/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.ThreadPoolConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.util.NoopShutdownScheduledExecutorService;
import io.smallrye.common.cpu.ProcessorInfo;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.jboss.logging.Logger;
import org.jboss.threads.ContextHandler;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadFactory;

@Recorder
public class ExecutorRecorder {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.thread-pool");
    private static volatile Executor current;
    private final RuntimeValue<ThreadPoolConfig> threadPoolConfig;

    public ExecutorRecorder(RuntimeValue<ThreadPoolConfig> threadPoolConfig) {
        this.threadPoolConfig = threadPoolConfig;
    }

    public ScheduledExecutorService setupRunTime(ShutdownContext shutdownContext, LaunchMode launchMode, ThreadFactory threadFactory, ContextHandler<Object> contextHandler) {
        final EnhancedQueueExecutor underlying = ExecutorRecorder.createExecutor(this.threadPoolConfig.getValue(), threadFactory, contextHandler);
        if (launchMode == LaunchMode.DEVELOPMENT) {
            shutdownContext.addLastShutdownTask(new Runnable(){

                @Override
                public void run() {
                    for (Runnable i : underlying.shutdownNow()) {
                        Thread thread = new Thread(i, "Shutdown task thread");
                        thread.setDaemon(true);
                        thread.start();
                    }
                    current = null;
                }
            });
        } else {
            Runnable shutdownTask = ExecutorRecorder.createShutdownTask(this.threadPoolConfig.getValue(), underlying);
            shutdownContext.addLastShutdownTask(shutdownTask);
        }
        if (this.threadPoolConfig.getValue().prefill()) {
            underlying.prestartAllCoreThreads();
        }
        Object managed = underlying;
        if (launchMode != LaunchMode.DEVELOPMENT) {
            managed = new NoopShutdownScheduledExecutorService((ScheduledExecutorService)underlying);
        }
        current = managed;
        return managed;
    }

    private static Runnable createShutdownTask(final ThreadPoolConfig threadPoolConfig, final EnhancedQueueExecutor executor) {
        return new Runnable(){

            @Override
            public void run() {
                long interval;
                executor.shutdown();
                Duration shutdownTimeout = threadPoolConfig.shutdownTimeout();
                Optional<Duration> optionalInterval = threadPoolConfig.shutdownCheckInterval();
                long remaining = shutdownTimeout.toNanos();
                long intervalRemaining = interval = optionalInterval.orElse(Duration.ofNanos(Long.MAX_VALUE)).toNanos();
                long interruptRemaining = threadPoolConfig.shutdownInterrupt().toNanos();
                long start = System.nanoTime();
                int loop = 1;
                while (true) {
                    log.debugf("loop: %s, remaining: %s, intervalRemaining: %s, interruptRemaining: %s", new Object[]{loop++, remaining, intervalRemaining, interruptRemaining});
                    try {
                        if (!executor.awaitTermination(Math.min(remaining, intervalRemaining), TimeUnit.NANOSECONDS)) {
                            long elapsed = System.nanoTime() - start;
                            intervalRemaining -= elapsed;
                            remaining -= elapsed;
                            if ((interruptRemaining -= elapsed) <= 0L) {
                                executor.shutdown(true);
                            }
                            if (remaining <= 0L) {
                                List runnables = executor.shutdownNow();
                                if (!runnables.isEmpty()) {
                                    log.warnf("Thread pool shutdown failed: discarding %d tasks, %d threads still running", (Object)runnables.size(), (Object)executor.getActiveCount());
                                } else {
                                    log.warnf("Thread pool shutdown failed: %d threads still running", (Object)executor.getActiveCount());
                                }
                            } else {
                                if (intervalRemaining > 0L) continue;
                                intervalRemaining = interval;
                                int queueSize = executor.getQueueSize();
                                Thread[] runningThreads = executor.getRunningThreads();
                                if (queueSize <= 0) {
                                    log.infof("Awaiting thread pool shutdown; %d thread(s) running", (Object)runningThreads.length);
                                } else {
                                    log.infof("Awaiting thread pool shutdown; %d thread(s) running with %d task(s) waiting", (Object)runningThreads.length, (Object)queueSize);
                                }
                                int realWaiting = runningThreads.length;
                                block3: for (Thread thr : runningThreads) {
                                    StackTraceElement[] stackTrace = thr.getStackTrace();
                                    for (int i = 0; i < stackTrace.length && i < 8; ++i) {
                                        if (!stackTrace[i].getClassName().equals("java.lang.System") || !stackTrace[i].getMethodName().equals("exit")) continue;
                                        Throwable t = new Throwable();
                                        t.setStackTrace(stackTrace);
                                        log.errorf(t, "Thread %s is blocked in System.exit(); pooled (Executor) threads should never call this method because it never returns, thus preventing the thread pool from shutting down in a timely manner.  This is the stack trace of the call", (Object)thr.getName());
                                        --realWaiting;
                                        continue block3;
                                    }
                                }
                                if (realWaiting != 0) continue;
                                executor.shutdownNow();
                            }
                            break;
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
    }

    private static EnhancedQueueExecutor createExecutor(ThreadPoolConfig threadPoolConfig, ThreadFactory threadFactory, ContextHandler<Object> contextHandler) {
        if (threadFactory == null) {
            threadFactory = new JBossThreadFactory(new ThreadGroup("executor"), Boolean.TRUE, null, "executor-thread-%t", JBossExecutors.loggingExceptionHandler((String)"org.jboss.executor.uncaught"), null);
        }
        EnhancedQueueExecutor.Builder builder = new EnhancedQueueExecutor.Builder().setRegisterMBean(false).setHandoffExecutor(JBossExecutors.rejectingExecutor()).setThreadFactory(JBossExecutors.resettingThreadFactory((ThreadFactory)threadFactory));
        builder.setCorePoolSize(threadPoolConfig.coreThreads());
        builder.setMaximumPoolSize(ExecutorRecorder.getMaxSize(threadPoolConfig));
        if (threadPoolConfig.queueSize().isPresent()) {
            if (threadPoolConfig.queueSize().getAsInt() < 0) {
                builder.setMaximumQueueSize(Integer.MAX_VALUE);
                builder.setQueueLimited(false);
            } else {
                builder.setMaximumQueueSize(threadPoolConfig.queueSize().getAsInt());
            }
        } else {
            builder.setQueueLimited(false);
        }
        builder.setGrowthResistance(threadPoolConfig.growthResistance());
        builder.setKeepAliveTime(threadPoolConfig.keepAliveTime());
        if (contextHandler != null) {
            builder.setContextHandler(contextHandler);
        }
        return builder.build();
    }

    public static int getMaxSize(ThreadPoolConfig threadPoolConfig) {
        return threadPoolConfig.maxThreads().orElseGet(MaxThreadsCalculator.INSTANCE);
    }

    public static int calculateMaxThreads() {
        return MaxThreadsCalculator.INSTANCE.getAsInt();
    }

    public static Executor getCurrent() {
        return current;
    }

    private static final class MaxThreadsCalculator
    implements IntSupplier {
        private static final MaxThreadsCalculator INSTANCE = new MaxThreadsCalculator();

        private MaxThreadsCalculator() {
        }

        @Override
        public int getAsInt() {
            return Holder.CALCULATION;
        }

        private static class Holder {
            private static final int DEFAULT_MAX_THREADS = 200;
            private static final int CALCULATION = Math.max(8 * ProcessorInfo.availableProcessors(), 200);

            private Holder() {
            }
        }
    }
}

