/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement.placement;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.MapViewPositionAndRotation;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;

public class CompletelyInsideAreaStrategy
implements PositionForAreaStrategy {
    public static final CompletelyInsideAreaStrategy INSTANCE = new CompletelyInsideAreaStrategy(0.0, 0.0);
    protected final double offsetX;
    protected final double offsetY;

    protected CompletelyInsideAreaStrategy(double offsetX, double offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    @Override
    public MapViewPositionAndRotation findLabelPlacement(MapViewPath path, Rectangle2D nb) {
        Rectangle[] candidates;
        int nbh;
        int nbw;
        double h;
        int y2;
        Rectangle pb = path.getBounds();
        if ((double)pb.width < nb.getWidth() || (double)pb.height < nb.getHeight()) {
            return null;
        }
        double w = (double)pb.width - nb.getWidth();
        int x2 = pb.x + (int)(w / 2.0);
        Rectangle centeredNBounds = new Rectangle(x2, y2 = pb.y + (int)((h = (double)pb.height - nb.getHeight()) / 2.0), nbw = (int)nb.getWidth(), nbh = (int)nb.getHeight());
        if (path.contains(centeredNBounds)) {
            return this.centerOf(path.getMapViewState(), centeredNBounds);
        }
        int x1 = pb.x + (int)(0.25 * w);
        int x3 = pb.x + (int)(0.75 * w);
        int y1 = pb.y + (int)(0.25 * h);
        int y3 = pb.y + (int)(0.75 * h);
        for (Rectangle candidate : candidates = new Rectangle[]{new Rectangle(x2, y1, nbw, nbh), new Rectangle(x3, y2, nbw, nbh), new Rectangle(x2, y3, nbw, nbh), new Rectangle(x1, y2, nbw, nbh), new Rectangle(x1, y1, nbw, nbh), new Rectangle(x3, y1, nbw, nbh), new Rectangle(x3, y3, nbw, nbh), new Rectangle(x1, y3, nbw, nbh)}) {
            if (!path.contains(candidate)) continue;
            return this.centerOf(path.getMapViewState(), candidate);
        }
        return null;
    }

    private MapViewPositionAndRotation centerOf(MapViewState mapViewState, Rectangle centeredNBounds) {
        double x = centeredNBounds.getCenterX() + this.offsetX;
        double y = centeredNBounds.getCenterY() + this.offsetY;
        return new MapViewPositionAndRotation(mapViewState.getForView(x, y), 0.0);
    }

    @Override
    public boolean supportsGlyphVector() {
        return false;
    }

    @Override
    public PositionForAreaStrategy withAddedOffset(Point2D addToOffset) {
        if (Math.abs(addToOffset.getX()) < 1.0E-5 && Math.abs(addToOffset.getY()) < 1.0E-5) {
            return this;
        }
        return new CompletelyInsideAreaStrategy(this.offsetX + addToOffset.getX(), this.offsetY - addToOffset.getY());
    }

    public String toString() {
        return "CompletelyInsideAreaStrategy [offsetX=" + this.offsetX + ", offsetY=" + this.offsetY + "]";
    }

    public int hashCode() {
        return Objects.hash(this.offsetX, this.offsetY);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompletelyInsideAreaStrategy other = (CompletelyInsideAreaStrategy)obj;
        return Double.doubleToLongBits(this.offsetX) == Double.doubleToLongBits(other.offsetX) && Double.doubleToLongBits(this.offsetY) == Double.doubleToLongBits(other.offsetY);
    }
}

