/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Enhance M-dimensional objects in N-dimensional images.


This filter is a generalization of Frangi's vesselness measurement for
detecting M-dimensional object in N-dimensional space. For example a
vessel is a 1-D object in 3-D space. The filter can enhance blob-like
structures (M=0), vessel-like structures (M=1), 2D plate-like
structures (M=2), hyper-plate-like structures (M=3) in N-dimensional
images, with M&lt;N.

This filter takes a scalar image as input and produces a real valued
image as output which contains the objectness measure at each pixel.
Internally, it computes a Hessian via discrete central differences.
Before applying this filter it is expected that a Gaussian smoothing
filter at an appropriate scale (sigma) was applied to the input image.

The enhancement is based on the eigenvalues of the Hessian matrix. For
the Frangi's vesselness case were M=1 and N=3 we have the 3
eigenvalues such that $ | \\lambda_1 | &lt; | \\lambda_2 | &lt; |\\lambda_3 | $ . The formula follows:

\\[ R_A = \\frac{|\\lambda_2|}{|\\lambda_3|}, \\; R_B =
\\frac{|\\lambda_2|}{|\\lambda_2\\lambda_3|}, \\; S =
\\sqrt{\\lambda_1^2+\\lambda_2^2+\\lambda_3^2} \\] \\[ V_{\\sigma}= \\begin{cases}
(1-e^{-\\frac{R_A^2}{2\\alpha^2}}) \\cdot
e^{\\frac{R_B^2}{2\\beta^2}} \\cdot
(1-e^{-\\frac{S^2}{2\\gamma^2}}) &amp; \\text{if }
\\lambda_2&lt;0 \\text{ and } \\lambda_3&lt;0
\\text{,}\\\\ 0 &amp; \\text{otherwise} \\end{cases} \\]

References
Antiga, L. Generalizing vesselness with respect to dimensionality and
shape. https://hdl.handle.net/1926/576

Frangi, AF, Niessen, WJ, Vincken, KL, &amp; Viergever, MA (1998).
Multiscale Vessel Enhancement Filtering. In Wells, WM, Colchester, A,
&amp; Delp, S, Editors, MICCAI '98 Medical Image Computing and Computer-Assisted Intervention, Lecture Notes in
Computer Science, pages 130-137, Springer Verlag, 1998.

See:
 itk::HessianToObjectnessMeasureImageFilter

 itk::simple::ObjectnessMeasure for the procedural interface

 itk::ObjectnessMeasureImageFilter for the Doxygen on the original ITK
class.


C++ includes: sitkObjectnessMeasureImageFilter.h
*/
public class ObjectnessMeasureImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ObjectnessMeasureImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ObjectnessMeasureImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ObjectnessMeasureImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ObjectnessMeasureImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ObjectnessMeasureImageFilter::~ObjectnessMeasureImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ObjectnessMeasureImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ObjectnessMeasureImageFilter::ObjectnessMeasureImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ObjectnessMeasureImageFilter() {
    this(SimpleITKJNI.new_ObjectnessMeasureImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ObjectnessMeasureImageFilter::SetAlpha(double Alpha)

Set/Get Alpha, the weight corresponding to R_A (the ratio of the
smallest eigenvalue that has to be large to the larger ones). Smaller
values lead to increased sensitivity to the object dimensionality.

*/
public  void setAlpha(double Alpha) {
    SimpleITKJNI.ObjectnessMeasureImageFilter_setAlpha(swigCPtr, this, Alpha);
  }

  /**
double itk::simple::ObjectnessMeasureImageFilter::GetAlpha() const

Set/Get Alpha, the weight corresponding to R_A (the ratio of the
smallest eigenvalue that has to be large to the larger ones). Smaller
values lead to increased sensitivity to the object dimensionality.

*/
public  double getAlpha() {
    return SimpleITKJNI.ObjectnessMeasureImageFilter_getAlpha(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ObjectnessMeasureImageFilter::SetBeta(double Beta)

Set/Get Beta, the weight corresponding to R_B (the ratio of the
largest eigenvalue that has to be small to the larger ones). Smaller
values lead to increased sensitivity to the object dimensionality.

*/
public  void setBeta(double Beta) {
    SimpleITKJNI.ObjectnessMeasureImageFilter_setBeta(swigCPtr, this, Beta);
  }

  /**
double itk::simple::ObjectnessMeasureImageFilter::GetBeta() const

Set/Get Beta, the weight corresponding to R_B (the ratio of the
largest eigenvalue that has to be small to the larger ones). Smaller
values lead to increased sensitivity to the object dimensionality.

*/
public  double getBeta() {
    return SimpleITKJNI.ObjectnessMeasureImageFilter_getBeta(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ObjectnessMeasureImageFilter::SetGamma(double Gamma)

Set/Get Gamma, the weight corresponding to S (the Frobenius norm of
the Hessian matrix, or second-order structureness)

*/
public  void setGamma(double Gamma) {
    SimpleITKJNI.ObjectnessMeasureImageFilter_setGamma(swigCPtr, this, Gamma);
  }

  /**
double itk::simple::ObjectnessMeasureImageFilter::GetGamma() const

Set/Get Gamma, the weight corresponding to S (the Frobenius norm of
the Hessian matrix, or second-order structureness)

*/
public  double getGamma() {
    return SimpleITKJNI.ObjectnessMeasureImageFilter_getGamma(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ObjectnessMeasureImageFilter::SetScaleObjectnessMeasure(bool ScaleObjectnessMeasure)

Toggle scaling the objectness measure with the magnitude of the
largest absolute eigenvalue

*/
public  void setScaleObjectnessMeasure(boolean ScaleObjectnessMeasure) {
    SimpleITKJNI.ObjectnessMeasureImageFilter_setScaleObjectnessMeasure(swigCPtr, this, ScaleObjectnessMeasure);
  }

  /**
Self&amp; itk::simple::ObjectnessMeasureImageFilter::ScaleObjectnessMeasureOn()

Set the value of ScaleObjectnessMeasure to true or false respectfully.

*/
public  void scaleObjectnessMeasureOn() {
    SimpleITKJNI.ObjectnessMeasureImageFilter_scaleObjectnessMeasureOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ObjectnessMeasureImageFilter::ScaleObjectnessMeasureOff()
*/
public  void scaleObjectnessMeasureOff() {
    SimpleITKJNI.ObjectnessMeasureImageFilter_scaleObjectnessMeasureOff(swigCPtr, this);
  }

  /**
bool itk::simple::ObjectnessMeasureImageFilter::GetScaleObjectnessMeasure() const

Toggle scaling the objectness measure with the magnitude of the
largest absolute eigenvalue

*/
public  boolean getScaleObjectnessMeasure() {
    return SimpleITKJNI.ObjectnessMeasureImageFilter_getScaleObjectnessMeasure(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ObjectnessMeasureImageFilter::SetObjectDimension(unsigned int ObjectDimension)

Set/Get the dimensionality of the object (0: points (blobs), 1: lines
(vessels), 2: planes (plate-like structures), 3: hyper-planes.
ObjectDimension must be smaller than ImageDimension.

*/
public  void setObjectDimension(long ObjectDimension) {
    SimpleITKJNI.ObjectnessMeasureImageFilter_setObjectDimension(swigCPtr, this, ObjectDimension);
  }

  /**
unsigned int itk::simple::ObjectnessMeasureImageFilter::GetObjectDimension() const

Set/Get the dimensionality of the object (0: points (blobs), 1: lines
(vessels), 2: planes (plate-like structures), 3: hyper-planes.
ObjectDimension must be smaller than ImageDimension.

*/
public  long getObjectDimension() {
    return SimpleITKJNI.ObjectnessMeasureImageFilter_getObjectDimension(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ObjectnessMeasureImageFilter::SetBrightObject(bool BrightObject)

Enhance bright structures on a dark background if true, the opposite
if false.

*/
public  void setBrightObject(boolean BrightObject) {
    SimpleITKJNI.ObjectnessMeasureImageFilter_setBrightObject(swigCPtr, this, BrightObject);
  }

  /**
Self&amp; itk::simple::ObjectnessMeasureImageFilter::BrightObjectOn()

Set the value of BrightObject to true or false respectfully.

*/
public  void brightObjectOn() {
    SimpleITKJNI.ObjectnessMeasureImageFilter_brightObjectOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ObjectnessMeasureImageFilter::BrightObjectOff()
*/
public  void brightObjectOff() {
    SimpleITKJNI.ObjectnessMeasureImageFilter_brightObjectOff(swigCPtr, this);
  }

  /**
bool itk::simple::ObjectnessMeasureImageFilter::GetBrightObject() const

Enhance bright structures on a dark background if true, the opposite
if false.

*/
public  boolean getBrightObject() {
    return SimpleITKJNI.ObjectnessMeasureImageFilter_getBrightObject(swigCPtr, this);
  }

  /**
std::string itk::simple::ObjectnessMeasureImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ObjectnessMeasureImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ObjectnessMeasureImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ObjectnessMeasureImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ObjectnessMeasureImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ObjectnessMeasureImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
