/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Suppress local maxima whose height above the baseline is less than h.


HMaximaImageFilter suppresses local maxima that are less than h intensity units above
the (local) background. This has the effect of smoothing over the
"high" parts of the noise in the image without smoothing over large
changes in intensity (region boundaries). See the HMinimaImageFilter to suppress the local minima whose depth is less than h intensity
units below the (local) background.

If the output of HMaximaImageFilter is subtracted from the original image, the significant "peaks" in
the image can be identified. This is what the HConvexImageFilter provides.

This filter uses the ReconstructionByDilationImageFilter . It provides its own input as the "mask" input to the geodesic
dilation. The "marker" image for the geodesic dilation is the input
image minus the height parameter h.

Geodesic morphology and the H-Maxima algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.

The height parameter is set using SetHeight.


See:
 ReconstructionByDilationImageFilter , HMinimaImageFilter , HConvexImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::HMaxima for the procedural interface

 itk::HMaximaImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHMaximaImageFilter.h
*/
public class HMaximaImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected HMaximaImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.HMaximaImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(HMaximaImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(HMaximaImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::HMaximaImageFilter::~HMaximaImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_HMaximaImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::HMaximaImageFilter::HMaximaImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  HMaximaImageFilter() {
    this(SimpleITKJNI.new_HMaximaImageFilter(), true);
  }

  /**
Self&amp; itk::simple::HMaximaImageFilter::SetHeight(double Height)

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public  void setHeight(double Height) {
    SimpleITKJNI.HMaximaImageFilter_setHeight(swigCPtr, this, Height);
  }

  /**
double itk::simple::HMaximaImageFilter::GetHeight() const

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public  double getHeight() {
    return SimpleITKJNI.HMaximaImageFilter_getHeight(swigCPtr, this);
  }

  /**
std::string itk::simple::HMaximaImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.HMaximaImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::HMaximaImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.HMaximaImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::HMaximaImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.HMaximaImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
