/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorString
extends AbstractList<String>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorString(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorString vectorString) {
        return vectorString == null ? 0L : vectorString.swigCPtr;
    }

    protected static long swigRelease(VectorString vectorString) {
        long l = 0L;
        if (vectorString != null) {
            if (!vectorString.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorString.swigCPtr;
            vectorString.swigCMemOwn = false;
            vectorString.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorString(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorString(String[] stringArray) {
        this();
        this.reserve(stringArray.length);
        for (String string : stringArray) {
            this.add(string);
        }
    }

    public VectorString(Iterable<String> iterable) {
        this();
        for (String string : iterable) {
            this.add(string);
        }
    }

    @Override
    public String get(int n) {
        return this.doGet(n);
    }

    @Override
    public String set(int n, String string) {
        return this.doSet(n, string);
    }

    @Override
    public boolean add(String string) {
        ++this.modCount;
        this.doAdd(string);
        return true;
    }

    @Override
    public void add(int n, String string) {
        ++this.modCount;
        this.doAdd(n, string);
    }

    @Override
    public String remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorString() {
        this(SimpleITKJNI.new_VectorString__SWIG_0(), true);
    }

    public VectorString(VectorString vectorString) {
        this(SimpleITKJNI.new_VectorString__SWIG_1(VectorString.getCPtr(vectorString), vectorString), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorString_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorString_clear(this.swigCPtr, this);
    }

    public VectorString(int n, String string) {
        this(SimpleITKJNI.new_VectorString__SWIG_2(n, string), true);
    }

    private int doCapacity() {
        return SimpleITKJNI.VectorString_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        SimpleITKJNI.VectorString_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return SimpleITKJNI.VectorString_doSize(this.swigCPtr, this);
    }

    private void doAdd(String string) {
        SimpleITKJNI.VectorString_doAdd__SWIG_0(this.swigCPtr, this, string);
    }

    private void doAdd(int n, String string) {
        SimpleITKJNI.VectorString_doAdd__SWIG_1(this.swigCPtr, this, n, string);
    }

    private String doRemove(int n) {
        return SimpleITKJNI.VectorString_doRemove(this.swigCPtr, this, n);
    }

    private String doGet(int n) {
        return SimpleITKJNI.VectorString_doGet(this.swigCPtr, this, n);
    }

    private String doSet(int n, String string) {
        return SimpleITKJNI.VectorString_doSet(this.swigCPtr, this, n, string);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorString_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

