#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.42.2
visibility:           public
id:                   hledger-web-1.42.2-DhZeHUHImkx4N7eKCCcMHH
key:                  hledger-web-1.42.2-DhZeHUHImkx4N7eKCCcMHH
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  af3eca3e489d5111188436811cc41583
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.42.2-DhZeHUHImkx4N7eKCCcMHH
depends:
    Decimal-0.5.2-2euKSIaxOiRDecL8O37p6o
    aeson-2.1.2.1-1NeIvw5bSkQ9apxHmCtPBl base-4.17.2.1
    base-compat-0.14.1-EDnSvJBeGTDBBfh2KFPKKz
    base64-1.0-9PbHP43d07k3pUrKC2TXRS
    blaze-html-0.9.2.0-LjI88QSzeg6Du3gTHOTwfP
    blaze-markup-0.8.3.0-3LhydqQBevSLPC64eL272u bytestring-0.11.5.3
    case-insensitive-1.2.1.0-2s4OeiMO3UWBaQwGHjklqk
    clientsession-0.9.3.0-Bvj6NO23QMQLDETJUN1xIK
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-H9ptnXIhOG68WzIJmqszIZ
    conduit-extra-1.3.8-7ttM5DDZKxD2zpAgGtSIY1 containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-FVFc4gt4avs4Z4Fwytd6v6 filepath-1.4.2.2
    githash-0.1.6.3-2yW9KwVpOZo9zEtht9Hsdo
    hjsmin-0.2.1-EHH5rSeSGUZDFm7eM2uQDL
    hledger-1.42.2-9fkHdzzRg3N4UG6Fepj08o
    hledger-lib-1.42.2-EpBy2Ogjb7NJHzSrbVjXPG
    hspec-2.11.2-LoCWuRZ7Zs25PpiBaqPRLG
    http-client-0.7.19-1UbHkZcsz6aHaInIJtT6mf
    http-conduit-2.3.9.1-EInXfbQedhu9pZKI9sPoBO
    http-types-0.12.4-7uecRhjtUnyHbQI0kDNqA2
    megaparsec-9.7.0-L0csM5p3V1T7HhcnanYAK3 mtl-2.2.2
    network-3.1.4.0-GAyMeTMiQBM1z6BFq5KYYA
    safe-0.3.21-3kF9VX2rOl78iX2OdZTXNo
    shakespeare-2.1.4-12KGltIXcNwBcFqw7XKmJb template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-4uh2N5X0qi8J6n5m3thcXg
    unordered-containers-0.2.20-1s4f8pAJmee27mGfYrIk99
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-LNQZLvP4BwI5qoFlUqY1xm
    wai-cors-0.2.7-8lYJG8YnxZI40y2OnOQsJ9
    wai-extra-3.1.18-7bvLIwAWq5cJ3TQu8PVPer
    wai-handler-launch-3.0.3.1-65MCgSeY8tRLUOwgYManZ7
    warp-3.3.31-5qZQWM2cWaK3toUW3gwoef
    yaml-0.11.11.2-5x6tKIpIM1V62IqZqeedIR
    yesod-1.6.2.1-Cj0Lrxavx118qbxGhUDaDU
    yesod-core-1.6.27.1-DA3EvKtXvPES36WHgVUP0
    yesod-form-1.7.9-7QLppi9ofk1KUHjVkVeByD
    yesod-static-1.6.1.0-L70SsNUZnc09QwRsyLNjZc
    yesod-test-1.6.23-CD5ChYB3xgeG9V21o46MvC

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

