#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-42UGS3KZiLxjC1aCzMRMc
key:                  hOpenPGP-2.10.1-42UGS3KZiLxjC1aCzMRMc
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  94cde4595588978376ad01ff445f652f
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-42UGS3KZiLxjC1aCzMRMc
depends:
    aeson-2.1.2.1-Kx5U0b11hXDAcrJPuBeHuf
    asn1-encoding-0.9.6-J3G4DVOCN1NI2ZtRoKVMDc
    attoparsec-0.14.4-4eygFQtTMUIB0P0RxBrkGo base-4.17.2.1
    base16-bytestring-1.0.2.0-KXYtISPPGuc1jDx46dDwiE
    bifunctors-5.6.2-KlFn0b1gGYdHH1u2NLmQKu binary-0.8.9.1
    binary-conduit-1.3.1-HZ1tHTrGErlBogP2zqi6jk bytestring-0.11.5.3
    bz2-1.0.1.1-3RZWX0mwUvtBwxXiLCagmF
    conduit-1.3.6.1-3OoOkivWqZS7dcQwoEFiHk
    conduit-extra-1.3.8-BJDq9IUY40K5dXgPcvjS82 containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.3-KZIm3vPrVCyIrlyoRaXpFj
    errors-2.3.0-WT3TbPjIBLAQ0vtipnCl1
    hashable-1.4.6.0-2hEv5lQFD6LEJdTUNcXkaI
    incremental-parser-0.5.1-CWIqmJ9a9NQ3ppJsyvTwY8
    ixset-typed-0.5.1.0-3hZdy1mINzR7rmdgFBmtX4
    lens-5.3.2-LURSnBuXCqTHeh00mrfrRc
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-JKWvmQYUpUN61cz8IfYdaz
    openpgp-asciiarmor-0.1.2-9rrV2f9lVpT7PzArfXD67N
    prettyprinter-1.7.1-KzM58U4JCdzBv7NnMyEr6Q
    resourcet-1.2.6-DmwxA4NFPQTJ3BdeBVaPkm
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Jnp6Xrk1NDm4qrPXFyeyaF
    zlib-0.7.0.0-CRqYHirV4cyFsC2akuoUKz

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

