#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   gi-cairo-render
version:                0.1.2
visibility:             public
id:                     gi-cairo-render-0.1.2-4dKAi4eVfTh6lp7pPRrOSR
key:                    gi-cairo-render-0.1.2-4dKAi4eVfTh6lp7pPRrOSR
license:                BSD-3-Clause
copyright:
    (c) 2018 Kilian Kilger, (c) 2001-2010 The Gtk2Hs Team, (c) Paolo Martini 2005, (c) Abraham Egnor 2003, 2004, (c) Aetion Technologies LLC 2004

maintainer:             Kilian Kilger (kkilger@gmail.com)
author:                 Axel Simon, Duncan Coutts
stability:              experimental
homepage:               https://github.com/cohomology/gi-cairo-render
synopsis:               GI friendly Binding to the Cairo library.
description:
    Cairo is a library to render high quality vector graphics. There
    exist various backends that allows rendering to Gtk windows, PDF,
    PS, PNG and SVG documents, amongst others.

category:               Graphics
abi:                    a4d3aa3afecc8e043b8b70fbf5d47003
exposed:                True
exposed-modules:
    GI.Cairo.Render GI.Cairo.Render.Internal GI.Cairo.Render.Matrix
    GI.Cairo.Render.Types

hidden-modules:
    GI.Cairo.Render.Internal.Drawing.Cairo
    GI.Cairo.Render.Internal.Drawing.Paths
    GI.Cairo.Render.Internal.Drawing.Patterns
    GI.Cairo.Render.Internal.Drawing.Text
    GI.Cairo.Render.Internal.Drawing.Transformations
    GI.Cairo.Render.Internal.Fonts.FontOptions
    GI.Cairo.Render.Internal.Surfaces.Image
    GI.Cairo.Render.Internal.Surfaces.PNG
    GI.Cairo.Render.Internal.Surfaces.Surface
    GI.Cairo.Render.Internal.Utilities
    GI.Cairo.Render.Internal.Surfaces.PDF
    GI.Cairo.Render.Internal.Surfaces.PS
    GI.Cairo.Render.Internal.Surfaces.SVG
    GI.Cairo.Render.Internal.Region

import-dirs:            /usr/lib/ghc-9.4.8/site-local/gi-cairo-render-0.1.2
library-dirs:           /usr/lib/ghc-9.4.8/site-local/gi-cairo-render-0.1.2
library-dirs-static:    /usr/lib/ghc-9.4.8/site-local/gi-cairo-render-0.1.2
dynamic-library-dirs:   /usr/lib
data-dir:               /usr/share/haskell-gi-cairo-render
hs-libraries:           HSgi-cairo-render-0.1.2-4dKAi4eVfTh6lp7pPRrOSR
extra-libraries:        cairo-gobject gobject-2.0 glib-2.0 cairo png16 z
extra-libraries-static:
    cairo-gobject m dl gobject-2.0 glib-2.0 m sysprof-capture-4 pcre2-8
    ffi cairo m dl fontconfig m expat m freetype dl bz2 brotlidec
    brotlicommon Xext Xrender X11 pthread xcb-render xcb-shm xcb Xau
    Xdmcp pixman-1 m png16 m m z

include-dirs:
    /usr/include/cairo /usr/include/glib-2.0 /usr/lib/glib-2.0/include
    /usr/include/sysprof-6 /usr/include/freetype2 /usr/include/pixman-1
    /usr/include/libpng16

depends:
    array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3
    haskell-gi-base-0.26.7-IKgSSFp3EiO52VN49Ye8zT mtl-2.2.2 text-2.0.2
    utf8-string-1.0.2-JqS4SAQdze6LQzXf6ug2xB

haddock-interfaces:
    /usr/share/doc/haskell-gi-cairo-render/html/gi-cairo-render.haddock

haddock-html:           /usr/share/doc/haskell-gi-cairo-render/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

