#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-23V5N0jNSYv5uKDmolrbRN
key:                  gitit-0.15.1.2-23V5N0jNSYv5uKDmolrbRN
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  3524307815c66966dc02ba58db420fd7
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-23V5N0jNSYv5uKDmolrbRN
depends:
    HStringTemplate-0.8.8-JtAdE0DGUU9B4uqWATIakD
    HTTP-4000.4.1-GGIoqdJ2gt4HkjOtIyENkn
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-Kx5U0b11hXDAcrJPuBeHuf base-4.17.2.1
    base64-bytestring-1.2.1.0-GswEt3eOHYLA64palw0j2S
    blaze-html-0.9.2.0-KhmoRG3R09V549Pilp7yk8 bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-DNxNyNIVV969ijZVNZuczh
    feed-1.3.2.1-5EX0EIZaZn7KZ2cUH5rF82 filepath-1.4.2.2
    filestore-0.6.5.1-LU9XhL6hlYl4rqgvJjXcFz ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-2dr7KXdy9qrBVUy8D71Ay7
    hoauth2-2.13.0-BReHmGuoZArIDoSMUbV3lT
    hslogger-1.3.2.0-HHnZePS3lQd6rnoeTbwVHs
    http-client-tls-0.3.6.4-CB4kSvmWkV2Ki3PB3JtnDL
    http-conduit-2.3.9.1-LdiFxavybru7fsar1aO4vs
    json-0.10-EAhbROZFA1Y6NpnTZgACjk mtl-2.2.2
    network-3.1.4.0-4cEUA9pnnvEEvGlZk2FqT
    network-bsd-2.8.1.0-L5HEmsOfUJdFzoiASssZR1
    network-uri-2.6.4.2-JKWvmQYUpUN61cz8IfYdaz
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.3-KP08aVOqQXNBKndQ1ndnJd
    pandoc-types-1.23.1-JLhoLlQviylHohrB3RWGpg parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-HJyMSutqwH8Lt2zSK2VrDO
    recaptcha-0.1.0.4-2Ny9VEINiVS30oyG0DWB2g
    safe-0.3.21-HlwzjIK5TiIKPzF0RtoFLn
    skylighting-0.14.3-LBzt5oYwi6nAfUzg1ZWrjJ
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-B3ujAx0b01UAjArJbq6cUd
    tagsoup-0.14.8-K7L5UoygLqE3cB1qyG2i7T
    temporary-1.3-4U3e01RislmEUeJgFruRX5 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-K2d51iZwEHC6jLmEzxWYsR
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-90yrZACQ3M49bh0zFpBEbk xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-3uUwAVag58SIuBpvKvM66W
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-HmD7VwAM0uFL1Tvt6pXqH
    zlib-0.7.0.0-CRqYHirV4cyFsC2akuoUKz

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

