/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.DeclarationCondition;
import io.sf.carte.doc.style.css.nsac.InputSource;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorFunction;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSCanvas;
import io.sf.carte.doc.style.css.om.AbstractStyleDatabase;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.om.Specificity;
import io.sf.carte.doc.style.css.parser.AttributeConditionVisitor;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.echosvg.css.CSSSecurityException;
import io.sf.carte.echosvg.css.engine.CSSCircularityException;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngineEvent;
import io.sf.carte.echosvg.css.engine.CSSEngineListener;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSNavigableDocument;
import io.sf.carte.echosvg.css.engine.CSSNavigableDocumentListener;
import io.sf.carte.echosvg.css.engine.CSSNavigableNode;
import io.sf.carte.echosvg.css.engine.CSSResourceLimitException;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.CSSStyleSheetNode;
import io.sf.carte.echosvg.css.engine.CounterRef;
import io.sf.carte.echosvg.css.engine.FontFaceRule;
import io.sf.carte.echosvg.css.engine.ImportRule;
import io.sf.carte.echosvg.css.engine.MediaRule;
import io.sf.carte.echosvg.css.engine.Messages;
import io.sf.carte.echosvg.css.engine.PropertyDefinitionImpl;
import io.sf.carte.echosvg.css.engine.Rule;
import io.sf.carte.echosvg.css.engine.SVGSelectorMatcher;
import io.sf.carte.echosvg.css.engine.StringIntMap;
import io.sf.carte.echosvg.css.engine.StyleDeclaration;
import io.sf.carte.echosvg.css.engine.StyleDeclarationProvider;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.StyleRule;
import io.sf.carte.echosvg.css.engine.StyleSheet;
import io.sf.carte.echosvg.css.engine.SupportsRule;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.ComputedValue;
import io.sf.carte.echosvg.css.engine.value.InheritValue;
import io.sf.carte.echosvg.css.engine.value.LexicalValue;
import io.sf.carte.echosvg.css.engine.value.PendingValue;
import io.sf.carte.echosvg.css.engine.value.PropertyDefinition;
import io.sf.carte.echosvg.css.engine.value.ShorthandManager;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class CSSEngine {
    protected CSSEngineUserAgent userAgent;
    protected CSSContext cssContext;
    private EngineStyleDatabase styleDb;
    private CSSCanvas csscanvas;
    protected Document document;
    protected ParsedURL documentURI;
    protected boolean isCSSNavigableDocument;
    protected StringIntMap indexes;
    protected StringIntMap shorthandIndexes;
    protected ValueManager[] valueManagers;
    protected ShorthandManager[] shorthandManagers;
    protected Parser parser;
    protected String[] pseudoElementNames;
    protected int fontSizeIndex = -1;
    protected int lineHeightIndex = -1;
    protected int colorIndex = -1;
    protected StyleSheet userAgentStyleSheet;
    protected StyleSheet userStyleSheet;
    private String medium;
    protected List<Node> styleSheetNodes;
    protected List<FontFaceRule> fontFaces = new LinkedList<FontFaceRule>();
    protected String styleNamespaceURI;
    protected String styleLocalName;
    protected String classNamespaceURI;
    protected String classLocalName;
    protected Set<String> nonCSSPresentationalHints;
    protected String nonCSSPresentationalHintsNamespaceURI;
    protected StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
    protected StyleDeclarationUpdateHandler styleDeclarationUpdateHandler;
    protected StyleSheetDocumentHandler styleSheetDocumentHandler = new StyleSheetDocumentHandler();
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    protected CSSStylableElement element;
    protected ParsedURL cssBaseURI;
    protected String alternateStyleSheet;
    protected CSSNavigableDocumentHandler cssNavigableDocumentListener;
    protected EventListener domAttrModifiedListener;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domSubtreeModifiedListener;
    protected EventListener domCharacterDataModifiedListener;
    protected boolean styleSheetRemoved;
    protected Node removedStylableElementSibling;
    protected List<CSSEngineListener> listeners = Collections.synchronizedList(new LinkedList());
    protected Set<String> selectorAttributes;
    private HashMap<String, PropertyDefinition> propertyDefinitionMap = null;
    private static final int INITIAL_CUSTOM_PTY_SET_SIZE = 1;
    protected final int[] ALL_PROPERTIES;
    protected static final CSSEngineListener[] LISTENER_ARRAY = new CSSEngineListener[0];

    public static Node getCSSParentNode(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSParentNode();
        }
        return node.getParentNode();
    }

    protected static Node getCSSFirstChild(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSFirstChild();
        }
        return node.getFirstChild();
    }

    protected static Node getCSSNextSibling(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSNextSibling();
        }
        return node.getNextSibling();
    }

    protected static Node getCSSPreviousSibling(Node node) {
        if (node instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)node)).getCSSPreviousSibling();
        }
        return node.getPreviousSibling();
    }

    public static CSSStylableElement getParentCSSStylableElement(Element element) {
        Node node = CSSEngine.getCSSParentNode(element);
        while (node != null) {
            if (node instanceof CSSStylableElement) {
                return (CSSStylableElement)node;
            }
            node = CSSEngine.getCSSParentNode(node);
        }
        return null;
    }

    protected CSSEngine(Document document, ParsedURL parsedURL, Parser parser, ValueManager[] valueManagerArray, ShorthandManager[] shorthandManagerArray, String[] stringArray, String string, String string2, String string3, String string4, boolean bl, String string5, CSSContext cSSContext) {
        String string6;
        int n;
        this.document = document;
        this.documentURI = parsedURL;
        this.parser = parser;
        this.pseudoElementNames = stringArray;
        this.styleNamespaceURI = string;
        this.styleLocalName = string2;
        this.classNamespaceURI = string3;
        this.classLocalName = string4;
        this.cssContext = cSSContext;
        this.styleDb = new EngineStyleDatabase();
        this.csscanvas = new EngineCSSCanvas();
        this.isCSSNavigableDocument = document instanceof CSSNavigableDocument;
        int n2 = valueManagerArray.length;
        this.indexes = new StringIntMap(n2);
        this.valueManagers = valueManagerArray;
        for (n = n2 - 1; n >= 0; --n) {
            string6 = valueManagerArray[n].getPropertyName();
            this.indexes.put(string6, n);
            if (this.fontSizeIndex == -1 && string6.equals("font-size")) {
                this.fontSizeIndex = n;
            }
            if (this.lineHeightIndex == -1 && string6.equals("line-height")) {
                this.lineHeightIndex = n;
            }
            if (this.colorIndex != -1 || !string6.equals("color")) continue;
            this.colorIndex = n;
        }
        n2 = shorthandManagerArray.length;
        this.shorthandIndexes = new StringIntMap(n2);
        this.shorthandManagers = shorthandManagerArray;
        for (n = n2 - 1; n >= 0; --n) {
            this.shorthandIndexes.put(shorthandManagerArray[n].getPropertyName(), n);
        }
        if (bl) {
            this.nonCSSPresentationalHints = new HashSet<String>(valueManagerArray.length + shorthandManagerArray.length);
            this.nonCSSPresentationalHintsNamespaceURI = string5;
            n2 = valueManagerArray.length;
            for (n = 0; n < n2; ++n) {
                string6 = valueManagerArray[n].getPropertyName();
                this.nonCSSPresentationalHints.add(string6);
            }
            n2 = shorthandManagerArray.length;
            for (n = 0; n < n2; ++n) {
                string6 = shorthandManagerArray[n].getPropertyName();
                this.nonCSSPresentationalHints.add(string6);
            }
        }
        if (this.cssContext.isDynamic() && this.document instanceof EventTarget) {
            this.addEventListeners((EventTarget)((Object)this.document));
            this.styleDeclarationUpdateHandler = new StyleDeclarationUpdateHandler();
        }
        this.ALL_PROPERTIES = new int[this.getNumberOfProperties()];
        for (n = this.getNumberOfProperties() - 1; n >= 0; --n) {
            this.ALL_PROPERTIES[n] = n;
        }
    }

    protected void addEventListeners(EventTarget eventTarget) {
        if (this.isCSSNavigableDocument) {
            this.cssNavigableDocumentListener = new CSSNavigableDocumentHandler();
            CSSNavigableDocument cSSNavigableDocument = (CSSNavigableDocument)((Object)eventTarget);
            cSSNavigableDocument.addCSSNavigableDocumentListener(this.cssNavigableDocumentListener);
        } else {
            this.domAttrModifiedListener = new DOMAttrModifiedListener();
            eventTarget.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            this.domNodeInsertedListener = new DOMNodeInsertedListener();
            eventTarget.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            this.domNodeRemovedListener = new DOMNodeRemovedListener();
            eventTarget.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            this.domSubtreeModifiedListener = new DOMSubtreeModifiedListener();
            eventTarget.addEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
            eventTarget.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    protected void removeEventListeners(EventTarget eventTarget) {
        if (this.isCSSNavigableDocument) {
            CSSNavigableDocument cSSNavigableDocument = (CSSNavigableDocument)((Object)eventTarget);
            cSSNavigableDocument.removeCSSNavigableDocumentListener(this.cssNavigableDocumentListener);
        } else {
            eventTarget.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            eventTarget.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            eventTarget.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            eventTarget.removeEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            eventTarget.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    public void dispose() {
        this.setCSSEngineUserAgent(null);
        this.disposeStyleMaps(this.document.getDocumentElement());
        if (this.document instanceof EventTarget) {
            this.removeEventListeners((EventTarget)((Object)this.document));
        }
    }

    protected void disposeStyleMaps(Node node) {
        if (node instanceof CSSStylableElement) {
            ((CSSStylableElement)node).setComputedStyleMap(null, null);
        }
        Node node2 = CSSEngine.getCSSFirstChild(node);
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                this.disposeStyleMaps(node2);
            }
            node2 = CSSEngine.getCSSNextSibling(node2);
        }
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFontSizeIndex() {
        return this.fontSizeIndex;
    }

    public int getLineHeightIndex() {
        return this.lineHeightIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getNumberOfProperties() {
        return this.valueManagers.length;
    }

    public int getPropertyIndex(String string) {
        return this.indexes.get(string);
    }

    public int getShorthandIndex(String string) {
        return this.shorthandIndexes.get(string);
    }

    public String getPropertyName(int n) {
        return this.valueManagers[n].getPropertyName();
    }

    public void setCSSEngineUserAgent(CSSEngineUserAgent cSSEngineUserAgent) {
        this.userAgent = cSSEngineUserAgent;
    }

    public CSSEngineUserAgent getCSSEngineUserAgent() {
        return this.userAgent;
    }

    public void setUserAgentStyleSheet(StyleSheet styleSheet) {
        this.userAgentStyleSheet = styleSheet;
    }

    public void setUserStyleSheet(StyleSheet styleSheet) {
        this.userStyleSheet = styleSheet;
    }

    public ValueManager[] getValueManagers() {
        return this.valueManagers;
    }

    public ShorthandManager[] getShorthandManagers() {
        return this.shorthandManagers;
    }

    public List<FontFaceRule> getFontFaces() {
        return this.fontFaces;
    }

    public void setMedia(String string) {
        this.medium = string != null ? string.toLowerCase(Locale.ROOT) : null;
    }

    public void setAlternateStyleSheet(String string) {
        this.alternateStyleSheet = string;
    }

    public void importCascadedStyleMaps(Element element, CSSEngine cSSEngine, Element element2) {
        Node node;
        Node node2;
        if (element instanceof CSSStylableElement) {
            node2 = (CSSStylableElement)element;
            node = (CSSStylableElement)element2;
            StyleMap styleMap = cSSEngine.getCascadedStyleMap((CSSStylableElement)node2, null);
            styleMap.setFixedCascadedStyle(true);
            node.setComputedStyleMap(null, styleMap);
            if (this.pseudoElementNames != null) {
                for (String string : this.pseudoElementNames) {
                    styleMap = cSSEngine.getCascadedStyleMap((CSSStylableElement)node2, string);
                    node.setComputedStyleMap(string, styleMap);
                }
            }
        }
        node2 = CSSEngine.getCSSFirstChild(element2);
        node = CSSEngine.getCSSFirstChild(element);
        while (node2 != null) {
            if (node.getNodeType() == 1) {
                this.importCascadedStyleMaps((Element)node, cSSEngine, (Element)node2);
            }
            node2 = CSSEngine.getCSSNextSibling(node2);
            node = CSSEngine.getCSSNextSibling(node);
        }
    }

    public ParsedURL getCSSBaseURI() {
        if (this.cssBaseURI == null) {
            this.cssBaseURI = this.element.getCSSBase();
        }
        return this.cssBaseURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMap getCascadedStyleMap(CSSStylableElement cSSStylableElement, String string) {
        Object object;
        Object object2;
        int n = this.getNumberOfProperties();
        final StyleMap styleMap = new StyleMap(n);
        SVGSelectorMatcher sVGSelectorMatcher = new SVGSelectorMatcher(cSSStylableElement);
        if (string != null) {
            object2 = this.createCSSParser();
            object = object2.parsePseudoElement(string);
            sVGSelectorMatcher.setPseudoElement((Condition)object);
        }
        if (this.userAgentStyleSheet != null) {
            object2 = new ArrayList();
            this.addMatchingRules((List<Rule>)object2, this.userAgentStyleSheet, (SelectorMatcher)sVGSelectorMatcher);
            this.addRules((SelectorMatcher)sVGSelectorMatcher, styleMap, (ArrayList<Rule>)object2, 0);
        }
        if (this.userStyleSheet != null) {
            object2 = new ArrayList();
            this.addMatchingRules((List<Rule>)object2, this.userStyleSheet, (SelectorMatcher)sVGSelectorMatcher);
            this.addRules((SelectorMatcher)sVGSelectorMatcher, styleMap, (ArrayList<Rule>)object2, 0x20000000);
        }
        this.element = cSSStylableElement;
        try {
            StyleDeclarationProvider styleDeclarationProvider;
            String string2;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            int n2;
            if (this.nonCSSPresentationalHints != null) {
                object2 = new ShorthandManager.PropertyHandler(){

                    @Override
                    public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
                        int n = CSSEngine.this.getPropertyIndex(string);
                        if (n != -1) {
                            Value value;
                            ValueManager valueManager = CSSEngine.this.valueManagers[n];
                            try {
                                value = valueManager.createValue(lexicalUnit, CSSEngine.this);
                            }
                            catch (CSSProxyValueException cSSProxyValueException) {
                                value = new LexicalValue(lexicalUnit);
                            }
                            CSSEngine.this.putAuthorProperty(styleMap, n, value, bl, 0x40000000);
                            return;
                        }
                        n = CSSEngine.this.getShorthandIndex(string);
                        if (n == -1) {
                            return;
                        }
                        CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
                    }

                    @Override
                    public void pendingValue(String string, PendingValue pendingValue, boolean bl) {
                        int n = CSSEngine.this.getPropertyIndex(string);
                        if (n != -1) {
                            CSSEngine.this.putAuthorProperty(styleMap, n, pendingValue, bl, 0x40000000);
                        }
                    }
                };
                object = cSSStylableElement.getAttributes();
                n2 = object.getLength();
                for (int i = 0; i < n2; ++i) {
                    object7 = object.item(i);
                    object6 = object7.getNodeName();
                    if (!this.nonCSSPresentationalHints.contains(object6)) continue;
                    try {
                        object5 = this.parser.parsePropertyValue((Reader)new StringReader(object7.getNodeValue()));
                        object2.property((String)object6, (LexicalUnit)object5, false);
                        continue;
                    }
                    catch (Exception exception) {
                        object4 = exception.getMessage();
                        if (object4 == null) {
                            object4 = "";
                        }
                        String object32 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String string3 = Messages.formatMessage("property.syntax.error.at", new Object[]{object32, object6, object7.getNodeValue(), object4});
                        DOMException dOMException = new DOMException(12, string3);
                        dOMException.initCause(exception);
                        if (this.userAgent == null) {
                            throw dOMException;
                        }
                        this.userAgent.displayError(dOMException);
                    }
                }
            }
            if ((n2 = (object = ((CSSEngine)(object2 = this.cssContext.getCSSEngineForElement(cSSStylableElement))).getStyleSheetNodes()).size()) > 0) {
                ArrayList<Rule> arrayList = new ArrayList<Rule>();
                object7 = object.iterator();
                while (object7.hasNext()) {
                    object6 = (Node)object7.next();
                    object5 = (CSSStyleSheetNode)object6;
                    object4 = object5.getCSSStyleSheet();
                    if (object4 == null || ((StyleSheet)object4).isAlternate() && ((StyleSheet)object4).getTitle() != null && !((StyleSheet)object4).getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(((StyleSheet)object4).getMedia())) continue;
                    this.addMatchingRules(arrayList, (StyleSheet)object4, (SelectorMatcher)sVGSelectorMatcher);
                }
                this.addRules((SelectorMatcher)sVGSelectorMatcher, styleMap, arrayList, 0x60000000);
            }
            if (this.styleLocalName != null && (string2 = cSSStylableElement.getAttributeNS(this.styleNamespaceURI, this.styleLocalName)).length() > 0) {
                try {
                    this.styleDeclarationDocumentHandler.styleMap = styleMap;
                    this.parser.setDocumentHandler((CSSHandler)this.styleDeclarationDocumentHandler);
                    this.parser.parseStyleDeclaration((Reader)new StringReader(string2));
                    this.styleDeclarationDocumentHandler.styleMap = null;
                }
                catch (Exception exception) {
                    object6 = exception.getMessage();
                    if (object6 == null) {
                        object6 = exception.getClass().getName();
                    }
                    object5 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    object4 = Messages.formatMessage("style.syntax.error.at", new Object[]{object5, this.styleLocalName, string2, object6});
                    DOMException dOMException = new DOMException(12, (String)object4);
                    dOMException.initCause(exception);
                    if (this.userAgent == null) {
                        throw dOMException;
                    }
                    this.userAgent.displayError(dOMException);
                }
            }
            if ((styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider()) != null && (object7 = styleDeclarationProvider.getStyleDeclaration()) != null) {
                int n3 = ((StyleDeclaration)object7).size();
                for (int i = 0; i < n3; ++i) {
                    int n4 = ((StyleDeclaration)object7).getIndex(i);
                    Value value = ((StyleDeclaration)object7).getValue(i);
                    boolean bl = ((StyleDeclaration)object7).getPriority(i);
                    if (styleMap.isImportant(n4) && !bl) continue;
                    styleMap.putValue(n4, value);
                    styleMap.putImportant(n4, bl);
                    styleMap.putOrigin(n4, -1610612736);
                }
                Map<String, LexicalUnit> map = ((StyleDeclaration)object7).getCustomProperties();
                if (map != null) {
                    for (Map.Entry<String, LexicalUnit> entry : map.entrySet()) {
                        styleMap.putCustomProperty(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return styleMap;
    }

    private Parser createCSSParser() {
        return new CSSOMParser();
    }

    public Value getComputedStyle(CSSStylableElement cSSStylableElement, String string, int n) throws CSSSecurityException {
        Value value;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(string);
        if (styleMap == null) {
            styleMap = this.getCascadedStyleMap(cSSStylableElement, string);
            cSSStylableElement.setComputedStyleMap(string, styleMap);
        }
        Value value2 = styleMap.getValue(n);
        if (styleMap.isComputed(n)) {
            return value2;
        }
        Value value3 = value2;
        ValueManager valueManager = this.valueManagers[n];
        CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
        if (value2 == null) {
            if (cSSStylableElement2 == null || !valueManager.isInheritedProperty()) {
                value3 = valueManager.getDefaultValue();
            }
        } else if (value2.getPrimitiveType() == CSSValue.Type.LEXICAL) {
            value = (LexicalValue)value2;
            LexicalUnit lexicalUnit = this.replaceLexicalValue(styleMap, ((LexicalValue)value).getLexicalUnit(), cSSStylableElement, cSSStylableElement2, n);
            if (lexicalUnit != null) {
                value3 = valueManager.createValue(lexicalUnit, this);
                if (value3 == null || value3.getCssValueType() == CSSValue.CssType.KEYWORD) {
                    value3 = CSSEngine.initialOrNull(cSSStylableElement2 != null, valueManager, value3);
                }
            } else {
                value3 = CSSEngine.initialOrNull(cSSStylableElement2 != null, valueManager, null);
            }
        } else if (value2.getPrimitiveType() == CSSValue.Type.INTERNAL) {
            value = (PendingValue)value2;
            value3 = this.substitutePendingShorthand(styleMap, (PendingValue)value, cSSStylableElement, cSSStylableElement2, n) ? styleMap.getValue(n) : CSSEngine.initialOrNull(cSSStylableElement2 != null, valueManager, null);
        } else if (value2.getCssValueType() == CSSValue.CssType.KEYWORD) {
            value3 = CSSEngine.initialOrNull(cSSStylableElement2 != null, valueManager, value2);
        }
        if (value3 != null && (value3 = valueManager.computeValue(cSSStylableElement, string, this, n, styleMap, value3)) == null) {
            value3 = CSSEngine.initialOrNull(cSSStylableElement2 != null, valueManager, null);
        }
        if (value3 == null) {
            value3 = this.getComputedStyle(cSSStylableElement2, null, n);
            styleMap.putParentRelative(n, true);
            styleMap.putInherited(n, true);
        }
        if (value2 == null) {
            styleMap.putValue(n, value3);
            styleMap.putNullCascaded(n, true);
        } else if (value3 != value2) {
            value = new ComputedValue(value2);
            ((ComputedValue)value).setComputedValue(value3);
            styleMap.putValue(n, value);
            value3 = value;
        }
        styleMap.putComputed(n, true);
        return value3;
    }

    private static Value initialOrNull(boolean bl, ValueManager valueManager, Value value) {
        Value value2 = bl && (valueManager.isInheritedProperty() || value == InheritValue.getInstance()) ? null : valueManager.getDefaultValue();
        return value2;
    }

    private LexicalUnit replaceLexicalValue(StyleMap styleMap, LexicalUnit lexicalUnit, CSSStylableElement cSSStylableElement, CSSStylableElement cSSStylableElement2, int n) throws CSSSecurityException {
        LexicalUnit lexicalUnit2;
        HashSet<String> hashSet = new HashSet<String>(1);
        CounterRef counterRef = new CounterRef();
        LexicalUnit lexicalUnit3 = lexicalUnit.clone();
        try {
            lexicalUnit2 = this.replaceLexicalProxy(styleMap, lexicalUnit3, cSSStylableElement, cSSStylableElement2, counterRef, hashSet, n);
        }
        catch (CSSSecurityException cSSSecurityException) {
            throw cSSSecurityException;
        }
        catch (DOMException dOMException) {
            this.displayOrThrowError(dOMException);
            return null;
        }
        if (lexicalUnit2 != null && lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            lexicalUnit2 = null;
        }
        return lexicalUnit2;
    }

    private LexicalUnit replaceLexicalProxy(StyleMap styleMap, LexicalUnit object, CSSStylableElement cSSStylableElement, CSSStylableElement cSSStylableElement2, CounterRef counterRef, Set<String> set, int n) throws DOMException, CSSSecurityException {
        int n2 = 131072;
        Object object2 = object;
        block4: do {
            LexicalUnit lexicalUnit;
            String string;
            Object object3;
            if (object2.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                boolean bl;
                styleMap.putCustomPtyRelative(n, true);
                object3 = object2.getParameters();
                string = object3.getStringValue();
                object3 = object3.getNextLexicalUnit();
                if (object3 != null) {
                    object3 = object3.getNextLexicalUnit();
                }
                lexicalUnit = new HashSet(set.size() + 1);
                lexicalUnit.addAll(set);
                LexicalUnit lexicalUnit2 = this.getCustomPropertyValueOrFallback(styleMap, string, (LexicalUnit)object3, cSSStylableElement2, counterRef, (Set<String>)lexicalUnit);
                if (lexicalUnit2 != null) {
                    lexicalUnit2 = lexicalUnit2.clone();
                    lexicalUnit2 = this.replaceLexicalProxy(styleMap, lexicalUnit2, cSSStylableElement, cSSStylableElement2, counterRef, (Set<String>)lexicalUnit, n);
                }
                boolean bl2 = bl = object2 == object;
                if (lexicalUnit2 == null) {
                    object2 = object2.remove();
                    if (bl) {
                        object = object2;
                    }
                    lexicalUnit.remove(string);
                    continue;
                }
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.EMPTY) {
                    try {
                        counterRef.replaceCounter += object2.countReplaceBy(lexicalUnit2);
                    }
                    catch (CSSBudgetException cSSBudgetException) {
                        throw this.createVarResourceLimitException(string, cSSBudgetException);
                    }
                    if (counterRef.replaceCounter >= 131072) {
                        throw this.createVarResourceLimitException(string);
                    }
                    object2 = lexicalUnit2;
                    if (!bl) continue;
                    object = lexicalUnit2;
                    continue;
                }
                LexicalUnit lexicalUnit3 = object2.remove();
                object2 = lexicalUnit3 != null ? lexicalUnit3 : lexicalUnit2;
                if (bl) {
                    object = object2;
                }
                lexicalUnit.remove(string);
                continue;
            }
            if (object2.getLexicalUnitType() == LexicalUnit.LexicalType.ATTR) {
                boolean bl = object2 == object;
                object3 = new HashSet(set.size() + 1);
                object3.addAll(set);
                string = this.replacementAttrUnit(styleMap, (LexicalUnit)object2, cSSStylableElement, cSSStylableElement2, counterRef, (Set<String>)object3, n);
                if (string != null) {
                    string = this.replaceLexicalProxy(styleMap, (LexicalUnit)string, cSSStylableElement, cSSStylableElement2, counterRef, (Set<String>)object3, n);
                }
                if (string == null) {
                    object2 = object2.remove();
                    if (!bl) continue;
                    object = object2;
                    continue;
                }
                styleMap.putAttrTainted(n, true);
                while (string.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
                    lexicalUnit = string.remove();
                    if (lexicalUnit == null) {
                        if ((object2 = object2.remove()) == null) {
                            object2 = string;
                        }
                        if (!bl) continue block4;
                        object = object2;
                        continue block4;
                    }
                    string = lexicalUnit;
                }
                try {
                    counterRef.replaceCounter += object2.countReplaceBy((LexicalUnit)string);
                }
                catch (CSSBudgetException cSSBudgetException) {
                    throw this.createAttrResourceLimitException(cSSBudgetException);
                }
                if (counterRef.replaceCounter >= 131072) {
                    throw this.createAttrResourceLimitException();
                }
                object2 = string;
                if (!bl) continue;
                object = string;
                continue;
            }
            LexicalUnit lexicalUnit4 = object2.getParameters();
            if (lexicalUnit4 != null || (lexicalUnit4 = object2.getSubValues()) != null) {
                this.replaceLexicalProxy(styleMap, lexicalUnit4, cSSStylableElement, cSSStylableElement2, counterRef, set, n);
            }
            object2 = object2.getNextLexicalUnit();
        } while (object2 != null);
        return object;
    }

    private LexicalUnit replacementAttrUnit(StyleMap styleMap, LexicalUnit lexicalUnit, CSSStylableElement cSSStylableElement, CSSStylableElement cSSStylableElement2, CounterRef counterRef, Set<String> set, int n) {
        String string;
        Object object;
        LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
        if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
            this.valueSyntaxError("Unexpected attribute name (" + lexicalUnit2.getCssText() + ") in " + lexicalUnit.getCssText());
            return null;
        }
        String string2 = lexicalUnit2.getStringValue();
        if (!set.add(string2)) {
            throw new CSSCircularityException("Circularity evaluating attr() '" + string2 + "': " + set.toString());
        }
        CSSValueSyntax cSSValueSyntax = null;
        short s = -1;
        if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
            if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                switch (lexicalUnit2.getLexicalUnitType()) {
                    case IDENT: {
                        object = lexicalUnit2.getStringValue().toLowerCase(Locale.ROOT);
                        if ("string".equals(object) || (s = (short)UnitStringToId.unitFromString((String)object)) != 1) break;
                        this.valueSyntaxError("Unexpected attribute type (" + lexicalUnit2.getCssText() + ") in " + lexicalUnit.getCssText());
                        return null;
                    }
                    case OPERATOR_MOD: {
                        s = 2;
                        break;
                    }
                    case TYPE_FUNCTION: {
                        string = lexicalUnit2.getParameters();
                        if (string.getLexicalUnitType() == LexicalUnit.LexicalType.SYNTAX) {
                            cSSValueSyntax = string.getSyntax();
                            s = 0;
                            break;
                        }
                    }
                    default: {
                        this.valueSyntaxError("Unexpected attribute type (" + lexicalUnit2.getCssText() + ") in " + lexicalUnit.getCssText());
                        return lexicalUnit2 == null ? null : lexicalUnit2.clone();
                    }
                }
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                    if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.valueSyntaxError("Expected comma, found: " + lexicalUnit2.getCssText() + " in " + lexicalUnit.getCssText());
                        return null;
                    }
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                }
            } else if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                this.valueSyntaxError("Unexpected end after comma in value " + lexicalUnit.getCssText());
                return null;
            }
        }
        string = (object = cSSStylableElement.getAttributeNode(string2)) != null ? object.getValue() : "";
        Parser parser = this.createCSSParser();
        if (s == -1) {
            LexicalUnit lexicalUnit3;
            block39: {
                if (object != null || lexicalUnit2 == null) {
                    String string3 = ParseHelper.quote((String)string, (char)'\"');
                    try {
                        lexicalUnit3 = parser.parsePropertyValue((Reader)new StringReader(string3));
                    }
                    catch (IOException iOException) {
                        lexicalUnit3 = null;
                    }
                    catch (CSSParseException cSSParseException) {
                        this.valueSyntaxError("Unexpected error parsing: " + string3.substring(0, Math.min(string3.length(), 255)), cSSParseException);
                        if (lexicalUnit2 != null) {
                            lexicalUnit3 = lexicalUnit2.clone();
                            break block39;
                        }
                        try {
                            lexicalUnit3 = parser.parsePropertyValue((Reader)new StringReader("\"\""));
                        }
                        catch (CSSParseException | IOException throwable) {
                            lexicalUnit3 = null;
                        }
                    }
                } else {
                    lexicalUnit3 = lexicalUnit2.clone();
                }
            }
            return lexicalUnit3;
        }
        if (!(string = string.trim()).isEmpty()) {
            LexicalUnit lexicalUnit4;
            try {
                lexicalUnit4 = parser.parsePropertyValue((Reader)new StringReader(string));
            }
            catch (IOException iOException) {
                lexicalUnit4 = null;
            }
            catch (CSSParseException cSSParseException) {
                this.valueSyntaxError("Error parsing attribute '" + string2 + "', value: " + string, cSSParseException);
                if (lexicalUnit2 != null) {
                    return lexicalUnit2.clone();
                }
                return null;
            }
            lexicalUnit4 = this.replaceLexicalProxy(styleMap, lexicalUnit4, cSSStylableElement, cSSStylableElement2, counterRef, set, n);
            if (lexicalUnit4 != null) {
                if (cSSValueSyntax != null) {
                    if (lexicalUnit4.matches(cSSValueSyntax) == CSSValueSyntax.Match.TRUE) {
                        return lexicalUnit4;
                    }
                    String string4 = "Attribute " + string2 + " with value '" + lexicalUnit4 + "' does not match type '" + cSSValueSyntax.toString() + "'.";
                    if (lexicalUnit2 == null) {
                        throw new DOMException(17, string4);
                    }
                    this.valueSyntaxError(string4);
                } else {
                    float f;
                    LexicalUnit.LexicalType lexicalType = lexicalUnit4.getLexicalUnitType();
                    if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
                        f = lexicalUnit4.getIntegerValue();
                    } else if (lexicalType == LexicalUnit.LexicalType.REAL) {
                        f = lexicalUnit4.getFloatValue();
                    } else {
                        String string5 = "Attribute unit is not a <number>, instead is: " + CSSUnit.dimensionUnitString((short)lexicalUnit4.getCssUnit());
                        if (lexicalUnit2 != null) {
                            this.valueSyntaxError(string5);
                            return lexicalUnit2.clone();
                        }
                        throw new DOMException(17, string5);
                    }
                    if (s != 0) {
                        lexicalUnit4 = ParseHelper.createDimensionLexicalUnit((short)s, (float)f);
                    }
                    return lexicalUnit4;
                }
            }
        }
        return lexicalUnit2 == null ? null : lexicalUnit2.clone();
    }

    private LexicalUnit getCustomPropertyValueOrFallback(StyleMap styleMap, String string, LexicalUnit lexicalUnit, CSSStylableElement cSSStylableElement, CounterRef counterRef, Set<String> set) throws DOMException, CSSSecurityException {
        if (set.contains(string)) {
            throw new CSSCircularityException("Circularity evaluating custom property " + string + ": " + set.toString());
        }
        if (!counterRef.increment()) {
            throw this.createVarResourceLimitException(string);
        }
        LexicalUnit lexicalUnit2 = this.getCustomProperty(styleMap, string, cSSStylableElement);
        if (lexicalUnit2 != null) {
            set.add(string);
            return lexicalUnit2;
        }
        return lexicalUnit;
    }

    private LexicalUnit getCustomProperty(StyleMap styleMap, String string, CSSStylableElement cSSStylableElement) {
        LexicalUnit lexicalUnit;
        boolean bl;
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(string);
        boolean bl2 = bl = propertyDefinition == null || propertyDefinition.inherits();
        while ((lexicalUnit = styleMap.getCustomProperty(string)) == null && bl && cSSStylableElement != null) {
            styleMap = cSSStylableElement.getComputedStyleMap(null);
            if (styleMap == null) {
                styleMap = this.getCascadedStyleMap(cSSStylableElement, null);
                cSSStylableElement.setComputedStyleMap(null, styleMap);
            }
            cSSStylableElement = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
        }
        if (propertyDefinition != null) {
            if (lexicalUnit == null) {
                lexicalUnit = propertyDefinition.getInitialValue();
            } else {
                CSSValueSyntax cSSValueSyntax = propertyDefinition.getSyntax();
                if (lexicalUnit.matches(cSSValueSyntax) == CSSValueSyntax.Match.FALSE) {
                    lexicalUnit = propertyDefinition.getInitialValue();
                }
            }
        }
        return lexicalUnit;
    }

    private PropertyDefinition getPropertyDefinition(String string) {
        return this.propertyDefinitionMap == null ? null : this.propertyDefinitionMap.get(string);
    }

    private boolean substitutePendingShorthand(StyleMap styleMap, PendingValue pendingValue, CSSStylableElement cSSStylableElement, CSSStylableElement cSSStylableElement2, int n) throws DOMException, CSSSecurityException {
        LexicalUnit lexicalUnit = this.replaceLexicalProxy(styleMap, pendingValue.getLexicalUnit().clone(), cSSStylableElement, cSSStylableElement2, new CounterRef(), new HashSet<String>(1), n);
        boolean bl = lexicalUnit != null ? this.setShorthandLonghands(styleMap, pendingValue.getShorthandName(), lexicalUnit, styleMap.isImportant(n)) : false;
        return bl;
    }

    private boolean setShorthandLonghands(final StyleMap styleMap, String string, LexicalUnit lexicalUnit, boolean bl) throws DOMException {
        try {
            int n = this.getShorthandIndex(string);
            if (n == -1) {
                return false;
            }
            this.shorthandManagers[n].setValues(this, new ShorthandManager.PropertyHandler(){

                @Override
                public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
                    int n = CSSEngine.this.getPropertyIndex(string);
                    if (n != -1) {
                        Value value = styleMap.getValue(n);
                        if (value == null || value.getPrimitiveType() == CSSValue.Type.INTERNAL) {
                            ValueManager valueManager = CSSEngine.this.valueManagers[n];
                            Value value2 = valueManager.createValue(lexicalUnit, CSSEngine.this);
                            styleMap.putValue(n, value2);
                        }
                    } else {
                        throw new IllegalStateException("Unknown pending value.");
                    }
                }

                @Override
                public void pendingValue(String string, PendingValue pendingValue, boolean bl) {
                    throw new IllegalStateException("Cannot set pending values after replacement.");
                }
            }, lexicalUnit, bl);
            return true;
        }
        catch (DOMException dOMException) {
            DOMException dOMException2 = new DOMException(dOMException.code, "Error setting shorthand " + string);
            dOMException2.initCause(dOMException);
            this.displayOrThrowError(dOMException2);
            return false;
        }
    }

    private void valueSyntaxError(String string) {
        DOMException dOMException = new DOMException(12, string);
        this.displayOrThrowError(dOMException);
    }

    private void valueSyntaxError(String string, Throwable throwable) {
        DOMException dOMException = new DOMException(12, string);
        dOMException.initCause(throwable);
        this.displayOrThrowError(dOMException);
    }

    private CSSResourceLimitException createVarResourceLimitException(String string) {
        return this.createResourceLimitException("Resource limit hit while replacing custom property: " + string);
    }

    private CSSResourceLimitException createVarResourceLimitException(String string, Throwable throwable) {
        return this.createResourceLimitException("Resource limit hit while replacing custom property " + string, throwable);
    }

    private CSSResourceLimitException createAttrResourceLimitException() {
        return this.createResourceLimitException("Resource limit hit while replacing attr() property.");
    }

    private CSSResourceLimitException createAttrResourceLimitException(Throwable throwable) {
        return this.createResourceLimitException("Resource limit hit while replacing attr() property.", throwable);
    }

    private CSSResourceLimitException createResourceLimitException(String string) {
        return new CSSResourceLimitException(string);
    }

    private CSSResourceLimitException createResourceLimitException(String string, Throwable throwable) {
        return new CSSResourceLimitException(string, throwable);
    }

    private void displayOrThrowError(RuntimeException runtimeException) {
        if (this.userAgent == null) {
            throw runtimeException;
        }
        this.userAgent.displayError(runtimeException);
    }

    public List<Node> getStyleSheetNodes() {
        if (this.styleSheetNodes == null) {
            this.styleSheetNodes = new ArrayList<Node>();
            this.selectorAttributes = new HashSet<String>();
            AttributeVisitor attributeVisitor = new AttributeVisitor();
            this.findStyleSheetNodes(this.document);
            for (Node node : this.styleSheetNodes) {
                CSSStyleSheetNode cSSStyleSheetNode = (CSSStyleSheetNode)((Object)node);
                StyleSheet styleSheet = cSSStyleSheetNode.getCSSStyleSheet();
                if (styleSheet == null) continue;
                this.findSelectorAttributes(attributeVisitor, styleSheet);
            }
        }
        return this.styleSheetNodes;
    }

    protected void findStyleSheetNodes(Node node) {
        if (node instanceof CSSStyleSheetNode) {
            this.styleSheetNodes.add(node);
        }
        Node node2 = CSSEngine.getCSSFirstChild(node);
        while (node2 != null) {
            this.findStyleSheetNodes(node2);
            node2 = CSSEngine.getCSSNextSibling(node2);
        }
    }

    private void findSelectorAttributes(AttributeVisitor attributeVisitor, StyleSheet styleSheet) {
        int n = styleSheet.getSize();
        block4: for (int i = 0; i < n; ++i) {
            Rule rule = styleSheet.getRule(i);
            switch (rule.getType()) {
                case 0: {
                    StyleRule styleRule = (StyleRule)rule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    attributeVisitor.visit(selectorList);
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mediaRule = (MediaRule)rule;
                    if (!this.mediaMatch(mediaRule.getMediaList())) continue block4;
                    this.findSelectorAttributes(attributeVisitor, mediaRule);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProperties(CSSStylableElement cSSStylableElement, final MainPropertyReceiver mainPropertyReceiver, String string, String string2, boolean bl) {
        try {
            this.element = cSSStylableElement;
            LexicalUnit lexicalUnit = this.parser.parsePropertyValue((Reader)new StringReader(string2));
            ShorthandManager.PropertyHandler propertyHandler = new ShorthandManager.PropertyHandler(){

                @Override
                public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
                    int n = CSSEngine.this.getPropertyIndex(string);
                    if (n != -1) {
                        ValueManager valueManager = CSSEngine.this.valueManagers[n];
                        Value value = valueManager.createValue(lexicalUnit, CSSEngine.this);
                        mainPropertyReceiver.setMainProperty(string, value, bl);
                        return;
                    }
                    n = CSSEngine.this.getShorthandIndex(string);
                    if (n == -1) {
                        return;
                    }
                    CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
                }

                @Override
                public void pendingValue(String string, PendingValue pendingValue, boolean bl) {
                    mainPropertyReceiver.setMainProperty(string, pendingValue, bl);
                }
            };
            propertyHandler.property(string, lexicalUnit, bl);
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string5 = Messages.formatMessage("property.syntax.error.at", new Object[]{string4, string, string2, string3});
            DOMException dOMException = new DOMException(12, string5);
            dOMException.initCause(exception);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value parsePropertyValue(CSSStylableElement cSSStylableElement, String string, String string2) {
        int n = this.getPropertyIndex(string);
        if (n == -1) {
            return null;
        }
        ValueManager valueManager = this.valueManagers[n];
        try {
            this.element = cSSStylableElement;
            LexicalUnit lexicalUnit = this.parser.parsePropertyValue((Reader)new StringReader(string2));
            Value value = valueManager.createValue(lexicalUnit, this);
            return value;
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string5 = Messages.formatMessage("property.syntax.error.at", new Object[]{string4, string, string2, string3});
            DOMException dOMException = new DOMException(12, string5);
            dOMException.initCause(exception);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return valueManager.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleDeclaration parseStyleDeclaration(CSSStylableElement cSSStylableElement, String string) {
        this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration();
        try {
            this.element = cSSStylableElement;
            this.parser.setDocumentHandler((CSSHandler)this.styleDeclarationBuilder);
            this.parser.parseStyleDeclaration((Reader)new StringReader(string));
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string4 = Messages.formatMessage("syntax.error.at", new Object[]{string3, string2});
            DOMException dOMException = new DOMException(12, string4);
            dOMException.initCause(exception);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return this.styleDeclarationBuilder.styleDeclaration;
    }

    public StyleSheet parseStyleSheet(ParsedURL parsedURL, String string) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMediaQueryList(string, null));
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string4 = Messages.formatMessage("syntax.error.at", new Object[]{string3, string2});
            DOMException dOMException = new DOMException(12, string4);
            dOMException.initCause(exception);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return styleSheet;
        }
        this.parseStyleSheet(styleSheet, parsedURL);
        return styleSheet;
    }

    public StyleSheet parseStyleSheet(InputSource inputSource, ParsedURL parsedURL, String string) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMediaQueryList(string, null));
            this.parseStyleSheet(styleSheet, inputSource, parsedURL);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string4 = Messages.formatMessage("syntax.error.at", new Object[]{string3, string2});
            DOMException dOMException = new DOMException(12, string4);
            dOMException.initCause(exception);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
        return styleSheet;
    }

    public void parseStyleSheet(StyleSheet styleSheet, ParsedURL parsedURL) throws DOMException {
        if (parsedURL == null) {
            String string = Messages.formatMessage("syntax.error.at", new Object[]{"Null Document reference", ""});
            DOMException dOMException = new DOMException(12, string);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return;
        }
        try {
            this.cssContext.checkLoadExternalResource(parsedURL, this.documentURI);
            this.parseStyleSheet(styleSheet, new InputSource(parsedURL.toString()), parsedURL);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = exception.getClass().getName();
            }
            String string2 = Messages.formatMessage("syntax.error.at", new Object[]{parsedURL.toString(), string});
            DOMException dOMException = new DOMException(12, string2);
            dOMException.initCause(exception);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
    }

    public StyleSheet parseStyleSheet(String string, ParsedURL parsedURL, String string2) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMediaQueryList(string2, null));
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String string5 = Messages.formatMessage("syntax.error.at", new Object[]{string4, string3});
            DOMException dOMException = new DOMException(12, string5);
            dOMException.initCause(exception);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
            return styleSheet;
        }
        this.parseStyleSheet(styleSheet, string, parsedURL);
        return styleSheet;
    }

    public void parseStyleSheet(StyleSheet styleSheet, String string, ParsedURL parsedURL) throws DOMException {
        try {
            this.parseStyleSheet(styleSheet, new InputSource((Reader)new StringReader(string)), parsedURL);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = parsedURL != null ? parsedURL.toString() : "";
            String string4 = Messages.formatMessage("stylesheet.syntax.error", new Object[]{string3, string, string2});
            DOMException dOMException = new DOMException(12, string4);
            dOMException.initCause(exception);
            if (this.userAgent == null) {
                throw dOMException;
            }
            this.userAgent.displayError(dOMException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseStyleSheet(StyleSheet styleSheet, InputSource inputSource, ParsedURL parsedURL) throws IOException {
        try {
            this.cssBaseURI = parsedURL;
            this.styleSheetDocumentHandler.styleSheet = styleSheet;
            this.parser.setDocumentHandler((CSSHandler)this.styleSheetDocumentHandler);
            this.parser.parseStyleSheet(inputSource);
            int n = styleSheet.getSize();
            for (int i = 0; i < n; ++i) {
                Rule rule = styleSheet.getRule(i);
                if (rule.getType() != 2) {
                    break;
                }
                ImportRule importRule = (ImportRule)rule;
                this.parseStyleSheet(importRule, importRule.getURI());
            }
        }
        finally {
            this.cssBaseURI = null;
        }
    }

    protected void putAuthorProperty(StyleMap styleMap, int n, Value value, boolean bl, int n2) {
        boolean bl2;
        Value value2 = styleMap.getValue(n);
        int n3 = styleMap.getOrigin(n);
        boolean bl3 = styleMap.isImportant(n);
        boolean bl4 = bl2 = value2 == null;
        if (!bl2) {
            switch (n3) {
                case 0x20000000: {
                    bl2 = !bl3;
                    break;
                }
                case 0x60000000: {
                    bl2 = !bl3 || bl;
                    break;
                }
                case -1610612736: {
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            styleMap.putValue(n, value);
            styleMap.putImportant(n, bl);
            styleMap.putOrigin(n, n2);
        }
    }

    protected void addMatchingRules(List<Rule> list, StyleSheet styleSheet, SelectorMatcher selectorMatcher) {
        int n = styleSheet.getSize();
        block5: for (int i = 0; i < n; ++i) {
            Rule rule = styleSheet.getRule(i);
            switch (rule.getType()) {
                case 0: {
                    SupportsRule supportsRule;
                    StyleRule styleRule = (StyleRule)rule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    int n2 = selectorList.getLength();
                    for (int j = 0; j < n2; ++j) {
                        supportsRule = selectorList.item(j);
                        if (!selectorMatcher.matches((Selector)supportsRule)) continue;
                        list.add(styleRule);
                    }
                    continue block5;
                }
                case 1: 
                case 2: {
                    MediaRule mediaRule = (MediaRule)rule;
                    if (!this.mediaMatch(mediaRule.getMediaList())) continue block5;
                    this.addMatchingRules(list, mediaRule, selectorMatcher);
                    continue block5;
                }
                case 12: {
                    SupportsRule supportsRule = (SupportsRule)rule;
                    if (!supportsRule.supports) continue block5;
                    this.addMatchingRules(list, supportsRule, selectorMatcher);
                }
            }
        }
    }

    protected boolean mediaMatch(MediaQueryList mediaQueryList) {
        if (this.medium == null || mediaQueryList == null || mediaQueryList.isAllMedia()) {
            return true;
        }
        return mediaQueryList.matches(this.medium, this.csscanvas);
    }

    private void setSupports(SupportsRule supportsRule) {
        BooleanCondition booleanCondition = supportsRule.getCondition();
        if (booleanCondition != null) {
            try {
                supportsRule.supports = this.supports(booleanCondition);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        supportsRule.supports = false;
    }

    private boolean supports(BooleanCondition booleanCondition) {
        switch (booleanCondition.getType()) {
            case PREDICATE: {
                DeclarationCondition declarationCondition = (DeclarationCondition)booleanCondition;
                return this.supports(declarationCondition.getName(), declarationCondition.getValue());
            }
            case AND: {
                List list = booleanCondition.getSubConditions();
                if (list == null) {
                    DOMException dOMException = new DOMException(12, "No conditions inside and().");
                    this.userAgent.displayError(dOMException);
                    return false;
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (this.supports((BooleanCondition)iterator.next())) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                BooleanCondition booleanCondition2 = booleanCondition.getNestedCondition();
                if (booleanCondition2 == null) {
                    DOMException dOMException = new DOMException(12, "No condition inside not().");
                    this.userAgent.displayError(dOMException);
                    return false;
                }
                return !this.supports(booleanCondition2);
            }
            case OR: {
                List list = booleanCondition.getSubConditions();
                if (list == null) {
                    DOMException dOMException = new DOMException(12, "No conditions inside or().");
                    this.userAgent.displayError(dOMException);
                    return false;
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!this.supports((BooleanCondition)iterator.next())) continue;
                    return true;
                }
                break;
            }
            case SELECTOR_FUNCTION: {
                SelectorFunction selectorFunction = (SelectorFunction)booleanCondition;
                return this.styleDb.supports(selectorFunction.getSelectors());
            }
        }
        return false;
    }

    private boolean supports(String string, LexicalUnit lexicalUnit) {
        int n = this.getPropertyIndex(string);
        if (n != -1) {
            try {
                this.valueManagers[n].createValue(lexicalUnit, this);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        n = this.getShorthandIndex(string);
        if (n != -1) {
            try {
                this.shorthandManagers[n].setValues(this, new ShorthandManager.PropertyHandler(){

                    @Override
                    public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
                    }

                    @Override
                    public void pendingValue(String string, PendingValue pendingValue, boolean bl) {
                    }
                }, lexicalUnit, false);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected void addRules(SelectorMatcher selectorMatcher, StyleMap styleMap, ArrayList<Rule> arrayList, int n) {
        this.sortRules(arrayList, selectorMatcher);
        if (n == 0x60000000) {
            for (Rule rule : arrayList) {
                StyleRule styleRule = (StyleRule)rule;
                StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                int n2 = styleDeclaration.size();
                for (int i = 0; i < n2; ++i) {
                    this.putAuthorProperty(styleMap, styleDeclaration.getIndex(i), styleDeclaration.getValue(i), styleDeclaration.getPriority(i), n);
                }
                Map<String, LexicalUnit> map = styleDeclaration.getCustomProperties();
                if (map == null) continue;
                for (Map.Entry<String, LexicalUnit> entry : map.entrySet()) {
                    styleMap.putCustomProperty(entry.getKey(), entry.getValue());
                }
            }
        } else {
            for (Rule rule : arrayList) {
                StyleRule styleRule = (StyleRule)rule;
                StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                int n3 = styleDeclaration.size();
                for (int i = 0; i < n3; ++i) {
                    int n4 = styleDeclaration.getIndex(i);
                    styleMap.putValue(n4, styleDeclaration.getValue(i));
                    styleMap.putImportant(n4, styleDeclaration.getPriority(i));
                    styleMap.putOrigin(n4, n);
                }
            }
        }
    }

    protected void sortRules(ArrayList<Rule> arrayList, SelectorMatcher selectorMatcher) {
        SelectorList selectorList;
        Rule rule;
        int n;
        int n2 = arrayList.size();
        Specificity[] specificityArray = new Specificity[n2];
        for (n = 0; n < n2; ++n) {
            rule = (StyleRule)arrayList.get(n);
            selectorList = rule.getSelectorList();
            Specificity specificity = null;
            int n3 = selectorList.getLength();
            for (int i = 0; i < n3; ++i) {
                Selector selector = selectorList.item(i);
                if (!selectorMatcher.matches(selector)) continue;
                Specificity specificity2 = new Specificity(selector, selectorMatcher);
                if (specificity == null) {
                    specificity = specificity2;
                    continue;
                }
                int n4 = Specificity.selectorCompare((Specificity)specificity2, (Specificity)specificity);
                if (n4 <= 0) continue;
                specificity = specificity2;
            }
            specificityArray[n] = specificity;
        }
        for (n = 1; n < n2; ++n) {
            int n5;
            rule = arrayList.get(n);
            selectorList = specificityArray[n];
            for (n5 = n - 1; n5 >= 0 && Specificity.selectorCompare((Specificity)specificityArray[n5], (Specificity)selectorList) > 0; --n5) {
                arrayList.set(n5 + 1, arrayList.get(n5));
                specificityArray[n5 + 1] = specificityArray[n5];
            }
            arrayList.set(n5 + 1, rule);
            specificityArray[n5 + 1] = selectorList;
        }
    }

    public void addCSSEngineListener(CSSEngineListener cSSEngineListener) {
        this.listeners.add(cSSEngineListener);
    }

    public void removeCSSEngineListener(CSSEngineListener cSSEngineListener) {
        this.listeners.remove(cSSEngineListener);
    }

    protected void firePropertiesChangedEvent(Element element, int[] nArray) {
        CSSEngineListener[] cSSEngineListenerArray = this.listeners.toArray(LISTENER_ARRAY);
        int n = cSSEngineListenerArray.length;
        if (n > 0) {
            CSSEngineEvent cSSEngineEvent = new CSSEngineEvent(this, element, nArray);
            for (CSSEngineListener cSSEngineListener : cSSEngineListenerArray) {
                cSSEngineListener.propertiesChanged(cSSEngineEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inlineStyleAttributeUpdated(CSSStylableElement cSSStylableElement, StyleMap styleMap, short s, String string, String string2) {
        int n;
        boolean[] blArray = this.styleDeclarationUpdateHandler.updatedProperties;
        for (n = this.getNumberOfProperties() - 1; n >= 0; --n) {
            blArray[n] = false;
        }
        switch (s) {
            case 1: 
            case 2: {
                if (string2.length() > 0) {
                    this.element = cSSStylableElement;
                    try {
                        this.styleDeclarationUpdateHandler.styleMap = styleMap;
                        this.parser.setDocumentHandler((CSSHandler)this.styleDeclarationUpdateHandler);
                        this.parser.parseStyleDeclaration((Reader)new StringReader(string2));
                        this.styleDeclarationUpdateHandler.styleMap = null;
                    }
                    catch (Exception exception) {
                        String string3 = exception.getMessage();
                        if (string3 == null) {
                            string3 = "";
                        }
                        String string4 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String string5 = Messages.formatMessage("style.syntax.error.at", new Object[]{string4, this.styleLocalName, string2, string3});
                        DOMException dOMException = new DOMException(12, string5);
                        dOMException.initCause(exception);
                        if (this.userAgent == null) {
                            throw dOMException;
                        }
                        this.userAgent.displayError(dOMException);
                    }
                    finally {
                        this.element = null;
                        this.cssBaseURI = null;
                    }
                }
            }
            case 3: {
                n = 0;
                if (string != null && string.length() > 0) {
                    for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                        int n2;
                        if (!styleMap.isComputed(i) || blArray[i] || (n2 = styleMap.getOrigin(i)) < Integer.MIN_VALUE) continue;
                        n = 1;
                        blArray[i] = true;
                    }
                }
                if (n != 0) {
                    this.invalidateProperties(cSSStylableElement, null, blArray, true);
                    break;
                }
                int n3 = 0;
                boolean bl = this.fontSizeIndex == -1 ? false : blArray[this.fontSizeIndex];
                boolean bl2 = this.lineHeightIndex == -1 ? false : blArray[this.lineHeightIndex];
                boolean bl3 = this.colorIndex == -1 ? false : blArray[this.colorIndex];
                boolean bl4 = cSSStylableElement.getOwnerDocument().getDocumentElement() == cSSStylableElement;
                boolean bl5 = this.styleDeclarationUpdateHandler.updatedCustomProperties;
                for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (blArray[i]) {
                        ++n3;
                        continue;
                    }
                    if (!(bl && styleMap.isFontSizeRelative(i) || bl2 && styleMap.isLineHeightRelative(i) || bl3 && styleMap.isColorRelative(i) || bl && bl4 && styleMap.isRootFontSizeRelative(i) || bl2 && bl4 && styleMap.isRootLineHeightRelative(i)) && (!bl5 || !styleMap.isCustomPtyRelative(i))) continue;
                    blArray[i] = true;
                    CSSEngine.clearComputedValue(styleMap, i);
                    ++n3;
                }
                if (n3 <= 0) break;
                int[] nArray = new int[n3];
                n3 = 0;
                for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (!blArray[i]) continue;
                    nArray[n3++] = i;
                }
                this.invalidateProperties(cSSStylableElement, nArray, null, true);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid attrChangeType");
            }
        }
    }

    private static void clearComputedValue(StyleMap styleMap, int n) {
        if (styleMap.isNullCascaded(n)) {
            styleMap.putValue(n, null);
        } else {
            Value value = styleMap.getValue(n);
            if (value instanceof ComputedValue) {
                ComputedValue computedValue = (ComputedValue)value;
                value = computedValue.getCascadedValue();
                styleMap.putValue(n, value);
            }
        }
        styleMap.putComputed(n, false);
    }

    protected void invalidateProperties(Node node, int[] nArray, boolean[] blArray, boolean bl) {
        Object object;
        int n;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)node;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap == null) {
            return;
        }
        boolean[] blArray2 = new boolean[this.getNumberOfProperties()];
        if (blArray != null) {
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        }
        if (nArray != null) {
            int[] nArray2 = nArray;
            int n2 = nArray2.length;
            for (n = 0; n < n2; ++n) {
                int n3 = nArray2[n];
                blArray2[n3] = true;
            }
        }
        int n4 = 0;
        if (!bl) {
            for (boolean bl2 : blArray2) {
                if (!bl2) continue;
                ++n4;
            }
        } else {
            object = this.getCascadedStyleMap(cSSStylableElement, null);
            cSSStylableElement.setComputedStyleMap(null, (StyleMap)object);
            for (n = 0; n < blArray2.length; ++n) {
                if (blArray2[n]) {
                    ++n4;
                    continue;
                }
                Value value = ((StyleMap)object).getValue(n);
                Value value2 = null;
                if (!styleMap.isNullCascaded(n) && (value2 = styleMap.getValue(n)) instanceof ComputedValue) {
                    value2 = ((ComputedValue)value2).getCascadedValue();
                }
                if (value == value2) continue;
                if (value != null && value2 != null) {
                    if (value.equals(value2)) continue;
                    String string = value2.getCssText();
                    String string2 = value.getCssText();
                    if (string2 == string || string2 != null && string2.equals(string)) continue;
                }
                ++n4;
                blArray2[n] = true;
            }
        }
        object = null;
        if (n4 != 0) {
            object = new int[n4];
            n4 = 0;
            for (n = 0; n < blArray2.length; ++n) {
                if (!blArray2[n]) continue;
                object[n4++] = n;
            }
        }
        this.propagateChanges(cSSStylableElement, (int[])object, bl);
    }

    protected void propagateChanges(Node node, int[] nArray, boolean bl) {
        int n;
        int n2;
        Object[] objectArray;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement cSSStylableElement = (CSSStylableElement)node;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap != null) {
            int n3;
            objectArray = this.styleDeclarationUpdateHandler.updatedProperties;
            for (n2 = this.getNumberOfProperties() - 1; n2 >= 0; --n2) {
                objectArray[n2] = 0;
            }
            if (nArray != null) {
                for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                    n = nArray[n2];
                    objectArray[n] = 1;
                }
            }
            n2 = this.fontSizeIndex == -1 ? 0 : objectArray[this.fontSizeIndex];
            n = this.lineHeightIndex == -1 ? 0 : objectArray[this.lineHeightIndex];
            int n4 = this.colorIndex == -1 ? 0 : objectArray[this.colorIndex];
            int n5 = n2 != 0 && cSSStylableElement.getOwnerDocument().getDocumentElement() == cSSStylableElement ? 1 : 0;
            int n6 = this.styleDeclarationUpdateHandler.updatedCustomProperties ? 1 : 0;
            int n7 = 0;
            for (n3 = this.getNumberOfProperties() - 1; n3 >= 0; --n3) {
                if (objectArray[n3] != 0) {
                    ++n7;
                    continue;
                }
                if (!(n2 != 0 && styleMap.isFontSizeRelative(n3) || n != 0 && styleMap.isLineHeightRelative(n3) || n4 != 0 && styleMap.isColorRelative(n3) || n5 != 0 && styleMap.isRootFontSizeRelative(n3)) && (n6 == 0 || !styleMap.isCustomPtyRelative(n3))) continue;
                objectArray[n3] = 1;
                CSSEngine.clearComputedValue(styleMap, n3);
                ++n7;
            }
            if (n7 == 0) {
                nArray = null;
            } else {
                nArray = new int[n7];
                n7 = 0;
                for (n3 = this.getNumberOfProperties() - 1; n3 >= 0; --n3) {
                    if (objectArray[n3] == 0) continue;
                    nArray[n7++] = n3;
                }
                this.firePropertiesChangedEvent(cSSStylableElement, nArray);
            }
        }
        objectArray = nArray;
        if (nArray != null) {
            n2 = 0;
            for (n = 0; n < nArray.length; ++n) {
                ValueManager valueManager = this.valueManagers[nArray[n]];
                if (valueManager.isInheritedProperty()) {
                    ++n2;
                    continue;
                }
                nArray[n] = -1;
            }
            if (n2 == 0) {
                objectArray = null;
            } else {
                objectArray = new int[n2];
                n2 = 0;
                for (int n6 : nArray) {
                    if (n6 == -1) continue;
                    objectArray[n2++] = n6;
                }
            }
        }
        Node node2 = CSSEngine.getCSSFirstChild(node);
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                this.invalidateProperties(node2, (int[])objectArray, null, bl);
            }
            node2 = CSSEngine.getCSSNextSibling(node2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nonCSSPresentationalHintUpdated(CSSStylableElement cSSStylableElement, StyleMap styleMap, String string, short s, String string2) {
        int n;
        Object object;
        int n2 = this.getPropertyIndex(string);
        if (styleMap.isImportant(n2)) {
            return;
        }
        if (styleMap.getOrigin(n2) >= 0x60000000) {
            return;
        }
        switch (s) {
            case 1: 
            case 2: {
                Object object2;
                Object object3;
                this.element = cSSStylableElement;
                try {
                    object = this.parser.parsePropertyValue((Reader)new StringReader(string2));
                    object3 = this.valueManagers[n2];
                    object2 = object3.createValue((LexicalUnit)object, this);
                    styleMap.putMask(n2, 0);
                    styleMap.putValue(n2, (Value)object2);
                    styleMap.putOrigin(n2, 0x40000000);
                    break;
                }
                catch (Exception exception) {
                    object3 = exception.getMessage();
                    if (object3 == null) {
                        object3 = "";
                    }
                    object2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    String string3 = Messages.formatMessage("property.syntax.error.at", new Object[]{object2, string, string2, object3});
                    DOMException dOMException = new DOMException(12, string3);
                    dOMException.initCause(exception);
                    if (this.userAgent == null) {
                        throw dOMException;
                    }
                    this.userAgent.displayError(dOMException);
                    break;
                }
                finally {
                    this.element = null;
                    this.cssBaseURI = null;
                }
            }
            case 3: {
                int[] nArray = new int[]{n2};
                this.invalidateProperties(cSSStylableElement, nArray, null, true);
                return;
            }
        }
        object = this.styleDeclarationUpdateHandler.updatedProperties;
        for (n = this.getNumberOfProperties() - 1; n >= 0; --n) {
            object[n] = false;
        }
        object[n2] = true;
        n = n2 == this.fontSizeIndex ? 1 : 0;
        boolean bl = n2 == this.lineHeightIndex;
        boolean bl2 = n2 == this.colorIndex;
        boolean bl3 = n != 0 && cSSStylableElement.getOwnerDocument().getDocumentElement() == cSSStylableElement;
        int n3 = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (object[i]) {
                ++n3;
                continue;
            }
            if (!(n != 0 && styleMap.isFontSizeRelative(i) || bl && styleMap.isLineHeightRelative(i) || bl2 && styleMap.isColorRelative(i)) && (!bl3 || !styleMap.isRootFontSizeRelative(i))) continue;
            object[i] = true;
            CSSEngine.clearComputedValue(styleMap, i);
            ++n3;
        }
        int[] nArray = new int[n3];
        n3 = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (!object[i]) continue;
            nArray[n3++] = i;
        }
        this.invalidateProperties(cSSStylableElement, nArray, null, true);
    }

    protected boolean hasStyleSheetNode(Node node) {
        if (node instanceof CSSStyleSheetNode) {
            return true;
        }
        node = CSSEngine.getCSSFirstChild(node);
        while (node != null) {
            if (this.hasStyleSheetNode(node)) {
                return true;
            }
            node = CSSEngine.getCSSNextSibling(node);
        }
        return false;
    }

    protected void handleAttrModified(Element element, Attr attr, short s, String string, String string2) {
        if (!(element instanceof CSSStylableElement) || string2.equals(string)) {
            return;
        }
        String string3 = attr.getNamespaceURI();
        String string4 = string3 == null ? attr.getNodeName() : attr.getLocalName();
        CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
        if (styleMap != null) {
            if ((string3 == this.styleNamespaceURI || string3 != null && string3.equals(this.styleNamespaceURI)) && string4.equals(this.styleLocalName)) {
                this.inlineStyleAttributeUpdated(cSSStylableElement, styleMap, s, string, string2);
                return;
            }
            if (this.nonCSSPresentationalHints != null && (string3 == this.nonCSSPresentationalHintsNamespaceURI || string3 != null && string3.equals(this.nonCSSPresentationalHintsNamespaceURI)) && this.nonCSSPresentationalHints.contains(string4)) {
                this.nonCSSPresentationalHintUpdated(cSSStylableElement, styleMap, string4, s, string2);
                return;
            }
        }
        if (this.selectorAttributes != null && this.selectorAttributes.contains(string4)) {
            this.invalidateProperties(cSSStylableElement, null, null, true);
            Node node = CSSEngine.getCSSNextSibling(cSSStylableElement);
            while (node != null) {
                this.invalidateProperties(node, null, null, true);
                node = CSSEngine.getCSSNextSibling(node);
            }
        }
    }

    protected void handleNodeInserted(Node node) {
        if (this.hasStyleSheetNode(node)) {
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        } else if (node instanceof CSSStylableElement) {
            node = CSSEngine.getCSSNextSibling(node);
            while (node != null) {
                this.invalidateProperties(node, null, null, true);
                node = CSSEngine.getCSSNextSibling(node);
            }
        }
    }

    protected void handleNodeRemoved(Node node) {
        if (this.hasStyleSheetNode(node)) {
            this.styleSheetRemoved = true;
        } else if (node instanceof CSSStylableElement) {
            this.removedStylableElementSibling = CSSEngine.getCSSNextSibling(node);
        }
        this.disposeStyleMaps(node);
    }

    protected void handleSubtreeModified(Node node) {
        if (this.styleSheetRemoved) {
            this.styleSheetRemoved = false;
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        } else if (this.removedStylableElementSibling != null) {
            Node node2 = this.removedStylableElementSibling;
            while (node2 != null) {
                this.invalidateProperties(node2, null, null, true);
                node2 = CSSEngine.getCSSNextSibling(node2);
            }
            this.removedStylableElementSibling = null;
        }
    }

    protected void handleCharacterDataModified(Node node) {
        if (CSSEngine.getCSSParentNode(node) instanceof CSSStyleSheetNode) {
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        }
    }

    private class AttributeVisitor
    extends AttributeConditionVisitor {
        AttributeVisitor() {
        }

        public void visit(AttributeCondition attributeCondition) {
            switch (attributeCondition.getConditionType()) {
                case ATTRIBUTE: 
                case ONE_OF_ATTRIBUTE: 
                case BEGIN_HYPHEN_ATTRIBUTE: 
                case BEGINS_ATTRIBUTE: 
                case ENDS_ATTRIBUTE: 
                case SUBSTRING_ATTRIBUTE: {
                    CSSEngine.this.selectorAttributes.add(attributeCondition.getLocalName());
                    break;
                }
            }
        }
    }

    protected class CSSNavigableDocumentHandler
    implements CSSNavigableDocumentListener,
    MainPropertyReceiver {
        protected boolean[] mainPropertiesChanged;
        protected StyleDeclaration declaration;

        protected CSSNavigableDocumentHandler() {
        }

        @Override
        public void nodeInserted(Node node) {
            CSSEngine.this.handleNodeInserted(node);
        }

        @Override
        public void nodeToBeRemoved(Node node) {
            CSSEngine.this.handleNodeRemoved(node);
        }

        @Override
        public void subtreeModified(Node node) {
            CSSEngine.this.handleSubtreeModified(node);
        }

        @Override
        public void characterDataModified(Node node) {
            CSSEngine.this.handleCharacterDataModified(node);
        }

        @Override
        public void attrModified(Element element, Attr attr, short s, String string, String string2) {
            CSSEngine.this.handleAttrModified(element, attr, s, string, string2);
        }

        @Override
        public void overrideStyleTextChanged(CSSStylableElement cSSStylableElement, String string) {
            int n;
            StyleDeclarationProvider styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider();
            StyleDeclaration styleDeclaration = styleDeclarationProvider.getStyleDeclaration();
            int n2 = styleDeclaration.size();
            boolean[] blArray = new boolean[CSSEngine.this.getNumberOfProperties()];
            for (n = 0; n < n2; ++n) {
                blArray[styleDeclaration.getIndex((int)n)] = true;
            }
            styleDeclaration = CSSEngine.this.parseStyleDeclaration(cSSStylableElement, string);
            styleDeclarationProvider.setStyleDeclaration(styleDeclaration);
            n2 = styleDeclaration.size();
            for (n = 0; n < n2; ++n) {
                blArray[styleDeclaration.getIndex((int)n)] = true;
            }
            CSSEngine.this.invalidateProperties(cSSStylableElement, null, blArray, true);
        }

        @Override
        public void overrideStylePropertyRemoved(CSSStylableElement cSSStylableElement, String string) {
            StyleDeclarationProvider styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider();
            StyleDeclaration styleDeclaration = styleDeclarationProvider.getStyleDeclaration();
            int n = CSSEngine.this.getPropertyIndex(string);
            int n2 = styleDeclaration.size();
            for (int i = 0; i < n2; ++i) {
                if (n != styleDeclaration.getIndex(i)) continue;
                styleDeclaration.remove(i);
                StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
                if (styleMap == null || styleMap.getOrigin(n) != -1610612736) break;
                CSSEngine.this.invalidateProperties(cSSStylableElement, new int[]{n}, null, true);
                break;
            }
        }

        @Override
        public void overrideStylePropertyChanged(CSSStylableElement cSSStylableElement, String string, String string2, String string3) {
            boolean bl = string3 != null && string3.length() != 0;
            StyleDeclarationProvider styleDeclarationProvider = cSSStylableElement.getOverrideStyleDeclarationProvider();
            this.declaration = styleDeclarationProvider.getStyleDeclaration();
            CSSEngine.this.setMainProperties(cSSStylableElement, this, string, string2, bl);
            this.declaration = null;
            CSSEngine.this.invalidateProperties(cSSStylableElement, null, this.mainPropertiesChanged, true);
        }

        @Override
        public void setMainProperty(String string, Value value, boolean bl) {
            int n;
            int n2 = CSSEngine.this.getPropertyIndex(string);
            if (n2 == -1) {
                return;
            }
            for (n = 0; n < this.declaration.size() && n2 != this.declaration.getIndex(n); ++n) {
            }
            if (n < this.declaration.size()) {
                this.declaration.put(n, value, n2, bl);
            } else {
                this.declaration.append(value, n2, bl);
            }
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            CSSEngine.this.handleAttrModified((Element)((Object)event.getTarget()), (Attr)mutationEvent.getRelatedNode(), mutationEvent.getAttrChange(), mutationEvent.getPrevValue(), mutationEvent.getNewValue());
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            CSSEngine.this.handleCharacterDataModified((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            CSSEngine.this.handleNodeInserted((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            CSSEngine.this.handleNodeRemoved((Node)((Object)event.getTarget()));
        }
    }

    protected class DOMSubtreeModifiedListener
    implements EventListener {
        protected DOMSubtreeModifiedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            CSSEngine.this.handleSubtreeModified((Node)((Object)event.getTarget()));
        }
    }

    protected static class DocumentAdapter
    implements CSSHandler {
        protected DocumentAdapter() {
        }

        public void parseStart(ParserControl parserControl) {
        }

        public void endOfStream() {
        }

        public void comment(String string, boolean bl) {
        }

        public void ignorableAtRule(String string) {
            this.throwUnsupportedEx();
        }

        public void namespaceDeclaration(String string, String string2) {
            this.throwUnsupportedEx();
        }

        public void importStyle(String string, MediaQueryList mediaQueryList, String string2) {
            this.throwUnsupportedEx();
        }

        public void startMedia(MediaQueryList mediaQueryList) {
            this.throwUnsupportedEx();
        }

        public void endMedia(MediaQueryList mediaQueryList) {
            this.throwUnsupportedEx();
        }

        public void startPage(PageSelectorList pageSelectorList) {
            this.throwUnsupportedEx();
        }

        public void endPage(PageSelectorList pageSelectorList) {
            this.throwUnsupportedEx();
        }

        public void startFontFace() {
            this.throwUnsupportedEx();
        }

        public void endFontFace() {
            this.throwUnsupportedEx();
        }

        public void startMargin(String string) {
            this.throwUnsupportedEx();
        }

        public void endMargin() {
            this.throwUnsupportedEx();
        }

        public void startCounterStyle(String string) {
            this.throwUnsupportedEx();
        }

        public void endCounterStyle() {
            this.throwUnsupportedEx();
        }

        public void startKeyframes(String string) {
            this.throwUnsupportedEx();
        }

        public void endKeyframes() {
            this.throwUnsupportedEx();
        }

        public void startKeyframe(LexicalUnit lexicalUnit) {
            this.throwUnsupportedEx();
        }

        public void endKeyframe() {
            this.throwUnsupportedEx();
        }

        public void startFontFeatures(String[] stringArray) {
            this.throwUnsupportedEx();
        }

        public void endFontFeatures() {
            this.throwUnsupportedEx();
        }

        public void startFeatureMap(String string) {
            this.throwUnsupportedEx();
        }

        public void endFeatureMap() {
            this.throwUnsupportedEx();
        }

        public void startProperty(String string) {
            this.throwUnsupportedEx();
        }

        public void endProperty(boolean bl) {
            this.throwUnsupportedEx();
        }

        public void startSupports(BooleanCondition booleanCondition) {
            this.throwUnsupportedEx();
        }

        public void endSupports(BooleanCondition booleanCondition) {
            this.throwUnsupportedEx();
        }

        public void startViewport() {
            this.throwUnsupportedEx();
        }

        public void endViewport() {
            this.throwUnsupportedEx();
        }

        public void startSelector(SelectorList selectorList) {
            this.throwUnsupportedEx();
        }

        public void endSelector(SelectorList selectorList) {
            this.throwUnsupportedEx();
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            this.throwUnsupportedEx();
        }

        public void lexicalProperty(String string, LexicalUnit lexicalUnit, boolean bl) {
        }

        private void throwUnsupportedEx() {
            throw new UnsupportedOperationException("you try to use an empty method in Adapter-class");
        }
    }

    private class EngineCSSCanvas
    extends AbstractCSSCanvas {
        private EngineCSSCanvas() {
        }

        public CSSDocument getDocument() {
            return null;
        }

        public StyleDatabase getStyleDatabase() {
            return CSSEngine.this.styleDb;
        }

        protected String getOverflowBlock() {
            return "none";
        }

        protected String getOverflowInline() {
            return "none";
        }

        protected String getPointerAccuracy() {
            return "none";
        }

        protected String getPrefersColorScheme() {
            return CSSEngine.this.cssContext.getPrefersColorScheme();
        }

        protected float getResolution() {
            return CSSEngine.this.cssContext.getResolution();
        }
    }

    private class EngineStyleDatabase
    extends AbstractStyleDatabase {
        private static final long serialVersionUID = 1L;
        private final List<String> fonts = this.getAvailableFontList();

        private EngineStyleDatabase() {
        }

        private List<String> getAvailableFontList() {
            return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        }

        public String getDefaultGenericFontFamily() {
            return CSSEngine.this.cssContext.getDefaultFontFamily().getStringValue();
        }

        public String getDefaultGenericFontFamily(String string) {
            return string;
        }

        public boolean isFontFaceName(String string) {
            for (FontFaceRule fontFaceRule : CSSEngine.this.fontFaces) {
                int n;
                StyleMap styleMap = fontFaceRule.getStyleMap();
                Value value = styleMap.getValue(n = CSSEngine.this.getPropertyIndex("font-family"));
                if (value == null || !value.getStringValue().equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }

        public int getColorDepth() {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
            int n = 255;
            if (graphicsConfiguration != null) {
                int[] nArray = graphicsConfiguration.getColorModel().getComponentSize();
                for (int i = 0; i < 3; ++i) {
                    if (n <= nArray[i]) continue;
                    n = nArray[i];
                }
            }
            return n;
        }

        public float getDeviceHeight() {
            return CSSEngine.this.cssContext.getViewport(CSSEngine.this.element).getHeight();
        }

        public float getDeviceWidth() {
            return CSSEngine.this.cssContext.getViewport(CSSEngine.this.element).getWidth();
        }

        protected boolean isFontFamilyAvailable(String string) {
            return this.fonts.contains(string);
        }

        public CSSTypedValue getInitialColor() {
            String string = CSSEngine.this.cssContext.getPrefersColorScheme();
            return "dark".equals(string) ? this.darkmodeInitialColor() : super.getInitialColor();
        }

        private CSSTypedValue darkmodeInitialColor() {
            return (CSSTypedValue)new ValueFactory().parseProperty("#fff");
        }

        public boolean supports(SelectorList selectorList) {
            for (Selector selector : selectorList) {
                if (this.supports(selector)) continue;
                return false;
            }
            return true;
        }

        private boolean supports(Selector selector) {
            if (selector != null) {
                switch (selector.getSelectorType()) {
                    case CHILD: 
                    case DESCENDANT: 
                    case DIRECT_ADJACENT: 
                    case SUBSEQUENT_SIBLING: {
                        CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                        return this.supports(combinatorSelector.getSelector()) && this.supports((Selector)combinatorSelector.getSecondSelector());
                    }
                    case CONDITIONAL: {
                        ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                        return this.supports((Selector)conditionalSelector.getSimpleSelector()) && this.supports(conditionalSelector.getCondition());
                    }
                    case COLUMN_COMBINATOR: {
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean supports(Condition condition) {
            switch (condition.getConditionType()) {
                case AND: {
                    CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                    return this.supports(combinatorCondition.getFirstCondition()) && this.supports(combinatorCondition.getSecondCondition());
                }
                case SELECTOR_ARGUMENT: {
                    ArgumentCondition argumentCondition = (ArgumentCondition)condition;
                    SelectorList selectorList = argumentCondition.getSelectors();
                    return selectorList == null || this.supports(selectorList);
                }
            }
            return true;
        }
    }

    public static interface MainPropertyReceiver {
        public void setMainProperty(String var1, Value var2, boolean var3);
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleDeclaration styleDeclaration;

        protected StyleDeclarationBuilder() {
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleDeclaration.append(value, n, bl);
            }
        }

        @Override
        public void lexicalProperty(String string, LexicalUnit lexicalUnit, boolean bl) {
            this.styleDeclaration.setCustomProperty(string, lexicalUnit, bl);
        }

        @Override
        public void pendingValue(String string, PendingValue pendingValue, boolean bl) {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n != -1) {
                this.styleDeclaration.append(pendingValue, n, bl);
            }
        }
    }

    protected class StyleDeclarationDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;

        protected StyleDeclarationDocumentHandler() {
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                try {
                    CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
                }
                catch (Exception exception) {
                    if (CSSEngine.this.userAgent == null) {
                        throw exception;
                    }
                    CSSEngine.this.userAgent.displayError(exception);
                }
            } else {
                Value value;
                try {
                    value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                }
                catch (Exception exception) {
                    if (CSSEngine.this.userAgent == null) {
                        throw exception;
                    }
                    CSSEngine.this.userAgent.displayError(exception);
                    return;
                }
                CSSEngine.this.putAuthorProperty(this.styleMap, n, value, bl, Integer.MIN_VALUE);
            }
        }

        @Override
        public void lexicalProperty(String string, LexicalUnit lexicalUnit, boolean bl) {
            this.styleMap.putCustomProperty(string, lexicalUnit);
        }

        @Override
        public void pendingValue(String string, PendingValue pendingValue, boolean bl) {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n != -1) {
                CSSEngine.this.putAuthorProperty(this.styleMap, n, pendingValue, bl, Integer.MIN_VALUE);
            }
        }
    }

    protected class StyleDeclarationUpdateHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        public boolean[] updatedProperties;
        public boolean updatedCustomProperties;

        protected StyleDeclarationUpdateHandler() {
            this.updatedProperties = new boolean[CSSEngine.this.getNumberOfProperties()];
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                if (this.styleMap.isImportant(n)) {
                    return;
                }
                this.updatedProperties[n] = true;
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleMap.putMask(n, 0);
                this.styleMap.putValue(n, value);
                this.styleMap.putOrigin(n, Integer.MIN_VALUE);
            }
        }

        @Override
        public void lexicalProperty(String string, LexicalUnit lexicalUnit, boolean bl) {
            this.updatedCustomProperties = true;
        }

        @Override
        public void pendingValue(String string, PendingValue pendingValue, boolean bl) {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (this.styleMap.isImportant(n)) {
                return;
            }
            this.updatedProperties[n] = true;
            this.styleMap.putMask(n, 0);
            this.styleMap.putValue(n, pendingValue);
            this.styleMap.putOrigin(n, Integer.MIN_VALUE);
        }
    }

    protected class StyleSheetDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleSheet styleSheet;
        protected StyleRule styleRule;
        protected StyleDeclaration styleDeclaration;
        private PropertyDefinitionImpl currentPropertyDefinition = null;
        private int ignoredForRule = 0;

        protected StyleSheetDocumentHandler() {
        }

        @Override
        public void parseStart(ParserControl parserControl) {
        }

        @Override
        public void endOfStream() {
        }

        @Override
        public void ignorableAtRule(String string) {
        }

        @Override
        public void namespaceDeclaration(String string, String string2) {
        }

        @Override
        public void startCounterStyle(String string) {
            if (this.ignoredForRule == 0) {
                this.ignoredForRule = 11;
            }
        }

        @Override
        public void endCounterStyle() {
            if (this.ignoredForRule == 11) {
                this.ignoredForRule = 0;
            }
        }

        @Override
        public void importStyle(String string, MediaQueryList mediaQueryList, String string2) {
            if (this.ignoredForRule > 0) {
                return;
            }
            ImportRule importRule = new ImportRule();
            importRule.setMediaList(mediaQueryList);
            importRule.setParent(this.styleSheet);
            ParsedURL parsedURL = CSSEngine.this.getCSSBaseURI();
            ParsedURL parsedURL2 = parsedURL == null ? new ParsedURL(string) : new ParsedURL(parsedURL, string);
            importRule.setURI(parsedURL2);
            this.styleSheet.append(importRule);
        }

        @Override
        public void startMedia(MediaQueryList mediaQueryList) {
            if (this.ignoredForRule > 0) {
                return;
            }
            MediaRule mediaRule = new MediaRule();
            mediaRule.setMediaList(mediaQueryList);
            mediaRule.setParent(this.styleSheet);
            this.styleSheet.append(mediaRule);
            this.styleSheet = mediaRule;
        }

        @Override
        public void endMedia(MediaQueryList mediaQueryList) {
            if (this.ignoredForRule > 0) {
                return;
            }
            this.styleSheet = this.styleSheet.getParent();
        }

        @Override
        public void startPage(PageSelectorList pageSelectorList) {
            if (this.ignoredForRule == 0) {
                this.ignoredForRule = 6;
            }
        }

        @Override
        public void endPage(PageSelectorList pageSelectorList) {
            if (this.ignoredForRule == 6) {
                this.ignoredForRule = 0;
            }
        }

        @Override
        public void startFontFace() {
            if (this.ignoredForRule > 0) {
                return;
            }
            this.styleDeclaration = new StyleDeclaration();
        }

        @Override
        public void endFontFace() {
            int n;
            if (this.ignoredForRule > 0) {
                return;
            }
            StyleMap styleMap = new StyleMap(CSSEngine.this.getNumberOfProperties());
            int n2 = this.styleDeclaration.size();
            for (n = 0; n < n2; ++n) {
                int n3 = this.styleDeclaration.getIndex(n);
                styleMap.putValue(n3, this.styleDeclaration.getValue(n));
                styleMap.putImportant(n3, this.styleDeclaration.getPriority(n));
                styleMap.putOrigin(n3, 0x60000000);
            }
            this.styleDeclaration = null;
            n = CSSEngine.this.getPropertyIndex("font-family");
            Value value = styleMap.getValue(n);
            if (value == null) {
                return;
            }
            ParsedURL parsedURL = CSSEngine.this.getCSSBaseURI();
            CSSEngine.this.fontFaces.add(new FontFaceRule(styleMap, parsedURL));
        }

        @Override
        public void startMargin(String string) {
        }

        @Override
        public void endMargin() {
        }

        @Override
        public void startKeyframes(String string) {
            if (this.ignoredForRule == 0) {
                this.ignoredForRule = 7;
            }
        }

        @Override
        public void endKeyframes() {
            if (this.ignoredForRule == 7) {
                this.ignoredForRule = 0;
            }
        }

        @Override
        public void startKeyframe(LexicalUnit lexicalUnit) {
        }

        @Override
        public void endKeyframe() {
        }

        @Override
        public void startFontFeatures(String[] stringArray) {
            if (this.ignoredForRule == 0) {
                this.ignoredForRule = 14;
            }
        }

        @Override
        public void endFontFeatures() {
            if (this.ignoredForRule == 14) {
                this.ignoredForRule = 0;
            }
        }

        @Override
        public void startFeatureMap(String string) {
        }

        @Override
        public void endFeatureMap() {
        }

        @Override
        public void startProperty(String string) {
            if (this.ignoredForRule != 0) {
                return;
            }
            this.ignoredForRule = 18;
            if (CSSEngine.this.propertyDefinitionMap == null) {
                CSSEngine.this.propertyDefinitionMap = new HashMap();
            }
            this.currentPropertyDefinition = new PropertyDefinitionImpl(string);
        }

        @Override
        public void endProperty(boolean bl) {
            if (this.ignoredForRule != 18) {
                return;
            }
            if (!bl) {
                CSSEngine.this.propertyDefinitionMap.put(this.currentPropertyDefinition.getName(), this.currentPropertyDefinition);
            }
            this.currentPropertyDefinition = null;
            this.ignoredForRule = 0;
        }

        @Override
        public void startSupports(BooleanCondition booleanCondition) {
            if (this.ignoredForRule > 0) {
                return;
            }
            SupportsRule supportsRule = new SupportsRule(booleanCondition);
            CSSEngine.this.setSupports(supportsRule);
            supportsRule.setParent(this.styleSheet);
            this.styleSheet.append(supportsRule);
            this.styleSheet = supportsRule;
        }

        @Override
        public void endSupports(BooleanCondition booleanCondition) {
            if (this.ignoredForRule > 0) {
                return;
            }
            this.styleSheet = this.styleSheet.getParent();
        }

        @Override
        public void startViewport() {
            if (this.ignoredForRule == 0) {
                this.ignoredForRule = 15;
            }
        }

        @Override
        public void endViewport() {
            if (this.ignoredForRule == 15) {
                this.ignoredForRule = 0;
            }
        }

        @Override
        public void startSelector(SelectorList selectorList) {
            if (this.ignoredForRule > 0) {
                return;
            }
            this.styleRule = new StyleRule();
            this.styleRule.setSelectorList(selectorList);
            this.styleDeclaration = new StyleDeclaration();
            this.styleRule.setStyleDeclaration(this.styleDeclaration);
            this.styleSheet.append(this.styleRule);
        }

        @Override
        public void endSelector(SelectorList selectorList) {
            this.styleRule = null;
            this.styleDeclaration = null;
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            if (this.ignoredForRule > 0) {
                return;
            }
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                try {
                    CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
                }
                catch (Exception exception) {
                    if (CSSEngine.this.userAgent == null) {
                        throw exception;
                    }
                    CSSEngine.this.userAgent.displayError(exception);
                }
            } else {
                Value value;
                try {
                    value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                }
                catch (Exception exception) {
                    if (CSSEngine.this.userAgent == null) {
                        throw exception;
                    }
                    CSSEngine.this.userAgent.displayError(exception);
                    return;
                }
                this.styleDeclaration.append(value, n, bl);
            }
        }

        @Override
        public void lexicalProperty(String string, LexicalUnit lexicalUnit, boolean bl) {
            if (this.ignoredForRule == 18) {
                this.propertyRuleDescriptor(string, lexicalUnit, bl);
                return;
            }
            if (this.ignoredForRule > 0) {
                return;
            }
            this.styleDeclaration.setCustomProperty(string, lexicalUnit, bl);
        }

        private void propertyRuleDescriptor(String string, LexicalUnit lexicalUnit, boolean bl) {
            switch (string) {
                case "inherits": {
                    this.currentPropertyDefinition.setInherits(!"false".equalsIgnoreCase(lexicalUnit.getStringValue()));
                    break;
                }
                case "initial-value": {
                    this.currentPropertyDefinition.setInitialValue(lexicalUnit);
                    break;
                }
                case "syntax": {
                    CSSValueSyntax cSSValueSyntax;
                    String string2 = lexicalUnit.getStringValue();
                    if (string2 == null) {
                        string2 = "*";
                    }
                    SyntaxParser syntaxParser = new SyntaxParser();
                    try {
                        cSSValueSyntax = syntaxParser.parseSyntax(string2);
                    }
                    catch (Exception exception) {
                        cSSValueSyntax = syntaxParser.parseSyntax("*");
                    }
                    this.currentPropertyDefinition.setSyntax(cSSValueSyntax);
                }
            }
        }

        @Override
        public void pendingValue(String string, PendingValue pendingValue, boolean bl) {
            if (this.ignoredForRule > 0) {
                return;
            }
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n != -1) {
                this.styleDeclaration.append(pendingValue, n, bl);
            }
        }
    }
}

