/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.values;

import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.values.AnimatableValue;

public class AnimatableNumberValue
extends AnimatableValue {
    protected float value;

    protected AnimatableNumberValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableNumberValue(AnimationTarget animationTarget, float f) {
        super(animationTarget);
        this.value = f;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f, AnimatableValue animatableValue3, int n) {
        AnimatableNumberValue animatableNumberValue;
        AnimatableNumberValue animatableNumberValue2 = animatableValue == null ? new AnimatableNumberValue(this.target) : (AnimatableNumberValue)animatableValue;
        float f2 = this.value;
        if (animatableValue2 != null) {
            animatableNumberValue = (AnimatableNumberValue)animatableValue2;
            f2 += f * (animatableNumberValue.value - this.value);
        }
        if (animatableValue3 != null) {
            animatableNumberValue = (AnimatableNumberValue)animatableValue3;
            f2 += (float)n * animatableNumberValue.value;
        }
        if (animatableNumberValue2.value != f2) {
            animatableNumberValue2.value = f2;
            animatableNumberValue2.hasChanged = true;
        }
        return animatableNumberValue2;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public boolean canPace() {
        return true;
    }

    @Override
    public float distanceTo(AnimatableValue animatableValue) {
        AnimatableNumberValue animatableNumberValue = (AnimatableNumberValue)animatableValue;
        return Math.abs(this.value - animatableNumberValue.value);
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableNumberValue(this.target, 0.0f);
    }

    @Override
    public String getCssText() {
        return AnimatableNumberValue.formatNumber(this.value);
    }
}

