/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.NodeStyleDeclaration;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class InlineStyle
extends BaseCSSStyleDeclaration
implements NodeStyleDeclaration {
    private static final long serialVersionUID = 1L;
    private Node node = null;

    protected InlineStyle() {
    }

    protected InlineStyle(InlineStyle inlineStyle) {
        super(inlineStyle);
        this.setOwnerNode(inlineStyle.getOwnerNode());
    }

    @Override
    protected void writeShorthandCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext, String string, ShorthandValue shorthandValue) throws IOException {
        simpleWriter.write((CharSequence)string);
        styleFormattingContext.writeColon(simpleWriter);
        styleFormattingContext.writeShorthandValue(simpleWriter, string, shorthandValue);
        if (shorthandValue.isImportant()) {
            styleFormattingContext.writeImportantPriority(simpleWriter);
        }
        styleFormattingContext.writeSemiColon(simpleWriter);
        styleFormattingContext.endInlinePropertyDeclaration(simpleWriter);
    }

    @Override
    protected void writeLonghandCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext, String string, StyleValue styleValue, boolean bl) throws IOException {
        simpleWriter.write((CharSequence)string);
        styleFormattingContext.writeColon(simpleWriter);
        this.writeValue(simpleWriter, string, styleValue);
        if (bl) {
            styleFormattingContext.writeImportantPriority(simpleWriter);
        }
        styleFormattingContext.writeSemiColon(simpleWriter);
        styleFormattingContext.endInlinePropertyDeclaration(simpleWriter);
    }

    private void writeValue(SimpleWriter simpleWriter, String string, StyleValue styleValue) throws IOException {
        if (styleValue.getCssValueType() != CSSValue.CssType.TYPED || styleValue.getPrimitiveType() != CSSValue.Type.STRING) {
            styleValue.writeCssText(simpleWriter);
        } else {
            CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue);
            String string2 = cSSTypedValue.getStringValue();
            string2 = ParseHelper.escapeControl(string2);
            string2 = ParseHelper.quote(string2, '\'');
            simpleWriter.write((CharSequence)string2);
        }
    }

    @Override
    public Node getOwnerNode() {
        return this.node;
    }

    protected void setOwnerNode(Node node) {
        this.node = node;
    }

    public boolean hasOverrideStyle(Condition condition) {
        Node node = this.getOwnerNode();
        if (node != null) {
            short s = node.getNodeType();
            if (s == 2) {
                if ((node = ((Attr)node).getOwnerElement()) == null) {
                    return false;
                }
                s = node.getNodeType();
            }
            if (s == 1) {
                return ((CSSElement)node).hasOverrideStyle(condition);
            }
        }
        return false;
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        CSSElement cSSElement;
        Node node = this.getOwnerNode();
        if (node != null && (cSSElement = node.getNodeType() == 2 ? (CSSElement)((Attr)node).getOwnerElement() : (node.getNodeType() == 1 ? (CSSElement)node : null)) != null) {
            return cSSElement.getOwnerDocument().getErrorHandler().getInlineStyleErrorHandler(cSSElement);
        }
        return null;
    }

    @Override
    public abstract InlineStyle clone();
}

