/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.FontVariantBuilder;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import java.util.Locale;
import java.util.Set;

class FontBuilder
extends ShorthandBuilder {
    private boolean fontVariantDone = false;

    FontBuilder(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super("font", baseCSSStyleDeclaration);
    }

    @Override
    protected int getMinimumSetSize() {
        return 17;
    }

    @Override
    protected void preprocessSet() {
        this.addPropertyIfAssigned("font-variant-caps");
        this.addPropertyIfAssigned("font-variant-ligatures");
        this.addPropertyIfAssigned("font-variant-position");
        this.addPropertyIfAssigned("font-variant-numeric");
        this.addPropertyIfAssigned("font-variant-alternates");
        this.addPropertyIfAssigned("font-variant-east-asian");
    }

    private void addPropertyIfAssigned(String string) {
        BaseCSSStyleDeclaration baseCSSStyleDeclaration = this.getParentStyle();
        if (baseCSSStyleDeclaration.isPropertySet(string) && !this.isPropertyInAnySet(string)) {
            this.addAssignedProperty(string, baseCSSStyleDeclaration.isPropertyImportant(string));
        }
    }

    @Override
    boolean isInheritedProperty() {
        return true;
    }

    private void appendFontLonghand(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(':').append(this.getCSSValue(string).getMinifiedCssText(string));
        this.appendPriority(stringBuilder, this.isPropertyInImportantSet(string));
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        int n = this.appendFontShorthandSet(stringBuilder, set, bl);
        if (n == -1) {
            return 1;
        }
        if (n == 0) {
            Object object;
            if (!this.fontVariantDone) {
                object = this.createFontVariantBuilder();
                if (((ShorthandBuilder)object).checkValuesForType(CSSValue.Type.INTERNAL, bl) != 0) {
                    return 1;
                }
                if (!this.isFontVariantSetToInitialOrCss21(set)) {
                    ((ShorthandBuilder)object).appendMinifiedCssText(stringBuilder);
                    this.setFontVariantDone();
                }
            }
            object = this.getCSSValue("font-stretch");
            if (this.isPropertyAssigned("font-stretch", bl) && this.isNotInitialValue((StyleValue)object, "font-stretch") && !this.isFontStretchCss3((StyleValue)object)) {
                stringBuilder.append("font-stretch:").append(((StyleValue)object).getMinifiedCssText("font-stretch"));
                this.appendPriority(stringBuilder, this.isPropertyInImportantSet("font-stretch"));
            }
            if (this.isPropertyAssigned("font-kerning", bl) && !this.isInitialValue("font-kerning")) {
                this.appendFontLonghand(stringBuilder, "font-kerning");
            }
            if (this.isPropertyAssigned("font-optical-sizing", bl) && !this.isInitialValue("font-optical-sizing")) {
                this.appendFontLonghand(stringBuilder, "font-optical-sizing");
            }
            if (this.isPropertyAssigned("font-feature-settings", bl) && !this.isInitialValue("font-feature-settings")) {
                this.appendFontLonghand(stringBuilder, "font-feature-settings");
            }
            if (this.isPropertyAssigned("font-variation-settings", bl) && !this.isInitialValue("font-variation-settings")) {
                this.appendFontLonghand(stringBuilder, "font-variation-settings");
            }
            if (this.isPropertyAssigned("font-size-adjust", bl) && !this.isInitialValue("font-size-adjust")) {
                this.appendFontLonghand(stringBuilder, "font-size-adjust");
            }
        } else {
            CSSValue.Type type;
            switch (n) {
                case 1: {
                    type = CSSValue.Type.INHERIT;
                    break;
                }
                case 2: {
                    type = CSSValue.Type.UNSET;
                    break;
                }
                default: {
                    type = CSSValue.Type.REVERT;
                }
            }
            this.appendLonghandIfNotKeyword(stringBuilder, "font-kerning", type, bl);
            this.appendLonghandIfNotKeyword(stringBuilder, "font-optical-sizing", type, bl);
            this.appendLonghandIfNotKeyword(stringBuilder, "font-feature-settings", type, bl);
            this.appendLonghandIfNotKeyword(stringBuilder, "font-variation-settings", type, bl);
            this.appendLonghandIfNotKeyword(stringBuilder, "font-size-adjust", type, bl);
            FontVariantBuilder fontVariantBuilder = this.createFontVariantBuilder();
            fontVariantBuilder.preprocessSet();
            if (fontVariantBuilder.checkValuesForType(CSSValue.Type.INTERNAL, bl) != 0) {
                return 1;
            }
            byte by = fontVariantBuilder.checkValuesForType(type, bl);
            if (by == 2) {
                return 1;
            }
            if (by == 0 && !this.fontVariantDone && !this.isFontVariantSetToInitialOrCss21(set)) {
                fontVariantBuilder.appendMinifiedCssText(stringBuilder);
                this.setFontVariantDone();
            }
        }
        return 0;
    }

    private int appendFontShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        byte by;
        byte by2;
        stringBuilder.append(this.getShorthandName()).append(':');
        StyleValue styleValue = this.getCSSValue("font-variant-caps");
        StyleValue styleValue2 = this.getCSSValue("font-style");
        StyleValue styleValue3 = this.getCSSValue("font-weight");
        StyleValue styleValue4 = this.getCSSValue("font-stretch");
        StyleValue styleValue5 = this.getCSSValue("font-size");
        StyleValue styleValue6 = this.getCSSValue("font-family");
        StyleValue styleValue7 = this.getCSSValue("line-height");
        if (set.size() >= 7) {
            by2 = this.checkValuesForInherit(styleValue, styleValue2, styleValue3, styleValue4, styleValue5, styleValue6, styleValue7);
            if (by2) {
                stringBuilder.append("inherit");
                this.appendPriority(stringBuilder, bl);
                return 1;
            }
            if (by2 == 2) {
                return -1;
            }
            if (this.checkValuesForInitial(styleValue2, styleValue, styleValue3, styleValue4, styleValue5, styleValue6, styleValue7)) {
                stringBuilder.append("normal");
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
            by = this.checkValuesForKeyword(CSSValue.Type.UNSET, styleValue, styleValue2, styleValue3, styleValue4, styleValue5, styleValue6, styleValue7);
            if (by == 1) {
                stringBuilder.append("unset");
                this.appendPriority(stringBuilder, bl);
                return 2;
            }
            if (by == 2) {
                return -1;
            }
            by = this.checkValuesForKeyword(CSSValue.Type.REVERT, styleValue, styleValue2, styleValue3, styleValue4, styleValue5, styleValue6, styleValue7);
            if (by == 1) {
                stringBuilder.append("revert");
                this.appendPriority(stringBuilder, bl);
                return 3;
            }
            if (by == 2) {
                return -1;
            }
        }
        by2 = 0;
        if (set.contains("font-style")) {
            by2 = this.appendValueIfNotInitial(stringBuilder, "font-style", styleValue2, by2 != 0);
        }
        if (set.contains("font-variant-caps") && this.isFontVariantCss21(styleValue)) {
            by2 = this.appendValueIfNotInitial(stringBuilder, "font-variant-caps", styleValue, by2 != 0);
        }
        if (set.contains("font-weight")) {
            by2 = this.appendValueIfNotInitial(stringBuilder, "font-weight", styleValue3, by2 != 0);
        }
        if (set.contains("font-size") || set.contains("line-height") || set.contains("font-family") || set.contains("font-stretch")) {
            boolean bl2;
            by = this.isNotInitialValue(styleValue7, "line-height");
            boolean bl3 = this.isNotInitialValue(styleValue5, "font-size");
            boolean bl4 = this.isNotInitialValue(styleValue4, "font-stretch") && this.isFontStretchCss3(styleValue4);
            boolean bl5 = bl2 = !styleValue6.isSystemDefault() && !this.isEffectiveInitialKeyword(styleValue6);
            if (bl3 || by != 0 || bl4) {
                String string = bl3 ? styleValue5.getMinifiedCssText("font-size") : "medium";
                if (!bl2) {
                    if (!by2) {
                        stringBuilder.append("normal");
                    }
                    this.appendPriority(stringBuilder, bl);
                    if (bl4 && set.contains("font-stretch")) {
                        stringBuilder.append("font-stretch:");
                        stringBuilder.append(styleValue4.getMinifiedCssText("font-stretch"));
                        this.appendPriority(stringBuilder, bl);
                    }
                    if (bl3 && set.contains("font-size")) {
                        stringBuilder.append("font-size:");
                        stringBuilder.append(string);
                        this.appendPriority(stringBuilder, bl);
                    }
                    if (by != 0 && set.contains("line-height")) {
                        stringBuilder.append("line-height:");
                        stringBuilder.append(styleValue7.getMinifiedCssText("line-height"));
                        this.appendPriority(stringBuilder, bl);
                    }
                    return 0;
                }
                if (bl4 && set.contains("font-stretch")) {
                    by2 = this.appendValueIfNotInitial(stringBuilder, "font-stretch", styleValue4, by2 != 0);
                }
                if (by2) {
                    stringBuilder.append(' ');
                } else {
                    by2 = 1;
                }
                stringBuilder.append(string);
                if (by != 0) {
                    stringBuilder.append('/').append(styleValue7.getMinifiedCssText("line-height"));
                }
                stringBuilder.append(' ');
                stringBuilder.append(styleValue6.getMinifiedCssText("font-family"));
            } else if (bl2) {
                if (!by2) {
                    stringBuilder.append("normal");
                }
                this.appendPriority(stringBuilder, bl);
                stringBuilder.append("font-family:");
                stringBuilder.append(styleValue6.getMinifiedCssText("font-family"));
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
        }
        if (!by2) {
            stringBuilder.append("normal");
        }
        this.appendPriority(stringBuilder, bl);
        return 0;
    }

    private boolean appendValueIfNotInitial(StringBuilder stringBuilder, String string, StyleValue styleValue, boolean bl) {
        String string2 = this.getValueTextIfNotInitial(string, styleValue);
        if (string2 != null) {
            if (bl) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2);
            return true;
        }
        return bl;
    }

    private void appendLonghandIfNotKeyword(StringBuilder stringBuilder, String string, CSSValue.Type type, boolean bl) {
        StyleValue styleValue = this.getCSSValue(string);
        if (styleValue.getPrimitiveType() != type && this.isPropertyAssigned(string, bl)) {
            stringBuilder.append(string).append(':');
            stringBuilder.append(styleValue.getMinifiedCssText(string));
            this.appendPriority(stringBuilder, bl);
        }
    }

    private byte checkValuesForInherit(StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3, StyleValue styleValue4, StyleValue styleValue5, StyleValue styleValue6, StyleValue styleValue7) {
        int n = 0;
        if (this.isInherit(styleValue)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue2)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue3)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue4)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue5)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue6)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue7)) {
            n = (byte)(n + 1);
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkValuesForKeyword(CSSValue.Type type, StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3, StyleValue styleValue4, StyleValue styleValue5, StyleValue styleValue6, StyleValue styleValue7) {
        int n = 0;
        if (FontBuilder.isCssValueOfType(type, styleValue)) {
            n = (byte)(n + 1);
        }
        if (FontBuilder.isCssValueOfType(type, styleValue2)) {
            n = (byte)(n + 1);
        }
        if (FontBuilder.isCssValueOfType(type, styleValue3)) {
            n = (byte)(n + 1);
        }
        if (FontBuilder.isCssValueOfType(type, styleValue4)) {
            n = (byte)(n + 1);
        }
        if (FontBuilder.isCssValueOfType(type, styleValue5)) {
            n = (byte)(n + 1);
        }
        if (FontBuilder.isCssValueOfType(type, styleValue6)) {
            n = (byte)(n + 1);
        }
        if (FontBuilder.isCssValueOfType(type, styleValue7)) {
            n = (byte)(n + 1);
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private boolean checkValuesForInitial(StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3, StyleValue styleValue4, StyleValue styleValue5, StyleValue styleValue6, StyleValue styleValue7) {
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, styleValue) && this.isNotInitialValue(styleValue, "font-style")) {
            return false;
        }
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, styleValue2) && this.isNotInitialValue(styleValue2, "font-variant")) {
            return false;
        }
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, styleValue3) && this.isNotInitialValue(styleValue3, "font-weight")) {
            return false;
        }
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, styleValue4) && this.isNotInitialValue(styleValue4, "font-stretch")) {
            return false;
        }
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, styleValue5) && this.isNotInitialValue(styleValue5, "font-size")) {
            return false;
        }
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, styleValue6) && this.isNotInitialValue(styleValue6, "font-family")) {
            return false;
        }
        return FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, styleValue7) || !this.isNotInitialValue(styleValue7, "line-height");
    }

    private boolean isFontVariantCss21(StyleValue styleValue) {
        String string = styleValue.getCssText().toLowerCase(Locale.ROOT);
        return string.equals("normal") || string.equals("small-caps") || string.equals("initial");
    }

    private boolean isFontStretchCss3(StyleValue styleValue) {
        String string = styleValue.getCssText().toLowerCase(Locale.ROOT);
        return string.equals("normal") || string.equals("ultra-condensed") || string.equals("extra-condensed") || string.equals("condensed") || string.equals("semi-condensed") || string.equals("semi-expanded") || string.equals("expanded") || string.equals("extra-expanded") || string.equals("ultra-expanded") || string.equals("initial");
    }

    private boolean isFontVariantSetToInitialOrCss21(Set<String> set) {
        if (!set.contains("font-variant-caps")) {
            return true;
        }
        StyleValue styleValue = this.getCSSValue("font-variant-caps");
        String string = styleValue.getCssText();
        if (this.isEffectiveInitialKeyword(styleValue) || string.equalsIgnoreCase("normal") || string.equalsIgnoreCase("small-caps")) {
            return !(set.contains("font-variant-ligatures") && !this.isInitialValue("font-variant-ligatures") || set.contains("font-variant-position") && !this.isInitialValue("font-variant-position") || set.contains("font-variant-numeric") && !this.isInitialValue("font-variant-numeric") || set.contains("font-variant-alternates") && !this.isInitialValue("font-variant-alternates") || set.contains("font-variant-east-asian") && !this.isInitialValue("font-variant-east-asian"));
        }
        return false;
    }

    private FontVariantBuilder createFontVariantBuilder() {
        BaseCSSStyleDeclaration baseCSSStyleDeclaration = this.getParentStyle();
        FontVariantBuilder fontVariantBuilder = new FontVariantBuilder(baseCSSStyleDeclaration);
        this.addPropertyIfAssigned(fontVariantBuilder, "font-variant-ligatures");
        this.addPropertyIfAssigned(fontVariantBuilder, "font-variant-caps");
        this.addPropertyIfAssigned(fontVariantBuilder, "font-variant-position");
        this.addPropertyIfAssigned(fontVariantBuilder, "font-variant-numeric");
        this.addPropertyIfAssigned(fontVariantBuilder, "font-variant-alternates");
        this.addPropertyIfAssigned(fontVariantBuilder, "font-variant-east-asian");
        return fontVariantBuilder;
    }

    private void setFontVariantDone() {
        this.fontVariantDone = true;
        this.removeAssignedProperty("font-variant-ligatures");
        this.removeAssignedProperty("font-variant-caps");
        this.removeAssignedProperty("font-variant-position");
        this.removeAssignedProperty("font-variant-numeric");
        this.removeAssignedProperty("font-variant-alternates");
        this.removeAssignedProperty("font-variant-east-asian");
    }

    private void addPropertyIfAssigned(ShorthandBuilder shorthandBuilder, String string) {
        BaseCSSStyleDeclaration baseCSSStyleDeclaration = this.getParentStyle();
        if (baseCSSStyleDeclaration.isPropertySet(string)) {
            shorthandBuilder.addAssignedProperty(string, baseCSSStyleDeclaration.isPropertyImportant(string));
        }
    }
}

