/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.SelectorSerializer;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.dom.DOMException;

public abstract class CSSStyleDeclarationRule
extends BaseCSSDeclarationRule {
    private static final long serialVersionUID = 1L;
    private SelectorList selectorList = null;
    private String selectorText = "";

    protected CSSStyleDeclarationRule(AbstractCSSStyleSheet abstractCSSStyleSheet, short s, byte by) {
        super(abstractCSSStyleSheet, s, by);
    }

    CSSStyleDeclarationRule() {
    }

    public String getSelectorText() {
        return this.selectorText;
    }

    void setSelectorText(String string) throws DOMException {
        this.selectorText = string;
    }

    public void setSelectorList(SelectorList selectorList) {
        if (selectorList == null) {
            throw new NullPointerException("Null selector list");
        }
        if (selectorList.getLength() == 0) {
            throw new IllegalArgumentException("Empty selector list");
        }
        this.selectorList = selectorList;
        this.updateSelectorText();
    }

    void updateSelectorText() {
        int n = this.selectorList.getLength();
        StringBuilder stringBuilder = new StringBuilder(n * 7 + 5);
        if (n > 0) {
            SelectorSerializer selectorSerializer = new SelectorSerializer(this.getParentStyleSheet());
            selectorSerializer.selectorListText(stringBuilder, this.selectorList, false, false);
        }
        this.selectorText = stringBuilder.toString();
    }

    SelectorList getSelectorList() {
        return this.selectorList;
    }

    @Override
    public void setCssText(String string) throws DOMException {
        this.clear();
        this.selectorList = null;
        this.selectorText = "";
        CSSParser cSSParser = (CSSParser)this.createSACParser();
        StringReader stringReader = new StringReader(string);
        RuleHandler ruleHandler = new RuleHandler();
        ruleHandler.setLexicalPropertyListener(this.getLexicalPropertyListener());
        cSSParser.setDocumentHandler(ruleHandler);
        cSSParser.setErrorHandler(ruleHandler);
        try {
            this.parseRule((Reader)stringReader, cSSParser);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        String string = this.getSelectorText();
        if (string.length() != 0) {
            styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
            simpleWriter.write((CharSequence)string);
            styleFormattingContext.updateContext(this);
            styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
            styleFormattingContext.startStyleDeclaration(simpleWriter);
            this.getStyle().writeCssText(simpleWriter, styleFormattingContext);
            styleFormattingContext.endCurrentContext(this);
            styleFormattingContext.endStyleDeclaration(simpleWriter);
            styleFormattingContext.writeRightCurlyBracket(simpleWriter);
            styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
        }
    }

    @Override
    public String getMinifiedCssText() {
        String string = this.getSelectorText();
        if (string.length() != 0) {
            return string + '{' + this.getStyle().getMinifiedCssText() + '}';
        }
        return "";
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.selectorList == null ? 0 : this.selectorList.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CSSStyleDeclarationRule)) {
            return false;
        }
        CSSStyleDeclarationRule cSSStyleDeclarationRule = (CSSStyleDeclarationRule)object;
        if (!super.equals(cSSStyleDeclarationRule)) {
            return false;
        }
        return !(this.selectorList == null ? cSSStyleDeclarationRule.selectorList != null : !this.selectorList.equals(cSSStyleDeclarationRule.selectorList));
    }

    @Override
    public CSSStyleDeclarationRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) throws IllegalArgumentException {
        CSSStyleDeclarationRule cSSStyleDeclarationRule;
        Constructor<?> constructor;
        Class[] classArray = new Class[]{AbstractCSSStyleSheet.class, Byte.TYPE};
        try {
            constructor = this.getClass().getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException);
        }
        Object[] objectArray = new Object[]{abstractCSSStyleSheet, this.getOrigin()};
        try {
            cSSStyleDeclarationRule = (CSSStyleDeclarationRule)constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(invocationTargetException);
        }
        String string = this.getParentStyleSheet().getHref();
        cSSStyleDeclarationRule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), string);
        cSSStyleDeclarationRule.selectorList = this.getSelectorList();
        cSSStyleDeclarationRule.selectorText = this.getSelectorText();
        if (this.hasErrorsOrWarnings()) {
            cSSStyleDeclarationRule.setStyleDeclarationErrorHandler(this.getStyleDeclarationErrorHandler());
        }
        return cSSStyleDeclarationRule;
    }

    private class RuleHandler
    extends BaseCSSDeclarationRule.DeclarationRuleCSSHandler {
        private RuleHandler() {
        }

        @Override
        public void startSelector(SelectorList selectorList) throws DOMException {
            if (CSSStyleDeclarationRule.this.selectorList != null) {
                throw new DOMException(3, "Rule already set, stream contains more than one rule");
            }
            CSSStyleDeclarationRule.this.setSelectorList(selectorList);
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            try {
                super.property(string, lexicalUnit, bl);
            }
            catch (DOMException dOMException) {
                CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException(dOMException);
                cSSPropertyValueException.setValueText(lexicalUnit.toString());
                CSSStyleDeclarationRule.this.getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
            }
        }

        @Override
        public void warning(CSSParseException cSSParseException) throws CSSParseException {
            if (CSSStyleDeclarationRule.this.selectorList != null) {
                super.warning(cSSParseException);
            } else {
                AbstractCSSStyleSheet abstractCSSStyleSheet = CSSStyleDeclarationRule.this.getParentStyleSheet();
                if (abstractCSSStyleSheet != null) {
                    abstractCSSStyleSheet.getErrorHandler().ruleParseWarning(CSSStyleDeclarationRule.this, cSSParseException);
                }
            }
        }

        @Override
        public void error(CSSParseException cSSParseException) throws CSSParseException {
            if (CSSStyleDeclarationRule.this.selectorList != null) {
                super.error(cSSParseException);
            } else {
                AbstractCSSStyleSheet abstractCSSStyleSheet = CSSStyleDeclarationRule.this.getParentStyleSheet();
                if (abstractCSSStyleSheet != null) {
                    abstractCSSStyleSheet.getErrorHandler().ruleParseError(CSSStyleDeclarationRule.this, cSSParseException);
                }
            }
        }
    }
}

