/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.CompatStyleDeclaration;
import io.sf.carte.doc.style.css.om.DefaultStyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.LexicalPropertyListener;
import io.sf.carte.doc.style.css.om.PropertyCSSHandler;
import io.sf.carte.doc.style.css.om.WrappedCSSStyleDeclaration;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.StyleValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.dom.DOMException;

public abstract class BaseCSSDeclarationRule
extends BaseCSSRule
implements CSSDeclarationRule {
    private static final long serialVersionUID = 1L;
    private BaseCSSStyleDeclaration declaration = null;
    private StyleDeclarationErrorHandler sdErrorHandler = null;

    protected BaseCSSDeclarationRule(AbstractCSSStyleSheet abstractCSSStyleSheet, short s, byte by) {
        super(abstractCSSStyleSheet, s, by);
        this.declaration = this.createStyleDeclaration(abstractCSSStyleSheet);
    }

    BaseCSSStyleDeclaration createStyleDeclaration(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        return (BaseCSSStyleDeclaration)abstractCSSStyleSheet.createStyleDeclaration(this);
    }

    BaseCSSDeclarationRule() {
        super(null, (short)1, (byte)0);
        this.declaration = new BaseCSSStyleDeclaration(this);
        this.sdErrorHandler = new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public AbstractCSSStyleDeclaration getStyle() {
        return this.declaration;
    }

    @Override
    void setRule(AbstractCSSRule abstractCSSRule) {
        BaseCSSDeclarationRule baseCSSDeclarationRule = (BaseCSSDeclarationRule)abstractCSSRule;
        this.setPrecedingComments(abstractCSSRule.getPrecedingComments());
        this.setTrailingComments(abstractCSSRule.getTrailingComments());
        this.declaration.setProperties(baseCSSDeclarationRule.declaration);
    }

    @Override
    void clear() {
        this.declaration.clear();
        this.resetComments();
    }

    void startAtRule(String string, String string2) {
    }

    LexicalPropertyListener getLexicalPropertyListener() {
        return this.declaration;
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        if (this.sdErrorHandler == null) {
            this.sdErrorHandler = this.getParentStyleSheet().getStyleSheetFactory().createStyleDeclarationErrorHandler(this);
        }
        return this.sdErrorHandler;
    }

    @Override
    boolean hasErrorsOrWarnings() {
        return this.sdErrorHandler != null && (this.sdErrorHandler.hasErrors() || this.sdErrorHandler.hasWarnings());
    }

    public void setStyleDeclarationErrorHandler(StyleDeclarationErrorHandler styleDeclarationErrorHandler) {
        this.sdErrorHandler = styleDeclarationErrorHandler;
    }

    public int hashCode() {
        int n = 31;
        int n2 = Short.hashCode(this.getType());
        n2 = 31 * n2 + (this.declaration == null ? 0 : this.declaration.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BaseCSSDeclarationRule baseCSSDeclarationRule = (BaseCSSDeclarationRule)object;
        if (this.declaration == null) {
            return baseCSSDeclarationRule.declaration == null;
        }
        return this.declaration.equals(baseCSSDeclarationRule.declaration);
    }

    @Override
    public BaseCSSDeclarationRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) throws IllegalArgumentException {
        BaseCSSDeclarationRule baseCSSDeclarationRule;
        Constructor<?> constructor;
        Class[] classArray = new Class[]{AbstractCSSStyleSheet.class, Byte.TYPE};
        try {
            constructor = this.getClass().getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException);
        }
        Object[] objectArray = new Object[]{abstractCSSStyleSheet, this.getOrigin()};
        try {
            baseCSSDeclarationRule = (BaseCSSDeclarationRule)constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(invocationTargetException);
        }
        String string = this.getParentStyleSheet().getHref();
        baseCSSDeclarationRule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), string);
        return baseCSSDeclarationRule;
    }

    void setWrappedStyle(BaseCSSStyleDeclaration baseCSSStyleDeclaration, String string) {
        this.declaration = !(baseCSSStyleDeclaration instanceof CompatStyleDeclaration) ? new StyleWrapper(baseCSSStyleDeclaration, string) : new CompatStyleWrapper((CompatStyleDeclaration)baseCSSStyleDeclaration, string);
    }

    private class CompatStyleWrapper
    extends CompatStyleDeclaration {
        private static final long serialVersionUID = 1L;
        private final String hrefcontext;
        private final String oldHrefContext;

        private CompatStyleWrapper(CompatStyleDeclaration compatStyleDeclaration, String string) {
            super(compatStyleDeclaration);
            this.hrefcontext = WrappedCSSStyleDeclaration.getHrefContext(this.getParentRule());
            this.oldHrefContext = string;
        }

        @Override
        protected StyleValue getCSSValue(String string) {
            StyleValue styleValue = super.getCSSValue(string);
            if (styleValue != null) {
                styleValue = WrappedCSSStyleDeclaration.wrapCSSValue(styleValue, this.oldHrefContext, this.hrefcontext);
            }
            return styleValue;
        }

        @Override
        public BaseCSSDeclarationRule getParentRule() {
            return BaseCSSDeclarationRule.this;
        }
    }

    class DeclarationRuleCSSHandler
    extends PropertyCSSHandler
    implements CSSParser.DeclarationRuleHandler {
        private boolean ruleStarted = false;
        private boolean ruleEnded = false;

        DeclarationRuleCSSHandler() {
        }

        @Override
        public void startAtRule(String string, String string2) {
            BaseCSSDeclarationRule.this.startAtRule(string, string2);
            this.ruleStarted = true;
        }

        @Override
        public void endAtRule() {
            this.ruleEnded = true;
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            block2: {
                try {
                    super.property(string, lexicalUnit, bl);
                }
                catch (DOMException dOMException) {
                    if (BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler() == null) break block2;
                    CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException(dOMException);
                    cSSPropertyValueException.setValueText(lexicalUnit.toString());
                    BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
                }
            }
        }

        @Override
        public void comment(String string, boolean bl) {
            if (!this.ruleStarted) {
                if (BaseCSSDeclarationRule.this.getPrecedingComments() == null) {
                    BaseCSSDeclarationRule.this.setPrecedingComments(new LinkedStringList());
                }
                BaseCSSDeclarationRule.this.getPrecedingComments().add(string);
            } else if (!bl && this.ruleEnded) {
                if (BaseCSSDeclarationRule.this.getTrailingComments() == null) {
                    BaseCSSDeclarationRule.this.setTrailingComments(new LinkedStringList());
                }
                BaseCSSDeclarationRule.this.getTrailingComments().add(string);
            }
        }

        @Override
        public void warning(CSSParseException cSSParseException) throws CSSParseException {
            BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler().sacWarning(cSSParseException, BaseCSSDeclarationRule.this.getStyle().getLength() - 1);
        }

        @Override
        public void error(CSSParseException cSSParseException) throws CSSParseException {
            BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler().sacError(cSSParseException, BaseCSSDeclarationRule.this.getStyle().getLength() - 1);
        }
    }

    private class StyleWrapper
    extends WrappedCSSStyleDeclaration {
        private static final long serialVersionUID = 1L;

        private StyleWrapper(BaseCSSStyleDeclaration baseCSSStyleDeclaration, String string) {
            super(baseCSSStyleDeclaration, string);
        }

        @Override
        public BaseCSSDeclarationRule getParentRule() {
            return BaseCSSDeclarationRule.this;
        }
    }
}

