/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNamedNodeMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.LexicalHandler;

public class XMLDocumentBuilder
extends DocumentBuilder {
    private final DOMImplementation domImpl;
    private final SAXParserFactory parserFactory;
    private XMLReader xmlReader = null;
    private EntityResolver resolver = null;
    private ErrorHandler errorHandler = null;
    private boolean strictErrorChecking = false;
    private boolean htmlProcessing = false;
    private boolean ignoreElementContentWhitespace = false;
    private boolean ignoreNotSpecifiedAttributes = true;
    private static final HashSet<String> headChildList = new HashSet(8);

    public XMLDocumentBuilder(DOMImplementation dOMImplementation) {
        this(dOMImplementation, SAXParserFactory.newInstance());
        this.parserFactory.setNamespaceAware(true);
        try {
            this.parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.parserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.parserFactory.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
    }

    public XMLDocumentBuilder(DOMImplementation dOMImplementation, SAXParserFactory sAXParserFactory) {
        this.domImpl = dOMImplementation;
        this.parserFactory = sAXParserFactory;
        if (dOMImplementation instanceof CSSDOMImplementation) {
            this.strictErrorChecking = ((CSSDOMImplementation)dOMImplementation).getStrictErrorChecking();
        }
    }

    @Override
    public Document parse(InputSource inputSource) throws SAXException, IOException {
        XMLReader xMLReader = this.xmlReader == null ? this.createXMLReader() : this.xmlReader;
        return this.parse(inputSource, xMLReader);
    }

    private XMLReader createXMLReader() throws SAXException {
        SAXParser sAXParser;
        try {
            sAXParser = this.parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        XMLReader xMLReader = sAXParser.getXMLReader();
        if (this.resolver != null) {
            xMLReader.setEntityResolver(this.resolver);
        } else {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                xMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
        }
        return xMLReader;
    }

    private Document parse(InputSource inputSource, XMLReader xMLReader) throws SAXException, IOException {
        boolean bl = true;
        XMLContentHandler xMLContentHandler = this.htmlProcessing ? new XHTMLContentHandler(xMLReader) : new XMLContentHandler(xMLReader);
        xMLContentHandler.setSystemId(inputSource.getSystemId());
        xMLReader.setContentHandler(xMLContentHandler);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", xMLContentHandler);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        if (this.errorHandler != null) {
            xMLReader.setErrorHandler(this.errorHandler);
        } else if (xMLReader.getErrorHandler() == null) {
            xMLReader.setErrorHandler(xMLContentHandler);
        } else {
            bl = false;
        }
        xMLReader.parse(inputSource);
        Document document = xMLContentHandler.getDocument();
        xMLReader.setContentHandler(null);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", null);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        if (bl) {
            xMLReader.setErrorHandler(null);
        }
        return document;
    }

    @Override
    public boolean isNamespaceAware() {
        return this.parserFactory.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this.parserFactory.isValidating();
    }

    @Override
    public boolean isXIncludeAware() {
        return this.parserFactory.isXIncludeAware();
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public Document newDocument() {
        return this.createDocument("", null, null, null);
    }

    private Document createDocument(String string, String string2, DocumentType documentType, String string3) throws DOMException {
        if (documentType != null && "html".equals(documentType.getName()) && string != null && string.length() == 0) {
            string = null;
        }
        Document document = this.domImpl.createDocument(string, string2, documentType);
        document.setStrictErrorChecking(this.strictErrorChecking);
        document.setDocumentURI(string3);
        return document;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.domImpl;
    }

    public SAXParserFactory getSAXParserFactory() {
        return this.parserFactory;
    }

    @Override
    public Schema getSchema() {
        return this.parserFactory.getSchema();
    }

    public void setHTMLProcessing(boolean bl) {
        this.htmlProcessing = bl;
    }

    public void setIgnoreElementContentWhitespace(boolean bl) {
        this.ignoreElementContentWhitespace = bl;
    }

    public void setIgnoreNotSpecifiedAttributes(boolean bl) {
        this.ignoreNotSpecifiedAttributes = bl;
    }

    public void setStrictErrorChecking(boolean bl) {
        this.strictErrorChecking = bl;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.xmlReader = xMLReader;
    }

    @Override
    public void reset() {
        this.strictErrorChecking = this.domImpl instanceof CSSDOMImplementation ? ((CSSDOMImplementation)this.domImpl).getStrictErrorChecking() : false;
        this.ignoreElementContentWhitespace = false;
        this.resolver = null;
        this.errorHandler = null;
    }

    private static boolean isHeadChild(String string) {
        return headChildList.contains(string);
    }

    static {
        headChildList.add("base");
        headChildList.add("link");
        headChildList.add("meta");
        headChildList.add("noscript");
        headChildList.add("script");
        headChildList.add("style");
        headChildList.add("template");
        headChildList.add("title");
    }

    private static class MockCommentNode
    extends MockNode {
        MockCommentNode(String string) {
            super(string);
        }

        @Override
        short getNodeType() {
            return 8;
        }
    }

    static abstract class MockNode {
        String data = null;

        MockNode(String string) {
            this.data = string;
        }

        abstract short getNodeType();

        String getData() {
            return this.data;
        }
    }

    private static class MockProcessingInstruction
    extends MockNode {
        String target = null;

        MockProcessingInstruction(String string, String string2) {
            super(string2);
            this.target = string;
        }

        @Override
        short getNodeType() {
            return 7;
        }

        String getTarget() {
            return this.target;
        }
    }

    private class XHTMLContentHandler
    extends XMLContentHandler {
        private boolean headPending;
        private boolean bodyPending;
        private boolean headImplicit;
        private boolean bodyImplicit;

        XHTMLContentHandler(XMLReader xMLReader) {
            super(xMLReader);
            this.headPending = true;
            this.bodyPending = true;
            this.headImplicit = false;
            this.bodyImplicit = false;
        }

        @Override
        void documentElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            boolean bl;
            boolean bl2 = bl = "http://www.w3.org/1999/xhtml".equals(string) || this.documentType != null && "html".equalsIgnoreCase(this.documentType.getName());
            if (!"html".equals(string2) && bl) {
                String string4 = "html";
                if (!string3.equalsIgnoreCase(string2)) {
                    int n = string3.indexOf(58, 1);
                    if (n != -1) {
                        string4 = string3.substring(0, n) + ":html";
                    } else {
                        this.error("Bad qName: " + string3);
                    }
                }
                this.document = XMLDocumentBuilder.this.createDocument(string, string4, this.documentType, this.systemId);
                this.currentNode = this.document.getDocumentElement();
                this.newElement(string, string2, string3, attributes);
            } else {
                this.document = XMLDocumentBuilder.this.createDocument(string, string3, this.documentType, this.systemId);
                Element element = this.document.getDocumentElement();
                this.currentNode = element;
                this.setAttributes(element, attributes);
                if (!bl) {
                    this.headPending = false;
                    this.bodyPending = false;
                }
            }
        }

        @Override
        void newElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Element element = this.document.createElementNS(string, string3);
            this.setAttributes(element, attributes);
            if (this.headPending && this.currentNode.getParentNode() == this.document) {
                if ("head".equals(string3)) {
                    this.appendChild(element);
                    this.headPending = false;
                    this.currentNode = element;
                    return;
                }
                if (XMLDocumentBuilder.isHeadChild(string3)) {
                    Element element2 = this.document.createElementNS(string, "head");
                    this.currentNode.appendChild(element2);
                    element2.appendChild(element);
                    this.headImplicit = true;
                    this.headPending = false;
                    this.currentNode = element;
                    return;
                }
            }
            if (this.bodyPending && (this.currentNode.getParentNode() == this.document || this.headImplicit && this.currentNode.getParentNode().getParentNode() == this.document)) {
                if ("body".equals(string3)) {
                    if (this.headImplicit) {
                        this.currentNode = this.currentNode.getParentNode();
                        this.headImplicit = false;
                    } else {
                        this.headPending = false;
                    }
                    this.bodyPending = false;
                } else if (!XMLDocumentBuilder.isHeadChild(string3)) {
                    if (this.headImplicit) {
                        this.currentNode = this.currentNode.getParentNode();
                        this.headImplicit = false;
                    } else {
                        this.headPending = false;
                    }
                    Element element3 = this.document.createElementNS(string, "body");
                    this.currentNode.appendChild(element3);
                    element3.appendChild(element);
                    this.currentNode = element;
                    this.bodyPending = false;
                    this.bodyImplicit = true;
                    return;
                }
            }
            this.appendChild(element);
            this.currentNode = element;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            this.currentNode = this.currentNode.getParentNode();
            if ((this.bodyImplicit || this.headImplicit) && "html".equals(this.currentNode.getNodeName())) {
                this.currentNode = this.currentNode.getParentNode();
            }
        }
    }

    private class XMLContentHandler
    implements ContentHandler,
    LexicalHandler,
    ErrorHandler {
        String systemId = null;
        Document document = null;
        DocumentType documentType = null;
        private LinkedList<MockNode> preDocTypeNodes = null;
        private LinkedList<MockNode> preDocElementNodes = null;
        Node currentNode = null;
        private Locator lastLocator = null;
        private boolean cdata = false;
        private boolean endDTD = true;
        private final boolean ignoreECW;
        final boolean isNativeDOM;
        final boolean hasAttributes2;
        private final AttributeProcessor attrProcessor;

        XMLContentHandler(XMLReader xMLReader) {
            this.ignoreECW = XMLDocumentBuilder.this.ignoreElementContentWhitespace;
            this.isNativeDOM = XMLDocumentBuilder.this.domImpl instanceof CSSDOMImplementation;
            this.hasAttributes2 = this.hasAttributes2Feature(xMLReader);
            this.attrProcessor = XMLDocumentBuilder.this.ignoreNotSpecifiedAttributes ? new AttributeProcessor() : new NotSpecifiedAttributeProcessor();
        }

        void setSystemId(String string) {
            this.systemId = string;
        }

        private boolean hasAttributes2Feature(XMLReader xMLReader) {
            boolean bl;
            try {
                bl = xMLReader.getFeature("http://xml.org/sax/features/use-attributes2");
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                bl = false;
            }
            return bl;
        }

        Document getDocument() {
            return this.document;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.lastLocator = locator;
        }

        @Override
        public void startDocument() throws SAXException {
            this.document = null;
        }

        @Override
        public void endDocument() throws SAXException {
            this.currentNode = null;
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.document == null) {
                this.documentElement(string, string2, string3, attributes);
                this.insertPreDocElementNodes();
            } else {
                this.newElement(string, string2, string3, attributes);
            }
        }

        void documentElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.document = XMLDocumentBuilder.this.createDocument(string, string3, this.documentType, this.systemId);
            Element element = this.document.getDocumentElement();
            this.currentNode = element;
            this.setAttributes(element, attributes);
        }

        void newElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Element element = this.document.createElementNS(string, string3);
            this.setAttributes(element, attributes);
            this.appendChild(element);
            this.currentNode = element;
        }

        void setAttributes(Element element, Attributes attributes) throws SAXException {
            this.attrProcessor.setAttributes(element, attributes);
        }

        private void insertPreDocElementNodes() {
            Node node;
            if (this.preDocTypeNodes != null) {
                node = this.documentType;
                if (node == null) {
                    node = this.document.getDocumentElement();
                }
                for (MockNode mockNode : this.preDocTypeNodes) {
                    this.insertMockNode(mockNode, node);
                }
            }
            if (this.preDocElementNodes != null) {
                node = this.document.getDocumentElement();
                for (MockNode mockNode : this.preDocElementNodes) {
                    this.insertMockNode(mockNode, node);
                }
            }
        }

        private void insertMockNode(MockNode mockNode, Node node) {
            if (mockNode.getNodeType() == 8) {
                this.document.insertBefore(this.document.createComment(mockNode.getData()), node);
            } else {
                this.document.insertBefore(this.document.createProcessingInstruction(((MockProcessingInstruction)mockNode).getTarget(), mockNode.getData()), node);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            this.currentNode = this.currentNode.getParentNode();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            Node node;
            String string = new String(cArray, n, n2);
            if (this.currentNode == null) {
                this.error("Text outside of root element: " + string);
            }
            int n3 = (node = this.currentNode.getLastChild()) == null ? -1 : (int)node.getNodeType();
            if (!this.cdata && n3 == 3 || this.cdata && n3 == 4) {
                Text text = (Text)node;
                text.appendData(string);
            } else if (!this.cdata) {
                this.appendChild(this.document.createTextNode(string));
            } else {
                this.appendChild(this.document.createCDATASection(string));
            }
        }

        void appendChild(Node node) throws SAXException {
            try {
                this.currentNode.appendChild(node);
            }
            catch (DOMException dOMException) {
                this.error("Error appending child " + node.getNodeName() + " to " + this.currentNode.getNodeName(), dOMException);
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            if (!this.ignoreECW && this.currentNode != null) {
                String string = new String(cArray, n, n2);
                Node node = this.currentNode.getLastChild();
                int n3 = node == null ? -1 : (int)node.getNodeType();
                if (this.cdata && n3 == 4) {
                    Text text = (Text)node;
                    text.appendData(string);
                } else if (!this.cdata) {
                    this.appendChild(this.document.createTextNode(string));
                } else {
                    this.appendChild(this.document.createCDATASection(string));
                }
            }
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            if (this.currentNode != null) {
                this.appendChild(this.document.createProcessingInstruction(string, string2));
            } else if (this.document != null) {
                this.document.appendChild(this.document.createProcessingInstruction(string, string2));
            } else if (this.endDTD) {
                if (this.documentType == null) {
                    if (this.preDocTypeNodes == null) {
                        this.preDocTypeNodes = new LinkedList();
                    }
                    this.preDocTypeNodes.add(new MockProcessingInstruction(string, string2));
                } else {
                    if (this.preDocElementNodes == null) {
                        this.preDocElementNodes = new LinkedList();
                    }
                    this.preDocElementNodes.add(new MockProcessingInstruction(string, string2));
                }
            }
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
        }

        @Override
        public void startDTD(String string, String string2, String string3) throws SAXException {
            if (this.documentType != null || this.document != null) {
                this.error("DTD must be the first node in a document (except PIs and comments)");
            }
            this.documentType = XMLDocumentBuilder.this.domImpl.createDocumentType(string, string2, string3);
            this.endDTD = false;
        }

        @Override
        public void endDTD() throws SAXException {
            this.endDTD = true;
        }

        @Override
        public void startEntity(String string) throws SAXException {
        }

        @Override
        public void endEntity(String string) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
            this.cdata = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            this.cdata = false;
        }

        @Override
        public void comment(char[] cArray, int n, int n2) throws SAXException {
            String string = new String(cArray, n, n2);
            if (this.currentNode != null) {
                this.appendChild(this.document.createComment(string));
            } else if (this.document != null) {
                this.document.appendChild(this.document.createComment(string));
            } else if (this.endDTD) {
                if (this.documentType == null) {
                    if (this.preDocTypeNodes == null) {
                        this.preDocTypeNodes = new LinkedList();
                    }
                    this.preDocTypeNodes.add(new MockCommentNode(string));
                } else {
                    if (this.preDocElementNodes == null) {
                        this.preDocElementNodes = new LinkedList();
                    }
                    this.preDocElementNodes.add(new MockCommentNode(string));
                }
            }
        }

        void error(String string) throws SAXException {
            if (this.lastLocator == null) {
                throw new SAXException(string);
            }
            throw new SAXParseException(string, this.lastLocator);
        }

        private void error(String string, Exception exception) throws SAXException {
            if (this.lastLocator == null) {
                throw new SAXException(string, exception);
            }
            throw new SAXParseException(string, this.lastLocator, exception);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        private class AttributeProcessor {
            private AttributeProcessor() {
            }

            void setAttributes(Element element, Attributes attributes) throws SAXException {
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    String string = attributes.getURI(i);
                    String string2 = attributes.getValue(i);
                    if (XMLContentHandler.this.isNativeDOM && "http://www.w3.org/XML/1998/namespace".equals(string) && "space".equals(attributes.getLocalName(i)) && "preserve".equalsIgnoreCase(string2)) {
                        ((DOMElement)element).setRawText();
                    }
                    if (XMLContentHandler.this.hasAttributes2 && !(object = (Attributes2)attributes).isSpecified(i)) continue;
                    object = attributes.getQName(i);
                    Attr attr = XMLContentHandler.this.document.createAttributeNS(string, (String)object);
                    attr.setValue(string2);
                    if (XMLContentHandler.this.isNativeDOM) {
                        ((DOMNamedNodeMap)element.getAttributes()).setNamedItemUnchecked(attr);
                        continue;
                    }
                    element.getAttributes().setNamedItem(attr);
                    if (!"ID".equals(attributes.getType(i)) && (!"id".equals(object) || element.getNamespaceURI() == XMLContentHandler.this.document.getNamespaceURI())) continue;
                    element.setIdAttributeNode(attr, true);
                }
            }
        }

        private class NotSpecifiedAttributeProcessor
        extends AttributeProcessor {
            private NotSpecifiedAttributeProcessor() {
            }

            @Override
            void setAttributes(Element element, Attributes attributes) throws SAXException {
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    String string = attributes.getURI(i);
                    String string2 = attributes.getValue(i);
                    String string3 = attributes.getQName(i);
                    Attr attr = XMLContentHandler.this.document.createAttributeNS(string, string3);
                    attr.setValue(string2);
                    if (XMLContentHandler.this.isNativeDOM) {
                        if (XMLContentHandler.this.hasAttributes2) {
                            ((DOMAttr)attr).specified = ((Attributes2)attributes).isSpecified(i);
                        }
                        if ("http://www.w3.org/XML/1998/namespace".equals(string) && "space".equals(attributes.getLocalName(i)) && "preserve".equalsIgnoreCase(string2)) {
                            ((DOMElement)element).setRawText();
                        }
                        ((DOMNamedNodeMap)element.getAttributes()).setNamedItemUnchecked(attr);
                        continue;
                    }
                    element.getAttributes().setNamedItem(attr);
                    if (!"ID".equals(attributes.getType(i)) && (!"id".equals(string3) || element.getNamespaceURI() == XMLContentHandler.this.document.getNamespaceURI())) continue;
                    element.setIdAttributeNode(attr, true);
                }
            }
        }
    }
}

