/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.echosvg.parser.AngleHandler;
import io.sf.carte.echosvg.parser.CalcParseException;
import io.sf.carte.echosvg.parser.NumberParser;
import io.sf.carte.echosvg.parser.ParseException;
import java.io.IOException;
import org.w3c.css.om.unit.CSSUnit;

public class AngleParser
extends NumberParser {
    private AngleHandler angleHandler;

    public AngleParser(AngleHandler angleHandler) {
        this.angleHandler = angleHandler;
    }

    public void setAngleHandler(AngleHandler angleHandler) {
        this.angleHandler = angleHandler;
    }

    public AngleHandler getAngleHandler() {
        return this.angleHandler;
    }

    @Override
    protected void doParse() throws ParseException, IOException {
        this.angleHandler.startAngle();
        this.current = this.reader.read();
        this.skipSpaces();
        try {
            float f = this.parseFloat();
            this.angleHandler.angleValue(f);
            if (this.current != -1) {
                block1 : switch (this.current) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        break;
                    }
                    default: {
                        switch (this.current) {
                            case 100: {
                                this.current = this.reader.read();
                                if (this.current != 101) {
                                    this.reportCharacterExpectedError('e', this.current);
                                    break block1;
                                }
                                this.current = this.reader.read();
                                if (this.current != 103) {
                                    this.reportCharacterExpectedError('g', this.current);
                                    break block1;
                                }
                                this.angleHandler.deg();
                                this.current = this.reader.read();
                                break block1;
                            }
                            case 103: {
                                this.current = this.reader.read();
                                if (this.current != 114) {
                                    this.reportCharacterExpectedError('r', this.current);
                                    break block1;
                                }
                                this.current = this.reader.read();
                                if (this.current != 97) {
                                    this.reportCharacterExpectedError('a', this.current);
                                    break block1;
                                }
                                this.current = this.reader.read();
                                if (this.current != 100) {
                                    this.reportCharacterExpectedError('d', this.current);
                                    break block1;
                                }
                                this.angleHandler.grad();
                                this.current = this.reader.read();
                                break block1;
                            }
                            case 114: {
                                this.current = this.reader.read();
                                if (this.current != 97) {
                                    this.reportCharacterExpectedError('a', this.current);
                                    break block1;
                                }
                                this.current = this.reader.read();
                                if (this.current != 100) {
                                    this.reportCharacterExpectedError('d', this.current);
                                    break block1;
                                }
                                this.angleHandler.rad();
                                this.current = this.reader.read();
                                break block1;
                            }
                            case 116: {
                                this.current = this.reader.read();
                                if (this.current != 117) {
                                    this.reportCharacterExpectedError('u', this.current);
                                    break block1;
                                }
                                this.current = this.reader.read();
                                if (this.current != 114) {
                                    this.reportCharacterExpectedError('r', this.current);
                                    break block1;
                                }
                                this.current = this.reader.read();
                                if (this.current != 110) {
                                    this.reportCharacterExpectedError('n', this.current);
                                    break block1;
                                }
                                this.angleHandler.turn();
                                this.current = this.reader.read();
                                break block1;
                            }
                        }
                        this.reportUnexpectedCharacterError(this.current);
                    }
                }
            }
            this.skipSpaces();
            if (this.current != -1) {
                this.reportError("end.of.stream.expected", new Object[]{this.current});
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.reportUnexpectedCharacterError(this.current);
        }
        catch (CalcParseException calcParseException) {
            this.cssParse();
        }
        this.angleHandler.endAngle();
    }

    @Override
    protected void handleNumber(short s, float f) throws ParseException {
        if (!CSSUnit.isAngleUnitType((short)s)) {
            throw new ParseException("Not an angle: " + CSSUnit.dimensionUnitString((short)s), -1, -1);
        }
        this.angleHandler.angleValue(f);
        switch (s) {
            case 80: {
                this.angleHandler.deg();
                break;
            }
            case 82: {
                this.angleHandler.grad();
                break;
            }
            case 81: {
                this.angleHandler.rad();
                break;
            }
            case 83: {
                this.angleHandler.turn();
                break;
            }
            default: {
                this.reportError("character.unexpected", new Object[]{CSSUnit.dimensionUnitString((short)s)});
            }
        }
    }

    @Override
    protected short getPreferredUnit() {
        return 80;
    }
}

