/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeSymbol
extends IdScriptableObject
implements Symbol {
    private static final long serialVersionUID = -589539749749830003L;
    public static final String CLASS_NAME = "Symbol";
    public static final String TYPE_NAME = "symbol";
    private static final Object GLOBAL_TABLE_KEY = new Object();
    private static final Object CONSTRUCTOR_SLOT = new Object();
    private final SymbolKey key;
    private final NativeSymbol symbolData;
    private static final int ConstructorId_keyFor = -2;
    private static final int ConstructorId_for = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_valueOf = 4;
    private static final int SymbolId_toStringTag = 3;
    private static final int SymbolId_toPrimitive = 5;
    private static final int MAX_PROTOTYPE_ID = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeSymbol nativeSymbol = new NativeSymbol("");
        IdFunctionObject idFunctionObject = nativeSymbol.exportAsJSClass(5, scriptable, false);
        context.putThreadLocal(CONSTRUCTOR_SLOT, Boolean.TRUE);
        try {
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "iterator", SymbolKey.ITERATOR);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "species", SymbolKey.SPECIES);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "toStringTag", SymbolKey.TO_STRING_TAG);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "hasInstance", SymbolKey.HAS_INSTANCE);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "isConcatSpreadable", SymbolKey.IS_CONCAT_SPREADABLE);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "isRegExp", SymbolKey.IS_REGEXP);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "toPrimitive", SymbolKey.TO_PRIMITIVE);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "match", SymbolKey.MATCH);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "replace", SymbolKey.REPLACE);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "search", SymbolKey.SEARCH);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "split", SymbolKey.SPLIT);
            NativeSymbol.createStandardSymbol(context, scriptable, idFunctionObject, "unscopables", SymbolKey.UNSCOPABLES);
        }
        finally {
            context.removeThreadLocal(CONSTRUCTOR_SLOT);
        }
        if (bl) {
            idFunctionObject.sealObject();
        }
    }

    private NativeSymbol(String string) {
        this.key = new SymbolKey(string);
        this.symbolData = null;
    }

    NativeSymbol(SymbolKey symbolKey) {
        this.key = symbolKey;
        this.symbolData = this;
    }

    public NativeSymbol(NativeSymbol nativeSymbol) {
        this.key = nativeSymbol.key;
        this.symbolData = nativeSymbol.symbolData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeSymbol construct(Context context, Scriptable scriptable, Object[] objectArray) {
        context.putThreadLocal(CONSTRUCTOR_SLOT, Boolean.TRUE);
        try {
            NativeSymbol nativeSymbol = (NativeSymbol)context.newObject(scriptable, CLASS_NAME, objectArray);
            return nativeSymbol;
        }
        finally {
            context.removeThreadLocal(CONSTRUCTOR_SLOT);
        }
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        super.fillConstructorProperties(idFunctionObject);
        this.addIdFunctionProperty(idFunctionObject, CLASS_NAME, -1, "for", 1);
        this.addIdFunctionProperty(idFunctionObject, CLASS_NAME, -2, "keyFor", 1);
    }

    private static void createStandardSymbol(Context context, Scriptable scriptable, ScriptableObject scriptableObject, String string, SymbolKey symbolKey) {
        Scriptable scriptable2 = context.newObject(scriptable, CLASS_NAME, new Object[]{string, symbolKey});
        scriptableObject.defineProperty(string, (Object)scriptable2, 7);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n = 0;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "toString": {
                n = 2;
                break;
            }
            case "valueOf": {
                n = 4;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.TO_STRING_TAG.equals(symbol)) {
            return 3;
        }
        if (SymbolKey.TO_PRIMITIVE.equals(symbol)) {
            return 5;
        }
        return 0;
    }

    @Override
    protected void initPrototypeId(int n) {
        switch (n) {
            case 1: {
                this.initPrototypeMethod(CLASS_NAME, n, "constructor", 0);
                break;
            }
            case 2: {
                this.initPrototypeMethod(CLASS_NAME, n, "toString", 0);
                break;
            }
            case 4: {
                this.initPrototypeMethod(CLASS_NAME, n, "valueOf", 0);
                break;
            }
            case 3: {
                this.initPrototypeValue(n, SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
                break;
            }
            case 5: {
                this.initPrototypeMethod((Object)CLASS_NAME, n, SymbolKey.TO_PRIMITIVE, "Symbol.toPrimitive", 1);
                break;
            }
            default: {
                super.initPrototypeId(n);
            }
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(CLASS_NAME)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case -1: {
                return this.js_for(context, scriptable, objectArray);
            }
            case -2: {
                return this.js_keyFor(context, scriptable, objectArray);
            }
            case 1: {
                if (scriptable2 == null) {
                    if (context.getThreadLocal(CONSTRUCTOR_SLOT) == null) {
                        throw ScriptRuntime.typeErrorById("msg.no.symbol.new", new Object[0]);
                    }
                    return NativeSymbol.js_constructor(objectArray);
                }
                return NativeSymbol.construct(context, scriptable, objectArray);
            }
            case 2: {
                return NativeSymbol.getSelf(context, scriptable, scriptable2).toString();
            }
            case 4: 
            case 5: {
                return NativeSymbol.getSelf(context, scriptable, scriptable2).js_valueOf();
            }
        }
        return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
    }

    private static NativeSymbol getSelf(Context context, Scriptable scriptable, Object object) {
        try {
            return (NativeSymbol)ScriptRuntime.toObject(context, scriptable, object);
        }
        catch (ClassCastException classCastException) {
            throw ScriptRuntime.typeErrorById("msg.invalid.type", object.getClass().getName());
        }
    }

    private static NativeSymbol js_constructor(Object[] objectArray) {
        String string = objectArray.length > 0 ? (Undefined.instance.equals(objectArray[0]) ? "" : ScriptRuntime.toString(objectArray[0])) : "";
        if (objectArray.length > 1) {
            return new NativeSymbol((SymbolKey)objectArray[1]);
        }
        return new NativeSymbol(new SymbolKey(string));
    }

    private Object js_valueOf() {
        return this.symbolData;
    }

    private Object js_for(Context context, Scriptable scriptable, Object[] objectArray) {
        String string = objectArray.length > 0 ? ScriptRuntime.toString(objectArray[0]) : ScriptRuntime.toString(Undefined.instance);
        Map<String, NativeSymbol> map = this.getGlobalMap();
        NativeSymbol nativeSymbol = map.get(string);
        if (nativeSymbol == null) {
            nativeSymbol = NativeSymbol.construct(context, scriptable, new Object[]{string});
            map.put(string, nativeSymbol);
        }
        return nativeSymbol;
    }

    private Object js_keyFor(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object;
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        if (!(object instanceof NativeSymbol)) {
            throw ScriptRuntime.throwCustomError(context, scriptable, "TypeError", "Not a Symbol");
        }
        NativeSymbol nativeSymbol = (NativeSymbol)object;
        Map<String, NativeSymbol> map = this.getGlobalMap();
        for (Map.Entry<String, NativeSymbol> entry : map.entrySet()) {
            if (entry.getValue().key != nativeSymbol.key) continue;
            return entry.getKey();
        }
        return Undefined.instance;
    }

    public String toString() {
        return this.key.toString();
    }

    private static boolean isStrictMode() {
        Context context = Context.getCurrentContext();
        return context != null && context.isStrictMode();
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        if (!this.isSymbol()) {
            super.put(string, scriptable, object);
        } else if (NativeSymbol.isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.no.assign.symbol.strict", new Object[0]);
        }
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (!this.isSymbol()) {
            super.put(n, scriptable, object);
        } else if (NativeSymbol.isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.no.assign.symbol.strict", new Object[0]);
        }
    }

    @Override
    public void put(Symbol symbol, Scriptable scriptable, Object object) {
        if (!this.isSymbol()) {
            super.put(symbol, scriptable, object);
        } else if (NativeSymbol.isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.no.assign.symbol.strict", new Object[0]);
        }
    }

    public boolean isSymbol() {
        return this.symbolData == this;
    }

    @Override
    public String getTypeOf() {
        return this.isSymbol() ? TYPE_NAME : super.getTypeOf();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        return this.key.equals(object);
    }

    SymbolKey getKey() {
        return this.key;
    }

    private Map<String, NativeSymbol> getGlobalMap() {
        ScriptableObject scriptableObject = (ScriptableObject)NativeSymbol.getTopLevelScope(this);
        HashMap hashMap = (HashMap)scriptableObject.getAssociatedValue(GLOBAL_TABLE_KEY);
        if (hashMap == null) {
            hashMap = new HashMap();
            scriptableObject.associateValue(GLOBAL_TABLE_KEY, hashMap);
        }
        return hashMap;
    }
}

