/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.UnitProcessor;
import org.w3c.dom.Element;

public abstract class UnitProcessor
extends io.sf.carte.echosvg.parser.UnitProcessor {
    public static UnitProcessor.Context createContext(BridgeContext bridgeContext, Element element) {
        return new DefaultContext(bridgeContext, element);
    }

    public static float svgHorizontalCoordinateToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToObjectBoundingBox(string, string2, (short)2, context);
    }

    public static float svgVerticalCoordinateToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToObjectBoundingBox(string, string2, (short)1, context);
    }

    public static float svgOtherCoordinateToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToObjectBoundingBox(string, string2, (short)0, context);
    }

    public static float svgHorizontalLengthToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToObjectBoundingBox(string, string2, (short)2, context);
    }

    public static float svgVerticalLengthToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToObjectBoundingBox(string, string2, (short)1, context);
    }

    public static float svgOtherLengthToObjectBoundingBox(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToObjectBoundingBox(string, string2, (short)0, context);
    }

    public static float svgLengthToObjectBoundingBox(String string, String string2, short s, UnitProcessor.Context context) {
        float f = UnitProcessor.svgToObjectBoundingBox(string, string2, s, context);
        if (f < 0.0f) {
            throw new BridgeException(UnitProcessor.getBridgeContext(context), context.getElement(), "length.negative", new Object[]{string2, string});
        }
        return f;
    }

    public static float svgToObjectBoundingBox(String string, String string2, short s, UnitProcessor.Context context) {
        try {
            return io.sf.carte.echosvg.parser.UnitProcessor.cssToObjectBoundingBox((String)string, (String)string2, (short)s, (UnitProcessor.Context)context);
        }
        catch (ParseException parseException) {
            throw new BridgeException(UnitProcessor.getBridgeContext(context), context.getElement(), (Exception)((Object)parseException), "attribute.malformed", new Object[]{string2, string, parseException});
        }
    }

    public static float svgHorizontalLengthToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToUserSpace(string, string2, (short)2, context);
    }

    public static float svgVerticalLengthToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToUserSpace(string, string2, (short)1, context);
    }

    public static float svgOtherLengthToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgLengthToUserSpace(string, string2, (short)0, context);
    }

    public static float svgHorizontalCoordinateToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToUserSpace(string, string2, (short)2, context);
    }

    public static float svgVerticalCoordinateToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToUserSpace(string, string2, (short)1, context);
    }

    public static float svgOtherCoordinateToUserSpace(String string, String string2, UnitProcessor.Context context) {
        return UnitProcessor.svgToUserSpace(string, string2, (short)0, context);
    }

    public static float svgLengthToUserSpace(String string, String string2, short s, UnitProcessor.Context context) {
        float f = UnitProcessor.svgToUserSpace(string, string2, s, context);
        if (f < 0.0f) {
            throw new BridgeException(UnitProcessor.getBridgeContext(context), context.getElement(), "length.negative", new Object[]{string2, string});
        }
        return f;
    }

    public static float svgToUserSpace(String string, String string2, short s, UnitProcessor.Context context) {
        try {
            return io.sf.carte.echosvg.parser.UnitProcessor.cssToUserSpace((String)string, (String)string2, (short)s, (UnitProcessor.Context)context);
        }
        catch (ParseException parseException) {
            throw new BridgeException(UnitProcessor.getBridgeContext(context), context.getElement(), (Exception)((Object)parseException), "attribute.malformed", new Object[]{string2, string, parseException});
        }
    }

    protected static BridgeContext getBridgeContext(UnitProcessor.Context context) {
        if (context instanceof DefaultContext) {
            return ((DefaultContext)context).ctx;
        }
        return null;
    }

    public static class DefaultContext
    implements UnitProcessor.Context {
        protected Element e;
        protected BridgeContext ctx;

        public DefaultContext(BridgeContext bridgeContext, Element element) {
            this.ctx = bridgeContext;
            this.e = element;
        }

        public Element getElement() {
            return this.e;
        }

        public float getResolution() {
            return this.ctx.getUserAgent().getResolution();
        }

        public float getFontSize() {
            return CSSUtilities.getComputedStyle(this.e, 21).getFloatValue();
        }

        public float getLineHeight() {
            return CSSUtilities.getComputedStyle(this.e, 33).getFloatValue();
        }

        public float getRootFontSize() {
            Element element = this.e.getOwnerDocument().getDocumentElement();
            return CSSUtilities.getComputedStyle(element, 21).getFloatValue();
        }

        public float getRootLineHeight() {
            Element element = this.e.getOwnerDocument().getDocumentElement();
            return CSSUtilities.getComputedStyle(element, 33).getFloatValue();
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getRootXHeight() {
            return 0.5f;
        }

        public float getViewportWidth() {
            return this.ctx.getViewport(this.e).getWidth();
        }

        public float getViewportHeight() {
            return this.ctx.getViewport(this.e).getHeight();
        }
    }
}

