/*
 * Decompiled with CFR 0.152.
 */
package firrtl.proto;

import com.google.protobuf.CodedInputStream;
import firrtl.CDefMPort;
import firrtl.CDefMemory;
import firrtl.FirrtlProtos;
import firrtl.FirrtlUserException;
import firrtl.FirrtlUserException$;
import firrtl.MInfer$;
import firrtl.MPortDir;
import firrtl.MRead$;
import firrtl.MReadWrite$;
import firrtl.MWrite$;
import firrtl.Utils$;
import firrtl.ir.AnalogType;
import firrtl.ir.AsyncResetType$;
import firrtl.ir.Attach;
import firrtl.ir.Block;
import firrtl.ir.BundleType;
import firrtl.ir.Circuit;
import firrtl.ir.ClockType$;
import firrtl.ir.Conditionally;
import firrtl.ir.Connect;
import firrtl.ir.DefInstance;
import firrtl.ir.DefInstance$;
import firrtl.ir.DefMemory;
import firrtl.ir.DefModule;
import firrtl.ir.DefNode;
import firrtl.ir.DefRegister;
import firrtl.ir.DefWire;
import firrtl.ir.Default$;
import firrtl.ir.Direction;
import firrtl.ir.DoPrim;
import firrtl.ir.DoubleParam;
import firrtl.ir.EmptyStmt$;
import firrtl.ir.Expression;
import firrtl.ir.ExtModule;
import firrtl.ir.Field;
import firrtl.ir.FileInfo$;
import firrtl.ir.FixedLiteral;
import firrtl.ir.FixedType;
import firrtl.ir.Flip$;
import firrtl.ir.Formal$;
import firrtl.ir.Info;
import firrtl.ir.Input$;
import firrtl.ir.IntParam;
import firrtl.ir.IntWidth;
import firrtl.ir.IntWidth$;
import firrtl.ir.IsInvalid;
import firrtl.ir.Module;
import firrtl.ir.Mux;
import firrtl.ir.NoInfo$;
import firrtl.ir.Orientation;
import firrtl.ir.Output$;
import firrtl.ir.Param;
import firrtl.ir.PartialConnect;
import firrtl.ir.Port;
import firrtl.ir.PrimOp;
import firrtl.ir.Print;
import firrtl.ir.Print$;
import firrtl.ir.RawStringParam;
import firrtl.ir.ReadUnderWrite$;
import firrtl.ir.Reference;
import firrtl.ir.Reference$;
import firrtl.ir.ResetType$;
import firrtl.ir.SIntLiteral;
import firrtl.ir.SIntType;
import firrtl.ir.Statement;
import firrtl.ir.Stop;
import firrtl.ir.Stop$;
import firrtl.ir.StringLit;
import firrtl.ir.StringParam;
import firrtl.ir.SubAccess;
import firrtl.ir.SubAccess$;
import firrtl.ir.SubField;
import firrtl.ir.SubField$;
import firrtl.ir.SubIndex;
import firrtl.ir.SubIndex$;
import firrtl.ir.Type;
import firrtl.ir.UIntLiteral;
import firrtl.ir.UIntType;
import firrtl.ir.UnknownType$;
import firrtl.ir.UnknownWidth$;
import firrtl.ir.ValidIf;
import firrtl.ir.VectorType;
import firrtl.ir.Verification;
import firrtl.ir.Verification$;
import firrtl.proto.ToProto$;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.NotDirectoryException;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class FromProto$ {
    public static final FromProto$ MODULE$ = new FromProto$();
    private static final Map<FirrtlProtos.Firrtl.Expression.PrimOp.Op, PrimOp> convert = (Map)ToProto$.MODULE$.convert().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        PrimOp k = (PrimOp)tuple2._1();
        FirrtlProtos.Firrtl.Expression.PrimOp.Op v = (FirrtlProtos.Firrtl.Expression.PrimOp.Op)tuple2._2();
        Tuple2<FirrtlProtos.Firrtl.Expression.PrimOp.Op, PrimOp> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(v), k);
        return tuple22;
    });

    public Circuit fromFile(String filename) {
        return this.fromInputStream(new FileInputStream(new File(filename)));
    }

    public Circuit fromInputStream(InputStream is) {
        CodedInputStream cistream = CodedInputStream.newInstance(is);
        cistream.setRecursionLimit(Integer.MAX_VALUE);
        FirrtlProtos.Firrtl pb = FirrtlProtos.Firrtl.parseFrom(cistream);
        return this.convert(pb);
    }

    public Circuit fromDirectory(String dir) {
        File d = new File(dir);
        if (!d.exists()) {
            throw new FileNotFoundException(new StringBuilder(38).append("Specified directory '").append(d).append("' does not exist!").toString());
        }
        if (!d.isDirectory()) {
            throw new NotDirectoryException(new StringBuilder(22).append("'").append(d).append("' is not a directory!").toString());
        }
        List fileList = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(d.listFiles()), (Function1<File, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isFile()))).toList();
        return Utils$.MODULE$.combine((scala.collection.immutable.Seq<Circuit>)fileList.map((Function1<File, Circuit> & Serializable)f -> MODULE$.fromInputStream(new FileInputStream((File)f))));
    }

    private Statement compressStmts(Seq<Statement> stmts) {
        SeqOps seqOps;
        Statement statement;
        SeqOps seqOps2;
        Seq<Statement> seq = stmts;
        if (seq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = Seq$.MODULE$.unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
            statement = EmptyStmt$.MODULE$;
        } else if (seq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            Statement stmt = (Statement)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            statement = stmt;
        } else {
            statement = new Block(seq.toSeq());
        }
        return statement;
    }

    public Info convert(FirrtlProtos.Firrtl.SourceInfo info) {
        Info info2;
        int n = info.getSourceInfoCase().getNumber();
        switch (n) {
            case 2: {
                FirrtlProtos.Firrtl.SourceInfo.Position pos = info.getPosition();
                String str = new StringBuilder(2).append(pos.getFilename()).append(" ").append(pos.getLine()).append(":").append(pos.getColumn()).toString();
                info2 = FileInfo$.MODULE$.fromUnescaped(str);
                break;
            }
            case 3: {
                info2 = FileInfo$.MODULE$.fromUnescaped(info.getText());
                break;
            }
            default: {
                info2 = NoInfo$.MODULE$;
                break;
            }
        }
        return info2;
    }

    public Map<FirrtlProtos.Firrtl.Expression.PrimOp.Op, PrimOp> convert() {
        return convert;
    }

    public BigInt convert(FirrtlProtos.Firrtl.Expression.IntegerLiteral literal) {
        return package$.MODULE$.BigInt().apply(literal.getValue());
    }

    public BigInt convert(FirrtlProtos.Firrtl.BigInt bigint) {
        return package$.MODULE$.BigInt().apply(bigint.getValue().toByteArray());
    }

    public UIntLiteral convert(FirrtlProtos.Firrtl.Expression.UIntLiteral uint) {
        UnknownWidth$ width = uint.hasWidth() ? this.convert(uint.getWidth()) : UnknownWidth$.MODULE$;
        return new UIntLiteral(this.convert(uint.getValue()), width);
    }

    public SIntLiteral convert(FirrtlProtos.Firrtl.Expression.SIntLiteral sint) {
        UnknownWidth$ width = sint.hasWidth() ? this.convert(sint.getWidth()) : UnknownWidth$.MODULE$;
        return new SIntLiteral(this.convert(sint.getValue()), width);
    }

    public FixedLiteral convert(FirrtlProtos.Firrtl.Expression.FixedLiteral fixed) {
        UnknownWidth$ width = fixed.hasWidth() ? this.convert(fixed.getWidth()) : UnknownWidth$.MODULE$;
        UnknownWidth$ point = fixed.hasPoint() ? this.convert(fixed.getPoint()) : UnknownWidth$.MODULE$;
        return new FixedLiteral(this.convert(fixed.getValue()), width, point);
    }

    public SubField convert(FirrtlProtos.Firrtl.Expression.SubField subfield) {
        return new SubField(this.convert(subfield.getExpression()), subfield.getField(), UnknownType$.MODULE$, SubField$.MODULE$.apply$default$4());
    }

    public SubIndex convert(FirrtlProtos.Firrtl.Expression.SubIndex index) {
        return new SubIndex(this.convert(index.getExpression()), this.convert(index.getIndex()).toInt(), UnknownType$.MODULE$, SubIndex$.MODULE$.apply$default$4());
    }

    public SubAccess convert(FirrtlProtos.Firrtl.Expression.SubAccess access) {
        return new SubAccess(this.convert(access.getExpression()), this.convert(access.getIndex()), UnknownType$.MODULE$, SubAccess$.MODULE$.apply$default$4());
    }

    public DoPrim convert(FirrtlProtos.Firrtl.Expression.PrimOp primop) {
        scala.collection.immutable.Seq<Expression> args = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(primop.getArgList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Expression, Expression> & Serializable)x$2 -> MODULE$.convert((FirrtlProtos.Firrtl.Expression)x$2))).toSeq();
        scala.collection.immutable.Seq<BigInt> consts = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(primop.getConstList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Expression.IntegerLiteral, BigInt> & Serializable)x$3 -> MODULE$.convert((FirrtlProtos.Firrtl.Expression.IntegerLiteral)x$3))).toSeq();
        return new DoPrim((PrimOp)this.convert().apply(primop.getOp()), args, consts, UnknownType$.MODULE$);
    }

    public Mux convert(FirrtlProtos.Firrtl.Expression.Mux mux) {
        return new Mux(this.convert(mux.getCondition()), this.convert(mux.getTValue()), this.convert(mux.getFValue()), UnknownType$.MODULE$);
    }

    public ValidIf convert(FirrtlProtos.Firrtl.Expression.ValidIf validif) {
        return new ValidIf(this.convert(validif.getCondition()), this.convert(validif.getValue()), UnknownType$.MODULE$);
    }

    public Expression convert(FirrtlProtos.Firrtl.Expression expr) {
        Expression expression;
        int n = expr.getExpressionCase().getNumber();
        switch (n) {
            case 1: {
                expression = new Reference(expr.getReference().getId(), UnknownType$.MODULE$, Reference$.MODULE$.apply$default$3(), Reference$.MODULE$.apply$default$4());
                break;
            }
            case 7: {
                expression = this.convert(expr.getSubField());
                break;
            }
            case 8: {
                expression = this.convert(expr.getSubIndex());
                break;
            }
            case 9: {
                expression = this.convert(expr.getSubAccess());
                break;
            }
            case 2: {
                expression = this.convert(expr.getUintLiteral());
                break;
            }
            case 3: {
                expression = this.convert(expr.getSintLiteral());
                break;
            }
            case 11: {
                expression = this.convert(expr.getFixedLiteral());
                break;
            }
            case 10: {
                expression = this.convert(expr.getPrimOp());
                break;
            }
            case 6: {
                expression = this.convert(expr.getMux());
                break;
            }
            case 4: {
                expression = this.convert(expr.getValidIf());
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        return expression;
    }

    public Connect convert(FirrtlProtos.Firrtl.Statement.Connect con, FirrtlProtos.Firrtl.SourceInfo info) {
        return new Connect(this.convert(info), this.convert(con.getLocation()), this.convert(con.getExpression()));
    }

    public PartialConnect convert(FirrtlProtos.Firrtl.Statement.PartialConnect con, FirrtlProtos.Firrtl.SourceInfo info) {
        return new PartialConnect(this.convert(info), this.convert(con.getLocation()), this.convert(con.getExpression()));
    }

    public DefWire convert(FirrtlProtos.Firrtl.Statement.Wire wire, FirrtlProtos.Firrtl.SourceInfo info) {
        return new DefWire(this.convert(info), wire.getId(), this.convert(wire.getType()));
    }

    public DefRegister convert(FirrtlProtos.Firrtl.Statement.Register reg, FirrtlProtos.Firrtl.SourceInfo info) {
        return new DefRegister(this.convert(info), reg.getId(), this.convert(reg.getType()), this.convert(reg.getClock()), this.convert(reg.getReset()), this.convert(reg.getInit()));
    }

    public DefNode convert(FirrtlProtos.Firrtl.Statement.Node node, FirrtlProtos.Firrtl.SourceInfo info) {
        return new DefNode(this.convert(info), node.getId(), this.convert(node.getExpression()));
    }

    public DefInstance convert(FirrtlProtos.Firrtl.Statement.Instance inst, FirrtlProtos.Firrtl.SourceInfo info) {
        return new DefInstance(this.convert(info), inst.getId(), inst.getModuleId(), DefInstance$.MODULE$.apply$default$4());
    }

    public Conditionally convert(FirrtlProtos.Firrtl.Statement.When when, FirrtlProtos.Firrtl.SourceInfo info) {
        Statement conseq = this.compressStmts((Seq)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(when.getConsequentList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Statement, Statement> & Serializable)x$4 -> MODULE$.convert((FirrtlProtos.Firrtl.Statement)x$4)));
        Statement alt = this.compressStmts((Seq)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(when.getOtherwiseList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Statement, Statement> & Serializable)x$5 -> MODULE$.convert((FirrtlProtos.Firrtl.Statement)x$5)));
        return new Conditionally(this.convert(info), this.convert(when.getPredicate()), conseq, alt);
    }

    public Enumeration.Value convert(FirrtlProtos.Firrtl.Statement.ReadUnderWrite ruw) {
        Enumeration.Value value;
        FirrtlProtos.Firrtl.Statement.ReadUnderWrite readUnderWrite = ruw;
        if (FirrtlProtos.Firrtl.Statement.ReadUnderWrite.UNDEFINED.equals(readUnderWrite)) {
            value = ReadUnderWrite$.MODULE$.Undefined();
        } else if (FirrtlProtos.Firrtl.Statement.ReadUnderWrite.OLD.equals(readUnderWrite)) {
            value = ReadUnderWrite$.MODULE$.Old();
        } else if (FirrtlProtos.Firrtl.Statement.ReadUnderWrite.NEW.equals(readUnderWrite)) {
            value = ReadUnderWrite$.MODULE$.New();
        } else {
            if (FirrtlProtos.Firrtl.Statement.ReadUnderWrite.UNRECOGNIZED.equals(readUnderWrite)) {
                String msg = new StringBuilder(80).append("Unrecognized ReadUnderWrite value '").append(ruw).append("', perhaps this version of FIRRTL is too old?").toString();
                throw new FirrtlUserException(msg, FirrtlUserException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError(readUnderWrite);
        }
        return value;
    }

    public Tuple2<Type, BigInt> convert(FirrtlProtos.Firrtl.Statement.CMemory.TypeAndDepth dt) {
        return new Tuple2<Type, BigInt>(this.convert(dt.getDataType()), this.convert(dt.getDepth()));
    }

    public Statement convert(FirrtlProtos.Firrtl.Statement.CMemory cmem, FirrtlProtos.Firrtl.SourceInfo info) {
        Tuple2<Type, BigInt> tuple2;
        int n = cmem.getTypeCase().getNumber();
        switch (n) {
            case 2: {
                VectorType vtpe = this.convert(cmem.getVectorType());
                tuple2 = new Tuple2<Type, BigInt>(vtpe.tpe(), package$.MODULE$.BigInt().apply(vtpe.size()));
                break;
            }
            case 4: {
                tuple2 = this.convert(cmem.getTypeAndDepth());
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        Tuple2<Type, BigInt> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        Type tpe = (Type)tuple22._1();
        BigInt depth = (BigInt)tuple22._2();
        Tuple2<Type, BigInt> tuple23 = new Tuple2<Type, BigInt>(tpe, depth);
        Tuple2<Type, BigInt> tuple24 = tuple23;
        Type tpe2 = tuple24._1();
        BigInt depth2 = tuple24._2();
        return new CDefMemory(this.convert(info), cmem.getId(), tpe2, depth2, cmem.getSyncRead(), this.convert(cmem.getReadUnderWrite()));
    }

    public MPortDir convert(FirrtlProtos.Firrtl.Statement.MemoryPort.Direction mportdir) {
        MPortDir mPortDir;
        FirrtlProtos.Firrtl.Statement.MemoryPort.Direction direction = mportdir;
        if (FirrtlProtos.Firrtl.Statement.MemoryPort.Direction.MEMORY_PORT_DIRECTION_INFER.equals(direction)) {
            mPortDir = MInfer$.MODULE$;
        } else if (FirrtlProtos.Firrtl.Statement.MemoryPort.Direction.MEMORY_PORT_DIRECTION_READ.equals(direction)) {
            mPortDir = MRead$.MODULE$;
        } else if (FirrtlProtos.Firrtl.Statement.MemoryPort.Direction.MEMORY_PORT_DIRECTION_WRITE.equals(direction)) {
            mPortDir = MWrite$.MODULE$;
        } else if (FirrtlProtos.Firrtl.Statement.MemoryPort.Direction.MEMORY_PORT_DIRECTION_READ_WRITE.equals(direction)) {
            mPortDir = MReadWrite$.MODULE$;
        } else if (FirrtlProtos.Firrtl.Statement.MemoryPort.Direction.MEMORY_PORT_DIRECTION_UNKNOWN.equals(direction)) {
            mPortDir = MInfer$.MODULE$;
        } else {
            if (FirrtlProtos.Firrtl.Statement.MemoryPort.Direction.UNRECOGNIZED.equals(direction)) {
                String msg = new StringBuilder(86).append("Unrecognized MemoryPort Direction value '").append(mportdir).append("', perhaps this version of FIRRTL is too old?").toString();
                throw new FirrtlUserException(msg, FirrtlUserException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError(direction);
        }
        return mPortDir;
    }

    public CDefMPort convert(FirrtlProtos.Firrtl.Statement.MemoryPort port, FirrtlProtos.Firrtl.SourceInfo info) {
        scala.collection.immutable.Seq exprs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.convert(port.getMemoryIndex()), this.convert(port.getExpression())}));
        return new CDefMPort(this.convert(info), port.getId(), UnknownType$.MODULE$, port.getMemoryId(), exprs, this.convert(port.getDirection()));
    }

    public Print convert(FirrtlProtos.Firrtl.Statement.Printf printf, FirrtlProtos.Firrtl.SourceInfo info) {
        scala.collection.immutable.Seq<Expression> args = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(printf.getArgList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Expression, Expression> & Serializable)x$7 -> MODULE$.convert((FirrtlProtos.Firrtl.Expression)x$7))).toSeq();
        StringLit str = new StringLit(printf.getValue());
        return Print$.MODULE$.apply(this.convert(info), str, args, this.convert(printf.getClk()), this.convert(printf.getEn()));
    }

    public Stop convert(FirrtlProtos.Firrtl.Statement.Stop stop, FirrtlProtos.Firrtl.SourceInfo info) {
        return Stop$.MODULE$.apply(this.convert(info), stop.getReturnValue(), this.convert(stop.getClk()), this.convert(stop.getEn()));
    }

    public Enumeration.Value convert(FirrtlProtos.Firrtl.Statement.Formal formal) {
        Enumeration.Value value;
        FirrtlProtos.Firrtl.Statement.Formal formal2 = formal;
        if (FirrtlProtos.Firrtl.Statement.Formal.ASSERT.equals(formal2)) {
            value = Formal$.MODULE$.Assert();
        } else if (FirrtlProtos.Firrtl.Statement.Formal.ASSUME.equals(formal2)) {
            value = Formal$.MODULE$.Assume();
        } else if (FirrtlProtos.Firrtl.Statement.Formal.COVER.equals(formal2)) {
            value = Formal$.MODULE$.Cover();
        } else {
            if (FirrtlProtos.Firrtl.Statement.Formal.UNRECOGNIZED.equals(formal2)) {
                String msg = new StringBuilder(72).append("Unrecognized Formal value '").append(formal).append("', perhaps this version of FIRRTL is too old?").toString();
                throw new FirrtlUserException(msg, FirrtlUserException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError(formal2);
        }
        return value;
    }

    public Verification convert(FirrtlProtos.Firrtl.Statement.Verification ver, FirrtlProtos.Firrtl.SourceInfo info) {
        return Verification$.MODULE$.apply(this.convert(ver.getOp()), this.convert(info), this.convert(ver.getClk()), this.convert(ver.getCond()), this.convert(ver.getEn()), new StringLit(ver.getMsg()));
    }

    public DefMemory convert(FirrtlProtos.Firrtl.Statement.Memory mem, FirrtlProtos.Firrtl.SourceInfo info) {
        BigInt bigInt;
        Type dtype = this.convert(mem.getType());
        scala.collection.immutable.Seq<String> rs = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(mem.getReaderIdList()).asScala()).toSeq();
        scala.collection.immutable.Seq<String> ws = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(mem.getWriterIdList()).asScala()).toSeq();
        scala.collection.immutable.Seq<String> rws = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(mem.getReadwriterIdList()).asScala()).toSeq();
        int n = mem.getDepthCase().getNumber();
        switch (n) {
            case 3: {
                bigInt = package$.MODULE$.BigInt().apply(mem.getUintDepth());
                break;
            }
            case 9: {
                bigInt = this.convert(mem.getBigintDepth());
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        BigInt depth = bigInt;
        return new DefMemory(this.convert(info), mem.getId(), dtype, depth, mem.getWriteLatency(), mem.getReadLatency(), rs, ws, rws, this.convert(mem.getReadUnderWrite()));
    }

    public Attach convert(FirrtlProtos.Firrtl.Statement.Attach attach, FirrtlProtos.Firrtl.SourceInfo info) {
        scala.collection.immutable.Seq<Expression> exprs = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(attach.getExpressionList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Expression, Expression> & Serializable)x$8 -> MODULE$.convert((FirrtlProtos.Firrtl.Expression)x$8))).toSeq();
        return new Attach(this.convert(info), exprs);
    }

    public Statement convert(FirrtlProtos.Firrtl.Statement stmt) {
        Statement statement;
        FirrtlProtos.Firrtl.SourceInfo info = stmt.getSourceInfo();
        int n = stmt.getStatementCase().getNumber();
        switch (n) {
            case 6: {
                statement = this.convert(stmt.getNode(), info);
                break;
            }
            case 15: {
                statement = this.convert(stmt.getConnect(), info);
                break;
            }
            case 16: {
                statement = this.convert(stmt.getPartialConnect(), info);
                break;
            }
            case 1: {
                statement = this.convert(stmt.getWire(), info);
                break;
            }
            case 2: {
                statement = this.convert(stmt.getRegister(), info);
                break;
            }
            case 7: {
                statement = this.convert(stmt.getWhen(), info);
                break;
            }
            case 5: {
                statement = this.convert(stmt.getInstance(), info);
                break;
            }
            case 10: {
                statement = this.convert(stmt.getPrintf(), info);
                break;
            }
            case 8: {
                statement = this.convert(stmt.getStop(), info);
                break;
            }
            case 3: {
                statement = this.convert(stmt.getMemory(), info);
                break;
            }
            case 17: {
                statement = new IsInvalid(this.convert(info), this.convert(stmt.getIsInvalid().getExpression()));
                break;
            }
            case 4: {
                statement = this.convert(stmt.getCmemory(), info);
                break;
            }
            case 18: {
                statement = this.convert(stmt.getMemoryPort(), info);
                break;
            }
            case 20: {
                statement = this.convert(stmt.getAttach(), info);
                break;
            }
            case 21: {
                statement = this.convert(stmt.getVerification(), info);
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        return statement;
    }

    public IntWidth convert(FirrtlProtos.Firrtl.Width width) {
        return IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(width.getValue()));
    }

    public UIntType convert(FirrtlProtos.Firrtl.Type.UIntType ut) {
        UnknownWidth$ w = ut.hasWidth() ? this.convert(ut.getWidth()) : UnknownWidth$.MODULE$;
        return new UIntType(w);
    }

    public SIntType convert(FirrtlProtos.Firrtl.Type.SIntType st) {
        UnknownWidth$ w = st.hasWidth() ? this.convert(st.getWidth()) : UnknownWidth$.MODULE$;
        return new SIntType(w);
    }

    public FixedType convert(FirrtlProtos.Firrtl.Type.FixedType fixed) {
        UnknownWidth$ w = fixed.hasWidth() ? this.convert(fixed.getWidth()) : UnknownWidth$.MODULE$;
        UnknownWidth$ p = fixed.hasPoint() ? this.convert(fixed.getPoint()) : UnknownWidth$.MODULE$;
        return new FixedType(w, p);
    }

    public AnalogType convert(FirrtlProtos.Firrtl.Type.AnalogType analog) {
        UnknownWidth$ w = analog.hasWidth() ? this.convert(analog.getWidth()) : UnknownWidth$.MODULE$;
        return new AnalogType(w);
    }

    public Field convert(FirrtlProtos.Firrtl.Type.BundleType.Field field2) {
        Orientation flip = field2.getIsFlipped() ? Flip$.MODULE$ : Default$.MODULE$;
        return new Field(field2.getId(), flip, this.convert(field2.getType()));
    }

    public VectorType convert(FirrtlProtos.Firrtl.Type.VectorType vtpe) {
        return new VectorType(this.convert(vtpe.getType()), vtpe.getSize());
    }

    public Type convert(FirrtlProtos.Firrtl.Type tpe) {
        Type type;
        int n = tpe.getTypeCase().getNumber();
        switch (n) {
            case 2: {
                type = this.convert(tpe.getUintType());
                break;
            }
            case 3: {
                type = this.convert(tpe.getSintType());
                break;
            }
            case 7: {
                type = this.convert(tpe.getFixedType());
                break;
            }
            case 4: {
                type = ClockType$.MODULE$;
                break;
            }
            case 9: {
                type = AsyncResetType$.MODULE$;
                break;
            }
            case 10: {
                type = ResetType$.MODULE$;
                break;
            }
            case 8: {
                type = this.convert(tpe.getAnalogType());
                break;
            }
            case 5: {
                type = new BundleType(((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(tpe.getBundleType().getFieldList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Type.BundleType.Field, Field> & Serializable)x$9 -> MODULE$.convert((FirrtlProtos.Firrtl.Type.BundleType.Field)x$9))).toSeq());
                break;
            }
            case 6: {
                type = this.convert(tpe.getVectorType());
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        return type;
    }

    public Direction convert(FirrtlProtos.Firrtl.Port.Direction dir) {
        Direction direction;
        FirrtlProtos.Firrtl.Port.Direction direction2 = dir;
        if (FirrtlProtos.Firrtl.Port.Direction.PORT_DIRECTION_IN.equals(direction2)) {
            direction = Input$.MODULE$;
        } else if (FirrtlProtos.Firrtl.Port.Direction.PORT_DIRECTION_OUT.equals(direction2)) {
            direction = Output$.MODULE$;
        } else {
            boolean bl = FirrtlProtos.Firrtl.Port.Direction.PORT_DIRECTION_UNKNOWN.equals(direction2) ? true : FirrtlProtos.Firrtl.Port.Direction.UNRECOGNIZED.equals(direction2);
            if (bl) {
                String msg = new StringBuilder(80).append("Unrecognized Port Direction value '").append(dir).append("', perhaps this version of FIRRTL is too old?").toString();
                throw new FirrtlUserException(msg, FirrtlUserException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError(direction2);
        }
        return direction;
    }

    public Port convert(FirrtlProtos.Firrtl.Port port) {
        Direction dir = this.convert(port.getDirection());
        Type tpe = this.convert(port.getType());
        return new Port(NoInfo$.MODULE$, port.getId(), dir, tpe);
    }

    public Param convert(FirrtlProtos.Firrtl.Module.ExternalModule.Parameter param2) {
        Param param3;
        String name = param2.getId();
        int n = param2.getValueCase().getNumber();
        switch (n) {
            case 2: {
                param3 = new IntParam(name, this.convert(param2.getInteger()));
                break;
            }
            case 3: {
                param3 = new DoubleParam(name, param2.getDouble());
                break;
            }
            case 4: {
                param3 = new StringParam(name, new StringLit(param2.getString()));
                break;
            }
            case 5: {
                param3 = new RawStringParam(name, param2.getRawString());
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        return param3;
    }

    public Module convert(FirrtlProtos.Firrtl.Module.UserModule module) {
        String name = module.getId();
        scala.collection.immutable.Seq<Port> ports = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(module.getPortList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Port, Port> & Serializable)x$10 -> MODULE$.convert((FirrtlProtos.Firrtl.Port)x$10))).toSeq();
        scala.collection.immutable.Seq<Statement> stmts = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(module.getStatementList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Statement, Statement> & Serializable)x$11 -> MODULE$.convert((FirrtlProtos.Firrtl.Statement)x$11))).toSeq();
        return new Module(NoInfo$.MODULE$, name, ports, new Block(stmts));
    }

    public ExtModule convert(FirrtlProtos.Firrtl.Module.ExternalModule module) {
        String name = module.getId();
        scala.collection.immutable.Seq<Port> ports = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(module.getPortList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Port, Port> & Serializable)x$12 -> MODULE$.convert((FirrtlProtos.Firrtl.Port)x$12))).toSeq();
        String defname = module.getDefinedName();
        scala.collection.immutable.Seq<Param> params = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(module.getParameterList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Module.ExternalModule.Parameter, Param> & Serializable)x$13 -> MODULE$.convert((FirrtlProtos.Firrtl.Module.ExternalModule.Parameter)x$13))).toSeq();
        return new ExtModule(NoInfo$.MODULE$, name, ports, defname, params);
    }

    public DefModule convert(FirrtlProtos.Firrtl.Module module) {
        DefModule defModule;
        if (module.hasUserModule()) {
            defModule = this.convert(module.getUserModule());
        } else {
            Predef$.MODULE$.require(module.hasExternalModule(), (Function0<Object>)(Function0<String> & Serializable)() -> "Module must have Module or ExtModule");
            defModule = this.convert(module.getExternalModule());
        }
        return defModule;
    }

    public Circuit convert(FirrtlProtos.Firrtl proto) {
        Predef$.MODULE$.require(proto.getCircuitCount() == 1, (Function0<Object>)(Function0<String> & Serializable)() -> "Only 1 circuit is currently supported");
        FirrtlProtos.Firrtl.Circuit c = proto.getCircuit(0);
        Predef$.MODULE$.require(c.getTopCount() == 1, (Function0<Object>)(Function0<String> & Serializable)() -> "Only 1 top is currently supported");
        scala.collection.immutable.Seq<DefModule> modules = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(c.getModuleList()).asScala()).map((Function1<FirrtlProtos.Firrtl.Module, DefModule> & Serializable)x$14 -> MODULE$.convert((FirrtlProtos.Firrtl.Module)x$14))).toSeq();
        String top = c.getTop(0).getName();
        return new Circuit(NoInfo$.MODULE$, modules, top);
    }

    private FromProto$() {
    }
}

