#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-HT2Q0LRqO6P7ABbhVuRmu3
key:                  dhall-1.42.3-HT2Q0LRqO6P7ABbhVuRmu3
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  ad046314144d5d56b2a51775655b8d66
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-HT2Q0LRqO6P7ABbhVuRmu3
depends:
    Diff-0.5-1uoNXaoPLJdFj3rRDp0Am9
    aeson-2.1.2.1-1NeIvw5bSkQ9apxHmCtPBl
    aeson-pretty-0.8.10-2tNFY07YMRPWyoSCQYVlF
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU
    atomic-write-0.2.1.1-LpFS7APYsEU3Om1ZyPGGur base-4.17.2.1
    base16-bytestring-1.0.2.0-EMXeBMC8GqbAFRIxoGFv6C
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-2s4OeiMO3UWBaQwGHjklqk
    cborg-0.2.10.0-6h8rLuMNAWF9muy76zr4Yo
    cborg-json-0.2.6.0-DJAMcekvZuWApF4qZRCFyC containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-kSb4bilGxWJO0W8QVSW7d
    data-fix-0.3.4-EjzgaVMe822wQcgPtXOYx deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-3Cpa4QU2PcuJ7IDGatAF0h exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-BJIdkiUdV2NFpv0HYTn0eY
    hashable-1.4.6.0-Bdyeh8ev81I2bBqnptAVUL haskeline-0.8.2
    http-client-0.7.19-1UbHkZcsz6aHaInIJtT6mf
    http-client-tls-0.3.6.4-DUrge6mvdVp4XdLujK5Myn
    http-types-0.12.4-7uecRhjtUnyHbQI0kDNqA2
    indexed-traversable-0.1.4-52OhEMiwF4u4EtkYVR4uVg
    megaparsec-9.7.0-L0csM5p3V1T7HhcnanYAK3
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-J6lb0WgqIXTCowsvFrAUqQ
    optparse-applicative-0.18.1.0-EO4j3VaswTtGiqiAFplF0k
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-EkRANkErUQWGtV7IMVZ0Dt
    pretty-simple-4.1.3.0-HjL895Y5L5u8fcBIUZhYDC
    prettyprinter-1.7.1-8UVKtzGyqYf1hA40GaDLxY
    prettyprinter-ansi-terminal-1.1.3-IyfQOLi3m8UGh0RxwsEjoo
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-5UF0voSgI45snHwsluIty
    serialise-0.2.6.1-FT4VqXf7ocUEr5hsEQ7371 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-Eh7GquQqeLgKRMhm1hP5uD
    text-short-0.1.6-L2MeS8ccPsd8TFkZJEeMI
    th-lift-instances-0.1.20-3sYMSLLlk6EynWin6Robf time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-4uh2N5X0qi8J6n5m3thcXg
    unordered-containers-0.2.20-1s4f8pAJmee27mGfYrIk99
    vector-0.13.2.0-JPy5pohpq8EDknIfFhMz6E

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

