/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.PostgreValueParser;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataTypeAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTypeType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructImpl;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeStatic;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStructValueHandler;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PostgreStructValueHandler
extends JDBCStructValueHandler {
    private static final Log log = Log.getLog(PostgreStructValueHandler.class);
    public static final PostgreStructValueHandler INSTANCE = new PostgreStructValueHandler();

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, 2002);
        } else if (value instanceof DBDComposite) {
            DBDComposite struct = (DBDComposite)value;
            if (struct.isNull()) {
                statement.setNull(paramIndex, 2002);
            } else if (struct instanceof JDBCComposite) {
                Object[] values = ((JDBCComposite)struct).getValues();
                String string = PostgreValueParser.generateObjectString(values);
                statement.setObject(paramIndex, (Object)string, 1111);
            }
        } else {
            throw new DBCException("Struct parameter type '" + value.getClass().getName() + "' not supported");
        }
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        PostgreDataSource dataSource = (PostgreDataSource)session.getDataSource();
        PostgreDataType structType = PostgreUtils.findDataType(session, dataSource, type);
        if (structType == null) {
            log.debug((Object)("Can't resolve struct type '" + type.getTypeName() + "'"));
            return object;
        }
        if (structType.getTypeType() == PostgreTypeType.d) {
            structType = structType.getBaseType(session.getProgressMonitor());
        }
        try {
            if (object == null) {
                return new JDBCCompositeStatic(session, (DBSDataType)structType, null);
            }
            if (object instanceof JDBCCompositeStatic) {
                JDBCCompositeStatic jdbcCompositeStatic = (JDBCCompositeStatic)object;
                return copy ? jdbcCompositeStatic.cloneValue(session.getProgressMonitor()) : object;
            }
            boolean isPgObject = PostgreUtils.isPgObject((DBPDataSource)dataSource, object);
            Object value = isPgObject ? PostgreUtils.extractPGObjectValue(object, (DBPDataSource)dataSource) : object.toString();
            return this.convertStringToStruct(session, structType, (String)value);
        }
        catch (DBException e) {
            throw new DBCException("Error converting string to composite type", (Throwable)e, session.getExecutionContext());
        }
    }

    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (!DBUtils.isNullValue((Object)value) && value instanceof JDBCComposite) {
            JDBCComposite composite = (JDBCComposite)value;
            StringJoiner output = new StringJoiner(",", "(", ")");
            DBSAttributeBase[] dBSAttributeBaseArray = composite.getAttributes();
            int n = dBSAttributeBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBSAttributeBase attribute = dBSAttributeBaseArray[n2];
                DBDValueHandler handler = DBUtils.findValueHandler((DBPDataSource)composite.getDataType().getDataSource(), (DBSTypedObject)attribute);
                Object item = composite.getAttributeValue(attribute);
                String member = PostgreStructValueHandler.getStructMemberDisplayString((DBSTypedObject)attribute, handler, item, format);
                output.add(member);
                ++n2;
            }
            return output.toString();
        }
        return super.getValueDisplayString(column, value, format);
    }

    @NotNull
    private static String getStructMemberDisplayString(@NotNull DBSTypedObject type, @NotNull DBDValueHandler handler, @Nullable Object value, DBDDisplayFormat format) {
        if (DBUtils.isNullValue((Object)value)) {
            return "";
        }
        String string = handler.getValueDisplayString(type, value, DBDDisplayFormat.NATIVE);
        if (format == DBDDisplayFormat.NATIVE && PostgreStructValueHandler.isQuotingRequired(string)) {
            return "\"" + string.replace("\"", "\"\"") + "\"";
        }
        return string;
    }

    private static boolean isQuotingRequired(@NotNull String value) {
        if (value.isEmpty()) {
            return true;
        }
        int index = 0;
        while (index < value.length()) {
            switch (value.charAt(index)) {
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '\\': {
                    return true;
                }
            }
            ++index;
        }
        return false;
    }

    private JDBCCompositeStatic convertStringToStruct(@NotNull DBCSession session, @NotNull PostgreDataType compType, @NotNull String value) throws DBException {
        List<PostgreDataTypeAttribute> attributes;
        if (value.startsWith("(") && value.endsWith(")")) {
            value = value.substring(1, value.length() - 1);
        }
        if ((attributes = compType.getAttributes(session.getProgressMonitor())) == null) {
            throw new DBException("Composite type '" + compType.getTypeName() + "' has no attributes");
        }
        String[] parsedValues = PostgreValueParser.parseSingleObject(value);
        if (parsedValues.length != attributes.size()) {
            log.debug((Object)("Number of attributes (" + attributes.size() + ") doesn't match actual number of parsed strings (" + parsedValues.length + ")"));
        }
        Object[] attrValues = new Object[attributes.size()];
        Iterator attrIter = attributes.iterator();
        int i = 0;
        while (i < parsedValues.length && attrIter.hasNext()) {
            PostgreDataTypeAttribute itemAttr = (PostgreDataTypeAttribute)attrIter.next();
            attrValues[i] = PostgreValueParser.convertStringToValue(session, (DBSTypedObject)itemAttr, parsedValues[i]);
            ++i;
        }
        JDBCStructImpl contents = new JDBCStructImpl(compType.getTypeName(), attrValues, value);
        return new JDBCCompositeStatic(session, (DBSDataType)compType, (Struct)contents);
    }
}

