/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.tasks;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;

public class OracleToolTableValidateStructureSettings
extends SQLToolExecuteSettings<OracleTableBase> {
    private String option;

    @Property(viewable=true, editable=true, updatable=true, listProvider=CheckOptionListProvider.class)
    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> config, @NotNull DBPProject project) {
        super.loadConfiguration(runnableContext, config, project);
        this.option = JSONUtils.getString(config, (String)"option");
    }

    public void saveConfiguration(Map<String, Object> config) {
        super.saveConfiguration(config);
        config.put("option", this.option);
    }

    public static class CheckOptionListProvider
    implements IPropertyValueListProvider<OracleToolTableValidateStructureSettings> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(OracleToolTableValidateStructureSettings object) {
            return new String[]{"", "CASCADE", "CASCADE FAST", "CASCADE ONLINE"};
        }
    }
}

