/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBGrant;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBPrivilege;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBRelationalUser;
import org.jkiss.dbeaver.ext.iotdb.ui.config.IoTDBCommandGrantPrivilege;
import org.jkiss.dbeaver.ext.iotdb.ui.controls.PrivilegeTableControl;
import org.jkiss.dbeaver.ext.iotdb.ui.editors.IoTDBUserEditorAbstract;
import org.jkiss.dbeaver.ext.iotdb.ui.internal.IoTDBUiMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;

public class IoTDBUserEditorPrivileges
extends IoTDBUserEditorAbstract {
    private static Log log = Log.getLog(IoTDBUserEditorPrivileges.class);
    private PageControl pageControl;
    private Table databasesTable;
    private Table tablesTable;
    private boolean isLoaded = false;
    private IoTDBRelationalUser.IoTDBDatabase selectedDatabase;
    private String selectedTable;
    private PrivilegeTableControl tablePrivilegesTable;
    private volatile List<IoTDBGrant> grants;
    private Font boldFont;

    public void createPartControl(Composite parent) {
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        this.pageControl = new PageControl(parent);
        GridData gd = new GridData(1808);
        CustomSashForm sash = new CustomSashForm((Composite)this.pageControl, 256);
        sash.setLayoutData((Object)gd);
        Composite leftPane = UIUtils.createPlaceholder((Composite)sash, (int)2);
        leftPane.setLayoutData((Object)new GridData(1808));
        leftPane.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        Group databaseGroup = UIUtils.createControlGroup((Composite)leftPane, (String)"Databases", (int)1, (int)1808, (int)0);
        this.databasesTable = new Table((Composite)databaseGroup, 2820);
        this.databasesTable.setHeaderVisible(true);
        gd = new GridData(1808);
        this.databasesTable.setLayoutData((Object)gd);
        this.databasesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = IoTDBUserEditorPrivileges.this.databasesTable.getSelectionIndex();
                IoTDBUserEditorPrivileges.this.selectedDatabase = selIndex < 0 ? null : (IoTDBRelationalUser.IoTDBDatabase)IoTDBUserEditorPrivileges.this.databasesTable.getItem(selIndex).getData();
                IoTDBUserEditorPrivileges.this.showDatabaseTables();
            }
        });
        UIUtils.createTableColumn((Table)this.databasesTable, (int)16384, (String)"Database");
        TableItem item = new TableItem(this.databasesTable, 0);
        item.setText("(ALL)");
        item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
        item.setData((Object)((IoTDBRelationalUser)this.getDatabaseObject()).getDatabaseAll());
        for (IoTDBRelationalUser.IoTDBDatabase db : ((IoTDBRelationalUser)this.getDatabaseObject()).getDatabases()) {
            item = new TableItem(this.databasesTable, 0);
            item.setText(db.name);
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
            item.setData((Object)db);
        }
        UIUtils.packColumns((Table)this.databasesTable);
        Group tablesGroup = UIUtils.createControlGroup((Composite)leftPane, (String)"Tables", (int)1, (int)1808, (int)0);
        this.tablesTable = new Table((Composite)tablesGroup, 2820);
        this.tablesTable.setHeaderVisible(true);
        gd = new GridData(1808);
        this.tablesTable.setLayoutData((Object)gd);
        this.tablesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = IoTDBUserEditorPrivileges.this.tablesTable.getSelectionIndex();
                IoTDBUserEditorPrivileges.this.selectedTable = selIndex < 0 ? null : IoTDBUserEditorPrivileges.this.tablesTable.getItem(selIndex).getText();
                IoTDBUserEditorPrivileges.this.showGrants();
            }
        });
        UIUtils.createTableColumn((Table)this.tablesTable, (int)16384, (String)"Table");
        UIUtils.packColumns((Table)this.tablesTable);
        Composite rightPane = UIUtils.createPlaceholder((Composite)sash, (int)1);
        rightPane.setLayoutData((Object)new GridData(1808));
        this.tablePrivilegesTable = new PrivilegeTableControl(rightPane, "Table Privileges");
        gd = new GridData(1808);
        this.tablePrivilegesTable.setLayoutData(gd);
        sash.setSashBorders(new boolean[2]);
        this.pageControl.createProgressPanel();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UIUtils.dispose((Resource)IoTDBUserEditorPrivileges.this.boldFont);
            }
        });
        this.tablePrivilegesTable.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                IoTDBPrivilege privilege = (IoTDBPrivilege)event.data;
                int tp = event.detail;
                String db = IoTDBUserEditorPrivileges.this.selectedDatabase.name;
                String tb = IoTDBUserEditorPrivileges.this.selectedTable;
                IoTDBUserEditorPrivileges.this.addChangeCommand((DBECommand)new IoTDBCommandGrantPrivilege((IoTDBRelationalUser)IoTDBUserEditorPrivileges.this.getDatabaseObject(), tp, db, tb, privilege), (DBECommandReflector)new DBECommandReflector<IoTDBRelationalUser, IoTDBCommandGrantPrivilege>(){

                    public void redoCommand(IoTDBCommandGrantPrivilege command) {
                    }

                    public void undoCommand(IoTDBCommandGrantPrivilege command) {
                    }
                });
            }
        });
    }

    private void showDatabaseTables() {
        LoadingJob.createService((ILoadService)new DatabaseLoadService<List<String>>(IoTDBUiMessages.editors_user_editor_privileges_service_load_tables, this.getExecutionContext()){

            public List<String> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (IoTDBUserEditorPrivileges.this.selectedDatabase == null) {
                    return Collections.emptyList();
                }
                ArrayList<String> tables = new ArrayList<String>();
                if (!IoTDBUserEditorPrivileges.this.selectedDatabase.name.equals("(ALL)")) {
                    tables.add("(ALL)");
                }
                try {
                    tables.addAll(IoTDBUserEditorPrivileges.this.selectedDatabase.tables);
                    return tables;
                }
                catch (Exception e) {
                    log.error((Object)"Error loading tables", (Throwable)e);
                    return null;
                }
            }
        }, this.pageControl.createTablesLoadVisualizer()).schedule();
    }

    private void showGrants() {
        if (this.grants == null) {
            return;
        }
        ArrayList<IoTDBGrant> currentGrants = new ArrayList<IoTDBGrant>();
        String db = "";
        String tb = "";
        for (IoTDBGrant grant : this.grants) {
            db = this.selectedDatabase.name.equals("(ALL)") ? "*" : this.selectedDatabase.name;
            String string = tb = this.selectedTable.equals("(ALL)") ? "*" : this.selectedTable;
            if (!grant.matches(db, tb)) continue;
            currentGrants.add(grant);
        }
        this.tablePrivilegesTable.fillGrants(currentGrants);
    }

    public synchronized void activatePart() {
        if (this.isLoaded) {
            return;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            return;
        }
        this.isLoaded = true;
        LoadingJob.createService((ILoadService)new DatabaseLoadService<List<IoTDBPrivilege>>(IoTDBUiMessages.editors_user_editor_privileges_service_load_privileges, executionContext){

            public List<IoTDBPrivilege> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IoTDBRelationalUser user = (IoTDBRelationalUser)IoTDBUserEditorPrivileges.this.getDatabaseObject();
                if (user == null) {
                    IoTDBUserEditorPrivileges.this.isLoaded = false;
                    return null;
                }
                return user.getDataSource().getPrivilegesByKind(false);
            }
        }, this.pageControl.createPrivilegesLoadVisualizer()).schedule();
    }

    @Override
    protected PageControl getPageControl() {
        return this.pageControl;
    }

    @Override
    protected void processGrants(List<IoTDBGrant> grantsTmp) {
        this.grants = new ArrayList<IoTDBGrant>(grantsTmp);
        this.highlightDatabases();
        this.showGrants();
        this.showDatabaseTables();
    }

    private void highlightDatabases() {
        if (this.databasesTable != null && !this.databasesTable.isDisposed()) {
            TableItem[] tableItemArray = this.databasesTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                String db = item.getText();
                if (db.equals("(ALL)")) {
                    db = "*";
                }
                item.setFont(null);
                if (this.grants != null) {
                    for (IoTDBGrant grant : this.grants) {
                        if (!grant.canHighlightDatabase(db)) continue;
                        item.setFont(this.boldFont);
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    private void highlightTables() {
        if (this.tablesTable != null && !this.tablesTable.isDisposed()) {
            TableItem[] tableItemArray = this.tablesTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                String tb = item.getText();
                if (tb.equals("(ALL)")) {
                    tb = "*";
                }
                item.setFont(null);
                if (this.grants != null) {
                    for (IoTDBGrant grant : this.grants) {
                        if (!grant.canHighlightTable(this.selectedDatabase.name, tb)) continue;
                        item.setFont(this.boldFont);
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        if (force || source instanceof DBNEvent && ((DBNEvent)source).getSource() == DBNEvent.UPDATE_ON_SAVE || !this.isLoaded) {
            this.isLoaded = false;
            this.activatePart();
            return IRefreshablePart.RefreshResult.REFRESHED;
        }
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    private class PageControl
    extends IoTDBUserEditorAbstract.UserPageControl {
        public PageControl(Composite parent) {
            super(parent);
        }

        public ProgressPageControl.ProgressVisualizer<List<String>> createTablesLoadVisualizer() {
            return new ProgressPageControl.ProgressVisualizer<List<String>>((ProgressPageControl)this){

                public void completeLoading(List<String> tables) {
                    super.completeLoading(tables);
                    if (((PageControl)PageControl.this).IoTDBUserEditorPrivileges.this.tablesTable.isDisposed()) {
                        return;
                    }
                    ((PageControl)PageControl.this).IoTDBUserEditorPrivileges.this.tablesTable.removeAll();
                    if (tables != null) {
                        for (String table : tables) {
                            TableItem item = new TableItem(((PageControl)PageControl.this).IoTDBUserEditorPrivileges.this.tablesTable, 0);
                            item.setText(table);
                            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_TABLE));
                            item.setData((Object)table);
                        }
                        IoTDBUserEditorPrivileges.this.highlightTables();
                    }
                    UIUtils.packColumns((Table)((PageControl)PageControl.this).IoTDBUserEditorPrivileges.this.tablesTable);
                }
            };
        }

        public ProgressPageControl.ProgressVisualizer<List<IoTDBPrivilege>> createPrivilegesLoadVisualizer() {
            return new ProgressPageControl.ProgressVisualizer<List<IoTDBPrivilege>>((ProgressPageControl)this){

                public void completeLoading(List<IoTDBPrivilege> privileges) {
                    super.completeLoading(privileges);
                    ((PageControl)PageControl.this).IoTDBUserEditorPrivileges.this.tablePrivilegesTable.fillPrivileges(privileges);
                    IoTDBUserEditorPrivileges.this.loadGrants();
                }
            };
        }
    }
}

