/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.plaintext;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextFindReplaceTarget;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDisplayFormatProvider;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetThemeSettings;
import org.jkiss.dbeaver.ui.controls.resultset.plaintext.PlainTextFormatter;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;

public class PlainTextPresentation
extends AbstractPresentation
implements IResultSetDisplayFormatProvider,
DBPAdaptable {
    public static final int FIRST_ROW_LINE = 2;
    public static final Color COLOR_GREEN_CONTRAST = new Color(null, 23, 135, 58);
    private StyledText text;
    private DBDAttributeBinding curAttribute;
    private StyledTextFindReplaceTarget findReplaceTarget;
    public boolean activated;
    private Color curLineColor;
    private int[] colWidths;
    private int startOffset;
    private StyleRange curLineRange;
    private int totalRows = 0;
    private String curSelection;
    private static PrinterData fgPrinterData = null;

    @Override
    public void createPresentation(final @NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        UIUtils.createHorizontalLine((Composite)parent);
        this.text = new StyledText(parent, 778);
        this.text.setBlockSelection(true);
        this.text.setCursor(parent.getDisplay().getSystemCursor(19));
        this.text.setMargins(4, 4, 4, 4);
        this.text.setForeground(UIStyles.getDefaultTextForeground());
        this.text.setBackground(UIStyles.getDefaultTextBackground());
        this.text.setTabs(controller.getPreferenceStore().getInt("resultset.text.tab.size"));
        this.text.setTabStops(null);
        this.text.setFont(UIUtils.getMonospaceFont());
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.addCaretListener(event -> this.onCursorChange(event.caretOffset));
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlainTextPresentation.this.curSelection = PlainTextPresentation.this.text.getSelectionText();
                PlainTextPresentation.this.fireSelectionChanged((ISelection)new PlainTextSelectionImpl());
            }
        });
        final ScrollBar verticalBar = this.text.getVerticalBar();
        verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (verticalBar.getSelection() + verticalBar.getPageIncrement() >= verticalBar.getMaximum() && controller.getPreferenceStore().getBoolean("resultset.autofetch.next.segment") && !controller.isRecordMode() && controller.isHasMoreData()) {
                    controller.readNextSegment();
                }
            }
        });
        this.findReplaceTarget = new StyledTextFindReplaceTarget(this.text);
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)controller.getSite(), (Control)this.text);
        this.applyCurrentThemeSettings();
        this.registerContextMenu();
        this.activateTextKeyBindings(controller, (Control)this.text);
        this.trackPresentationControl();
    }

    @Override
    protected void applyThemeSettings(ITheme currentTheme) {
        this.text.setFont(BaseThemeSettings.instance.monospaceFont);
        if (UIStyles.isDarkHighContrastTheme()) {
            this.text.setBackground(UIStyles.getDefaultWidgetBackground());
            this.text.setForeground(UIStyles.COLOR_WHITE);
            this.curLineColor = COLOR_GREEN_CONTRAST;
        } else {
            this.curLineColor = ResultSetThemeSettings.instance.backgroundOdd;
        }
    }

    private void onCursorChange(int offset) {
        ResultSetModel model = this.controller.getModel();
        DBPPreferenceStore prefs = this.controller.getPreferenceStore();
        int lineNum = this.text.getLineAtOffset(offset);
        int lineOffset = this.text.getOffsetAtLine(lineNum);
        int horizontalOffset = offset - lineOffset;
        int lineCount = this.text.getLineCount();
        boolean delimLeading = this.getController().getPreferenceStore().getBoolean("resultset.text.delimiter.leading");
        boolean delimTop = prefs.getBoolean("resultset.text.delimiter.top");
        int rowNum = lineNum - 2 - (delimTop ? 1 : 0);
        if (this.controller.isRecordMode()) {
            if (rowNum < 0) {
                rowNum = 0;
            }
            if (rowNum >= 0 && rowNum < model.getVisibleAttributeCount()) {
                this.curAttribute = model.getVisibleAttribute(rowNum);
            }
        } else {
            int colNum = 0;
            int horOffsetBegin = 0;
            int horOffsetEnd = this.startOffset;
            if (delimLeading) {
                ++horOffsetEnd;
            }
            int i = 0;
            while (i < this.colWidths.length) {
                horOffsetBegin = horOffsetEnd;
                if (horizontalOffset < (horOffsetEnd += this.colWidths[i] + 1)) {
                    colNum = i;
                    break;
                }
                ++i;
            }
            if (rowNum < 0 && model.getRowCount() > 0) {
                rowNum = 0;
            }
            if (rowNum >= 0 && rowNum < model.getRowCount() && colNum >= 0 && colNum < model.getVisibleAttributeCount()) {
                this.controller.setCurrentRow(model.getRow(rowNum));
                this.curAttribute = model.getVisibleAttribute(colNum);
            }
            this.controller.updateEditControls();
            if (this.curLineRange == null || this.curLineRange.start != lineOffset + horOffsetBegin) {
                this.curLineRange = new StyleRange(lineOffset + horOffsetBegin, horOffsetEnd - horOffsetBegin - 1, null, this.curLineColor);
                this.text.setStyleRanges(new StyleRange[]{this.curLineRange});
                this.text.redraw();
            }
            if (lineNum == lineCount - 1 && this.controller.isHasMoreData() && this.controller.getPreferenceStore().getBoolean("resultset.autofetch.next.segment")) {
                this.controller.readNextSegment();
            }
        }
        this.fireSelectionChanged((ISelection)new PlainTextSelectionImpl());
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        if (this.controller.isRecordMode()) {
            this.printRecord();
        } else {
            this.printGrid(append);
        }
    }

    private void printGrid(boolean append) {
        StringBuilder grid = new StringBuilder(512);
        PlainTextFormatter formatter = new PlainTextFormatter(this.getController().getPreferenceStore());
        ResultSetModel model = this.controller.getModel();
        this.totalRows = formatter.printGrid(grid, model);
        this.colWidths = formatter.getColWidths();
        this.startOffset = formatter.getStartOffset();
        int topIndex = this.text.getTopIndex();
        int horizontalIndex = this.text.getHorizontalIndex();
        int caretOffset = this.text.getCaretOffset();
        this.text.setText(grid.toString());
        if (append) {
            this.text.setTopIndex(topIndex);
            this.text.setHorizontalIndex(horizontalIndex);
            this.text.setCaretOffset(caretOffset);
        }
    }

    private void printRecord() {
        PlainTextFormatter formatter = new PlainTextFormatter(this.getController().getPreferenceStore());
        StringBuilder grid = new StringBuilder(512);
        formatter.printRecord(grid, this.controller.getModel(), this.controller.getCurrentRow());
        this.text.setText(grid.toString());
    }

    @Override
    @NotNull
    public String getFontId() {
        return "org.jkiss.dbeaver.dbeaver.ui.fonts.monospace";
    }

    @Override
    public void formatData(boolean refreshData) {
    }

    @Override
    public void clearMetaData() {
        this.colWidths = null;
        this.curLineRange = null;
        this.totalRows = 0;
    }

    @Override
    public void updateValueView() {
    }

    @Override
    public void fillMenu(@NotNull IMenuManager menu) {
    }

    @Override
    public void changeMode(boolean recordMode) {
        this.text.setSelection(0);
        this.text.setBlockSelectionBounds(new Rectangle(0, 0, 0, 0));
        this.curSelection = null;
    }

    @Override
    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
        if (this.controller.isRecordMode()) {
            super.scrollToRow(position);
        } else {
            int lineNum;
            int caretOffset = this.text.getCaretOffset();
            if (caretOffset < 0) {
                caretOffset = 0;
            }
            if ((lineNum = this.text.getLineAtOffset(caretOffset)) < 2) {
                lineNum = 2;
            }
            int lineOffset = this.text.getOffsetAtLine(lineNum);
            int xOffset = caretOffset - lineOffset;
            int totalLines = this.text.getLineCount();
            switch (position) {
                case FIRST: {
                    lineNum = 2;
                    break;
                }
                case PREVIOUS: {
                    --lineNum;
                    break;
                }
                case NEXT: {
                    ++lineNum;
                    break;
                }
                case LAST: {
                    lineNum = totalLines - 1;
                    break;
                }
                case CURRENT: {
                    lineNum = this.controller.getCurrentRow().getVisualNumber() + 2;
                }
            }
            if (lineNum < 2 || lineNum >= totalLines) {
                return;
            }
            int newOffset = this.text.getOffsetAtLine(lineNum);
            this.text.setCaretOffset(newOffset += xOffset);
            this.text.showSelection();
        }
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.curAttribute;
    }

    @Override
    @NotNull
    public Map<Transfer, Object> copySelection(ResultSetCopySettings settings) {
        return Collections.singletonMap(TextTransfer.getInstance(), this.text.getSelectionText());
    }

    @Override
    public void printResultSet() {
        Shell shell = this.getControl().getShell();
        StyledTextPrintOptions options = new StyledTextPrintOptions();
        options.printTextFontStyle = true;
        options.printTextForeground = true;
        if (Printer.getPrinterList().length == 0) {
            UIUtils.showMessageBox((Shell)shell, (String)"No printers", (String)"Printers not found", (int)1);
            return;
        }
        PrintDialog dialog = new PrintDialog(shell, 32768);
        dialog.setPrinterData(fgPrinterData);
        PrinterData data = dialog.open();
        if (data != null) {
            final Printer printer = new Printer(data);
            final Runnable styledTextPrinter = this.text.print(printer, options);
            new Thread("Printing"){

                @Override
                public void run() {
                    styledTextPrinter.run();
                    printer.dispose();
                }
            }.start();
            fgPrinterData = data;
            PlainTextPresentation.fgPrinterData.startPage = 1;
            PlainTextPresentation.fgPrinterData.endPage = 1;
            PlainTextPresentation.fgPrinterData.scope = 0;
            PlainTextPresentation.fgPrinterData.copyCount = 1;
        }
    }

    @Override
    protected void performHorizontalScroll(int scrollCount) {
        ScrollBar hsb = this.text.getHorizontalBar();
        if (hsb != null && hsb.isVisible()) {
            int curPosition = this.text.getHorizontalPixel();
            int pageIncrement = UIUtils.getFontHeight((Font)this.text.getFont()) * 10;
            if (scrollCount > 0) {
                if (curPosition > 0) {
                    curPosition -= pageIncrement;
                }
            } else {
                curPosition += pageIncrement;
            }
            if (curPosition < 0) {
                curPosition = 0;
            }
            this.text.setHorizontalPixel(curPosition);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IFindReplaceTarget.class) {
            return adapter.cast(this.findReplaceTarget);
        }
        return null;
    }

    @Override
    public ISelection getSelection() {
        return new PlainTextSelectionImpl();
    }

    @Override
    public DBDDisplayFormat getDefaultDisplayFormat() {
        return DBDDisplayFormat.safeValueOf((String)this.controller.getPreferenceStore().getString("resultset.text.value.format"));
    }

    @Override
    public void setDefaultDisplayFormat(DBDDisplayFormat displayFormat) {
        this.controller.getPreferenceStore().setValue("resultset.text.value.format", displayFormat.name());
    }

    private class PlainTextSelectionImpl
    implements IResultSetSelection {
        private PlainTextSelectionImpl() {
        }

        @Nullable
        public Object getFirstElement() {
            return PlainTextPresentation.this.curSelection;
        }

        @NotNull
        public Iterator<String> iterator() {
            return this.toList().iterator();
        }

        public int size() {
            return PlainTextPresentation.this.curSelection == null ? 0 : 1;
        }

        public Object[] toArray() {
            Object[] objectArray;
            if (PlainTextPresentation.this.curSelection == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = PlainTextPresentation.this.curSelection;
            }
            return objectArray;
        }

        public List<String> toList() {
            return PlainTextPresentation.this.curSelection == null ? Collections.emptyList() : Collections.singletonList(PlainTextPresentation.this.curSelection);
        }

        public boolean isEmpty() {
            return false;
        }

        @Override
        @NotNull
        public IResultSetController getController() {
            return PlainTextPresentation.this.controller;
        }

        @Override
        @NotNull
        public List<DBDAttributeBinding> getSelectedAttributes() {
            if (PlainTextPresentation.this.curAttribute == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(PlainTextPresentation.this.curAttribute);
        }

        @Override
        @NotNull
        public List<ResultSetRow> getSelectedRows() {
            ResultSetRow currentRow = PlainTextPresentation.this.controller.getCurrentRow();
            if (currentRow == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(currentRow);
        }

        @Override
        public DBDAttributeBinding getElementAttribute(Object element) {
            return PlainTextPresentation.this.curAttribute;
        }

        @Override
        public ResultSetRow getElementRow(Object element) {
            return this.getController().getCurrentRow();
        }
    }
}

