/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.utils.CommonUtils;

public class AIEngineRegistry {
    private static final Log log = Log.getLog(AIEngineRegistry.class);
    private static AIEngineRegistry instance = null;
    private final Map<String, AIEngineDescriptor> descriptorMap = new LinkedHashMap<String, AIEngineDescriptor>();
    private final Map<String, String> replaceMap = new LinkedHashMap<String, String>();

    public static synchronized AIEngineRegistry getInstance() {
        if (instance == null) {
            instance = new AIEngineRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public AIEngineRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("com.dbeaver.ai.engine");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("completionEngine".equals(ext.getName())) {
                AIEngineDescriptor descriptor = new AIEngineDescriptor(ext);
                this.descriptorMap.put(descriptor.getId(), descriptor);
                String replaces = descriptor.getReplaces();
                if (!CommonUtils.isEmpty((String)replaces)) {
                    String[] stringArray = replaces.split(",");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String rl = stringArray[n4];
                        this.replaceMap.put(rl, descriptor.getId());
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    public List<AIEngineDescriptor> getCompletionEngines() {
        ArrayList<AIEngineDescriptor> list = new ArrayList<AIEngineDescriptor>();
        for (Map.Entry<String, AIEngineDescriptor> entry : this.descriptorMap.entrySet()) {
            if (this.replaceMap.containsKey(entry.getKey())) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public AIEngineDescriptor getDefaultCompletionEngineDescriptor() {
        return this.getCompletionEngines().stream().filter(AIEngineDescriptor::isDefault).findFirst().orElse(null);
    }

    public AIEngine getCompletionEngine(String id) throws DBException {
        AIEngineDescriptor descriptor = this.getEngineDescriptor(id);
        if (descriptor == null) {
            log.trace((Object)"Active engine is not present in the configuration, switching to default active engine");
            AIEngineDescriptor defaultCompletionEngineDescriptor = this.getDefaultCompletionEngineDescriptor();
            if (defaultCompletionEngineDescriptor == null) {
                throw new DBException("AI engine '" + id + "' not found");
            }
            descriptor = defaultCompletionEngineDescriptor;
        }
        return descriptor.createInstance();
    }

    public AIEngineDescriptor getEngineDescriptor(String id) {
        String replace;
        while ((replace = this.replaceMap.get(id)) != null) {
            id = replace;
        }
        return this.descriptorMap.get(id);
    }
}

