/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Hashtable;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Vector;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import gps.log.out.GPSFile;
import gps.log.out.WayPointStyle;
import gps.tracks.PolylineEncoder;
import gps.tracks.Track;
import gps.tracks.Trackpoint;

public final class GPSGoogleStaticMapUrl
extends GPSFile {
    private BT747Vector urls = JavaLibBridge.getVectorInstance();
    private final StringBuffer rec = new StringBuffer(1024);
    private boolean isWayType;
    private boolean isNewTrack = true;
    private int currentFilter;
    private final Track track = new Track();
    private final Track waypoints = new Track();
    private int trackIndex = 0;
    private double minlat;
    private double maxlat;
    private double minlon;
    private double maxlon;
    private int xSize = 400;
    private int ySize = 400;
    private int maxLen = 2000;
    private final BT747Hashtable icons = JavaLibBridge.getHashtableInstance(10);
    private int previousTime = 0;
    private int previousRec = 0;

    public GPSGoogleStaticMapUrl() {
        this.numberOfPasses = 2;
    }

    @Override
    public final void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        this.currentFilter = 1;
        this.isWayType = true;
        this.resetTrack();
    }

    private final void resetTrack() {
        this.track.removeAll();
    }

    @Override
    public final boolean nextPass() {
        super.nextPass();
        if (this.nbrOfPassesToGo > 0) {
            --this.nbrOfPassesToGo;
            this.previousDate = 0;
            this.isWayType = false;
            this.currentFilter = 0;
            return true;
        }
        return false;
    }

    @Override
    protected final void writeFileHeader(String string) {
    }

    @Override
    protected final void writeDataHeader() {
        if (!this.isWayType) {
            this.isNewTrack = true;
            this.minlat = 90.0;
            this.maxlat = -90.0;
            this.minlon = 180.0;
            this.maxlon = -180.0;
        }
    }

    protected final void endTrack(String object) {
        String string;
        object = new PolylineEncoder();
        int n = 10;
        while ((string = PolylineEncoder.replace(PolylineEncoder.replace((String)((PolylineEncoder)object).dpEncode(this.track).get("encodedPoints"), "|", "%7C"), "\\\\", "\\")).length() > this.maxLen && n-- > 0) {
        }
        if (string.length() >= 2) {
            this.rec.setLength(0);
            this.rec.append("http://maps.google.com/maps/api/staticmap?sensor=false&size=");
            this.rec.append(this.xSize);
            this.rec.append("x");
            this.rec.append(this.ySize);
            this.rec.append(this.keyCode());
            this.rec.append("&path=weight:3");
            this.rec.append("|color:0x");
            this.rec.append(this.goodTrackColor);
            this.rec.append("|enc:");
            this.rec.append(string);
            this.urls.addElement(this.rec.toString());
            Generic.debug(this.rec.toString());
            this.rec.setLength(0);
        }
        ++this.trackIndex;
        this.resetTrack();
    }

    private final String keyCode() {
        String string = this.getParamObject().getStringParam("googlemapkey");
        if (string != null && string.length() != 0) {
            return "&key=" + string;
        }
        return "";
    }

    @Override
    protected final void writeDataFooter() {
        if (this.isWayType) {
            if (this.waypoints.size() != 0) {
                this.rec.setLength(0);
                this.rec.append("var baseIcon = new GIcon(G_DEFAULT_ICON);\nbaseIcon.iconSize = new GSize(32, 32);\n");
                BT747Hashtable bT747Hashtable = this.icons.iterator();
                while (bT747Hashtable.hasNext()) {
                    Object object = bT747Hashtable.nextKey();
                    this.rec.append("var ICON");
                    this.rec.append((String)object);
                    this.rec.append("=new GIcon(baseIcon);");
                    this.rec.append("ICON");
                    this.rec.append((String)object);
                    this.rec.append(".image='");
                    this.rec.append((String)bT747Hashtable.get(object));
                    this.rec.append("';\n");
                }
                for (int i = 0; i < this.waypoints.size(); ++i) {
                    this.rec.append(JavaLibBridge.toString(this.waypoints.get(i).getLatDouble(), 5));
                    this.rec.append(JavaLibBridge.toString(this.waypoints.get(i).getLonDouble(), 5));
                }
                this.rec.setCharAt(this.rec.length() - 1, ']');
                this.rec.setLength(0);
                this.waypoints.removeAll();
            }
            this.resetTrack();
            return;
        }
        this.endTrack(this.goodTrackColor);
        this.splitOrEndTrack();
    }

    private final void splitOrEndTrack() {
    }

    @Override
    public final void writeRecord(GPSRecord object) {
        super.writeRecord((GPSRecord)object);
        if (!this.ptFilters[this.currentFilter].doFilter((GPSRecord)object)) {
            if (!(this.isWayType || this.isNewTrack || this.firstRecord || this.ignoreBadPoints)) {
                this.isNewTrack = true;
                if (this.track.size() != 0) {
                    Trackpoint trackpoint = this.track.get(this.track.size() - 1);
                    this.endTrack(this.goodTrackColor);
                    this.track.addTrackpoint(trackpoint);
                }
            }
            if (!this.isWayType && this.cachedRecordIsNeeded((GPSRecord)object)) {
                if (((GPSRecord)object).getLatitude() < this.minlat) {
                    this.minlat = ((GPSRecord)object).getLatitude();
                }
                if (((GPSRecord)object).getLatitude() > this.maxlat) {
                    this.maxlat = ((GPSRecord)object).getLatitude();
                }
                if (((GPSRecord)object).getLongitude() < this.minlon) {
                    this.minlon = ((GPSRecord)object).getLongitude();
                }
                if (((GPSRecord)object).getLongitude() > this.maxlon) {
                    this.maxlon = ((GPSRecord)object).getLongitude();
                    return;
                }
            }
        } else {
            Object object2;
            if (!this.isWayType) {
                this.rec.setLength(0);
                if (this.isNewTrack || this.needsToSplitTrack) {
                    this.isNewTrack = false;
                    if (((GPSRecord)object).hasLatitude() && ((GPSRecord)object).hasLongitude()) {
                        if (!this.needsToSplitTrack) {
                            this.track.addTrackpoint(new Trackpoint(((GPSRecord)object).getLatitude(), ((GPSRecord)object).getLongitude()));
                            if (((GPSRecord)object).hasUtc()) {
                                this.previousTime = ((GPSRecord)object).getUtc();
                                this.previousRec = ((GPSRecord)object).recCount;
                            }
                            this.endTrack(this.badTrackColor);
                        } else {
                            this.endTrack(this.goodTrackColor);
                            this.splitOrEndTrack();
                        }
                    }
                    this.resetTrack();
                }
            }
            if (((GPSRecord)object).hasUtc()) {
                this.previousTime = ((GPSRecord)object).getUtc();
                this.previousRec = ((GPSRecord)object).getRecCount();
            }
            if (((GPSRecord)object).hasLatitude() && ((GPSRecord)object).hasLongitude()) {
                object2 = new Trackpoint(((GPSRecord)object).getLatitude(), ((GPSRecord)object).getLongitude());
                this.track.addTrackpoint((Trackpoint)object2);
                if (((Trackpoint)object2).getLatDouble() < this.minlat) {
                    this.minlat = ((Trackpoint)object2).getLatDouble();
                }
                if (((Trackpoint)object2).getLatDouble() > this.maxlat) {
                    this.maxlat = ((Trackpoint)object2).getLatDouble();
                }
                if (((Trackpoint)object2).getLonDouble() < this.minlon) {
                    this.minlon = ((Trackpoint)object2).getLonDouble();
                }
                if (((Trackpoint)object2).getLonDouble() > this.maxlon) {
                    this.maxlon = ((Trackpoint)object2).getLonDouble();
                }
            }
            if (this.isWayType && ((GPSRecord)object).hasLatitude() && ((GPSRecord)object).hasLongitude()) {
                this.waypoints.addTrackpoint(new Trackpoint(((GPSRecord)object).getLatitude(), ((GPSRecord)object).getLongitude()));
                object2 = CommonOut.getRCRstr((GPSRecord)object);
                if (this.icons.get(object2) == null && (object = ((String)object2).length() > 0 && ((String)object2).charAt(0) == 'X' ? CommonOut.getWayPointStyles().get(((String)object2).substring(1)) : (((String)object2).length() > 1 ? CommonOut.getWayPointStyles().get("M") : CommonOut.getWayPointStyles().get((String)object2))) != null) {
                    object = ((WayPointStyle)object).getIconUrl();
                    this.icons.put(object2, object);
                }
            }
            this.rec.setLength(0);
        }
    }

    @Override
    public final void finaliseFile() {
        if (this.isOpen()) {
            for (int i = 0; i < this.urls.size(); ++i) {
                this.writeTxt((String)this.urls.elementAt(i));
                this.writeTxt("\r\n");
            }
            this.writeDataFooter();
        }
        super.finaliseFile();
    }
}

