/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.catalina.ha.deploy.FileMessage;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.res.StringManager;

public class FileMessageFactory {
    private static final Log log = LogFactory.getLog(FileMessageFactory.class);
    private static final StringManager sm = StringManager.getManager(FileMessageFactory.class);
    public static final int READ_SIZE = 10240;
    protected final File file;
    protected final boolean openForWrite;
    protected boolean closed = false;
    protected FileInputStream in;
    protected FileOutputStream out;
    protected int nrOfMessagesProcessed = 0;
    protected long size = 0L;
    protected long totalNrOfMessages = 0L;
    protected AtomicLong lastMessageProcessed = new AtomicLong(0L);
    protected final Map<Long, FileMessage> msgBuffer = new ConcurrentHashMap<Long, FileMessage>();
    protected byte[] data = new byte[10240];
    protected boolean isWriting = false;
    @Deprecated
    protected long creationTime = 0L;
    protected long lastModified = 0L;
    protected int maxValidTime = -1;

    private FileMessageFactory(File file, boolean bl) throws FileNotFoundException, IOException {
        this.file = file;
        this.openForWrite = bl;
        if (log.isDebugEnabled()) {
            log.debug((Object)("open file " + file + " write " + bl));
        }
        if (bl) {
            if (!this.file.exists() && !this.file.createNewFile()) {
                throw new IOException(sm.getString("fileNewFail", new Object[]{this.file}));
            }
            this.out = new FileOutputStream(file);
        } else {
            this.size = this.file.length();
            this.totalNrOfMessages = this.size / 10240L + 1L;
            this.in = new FileInputStream(file);
        }
        this.creationTime = System.currentTimeMillis();
        this.lastModified = System.currentTimeMillis();
    }

    public static FileMessageFactory getInstance(File file, boolean bl) throws FileNotFoundException, IOException {
        return new FileMessageFactory(file, bl);
    }

    public FileMessage readMessage(FileMessage fileMessage) throws IllegalArgumentException, IOException {
        this.checkState(false);
        int n = this.in.read(this.data);
        if (n == -1) {
            this.cleanup();
            return null;
        }
        fileMessage.setData(this.data, n);
        fileMessage.setTotalNrOfMsgs(this.totalNrOfMessages);
        fileMessage.setMessageNumber(++this.nrOfMessagesProcessed);
        return fileMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMessage(FileMessage fileMessage) throws IllegalArgumentException, IOException {
        if (!this.openForWrite) {
            throw new IllegalArgumentException(sm.getString("fileMessageFactory.cannotWrite"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message " + fileMessage + " data " + HexUtils.toHexString((byte[])fileMessage.getData()) + " data length " + fileMessage.getDataLength() + " out " + this.out));
        }
        if ((long)fileMessage.getMessageNumber() <= this.lastMessageProcessed.get()) {
            log.warn((Object)sm.getString("fileMessageFactory.duplicateMessage", new Object[]{fileMessage.getContextName(), fileMessage.getFileName(), HexUtils.toHexString((byte[])fileMessage.getData()), fileMessage.getDataLength()}));
            return false;
        }
        FileMessage fileMessage2 = this.msgBuffer.put(Long.valueOf(fileMessage.getMessageNumber()), fileMessage);
        if (fileMessage2 != null) {
            log.warn((Object)sm.getString("fileMessageFactory.duplicateMessage", new Object[]{fileMessage.getContextName(), fileMessage.getFileName(), HexUtils.toHexString((byte[])fileMessage.getData()), fileMessage.getDataLength()}));
            return false;
        }
        this.lastModified = System.currentTimeMillis();
        FileMessage fileMessage3 = null;
        FileMessageFactory fileMessageFactory = this;
        synchronized (fileMessageFactory) {
            if (!this.isWriting) {
                fileMessage3 = this.msgBuffer.get(this.lastMessageProcessed.get() + 1L);
                if (fileMessage3 == null) {
                    return false;
                }
            } else {
                return false;
            }
            this.isWriting = true;
        }
        while (fileMessage3 != null) {
            this.out.write(fileMessage3.getData(), 0, fileMessage3.getDataLength());
            this.lastMessageProcessed.incrementAndGet();
            this.out.flush();
            if ((long)fileMessage3.getMessageNumber() == fileMessage3.getTotalNrOfMsgs()) {
                this.out.close();
                this.cleanup();
                return true;
            }
            fileMessageFactory = this;
            synchronized (fileMessageFactory) {
                fileMessage3 = this.msgBuffer.get(this.lastMessageProcessed.get() + 1L);
                if (fileMessage3 == null) {
                    this.isWriting = false;
                }
            }
        }
        return false;
    }

    public void cleanup() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.in = null;
        this.out = null;
        this.size = 0L;
        this.closed = true;
        this.data = null;
        this.nrOfMessagesProcessed = 0;
        this.totalNrOfMessages = 0L;
        this.msgBuffer.clear();
        this.lastMessageProcessed = null;
    }

    protected void checkState(boolean bl) throws IllegalArgumentException {
        if (this.openForWrite != bl) {
            this.cleanup();
            if (bl) {
                throw new IllegalArgumentException(sm.getString("fileMessageFactory.cannotWrite"));
            }
            throw new IllegalArgumentException(sm.getString("fileMessageFactory.cannotRead"));
        }
        if (this.closed) {
            this.cleanup();
            throw new IllegalArgumentException(sm.getString("fileMessageFactory.closed"));
        }
    }

    public File getFile() {
        return this.file;
    }

    public boolean isValid() {
        long l;
        long l2;
        if (this.maxValidTime > 0 && (l2 = ((l = System.currentTimeMillis()) - this.lastModified) / 1000L) > (long)this.maxValidTime) {
            this.cleanup();
            if (this.file.exists()) {
                if (this.file.delete()) {
                    log.warn((Object)sm.getString("fileMessageFactory.delete", new Object[]{this.file, Long.toString(this.maxValidTime)}));
                } else {
                    log.warn((Object)sm.getString("fileMessageFactory.deleteFail", new Object[]{this.file}));
                }
            }
            return false;
        }
        return true;
    }

    public int getMaxValidTime() {
        return this.maxValidTime;
    }

    public void setMaxValidTime(int n) {
        this.maxValidTime = n;
    }
}

