// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from k210.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Kendryte-Community

//go:build kendryte && k210

// Kendryte K210 64-bit RISC-V CPU
//

package kendryte

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device = "K210"
)

// Interrupt numbers.
const (
	// Serial Peripheral Interface 0 (master)
	IRQ_SPI0 = 1

	// Serial Peripheral Interface 1 (master)
	IRQ_SPI1 = 2

	// Serial Peripheral Interface 2 (slave)
	IRQ_SPI_SLAVE = 3

	// Serial Peripheral Interface 3 (master)
	IRQ_SPI3 = 4

	// Inter-Integrated Sound Interface 0
	IRQ_I2S0 = 5

	// Inter-Integrated Sound Interface 1
	IRQ_I2S1 = 6

	// Inter-Integrated Sound Interface 2
	IRQ_I2S2 = 7

	// Inter-Integrated Circuit Bus 0
	IRQ_I2C0 = 8

	// Inter-Integrated Circuit Bus 1
	IRQ_I2C1 = 9

	// Inter-Integrated Circuit Bus 2
	IRQ_I2C2 = 10

	// Universal Asynchronous Receiver-Transmitter 1
	IRQ_UART1 = 11

	// Universal Asynchronous Receiver-Transmitter 2
	IRQ_UART2 = 12

	// Universal Asynchronous Receiver-Transmitter 3
	IRQ_UART3 = 13

	// Timer 0
	IRQ_TIMER0A = 14

	// Timer 0
	IRQ_TIMER0B = 15

	// Timer 1
	IRQ_TIMER1A = 16

	// Timer 1
	IRQ_TIMER1B = 17

	// Timer 2
	IRQ_TIMER2A = 18

	// Timer 2
	IRQ_TIMER2B = 19

	// Real Time Clock
	IRQ_RTC = 20

	// Watchdog Timer 0
	IRQ_WDT0 = 21

	// Watchdog Timer 1
	IRQ_WDT1 = 22

	// General Purpose Input/Output Interface
	IRQ_APB_GPIO = 23

	// Digital Video Port
	IRQ_DVP = 24

	// Neural Network Accelerator
	IRQ_KPU = 25

	// Fast Fourier Transform Accelerator
	IRQ_FFT = 26

	// Direct Memory Access Controller
	IRQ_DMA0 = 27

	// Direct Memory Access Controller
	IRQ_DMA1 = 28

	// Direct Memory Access Controller
	IRQ_DMA2 = 29

	// Direct Memory Access Controller
	IRQ_DMA3 = 30

	// Direct Memory Access Controller
	IRQ_DMA4 = 31

	// Direct Memory Access Controller
	IRQ_DMA5 = 32

	// High-speed UART
	IRQ_UARTHS = 33

	// High-speed GPIO
	IRQ_GPIOHS0 = 34

	// High-speed GPIO
	IRQ_GPIOHS1 = 35

	// High-speed GPIO
	IRQ_GPIOHS2 = 36

	// High-speed GPIO
	IRQ_GPIOHS3 = 37

	// High-speed GPIO
	IRQ_GPIOHS4 = 38

	// High-speed GPIO
	IRQ_GPIOHS5 = 39

	// High-speed GPIO
	IRQ_GPIOHS6 = 40

	// High-speed GPIO
	IRQ_GPIOHS7 = 41

	// High-speed GPIO
	IRQ_GPIOHS8 = 42

	// High-speed GPIO
	IRQ_GPIOHS9 = 43

	// High-speed GPIO
	IRQ_GPIOHS10 = 44

	// High-speed GPIO
	IRQ_GPIOHS11 = 45

	// High-speed GPIO
	IRQ_GPIOHS12 = 46

	// High-speed GPIO
	IRQ_GPIOHS13 = 47

	// High-speed GPIO
	IRQ_GPIOHS14 = 48

	// High-speed GPIO
	IRQ_GPIOHS15 = 49

	// High-speed GPIO
	IRQ_GPIOHS16 = 50

	// High-speed GPIO
	IRQ_GPIOHS17 = 51

	// High-speed GPIO
	IRQ_GPIOHS18 = 52

	// High-speed GPIO
	IRQ_GPIOHS19 = 53

	// High-speed GPIO
	IRQ_GPIOHS20 = 54

	// High-speed GPIO
	IRQ_GPIOHS21 = 55

	// High-speed GPIO
	IRQ_GPIOHS22 = 56

	// High-speed GPIO
	IRQ_GPIOHS23 = 57

	// High-speed GPIO
	IRQ_GPIOHS24 = 58

	// High-speed GPIO
	IRQ_GPIOHS25 = 59

	// High-speed GPIO
	IRQ_GPIOHS26 = 60

	// High-speed GPIO
	IRQ_GPIOHS27 = 61

	// High-speed GPIO
	IRQ_GPIOHS28 = 62

	// High-speed GPIO
	IRQ_GPIOHS29 = 63

	// High-speed GPIO
	IRQ_GPIOHS30 = 64

	// High-speed GPIO
	IRQ_GPIOHS31 = 65

	// Highest interrupt number on this device.
	IRQ_max = 65
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	case IRQ_SPI0:
		callHandlers(IRQ_SPI0)
	case IRQ_SPI1:
		callHandlers(IRQ_SPI1)
	case IRQ_SPI_SLAVE:
		callHandlers(IRQ_SPI_SLAVE)
	case IRQ_SPI3:
		callHandlers(IRQ_SPI3)
	case IRQ_I2S0:
		callHandlers(IRQ_I2S0)
	case IRQ_I2S1:
		callHandlers(IRQ_I2S1)
	case IRQ_I2S2:
		callHandlers(IRQ_I2S2)
	case IRQ_I2C0:
		callHandlers(IRQ_I2C0)
	case IRQ_I2C1:
		callHandlers(IRQ_I2C1)
	case IRQ_I2C2:
		callHandlers(IRQ_I2C2)
	case IRQ_UART1:
		callHandlers(IRQ_UART1)
	case IRQ_UART2:
		callHandlers(IRQ_UART2)
	case IRQ_UART3:
		callHandlers(IRQ_UART3)
	case IRQ_TIMER0A:
		callHandlers(IRQ_TIMER0A)
	case IRQ_TIMER0B:
		callHandlers(IRQ_TIMER0B)
	case IRQ_TIMER1A:
		callHandlers(IRQ_TIMER1A)
	case IRQ_TIMER1B:
		callHandlers(IRQ_TIMER1B)
	case IRQ_TIMER2A:
		callHandlers(IRQ_TIMER2A)
	case IRQ_TIMER2B:
		callHandlers(IRQ_TIMER2B)
	case IRQ_RTC:
		callHandlers(IRQ_RTC)
	case IRQ_WDT0:
		callHandlers(IRQ_WDT0)
	case IRQ_WDT1:
		callHandlers(IRQ_WDT1)
	case IRQ_APB_GPIO:
		callHandlers(IRQ_APB_GPIO)
	case IRQ_DVP:
		callHandlers(IRQ_DVP)
	case IRQ_KPU:
		callHandlers(IRQ_KPU)
	case IRQ_FFT:
		callHandlers(IRQ_FFT)
	case IRQ_DMA0:
		callHandlers(IRQ_DMA0)
	case IRQ_DMA1:
		callHandlers(IRQ_DMA1)
	case IRQ_DMA2:
		callHandlers(IRQ_DMA2)
	case IRQ_DMA3:
		callHandlers(IRQ_DMA3)
	case IRQ_DMA4:
		callHandlers(IRQ_DMA4)
	case IRQ_DMA5:
		callHandlers(IRQ_DMA5)
	case IRQ_UARTHS:
		callHandlers(IRQ_UARTHS)
	case IRQ_GPIOHS0:
		callHandlers(IRQ_GPIOHS0)
	case IRQ_GPIOHS1:
		callHandlers(IRQ_GPIOHS1)
	case IRQ_GPIOHS2:
		callHandlers(IRQ_GPIOHS2)
	case IRQ_GPIOHS3:
		callHandlers(IRQ_GPIOHS3)
	case IRQ_GPIOHS4:
		callHandlers(IRQ_GPIOHS4)
	case IRQ_GPIOHS5:
		callHandlers(IRQ_GPIOHS5)
	case IRQ_GPIOHS6:
		callHandlers(IRQ_GPIOHS6)
	case IRQ_GPIOHS7:
		callHandlers(IRQ_GPIOHS7)
	case IRQ_GPIOHS8:
		callHandlers(IRQ_GPIOHS8)
	case IRQ_GPIOHS9:
		callHandlers(IRQ_GPIOHS9)
	case IRQ_GPIOHS10:
		callHandlers(IRQ_GPIOHS10)
	case IRQ_GPIOHS11:
		callHandlers(IRQ_GPIOHS11)
	case IRQ_GPIOHS12:
		callHandlers(IRQ_GPIOHS12)
	case IRQ_GPIOHS13:
		callHandlers(IRQ_GPIOHS13)
	case IRQ_GPIOHS14:
		callHandlers(IRQ_GPIOHS14)
	case IRQ_GPIOHS15:
		callHandlers(IRQ_GPIOHS15)
	case IRQ_GPIOHS16:
		callHandlers(IRQ_GPIOHS16)
	case IRQ_GPIOHS17:
		callHandlers(IRQ_GPIOHS17)
	case IRQ_GPIOHS18:
		callHandlers(IRQ_GPIOHS18)
	case IRQ_GPIOHS19:
		callHandlers(IRQ_GPIOHS19)
	case IRQ_GPIOHS20:
		callHandlers(IRQ_GPIOHS20)
	case IRQ_GPIOHS21:
		callHandlers(IRQ_GPIOHS21)
	case IRQ_GPIOHS22:
		callHandlers(IRQ_GPIOHS22)
	case IRQ_GPIOHS23:
		callHandlers(IRQ_GPIOHS23)
	case IRQ_GPIOHS24:
		callHandlers(IRQ_GPIOHS24)
	case IRQ_GPIOHS25:
		callHandlers(IRQ_GPIOHS25)
	case IRQ_GPIOHS26:
		callHandlers(IRQ_GPIOHS26)
	case IRQ_GPIOHS27:
		callHandlers(IRQ_GPIOHS27)
	case IRQ_GPIOHS28:
		callHandlers(IRQ_GPIOHS28)
	case IRQ_GPIOHS29:
		callHandlers(IRQ_GPIOHS29)
	case IRQ_GPIOHS30:
		callHandlers(IRQ_GPIOHS30)
	case IRQ_GPIOHS31:
		callHandlers(IRQ_GPIOHS31)
	}
}

// Peripherals.
var (
	// Core Local Interruptor
	CLINT = (*CLINT_Type)(unsafe.Pointer(uintptr(0x2000000)))

	// Platform-Level Interrupt Controller
	PLIC = (*PLIC_Type)(unsafe.Pointer(uintptr(0xc000000)))

	// High-speed UART
	UARTHS = (*UARTHS_Type)(unsafe.Pointer(uintptr(0x38000000)))

	// High-speed GPIO
	GPIOHS = (*GPIOHS_Type)(unsafe.Pointer(uintptr(0x38001000)))

	// Neural Network Accelerator
	KPU = (*KPU_Type)(unsafe.Pointer(uintptr(0x40800000)))

	// Fast Fourier Transform Accelerator
	FFT = (*FFT_Type)(unsafe.Pointer(uintptr(0x42000000)))

	// Direct Memory Access Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// General Purpose Input/Output Interface
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50200000)))

	// Universal Asynchronous Receiver-Transmitter 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x50210000)))

	// Serial Peripheral Interface 0 (master)
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x52000000)))

	// Serial Peripheral Interface 2 (slave)
	SPI2 = (*SPI2_Type)(unsafe.Pointer(uintptr(0x50240000)))

	// Serial Peripheral Interface 3 (master)
	SPI3 = (*SPI3_Type)(unsafe.Pointer(uintptr(0x54000000)))

	// Inter-Integrated Sound Interface 0
	I2S0 = (*I2S_Type)(unsafe.Pointer(uintptr(0x50250000)))

	// Audio Processor
	APU = (*APU_Type)(unsafe.Pointer(uintptr(0x50250200)))

	// Inter-Integrated Circuit Bus 0
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x50280000)))

	// Field Programmable IO Array
	FPIOA = (*FPIOA_Type)(unsafe.Pointer(uintptr(0x502b0000)))

	// SHA256 Accelerator
	SHA256 = (*SHA256_Type)(unsafe.Pointer(uintptr(0x502c0000)))

	// Timer 0
	TIMER0 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x502d0000)))

	// Watchdog Timer 0
	WDT0 = (*WDT_Type)(unsafe.Pointer(uintptr(0x50400000)))

	// One-Time Programmable Memory Controller
	OTP = (*OTP_Type)(unsafe.Pointer(uintptr(0x50420000)))

	// Digital Video Port
	DVP = (*DVP_Type)(unsafe.Pointer(uintptr(0x50430000)))

	// System Controller
	SYSCTL = (*SYSCTL_Type)(unsafe.Pointer(uintptr(0x50440000)))

	// AES Accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x50450000)))

	// Real Time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x50460000)))

	// Universal Asynchronous Receiver-Transmitter 2
	UART2 = (*UART_Type)(unsafe.Pointer(uintptr(0x50220000)))

	// Universal Asynchronous Receiver-Transmitter 3
	UART3 = (*UART_Type)(unsafe.Pointer(uintptr(0x50230000)))

	// Serial Peripheral Interface 1 (master)
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x53000000)))

	// Inter-Integrated Sound Interface 1
	I2S1 = (*I2S_Type)(unsafe.Pointer(uintptr(0x50260000)))

	// Inter-Integrated Sound Interface 2
	I2S2 = (*I2S_Type)(unsafe.Pointer(uintptr(0x50270000)))

	// Inter-Integrated Circuit Bus 1
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x50290000)))

	// Inter-Integrated Circuit Bus 2
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x502a0000)))

	// Timer 1
	TIMER1 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x502e0000)))

	// Timer 2
	TIMER2 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x502f0000)))

	// Watchdog Timer 1
	WDT1 = (*WDT_Type)(unsafe.Pointer(uintptr(0x50410000)))
)

// Core Local Interruptor
type CLINT_Type struct {
	MSIP     [2]volatile.Register32 // 0x0
	_        [16376]byte
	MTIMECMP [2]volatile.Register64 // 0x4000
	_        [32744]byte
	MTIME    volatile.Register64 // 0xBFF8
}

// Platform-Level Interrupt Controller
type PLIC_Type struct {
	PRIORITY       [1024]volatile.Register32 // 0x0
	PENDING        [32]volatile.Register32   // 0x1000
	_              [3968]byte
	TARGET_ENABLES [4]PLIC_TARGET_ENABLES_Type // 0x2000
	_              [2088448]byte
	TARGETS        [4]PLIC_TARGETS_Type // 0x200000
}

// Target Interrupt Enables
type PLIC_TARGET_ENABLES_Type struct {
	ENABLE [32]volatile.Register32 // 0x2000
}

// Target Configuration
type PLIC_TARGETS_Type struct {
	THRESHOLD volatile.Register32 // 0x200000
	CLAIM     volatile.Register32 // 0x200004
	_         [4084]byte
	_RESERVED volatile.Register32 // 0x200FFC
}

// PLIC_TARGETS.THRESHOLD: Priority Threshold Register
func (o *PLIC_TARGETS_Type) SetTHRESHOLD_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.THRESHOLD.Reg, volatile.LoadUint32(&o.THRESHOLD.Reg)&^(0x7)|value)
}
func (o *PLIC_TARGETS_Type) GetTHRESHOLD_PRIORITY() uint32 {
	return volatile.LoadUint32(&o.THRESHOLD.Reg) & 0x7
}

// High-speed UART
type UARTHS_Type struct {
	TXDATA volatile.Register32 // 0x0
	RXDATA volatile.Register32 // 0x4
	TXCTRL volatile.Register32 // 0x8
	RXCTRL volatile.Register32 // 0xC
	IE     volatile.Register32 // 0x10
	IP     volatile.Register32 // 0x14
	DIV    volatile.Register32 // 0x18
}

// UARTHS.TXDATA: Transmit Data Register
func (o *UARTHS_Type) SetTXDATA_DATA(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, volatile.LoadUint32(&o.TXDATA.Reg)&^(0xff)|value)
}
func (o *UARTHS_Type) GetTXDATA_DATA() uint32 {
	return volatile.LoadUint32(&o.TXDATA.Reg) & 0xff
}
func (o *UARTHS_Type) SetTXDATA_FULL(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, volatile.LoadUint32(&o.TXDATA.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTHS_Type) GetTXDATA_FULL() uint32 {
	return (volatile.LoadUint32(&o.TXDATA.Reg) & 0x80000000) >> 31
}

// UARTHS.RXDATA: Receive Data Register
func (o *UARTHS_Type) SetRXDATA_DATA(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, volatile.LoadUint32(&o.RXDATA.Reg)&^(0xff)|value)
}
func (o *UARTHS_Type) GetRXDATA_DATA() uint32 {
	return volatile.LoadUint32(&o.RXDATA.Reg) & 0xff
}
func (o *UARTHS_Type) SetRXDATA_EMPTY(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, volatile.LoadUint32(&o.RXDATA.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTHS_Type) GetRXDATA_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.RXDATA.Reg) & 0x80000000) >> 31
}

// UARTHS.TXCTRL: Transmit Control Register
func (o *UARTHS_Type) SetTXCTRL_TXEN(value uint32) {
	volatile.StoreUint32(&o.TXCTRL.Reg, volatile.LoadUint32(&o.TXCTRL.Reg)&^(0x1)|value)
}
func (o *UARTHS_Type) GetTXCTRL_TXEN() uint32 {
	return volatile.LoadUint32(&o.TXCTRL.Reg) & 0x1
}
func (o *UARTHS_Type) SetTXCTRL_NSTOP(value uint32) {
	volatile.StoreUint32(&o.TXCTRL.Reg, volatile.LoadUint32(&o.TXCTRL.Reg)&^(0x2)|value<<1)
}
func (o *UARTHS_Type) GetTXCTRL_NSTOP() uint32 {
	return (volatile.LoadUint32(&o.TXCTRL.Reg) & 0x2) >> 1
}
func (o *UARTHS_Type) SetTXCTRL_TXCNT(value uint32) {
	volatile.StoreUint32(&o.TXCTRL.Reg, volatile.LoadUint32(&o.TXCTRL.Reg)&^(0x70000)|value<<16)
}
func (o *UARTHS_Type) GetTXCTRL_TXCNT() uint32 {
	return (volatile.LoadUint32(&o.TXCTRL.Reg) & 0x70000) >> 16
}

// UARTHS.RXCTRL: Receive Control Register
func (o *UARTHS_Type) SetRXCTRL_RXEN(value uint32) {
	volatile.StoreUint32(&o.RXCTRL.Reg, volatile.LoadUint32(&o.RXCTRL.Reg)&^(0x1)|value)
}
func (o *UARTHS_Type) GetRXCTRL_RXEN() uint32 {
	return volatile.LoadUint32(&o.RXCTRL.Reg) & 0x1
}
func (o *UARTHS_Type) SetRXCTRL_RXCNT(value uint32) {
	volatile.StoreUint32(&o.RXCTRL.Reg, volatile.LoadUint32(&o.RXCTRL.Reg)&^(0x70000)|value<<16)
}
func (o *UARTHS_Type) GetRXCTRL_RXCNT() uint32 {
	return (volatile.LoadUint32(&o.RXCTRL.Reg) & 0x70000) >> 16
}

// UARTHS.IE: Interrupt Enable Register
func (o *UARTHS_Type) SetIE_TXWM(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1)|value)
}
func (o *UARTHS_Type) GetIE_TXWM() uint32 {
	return volatile.LoadUint32(&o.IE.Reg) & 0x1
}
func (o *UARTHS_Type) SetIE_RXWM(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2)|value<<1)
}
func (o *UARTHS_Type) GetIE_RXWM() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2) >> 1
}

// UARTHS.IP: Interrupt Pending Register
func (o *UARTHS_Type) SetIP_TXWM(value uint32) {
	volatile.StoreUint32(&o.IP.Reg, volatile.LoadUint32(&o.IP.Reg)&^(0x1)|value)
}
func (o *UARTHS_Type) GetIP_TXWM() uint32 {
	return volatile.LoadUint32(&o.IP.Reg) & 0x1
}
func (o *UARTHS_Type) SetIP_RXWM(value uint32) {
	volatile.StoreUint32(&o.IP.Reg, volatile.LoadUint32(&o.IP.Reg)&^(0x2)|value<<1)
}
func (o *UARTHS_Type) GetIP_RXWM() uint32 {
	return (volatile.LoadUint32(&o.IP.Reg) & 0x2) >> 1
}

// UARTHS.DIV: Baud Rate Divisor Register
func (o *UARTHS_Type) SetDIV(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xffff)|value)
}
func (o *UARTHS_Type) GetDIV() uint32 {
	return volatile.LoadUint32(&o.DIV.Reg) & 0xffff
}

// High-speed GPIO
type GPIOHS_Type struct {
	INPUT_VAL  volatile.Register32 // 0x0
	INPUT_EN   volatile.Register32 // 0x4
	OUTPUT_EN  volatile.Register32 // 0x8
	OUTPUT_VAL volatile.Register32 // 0xC
	PULLUP_EN  volatile.Register32 // 0x10
	DRIVE      volatile.Register32 // 0x14
	RISE_IE    volatile.Register32 // 0x18
	RISE_IP    volatile.Register32 // 0x1C
	FALL_IE    volatile.Register32 // 0x20
	FALL_IP    volatile.Register32 // 0x24
	HIGH_IE    volatile.Register32 // 0x28
	HIGH_IP    volatile.Register32 // 0x2C
	LOW_IE     volatile.Register32 // 0x30
	LOW_IP     volatile.Register32 // 0x34
	IOF_EN     volatile.Register32 // 0x38
	IOF_SEL    volatile.Register32 // 0x3C
	OUTPUT_XOR volatile.Register32 // 0x40
}

// GPIOHS.INPUT_VAL: Input Value Register
func (o *GPIOHS_Type) SetINPUT_VAL_PIN_S(value uint32) {
	volatile.StoreUint32(&o.INPUT_VAL.Reg, volatile.LoadUint32(&o.INPUT_VAL.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetINPUT_VAL_PIN_S() uint32 {
	return volatile.LoadUint32(&o.INPUT_VAL.Reg) & 0x1
}

// GPIOHS.INPUT_EN: Pin Input Enable Register
func (o *GPIOHS_Type) SetINPUT_EN_PIN_S(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetINPUT_EN_PIN_S() uint32 {
	return volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x1
}

// GPIOHS.OUTPUT_EN: Pin Output Enable Register
func (o *GPIOHS_Type) SetOUTPUT_EN_PIN_S(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetOUTPUT_EN_PIN_S() uint32 {
	return volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x1
}

// GPIOHS.OUTPUT_VAL: Output Value Register
func (o *GPIOHS_Type) SetOUTPUT_VAL_PIN_S(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_VAL.Reg, volatile.LoadUint32(&o.OUTPUT_VAL.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetOUTPUT_VAL_PIN_S() uint32 {
	return volatile.LoadUint32(&o.OUTPUT_VAL.Reg) & 0x1
}

// GPIOHS.PULLUP_EN: Internal Pull-Up Enable Register
func (o *GPIOHS_Type) SetPULLUP_EN_PIN_S(value uint32) {
	volatile.StoreUint32(&o.PULLUP_EN.Reg, volatile.LoadUint32(&o.PULLUP_EN.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetPULLUP_EN_PIN_S() uint32 {
	return volatile.LoadUint32(&o.PULLUP_EN.Reg) & 0x1
}

// GPIOHS.DRIVE: Drive Strength Register
func (o *GPIOHS_Type) SetDRIVE_PIN_S(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetDRIVE_PIN_S() uint32 {
	return volatile.LoadUint32(&o.DRIVE.Reg) & 0x1
}

// GPIOHS.RISE_IE: Rise Interrupt Enable Register
func (o *GPIOHS_Type) SetRISE_IE_PIN_S(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetRISE_IE_PIN_S() uint32 {
	return volatile.LoadUint32(&o.RISE_IE.Reg) & 0x1
}

// GPIOHS.RISE_IP: Rise Interrupt Pending Register
func (o *GPIOHS_Type) SetRISE_IP_PIN_S(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetRISE_IP_PIN_S() uint32 {
	return volatile.LoadUint32(&o.RISE_IP.Reg) & 0x1
}

// GPIOHS.FALL_IE: Fall Interrupt Enable Register
func (o *GPIOHS_Type) SetFALL_IE_PIN_S(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetFALL_IE_PIN_S() uint32 {
	return volatile.LoadUint32(&o.FALL_IE.Reg) & 0x1
}

// GPIOHS.FALL_IP: Fall Interrupt Pending Register
func (o *GPIOHS_Type) SetFALL_IP_PIN_S(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetFALL_IP_PIN_S() uint32 {
	return volatile.LoadUint32(&o.FALL_IP.Reg) & 0x1
}

// GPIOHS.HIGH_IE: High Interrupt Enable Register
func (o *GPIOHS_Type) SetHIGH_IE_PIN_S(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetHIGH_IE_PIN_S() uint32 {
	return volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x1
}

// GPIOHS.HIGH_IP: High Interrupt Pending Register
func (o *GPIOHS_Type) SetHIGH_IP_PIN_S(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetHIGH_IP_PIN_S() uint32 {
	return volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x1
}

// GPIOHS.LOW_IE: Low Interrupt Enable Register
func (o *GPIOHS_Type) SetLOW_IE_PIN_S(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetLOW_IE_PIN_S() uint32 {
	return volatile.LoadUint32(&o.LOW_IE.Reg) & 0x1
}

// GPIOHS.LOW_IP: Low Interrupt Pending Register
func (o *GPIOHS_Type) SetLOW_IP_PIN_S(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetLOW_IP_PIN_S() uint32 {
	return volatile.LoadUint32(&o.LOW_IP.Reg) & 0x1
}

// GPIOHS.IOF_EN: HW I/O Function Enable Register
func (o *GPIOHS_Type) SetIOF_EN_PIN_S(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetIOF_EN_PIN_S() uint32 {
	return volatile.LoadUint32(&o.IOF_EN.Reg) & 0x1
}

// GPIOHS.IOF_SEL: HW I/O Function Select Register
func (o *GPIOHS_Type) SetIOF_SEL_PIN_S(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetIOF_SEL_PIN_S() uint32 {
	return volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x1
}

// GPIOHS.OUTPUT_XOR: Output XOR (invert) Register
func (o *GPIOHS_Type) SetOUTPUT_XOR_PIN_S(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_XOR.Reg, volatile.LoadUint32(&o.OUTPUT_XOR.Reg)&^(0x1)|value)
}
func (o *GPIOHS_Type) GetOUTPUT_XOR_PIN_S() uint32 {
	return volatile.LoadUint32(&o.OUTPUT_XOR.Reg) & 0x1
}

// Neural Network Accelerator
type KPU_Type struct {
	LAYER_ARGUMENT_FIFO volatile.Register64 // 0x0
	INTERRUPT_STATUS    volatile.Register64 // 0x8
	INTERRUPT_RAW       volatile.Register64 // 0x10
	INTERRUPT_MASK      volatile.Register64 // 0x18
	INTERRUPT_CLEAR     volatile.Register64 // 0x20
	FIFO_THRESHOLD      volatile.Register64 // 0x28
	FIFO_DATA_OUT       volatile.Register64 // 0x30
	FIFO_CTRL           volatile.Register64 // 0x38
	EIGHT_BIT_MODE      volatile.Register64 // 0x40
}

// KPU.INTERRUPT_STATUS: Interrupt status
func (o *KPU_Type) SetINTERRUPT_STATUS_CALC_DONE(value uint64) {
	volatile.StoreUint64(&o.INTERRUPT_STATUS.Reg, volatile.LoadUint64(&o.INTERRUPT_STATUS.Reg)&^(0x1)|value)
}
func (o *KPU_Type) GetINTERRUPT_STATUS_CALC_DONE() uint64 {
	return volatile.LoadUint64(&o.INTERRUPT_STATUS.Reg) & 0x1
}
func (o *KPU_Type) SetINTERRUPT_STATUS_LAYER_CFG_ALMOST_EMPTY(value uint64) {
	volatile.StoreUint64(&o.INTERRUPT_STATUS.Reg, volatile.LoadUint64(&o.INTERRUPT_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *KPU_Type) GetINTERRUPT_STATUS_LAYER_CFG_ALMOST_EMPTY() uint64 {
	return (volatile.LoadUint64(&o.INTERRUPT_STATUS.Reg) & 0x2) >> 1
}
func (o *KPU_Type) SetINTERRUPT_STATUS_LAYER_CFG_ALMOST_FULL(value uint64) {
	volatile.StoreUint64(&o.INTERRUPT_STATUS.Reg, volatile.LoadUint64(&o.INTERRUPT_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *KPU_Type) GetINTERRUPT_STATUS_LAYER_CFG_ALMOST_FULL() uint64 {
	return (volatile.LoadUint64(&o.INTERRUPT_STATUS.Reg) & 0x4) >> 2
}

// KPU.FIFO_THRESHOLD: FIFO threshold
func (o *KPU_Type) SetFIFO_THRESHOLD_FULL_THRESHOLD(value uint64) {
	volatile.StoreUint64(&o.FIFO_THRESHOLD.Reg, volatile.LoadUint64(&o.FIFO_THRESHOLD.Reg)&^(0xf)|value)
}
func (o *KPU_Type) GetFIFO_THRESHOLD_FULL_THRESHOLD() uint64 {
	return volatile.LoadUint64(&o.FIFO_THRESHOLD.Reg) & 0xf
}
func (o *KPU_Type) SetFIFO_THRESHOLD_EMPTY_THRESHOLD(value uint64) {
	volatile.StoreUint64(&o.FIFO_THRESHOLD.Reg, volatile.LoadUint64(&o.FIFO_THRESHOLD.Reg)&^(0xf0)|value<<4)
}
func (o *KPU_Type) GetFIFO_THRESHOLD_EMPTY_THRESHOLD() uint64 {
	return (volatile.LoadUint64(&o.FIFO_THRESHOLD.Reg) & 0xf0) >> 4
}

// KPU.FIFO_CTRL: FIFO control
func (o *KPU_Type) SetFIFO_CTRL_DMA_FIFO_FLUSH_N(value uint64) {
	volatile.StoreUint64(&o.FIFO_CTRL.Reg, volatile.LoadUint64(&o.FIFO_CTRL.Reg)&^(0x1)|value)
}
func (o *KPU_Type) GetFIFO_CTRL_DMA_FIFO_FLUSH_N() uint64 {
	return volatile.LoadUint64(&o.FIFO_CTRL.Reg) & 0x1
}
func (o *KPU_Type) SetFIFO_CTRL_GS_FIFO_FLUSH_N(value uint64) {
	volatile.StoreUint64(&o.FIFO_CTRL.Reg, volatile.LoadUint64(&o.FIFO_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *KPU_Type) GetFIFO_CTRL_GS_FIFO_FLUSH_N() uint64 {
	return (volatile.LoadUint64(&o.FIFO_CTRL.Reg) & 0x2) >> 1
}
func (o *KPU_Type) SetFIFO_CTRL_CFG_FIFO_FLUSH_N(value uint64) {
	volatile.StoreUint64(&o.FIFO_CTRL.Reg, volatile.LoadUint64(&o.FIFO_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *KPU_Type) GetFIFO_CTRL_CFG_FIFO_FLUSH_N() uint64 {
	return (volatile.LoadUint64(&o.FIFO_CTRL.Reg) & 0x4) >> 2
}
func (o *KPU_Type) SetFIFO_CTRL_CMD_FIFO_FLUSH_N(value uint64) {
	volatile.StoreUint64(&o.FIFO_CTRL.Reg, volatile.LoadUint64(&o.FIFO_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *KPU_Type) GetFIFO_CTRL_CMD_FIFO_FLUSH_N() uint64 {
	return (volatile.LoadUint64(&o.FIFO_CTRL.Reg) & 0x8) >> 3
}
func (o *KPU_Type) SetFIFO_CTRL_RESP_FIFO_FLUSH_N(value uint64) {
	volatile.StoreUint64(&o.FIFO_CTRL.Reg, volatile.LoadUint64(&o.FIFO_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *KPU_Type) GetFIFO_CTRL_RESP_FIFO_FLUSH_N() uint64 {
	return (volatile.LoadUint64(&o.FIFO_CTRL.Reg) & 0x10) >> 4
}

// KPU.EIGHT_BIT_MODE: Eight bit mode
func (o *KPU_Type) SetEIGHT_BIT_MODE(value uint64) {
	volatile.StoreUint64(&o.EIGHT_BIT_MODE.Reg, volatile.LoadUint64(&o.EIGHT_BIT_MODE.Reg)&^(0x1)|value)
}
func (o *KPU_Type) GetEIGHT_BIT_MODE() uint64 {
	return volatile.LoadUint64(&o.EIGHT_BIT_MODE.Reg) & 0x1
}

// Fast Fourier Transform Accelerator
type FFT_Type struct {
	INPUT_FIFO  volatile.Register64 // 0x0
	CTRL        volatile.Register64 // 0x8
	FIFO_CTRL   volatile.Register64 // 0x10
	INTR_MASK   volatile.Register64 // 0x18
	INTR_CLEAR  volatile.Register64 // 0x20
	STATUS      volatile.Register64 // 0x28
	STATUS_RAW  volatile.Register64 // 0x30
	OUTPUT_FIFO volatile.Register64 // 0x38
}

// FFT.CTRL: FFT control register
func (o *FFT_Type) SetCTRL_POINT(value uint64) {
	volatile.StoreUint64(&o.CTRL.Reg, volatile.LoadUint64(&o.CTRL.Reg)&^(0x7)|value)
}
func (o *FFT_Type) GetCTRL_POINT() uint64 {
	return volatile.LoadUint64(&o.CTRL.Reg) & 0x7
}
func (o *FFT_Type) SetCTRL_MODE(value uint64) {
	volatile.StoreUint64(&o.CTRL.Reg, volatile.LoadUint64(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *FFT_Type) GetCTRL_MODE() uint64 {
	return (volatile.LoadUint64(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *FFT_Type) SetCTRL_SHIFT(value uint64) {
	volatile.StoreUint64(&o.CTRL.Reg, volatile.LoadUint64(&o.CTRL.Reg)&^(0x1ff0)|value<<4)
}
func (o *FFT_Type) GetCTRL_SHIFT() uint64 {
	return (volatile.LoadUint64(&o.CTRL.Reg) & 0x1ff0) >> 4
}
func (o *FFT_Type) SetCTRL_ENABLE(value uint64) {
	volatile.StoreUint64(&o.CTRL.Reg, volatile.LoadUint64(&o.CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *FFT_Type) GetCTRL_ENABLE() uint64 {
	return (volatile.LoadUint64(&o.CTRL.Reg) & 0x2000) >> 13
}
func (o *FFT_Type) SetCTRL_DMA_SEND(value uint64) {
	volatile.StoreUint64(&o.CTRL.Reg, volatile.LoadUint64(&o.CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *FFT_Type) GetCTRL_DMA_SEND() uint64 {
	return (volatile.LoadUint64(&o.CTRL.Reg) & 0x4000) >> 14
}
func (o *FFT_Type) SetCTRL_INPUT_MODE(value uint64) {
	volatile.StoreUint64(&o.CTRL.Reg, volatile.LoadUint64(&o.CTRL.Reg)&^(0x18000)|value<<15)
}
func (o *FFT_Type) GetCTRL_INPUT_MODE() uint64 {
	return (volatile.LoadUint64(&o.CTRL.Reg) & 0x18000) >> 15
}
func (o *FFT_Type) SetCTRL_DATA_MODE(value uint64) {
	volatile.StoreUint64(&o.CTRL.Reg, volatile.LoadUint64(&o.CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *FFT_Type) GetCTRL_DATA_MODE() uint64 {
	return (volatile.LoadUint64(&o.CTRL.Reg) & 0x20000) >> 17
}

// FFT.FIFO_CTRL: FIFO control
func (o *FFT_Type) SetFIFO_CTRL_RESP_FIFO_FLUSH(value uint64) {
	volatile.StoreUint64(&o.FIFO_CTRL.Reg, volatile.LoadUint64(&o.FIFO_CTRL.Reg)&^(0x1)|value)
}
func (o *FFT_Type) GetFIFO_CTRL_RESP_FIFO_FLUSH() uint64 {
	return volatile.LoadUint64(&o.FIFO_CTRL.Reg) & 0x1
}
func (o *FFT_Type) SetFIFO_CTRL_CMD_FIFO_FLUSH(value uint64) {
	volatile.StoreUint64(&o.FIFO_CTRL.Reg, volatile.LoadUint64(&o.FIFO_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *FFT_Type) GetFIFO_CTRL_CMD_FIFO_FLUSH() uint64 {
	return (volatile.LoadUint64(&o.FIFO_CTRL.Reg) & 0x2) >> 1
}
func (o *FFT_Type) SetFIFO_CTRL_GS_FIFO_FLUSH(value uint64) {
	volatile.StoreUint64(&o.FIFO_CTRL.Reg, volatile.LoadUint64(&o.FIFO_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *FFT_Type) GetFIFO_CTRL_GS_FIFO_FLUSH() uint64 {
	return (volatile.LoadUint64(&o.FIFO_CTRL.Reg) & 0x4) >> 2
}

// FFT.INTR_MASK: interrupt mask
func (o *FFT_Type) SetINTR_MASK_FFT_DONE(value uint64) {
	volatile.StoreUint64(&o.INTR_MASK.Reg, volatile.LoadUint64(&o.INTR_MASK.Reg)&^(0x1)|value)
}
func (o *FFT_Type) GetINTR_MASK_FFT_DONE() uint64 {
	return volatile.LoadUint64(&o.INTR_MASK.Reg) & 0x1
}

// FFT.INTR_CLEAR: Interrupt clear
func (o *FFT_Type) SetINTR_CLEAR_FFT_DONE(value uint64) {
	volatile.StoreUint64(&o.INTR_CLEAR.Reg, volatile.LoadUint64(&o.INTR_CLEAR.Reg)&^(0x1)|value)
}
func (o *FFT_Type) GetINTR_CLEAR_FFT_DONE() uint64 {
	return volatile.LoadUint64(&o.INTR_CLEAR.Reg) & 0x1
}

// FFT.STATUS: FFT status register
func (o *FFT_Type) SetSTATUS_FFT_DONE(value uint64) {
	volatile.StoreUint64(&o.STATUS.Reg, volatile.LoadUint64(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *FFT_Type) GetSTATUS_FFT_DONE() uint64 {
	return volatile.LoadUint64(&o.STATUS.Reg) & 0x1
}

// FFT.STATUS_RAW: FFT status raw
func (o *FFT_Type) SetSTATUS_RAW_FFT_DONE(value uint64) {
	volatile.StoreUint64(&o.STATUS_RAW.Reg, volatile.LoadUint64(&o.STATUS_RAW.Reg)&^(0x1)|value)
}
func (o *FFT_Type) GetSTATUS_RAW_FFT_DONE() uint64 {
	return volatile.LoadUint64(&o.STATUS_RAW.Reg) & 0x1
}
func (o *FFT_Type) SetSTATUS_RAW_FFT_WORK(value uint64) {
	volatile.StoreUint64(&o.STATUS_RAW.Reg, volatile.LoadUint64(&o.STATUS_RAW.Reg)&^(0x2)|value<<1)
}
func (o *FFT_Type) GetSTATUS_RAW_FFT_WORK() uint64 {
	return (volatile.LoadUint64(&o.STATUS_RAW.Reg) & 0x2) >> 1
}

// Direct Memory Access Controller
type DMAC_Type struct {
	ID               volatile.Register64 // 0x0
	COMPVER          volatile.Register64 // 0x8
	CFG              volatile.Register64 // 0x10
	CHEN             volatile.Register64 // 0x18
	_                [16]byte
	INTSTATUS        volatile.Register64 // 0x30
	COM_INTCLEAR     volatile.Register64 // 0x38
	COM_INTSTATUS_EN volatile.Register64 // 0x40
	COM_INTSIGNAL_EN volatile.Register64 // 0x48
	COM_INTSTATUS    volatile.Register64 // 0x50
	RESET            volatile.Register64 // 0x58
	_                [160]byte
	CHANNEL          [6]DMAC_CHANNEL_Type // 0x100
}

// DMAC.CFG: Configure Register
func (o *DMAC_Type) SetCFG_DMAC_EN(value uint64) {
	volatile.StoreUint64(&o.CFG.Reg, volatile.LoadUint64(&o.CFG.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCFG_DMAC_EN() uint64 {
	return volatile.LoadUint64(&o.CFG.Reg) & 0x1
}
func (o *DMAC_Type) SetCFG_INT_EN(value uint64) {
	volatile.StoreUint64(&o.CFG.Reg, volatile.LoadUint64(&o.CFG.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCFG_INT_EN() uint64 {
	return (volatile.LoadUint64(&o.CFG.Reg) & 0x2) >> 1
}

// DMAC.CHEN: Channel Enable Register
func (o *DMAC_Type) SetCHEN_CH_S_EN(value uint64) {
	volatile.StoreUint64(&o.CHEN.Reg, volatile.LoadUint64(&o.CHEN.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHEN_CH_S_EN() uint64 {
	return volatile.LoadUint64(&o.CHEN.Reg) & 0x1
}
func (o *DMAC_Type) SetCHEN_CH_S_EN_WE(value uint64) {
	volatile.StoreUint64(&o.CHEN.Reg, volatile.LoadUint64(&o.CHEN.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHEN_CH_S_EN_WE() uint64 {
	return (volatile.LoadUint64(&o.CHEN.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHEN_CH_S_SUSP(value uint64) {
	volatile.StoreUint64(&o.CHEN.Reg, volatile.LoadUint64(&o.CHEN.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCHEN_CH_S_SUSP() uint64 {
	return (volatile.LoadUint64(&o.CHEN.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCHEN_CH_S_SUSP_WE(value uint64) {
	volatile.StoreUint64(&o.CHEN.Reg, volatile.LoadUint64(&o.CHEN.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHEN_CH_S_SUSP_WE() uint64 {
	return (volatile.LoadUint64(&o.CHEN.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHEN_CH_S_ABORT(value uint64) {
	volatile.StoreUint64(&o.CHEN.Reg, volatile.LoadUint64(&o.CHEN.Reg)&^(0x0)|value<<32)
}
func (o *DMAC_Type) GetCHEN_CH_S_ABORT() uint64 {
	return (volatile.LoadUint64(&o.CHEN.Reg) & 0x0) >> 32
}
func (o *DMAC_Type) SetCHEN_CH_S_ABORT_WE(value uint64) {
	volatile.StoreUint64(&o.CHEN.Reg, volatile.LoadUint64(&o.CHEN.Reg)&^(0x0)|value<<40)
}
func (o *DMAC_Type) GetCHEN_CH_S_ABORT_WE() uint64 {
	return (volatile.LoadUint64(&o.CHEN.Reg) & 0x0) >> 40
}

// DMAC.INTSTATUS: Interrupt Status Register
func (o *DMAC_Type) SetINTSTATUS_CH_S_INTSTAT(value uint64) {
	volatile.StoreUint64(&o.INTSTATUS.Reg, volatile.LoadUint64(&o.INTSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetINTSTATUS_CH_S_INTSTAT() uint64 {
	return volatile.LoadUint64(&o.INTSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetINTSTATUS_COMMONREG_INTSTAT(value uint64) {
	volatile.StoreUint64(&o.INTSTATUS.Reg, volatile.LoadUint64(&o.INTSTATUS.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetINTSTATUS_COMMONREG_INTSTAT() uint64 {
	return (volatile.LoadUint64(&o.INTSTATUS.Reg) & 0x10000) >> 16
}

// DMAC.COM_INTCLEAR: Common Interrupt Clear Register
func (o *DMAC_Type) SetCOM_INTCLEAR_SLVIF_DEC_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTCLEAR.Reg, volatile.LoadUint64(&o.COM_INTCLEAR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCOM_INTCLEAR_SLVIF_DEC_ERR() uint64 {
	return volatile.LoadUint64(&o.COM_INTCLEAR.Reg) & 0x1
}
func (o *DMAC_Type) SetCOM_INTCLEAR_SLVIF_WR2RO_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTCLEAR.Reg, volatile.LoadUint64(&o.COM_INTCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCOM_INTCLEAR_SLVIF_WR2RO_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTCLEAR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCOM_INTCLEAR_SLVIF_RD2WO_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTCLEAR.Reg, volatile.LoadUint64(&o.COM_INTCLEAR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCOM_INTCLEAR_SLVIF_RD2WO_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTCLEAR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCOM_INTCLEAR_SLVIF_WRONHOLD_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTCLEAR.Reg, volatile.LoadUint64(&o.COM_INTCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCOM_INTCLEAR_SLVIF_WRONHOLD_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTCLEAR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCOM_INTCLEAR_SLVIF_UNDEFINEDREG_DEC_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTCLEAR.Reg, volatile.LoadUint64(&o.COM_INTCLEAR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCOM_INTCLEAR_SLVIF_UNDEFINEDREG_DEC_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTCLEAR.Reg) & 0x100) >> 8
}

// DMAC.COM_INTSTATUS_EN: Common Interrupt Status Enable Register
func (o *DMAC_Type) SetCOM_INTSTATUS_EN_SLVIF_DEC_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSTATUS_EN.Reg, volatile.LoadUint64(&o.COM_INTSTATUS_EN.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCOM_INTSTATUS_EN_SLVIF_DEC_ERR() uint64 {
	return volatile.LoadUint64(&o.COM_INTSTATUS_EN.Reg) & 0x1
}
func (o *DMAC_Type) SetCOM_INTSTATUS_EN_SLVIF_WR2RO_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSTATUS_EN.Reg, volatile.LoadUint64(&o.COM_INTSTATUS_EN.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCOM_INTSTATUS_EN_SLVIF_WR2RO_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSTATUS_EN.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCOM_INTSTATUS_EN_SLVIF_RD2WO_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSTATUS_EN.Reg, volatile.LoadUint64(&o.COM_INTSTATUS_EN.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCOM_INTSTATUS_EN_SLVIF_RD2WO_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSTATUS_EN.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCOM_INTSTATUS_EN_SLVIF_WRONHOLD_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSTATUS_EN.Reg, volatile.LoadUint64(&o.COM_INTSTATUS_EN.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCOM_INTSTATUS_EN_SLVIF_WRONHOLD_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSTATUS_EN.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCOM_INTSTATUS_EN_SLVIF_UNDEFINEDREG_DEC_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSTATUS_EN.Reg, volatile.LoadUint64(&o.COM_INTSTATUS_EN.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCOM_INTSTATUS_EN_SLVIF_UNDEFINEDREG_DEC_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSTATUS_EN.Reg) & 0x100) >> 8
}

// DMAC.COM_INTSIGNAL_EN: Common Interrupt Signal Enable Register
func (o *DMAC_Type) SetCOM_INTSIGNAL_EN_SLVIF_DEC_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSIGNAL_EN.Reg, volatile.LoadUint64(&o.COM_INTSIGNAL_EN.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCOM_INTSIGNAL_EN_SLVIF_DEC_ERR() uint64 {
	return volatile.LoadUint64(&o.COM_INTSIGNAL_EN.Reg) & 0x1
}
func (o *DMAC_Type) SetCOM_INTSIGNAL_EN_SLVIF_WR2RO_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSIGNAL_EN.Reg, volatile.LoadUint64(&o.COM_INTSIGNAL_EN.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCOM_INTSIGNAL_EN_SLVIF_WR2RO_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSIGNAL_EN.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCOM_INTSIGNAL_EN_SLVIF_RD2WO_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSIGNAL_EN.Reg, volatile.LoadUint64(&o.COM_INTSIGNAL_EN.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCOM_INTSIGNAL_EN_SLVIF_RD2WO_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSIGNAL_EN.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCOM_INTSIGNAL_EN_SLVIF_WRONHOLD_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSIGNAL_EN.Reg, volatile.LoadUint64(&o.COM_INTSIGNAL_EN.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCOM_INTSIGNAL_EN_SLVIF_WRONHOLD_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSIGNAL_EN.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCOM_INTSIGNAL_EN_SLVIF_UNDEFINEDREG_DEC_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSIGNAL_EN.Reg, volatile.LoadUint64(&o.COM_INTSIGNAL_EN.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCOM_INTSIGNAL_EN_SLVIF_UNDEFINEDREG_DEC_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSIGNAL_EN.Reg) & 0x100) >> 8
}

// DMAC.COM_INTSTATUS: Common Interrupt Status
func (o *DMAC_Type) SetCOM_INTSTATUS_SLVIF_DEC_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSTATUS.Reg, volatile.LoadUint64(&o.COM_INTSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCOM_INTSTATUS_SLVIF_DEC_ERR() uint64 {
	return volatile.LoadUint64(&o.COM_INTSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetCOM_INTSTATUS_SLVIF_WR2RO_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSTATUS.Reg, volatile.LoadUint64(&o.COM_INTSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCOM_INTSTATUS_SLVIF_WR2RO_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSTATUS.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCOM_INTSTATUS_SLVIF_RD2WO_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSTATUS.Reg, volatile.LoadUint64(&o.COM_INTSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCOM_INTSTATUS_SLVIF_RD2WO_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSTATUS.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCOM_INTSTATUS_SLVIF_WRONHOLD_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSTATUS.Reg, volatile.LoadUint64(&o.COM_INTSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCOM_INTSTATUS_SLVIF_WRONHOLD_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSTATUS.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCOM_INTSTATUS_SLVIF_UNDEFINEDREG_DEC_ERR(value uint64) {
	volatile.StoreUint64(&o.COM_INTSTATUS.Reg, volatile.LoadUint64(&o.COM_INTSTATUS.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCOM_INTSTATUS_SLVIF_UNDEFINEDREG_DEC_ERR() uint64 {
	return (volatile.LoadUint64(&o.COM_INTSTATUS.Reg) & 0x100) >> 8
}

// DMAC.RESET: Reset register
func (o *DMAC_Type) SetRESET_RST(value uint64) {
	volatile.StoreUint64(&o.RESET.Reg, volatile.LoadUint64(&o.RESET.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetRESET_RST() uint64 {
	return volatile.LoadUint64(&o.RESET.Reg) & 0x1
}

// Channel configuration
type DMAC_CHANNEL_Type struct {
	SAR          volatile.Register32 // 0x100
	_            [4]byte
	DAR          volatile.Register32 // 0x108
	_            [4]byte
	BLOCK_TS     volatile.Register32 // 0x110
	_            [4]byte
	CTL          volatile.Register32 // 0x118
	_            [4]byte
	CFG          volatile.Register32 // 0x120
	_            [4]byte
	LLP          volatile.Register32 // 0x128
	_            [4]byte
	STATUS       volatile.Register32 // 0x130
	_            [4]byte
	SWHSSRC      volatile.Register32 // 0x138
	_            [4]byte
	SWHSDST      volatile.Register32 // 0x140
	_            [4]byte
	BLK_TFR      volatile.Register32 // 0x148
	_            [4]byte
	AXI_ID       volatile.Register32 // 0x150
	_            [4]byte
	AXI_QOS      volatile.Register32 // 0x158
	_            [36]byte
	INTSTATUS_EN volatile.Register32 // 0x180
	_            [4]byte
	INTSTATUS    volatile.Register32 // 0x188
	_            [4]byte
	INTSIGNAL_EN volatile.Register32 // 0x190
	_            [4]byte
	INTCLEAR     volatile.Register32 // 0x198
	_            [92]byte
	_RESERVED    volatile.Register32 // 0x1F8
	_            [4]byte
}

// DMAC_CHANNEL.BLOCK_TS: Block Transfer Size Register
func (o *DMAC_CHANNEL_Type) SetBLOCK_TS(value uint32) {
	volatile.StoreUint32(&o.BLOCK_TS.Reg, volatile.LoadUint32(&o.BLOCK_TS.Reg)&^(0x3fffff)|value)
}
func (o *DMAC_CHANNEL_Type) GetBLOCK_TS() uint32 {
	return volatile.LoadUint32(&o.BLOCK_TS.Reg) & 0x3fffff
}

// DMAC_CHANNEL.CTL: Control Register
func (o *DMAC_CHANNEL_Type) SetCTL_SMS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x1)|value)
}
func (o *DMAC_CHANNEL_Type) GetCTL_SMS() uint32 {
	return volatile.LoadUint32(&o.CTL.Reg) & 0x1
}
func (o *DMAC_CHANNEL_Type) SetCTL_DMS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_CHANNEL_Type) GetCTL_DMS() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x4) >> 2
}
func (o *DMAC_CHANNEL_Type) SetCTL_SINC(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_CHANNEL_Type) GetCTL_SINC() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x10) >> 4
}
func (o *DMAC_CHANNEL_Type) SetCTL_DINC(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_CHANNEL_Type) GetCTL_DINC() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x40) >> 6
}
func (o *DMAC_CHANNEL_Type) SetCTL_SRC_TR_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x700)|value<<8)
}
func (o *DMAC_CHANNEL_Type) GetCTL_SRC_TR_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x700) >> 8
}
func (o *DMAC_CHANNEL_Type) SetCTL_DST_TR_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x3800)|value<<11)
}
func (o *DMAC_CHANNEL_Type) GetCTL_DST_TR_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x3800) >> 11
}
func (o *DMAC_CHANNEL_Type) SetCTL_SRC_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x3c000)|value<<14)
}
func (o *DMAC_CHANNEL_Type) GetCTL_SRC_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x3c000) >> 14
}
func (o *DMAC_CHANNEL_Type) SetCTL_DST_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x3c0000)|value<<18)
}
func (o *DMAC_CHANNEL_Type) GetCTL_DST_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x3c0000) >> 18
}
func (o *DMAC_CHANNEL_Type) SetCTL_NONPOSTED_LASTWRITE_EN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_CHANNEL_Type) GetCTL_NONPOSTED_LASTWRITE_EN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x40000000) >> 30
}
func (o *DMAC_CHANNEL_Type) SetCTL_ARLEN_EN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x0)|value<<38)
}
func (o *DMAC_CHANNEL_Type) GetCTL_ARLEN_EN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x0) >> 38
}
func (o *DMAC_CHANNEL_Type) SetCTL_ARLEN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x0)|value<<39)
}
func (o *DMAC_CHANNEL_Type) GetCTL_ARLEN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x0) >> 39
}
func (o *DMAC_CHANNEL_Type) SetCTL_AWLEN_EN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x0)|value<<47)
}
func (o *DMAC_CHANNEL_Type) GetCTL_AWLEN_EN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x0) >> 47
}
func (o *DMAC_CHANNEL_Type) SetCTL_AWLEN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x0)|value<<48)
}
func (o *DMAC_CHANNEL_Type) GetCTL_AWLEN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x0) >> 48
}
func (o *DMAC_CHANNEL_Type) SetCTL_SRC_STAT_EN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x0)|value<<56)
}
func (o *DMAC_CHANNEL_Type) GetCTL_SRC_STAT_EN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x0) >> 56
}
func (o *DMAC_CHANNEL_Type) SetCTL_DST_STAT_EN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x0)|value<<57)
}
func (o *DMAC_CHANNEL_Type) GetCTL_DST_STAT_EN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x0) >> 57
}
func (o *DMAC_CHANNEL_Type) SetCTL_IOC_BLKTFR(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x0)|value<<58)
}
func (o *DMAC_CHANNEL_Type) GetCTL_IOC_BLKTFR() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x0) >> 58
}
func (o *DMAC_CHANNEL_Type) SetCTL_SHADOWREG_OR_LLI_LAST(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x0)|value<<62)
}
func (o *DMAC_CHANNEL_Type) GetCTL_SHADOWREG_OR_LLI_LAST() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x0) >> 62
}
func (o *DMAC_CHANNEL_Type) SetCTL_SHADOWREG_OR_LLI_VALID(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x0)|value<<63)
}
func (o *DMAC_CHANNEL_Type) GetCTL_SHADOWREG_OR_LLI_VALID() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x0) >> 63
}

// DMAC_CHANNEL.CFG: Configure Register
func (o *DMAC_CHANNEL_Type) SetCFG_SRC_MULTBLK_TYPE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x3)|value)
}
func (o *DMAC_CHANNEL_Type) GetCFG_SRC_MULTBLK_TYPE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x3
}
func (o *DMAC_CHANNEL_Type) SetCFG_DST_MULTBLK_TYPE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xc)|value<<2)
}
func (o *DMAC_CHANNEL_Type) GetCFG_DST_MULTBLK_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xc) >> 2
}
func (o *DMAC_CHANNEL_Type) SetCFG_TT_FC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<32)
}
func (o *DMAC_CHANNEL_Type) GetCFG_TT_FC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 32
}
func (o *DMAC_CHANNEL_Type) SetCFG_HS_SEL_SRC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<35)
}
func (o *DMAC_CHANNEL_Type) GetCFG_HS_SEL_SRC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 35
}
func (o *DMAC_CHANNEL_Type) SetCFG_HS_SEL_DST(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<36)
}
func (o *DMAC_CHANNEL_Type) GetCFG_HS_SEL_DST() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 36
}
func (o *DMAC_CHANNEL_Type) SetCFG_SRC_HWHS_POL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<37)
}
func (o *DMAC_CHANNEL_Type) GetCFG_SRC_HWHS_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 37
}
func (o *DMAC_CHANNEL_Type) SetCFG_DST_HWHS_POL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<38)
}
func (o *DMAC_CHANNEL_Type) GetCFG_DST_HWHS_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 38
}
func (o *DMAC_CHANNEL_Type) SetCFG_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<39)
}
func (o *DMAC_CHANNEL_Type) GetCFG_SRC_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 39
}
func (o *DMAC_CHANNEL_Type) SetCFG_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<44)
}
func (o *DMAC_CHANNEL_Type) GetCFG_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 44
}
func (o *DMAC_CHANNEL_Type) SetCFG_CH_PRIOR(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<49)
}
func (o *DMAC_CHANNEL_Type) GetCFG_CH_PRIOR() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 49
}
func (o *DMAC_CHANNEL_Type) SetCFG_LOCK_CH(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<52)
}
func (o *DMAC_CHANNEL_Type) GetCFG_LOCK_CH() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 52
}
func (o *DMAC_CHANNEL_Type) SetCFG_LOCK_CH_L(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<53)
}
func (o *DMAC_CHANNEL_Type) GetCFG_LOCK_CH_L() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 53
}
func (o *DMAC_CHANNEL_Type) SetCFG_SRC_OSR_LMT(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<55)
}
func (o *DMAC_CHANNEL_Type) GetCFG_SRC_OSR_LMT() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 55
}
func (o *DMAC_CHANNEL_Type) SetCFG_DST_OSR_LMT(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x0)|value<<59)
}
func (o *DMAC_CHANNEL_Type) GetCFG_DST_OSR_LMT() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x0) >> 59
}

// DMAC_CHANNEL.LLP: Linked List Pointer register
func (o *DMAC_CHANNEL_Type) SetLLP_LMS(value uint32) {
	volatile.StoreUint32(&o.LLP.Reg, volatile.LoadUint32(&o.LLP.Reg)&^(0x1)|value)
}
func (o *DMAC_CHANNEL_Type) GetLLP_LMS() uint32 {
	return volatile.LoadUint32(&o.LLP.Reg) & 0x1
}
func (o *DMAC_CHANNEL_Type) SetLLP_LOC(value uint32) {
	volatile.StoreUint32(&o.LLP.Reg, volatile.LoadUint32(&o.LLP.Reg)&^(0x0)|value<<6)
}
func (o *DMAC_CHANNEL_Type) GetLLP_LOC() uint32 {
	return (volatile.LoadUint32(&o.LLP.Reg) & 0x0) >> 6
}

// DMAC_CHANNEL.STATUS: Channel Status Register
func (o *DMAC_CHANNEL_Type) SetSTATUS_CMPLTD_BLK_SIZE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x3fffff)|value)
}
func (o *DMAC_CHANNEL_Type) GetSTATUS_CMPLTD_BLK_SIZE() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x3fffff
}

// DMAC_CHANNEL.SWHSSRC: Channel Software handshake Source Register
func (o *DMAC_CHANNEL_Type) SetSWHSSRC_REQ(value uint32) {
	volatile.StoreUint32(&o.SWHSSRC.Reg, volatile.LoadUint32(&o.SWHSSRC.Reg)&^(0x1)|value)
}
func (o *DMAC_CHANNEL_Type) GetSWHSSRC_REQ() uint32 {
	return volatile.LoadUint32(&o.SWHSSRC.Reg) & 0x1
}
func (o *DMAC_CHANNEL_Type) SetSWHSSRC_REQ_WE(value uint32) {
	volatile.StoreUint32(&o.SWHSSRC.Reg, volatile.LoadUint32(&o.SWHSSRC.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_CHANNEL_Type) GetSWHSSRC_REQ_WE() uint32 {
	return (volatile.LoadUint32(&o.SWHSSRC.Reg) & 0x2) >> 1
}
func (o *DMAC_CHANNEL_Type) SetSWHSSRC_SGLREQ(value uint32) {
	volatile.StoreUint32(&o.SWHSSRC.Reg, volatile.LoadUint32(&o.SWHSSRC.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_CHANNEL_Type) GetSWHSSRC_SGLREQ() uint32 {
	return (volatile.LoadUint32(&o.SWHSSRC.Reg) & 0x4) >> 2
}
func (o *DMAC_CHANNEL_Type) SetSWHSSRC_SGLREQ_WE(value uint32) {
	volatile.StoreUint32(&o.SWHSSRC.Reg, volatile.LoadUint32(&o.SWHSSRC.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_CHANNEL_Type) GetSWHSSRC_SGLREQ_WE() uint32 {
	return (volatile.LoadUint32(&o.SWHSSRC.Reg) & 0x8) >> 3
}
func (o *DMAC_CHANNEL_Type) SetSWHSSRC_LST(value uint32) {
	volatile.StoreUint32(&o.SWHSSRC.Reg, volatile.LoadUint32(&o.SWHSSRC.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_CHANNEL_Type) GetSWHSSRC_LST() uint32 {
	return (volatile.LoadUint32(&o.SWHSSRC.Reg) & 0x10) >> 4
}
func (o *DMAC_CHANNEL_Type) SetSWHSSRC_LST_WE(value uint32) {
	volatile.StoreUint32(&o.SWHSSRC.Reg, volatile.LoadUint32(&o.SWHSSRC.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_CHANNEL_Type) GetSWHSSRC_LST_WE() uint32 {
	return (volatile.LoadUint32(&o.SWHSSRC.Reg) & 0x20) >> 5
}

// DMAC_CHANNEL.SWHSDST: Channel Software handshake Destination Register
func (o *DMAC_CHANNEL_Type) SetSWHSDST_REQ(value uint32) {
	volatile.StoreUint32(&o.SWHSDST.Reg, volatile.LoadUint32(&o.SWHSDST.Reg)&^(0x1)|value)
}
func (o *DMAC_CHANNEL_Type) GetSWHSDST_REQ() uint32 {
	return volatile.LoadUint32(&o.SWHSDST.Reg) & 0x1
}
func (o *DMAC_CHANNEL_Type) SetSWHSDST_REQ_WE(value uint32) {
	volatile.StoreUint32(&o.SWHSDST.Reg, volatile.LoadUint32(&o.SWHSDST.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_CHANNEL_Type) GetSWHSDST_REQ_WE() uint32 {
	return (volatile.LoadUint32(&o.SWHSDST.Reg) & 0x2) >> 1
}
func (o *DMAC_CHANNEL_Type) SetSWHSDST_SGLREQ(value uint32) {
	volatile.StoreUint32(&o.SWHSDST.Reg, volatile.LoadUint32(&o.SWHSDST.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_CHANNEL_Type) GetSWHSDST_SGLREQ() uint32 {
	return (volatile.LoadUint32(&o.SWHSDST.Reg) & 0x4) >> 2
}
func (o *DMAC_CHANNEL_Type) SetSWHSDST_SGLREQ_WE(value uint32) {
	volatile.StoreUint32(&o.SWHSDST.Reg, volatile.LoadUint32(&o.SWHSDST.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_CHANNEL_Type) GetSWHSDST_SGLREQ_WE() uint32 {
	return (volatile.LoadUint32(&o.SWHSDST.Reg) & 0x8) >> 3
}
func (o *DMAC_CHANNEL_Type) SetSWHSDST_LST(value uint32) {
	volatile.StoreUint32(&o.SWHSDST.Reg, volatile.LoadUint32(&o.SWHSDST.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_CHANNEL_Type) GetSWHSDST_LST() uint32 {
	return (volatile.LoadUint32(&o.SWHSDST.Reg) & 0x10) >> 4
}
func (o *DMAC_CHANNEL_Type) SetSWHSDST_LST_WE(value uint32) {
	volatile.StoreUint32(&o.SWHSDST.Reg, volatile.LoadUint32(&o.SWHSDST.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_CHANNEL_Type) GetSWHSDST_LST_WE() uint32 {
	return (volatile.LoadUint32(&o.SWHSDST.Reg) & 0x20) >> 5
}

// DMAC_CHANNEL.BLK_TFR: Channel Block Transfer Resume Request Register
func (o *DMAC_CHANNEL_Type) SetBLK_TFR_RESUMEREQ(value uint32) {
	volatile.StoreUint32(&o.BLK_TFR.Reg, volatile.LoadUint32(&o.BLK_TFR.Reg)&^(0x1)|value)
}
func (o *DMAC_CHANNEL_Type) GetBLK_TFR_RESUMEREQ() uint32 {
	return volatile.LoadUint32(&o.BLK_TFR.Reg) & 0x1
}

// DMAC_CHANNEL.INTSTATUS_EN: Interrupt Status Enable Register
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_BLOCK_TFR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x1)|value)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_BLOCK_TFR_DONE() uint32 {
	return volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x1
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_TFR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_TFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x2) >> 1
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_SRC_TRANSCOMP(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_SRC_TRANSCOMP() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x8) >> 3
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_DST_TRANSCOMP(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_DST_TRANSCOMP() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x10) >> 4
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_SRC_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_SRC_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x20) >> 5
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_DST_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_DST_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x40) >> 6
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_SRC_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_SRC_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x80) >> 7
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_DST_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_DST_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x100) >> 8
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_LLI_RD_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_LLI_RD_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x200) >> 9
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_LLI_WR_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_LLI_WR_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x400) >> 10
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_LLI_RD_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_LLI_RD_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x800) >> 11
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_EN_LLI_WR_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS_EN.Reg, volatile.LoadUint32(&o.INTSTATUS_EN.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_EN_LLI_WR_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS_EN.Reg) & 0x1000) >> 12
}

// DMAC_CHANNEL.INTSTATUS: Channel Interrupt Status Register
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_BLOCK_TFR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_BLOCK_TFR_DONE() uint32 {
	return volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_TFR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_TFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x2) >> 1
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_SRC_TRANSCOMP(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_SRC_TRANSCOMP() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x8) >> 3
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_DST_TRANSCOMP(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_DST_TRANSCOMP() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x10) >> 4
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_SRC_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_SRC_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x20) >> 5
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_DST_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_DST_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x40) >> 6
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_SRC_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_SRC_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x80) >> 7
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_DST_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_DST_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x100) >> 8
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_LLI_RD_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_LLI_RD_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x200) >> 9
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_LLI_WR_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_LLI_WR_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x400) >> 10
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_LLI_RD_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_LLI_RD_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x800) >> 11
}
func (o *DMAC_CHANNEL_Type) SetINTSTATUS_LLI_WR_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_CHANNEL_Type) GetINTSTATUS_LLI_WR_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1000) >> 12
}

// DMAC_CHANNEL.INTSIGNAL_EN: Interrupt Signal Enable Register
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_BLOCK_TFR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x1)|value)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_BLOCK_TFR_DONE() uint32 {
	return volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x1
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_TFR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_TFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x2) >> 1
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_SRC_TRANSCOMP(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_SRC_TRANSCOMP() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x8) >> 3
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_DST_TRANSCOMP(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_DST_TRANSCOMP() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x10) >> 4
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_SRC_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_SRC_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x20) >> 5
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_DST_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_DST_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x40) >> 6
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_SRC_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_SRC_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x80) >> 7
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_DST_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_DST_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x100) >> 8
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_LLI_RD_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_LLI_RD_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x200) >> 9
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_LLI_WR_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_LLI_WR_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x400) >> 10
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_LLI_RD_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_LLI_RD_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x800) >> 11
}
func (o *DMAC_CHANNEL_Type) SetINTSIGNAL_EN_LLI_WR_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTSIGNAL_EN.Reg, volatile.LoadUint32(&o.INTSIGNAL_EN.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_CHANNEL_Type) GetINTSIGNAL_EN_LLI_WR_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTSIGNAL_EN.Reg) & 0x1000) >> 12
}

// DMAC_CHANNEL.INTCLEAR: Interrupt Clear Register
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_BLOCK_TFR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x1)|value)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_BLOCK_TFR_DONE() uint32 {
	return volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x1
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_TFR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_TFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x2) >> 1
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_SRC_TRANSCOMP(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_SRC_TRANSCOMP() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x8) >> 3
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_DST_TRANSCOMP(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_DST_TRANSCOMP() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x10) >> 4
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_SRC_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_SRC_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x20) >> 5
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_DST_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_DST_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x40) >> 6
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_SRC_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_SRC_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x80) >> 7
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_DST_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_DST_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x100) >> 8
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_LLI_RD_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_LLI_RD_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x200) >> 9
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_LLI_WR_DEC_ERR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_LLI_WR_DEC_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x400) >> 10
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_LLI_RD_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_LLI_RD_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x800) >> 11
}
func (o *DMAC_CHANNEL_Type) SetINTCLEAR_LLI_WR_SLV_ERR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_CHANNEL_Type) GetINTCLEAR_LLI_WR_SLV_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x1000) >> 12
}

// General Purpose Input/Output Interface
type GPIO_Type struct {
	DATA_OUTPUT          volatile.Register32 // 0x0
	DIRECTION            volatile.Register32 // 0x4
	SOURCE               volatile.Register32 // 0x8
	_                    [36]byte
	INTERRUPT_ENABLE     volatile.Register32 // 0x30
	INTERRUPT_MASK       volatile.Register32 // 0x34
	INTERRUPT_LEVEL      volatile.Register32 // 0x38
	INTERRUPT_POLARITY   volatile.Register32 // 0x3C
	INTERRUPT_STATUS     volatile.Register32 // 0x40
	INTERRUPT_STATUS_RAW volatile.Register32 // 0x44
	INTERRUPT_DEBOUNCE   volatile.Register32 // 0x48
	INTERRUPT_CLEAR      volatile.Register32 // 0x4C
	DATA_INPUT           volatile.Register32 // 0x50
	_                    [12]byte
	SYNC_LEVEL           volatile.Register32 // 0x60
	ID_CODE              volatile.Register32 // 0x64
	INTERRUPT_BOTHEDGE   volatile.Register32 // 0x68
}

// GPIO.DATA_OUTPUT: Data (output) registers
func (o *GPIO_Type) SetDATA_OUTPUT_PIN_S(value uint32) {
	volatile.StoreUint32(&o.DATA_OUTPUT.Reg, volatile.LoadUint32(&o.DATA_OUTPUT.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDATA_OUTPUT_PIN_S() uint32 {
	return volatile.LoadUint32(&o.DATA_OUTPUT.Reg) & 0x1
}

// GPIO.DIRECTION: Data direction registers
func (o *GPIO_Type) SetDIRECTION_PIN_S(value uint32) {
	volatile.StoreUint32(&o.DIRECTION.Reg, volatile.LoadUint32(&o.DIRECTION.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIRECTION_PIN_S() uint32 {
	return volatile.LoadUint32(&o.DIRECTION.Reg) & 0x1
}

// GPIO.DATA_INPUT: External port (data input) registers
func (o *GPIO_Type) SetDATA_INPUT_PIN_S(value uint32) {
	volatile.StoreUint32(&o.DATA_INPUT.Reg, volatile.LoadUint32(&o.DATA_INPUT.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDATA_INPUT_PIN_S() uint32 {
	return volatile.LoadUint32(&o.DATA_INPUT.Reg) & 0x1
}

// Universal Asynchronous Receiver-Transmitter 1
type UART_Type struct {
	RBR_DLL_THR volatile.Register32 // 0x0
	DLH_IER     volatile.Register32 // 0x4
	FCR_IIR     volatile.Register32 // 0x8
	LCR         volatile.Register32 // 0xC
	MCR         volatile.Register32 // 0x10
	LSR         volatile.Register32 // 0x14
	MSR         volatile.Register32 // 0x18
	SCR         volatile.Register32 // 0x1C
	LPDLL       volatile.Register32 // 0x20
	LPDLH       volatile.Register32 // 0x24
	_           [8]byte
	SRBR_STHR   [16]volatile.Register32 // 0x30
	FAR         volatile.Register32     // 0x70
	TFR         volatile.Register32     // 0x74
	RFW         volatile.Register32     // 0x78
	USR         volatile.Register32     // 0x7C
	TFL         volatile.Register32     // 0x80
	RFL         volatile.Register32     // 0x84
	SRR         volatile.Register32     // 0x88
	SRTS        volatile.Register32     // 0x8C
	SBCR        volatile.Register32     // 0x90
	SDMAM       volatile.Register32     // 0x94
	SFE         volatile.Register32     // 0x98
	SRT         volatile.Register32     // 0x9C
	STET        volatile.Register32     // 0xA0
	HTX         volatile.Register32     // 0xA4
	DMASA       volatile.Register32     // 0xA8
	TCR         volatile.Register32     // 0xAC
	DE_EN       volatile.Register32     // 0xB0
	RE_EN       volatile.Register32     // 0xB4
	DET         volatile.Register32     // 0xB8
	TAT         volatile.Register32     // 0xBC
	DLF         volatile.Register32     // 0xC0
	RAR         volatile.Register32     // 0xC4
	TAR         volatile.Register32     // 0xC8
	LCR_EXT     volatile.Register32     // 0xCC
	_           [36]byte
	CPR         volatile.Register32 // 0xF4
	UCV         volatile.Register32 // 0xF8
	CTR         volatile.Register32 // 0xFC
}

// Serial Peripheral Interface 0 (master)
type SPI_Type struct {
	CTRLR0           volatile.Register32 // 0x0
	CTRLR1           volatile.Register32 // 0x4
	SSIENR           volatile.Register32 // 0x8
	MWCR             volatile.Register32 // 0xC
	SER              volatile.Register32 // 0x10
	BAUDR            volatile.Register32 // 0x14
	TXFTLR           volatile.Register32 // 0x18
	RXFTLR           volatile.Register32 // 0x1C
	TXFLR            volatile.Register32 // 0x20
	RXFLR            volatile.Register32 // 0x24
	SR               volatile.Register32 // 0x28
	IMR              volatile.Register32 // 0x2C
	ISR              volatile.Register32 // 0x30
	RISR             volatile.Register32 // 0x34
	TXOICR           volatile.Register32 // 0x38
	RXOICR           volatile.Register32 // 0x3C
	RXUICR           volatile.Register32 // 0x40
	MSTICR           volatile.Register32 // 0x44
	ICR              volatile.Register32 // 0x48
	DMACR            volatile.Register32 // 0x4C
	DMATDLR          volatile.Register32 // 0x50
	DMARDLR          volatile.Register32 // 0x54
	IDR              volatile.Register32 // 0x58
	SSIC_VERSION_ID  volatile.Register32 // 0x5C
	DR0              volatile.Register32 // 0x60
	DR1              volatile.Register32 // 0x64
	DR2              volatile.Register32 // 0x68
	DR3              volatile.Register32 // 0x6C
	DR4              volatile.Register32 // 0x70
	DR5              volatile.Register32 // 0x74
	DR6              volatile.Register32 // 0x78
	DR7              volatile.Register32 // 0x7C
	DR8              volatile.Register32 // 0x80
	DR9              volatile.Register32 // 0x84
	DR10             volatile.Register32 // 0x88
	DR11             volatile.Register32 // 0x8C
	DR12             volatile.Register32 // 0x90
	DR13             volatile.Register32 // 0x94
	DR14             volatile.Register32 // 0x98
	DR15             volatile.Register32 // 0x9C
	DR16             volatile.Register32 // 0xA0
	DR17             volatile.Register32 // 0xA4
	DR18             volatile.Register32 // 0xA8
	DR19             volatile.Register32 // 0xAC
	DR20             volatile.Register32 // 0xB0
	DR21             volatile.Register32 // 0xB4
	DR22             volatile.Register32 // 0xB8
	DR23             volatile.Register32 // 0xBC
	DR24             volatile.Register32 // 0xC0
	DR25             volatile.Register32 // 0xC4
	DR26             volatile.Register32 // 0xC8
	DR27             volatile.Register32 // 0xCC
	DR28             volatile.Register32 // 0xD0
	DR29             volatile.Register32 // 0xD4
	DR30             volatile.Register32 // 0xD8
	DR31             volatile.Register32 // 0xDC
	DR32             volatile.Register32 // 0xE0
	DR33             volatile.Register32 // 0xE4
	DR34             volatile.Register32 // 0xE8
	DR35             volatile.Register32 // 0xEC
	RX_SAMPLE_DELAY  volatile.Register32 // 0xF0
	SPI_CTRLR0       volatile.Register32 // 0xF4
	_                [4]byte
	XIP_MODE_BITS    volatile.Register32 // 0xFC
	XIP_INCR_INST    volatile.Register32 // 0x100
	XIP_WRAP_INST    volatile.Register32 // 0x104
	XIP_CTRL         volatile.Register32 // 0x108
	XIP_SER          volatile.Register32 // 0x10C
	XRXOICR          volatile.Register32 // 0x110
	XIP_CNT_TIME_OUT volatile.Register32 // 0x114
	ENDIAN           volatile.Register32 // 0x118
}

// SPI.CTRLR0: Control Register 0
func (o *SPI_Type) SetCTRLR0_WORK_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0xc0)|value<<6)
}
func (o *SPI_Type) GetCTRLR0_WORK_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0xc0) >> 6
}
func (o *SPI_Type) SetCTRLR0_TMOD(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetCTRLR0_TMOD() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetCTRLR0_FRAME_FORMAT(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x600000)|value<<21)
}
func (o *SPI_Type) GetCTRLR0_FRAME_FORMAT() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x600000) >> 21
}
func (o *SPI_Type) SetCTRLR0_DATA_LENGTH(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x1f0000)|value<<16)
}
func (o *SPI_Type) GetCTRLR0_DATA_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x1f0000) >> 16
}

// SPI.SPI_CTRLR0: SPI Control Register
func (o *SPI_Type) SetSPI_CTRLR0_AITM(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x3)|value)
}
func (o *SPI_Type) GetSPI_CTRLR0_AITM() uint32 {
	return volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x3
}
func (o *SPI_Type) SetSPI_CTRLR0_ADDR_LENGTH(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x3c)|value<<2)
}
func (o *SPI_Type) GetSPI_CTRLR0_ADDR_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x3c) >> 2
}
func (o *SPI_Type) SetSPI_CTRLR0_INST_LENGTH(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetSPI_CTRLR0_INST_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetSPI_CTRLR0_WAIT_CYCLES(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0xf800)|value<<11)
}
func (o *SPI_Type) GetSPI_CTRLR0_WAIT_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0xf800) >> 11
}

// Serial Peripheral Interface 2 (slave)
type SPI2_Type struct {
	DUMMY volatile.Register32 // 0x0
}

// Serial Peripheral Interface 3 (master)
type SPI3_Type struct {
	CTRLR0           volatile.Register32 // 0x0
	CTRLR1           volatile.Register32 // 0x4
	SSIENR           volatile.Register32 // 0x8
	MWCR             volatile.Register32 // 0xC
	SER              volatile.Register32 // 0x10
	BAUDR            volatile.Register32 // 0x14
	TXFTLR           volatile.Register32 // 0x18
	RXFTLR           volatile.Register32 // 0x1C
	TXFLR            volatile.Register32 // 0x20
	RXFLR            volatile.Register32 // 0x24
	SR               volatile.Register32 // 0x28
	IMR              volatile.Register32 // 0x2C
	ISR              volatile.Register32 // 0x30
	RISR             volatile.Register32 // 0x34
	TXOICR           volatile.Register32 // 0x38
	RXOICR           volatile.Register32 // 0x3C
	RXUICR           volatile.Register32 // 0x40
	MSTICR           volatile.Register32 // 0x44
	ICR              volatile.Register32 // 0x48
	DMACR            volatile.Register32 // 0x4C
	DMATDLR          volatile.Register32 // 0x50
	DMARDLR          volatile.Register32 // 0x54
	IDR              volatile.Register32 // 0x58
	SSIC_VERSION_ID  volatile.Register32 // 0x5C
	DR0              volatile.Register32 // 0x60
	DR1              volatile.Register32 // 0x64
	DR2              volatile.Register32 // 0x68
	DR3              volatile.Register32 // 0x6C
	DR4              volatile.Register32 // 0x70
	DR5              volatile.Register32 // 0x74
	DR6              volatile.Register32 // 0x78
	DR7              volatile.Register32 // 0x7C
	DR8              volatile.Register32 // 0x80
	DR9              volatile.Register32 // 0x84
	DR10             volatile.Register32 // 0x88
	DR11             volatile.Register32 // 0x8C
	DR12             volatile.Register32 // 0x90
	DR13             volatile.Register32 // 0x94
	DR14             volatile.Register32 // 0x98
	DR15             volatile.Register32 // 0x9C
	DR16             volatile.Register32 // 0xA0
	DR17             volatile.Register32 // 0xA4
	DR18             volatile.Register32 // 0xA8
	DR19             volatile.Register32 // 0xAC
	DR20             volatile.Register32 // 0xB0
	DR21             volatile.Register32 // 0xB4
	DR22             volatile.Register32 // 0xB8
	DR23             volatile.Register32 // 0xBC
	DR24             volatile.Register32 // 0xC0
	DR25             volatile.Register32 // 0xC4
	DR26             volatile.Register32 // 0xC8
	DR27             volatile.Register32 // 0xCC
	DR28             volatile.Register32 // 0xD0
	DR29             volatile.Register32 // 0xD4
	DR30             volatile.Register32 // 0xD8
	DR31             volatile.Register32 // 0xDC
	DR32             volatile.Register32 // 0xE0
	DR33             volatile.Register32 // 0xE4
	DR34             volatile.Register32 // 0xE8
	DR35             volatile.Register32 // 0xEC
	RX_SAMPLE_DELAY  volatile.Register32 // 0xF0
	SPI_CTRLR0       volatile.Register32 // 0xF4
	_                [4]byte
	XIP_MODE_BITS    volatile.Register32 // 0xFC
	XIP_INCR_INST    volatile.Register32 // 0x100
	XIP_WRAP_INST    volatile.Register32 // 0x104
	XIP_CTRL         volatile.Register32 // 0x108
	XIP_SER          volatile.Register32 // 0x10C
	XRXOICR          volatile.Register32 // 0x110
	XIP_CNT_TIME_OUT volatile.Register32 // 0x114
	ENDIAN           volatile.Register32 // 0x118
}

// SPI3.CTRLR0: Control Register 0
func (o *SPI3_Type) SetCTRLR0_DATA_LENGTH(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x1f)|value)
}
func (o *SPI3_Type) GetCTRLR0_DATA_LENGTH() uint32 {
	return volatile.LoadUint32(&o.CTRLR0.Reg) & 0x1f
}
func (o *SPI3_Type) SetCTRLR0_WORK_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x300)|value<<8)
}
func (o *SPI3_Type) GetCTRLR0_WORK_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x300) >> 8
}
func (o *SPI3_Type) SetCTRLR0_TMOD(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0xc00)|value<<10)
}
func (o *SPI3_Type) GetCTRLR0_TMOD() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0xc00) >> 10
}
func (o *SPI3_Type) SetCTRLR0_FRAME_FORMAT(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0xc00000)|value<<22)
}
func (o *SPI3_Type) GetCTRLR0_FRAME_FORMAT() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0xc00000) >> 22
}

// SPI3.SPI_CTRLR0: SPI Control Register
func (o *SPI3_Type) SetSPI_CTRLR0_AITM(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x3)|value)
}
func (o *SPI3_Type) GetSPI_CTRLR0_AITM() uint32 {
	return volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x3
}
func (o *SPI3_Type) SetSPI_CTRLR0_ADDR_LENGTH(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x3c)|value<<2)
}
func (o *SPI3_Type) GetSPI_CTRLR0_ADDR_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x3c) >> 2
}
func (o *SPI3_Type) SetSPI_CTRLR0_INST_LENGTH(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x300)|value<<8)
}
func (o *SPI3_Type) GetSPI_CTRLR0_INST_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x300) >> 8
}
func (o *SPI3_Type) SetSPI_CTRLR0_WAIT_CYCLES(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0xf800)|value<<11)
}
func (o *SPI3_Type) GetSPI_CTRLR0_WAIT_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0xf800) >> 11
}

// Inter-Integrated Sound Interface 0
type I2S_Type struct {
	IER                volatile.Register32 // 0x0
	IRER               volatile.Register32 // 0x4
	ITER               volatile.Register32 // 0x8
	CER                volatile.Register32 // 0xC
	CCR                volatile.Register32 // 0x10
	RXFFR              volatile.Register32 // 0x14
	TXFFR              volatile.Register32 // 0x18
	_                  [4]byte
	CHANNEL            [4]I2S_CHANNEL_Type // 0x20
	_                  [160]byte
	RXDMA              volatile.Register32 // 0x1C0
	RRXDMA             volatile.Register32 // 0x1C4
	TXDMA              volatile.Register32 // 0x1C8
	RTXDMA             volatile.Register32 // 0x1CC
	_                  [32]byte
	I2S_COMP_PARAM_2   volatile.Register32 // 0x1F0
	I2S_COMP_PARAM_1   volatile.Register32 // 0x1F4
	I2S_COMP_VERSION_1 volatile.Register32 // 0x1F8
	I2S_COMP_TYPE      volatile.Register32 // 0x1FC
}

// I2S.IER: Enable Register
func (o *I2S_Type) SetIER_IEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetIER_IEN() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// I2S.IRER: Receiver Block Enable Register
func (o *I2S_Type) SetIRER_RXEN(value uint32) {
	volatile.StoreUint32(&o.IRER.Reg, volatile.LoadUint32(&o.IRER.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetIRER_RXEN() uint32 {
	return volatile.LoadUint32(&o.IRER.Reg) & 0x1
}

// I2S.ITER: Transmitter Block Enable Register
func (o *I2S_Type) SetITER_TXEN(value uint32) {
	volatile.StoreUint32(&o.ITER.Reg, volatile.LoadUint32(&o.ITER.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetITER_TXEN() uint32 {
	return volatile.LoadUint32(&o.ITER.Reg) & 0x1
}

// I2S.CER: Clock Generation enable
func (o *I2S_Type) SetCER_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CER.Reg, volatile.LoadUint32(&o.CER.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetCER_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CER.Reg) & 0x1
}

// I2S.CCR: Clock Configuration Register
func (o *I2S_Type) SetCCR_CLK_GATE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x7)|value)
}
func (o *I2S_Type) GetCCR_CLK_GATE() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x7
}
func (o *I2S_Type) SetCCR_CLK_WORD_SIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x18)|value<<3)
}
func (o *I2S_Type) GetCCR_CLK_WORD_SIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x18) >> 3
}
func (o *I2S_Type) SetCCR_ALIGN_MODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xe0)|value<<5)
}
func (o *I2S_Type) GetCCR_ALIGN_MODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xe0) >> 5
}
func (o *I2S_Type) SetCCR_DMA_TX_EN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetCCR_DMA_TX_EN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetCCR_DMA_RX_EN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetCCR_DMA_RX_EN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetCCR_DMA_DIVIDE_16(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetCCR_DMA_DIVIDE_16() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetCCR_SIGN_EXPAND_EN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetCCR_SIGN_EXPAND_EN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x800) >> 11
}

// I2S.RXFFR: Receiver Block FIFO Reset Register
func (o *I2S_Type) SetRXFFR(value uint32) {
	volatile.StoreUint32(&o.RXFFR.Reg, volatile.LoadUint32(&o.RXFFR.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetRXFFR() uint32 {
	return volatile.LoadUint32(&o.RXFFR.Reg) & 0x1
}

// I2S.TXFFR: Transmitter Block FIFO Reset Register
func (o *I2S_Type) SetTXFFR_RXFFR(value uint32) {
	volatile.StoreUint32(&o.TXFFR.Reg, volatile.LoadUint32(&o.TXFFR.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetTXFFR_RXFFR() uint32 {
	return volatile.LoadUint32(&o.TXFFR.Reg) & 0x1
}

// Channel cluster
type I2S_CHANNEL_Type struct {
	LEFT_RXTX  volatile.Register32 // 0x20
	RIGHT_RXTX volatile.Register32 // 0x24
	RER        volatile.Register32 // 0x28
	TER        volatile.Register32 // 0x2C
	RCR        volatile.Register32 // 0x30
	TCR        volatile.Register32 // 0x34
	ISR        volatile.Register32 // 0x38
	IMR        volatile.Register32 // 0x3C
	ROR        volatile.Register32 // 0x40
	TOR        volatile.Register32 // 0x44
	RFCR       volatile.Register32 // 0x48
	TFCR       volatile.Register32 // 0x4C
	RFF        volatile.Register32 // 0x50
	TFF        volatile.Register32 // 0x54
	_RESERVED0 volatile.Register32 // 0x58
	_RESERVED1 volatile.Register32 // 0x5C
}

// I2S_CHANNEL.RER: Receive Enable Register
func (o *I2S_CHANNEL_Type) SetRER_RXCHENX(value uint32) {
	volatile.StoreUint32(&o.RER.Reg, volatile.LoadUint32(&o.RER.Reg)&^(0x1)|value)
}
func (o *I2S_CHANNEL_Type) GetRER_RXCHENX() uint32 {
	return volatile.LoadUint32(&o.RER.Reg) & 0x1
}

// I2S_CHANNEL.TER: Transmit Enable Register
func (o *I2S_CHANNEL_Type) SetTER_TXCHENX(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x1)|value)
}
func (o *I2S_CHANNEL_Type) GetTER_TXCHENX() uint32 {
	return volatile.LoadUint32(&o.TER.Reg) & 0x1
}

// I2S_CHANNEL.RCR: Receive Configuration Register
func (o *I2S_CHANNEL_Type) SetRCR_WLEN(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0x7)|value)
}
func (o *I2S_CHANNEL_Type) GetRCR_WLEN() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0x7
}

// I2S_CHANNEL.TCR: Transmit Configuration Register
func (o *I2S_CHANNEL_Type) SetTCR_WLEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x7)|value)
}
func (o *I2S_CHANNEL_Type) GetTCR_WLEN() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x7
}

// I2S_CHANNEL.ISR: Interrupt Status Register
func (o *I2S_CHANNEL_Type) SetISR_RXDA(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2S_CHANNEL_Type) GetISR_RXDA() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *I2S_CHANNEL_Type) SetISR_RXFO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2S_CHANNEL_Type) GetISR_RXFO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2S_CHANNEL_Type) SetISR_TXFE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2S_CHANNEL_Type) GetISR_TXFE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2S_CHANNEL_Type) SetISR_TXFO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2S_CHANNEL_Type) GetISR_TXFO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}

// I2S_CHANNEL.IMR: Interrupt Mask Register
func (o *I2S_CHANNEL_Type) SetIMR_RXDAM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *I2S_CHANNEL_Type) GetIMR_RXDAM() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *I2S_CHANNEL_Type) SetIMR_RXFOM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *I2S_CHANNEL_Type) GetIMR_RXFOM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *I2S_CHANNEL_Type) SetIMR_TXFEM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *I2S_CHANNEL_Type) GetIMR_TXFEM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *I2S_CHANNEL_Type) SetIMR_TXFOM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *I2S_CHANNEL_Type) GetIMR_TXFOM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}

// I2S_CHANNEL.ROR: Receive Overrun Register
func (o *I2S_CHANNEL_Type) SetROR_RXCHO(value uint32) {
	volatile.StoreUint32(&o.ROR.Reg, volatile.LoadUint32(&o.ROR.Reg)&^(0x1)|value)
}
func (o *I2S_CHANNEL_Type) GetROR_RXCHO() uint32 {
	return volatile.LoadUint32(&o.ROR.Reg) & 0x1
}

// I2S_CHANNEL.TOR: Transmit Overrun Register
func (o *I2S_CHANNEL_Type) SetTOR_TXCHO(value uint32) {
	volatile.StoreUint32(&o.TOR.Reg, volatile.LoadUint32(&o.TOR.Reg)&^(0x1)|value)
}
func (o *I2S_CHANNEL_Type) GetTOR_TXCHO() uint32 {
	return volatile.LoadUint32(&o.TOR.Reg) & 0x1
}

// I2S_CHANNEL.RFCR: Receive FIFO Configuration Register
func (o *I2S_CHANNEL_Type) SetRFCR_RXCHDT(value uint32) {
	volatile.StoreUint32(&o.RFCR.Reg, volatile.LoadUint32(&o.RFCR.Reg)&^(0xf)|value)
}
func (o *I2S_CHANNEL_Type) GetRFCR_RXCHDT() uint32 {
	return volatile.LoadUint32(&o.RFCR.Reg) & 0xf
}

// I2S_CHANNEL.TFCR: Transmit FIFO Configuration Register
func (o *I2S_CHANNEL_Type) SetTFCR_TXCHET(value uint32) {
	volatile.StoreUint32(&o.TFCR.Reg, volatile.LoadUint32(&o.TFCR.Reg)&^(0xf)|value)
}
func (o *I2S_CHANNEL_Type) GetTFCR_TXCHET() uint32 {
	return volatile.LoadUint32(&o.TFCR.Reg) & 0xf
}

// I2S_CHANNEL.RFF: Receive FIFO Flush Register
func (o *I2S_CHANNEL_Type) SetRFF_RXCHFR(value uint32) {
	volatile.StoreUint32(&o.RFF.Reg, volatile.LoadUint32(&o.RFF.Reg)&^(0x1)|value)
}
func (o *I2S_CHANNEL_Type) GetRFF_RXCHFR() uint32 {
	return volatile.LoadUint32(&o.RFF.Reg) & 0x1
}

// I2S_CHANNEL.TFF: Transmit FIFO Flush Register
func (o *I2S_CHANNEL_Type) SetTFF_RTXCHFR(value uint32) {
	volatile.StoreUint32(&o.TFF.Reg, volatile.LoadUint32(&o.TFF.Reg)&^(0x1)|value)
}
func (o *I2S_CHANNEL_Type) GetTFF_RTXCHFR() uint32 {
	return volatile.LoadUint32(&o.TFF.Reg) & 0x1
}

// Audio Processor
type APU_Type struct {
	CH_CFG          volatile.Register32     // 0x0
	CTL             volatile.Register32     // 0x4
	DIR_BIDX        [32]volatile.Register32 // 0x8
	PRE_FIR0_COEF   [9]volatile.Register32  // 0x88
	POST_FIR0_COEF  [9]volatile.Register32  // 0xAC
	PRE_FIR1_COEF   [9]volatile.Register32  // 0xD0
	POST_FIR1_COEF  [9]volatile.Register32  // 0xF4
	DWSZ_CFG        volatile.Register32     // 0x118
	FFT_CFG         volatile.Register32     // 0x11C
	SOBUF_DMA_RDATA volatile.Register32     // 0x120
	VOBUF_DMA_RDATA volatile.Register32     // 0x124
	INT_STAT        volatile.Register32     // 0x128
	INT_MASK        volatile.Register32     // 0x12C
	SAT_COUNTER     volatile.Register32     // 0x130
	SAT_LIMITS      volatile.Register32     // 0x134
}

// APU.CH_CFG: Channel Config Register
func (o *APU_Type) SetCH_CFG_SOUND_CH_EN(value uint32) {
	volatile.StoreUint32(&o.CH_CFG.Reg, volatile.LoadUint32(&o.CH_CFG.Reg)&^(0xff)|value)
}
func (o *APU_Type) GetCH_CFG_SOUND_CH_EN() uint32 {
	return volatile.LoadUint32(&o.CH_CFG.Reg) & 0xff
}
func (o *APU_Type) SetCH_CFG_TARGET_DIR(value uint32) {
	volatile.StoreUint32(&o.CH_CFG.Reg, volatile.LoadUint32(&o.CH_CFG.Reg)&^(0xf00)|value<<8)
}
func (o *APU_Type) GetCH_CFG_TARGET_DIR() uint32 {
	return (volatile.LoadUint32(&o.CH_CFG.Reg) & 0xf00) >> 8
}
func (o *APU_Type) SetCH_CFG_AUDIO_GAIN(value uint32) {
	volatile.StoreUint32(&o.CH_CFG.Reg, volatile.LoadUint32(&o.CH_CFG.Reg)&^(0x7ff000)|value<<12)
}
func (o *APU_Type) GetCH_CFG_AUDIO_GAIN() uint32 {
	return (volatile.LoadUint32(&o.CH_CFG.Reg) & 0x7ff000) >> 12
}
func (o *APU_Type) SetCH_CFG_DATA_SRC_MODE(value uint32) {
	volatile.StoreUint32(&o.CH_CFG.Reg, volatile.LoadUint32(&o.CH_CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *APU_Type) GetCH_CFG_DATA_SRC_MODE() uint32 {
	return (volatile.LoadUint32(&o.CH_CFG.Reg) & 0x1000000) >> 24
}
func (o *APU_Type) SetCH_CFG_WE_SOUND_CH_EN(value uint32) {
	volatile.StoreUint32(&o.CH_CFG.Reg, volatile.LoadUint32(&o.CH_CFG.Reg)&^(0x10000000)|value<<28)
}
func (o *APU_Type) GetCH_CFG_WE_SOUND_CH_EN() uint32 {
	return (volatile.LoadUint32(&o.CH_CFG.Reg) & 0x10000000) >> 28
}
func (o *APU_Type) SetCH_CFG_WE_TARGET_DIR(value uint32) {
	volatile.StoreUint32(&o.CH_CFG.Reg, volatile.LoadUint32(&o.CH_CFG.Reg)&^(0x20000000)|value<<29)
}
func (o *APU_Type) GetCH_CFG_WE_TARGET_DIR() uint32 {
	return (volatile.LoadUint32(&o.CH_CFG.Reg) & 0x20000000) >> 29
}
func (o *APU_Type) SetCH_CFG_WE_AUDIO_GAIN(value uint32) {
	volatile.StoreUint32(&o.CH_CFG.Reg, volatile.LoadUint32(&o.CH_CFG.Reg)&^(0x40000000)|value<<30)
}
func (o *APU_Type) GetCH_CFG_WE_AUDIO_GAIN() uint32 {
	return (volatile.LoadUint32(&o.CH_CFG.Reg) & 0x40000000) >> 30
}
func (o *APU_Type) SetCH_CFG_WE_DATA_SRC_MODE(value uint32) {
	volatile.StoreUint32(&o.CH_CFG.Reg, volatile.LoadUint32(&o.CH_CFG.Reg)&^(0x80000000)|value<<31)
}
func (o *APU_Type) GetCH_CFG_WE_DATA_SRC_MODE() uint32 {
	return (volatile.LoadUint32(&o.CH_CFG.Reg) & 0x80000000) >> 31
}

// APU.CTL: Control Register
func (o *APU_Type) SetCTL_DIR_SEARCH_EN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x1)|value)
}
func (o *APU_Type) GetCTL_DIR_SEARCH_EN() uint32 {
	return volatile.LoadUint32(&o.CTL.Reg) & 0x1
}
func (o *APU_Type) SetCTL_SEARCH_PATH_RESET(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x2)|value<<1)
}
func (o *APU_Type) GetCTL_SEARCH_PATH_RESET() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x2) >> 1
}
func (o *APU_Type) SetCTL_STREAM_GEN_EN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x10)|value<<4)
}
func (o *APU_Type) GetCTL_STREAM_GEN_EN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x10) >> 4
}
func (o *APU_Type) SetCTL_VOICE_GEN_PATH_RESET(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x20)|value<<5)
}
func (o *APU_Type) GetCTL_VOICE_GEN_PATH_RESET() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x20) >> 5
}
func (o *APU_Type) SetCTL_UPDATE_VOICE_DIR(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x40)|value<<6)
}
func (o *APU_Type) GetCTL_UPDATE_VOICE_DIR() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x40) >> 6
}
func (o *APU_Type) SetCTL_WE_DIR_SEARCH_EN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x100)|value<<8)
}
func (o *APU_Type) GetCTL_WE_DIR_SEARCH_EN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x100) >> 8
}
func (o *APU_Type) SetCTL_WE_SEARCH_PATH_RST(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x200)|value<<9)
}
func (o *APU_Type) GetCTL_WE_SEARCH_PATH_RST() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x200) >> 9
}
func (o *APU_Type) SetCTL_WE_STREAM_GEN(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x400)|value<<10)
}
func (o *APU_Type) GetCTL_WE_STREAM_GEN() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x400) >> 10
}
func (o *APU_Type) SetCTL_WE_VOICE_GEN_PATH_RST(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x800)|value<<11)
}
func (o *APU_Type) GetCTL_WE_VOICE_GEN_PATH_RST() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x800) >> 11
}
func (o *APU_Type) SetCTL_WE_UPDATE_VOICE_DIR(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x1000)|value<<12)
}
func (o *APU_Type) GetCTL_WE_UPDATE_VOICE_DIR() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x1000) >> 12
}

// APU.DIR_BIDX: Direction Sample Buffer Read Index Configure Register (16 directions * 2 values * 4 indices)
func (o *APU_Type) SetDIR_BIDX_RD_IDX_S(idx int, value uint32) {
	volatile.StoreUint32(&o.DIR_BIDX[idx].Reg, volatile.LoadUint32(&o.DIR_BIDX[idx].Reg)&^(0x3f)|value)
}
func (o *APU_Type) GetDIR_BIDX_RD_IDX_S(idx int) uint32 {
	return volatile.LoadUint32(&o.DIR_BIDX[idx].Reg) & 0x3f
}

// APU.PRE_FIR0_COEF: FIR0 pre-filter coefficients
func (o *APU_Type) SetPRE_FIR0_COEF_TAP0(idx int, value uint32) {
	volatile.StoreUint32(&o.PRE_FIR0_COEF[idx].Reg, volatile.LoadUint32(&o.PRE_FIR0_COEF[idx].Reg)&^(0xffff)|value)
}
func (o *APU_Type) GetPRE_FIR0_COEF_TAP0(idx int) uint32 {
	return volatile.LoadUint32(&o.PRE_FIR0_COEF[idx].Reg) & 0xffff
}
func (o *APU_Type) SetPRE_FIR0_COEF_TAP1(idx int, value uint32) {
	volatile.StoreUint32(&o.PRE_FIR0_COEF[idx].Reg, volatile.LoadUint32(&o.PRE_FIR0_COEF[idx].Reg)&^(0xffff0000)|value<<16)
}
func (o *APU_Type) GetPRE_FIR0_COEF_TAP1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PRE_FIR0_COEF[idx].Reg) & 0xffff0000) >> 16
}

// APU.POST_FIR0_COEF: FIR0 post-filter coefficients
func (o *APU_Type) SetPOST_FIR0_COEF_TAP0(idx int, value uint32) {
	volatile.StoreUint32(&o.POST_FIR0_COEF[idx].Reg, volatile.LoadUint32(&o.POST_FIR0_COEF[idx].Reg)&^(0xffff)|value)
}
func (o *APU_Type) GetPOST_FIR0_COEF_TAP0(idx int) uint32 {
	return volatile.LoadUint32(&o.POST_FIR0_COEF[idx].Reg) & 0xffff
}
func (o *APU_Type) SetPOST_FIR0_COEF_TAP1(idx int, value uint32) {
	volatile.StoreUint32(&o.POST_FIR0_COEF[idx].Reg, volatile.LoadUint32(&o.POST_FIR0_COEF[idx].Reg)&^(0xffff0000)|value<<16)
}
func (o *APU_Type) GetPOST_FIR0_COEF_TAP1(idx int) uint32 {
	return (volatile.LoadUint32(&o.POST_FIR0_COEF[idx].Reg) & 0xffff0000) >> 16
}

// APU.PRE_FIR1_COEF: FIR1 pre-filter coeffecients
func (o *APU_Type) SetPRE_FIR1_COEF_TAP0(idx int, value uint32) {
	volatile.StoreUint32(&o.PRE_FIR1_COEF[idx].Reg, volatile.LoadUint32(&o.PRE_FIR1_COEF[idx].Reg)&^(0xffff)|value)
}
func (o *APU_Type) GetPRE_FIR1_COEF_TAP0(idx int) uint32 {
	return volatile.LoadUint32(&o.PRE_FIR1_COEF[idx].Reg) & 0xffff
}
func (o *APU_Type) SetPRE_FIR1_COEF_TAP1(idx int, value uint32) {
	volatile.StoreUint32(&o.PRE_FIR1_COEF[idx].Reg, volatile.LoadUint32(&o.PRE_FIR1_COEF[idx].Reg)&^(0xffff0000)|value<<16)
}
func (o *APU_Type) GetPRE_FIR1_COEF_TAP1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PRE_FIR1_COEF[idx].Reg) & 0xffff0000) >> 16
}

// APU.POST_FIR1_COEF: FIR1 post-filter coefficients
func (o *APU_Type) SetPOST_FIR1_COEF_TAP0(idx int, value uint32) {
	volatile.StoreUint32(&o.POST_FIR1_COEF[idx].Reg, volatile.LoadUint32(&o.POST_FIR1_COEF[idx].Reg)&^(0xffff)|value)
}
func (o *APU_Type) GetPOST_FIR1_COEF_TAP0(idx int) uint32 {
	return volatile.LoadUint32(&o.POST_FIR1_COEF[idx].Reg) & 0xffff
}
func (o *APU_Type) SetPOST_FIR1_COEF_TAP1(idx int, value uint32) {
	volatile.StoreUint32(&o.POST_FIR1_COEF[idx].Reg, volatile.LoadUint32(&o.POST_FIR1_COEF[idx].Reg)&^(0xffff0000)|value<<16)
}
func (o *APU_Type) GetPOST_FIR1_COEF_TAP1(idx int) uint32 {
	return (volatile.LoadUint32(&o.POST_FIR1_COEF[idx].Reg) & 0xffff0000) >> 16
}

// APU.DWSZ_CFG: Downsize Config Register
func (o *APU_Type) SetDWSZ_CFG_DIR_DWN_SIZ_RATE(value uint32) {
	volatile.StoreUint32(&o.DWSZ_CFG.Reg, volatile.LoadUint32(&o.DWSZ_CFG.Reg)&^(0xf)|value)
}
func (o *APU_Type) GetDWSZ_CFG_DIR_DWN_SIZ_RATE() uint32 {
	return volatile.LoadUint32(&o.DWSZ_CFG.Reg) & 0xf
}
func (o *APU_Type) SetDWSZ_CFG_VOC_DWN_SIZ_RATE(value uint32) {
	volatile.StoreUint32(&o.DWSZ_CFG.Reg, volatile.LoadUint32(&o.DWSZ_CFG.Reg)&^(0xf0)|value<<4)
}
func (o *APU_Type) GetDWSZ_CFG_VOC_DWN_SIZ_RATE() uint32 {
	return (volatile.LoadUint32(&o.DWSZ_CFG.Reg) & 0xf0) >> 4
}
func (o *APU_Type) SetDWSZ_CFG_SMPL_SHIFT_BITS(value uint32) {
	volatile.StoreUint32(&o.DWSZ_CFG.Reg, volatile.LoadUint32(&o.DWSZ_CFG.Reg)&^(0x1f00)|value<<8)
}
func (o *APU_Type) GetDWSZ_CFG_SMPL_SHIFT_BITS() uint32 {
	return (volatile.LoadUint32(&o.DWSZ_CFG.Reg) & 0x1f00) >> 8
}

// APU.INT_STAT: Interrupt Status Register
func (o *APU_Type) SetINT_STAT_DIR_SEARCH_DATA_RDY(value uint32) {
	volatile.StoreUint32(&o.INT_STAT.Reg, volatile.LoadUint32(&o.INT_STAT.Reg)&^(0x1)|value)
}
func (o *APU_Type) GetINT_STAT_DIR_SEARCH_DATA_RDY() uint32 {
	return volatile.LoadUint32(&o.INT_STAT.Reg) & 0x1
}
func (o *APU_Type) SetINT_STAT_VOC_BUF_DATA_RDY(value uint32) {
	volatile.StoreUint32(&o.INT_STAT.Reg, volatile.LoadUint32(&o.INT_STAT.Reg)&^(0x2)|value<<1)
}
func (o *APU_Type) GetINT_STAT_VOC_BUF_DATA_RDY() uint32 {
	return (volatile.LoadUint32(&o.INT_STAT.Reg) & 0x2) >> 1
}

// APU.INT_MASK: Interrupt Mask Register
func (o *APU_Type) SetINT_MASK_DIR_SEARCH_DATA_RDY(value uint32) {
	volatile.StoreUint32(&o.INT_MASK.Reg, volatile.LoadUint32(&o.INT_MASK.Reg)&^(0x1)|value)
}
func (o *APU_Type) GetINT_MASK_DIR_SEARCH_DATA_RDY() uint32 {
	return volatile.LoadUint32(&o.INT_MASK.Reg) & 0x1
}
func (o *APU_Type) SetINT_MASK_VOC_BUF_DATA_RDY(value uint32) {
	volatile.StoreUint32(&o.INT_MASK.Reg, volatile.LoadUint32(&o.INT_MASK.Reg)&^(0x2)|value<<1)
}
func (o *APU_Type) GetINT_MASK_VOC_BUF_DATA_RDY() uint32 {
	return (volatile.LoadUint32(&o.INT_MASK.Reg) & 0x2) >> 1
}

// APU.SAT_COUNTER: Saturation Counter
func (o *APU_Type) SetSAT_COUNTER_COUNTER(value uint32) {
	volatile.StoreUint32(&o.SAT_COUNTER.Reg, volatile.LoadUint32(&o.SAT_COUNTER.Reg)&^(0xffff)|value)
}
func (o *APU_Type) GetSAT_COUNTER_COUNTER() uint32 {
	return volatile.LoadUint32(&o.SAT_COUNTER.Reg) & 0xffff
}
func (o *APU_Type) SetSAT_COUNTER_TOTAL(value uint32) {
	volatile.StoreUint32(&o.SAT_COUNTER.Reg, volatile.LoadUint32(&o.SAT_COUNTER.Reg)&^(0xffff0000)|value<<16)
}
func (o *APU_Type) GetSAT_COUNTER_TOTAL() uint32 {
	return (volatile.LoadUint32(&o.SAT_COUNTER.Reg) & 0xffff0000) >> 16
}

// APU.SAT_LIMITS: Saturation Limits
func (o *APU_Type) SetSAT_LIMITS_UPPER(value uint32) {
	volatile.StoreUint32(&o.SAT_LIMITS.Reg, volatile.LoadUint32(&o.SAT_LIMITS.Reg)&^(0xffff)|value)
}
func (o *APU_Type) GetSAT_LIMITS_UPPER() uint32 {
	return volatile.LoadUint32(&o.SAT_LIMITS.Reg) & 0xffff
}
func (o *APU_Type) SetSAT_LIMITS_BOTTOM(value uint32) {
	volatile.StoreUint32(&o.SAT_LIMITS.Reg, volatile.LoadUint32(&o.SAT_LIMITS.Reg)&^(0xffff0000)|value<<16)
}
func (o *APU_Type) GetSAT_LIMITS_BOTTOM() uint32 {
	return (volatile.LoadUint32(&o.SAT_LIMITS.Reg) & 0xffff0000) >> 16
}

// Inter-Integrated Circuit Bus 0
type I2C_Type struct {
	CON            volatile.Register32 // 0x0
	TAR            volatile.Register32 // 0x4
	SAR            volatile.Register32 // 0x8
	_              [4]byte
	DATA_CMD       volatile.Register32 // 0x10
	SS_SCL_HCNT    volatile.Register32 // 0x14
	SS_SCL_LCNT    volatile.Register32 // 0x18
	_              [16]byte
	INTR_STAT      volatile.Register32 // 0x2C
	INTR_MASK      volatile.Register32 // 0x30
	RAW_INTR_STAT  volatile.Register32 // 0x34
	RX_TL          volatile.Register32 // 0x38
	TX_TL          volatile.Register32 // 0x3C
	CLR_INTR       volatile.Register32 // 0x40
	CLR_RX_UNDER   volatile.Register32 // 0x44
	CLR_RX_OVER    volatile.Register32 // 0x48
	CLR_TX_OVER    volatile.Register32 // 0x4C
	CLR_RD_REQ     volatile.Register32 // 0x50
	CLR_TX_ABRT    volatile.Register32 // 0x54
	CLR_RX_DONE    volatile.Register32 // 0x58
	CLR_ACTIVITY   volatile.Register32 // 0x5C
	CLR_STOP_DET   volatile.Register32 // 0x60
	CLR_START_DET  volatile.Register32 // 0x64
	CLR_GEN_CALL   volatile.Register32 // 0x68
	ENABLE         volatile.Register32 // 0x6C
	STATUS         volatile.Register32 // 0x70
	TXFLR          volatile.Register32 // 0x74
	RXFLR          volatile.Register32 // 0x78
	SDA_HOLD       volatile.Register32 // 0x7C
	TX_ABRT_SOURCE volatile.Register32 // 0x80
	_              [4]byte
	DMA_CR         volatile.Register32 // 0x88
	DMA_TDLR       volatile.Register32 // 0x8C
	DMA_RDLR       volatile.Register32 // 0x90
	SDA_SETUP      volatile.Register32 // 0x94
	GENERAL_CALL   volatile.Register32 // 0x98
	ENABLE_STATUS  volatile.Register32 // 0x9C
	FS_SPKLEN      volatile.Register32 // 0xA0
	_              [80]byte
	COMP_PARAM_1   volatile.Register32 // 0xF4
	COMP_VERSION   volatile.Register32 // 0xF8
	COMP_TYPE      volatile.Register32 // 0xFC
}

// I2C.CON: Control Register
func (o *I2C_Type) SetCON_MASTER_MODE(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCON_MASTER_MODE() uint32 {
	return volatile.LoadUint32(&o.CON.Reg) & 0x1
}
func (o *I2C_Type) SetCON_SPEED(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x6)|value<<1)
}
func (o *I2C_Type) GetCON_SPEED() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x6) >> 1
}
func (o *I2C_Type) SetCON_ADDR_SLAVE_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCON_ADDR_SLAVE_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCON_RESTART_EN(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCON_RESTART_EN() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCON_SLAVE_DISABLE(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCON_SLAVE_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCON_STOP_DET(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCON_STOP_DET() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCON_TX_EMPTY(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCON_TX_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x100) >> 8
}

// I2C.TAR: Target Address Register
func (o *I2C_Type) SetTAR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.TAR.Reg, volatile.LoadUint32(&o.TAR.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetTAR_ADDRESS() uint32 {
	return volatile.LoadUint32(&o.TAR.Reg) & 0x3ff
}
func (o *I2C_Type) SetTAR_GC(value uint32) {
	volatile.StoreUint32(&o.TAR.Reg, volatile.LoadUint32(&o.TAR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetTAR_GC() uint32 {
	return (volatile.LoadUint32(&o.TAR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetTAR_SPECIAL(value uint32) {
	volatile.StoreUint32(&o.TAR.Reg, volatile.LoadUint32(&o.TAR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetTAR_SPECIAL() uint32 {
	return (volatile.LoadUint32(&o.TAR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetTAR_ADDR_MASTER_WIDTH(value uint32) {
	volatile.StoreUint32(&o.TAR.Reg, volatile.LoadUint32(&o.TAR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTAR_ADDR_MASTER_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.TAR.Reg) & 0x1000) >> 12
}

// I2C.SAR: Slave Address Register
func (o *I2C_Type) SetSAR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.SAR.Reg, volatile.LoadUint32(&o.SAR.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSAR_ADDRESS() uint32 {
	return volatile.LoadUint32(&o.SAR.Reg) & 0x3ff
}

// I2C.DATA_CMD: Data Buffer and Command Register
func (o *I2C_Type) SetDATA_CMD_CMD(value uint32) {
	volatile.StoreUint32(&o.DATA_CMD.Reg, volatile.LoadUint32(&o.DATA_CMD.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetDATA_CMD_CMD() uint32 {
	return (volatile.LoadUint32(&o.DATA_CMD.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetDATA_CMD_DATA(value uint32) {
	volatile.StoreUint32(&o.DATA_CMD.Reg, volatile.LoadUint32(&o.DATA_CMD.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDATA_CMD_DATA() uint32 {
	return volatile.LoadUint32(&o.DATA_CMD.Reg) & 0xff
}

// I2C.SS_SCL_HCNT: Standard Speed Clock SCL High Count Register
func (o *I2C_Type) SetSS_SCL_HCNT_COUNT(value uint32) {
	volatile.StoreUint32(&o.SS_SCL_HCNT.Reg, volatile.LoadUint32(&o.SS_SCL_HCNT.Reg)&^(0xffff)|value)
}
func (o *I2C_Type) GetSS_SCL_HCNT_COUNT() uint32 {
	return volatile.LoadUint32(&o.SS_SCL_HCNT.Reg) & 0xffff
}

// I2C.SS_SCL_LCNT: Standard Speed Clock SCL Low Count Register
func (o *I2C_Type) SetSS_SCL_LCNT_COUNT(value uint32) {
	volatile.StoreUint32(&o.SS_SCL_LCNT.Reg, volatile.LoadUint32(&o.SS_SCL_LCNT.Reg)&^(0xffff)|value)
}
func (o *I2C_Type) GetSS_SCL_LCNT_COUNT() uint32 {
	return volatile.LoadUint32(&o.SS_SCL_LCNT.Reg) & 0xffff
}

// I2C.INTR_STAT: Interrupt Status Register
func (o *I2C_Type) SetINTR_STAT_RX_UNDER(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINTR_STAT_RX_UNDER() uint32 {
	return volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x1
}
func (o *I2C_Type) SetINTR_STAT_RX_OVER(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINTR_STAT_RX_OVER() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINTR_STAT_RX_FULL(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINTR_STAT_RX_FULL() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINTR_STAT_TX_OVER(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINTR_STAT_TX_OVER() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINTR_STAT_TX_EMPTY(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINTR_STAT_TX_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINTR_STAT_RD_REQ(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINTR_STAT_RD_REQ() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINTR_STAT_TX_ABRT(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINTR_STAT_TX_ABRT() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINTR_STAT_RX_DONE(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINTR_STAT_RX_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINTR_STAT_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINTR_STAT_ACTIVITY() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINTR_STAT_STOP_DET(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINTR_STAT_STOP_DET() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINTR_STAT_START_DET(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINTR_STAT_START_DET() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINTR_STAT_GEN_CALL(value uint32) {
	volatile.StoreUint32(&o.INTR_STAT.Reg, volatile.LoadUint32(&o.INTR_STAT.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINTR_STAT_GEN_CALL() uint32 {
	return (volatile.LoadUint32(&o.INTR_STAT.Reg) & 0x800) >> 11
}

// I2C.INTR_MASK: Interrupt Mask Register
func (o *I2C_Type) SetINTR_MASK_RX_UNDER(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINTR_MASK_RX_UNDER() uint32 {
	return volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x1
}
func (o *I2C_Type) SetINTR_MASK_RX_OVER(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINTR_MASK_RX_OVER() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINTR_MASK_RX_FULL(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINTR_MASK_RX_FULL() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINTR_MASK_TX_OVER(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINTR_MASK_TX_OVER() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINTR_MASK_TX_EMPTY(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINTR_MASK_TX_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINTR_MASK_RD_REQ(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINTR_MASK_RD_REQ() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINTR_MASK_TX_ABRT(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINTR_MASK_TX_ABRT() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINTR_MASK_RX_DONE(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINTR_MASK_RX_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINTR_MASK_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINTR_MASK_ACTIVITY() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINTR_MASK_STOP_DET(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINTR_MASK_STOP_DET() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINTR_MASK_START_DET(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINTR_MASK_START_DET() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINTR_MASK_GEN_CALL(value uint32) {
	volatile.StoreUint32(&o.INTR_MASK.Reg, volatile.LoadUint32(&o.INTR_MASK.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINTR_MASK_GEN_CALL() uint32 {
	return (volatile.LoadUint32(&o.INTR_MASK.Reg) & 0x800) >> 11
}

// I2C.RAW_INTR_STAT: Raw Interrupt Status Register
func (o *I2C_Type) SetRAW_INTR_STAT_RX_UNDER(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetRAW_INTR_STAT_RX_UNDER() uint32 {
	return volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x1
}
func (o *I2C_Type) SetRAW_INTR_STAT_RX_OVER(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetRAW_INTR_STAT_RX_OVER() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetRAW_INTR_STAT_RX_FULL(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetRAW_INTR_STAT_RX_FULL() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetRAW_INTR_STAT_TX_OVER(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetRAW_INTR_STAT_TX_OVER() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetRAW_INTR_STAT_TX_EMPTY(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetRAW_INTR_STAT_TX_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetRAW_INTR_STAT_RD_REQ(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetRAW_INTR_STAT_RD_REQ() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetRAW_INTR_STAT_TX_ABRT(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetRAW_INTR_STAT_TX_ABRT() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetRAW_INTR_STAT_RX_DONE(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetRAW_INTR_STAT_RX_DONE() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetRAW_INTR_STAT_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetRAW_INTR_STAT_ACTIVITY() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetRAW_INTR_STAT_STOP_DET(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetRAW_INTR_STAT_STOP_DET() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetRAW_INTR_STAT_START_DET(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetRAW_INTR_STAT_START_DET() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetRAW_INTR_STAT_GEN_CALL(value uint32) {
	volatile.StoreUint32(&o.RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.RAW_INTR_STAT.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetRAW_INTR_STAT_GEN_CALL() uint32 {
	return (volatile.LoadUint32(&o.RAW_INTR_STAT.Reg) & 0x800) >> 11
}

// I2C.RX_TL: Receive FIFO Threshold Register
func (o *I2C_Type) SetRX_TL_VALUE(value uint32) {
	volatile.StoreUint32(&o.RX_TL.Reg, volatile.LoadUint32(&o.RX_TL.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetRX_TL_VALUE() uint32 {
	return volatile.LoadUint32(&o.RX_TL.Reg) & 0x7
}

// I2C.TX_TL: Transmit FIFO Threshold Register
func (o *I2C_Type) SetTX_TL_VALUE(value uint32) {
	volatile.StoreUint32(&o.TX_TL.Reg, volatile.LoadUint32(&o.TX_TL.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetTX_TL_VALUE() uint32 {
	return volatile.LoadUint32(&o.TX_TL.Reg) & 0x7
}

// I2C.CLR_INTR: Clear Combined and Individual Interrupt Register
func (o *I2C_Type) SetCLR_INTR_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_INTR.Reg, volatile.LoadUint32(&o.CLR_INTR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_INTR_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_INTR.Reg) & 0x1
}

// I2C.CLR_RX_UNDER: Clear RX_UNDER Interrupt Register
func (o *I2C_Type) SetCLR_RX_UNDER_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_RX_UNDER.Reg, volatile.LoadUint32(&o.CLR_RX_UNDER.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_RX_UNDER_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_RX_UNDER.Reg) & 0x1
}

// I2C.CLR_RX_OVER: Clear RX_OVER Interrupt Register
func (o *I2C_Type) SetCLR_RX_OVER_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_RX_OVER.Reg, volatile.LoadUint32(&o.CLR_RX_OVER.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_RX_OVER_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_RX_OVER.Reg) & 0x1
}

// I2C.CLR_TX_OVER: Clear TX_OVER Interrupt Register
func (o *I2C_Type) SetCLR_TX_OVER_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_TX_OVER.Reg, volatile.LoadUint32(&o.CLR_TX_OVER.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_TX_OVER_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_TX_OVER.Reg) & 0x1
}

// I2C.CLR_RD_REQ: Clear RD_REQ Interrupt Register
func (o *I2C_Type) SetCLR_RD_REQ_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_RD_REQ.Reg, volatile.LoadUint32(&o.CLR_RD_REQ.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_RD_REQ_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_RD_REQ.Reg) & 0x1
}

// I2C.CLR_TX_ABRT: Clear TX_ABRT Interrupt Register
func (o *I2C_Type) SetCLR_TX_ABRT_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_TX_ABRT.Reg, volatile.LoadUint32(&o.CLR_TX_ABRT.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_TX_ABRT_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_TX_ABRT.Reg) & 0x1
}

// I2C.CLR_RX_DONE: Clear RX_DONE Interrupt Register
func (o *I2C_Type) SetCLR_RX_DONE_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_RX_DONE.Reg, volatile.LoadUint32(&o.CLR_RX_DONE.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_RX_DONE_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_RX_DONE.Reg) & 0x1
}

// I2C.CLR_ACTIVITY: Clear ACTIVITY Interrupt Register
func (o *I2C_Type) SetCLR_ACTIVITY_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_ACTIVITY.Reg, volatile.LoadUint32(&o.CLR_ACTIVITY.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_ACTIVITY_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_ACTIVITY.Reg) & 0x1
}

// I2C.CLR_STOP_DET: Clear STOP_DET Interrupt Register
func (o *I2C_Type) SetCLR_STOP_DET_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_STOP_DET.Reg, volatile.LoadUint32(&o.CLR_STOP_DET.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_STOP_DET_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_STOP_DET.Reg) & 0x1
}

// I2C.CLR_START_DET: Clear START_DET Interrupt Register
func (o *I2C_Type) SetCLR_START_DET_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_START_DET.Reg, volatile.LoadUint32(&o.CLR_START_DET.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_START_DET_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_START_DET.Reg) & 0x1
}

// I2C.CLR_GEN_CALL: I2C Clear GEN_CALL Interrupt Register
func (o *I2C_Type) SetCLR_GEN_CALL_CLR(value uint32) {
	volatile.StoreUint32(&o.CLR_GEN_CALL.Reg, volatile.LoadUint32(&o.CLR_GEN_CALL.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCLR_GEN_CALL_CLR() uint32 {
	return volatile.LoadUint32(&o.CLR_GEN_CALL.Reg) & 0x1
}

// I2C.ENABLE: Enable Register
func (o *I2C_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}
func (o *I2C_Type) SetENABLE_ABORT(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetENABLE_ABORT() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetENABLE_TX_CMD_BLOCK(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetENABLE_TX_CMD_BLOCK() uint32 {
	return (volatile.LoadUint32(&o.ENABLE.Reg) & 0x4) >> 2
}

// I2C.STATUS: Status Register
func (o *I2C_Type) SetSTATUS_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSTATUS_ACTIVITY() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *I2C_Type) SetSTATUS_TFNF(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSTATUS_TFNF() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSTATUS_TFE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSTATUS_TFE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSTATUS_RFNE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSTATUS_RFNE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSTATUS_RFF(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSTATUS_RFF() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSTATUS_MST_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSTATUS_MST_ACTIVITY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSTATUS_SLV_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSTATUS_SLV_ACTIVITY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}

// I2C.TXFLR: Transmit FIFO Level Register
func (o *I2C_Type) SetTXFLR_VALUE(value uint32) {
	volatile.StoreUint32(&o.TXFLR.Reg, volatile.LoadUint32(&o.TXFLR.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetTXFLR_VALUE() uint32 {
	return volatile.LoadUint32(&o.TXFLR.Reg) & 0x7
}

// I2C.RXFLR: Receive FIFO Level Register
func (o *I2C_Type) SetRXFLR_VALUE(value uint32) {
	volatile.StoreUint32(&o.RXFLR.Reg, volatile.LoadUint32(&o.RXFLR.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetRXFLR_VALUE() uint32 {
	return volatile.LoadUint32(&o.RXFLR.Reg) & 0x7
}

// I2C.SDA_HOLD: SDA Hold Time Length Register
func (o *I2C_Type) SetSDA_HOLD_TX(value uint32) {
	volatile.StoreUint32(&o.SDA_HOLD.Reg, volatile.LoadUint32(&o.SDA_HOLD.Reg)&^(0xffff)|value)
}
func (o *I2C_Type) GetSDA_HOLD_TX() uint32 {
	return volatile.LoadUint32(&o.SDA_HOLD.Reg) & 0xffff
}
func (o *I2C_Type) SetSDA_HOLD_RX(value uint32) {
	volatile.StoreUint32(&o.SDA_HOLD.Reg, volatile.LoadUint32(&o.SDA_HOLD.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetSDA_HOLD_RX() uint32 {
	return (volatile.LoadUint32(&o.SDA_HOLD.Reg) & 0xff0000) >> 16
}

// I2C.TX_ABRT_SOURCE: Transmit Abort Source Register
func (o *I2C_Type) SetTX_ABRT_SOURCE_ADDR7_NOACK(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_ADDR7_NOACK() uint32 {
	return volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x1
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_ADDR1_10_NOACK(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_ADDR1_10_NOACK() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_ADDR2_10_NOACK(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_ADDR2_10_NOACK() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_TXDATA_NOACK(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_TXDATA_NOACK() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_GCALL_NOACK(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_GCALL_NOACK() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_GCALL_READ(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_GCALL_READ() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_HS_ACKDET(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_HS_ACKDET() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_SBYTE_ACKDET(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_SBYTE_ACKDET() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_HS_NORSTRT(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_HS_NORSTRT() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_SBYTE_NORSTRT(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_SBYTE_NORSTRT() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_RD_10_NORSTRT(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_RD_10_NORSTRT() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_MASTER_DIS(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_MASTER_DIS() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_MST_ARBLOST(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_MST_ARBLOST() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_SLVFLUSH_TXFIFO(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_SLVFLUSH_TXFIFO() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_SLV_ARBLOST(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_SLV_ARBLOST() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_SLVRD_INTX(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_SLVRD_INTX() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTX_ABRT_SOURCE_USER_ABRT(value uint32) {
	volatile.StoreUint32(&o.TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetTX_ABRT_SOURCE_USER_ABRT() uint32 {
	return (volatile.LoadUint32(&o.TX_ABRT_SOURCE.Reg) & 0x10000) >> 16
}

// I2C.DMA_CR: I2C DMA Control Register
func (o *I2C_Type) SetDMA_CR_RDMAE(value uint32) {
	volatile.StoreUint32(&o.DMA_CR.Reg, volatile.LoadUint32(&o.DMA_CR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetDMA_CR_RDMAE() uint32 {
	return volatile.LoadUint32(&o.DMA_CR.Reg) & 0x1
}
func (o *I2C_Type) SetDMA_CR_TDMAE(value uint32) {
	volatile.StoreUint32(&o.DMA_CR.Reg, volatile.LoadUint32(&o.DMA_CR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetDMA_CR_TDMAE() uint32 {
	return (volatile.LoadUint32(&o.DMA_CR.Reg) & 0x2) >> 1
}

// I2C.DMA_TDLR: DMA Transmit Data Level Register
func (o *I2C_Type) SetDMA_TDLR_VALUE(value uint32) {
	volatile.StoreUint32(&o.DMA_TDLR.Reg, volatile.LoadUint32(&o.DMA_TDLR.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetDMA_TDLR_VALUE() uint32 {
	return volatile.LoadUint32(&o.DMA_TDLR.Reg) & 0x7
}

// I2C.DMA_RDLR: DMA Receive Data Level Register
func (o *I2C_Type) SetDMA_RDLR_VALUE(value uint32) {
	volatile.StoreUint32(&o.DMA_RDLR.Reg, volatile.LoadUint32(&o.DMA_RDLR.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetDMA_RDLR_VALUE() uint32 {
	return volatile.LoadUint32(&o.DMA_RDLR.Reg) & 0x7
}

// I2C.SDA_SETUP: SDA Setup Register
func (o *I2C_Type) SetSDA_SETUP_VALUE(value uint32) {
	volatile.StoreUint32(&o.SDA_SETUP.Reg, volatile.LoadUint32(&o.SDA_SETUP.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetSDA_SETUP_VALUE() uint32 {
	return volatile.LoadUint32(&o.SDA_SETUP.Reg) & 0xff
}

// I2C.GENERAL_CALL: ACK General Call Register
func (o *I2C_Type) SetGENERAL_CALL_CALL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.GENERAL_CALL.Reg, volatile.LoadUint32(&o.GENERAL_CALL.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetGENERAL_CALL_CALL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.GENERAL_CALL.Reg) & 0x1
}

// I2C.ENABLE_STATUS: Enable Status Register
func (o *I2C_Type) SetENABLE_STATUS_IC_ENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE_STATUS.Reg, volatile.LoadUint32(&o.ENABLE_STATUS.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetENABLE_STATUS_IC_ENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE_STATUS.Reg) & 0x1
}
func (o *I2C_Type) SetENABLE_STATUS_SLV_DIS_BUSY(value uint32) {
	volatile.StoreUint32(&o.ENABLE_STATUS.Reg, volatile.LoadUint32(&o.ENABLE_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetENABLE_STATUS_SLV_DIS_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ENABLE_STATUS.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetENABLE_STATUS_SLV_RX_DATA_LOST(value uint32) {
	volatile.StoreUint32(&o.ENABLE_STATUS.Reg, volatile.LoadUint32(&o.ENABLE_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetENABLE_STATUS_SLV_RX_DATA_LOST() uint32 {
	return (volatile.LoadUint32(&o.ENABLE_STATUS.Reg) & 0x4) >> 2
}

// I2C.FS_SPKLEN: SS, FS or FM+ spike suppression limit
func (o *I2C_Type) SetFS_SPKLEN_VALUE(value uint32) {
	volatile.StoreUint32(&o.FS_SPKLEN.Reg, volatile.LoadUint32(&o.FS_SPKLEN.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetFS_SPKLEN_VALUE() uint32 {
	return volatile.LoadUint32(&o.FS_SPKLEN.Reg) & 0xff
}

// I2C.COMP_PARAM_1: Component Parameter Register 1
func (o *I2C_Type) SetCOMP_PARAM_1_APB_DATA_WIDTH(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x3)|value)
}
func (o *I2C_Type) GetCOMP_PARAM_1_APB_DATA_WIDTH() uint32 {
	return volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x3
}
func (o *I2C_Type) SetCOMP_PARAM_1_MAX_SPEED_MODE(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0xc)|value<<2)
}
func (o *I2C_Type) GetCOMP_PARAM_1_MAX_SPEED_MODE() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0xc) >> 2
}
func (o *I2C_Type) SetCOMP_PARAM_1_HC_COUNT_VALUES(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCOMP_PARAM_1_HC_COUNT_VALUES() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCOMP_PARAM_1_INTR_IO(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCOMP_PARAM_1_INTR_IO() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCOMP_PARAM_1_HAS_DMA(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCOMP_PARAM_1_HAS_DMA() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCOMP_PARAM_1_ENCODED_PARAMS(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCOMP_PARAM_1_ENCODED_PARAMS() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCOMP_PARAM_1_RX_BUFFER_DEPTH(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetCOMP_PARAM_1_RX_BUFFER_DEPTH() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetCOMP_PARAM_1_TX_BUFFER_DEPTH(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCOMP_PARAM_1_TX_BUFFER_DEPTH() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0xff0000) >> 16
}

// I2C.COMP_VERSION: Component Version Register
func (o *I2C_Type) SetCOMP_VERSION(value uint32) {
	volatile.StoreUint32(&o.COMP_VERSION.Reg, value)
}
func (o *I2C_Type) GetCOMP_VERSION() uint32 {
	return volatile.LoadUint32(&o.COMP_VERSION.Reg)
}

// I2C.COMP_TYPE: Component Type Register
func (o *I2C_Type) SetCOMP_TYPE(value uint32) {
	volatile.StoreUint32(&o.COMP_TYPE.Reg, value)
}
func (o *I2C_Type) GetCOMP_TYPE() uint32 {
	return volatile.LoadUint32(&o.COMP_TYPE.Reg)
}

// Field Programmable IO Array
type FPIOA_Type struct {
	IO      [48]volatile.Register32 // 0x0
	TIE_EN  [8]volatile.Register32  // 0xC0
	TIE_VAL [8]volatile.Register32  // 0xE0
}

// FPIOA.IO: FPIOA GPIO multiplexer io array
func (o *FPIOA_Type) SetIO_CH_SEL(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0xff)|value)
}
func (o *FPIOA_Type) GetIO_CH_SEL(idx int) uint32 {
	return volatile.LoadUint32(&o.IO[idx].Reg) & 0xff
}
func (o *FPIOA_Type) SetIO_DS(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0xf00)|value<<8)
}
func (o *FPIOA_Type) GetIO_DS(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0xf00) >> 8
}
func (o *FPIOA_Type) SetIO_OE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x1000)|value<<12)
}
func (o *FPIOA_Type) GetIO_OE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x1000) >> 12
}
func (o *FPIOA_Type) SetIO_OE_INV(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x2000)|value<<13)
}
func (o *FPIOA_Type) GetIO_OE_INV(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x2000) >> 13
}
func (o *FPIOA_Type) SetIO_DO_SEL(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x4000)|value<<14)
}
func (o *FPIOA_Type) GetIO_DO_SEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x4000) >> 14
}
func (o *FPIOA_Type) SetIO_DO_INV(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x8000)|value<<15)
}
func (o *FPIOA_Type) GetIO_DO_INV(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x8000) >> 15
}
func (o *FPIOA_Type) SetIO_PU(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x10000)|value<<16)
}
func (o *FPIOA_Type) GetIO_PU(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x10000) >> 16
}
func (o *FPIOA_Type) SetIO_PD(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x20000)|value<<17)
}
func (o *FPIOA_Type) GetIO_PD(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x20000) >> 17
}
func (o *FPIOA_Type) SetIO_SL(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x80000)|value<<19)
}
func (o *FPIOA_Type) GetIO_SL(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x80000) >> 19
}
func (o *FPIOA_Type) SetIO_IE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x100000)|value<<20)
}
func (o *FPIOA_Type) GetIO_IE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x100000) >> 20
}
func (o *FPIOA_Type) SetIO_IE_INV(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x200000)|value<<21)
}
func (o *FPIOA_Type) GetIO_IE_INV(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x200000) >> 21
}
func (o *FPIOA_Type) SetIO_DI_INV(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x400000)|value<<22)
}
func (o *FPIOA_Type) GetIO_DI_INV(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x400000) >> 22
}
func (o *FPIOA_Type) SetIO_ST(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x800000)|value<<23)
}
func (o *FPIOA_Type) GetIO_ST(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x800000) >> 23
}
func (o *FPIOA_Type) SetIO_PAD_DI(idx int, value uint32) {
	volatile.StoreUint32(&o.IO[idx].Reg, volatile.LoadUint32(&o.IO[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *FPIOA_Type) GetIO_PAD_DI(idx int) uint32 {
	return (volatile.LoadUint32(&o.IO[idx].Reg) & 0x80000000) >> 31
}

// SHA256 Accelerator
type SHA256_Type struct {
	RESULT         [8]volatile.Register32 // 0x0
	DATA_IN        volatile.Register32    // 0x20
	_              [4]byte
	NUM_REG        volatile.Register32 // 0x28
	FUNCTION_REG_0 volatile.Register32 // 0x2C
	_              [4]byte
	FUNCTION_REG_1 volatile.Register32 // 0x34
}

// SHA256.NUM_REG: Counters register
func (o *SHA256_Type) SetNUM_REG_DATA_CNT(value uint32) {
	volatile.StoreUint32(&o.NUM_REG.Reg, volatile.LoadUint32(&o.NUM_REG.Reg)&^(0xffff)|value)
}
func (o *SHA256_Type) GetNUM_REG_DATA_CNT() uint32 {
	return volatile.LoadUint32(&o.NUM_REG.Reg) & 0xffff
}
func (o *SHA256_Type) SetNUM_REG_DATA_NUM(value uint32) {
	volatile.StoreUint32(&o.NUM_REG.Reg, volatile.LoadUint32(&o.NUM_REG.Reg)&^(0xffff0000)|value<<16)
}
func (o *SHA256_Type) GetNUM_REG_DATA_NUM() uint32 {
	return (volatile.LoadUint32(&o.NUM_REG.Reg) & 0xffff0000) >> 16
}

// SHA256.FUNCTION_REG_0: Function configuration register 0
func (o *SHA256_Type) SetFUNCTION_REG_0_EN(value uint32) {
	volatile.StoreUint32(&o.FUNCTION_REG_0.Reg, volatile.LoadUint32(&o.FUNCTION_REG_0.Reg)&^(0x1)|value)
}
func (o *SHA256_Type) GetFUNCTION_REG_0_EN() uint32 {
	return volatile.LoadUint32(&o.FUNCTION_REG_0.Reg) & 0x1
}
func (o *SHA256_Type) SetFUNCTION_REG_0_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.FUNCTION_REG_0.Reg, volatile.LoadUint32(&o.FUNCTION_REG_0.Reg)&^(0x100)|value<<8)
}
func (o *SHA256_Type) GetFUNCTION_REG_0_OVERFLOW() uint32 {
	return (volatile.LoadUint32(&o.FUNCTION_REG_0.Reg) & 0x100) >> 8
}
func (o *SHA256_Type) SetFUNCTION_REG_0_ENDIAN(value uint32) {
	volatile.StoreUint32(&o.FUNCTION_REG_0.Reg, volatile.LoadUint32(&o.FUNCTION_REG_0.Reg)&^(0x10000)|value<<16)
}
func (o *SHA256_Type) GetFUNCTION_REG_0_ENDIAN() uint32 {
	return (volatile.LoadUint32(&o.FUNCTION_REG_0.Reg) & 0x10000) >> 16
}

// SHA256.FUNCTION_REG_1: Function configuration register 1
func (o *SHA256_Type) SetFUNCTION_REG_1_DMA_EN(value uint32) {
	volatile.StoreUint32(&o.FUNCTION_REG_1.Reg, volatile.LoadUint32(&o.FUNCTION_REG_1.Reg)&^(0x1)|value)
}
func (o *SHA256_Type) GetFUNCTION_REG_1_DMA_EN() uint32 {
	return volatile.LoadUint32(&o.FUNCTION_REG_1.Reg) & 0x1
}
func (o *SHA256_Type) SetFUNCTION_REG_1_FIFO_IN_FULL(value uint32) {
	volatile.StoreUint32(&o.FUNCTION_REG_1.Reg, volatile.LoadUint32(&o.FUNCTION_REG_1.Reg)&^(0x100)|value<<8)
}
func (o *SHA256_Type) GetFUNCTION_REG_1_FIFO_IN_FULL() uint32 {
	return (volatile.LoadUint32(&o.FUNCTION_REG_1.Reg) & 0x100) >> 8
}

// Timer 0
type TIMER_Type struct {
	CHANNEL       [4]TIMER_CHANNEL_Type // 0x0
	_             [80]byte
	INTR_STAT     volatile.Register32 // 0xA0
	EOI           volatile.Register32 // 0xA4
	RAW_INTR_STAT volatile.Register32 // 0xA8
	COMP_VERSION  volatile.Register32 // 0xAC
	LOAD_COUNT20  volatile.Register32 // 0xB0
	LOAD_COUNT21  volatile.Register32 // 0xB4
	LOAD_COUNT22  volatile.Register32 // 0xB8
	LOAD_COUNT23  volatile.Register32 // 0xBC
}

// Channel cluster: load_count, current_value, control, eoi and intr_stat registers
type TIMER_CHANNEL_Type struct {
	LOAD_COUNT    volatile.Register32 // 0x0
	CURRENT_VALUE volatile.Register32 // 0x4
	CONTROL       volatile.Register32 // 0x8
	EOI           volatile.Register32 // 0xC
	INTR_STAT     volatile.Register32 // 0x10
}

// TIMER_CHANNEL.CONTROL: Control Register
func (o *TIMER_CHANNEL_Type) SetCONTROL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x1)|value)
}
func (o *TIMER_CHANNEL_Type) GetCONTROL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CONTROL.Reg) & 0x1
}
func (o *TIMER_CHANNEL_Type) SetCONTROL_MODE(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x2)|value<<1)
}
func (o *TIMER_CHANNEL_Type) GetCONTROL_MODE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x2) >> 1
}
func (o *TIMER_CHANNEL_Type) SetCONTROL_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x4)|value<<2)
}
func (o *TIMER_CHANNEL_Type) GetCONTROL_INTERRUPT() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x4) >> 2
}
func (o *TIMER_CHANNEL_Type) SetCONTROL_PWM_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x8)|value<<3)
}
func (o *TIMER_CHANNEL_Type) GetCONTROL_PWM_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x8) >> 3
}

// Watchdog Timer 0
type WDT_Type struct {
	CR           volatile.Register32 // 0x0
	TORR         volatile.Register32 // 0x4
	CCVR         volatile.Register32 // 0x8
	CRR          volatile.Register32 // 0xC
	STAT         volatile.Register32 // 0x10
	EOI          volatile.Register32 // 0x14
	_            [4]byte
	PROT_LEVEL   volatile.Register32 // 0x1C
	_            [196]byte
	COMP_PARAM_5 volatile.Register32 // 0xE4
	COMP_PARAM_4 volatile.Register32 // 0xE8
	COMP_PARAM_3 volatile.Register32 // 0xEC
	COMP_PARAM_2 volatile.Register32 // 0xF0
	COMP_PARAM_1 volatile.Register32 // 0xF4
	COMP_VERSION volatile.Register32 // 0xF8
	COMP_TYPE    volatile.Register32 // 0xFC
}

// WDT.CR: Control Register
func (o *WDT_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *WDT_Type) SetCR_RMOD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetCR_RMOD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetCR_RPL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1c)|value<<2)
}
func (o *WDT_Type) GetCR_RPL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1c) >> 2
}

// WDT.TORR: Timeout Range Register
func (o *WDT_Type) SetTORR_TOP0(value uint32) {
	volatile.StoreUint32(&o.TORR.Reg, volatile.LoadUint32(&o.TORR.Reg)&^(0xf)|value)
}
func (o *WDT_Type) GetTORR_TOP0() uint32 {
	return volatile.LoadUint32(&o.TORR.Reg) & 0xf
}
func (o *WDT_Type) SetTORR_TOP1(value uint32) {
	volatile.StoreUint32(&o.TORR.Reg, volatile.LoadUint32(&o.TORR.Reg)&^(0xf0)|value<<4)
}
func (o *WDT_Type) GetTORR_TOP1() uint32 {
	return (volatile.LoadUint32(&o.TORR.Reg) & 0xf0) >> 4
}

// WDT.STAT: Interrupt Status Register
func (o *WDT_Type) SetSTAT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetSTAT() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}

// WDT.EOI: Interrupt Clear Register
func (o *WDT_Type) SetEOI(value uint32) {
	volatile.StoreUint32(&o.EOI.Reg, volatile.LoadUint32(&o.EOI.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetEOI() uint32 {
	return volatile.LoadUint32(&o.EOI.Reg) & 0x1
}

// WDT.PROT_LEVEL: Protection level Register
func (o *WDT_Type) SetPROT_LEVEL(value uint32) {
	volatile.StoreUint32(&o.PROT_LEVEL.Reg, volatile.LoadUint32(&o.PROT_LEVEL.Reg)&^(0x7)|value)
}
func (o *WDT_Type) GetPROT_LEVEL() uint32 {
	return volatile.LoadUint32(&o.PROT_LEVEL.Reg) & 0x7
}

// WDT.COMP_PARAM_5: Component Parameters Register 5
func (o *WDT_Type) SetCOMP_PARAM_5(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_5.Reg, value)
}
func (o *WDT_Type) GetCOMP_PARAM_5() uint32 {
	return volatile.LoadUint32(&o.COMP_PARAM_5.Reg)
}

// WDT.COMP_PARAM_4: Component Parameters Register 4
func (o *WDT_Type) SetCOMP_PARAM_4(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_4.Reg, value)
}
func (o *WDT_Type) GetCOMP_PARAM_4() uint32 {
	return volatile.LoadUint32(&o.COMP_PARAM_4.Reg)
}

// WDT.COMP_PARAM_3: Component Parameters Register 3
func (o *WDT_Type) SetCOMP_PARAM_3(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_3.Reg, value)
}
func (o *WDT_Type) GetCOMP_PARAM_3() uint32 {
	return volatile.LoadUint32(&o.COMP_PARAM_3.Reg)
}

// WDT.COMP_PARAM_2: Component Parameters Register 2
func (o *WDT_Type) SetCOMP_PARAM_2(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_2.Reg, value)
}
func (o *WDT_Type) GetCOMP_PARAM_2() uint32 {
	return volatile.LoadUint32(&o.COMP_PARAM_2.Reg)
}

// WDT.COMP_PARAM_1: Component Parameters Register 1
func (o *WDT_Type) SetCOMP_PARAM_1_ALWAYS_EN(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetCOMP_PARAM_1_ALWAYS_EN() uint32 {
	return volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x1
}
func (o *WDT_Type) SetCOMP_PARAM_1_DFLT_RMOD(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetCOMP_PARAM_1_DFLT_RMOD() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetCOMP_PARAM_1_DUAL_TOP(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetCOMP_PARAM_1_DUAL_TOP() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetCOMP_PARAM_1_HC_RMOD(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetCOMP_PARAM_1_HC_RMOD() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetCOMP_PARAM_1_HC_RPL(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetCOMP_PARAM_1_HC_RPL() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x10) >> 4
}
func (o *WDT_Type) SetCOMP_PARAM_1_HC_TOP(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x20)|value<<5)
}
func (o *WDT_Type) GetCOMP_PARAM_1_HC_TOP() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x20) >> 5
}
func (o *WDT_Type) SetCOMP_PARAM_1_USE_FIX_TOP(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetCOMP_PARAM_1_USE_FIX_TOP() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x40) >> 6
}
func (o *WDT_Type) SetCOMP_PARAM_1_PAUSE(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetCOMP_PARAM_1_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x80) >> 7
}
func (o *WDT_Type) SetCOMP_PARAM_1_APB_DATA_WIDTH(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x300)|value<<8)
}
func (o *WDT_Type) GetCOMP_PARAM_1_APB_DATA_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x300) >> 8
}
func (o *WDT_Type) SetCOMP_PARAM_1_DFLT_RPL(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x1c00)|value<<10)
}
func (o *WDT_Type) GetCOMP_PARAM_1_DFLT_RPL() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x1c00) >> 10
}
func (o *WDT_Type) SetCOMP_PARAM_1_DFLT_TOP(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0xf0000)|value<<16)
}
func (o *WDT_Type) GetCOMP_PARAM_1_DFLT_TOP() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0xf0000) >> 16
}
func (o *WDT_Type) SetCOMP_PARAM_1_DFLT_TOP_INIT(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0xf00000)|value<<20)
}
func (o *WDT_Type) GetCOMP_PARAM_1_DFLT_TOP_INIT() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0xf00000) >> 20
}
func (o *WDT_Type) SetCOMP_PARAM_1_CNT_WIDTH(value uint32) {
	volatile.StoreUint32(&o.COMP_PARAM_1.Reg, volatile.LoadUint32(&o.COMP_PARAM_1.Reg)&^(0x1f000000)|value<<24)
}
func (o *WDT_Type) GetCOMP_PARAM_1_CNT_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.COMP_PARAM_1.Reg) & 0x1f000000) >> 24
}

// One-Time Programmable Memory Controller
type OTP_Type struct {
	DUMMY volatile.Register32 // 0x0
}

// Digital Video Port
type DVP_Type struct {
	DVP_CFG  volatile.Register32 // 0x0
	R_ADDR   volatile.Register32 // 0x4
	G_ADDR   volatile.Register32 // 0x8
	B_ADDR   volatile.Register32 // 0xC
	CMOS_CFG volatile.Register32 // 0x10
	SCCB_CFG volatile.Register32 // 0x14
	SCCB_CTL volatile.Register32 // 0x18
	AXI      volatile.Register32 // 0x1C
	STS      volatile.Register32 // 0x20
	REVERSE  volatile.Register32 // 0x24
	RGB_ADDR volatile.Register32 // 0x28
}

// DVP.DVP_CFG: Config Register
func (o *DVP_Type) SetDVP_CFG_START_INT_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DVP_CFG.Reg, volatile.LoadUint32(&o.DVP_CFG.Reg)&^(0x1)|value)
}
func (o *DVP_Type) GetDVP_CFG_START_INT_ENABLE() uint32 {
	return volatile.LoadUint32(&o.DVP_CFG.Reg) & 0x1
}
func (o *DVP_Type) SetDVP_CFG_FINISH_INT_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DVP_CFG.Reg, volatile.LoadUint32(&o.DVP_CFG.Reg)&^(0x2)|value<<1)
}
func (o *DVP_Type) GetDVP_CFG_FINISH_INT_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.DVP_CFG.Reg) & 0x2) >> 1
}
func (o *DVP_Type) SetDVP_CFG_AI_OUTPUT_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DVP_CFG.Reg, volatile.LoadUint32(&o.DVP_CFG.Reg)&^(0x4)|value<<2)
}
func (o *DVP_Type) GetDVP_CFG_AI_OUTPUT_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.DVP_CFG.Reg) & 0x4) >> 2
}
func (o *DVP_Type) SetDVP_CFG_DISPLAY_OUTPUT_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DVP_CFG.Reg, volatile.LoadUint32(&o.DVP_CFG.Reg)&^(0x8)|value<<3)
}
func (o *DVP_Type) GetDVP_CFG_DISPLAY_OUTPUT_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.DVP_CFG.Reg) & 0x8) >> 3
}
func (o *DVP_Type) SetDVP_CFG_AUTO_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DVP_CFG.Reg, volatile.LoadUint32(&o.DVP_CFG.Reg)&^(0x10)|value<<4)
}
func (o *DVP_Type) GetDVP_CFG_AUTO_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.DVP_CFG.Reg) & 0x10) >> 4
}
func (o *DVP_Type) SetDVP_CFG_BURST_SIZE_4BEATS(value uint32) {
	volatile.StoreUint32(&o.DVP_CFG.Reg, volatile.LoadUint32(&o.DVP_CFG.Reg)&^(0x100)|value<<8)
}
func (o *DVP_Type) GetDVP_CFG_BURST_SIZE_4BEATS() uint32 {
	return (volatile.LoadUint32(&o.DVP_CFG.Reg) & 0x100) >> 8
}
func (o *DVP_Type) SetDVP_CFG_FORMAT(value uint32) {
	volatile.StoreUint32(&o.DVP_CFG.Reg, volatile.LoadUint32(&o.DVP_CFG.Reg)&^(0x600)|value<<9)
}
func (o *DVP_Type) GetDVP_CFG_FORMAT() uint32 {
	return (volatile.LoadUint32(&o.DVP_CFG.Reg) & 0x600) >> 9
}
func (o *DVP_Type) SetDVP_CFG_HREF_BURST_NUM(value uint32) {
	volatile.StoreUint32(&o.DVP_CFG.Reg, volatile.LoadUint32(&o.DVP_CFG.Reg)&^(0xff000)|value<<12)
}
func (o *DVP_Type) GetDVP_CFG_HREF_BURST_NUM() uint32 {
	return (volatile.LoadUint32(&o.DVP_CFG.Reg) & 0xff000) >> 12
}
func (o *DVP_Type) SetDVP_CFG_LINE_NUM(value uint32) {
	volatile.StoreUint32(&o.DVP_CFG.Reg, volatile.LoadUint32(&o.DVP_CFG.Reg)&^(0x3ff00000)|value<<20)
}
func (o *DVP_Type) GetDVP_CFG_LINE_NUM() uint32 {
	return (volatile.LoadUint32(&o.DVP_CFG.Reg) & 0x3ff00000) >> 20
}

// DVP.CMOS_CFG: CMOS Config Register
func (o *DVP_Type) SetCMOS_CFG_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.CMOS_CFG.Reg, volatile.LoadUint32(&o.CMOS_CFG.Reg)&^(0xff)|value)
}
func (o *DVP_Type) GetCMOS_CFG_CLK_DIV() uint32 {
	return volatile.LoadUint32(&o.CMOS_CFG.Reg) & 0xff
}
func (o *DVP_Type) SetCMOS_CFG_CLK_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CMOS_CFG.Reg, volatile.LoadUint32(&o.CMOS_CFG.Reg)&^(0x100)|value<<8)
}
func (o *DVP_Type) GetCMOS_CFG_CLK_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CMOS_CFG.Reg) & 0x100) >> 8
}
func (o *DVP_Type) SetCMOS_CFG_RESET(value uint32) {
	volatile.StoreUint32(&o.CMOS_CFG.Reg, volatile.LoadUint32(&o.CMOS_CFG.Reg)&^(0x10000)|value<<16)
}
func (o *DVP_Type) GetCMOS_CFG_RESET() uint32 {
	return (volatile.LoadUint32(&o.CMOS_CFG.Reg) & 0x10000) >> 16
}
func (o *DVP_Type) SetCMOS_CFG_POWER_DOWN(value uint32) {
	volatile.StoreUint32(&o.CMOS_CFG.Reg, volatile.LoadUint32(&o.CMOS_CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *DVP_Type) GetCMOS_CFG_POWER_DOWN() uint32 {
	return (volatile.LoadUint32(&o.CMOS_CFG.Reg) & 0x1000000) >> 24
}

// DVP.SCCB_CFG: SCCB Config Register
func (o *DVP_Type) SetSCCB_CFG_BYTE_NUM(value uint32) {
	volatile.StoreUint32(&o.SCCB_CFG.Reg, volatile.LoadUint32(&o.SCCB_CFG.Reg)&^(0x3)|value)
}
func (o *DVP_Type) GetSCCB_CFG_BYTE_NUM() uint32 {
	return volatile.LoadUint32(&o.SCCB_CFG.Reg) & 0x3
}
func (o *DVP_Type) SetSCCB_CFG_SCL_LCNT(value uint32) {
	volatile.StoreUint32(&o.SCCB_CFG.Reg, volatile.LoadUint32(&o.SCCB_CFG.Reg)&^(0xff00)|value<<8)
}
func (o *DVP_Type) GetSCCB_CFG_SCL_LCNT() uint32 {
	return (volatile.LoadUint32(&o.SCCB_CFG.Reg) & 0xff00) >> 8
}
func (o *DVP_Type) SetSCCB_CFG_SCL_HCNT(value uint32) {
	volatile.StoreUint32(&o.SCCB_CFG.Reg, volatile.LoadUint32(&o.SCCB_CFG.Reg)&^(0xff0000)|value<<16)
}
func (o *DVP_Type) GetSCCB_CFG_SCL_HCNT() uint32 {
	return (volatile.LoadUint32(&o.SCCB_CFG.Reg) & 0xff0000) >> 16
}
func (o *DVP_Type) SetSCCB_CFG_RDATA(value uint32) {
	volatile.StoreUint32(&o.SCCB_CFG.Reg, volatile.LoadUint32(&o.SCCB_CFG.Reg)&^(0xff000000)|value<<24)
}
func (o *DVP_Type) GetSCCB_CFG_RDATA() uint32 {
	return (volatile.LoadUint32(&o.SCCB_CFG.Reg) & 0xff000000) >> 24
}

// DVP.SCCB_CTL: SCCB Control Register
func (o *DVP_Type) SetSCCB_CTL_DEVICE_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.SCCB_CTL.Reg, volatile.LoadUint32(&o.SCCB_CTL.Reg)&^(0xff)|value)
}
func (o *DVP_Type) GetSCCB_CTL_DEVICE_ADDRESS() uint32 {
	return volatile.LoadUint32(&o.SCCB_CTL.Reg) & 0xff
}
func (o *DVP_Type) SetSCCB_CTL_REG_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.SCCB_CTL.Reg, volatile.LoadUint32(&o.SCCB_CTL.Reg)&^(0xff00)|value<<8)
}
func (o *DVP_Type) GetSCCB_CTL_REG_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.SCCB_CTL.Reg) & 0xff00) >> 8
}
func (o *DVP_Type) SetSCCB_CTL_WDATA_BYTE0(value uint32) {
	volatile.StoreUint32(&o.SCCB_CTL.Reg, volatile.LoadUint32(&o.SCCB_CTL.Reg)&^(0xff0000)|value<<16)
}
func (o *DVP_Type) GetSCCB_CTL_WDATA_BYTE0() uint32 {
	return (volatile.LoadUint32(&o.SCCB_CTL.Reg) & 0xff0000) >> 16
}
func (o *DVP_Type) SetSCCB_CTL_WDATA_BYTE1(value uint32) {
	volatile.StoreUint32(&o.SCCB_CTL.Reg, volatile.LoadUint32(&o.SCCB_CTL.Reg)&^(0xff000000)|value<<24)
}
func (o *DVP_Type) GetSCCB_CTL_WDATA_BYTE1() uint32 {
	return (volatile.LoadUint32(&o.SCCB_CTL.Reg) & 0xff000000) >> 24
}

// DVP.AXI: AXI Register
func (o *DVP_Type) SetAXI_GM_MLEN(value uint32) {
	volatile.StoreUint32(&o.AXI.Reg, volatile.LoadUint32(&o.AXI.Reg)&^(0xff)|value)
}
func (o *DVP_Type) GetAXI_GM_MLEN() uint32 {
	return volatile.LoadUint32(&o.AXI.Reg) & 0xff
}

// DVP.STS: STS Register
func (o *DVP_Type) SetSTS_FRAME_START(value uint32) {
	volatile.StoreUint32(&o.STS.Reg, volatile.LoadUint32(&o.STS.Reg)&^(0x1)|value)
}
func (o *DVP_Type) GetSTS_FRAME_START() uint32 {
	return volatile.LoadUint32(&o.STS.Reg) & 0x1
}
func (o *DVP_Type) SetSTS_FRAME_START_WE(value uint32) {
	volatile.StoreUint32(&o.STS.Reg, volatile.LoadUint32(&o.STS.Reg)&^(0x2)|value<<1)
}
func (o *DVP_Type) GetSTS_FRAME_START_WE() uint32 {
	return (volatile.LoadUint32(&o.STS.Reg) & 0x2) >> 1
}
func (o *DVP_Type) SetSTS_FRAME_FINISH(value uint32) {
	volatile.StoreUint32(&o.STS.Reg, volatile.LoadUint32(&o.STS.Reg)&^(0x100)|value<<8)
}
func (o *DVP_Type) GetSTS_FRAME_FINISH() uint32 {
	return (volatile.LoadUint32(&o.STS.Reg) & 0x100) >> 8
}
func (o *DVP_Type) SetSTS_FRAME_FINISH_WE(value uint32) {
	volatile.StoreUint32(&o.STS.Reg, volatile.LoadUint32(&o.STS.Reg)&^(0x200)|value<<9)
}
func (o *DVP_Type) GetSTS_FRAME_FINISH_WE() uint32 {
	return (volatile.LoadUint32(&o.STS.Reg) & 0x200) >> 9
}
func (o *DVP_Type) SetSTS_DVP_EN(value uint32) {
	volatile.StoreUint32(&o.STS.Reg, volatile.LoadUint32(&o.STS.Reg)&^(0x10000)|value<<16)
}
func (o *DVP_Type) GetSTS_DVP_EN() uint32 {
	return (volatile.LoadUint32(&o.STS.Reg) & 0x10000) >> 16
}
func (o *DVP_Type) SetSTS_DVP_EN_WE(value uint32) {
	volatile.StoreUint32(&o.STS.Reg, volatile.LoadUint32(&o.STS.Reg)&^(0x20000)|value<<17)
}
func (o *DVP_Type) GetSTS_DVP_EN_WE() uint32 {
	return (volatile.LoadUint32(&o.STS.Reg) & 0x20000) >> 17
}
func (o *DVP_Type) SetSTS_SCCB_EN(value uint32) {
	volatile.StoreUint32(&o.STS.Reg, volatile.LoadUint32(&o.STS.Reg)&^(0x1000000)|value<<24)
}
func (o *DVP_Type) GetSTS_SCCB_EN() uint32 {
	return (volatile.LoadUint32(&o.STS.Reg) & 0x1000000) >> 24
}
func (o *DVP_Type) SetSTS_SCCB_EN_WE(value uint32) {
	volatile.StoreUint32(&o.STS.Reg, volatile.LoadUint32(&o.STS.Reg)&^(0x2000000)|value<<25)
}
func (o *DVP_Type) GetSTS_SCCB_EN_WE() uint32 {
	return (volatile.LoadUint32(&o.STS.Reg) & 0x2000000) >> 25
}

// System Controller
type SYSCTL_Type struct {
	GIT_ID       volatile.Register32 // 0x0
	CLK_FREQ     volatile.Register32 // 0x4
	PLL0         volatile.Register32 // 0x8
	PLL1         volatile.Register32 // 0xC
	PLL2         volatile.Register32 // 0x10
	_            [4]byte
	PLL_LOCK     volatile.Register32 // 0x18
	ROM_ERROR    volatile.Register32 // 0x1C
	CLK_SEL0     volatile.Register32 // 0x20
	CLK_SEL1     volatile.Register32 // 0x24
	CLK_EN_CENT  volatile.Register32 // 0x28
	CLK_EN_PERI  volatile.Register32 // 0x2C
	SOFT_RESET   volatile.Register32 // 0x30
	PERI_RESET   volatile.Register32 // 0x34
	CLK_TH0      volatile.Register32 // 0x38
	CLK_TH1      volatile.Register32 // 0x3C
	CLK_TH2      volatile.Register32 // 0x40
	CLK_TH3      volatile.Register32 // 0x44
	CLK_TH4      volatile.Register32 // 0x48
	CLK_TH5      volatile.Register32 // 0x4C
	CLK_TH6      volatile.Register32 // 0x50
	MISC         volatile.Register32 // 0x54
	PERI         volatile.Register32 // 0x58
	SPI_SLEEP    volatile.Register32 // 0x5C
	RESET_STATUS volatile.Register32 // 0x60
	DMA_SEL0     volatile.Register32 // 0x64
	DMA_SEL1     volatile.Register32 // 0x68
	POWER_SEL    volatile.Register32 // 0x6C
}

// SYSCTL.PLL0: PLL0 controller
func (o *SYSCTL_Type) SetPLL0_CLKR(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0xf)|value)
}
func (o *SYSCTL_Type) GetPLL0_CLKR() uint32 {
	return volatile.LoadUint32(&o.PLL0.Reg) & 0xf
}
func (o *SYSCTL_Type) SetPLL0_CLKF(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0x3f0)|value<<4)
}
func (o *SYSCTL_Type) GetPLL0_CLKF() uint32 {
	return (volatile.LoadUint32(&o.PLL0.Reg) & 0x3f0) >> 4
}
func (o *SYSCTL_Type) SetPLL0_CLKOD(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0x3c00)|value<<10)
}
func (o *SYSCTL_Type) GetPLL0_CLKOD() uint32 {
	return (volatile.LoadUint32(&o.PLL0.Reg) & 0x3c00) >> 10
}
func (o *SYSCTL_Type) SetPLL0_BWADJ(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0xfc000)|value<<14)
}
func (o *SYSCTL_Type) GetPLL0_BWADJ() uint32 {
	return (volatile.LoadUint32(&o.PLL0.Reg) & 0xfc000) >> 14
}
func (o *SYSCTL_Type) SetPLL0_RESET(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCTL_Type) GetPLL0_RESET() uint32 {
	return (volatile.LoadUint32(&o.PLL0.Reg) & 0x100000) >> 20
}
func (o *SYSCTL_Type) SetPLL0_PWRD(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCTL_Type) GetPLL0_PWRD() uint32 {
	return (volatile.LoadUint32(&o.PLL0.Reg) & 0x200000) >> 21
}
func (o *SYSCTL_Type) SetPLL0_INTFB(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCTL_Type) GetPLL0_INTFB() uint32 {
	return (volatile.LoadUint32(&o.PLL0.Reg) & 0x400000) >> 22
}
func (o *SYSCTL_Type) SetPLL0_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCTL_Type) GetPLL0_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PLL0.Reg) & 0x800000) >> 23
}
func (o *SYSCTL_Type) SetPLL0_TEST(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCTL_Type) GetPLL0_TEST() uint32 {
	return (volatile.LoadUint32(&o.PLL0.Reg) & 0x1000000) >> 24
}
func (o *SYSCTL_Type) SetPLL0_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCTL_Type) GetPLL0_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.PLL0.Reg) & 0x2000000) >> 25
}
func (o *SYSCTL_Type) SetPLL0_TEST_EN(value uint32) {
	volatile.StoreUint32(&o.PLL0.Reg, volatile.LoadUint32(&o.PLL0.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCTL_Type) GetPLL0_TEST_EN() uint32 {
	return (volatile.LoadUint32(&o.PLL0.Reg) & 0x4000000) >> 26
}

// SYSCTL.PLL1: PLL1 controller
func (o *SYSCTL_Type) SetPLL1_CLKR(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0xf)|value)
}
func (o *SYSCTL_Type) GetPLL1_CLKR() uint32 {
	return volatile.LoadUint32(&o.PLL1.Reg) & 0xf
}
func (o *SYSCTL_Type) SetPLL1_CLKF(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0x3f0)|value<<4)
}
func (o *SYSCTL_Type) GetPLL1_CLKF() uint32 {
	return (volatile.LoadUint32(&o.PLL1.Reg) & 0x3f0) >> 4
}
func (o *SYSCTL_Type) SetPLL1_CLKOD(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0x3c00)|value<<10)
}
func (o *SYSCTL_Type) GetPLL1_CLKOD() uint32 {
	return (volatile.LoadUint32(&o.PLL1.Reg) & 0x3c00) >> 10
}
func (o *SYSCTL_Type) SetPLL1_BWADJ(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0xfc000)|value<<14)
}
func (o *SYSCTL_Type) GetPLL1_BWADJ() uint32 {
	return (volatile.LoadUint32(&o.PLL1.Reg) & 0xfc000) >> 14
}
func (o *SYSCTL_Type) SetPLL1_RESET(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCTL_Type) GetPLL1_RESET() uint32 {
	return (volatile.LoadUint32(&o.PLL1.Reg) & 0x100000) >> 20
}
func (o *SYSCTL_Type) SetPLL1_PWRD(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCTL_Type) GetPLL1_PWRD() uint32 {
	return (volatile.LoadUint32(&o.PLL1.Reg) & 0x200000) >> 21
}
func (o *SYSCTL_Type) SetPLL1_INTFB(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCTL_Type) GetPLL1_INTFB() uint32 {
	return (volatile.LoadUint32(&o.PLL1.Reg) & 0x400000) >> 22
}
func (o *SYSCTL_Type) SetPLL1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCTL_Type) GetPLL1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PLL1.Reg) & 0x800000) >> 23
}
func (o *SYSCTL_Type) SetPLL1_TEST(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCTL_Type) GetPLL1_TEST() uint32 {
	return (volatile.LoadUint32(&o.PLL1.Reg) & 0x1000000) >> 24
}
func (o *SYSCTL_Type) SetPLL1_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCTL_Type) GetPLL1_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.PLL1.Reg) & 0x2000000) >> 25
}

// SYSCTL.PLL2: PLL2 controller
func (o *SYSCTL_Type) SetPLL2_CLKR(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0xf)|value)
}
func (o *SYSCTL_Type) GetPLL2_CLKR() uint32 {
	return volatile.LoadUint32(&o.PLL2.Reg) & 0xf
}
func (o *SYSCTL_Type) SetPLL2_CLKF(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0x3f0)|value<<4)
}
func (o *SYSCTL_Type) GetPLL2_CLKF() uint32 {
	return (volatile.LoadUint32(&o.PLL2.Reg) & 0x3f0) >> 4
}
func (o *SYSCTL_Type) SetPLL2_CLKOD(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0x3c00)|value<<10)
}
func (o *SYSCTL_Type) GetPLL2_CLKOD() uint32 {
	return (volatile.LoadUint32(&o.PLL2.Reg) & 0x3c00) >> 10
}
func (o *SYSCTL_Type) SetPLL2_BWADJ(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0xfc000)|value<<14)
}
func (o *SYSCTL_Type) GetPLL2_BWADJ() uint32 {
	return (volatile.LoadUint32(&o.PLL2.Reg) & 0xfc000) >> 14
}
func (o *SYSCTL_Type) SetPLL2_RESET(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCTL_Type) GetPLL2_RESET() uint32 {
	return (volatile.LoadUint32(&o.PLL2.Reg) & 0x100000) >> 20
}
func (o *SYSCTL_Type) SetPLL2_PWRD(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCTL_Type) GetPLL2_PWRD() uint32 {
	return (volatile.LoadUint32(&o.PLL2.Reg) & 0x200000) >> 21
}
func (o *SYSCTL_Type) SetPLL2_INTFB(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCTL_Type) GetPLL2_INTFB() uint32 {
	return (volatile.LoadUint32(&o.PLL2.Reg) & 0x400000) >> 22
}
func (o *SYSCTL_Type) SetPLL2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCTL_Type) GetPLL2_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PLL2.Reg) & 0x800000) >> 23
}
func (o *SYSCTL_Type) SetPLL2_TEST(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCTL_Type) GetPLL2_TEST() uint32 {
	return (volatile.LoadUint32(&o.PLL2.Reg) & 0x1000000) >> 24
}
func (o *SYSCTL_Type) SetPLL2_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCTL_Type) GetPLL2_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.PLL2.Reg) & 0x2000000) >> 25
}
func (o *SYSCTL_Type) SetPLL2_CKIN_SEL(value uint32) {
	volatile.StoreUint32(&o.PLL2.Reg, volatile.LoadUint32(&o.PLL2.Reg)&^(0xc000000)|value<<26)
}
func (o *SYSCTL_Type) GetPLL2_CKIN_SEL() uint32 {
	return (volatile.LoadUint32(&o.PLL2.Reg) & 0xc000000) >> 26
}

// SYSCTL.PLL_LOCK: PLL lock tester
func (o *SYSCTL_Type) SetPLL_LOCK_PLL_LOCK0(value uint32) {
	volatile.StoreUint32(&o.PLL_LOCK.Reg, volatile.LoadUint32(&o.PLL_LOCK.Reg)&^(0x3)|value)
}
func (o *SYSCTL_Type) GetPLL_LOCK_PLL_LOCK0() uint32 {
	return volatile.LoadUint32(&o.PLL_LOCK.Reg) & 0x3
}
func (o *SYSCTL_Type) SetPLL_LOCK_PLL_SLIP_CLEAR0(value uint32) {
	volatile.StoreUint32(&o.PLL_LOCK.Reg, volatile.LoadUint32(&o.PLL_LOCK.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTL_Type) GetPLL_LOCK_PLL_SLIP_CLEAR0() uint32 {
	return (volatile.LoadUint32(&o.PLL_LOCK.Reg) & 0x4) >> 2
}
func (o *SYSCTL_Type) SetPLL_LOCK_TEST_CLK_OUT0(value uint32) {
	volatile.StoreUint32(&o.PLL_LOCK.Reg, volatile.LoadUint32(&o.PLL_LOCK.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTL_Type) GetPLL_LOCK_TEST_CLK_OUT0() uint32 {
	return (volatile.LoadUint32(&o.PLL_LOCK.Reg) & 0x8) >> 3
}
func (o *SYSCTL_Type) SetPLL_LOCK_PLL_LOCK1(value uint32) {
	volatile.StoreUint32(&o.PLL_LOCK.Reg, volatile.LoadUint32(&o.PLL_LOCK.Reg)&^(0x300)|value<<8)
}
func (o *SYSCTL_Type) GetPLL_LOCK_PLL_LOCK1() uint32 {
	return (volatile.LoadUint32(&o.PLL_LOCK.Reg) & 0x300) >> 8
}
func (o *SYSCTL_Type) SetPLL_LOCK_PLL_SLIP_CLEAR1(value uint32) {
	volatile.StoreUint32(&o.PLL_LOCK.Reg, volatile.LoadUint32(&o.PLL_LOCK.Reg)&^(0x400)|value<<10)
}
func (o *SYSCTL_Type) GetPLL_LOCK_PLL_SLIP_CLEAR1() uint32 {
	return (volatile.LoadUint32(&o.PLL_LOCK.Reg) & 0x400) >> 10
}
func (o *SYSCTL_Type) SetPLL_LOCK_TEST_CLK_OUT1(value uint32) {
	volatile.StoreUint32(&o.PLL_LOCK.Reg, volatile.LoadUint32(&o.PLL_LOCK.Reg)&^(0x800)|value<<11)
}
func (o *SYSCTL_Type) GetPLL_LOCK_TEST_CLK_OUT1() uint32 {
	return (volatile.LoadUint32(&o.PLL_LOCK.Reg) & 0x800) >> 11
}
func (o *SYSCTL_Type) SetPLL_LOCK_PLL_LOCK2(value uint32) {
	volatile.StoreUint32(&o.PLL_LOCK.Reg, volatile.LoadUint32(&o.PLL_LOCK.Reg)&^(0x30000)|value<<16)
}
func (o *SYSCTL_Type) GetPLL_LOCK_PLL_LOCK2() uint32 {
	return (volatile.LoadUint32(&o.PLL_LOCK.Reg) & 0x30000) >> 16
}
func (o *SYSCTL_Type) SetPLL_LOCK_PLL_SLIP_CLEAR2(value uint32) {
	volatile.StoreUint32(&o.PLL_LOCK.Reg, volatile.LoadUint32(&o.PLL_LOCK.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCTL_Type) GetPLL_LOCK_PLL_SLIP_CLEAR2() uint32 {
	return (volatile.LoadUint32(&o.PLL_LOCK.Reg) & 0x40000) >> 18
}
func (o *SYSCTL_Type) SetPLL_LOCK_TEST_CLK_OUT2(value uint32) {
	volatile.StoreUint32(&o.PLL_LOCK.Reg, volatile.LoadUint32(&o.PLL_LOCK.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCTL_Type) GetPLL_LOCK_TEST_CLK_OUT2() uint32 {
	return (volatile.LoadUint32(&o.PLL_LOCK.Reg) & 0x80000) >> 19
}

// SYSCTL.ROM_ERROR: AXI ROM detector
func (o *SYSCTL_Type) SetROM_ERROR_ROM_MUL_ERROR(value uint32) {
	volatile.StoreUint32(&o.ROM_ERROR.Reg, volatile.LoadUint32(&o.ROM_ERROR.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetROM_ERROR_ROM_MUL_ERROR() uint32 {
	return volatile.LoadUint32(&o.ROM_ERROR.Reg) & 0x1
}
func (o *SYSCTL_Type) SetROM_ERROR_ROM_ONE_ERROR(value uint32) {
	volatile.StoreUint32(&o.ROM_ERROR.Reg, volatile.LoadUint32(&o.ROM_ERROR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTL_Type) GetROM_ERROR_ROM_ONE_ERROR() uint32 {
	return (volatile.LoadUint32(&o.ROM_ERROR.Reg) & 0x2) >> 1
}

// SYSCTL.CLK_SEL0: Clock select controller 0
func (o *SYSCTL_Type) SetCLK_SEL0_ACLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_SEL0.Reg, volatile.LoadUint32(&o.CLK_SEL0.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetCLK_SEL0_ACLK_SEL() uint32 {
	return volatile.LoadUint32(&o.CLK_SEL0.Reg) & 0x1
}
func (o *SYSCTL_Type) SetCLK_SEL0_ACLK_DIVIDER_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_SEL0.Reg, volatile.LoadUint32(&o.CLK_SEL0.Reg)&^(0x6)|value<<1)
}
func (o *SYSCTL_Type) GetCLK_SEL0_ACLK_DIVIDER_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_SEL0.Reg) & 0x6) >> 1
}
func (o *SYSCTL_Type) SetCLK_SEL0_APB0_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_SEL0.Reg, volatile.LoadUint32(&o.CLK_SEL0.Reg)&^(0x38)|value<<3)
}
func (o *SYSCTL_Type) GetCLK_SEL0_APB0_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_SEL0.Reg) & 0x38) >> 3
}
func (o *SYSCTL_Type) SetCLK_SEL0_APB1_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_SEL0.Reg, volatile.LoadUint32(&o.CLK_SEL0.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSCTL_Type) GetCLK_SEL0_APB1_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_SEL0.Reg) & 0x1c0) >> 6
}
func (o *SYSCTL_Type) SetCLK_SEL0_APB2_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_SEL0.Reg, volatile.LoadUint32(&o.CLK_SEL0.Reg)&^(0xe00)|value<<9)
}
func (o *SYSCTL_Type) GetCLK_SEL0_APB2_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_SEL0.Reg) & 0xe00) >> 9
}
func (o *SYSCTL_Type) SetCLK_SEL0_SPI3_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_SEL0.Reg, volatile.LoadUint32(&o.CLK_SEL0.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCTL_Type) GetCLK_SEL0_SPI3_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_SEL0.Reg) & 0x1000) >> 12
}
func (o *SYSCTL_Type) SetCLK_SEL0_TIMER0_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_SEL0.Reg, volatile.LoadUint32(&o.CLK_SEL0.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCTL_Type) GetCLK_SEL0_TIMER0_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_SEL0.Reg) & 0x2000) >> 13
}
func (o *SYSCTL_Type) SetCLK_SEL0_TIMER1_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_SEL0.Reg, volatile.LoadUint32(&o.CLK_SEL0.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCTL_Type) GetCLK_SEL0_TIMER1_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_SEL0.Reg) & 0x4000) >> 14
}
func (o *SYSCTL_Type) SetCLK_SEL0_TIMER2_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_SEL0.Reg, volatile.LoadUint32(&o.CLK_SEL0.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCTL_Type) GetCLK_SEL0_TIMER2_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_SEL0.Reg) & 0x8000) >> 15
}

// SYSCTL.CLK_SEL1: Clock select controller 1
func (o *SYSCTL_Type) SetCLK_SEL1_SPI3_SAMPLE_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_SEL1.Reg, volatile.LoadUint32(&o.CLK_SEL1.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetCLK_SEL1_SPI3_SAMPLE_CLK_SEL() uint32 {
	return volatile.LoadUint32(&o.CLK_SEL1.Reg) & 0x1
}

// SYSCTL.CLK_EN_CENT: Central clock enable
func (o *SYSCTL_Type) SetCLK_EN_CENT_CPU_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_CENT.Reg, volatile.LoadUint32(&o.CLK_EN_CENT.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetCLK_EN_CENT_CPU_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLK_EN_CENT.Reg) & 0x1
}
func (o *SYSCTL_Type) SetCLK_EN_CENT_SRAM0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_CENT.Reg, volatile.LoadUint32(&o.CLK_EN_CENT.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTL_Type) GetCLK_EN_CENT_SRAM0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_CENT.Reg) & 0x2) >> 1
}
func (o *SYSCTL_Type) SetCLK_EN_CENT_SRAM1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_CENT.Reg, volatile.LoadUint32(&o.CLK_EN_CENT.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTL_Type) GetCLK_EN_CENT_SRAM1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_CENT.Reg) & 0x4) >> 2
}
func (o *SYSCTL_Type) SetCLK_EN_CENT_APB0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_CENT.Reg, volatile.LoadUint32(&o.CLK_EN_CENT.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTL_Type) GetCLK_EN_CENT_APB0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_CENT.Reg) & 0x8) >> 3
}
func (o *SYSCTL_Type) SetCLK_EN_CENT_APB1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_CENT.Reg, volatile.LoadUint32(&o.CLK_EN_CENT.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTL_Type) GetCLK_EN_CENT_APB1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_CENT.Reg) & 0x10) >> 4
}
func (o *SYSCTL_Type) SetCLK_EN_CENT_APB2_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_CENT.Reg, volatile.LoadUint32(&o.CLK_EN_CENT.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTL_Type) GetCLK_EN_CENT_APB2_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_CENT.Reg) & 0x20) >> 5
}

// SYSCTL.CLK_EN_PERI: Peripheral clock enable
func (o *SYSCTL_Type) SetCLK_EN_PERI_ROM_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_ROM_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x1
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_DMA_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_DMA_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x2) >> 1
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_AI_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_AI_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x4) >> 2
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_DVP_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_DVP_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x8) >> 3
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_FFT_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_FFT_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x10) >> 4
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_GPIO_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_GPIO_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x20) >> 5
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_SPI0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_SPI0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x40) >> 6
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_SPI1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_SPI1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x80) >> 7
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_SPI2_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x100)|value<<8)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_SPI2_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x100) >> 8
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_SPI3_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x200)|value<<9)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_SPI3_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x200) >> 9
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_I2S0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x400)|value<<10)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_I2S0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x400) >> 10
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_I2S1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x800)|value<<11)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_I2S1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x800) >> 11
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_I2S2_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_I2S2_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x1000) >> 12
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_I2C0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_I2C0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x2000) >> 13
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_I2C1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_I2C1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x4000) >> 14
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_I2C2_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_I2C2_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x8000) >> 15
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_UART1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_UART1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x10000) >> 16
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_UART2_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_UART2_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x20000) >> 17
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_UART3_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_UART3_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x40000) >> 18
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_AES_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_AES_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x80000) >> 19
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_FPIOA_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_FPIOA_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x100000) >> 20
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_TIMER0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_TIMER0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x200000) >> 21
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_TIMER1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_TIMER1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x400000) >> 22
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_TIMER2_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_TIMER2_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x800000) >> 23
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_WDT0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_WDT0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x1000000) >> 24
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_WDT1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_WDT1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x2000000) >> 25
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_SHA_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_SHA_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x4000000) >> 26
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_OTP_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_OTP_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x8000000) >> 27
}
func (o *SYSCTL_Type) SetCLK_EN_PERI_RTC_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN_PERI.Reg, volatile.LoadUint32(&o.CLK_EN_PERI.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCTL_Type) GetCLK_EN_PERI_RTC_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_EN_PERI.Reg) & 0x20000000) >> 29
}

// SYSCTL.SOFT_RESET: Soft reset ctrl
func (o *SYSCTL_Type) SetSOFT_RESET(value uint32) {
	volatile.StoreUint32(&o.SOFT_RESET.Reg, volatile.LoadUint32(&o.SOFT_RESET.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetSOFT_RESET() uint32 {
	return volatile.LoadUint32(&o.SOFT_RESET.Reg) & 0x1
}

// SYSCTL.PERI_RESET: Peripheral reset controller
func (o *SYSCTL_Type) SetPERI_RESET_ROM_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetPERI_RESET_ROM_RESET() uint32 {
	return volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x1
}
func (o *SYSCTL_Type) SetPERI_RESET_DMA_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTL_Type) GetPERI_RESET_DMA_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x2) >> 1
}
func (o *SYSCTL_Type) SetPERI_RESET_AI_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTL_Type) GetPERI_RESET_AI_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x4) >> 2
}
func (o *SYSCTL_Type) SetPERI_RESET_DVP_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTL_Type) GetPERI_RESET_DVP_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x8) >> 3
}
func (o *SYSCTL_Type) SetPERI_RESET_FFT_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTL_Type) GetPERI_RESET_FFT_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x10) >> 4
}
func (o *SYSCTL_Type) SetPERI_RESET_GPIO_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTL_Type) GetPERI_RESET_GPIO_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x20) >> 5
}
func (o *SYSCTL_Type) SetPERI_RESET_SPI0_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTL_Type) GetPERI_RESET_SPI0_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x40) >> 6
}
func (o *SYSCTL_Type) SetPERI_RESET_SPI1_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTL_Type) GetPERI_RESET_SPI1_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x80) >> 7
}
func (o *SYSCTL_Type) SetPERI_RESET_SPI2_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x100)|value<<8)
}
func (o *SYSCTL_Type) GetPERI_RESET_SPI2_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x100) >> 8
}
func (o *SYSCTL_Type) SetPERI_RESET_SPI3_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x200)|value<<9)
}
func (o *SYSCTL_Type) GetPERI_RESET_SPI3_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x200) >> 9
}
func (o *SYSCTL_Type) SetPERI_RESET_I2S0_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x400)|value<<10)
}
func (o *SYSCTL_Type) GetPERI_RESET_I2S0_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x400) >> 10
}
func (o *SYSCTL_Type) SetPERI_RESET_I2S1_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x800)|value<<11)
}
func (o *SYSCTL_Type) GetPERI_RESET_I2S1_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x800) >> 11
}
func (o *SYSCTL_Type) SetPERI_RESET_I2S2_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCTL_Type) GetPERI_RESET_I2S2_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x1000) >> 12
}
func (o *SYSCTL_Type) SetPERI_RESET_I2C0_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCTL_Type) GetPERI_RESET_I2C0_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x2000) >> 13
}
func (o *SYSCTL_Type) SetPERI_RESET_I2C1_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCTL_Type) GetPERI_RESET_I2C1_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x4000) >> 14
}
func (o *SYSCTL_Type) SetPERI_RESET_I2C2_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCTL_Type) GetPERI_RESET_I2C2_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x8000) >> 15
}
func (o *SYSCTL_Type) SetPERI_RESET_UART1_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCTL_Type) GetPERI_RESET_UART1_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x10000) >> 16
}
func (o *SYSCTL_Type) SetPERI_RESET_UART2_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCTL_Type) GetPERI_RESET_UART2_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x20000) >> 17
}
func (o *SYSCTL_Type) SetPERI_RESET_UART3_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCTL_Type) GetPERI_RESET_UART3_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x40000) >> 18
}
func (o *SYSCTL_Type) SetPERI_RESET_AES_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCTL_Type) GetPERI_RESET_AES_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x80000) >> 19
}
func (o *SYSCTL_Type) SetPERI_RESET_FPIOA_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCTL_Type) GetPERI_RESET_FPIOA_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x100000) >> 20
}
func (o *SYSCTL_Type) SetPERI_RESET_TIMER0_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCTL_Type) GetPERI_RESET_TIMER0_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x200000) >> 21
}
func (o *SYSCTL_Type) SetPERI_RESET_TIMER1_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCTL_Type) GetPERI_RESET_TIMER1_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x400000) >> 22
}
func (o *SYSCTL_Type) SetPERI_RESET_TIMER2_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCTL_Type) GetPERI_RESET_TIMER2_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x800000) >> 23
}
func (o *SYSCTL_Type) SetPERI_RESET_WDT0_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCTL_Type) GetPERI_RESET_WDT0_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x1000000) >> 24
}
func (o *SYSCTL_Type) SetPERI_RESET_WDT1_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCTL_Type) GetPERI_RESET_WDT1_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x2000000) >> 25
}
func (o *SYSCTL_Type) SetPERI_RESET_SHA_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCTL_Type) GetPERI_RESET_SHA_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x4000000) >> 26
}
func (o *SYSCTL_Type) SetPERI_RESET_RTC_RESET(value uint32) {
	volatile.StoreUint32(&o.PERI_RESET.Reg, volatile.LoadUint32(&o.PERI_RESET.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCTL_Type) GetPERI_RESET_RTC_RESET() uint32 {
	return (volatile.LoadUint32(&o.PERI_RESET.Reg) & 0x20000000) >> 29
}

// SYSCTL.CLK_TH0: Clock threshold controller 0
func (o *SYSCTL_Type) SetCLK_TH0_SRAM0_GCLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH0.Reg, volatile.LoadUint32(&o.CLK_TH0.Reg)&^(0xf)|value)
}
func (o *SYSCTL_Type) GetCLK_TH0_SRAM0_GCLK() uint32 {
	return volatile.LoadUint32(&o.CLK_TH0.Reg) & 0xf
}
func (o *SYSCTL_Type) SetCLK_TH0_SRAM1_GCLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH0.Reg, volatile.LoadUint32(&o.CLK_TH0.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCTL_Type) GetCLK_TH0_SRAM1_GCLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH0.Reg) & 0xf0) >> 4
}
func (o *SYSCTL_Type) SetCLK_TH0_AI_GCLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH0.Reg, volatile.LoadUint32(&o.CLK_TH0.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCTL_Type) GetCLK_TH0_AI_GCLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH0.Reg) & 0xf00) >> 8
}
func (o *SYSCTL_Type) SetCLK_TH0_DVP_GCLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH0.Reg, volatile.LoadUint32(&o.CLK_TH0.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCTL_Type) GetCLK_TH0_DVP_GCLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH0.Reg) & 0xf000) >> 12
}
func (o *SYSCTL_Type) SetCLK_TH0_ROM_GCLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH0.Reg, volatile.LoadUint32(&o.CLK_TH0.Reg)&^(0xf0000)|value<<16)
}
func (o *SYSCTL_Type) GetCLK_TH0_ROM_GCLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH0.Reg) & 0xf0000) >> 16
}

// SYSCTL.CLK_TH1: Clock threshold controller 1
func (o *SYSCTL_Type) SetCLK_TH1_SPI0_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH1.Reg, volatile.LoadUint32(&o.CLK_TH1.Reg)&^(0xff)|value)
}
func (o *SYSCTL_Type) GetCLK_TH1_SPI0_CLK() uint32 {
	return volatile.LoadUint32(&o.CLK_TH1.Reg) & 0xff
}
func (o *SYSCTL_Type) SetCLK_TH1_SPI1_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH1.Reg, volatile.LoadUint32(&o.CLK_TH1.Reg)&^(0xff00)|value<<8)
}
func (o *SYSCTL_Type) GetCLK_TH1_SPI1_CLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH1.Reg) & 0xff00) >> 8
}
func (o *SYSCTL_Type) SetCLK_TH1_SPI2_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH1.Reg, volatile.LoadUint32(&o.CLK_TH1.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSCTL_Type) GetCLK_TH1_SPI2_CLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH1.Reg) & 0xff0000) >> 16
}
func (o *SYSCTL_Type) SetCLK_TH1_SPI3_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH1.Reg, volatile.LoadUint32(&o.CLK_TH1.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSCTL_Type) GetCLK_TH1_SPI3_CLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH1.Reg) & 0xff000000) >> 24
}

// SYSCTL.CLK_TH2: Clock threshold controller 2
func (o *SYSCTL_Type) SetCLK_TH2_TIMER0_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH2.Reg, volatile.LoadUint32(&o.CLK_TH2.Reg)&^(0xff)|value)
}
func (o *SYSCTL_Type) GetCLK_TH2_TIMER0_CLK() uint32 {
	return volatile.LoadUint32(&o.CLK_TH2.Reg) & 0xff
}
func (o *SYSCTL_Type) SetCLK_TH2_TIMER1_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH2.Reg, volatile.LoadUint32(&o.CLK_TH2.Reg)&^(0xff00)|value<<8)
}
func (o *SYSCTL_Type) GetCLK_TH2_TIMER1_CLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH2.Reg) & 0xff00) >> 8
}
func (o *SYSCTL_Type) SetCLK_TH2_TIMER2_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH2.Reg, volatile.LoadUint32(&o.CLK_TH2.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSCTL_Type) GetCLK_TH2_TIMER2_CLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH2.Reg) & 0xff0000) >> 16
}

// SYSCTL.CLK_TH3: Clock threshold controller 3
func (o *SYSCTL_Type) SetCLK_TH3_I2S0_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH3.Reg, volatile.LoadUint32(&o.CLK_TH3.Reg)&^(0xffff)|value)
}
func (o *SYSCTL_Type) GetCLK_TH3_I2S0_CLK() uint32 {
	return volatile.LoadUint32(&o.CLK_TH3.Reg) & 0xffff
}
func (o *SYSCTL_Type) SetCLK_TH3_I2S1_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH3.Reg, volatile.LoadUint32(&o.CLK_TH3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSCTL_Type) GetCLK_TH3_I2S1_CLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH3.Reg) & 0xffff0000) >> 16
}

// SYSCTL.CLK_TH4: Clock threshold controller 4
func (o *SYSCTL_Type) SetCLK_TH4_I2S2_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH4.Reg, volatile.LoadUint32(&o.CLK_TH4.Reg)&^(0xffff)|value)
}
func (o *SYSCTL_Type) GetCLK_TH4_I2S2_CLK() uint32 {
	return volatile.LoadUint32(&o.CLK_TH4.Reg) & 0xffff
}
func (o *SYSCTL_Type) SetCLK_TH4_I2S0_MCLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH4.Reg, volatile.LoadUint32(&o.CLK_TH4.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSCTL_Type) GetCLK_TH4_I2S0_MCLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH4.Reg) & 0xff0000) >> 16
}
func (o *SYSCTL_Type) SetCLK_TH4_I2S1_MCLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH4.Reg, volatile.LoadUint32(&o.CLK_TH4.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSCTL_Type) GetCLK_TH4_I2S1_MCLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH4.Reg) & 0xff000000) >> 24
}

// SYSCTL.CLK_TH5: Clock threshold controller 5
func (o *SYSCTL_Type) SetCLK_TH5_I2S2_MCLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH5.Reg, volatile.LoadUint32(&o.CLK_TH5.Reg)&^(0xff)|value)
}
func (o *SYSCTL_Type) GetCLK_TH5_I2S2_MCLK() uint32 {
	return volatile.LoadUint32(&o.CLK_TH5.Reg) & 0xff
}
func (o *SYSCTL_Type) SetCLK_TH5_I2C0_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH5.Reg, volatile.LoadUint32(&o.CLK_TH5.Reg)&^(0xff00)|value<<8)
}
func (o *SYSCTL_Type) GetCLK_TH5_I2C0_CLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH5.Reg) & 0xff00) >> 8
}
func (o *SYSCTL_Type) SetCLK_TH5_I2C1_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH5.Reg, volatile.LoadUint32(&o.CLK_TH5.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSCTL_Type) GetCLK_TH5_I2C1_CLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH5.Reg) & 0xff0000) >> 16
}
func (o *SYSCTL_Type) SetCLK_TH5_I2C2_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH5.Reg, volatile.LoadUint32(&o.CLK_TH5.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSCTL_Type) GetCLK_TH5_I2C2_CLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH5.Reg) & 0xff000000) >> 24
}

// SYSCTL.CLK_TH6: Clock threshold controller 6
func (o *SYSCTL_Type) SetCLK_TH6_WDT0_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH6.Reg, volatile.LoadUint32(&o.CLK_TH6.Reg)&^(0xff)|value)
}
func (o *SYSCTL_Type) GetCLK_TH6_WDT0_CLK() uint32 {
	return volatile.LoadUint32(&o.CLK_TH6.Reg) & 0xff
}
func (o *SYSCTL_Type) SetCLK_TH6_WDT1_CLK(value uint32) {
	volatile.StoreUint32(&o.CLK_TH6.Reg, volatile.LoadUint32(&o.CLK_TH6.Reg)&^(0xff00)|value<<8)
}
func (o *SYSCTL_Type) GetCLK_TH6_WDT1_CLK() uint32 {
	return (volatile.LoadUint32(&o.CLK_TH6.Reg) & 0xff00) >> 8
}

// SYSCTL.MISC: Miscellaneous controller
func (o *SYSCTL_Type) SetMISC_DEBUG_SEL(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x3f)|value)
}
func (o *SYSCTL_Type) GetMISC_DEBUG_SEL() uint32 {
	return volatile.LoadUint32(&o.MISC.Reg) & 0x3f
}
func (o *SYSCTL_Type) SetMISC_SPI_DVP_DATA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x400)|value<<10)
}
func (o *SYSCTL_Type) GetMISC_SPI_DVP_DATA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x400) >> 10
}

// SYSCTL.PERI: Peripheral controller
func (o *SYSCTL_Type) SetPERI_TIMER0_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetPERI_TIMER0_PAUSE() uint32 {
	return volatile.LoadUint32(&o.PERI.Reg) & 0x1
}
func (o *SYSCTL_Type) SetPERI_TIMER1_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTL_Type) GetPERI_TIMER1_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x2) >> 1
}
func (o *SYSCTL_Type) SetPERI_TIMER2_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTL_Type) GetPERI_TIMER2_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x4) >> 2
}
func (o *SYSCTL_Type) SetPERI_TIMER3_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTL_Type) GetPERI_TIMER3_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x8) >> 3
}
func (o *SYSCTL_Type) SetPERI_TIMER4_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTL_Type) GetPERI_TIMER4_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x10) >> 4
}
func (o *SYSCTL_Type) SetPERI_TIMER5_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTL_Type) GetPERI_TIMER5_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x20) >> 5
}
func (o *SYSCTL_Type) SetPERI_TIMER6_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTL_Type) GetPERI_TIMER6_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x40) >> 6
}
func (o *SYSCTL_Type) SetPERI_TIMER7_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTL_Type) GetPERI_TIMER7_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x80) >> 7
}
func (o *SYSCTL_Type) SetPERI_TIMER8_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x100)|value<<8)
}
func (o *SYSCTL_Type) GetPERI_TIMER8_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x100) >> 8
}
func (o *SYSCTL_Type) SetPERI_TIMER9_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x200)|value<<9)
}
func (o *SYSCTL_Type) GetPERI_TIMER9_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x200) >> 9
}
func (o *SYSCTL_Type) SetPERI_TIMER10_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x400)|value<<10)
}
func (o *SYSCTL_Type) GetPERI_TIMER10_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x400) >> 10
}
func (o *SYSCTL_Type) SetPERI_TIMER11_PAUSE(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x800)|value<<11)
}
func (o *SYSCTL_Type) GetPERI_TIMER11_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x800) >> 11
}
func (o *SYSCTL_Type) SetPERI_SPI0_XIP_EN(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCTL_Type) GetPERI_SPI0_XIP_EN() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x1000) >> 12
}
func (o *SYSCTL_Type) SetPERI_SPI1_XIP_EN(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCTL_Type) GetPERI_SPI1_XIP_EN() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x2000) >> 13
}
func (o *SYSCTL_Type) SetPERI_SPI2_XIP_EN(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCTL_Type) GetPERI_SPI2_XIP_EN() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x4000) >> 14
}
func (o *SYSCTL_Type) SetPERI_SPI3_XIP_EN(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCTL_Type) GetPERI_SPI3_XIP_EN() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x8000) >> 15
}
func (o *SYSCTL_Type) SetPERI_SPI0_CLK_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCTL_Type) GetPERI_SPI0_CLK_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x10000) >> 16
}
func (o *SYSCTL_Type) SetPERI_SPI1_CLK_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCTL_Type) GetPERI_SPI1_CLK_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x20000) >> 17
}
func (o *SYSCTL_Type) SetPERI_SPI2_CLK_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCTL_Type) GetPERI_SPI2_CLK_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x40000) >> 18
}
func (o *SYSCTL_Type) SetPERI_I2S0_CLK_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCTL_Type) GetPERI_I2S0_CLK_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x80000) >> 19
}
func (o *SYSCTL_Type) SetPERI_I2S1_CLK_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCTL_Type) GetPERI_I2S1_CLK_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x100000) >> 20
}
func (o *SYSCTL_Type) SetPERI_I2S2_CLK_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCTL_Type) GetPERI_I2S2_CLK_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x200000) >> 21
}
func (o *SYSCTL_Type) SetPERI_JTAG_CLK_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCTL_Type) GetPERI_JTAG_CLK_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x400000) >> 22
}
func (o *SYSCTL_Type) SetPERI_DVP_CLK_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCTL_Type) GetPERI_DVP_CLK_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x800000) >> 23
}
func (o *SYSCTL_Type) SetPERI_DEBUG_CLK_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PERI.Reg, volatile.LoadUint32(&o.PERI.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCTL_Type) GetPERI_DEBUG_CLK_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PERI.Reg) & 0x1000000) >> 24
}

// SYSCTL.SPI_SLEEP: SPI sleep controller
func (o *SYSCTL_Type) SetSPI_SLEEP_SSI0_SLEEP(value uint32) {
	volatile.StoreUint32(&o.SPI_SLEEP.Reg, volatile.LoadUint32(&o.SPI_SLEEP.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetSPI_SLEEP_SSI0_SLEEP() uint32 {
	return volatile.LoadUint32(&o.SPI_SLEEP.Reg) & 0x1
}
func (o *SYSCTL_Type) SetSPI_SLEEP_SSI1_SLEEP(value uint32) {
	volatile.StoreUint32(&o.SPI_SLEEP.Reg, volatile.LoadUint32(&o.SPI_SLEEP.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTL_Type) GetSPI_SLEEP_SSI1_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.SPI_SLEEP.Reg) & 0x2) >> 1
}
func (o *SYSCTL_Type) SetSPI_SLEEP_SSI2_SLEEP(value uint32) {
	volatile.StoreUint32(&o.SPI_SLEEP.Reg, volatile.LoadUint32(&o.SPI_SLEEP.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTL_Type) GetSPI_SLEEP_SSI2_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.SPI_SLEEP.Reg) & 0x4) >> 2
}
func (o *SYSCTL_Type) SetSPI_SLEEP_SSI3_SLEEP(value uint32) {
	volatile.StoreUint32(&o.SPI_SLEEP.Reg, volatile.LoadUint32(&o.SPI_SLEEP.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTL_Type) GetSPI_SLEEP_SSI3_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.SPI_SLEEP.Reg) & 0x8) >> 3
}

// SYSCTL.RESET_STATUS: Reset source status
func (o *SYSCTL_Type) SetRESET_STATUS_RESET_STS_CLR(value uint32) {
	volatile.StoreUint32(&o.RESET_STATUS.Reg, volatile.LoadUint32(&o.RESET_STATUS.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetRESET_STATUS_RESET_STS_CLR() uint32 {
	return volatile.LoadUint32(&o.RESET_STATUS.Reg) & 0x1
}
func (o *SYSCTL_Type) SetRESET_STATUS_PIN_RESET_STS(value uint32) {
	volatile.StoreUint32(&o.RESET_STATUS.Reg, volatile.LoadUint32(&o.RESET_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTL_Type) GetRESET_STATUS_PIN_RESET_STS() uint32 {
	return (volatile.LoadUint32(&o.RESET_STATUS.Reg) & 0x2) >> 1
}
func (o *SYSCTL_Type) SetRESET_STATUS_WDT0_RESET_STS(value uint32) {
	volatile.StoreUint32(&o.RESET_STATUS.Reg, volatile.LoadUint32(&o.RESET_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTL_Type) GetRESET_STATUS_WDT0_RESET_STS() uint32 {
	return (volatile.LoadUint32(&o.RESET_STATUS.Reg) & 0x4) >> 2
}
func (o *SYSCTL_Type) SetRESET_STATUS_WDT1_RESET_STS(value uint32) {
	volatile.StoreUint32(&o.RESET_STATUS.Reg, volatile.LoadUint32(&o.RESET_STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTL_Type) GetRESET_STATUS_WDT1_RESET_STS() uint32 {
	return (volatile.LoadUint32(&o.RESET_STATUS.Reg) & 0x8) >> 3
}
func (o *SYSCTL_Type) SetRESET_STATUS_SOFT_RESET_STS(value uint32) {
	volatile.StoreUint32(&o.RESET_STATUS.Reg, volatile.LoadUint32(&o.RESET_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTL_Type) GetRESET_STATUS_SOFT_RESET_STS() uint32 {
	return (volatile.LoadUint32(&o.RESET_STATUS.Reg) & 0x10) >> 4
}

// SYSCTL.DMA_SEL0: DMA handshake selector
func (o *SYSCTL_Type) SetDMA_SEL0(value uint32) {
	volatile.StoreUint32(&o.DMA_SEL0.Reg, volatile.LoadUint32(&o.DMA_SEL0.Reg)&^(0x3f)|value)
}
func (o *SYSCTL_Type) GetDMA_SEL0() uint32 {
	return volatile.LoadUint32(&o.DMA_SEL0.Reg) & 0x3f
}
func (o *SYSCTL_Type) SetDMA_SEL0_DMA_SEL1(value uint32) {
	volatile.StoreUint32(&o.DMA_SEL0.Reg, volatile.LoadUint32(&o.DMA_SEL0.Reg)&^(0xfc0)|value<<6)
}
func (o *SYSCTL_Type) GetDMA_SEL0_DMA_SEL1() uint32 {
	return (volatile.LoadUint32(&o.DMA_SEL0.Reg) & 0xfc0) >> 6
}
func (o *SYSCTL_Type) SetDMA_SEL0_DMA_SEL2(value uint32) {
	volatile.StoreUint32(&o.DMA_SEL0.Reg, volatile.LoadUint32(&o.DMA_SEL0.Reg)&^(0x3f000)|value<<12)
}
func (o *SYSCTL_Type) GetDMA_SEL0_DMA_SEL2() uint32 {
	return (volatile.LoadUint32(&o.DMA_SEL0.Reg) & 0x3f000) >> 12
}
func (o *SYSCTL_Type) SetDMA_SEL0_DMA_SEL3(value uint32) {
	volatile.StoreUint32(&o.DMA_SEL0.Reg, volatile.LoadUint32(&o.DMA_SEL0.Reg)&^(0xfc0000)|value<<18)
}
func (o *SYSCTL_Type) GetDMA_SEL0_DMA_SEL3() uint32 {
	return (volatile.LoadUint32(&o.DMA_SEL0.Reg) & 0xfc0000) >> 18
}
func (o *SYSCTL_Type) SetDMA_SEL0_DMA_SEL4(value uint32) {
	volatile.StoreUint32(&o.DMA_SEL0.Reg, volatile.LoadUint32(&o.DMA_SEL0.Reg)&^(0x3f000000)|value<<24)
}
func (o *SYSCTL_Type) GetDMA_SEL0_DMA_SEL4() uint32 {
	return (volatile.LoadUint32(&o.DMA_SEL0.Reg) & 0x3f000000) >> 24
}

// SYSCTL.DMA_SEL1: DMA handshake selector
func (o *SYSCTL_Type) SetDMA_SEL1_DMA_SEL5(value uint32) {
	volatile.StoreUint32(&o.DMA_SEL1.Reg, volatile.LoadUint32(&o.DMA_SEL1.Reg)&^(0x3f)|value)
}
func (o *SYSCTL_Type) GetDMA_SEL1_DMA_SEL5() uint32 {
	return volatile.LoadUint32(&o.DMA_SEL1.Reg) & 0x3f
}

// SYSCTL.POWER_SEL: IO Power Mode Select controller
func (o *SYSCTL_Type) SetPOWER_SEL_POWER_MODE_SEL0(value uint32) {
	volatile.StoreUint32(&o.POWER_SEL.Reg, volatile.LoadUint32(&o.POWER_SEL.Reg)&^(0x1)|value)
}
func (o *SYSCTL_Type) GetPOWER_SEL_POWER_MODE_SEL0() uint32 {
	return volatile.LoadUint32(&o.POWER_SEL.Reg) & 0x1
}
func (o *SYSCTL_Type) SetPOWER_SEL_POWER_MODE_SEL1(value uint32) {
	volatile.StoreUint32(&o.POWER_SEL.Reg, volatile.LoadUint32(&o.POWER_SEL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTL_Type) GetPOWER_SEL_POWER_MODE_SEL1() uint32 {
	return (volatile.LoadUint32(&o.POWER_SEL.Reg) & 0x2) >> 1
}
func (o *SYSCTL_Type) SetPOWER_SEL_POWER_MODE_SEL2(value uint32) {
	volatile.StoreUint32(&o.POWER_SEL.Reg, volatile.LoadUint32(&o.POWER_SEL.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTL_Type) GetPOWER_SEL_POWER_MODE_SEL2() uint32 {
	return (volatile.LoadUint32(&o.POWER_SEL.Reg) & 0x4) >> 2
}
func (o *SYSCTL_Type) SetPOWER_SEL_POWER_MODE_SEL3(value uint32) {
	volatile.StoreUint32(&o.POWER_SEL.Reg, volatile.LoadUint32(&o.POWER_SEL.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTL_Type) GetPOWER_SEL_POWER_MODE_SEL3() uint32 {
	return (volatile.LoadUint32(&o.POWER_SEL.Reg) & 0x8) >> 3
}
func (o *SYSCTL_Type) SetPOWER_SEL_POWER_MODE_SEL4(value uint32) {
	volatile.StoreUint32(&o.POWER_SEL.Reg, volatile.LoadUint32(&o.POWER_SEL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTL_Type) GetPOWER_SEL_POWER_MODE_SEL4() uint32 {
	return (volatile.LoadUint32(&o.POWER_SEL.Reg) & 0x10) >> 4
}
func (o *SYSCTL_Type) SetPOWER_SEL_POWER_MODE_SEL5(value uint32) {
	volatile.StoreUint32(&o.POWER_SEL.Reg, volatile.LoadUint32(&o.POWER_SEL.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTL_Type) GetPOWER_SEL_POWER_MODE_SEL5() uint32 {
	return (volatile.LoadUint32(&o.POWER_SEL.Reg) & 0x20) >> 5
}
func (o *SYSCTL_Type) SetPOWER_SEL_POWER_MODE_SEL6(value uint32) {
	volatile.StoreUint32(&o.POWER_SEL.Reg, volatile.LoadUint32(&o.POWER_SEL.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTL_Type) GetPOWER_SEL_POWER_MODE_SEL6() uint32 {
	return (volatile.LoadUint32(&o.POWER_SEL.Reg) & 0x40) >> 6
}
func (o *SYSCTL_Type) SetPOWER_SEL_POWER_MODE_SEL7(value uint32) {
	volatile.StoreUint32(&o.POWER_SEL.Reg, volatile.LoadUint32(&o.POWER_SEL.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTL_Type) GetPOWER_SEL_POWER_MODE_SEL7() uint32 {
	return (volatile.LoadUint32(&o.POWER_SEL.Reg) & 0x80) >> 7
}

// AES Accelerator
type AES_Type struct {
	KEY           [4]volatile.Register32 // 0x0
	ENCRYPT_SEL   volatile.Register32    // 0x10
	MODE_CTL      volatile.Register32    // 0x14
	IV            [4]volatile.Register32 // 0x18
	ENDIAN        volatile.Register32    // 0x28
	FINISH        volatile.Register32    // 0x2C
	DMA_SEL       volatile.Register32    // 0x30
	AAD_NUM       volatile.Register32    // 0x34
	_             [4]byte
	PC_NUM        volatile.Register32    // 0x3C
	TEXT_DATA     volatile.Register32    // 0x40
	AAD_DATA      volatile.Register32    // 0x44
	TAG_CHK       volatile.Register32    // 0x48
	DATA_IN_FLAG  volatile.Register32    // 0x4C
	GCM_IN_TAG    [4]volatile.Register32 // 0x50
	OUT_DATA      volatile.Register32    // 0x60
	EN            volatile.Register32    // 0x64
	DATA_OUT_FLAG volatile.Register32    // 0x68
	TAG_IN_FLAG   volatile.Register32    // 0x6C
	TAG_CLEAR     volatile.Register32    // 0x70
	GCM_OUT_TAG   [4]volatile.Register32 // 0x74
	KEY_EXT       [4]volatile.Register32 // 0x84
}

// AES.ENCRYPT_SEL: Encryption or decryption select
func (o *AES_Type) SetENCRYPT_SEL(value uint32) {
	volatile.StoreUint32(&o.ENCRYPT_SEL.Reg, volatile.LoadUint32(&o.ENCRYPT_SEL.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetENCRYPT_SEL() uint32 {
	return volatile.LoadUint32(&o.ENCRYPT_SEL.Reg) & 0x1
}

// AES.MODE_CTL: AES mode register
func (o *AES_Type) SetMODE_CTL_CIPHER_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE_CTL.Reg, volatile.LoadUint32(&o.MODE_CTL.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetMODE_CTL_CIPHER_MODE() uint32 {
	return volatile.LoadUint32(&o.MODE_CTL.Reg) & 0x7
}
func (o *AES_Type) SetMODE_CTL_KEY_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE_CTL.Reg, volatile.LoadUint32(&o.MODE_CTL.Reg)&^(0x18)|value<<3)
}
func (o *AES_Type) GetMODE_CTL_KEY_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE_CTL.Reg) & 0x18) >> 3
}
func (o *AES_Type) SetMODE_CTL_KEY_ORDER(value uint32) {
	volatile.StoreUint32(&o.MODE_CTL.Reg, volatile.LoadUint32(&o.MODE_CTL.Reg)&^(0x20)|value<<5)
}
func (o *AES_Type) GetMODE_CTL_KEY_ORDER() uint32 {
	return (volatile.LoadUint32(&o.MODE_CTL.Reg) & 0x20) >> 5
}
func (o *AES_Type) SetMODE_CTL_INPUT_ORDER(value uint32) {
	volatile.StoreUint32(&o.MODE_CTL.Reg, volatile.LoadUint32(&o.MODE_CTL.Reg)&^(0x80)|value<<7)
}
func (o *AES_Type) GetMODE_CTL_INPUT_ORDER() uint32 {
	return (volatile.LoadUint32(&o.MODE_CTL.Reg) & 0x80) >> 7
}
func (o *AES_Type) SetMODE_CTL_OUTPUT_ORDER(value uint32) {
	volatile.StoreUint32(&o.MODE_CTL.Reg, volatile.LoadUint32(&o.MODE_CTL.Reg)&^(0x200)|value<<9)
}
func (o *AES_Type) GetMODE_CTL_OUTPUT_ORDER() uint32 {
	return (volatile.LoadUint32(&o.MODE_CTL.Reg) & 0x200) >> 9
}

// AES.ENDIAN: Endian control
func (o *AES_Type) SetENDIAN(value uint32) {
	volatile.StoreUint32(&o.ENDIAN.Reg, volatile.LoadUint32(&o.ENDIAN.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetENDIAN() uint32 {
	return volatile.LoadUint32(&o.ENDIAN.Reg) & 0x1
}

// AES.FINISH: Finished status
func (o *AES_Type) SetFINISH(value uint32) {
	volatile.StoreUint32(&o.FINISH.Reg, volatile.LoadUint32(&o.FINISH.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetFINISH() uint32 {
	return volatile.LoadUint32(&o.FINISH.Reg) & 0x1
}

// AES.DMA_SEL: DMA select
func (o *AES_Type) SetDMA_SEL(value uint32) {
	volatile.StoreUint32(&o.DMA_SEL.Reg, volatile.LoadUint32(&o.DMA_SEL.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_SEL() uint32 {
	return volatile.LoadUint32(&o.DMA_SEL.Reg) & 0x1
}

// AES.TAG_CHK: Tag check status
func (o *AES_Type) SetTAG_CHK(value uint32) {
	volatile.StoreUint32(&o.TAG_CHK.Reg, volatile.LoadUint32(&o.TAG_CHK.Reg)&^(0x3)|value)
}
func (o *AES_Type) GetTAG_CHK() uint32 {
	return volatile.LoadUint32(&o.TAG_CHK.Reg) & 0x3
}

// AES.DATA_IN_FLAG: Data can input flag
func (o *AES_Type) SetDATA_IN_FLAG(value uint32) {
	volatile.StoreUint32(&o.DATA_IN_FLAG.Reg, volatile.LoadUint32(&o.DATA_IN_FLAG.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDATA_IN_FLAG() uint32 {
	return volatile.LoadUint32(&o.DATA_IN_FLAG.Reg) & 0x1
}

// AES.EN: AES module enable
func (o *AES_Type) SetEN(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetEN() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// AES.DATA_OUT_FLAG: Data can output flag
func (o *AES_Type) SetDATA_OUT_FLAG(value uint32) {
	volatile.StoreUint32(&o.DATA_OUT_FLAG.Reg, volatile.LoadUint32(&o.DATA_OUT_FLAG.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDATA_OUT_FLAG() uint32 {
	return volatile.LoadUint32(&o.DATA_OUT_FLAG.Reg) & 0x1
}

// AES.TAG_IN_FLAG: Can input tag (when using GCM)
func (o *AES_Type) SetTAG_IN_FLAG(value uint32) {
	volatile.StoreUint32(&o.TAG_IN_FLAG.Reg, volatile.LoadUint32(&o.TAG_IN_FLAG.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetTAG_IN_FLAG() uint32 {
	return volatile.LoadUint32(&o.TAG_IN_FLAG.Reg) & 0x1
}

// Real Time Clock
type RTC_Type struct {
	DATE           volatile.Register32 // 0x0
	TIME           volatile.Register32 // 0x4
	ALARM_DATE     volatile.Register32 // 0x8
	ALARM_TIME     volatile.Register32 // 0xC
	INITIAL_COUNT  volatile.Register32 // 0x10
	CURRENT_COUNT  volatile.Register32 // 0x14
	INTERRUPT_CTRL volatile.Register32 // 0x18
	REGISTER_CTRL  volatile.Register32 // 0x1C
	_              [8]byte
	EXTENDED       volatile.Register32 // 0x28
}

// RTC.DATE: Timer date information
func (o *RTC_Type) SetDATE_WEEK(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetDATE_WEEK() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x7
}
func (o *RTC_Type) SetDATE_DAY(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x1f00)|value<<8)
}
func (o *RTC_Type) GetDATE_DAY() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0x1f00) >> 8
}
func (o *RTC_Type) SetDATE_MONTH(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDATE_MONTH() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDATE_YEAR(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfff00000)|value<<20)
}
func (o *RTC_Type) GetDATE_YEAR() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0xfff00000) >> 20
}

// RTC.TIME: Timer time information
func (o *RTC_Type) SetTIME_SECOND(value uint32) {
	volatile.StoreUint32(&o.TIME.Reg, volatile.LoadUint32(&o.TIME.Reg)&^(0xfc00)|value<<10)
}
func (o *RTC_Type) GetTIME_SECOND() uint32 {
	return (volatile.LoadUint32(&o.TIME.Reg) & 0xfc00) >> 10
}
func (o *RTC_Type) SetTIME_MINUTE(value uint32) {
	volatile.StoreUint32(&o.TIME.Reg, volatile.LoadUint32(&o.TIME.Reg)&^(0x3f0000)|value<<16)
}
func (o *RTC_Type) GetTIME_MINUTE() uint32 {
	return (volatile.LoadUint32(&o.TIME.Reg) & 0x3f0000) >> 16
}
func (o *RTC_Type) SetTIME_HOUR(value uint32) {
	volatile.StoreUint32(&o.TIME.Reg, volatile.LoadUint32(&o.TIME.Reg)&^(0x1f000000)|value<<24)
}
func (o *RTC_Type) GetTIME_HOUR() uint32 {
	return (volatile.LoadUint32(&o.TIME.Reg) & 0x1f000000) >> 24
}

// RTC.ALARM_DATE: Alarm date information
func (o *RTC_Type) SetALARM_DATE_WEEK(value uint32) {
	volatile.StoreUint32(&o.ALARM_DATE.Reg, volatile.LoadUint32(&o.ALARM_DATE.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetALARM_DATE_WEEK() uint32 {
	return volatile.LoadUint32(&o.ALARM_DATE.Reg) & 0x7
}
func (o *RTC_Type) SetALARM_DATE_DAY(value uint32) {
	volatile.StoreUint32(&o.ALARM_DATE.Reg, volatile.LoadUint32(&o.ALARM_DATE.Reg)&^(0x1f00)|value<<8)
}
func (o *RTC_Type) GetALARM_DATE_DAY() uint32 {
	return (volatile.LoadUint32(&o.ALARM_DATE.Reg) & 0x1f00) >> 8
}
func (o *RTC_Type) SetALARM_DATE_MONTH(value uint32) {
	volatile.StoreUint32(&o.ALARM_DATE.Reg, volatile.LoadUint32(&o.ALARM_DATE.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALARM_DATE_MONTH() uint32 {
	return (volatile.LoadUint32(&o.ALARM_DATE.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALARM_DATE_YEAR(value uint32) {
	volatile.StoreUint32(&o.ALARM_DATE.Reg, volatile.LoadUint32(&o.ALARM_DATE.Reg)&^(0xfff00000)|value<<20)
}
func (o *RTC_Type) GetALARM_DATE_YEAR() uint32 {
	return (volatile.LoadUint32(&o.ALARM_DATE.Reg) & 0xfff00000) >> 20
}

// RTC.ALARM_TIME: Alarm time information
func (o *RTC_Type) SetALARM_TIME_SECOND(value uint32) {
	volatile.StoreUint32(&o.ALARM_TIME.Reg, volatile.LoadUint32(&o.ALARM_TIME.Reg)&^(0xfc00)|value<<10)
}
func (o *RTC_Type) GetALARM_TIME_SECOND() uint32 {
	return (volatile.LoadUint32(&o.ALARM_TIME.Reg) & 0xfc00) >> 10
}
func (o *RTC_Type) SetALARM_TIME_MINUTE(value uint32) {
	volatile.StoreUint32(&o.ALARM_TIME.Reg, volatile.LoadUint32(&o.ALARM_TIME.Reg)&^(0x3f0000)|value<<16)
}
func (o *RTC_Type) GetALARM_TIME_MINUTE() uint32 {
	return (volatile.LoadUint32(&o.ALARM_TIME.Reg) & 0x3f0000) >> 16
}
func (o *RTC_Type) SetALARM_TIME_HOUR(value uint32) {
	volatile.StoreUint32(&o.ALARM_TIME.Reg, volatile.LoadUint32(&o.ALARM_TIME.Reg)&^(0x1f000000)|value<<24)
}
func (o *RTC_Type) GetALARM_TIME_HOUR() uint32 {
	return (volatile.LoadUint32(&o.ALARM_TIME.Reg) & 0x1f000000) >> 24
}

// RTC.INITIAL_COUNT: Timer counter initial value
func (o *RTC_Type) SetINITIAL_COUNT(value uint32) {
	volatile.StoreUint32(&o.INITIAL_COUNT.Reg, value)
}
func (o *RTC_Type) GetINITIAL_COUNT() uint32 {
	return volatile.LoadUint32(&o.INITIAL_COUNT.Reg)
}

// RTC.CURRENT_COUNT: Timer counter current value
func (o *RTC_Type) SetCURRENT_COUNT(value uint32) {
	volatile.StoreUint32(&o.CURRENT_COUNT.Reg, value)
}
func (o *RTC_Type) GetCURRENT_COUNT() uint32 {
	return volatile.LoadUint32(&o.CURRENT_COUNT.Reg)
}

// RTC.INTERRUPT_CTRL: RTC interrupt settings
func (o *RTC_Type) SetINTERRUPT_CTRL_TICK_ENABLE(value uint32) {
	volatile.StoreUint32(&o.INTERRUPT_CTRL.Reg, volatile.LoadUint32(&o.INTERRUPT_CTRL.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetINTERRUPT_CTRL_TICK_ENABLE() uint32 {
	return volatile.LoadUint32(&o.INTERRUPT_CTRL.Reg) & 0x1
}
func (o *RTC_Type) SetINTERRUPT_CTRL_ALARM_ENABLE(value uint32) {
	volatile.StoreUint32(&o.INTERRUPT_CTRL.Reg, volatile.LoadUint32(&o.INTERRUPT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetINTERRUPT_CTRL_ALARM_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.INTERRUPT_CTRL.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetINTERRUPT_CTRL_TICK_INT_MODE(value uint32) {
	volatile.StoreUint32(&o.INTERRUPT_CTRL.Reg, volatile.LoadUint32(&o.INTERRUPT_CTRL.Reg)&^(0xc)|value<<2)
}
func (o *RTC_Type) GetINTERRUPT_CTRL_TICK_INT_MODE() uint32 {
	return (volatile.LoadUint32(&o.INTERRUPT_CTRL.Reg) & 0xc) >> 2
}
func (o *RTC_Type) SetINTERRUPT_CTRL_ALARM_COMPARE_MASK(value uint32) {
	volatile.StoreUint32(&o.INTERRUPT_CTRL.Reg, volatile.LoadUint32(&o.INTERRUPT_CTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *RTC_Type) GetINTERRUPT_CTRL_ALARM_COMPARE_MASK() uint32 {
	return (volatile.LoadUint32(&o.INTERRUPT_CTRL.Reg) & 0xff000000) >> 24
}

// RTC.REGISTER_CTRL: RTC register settings
func (o *RTC_Type) SetREGISTER_CTRL_READ_ENABLE(value uint32) {
	volatile.StoreUint32(&o.REGISTER_CTRL.Reg, volatile.LoadUint32(&o.REGISTER_CTRL.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetREGISTER_CTRL_READ_ENABLE() uint32 {
	return volatile.LoadUint32(&o.REGISTER_CTRL.Reg) & 0x1
}
func (o *RTC_Type) SetREGISTER_CTRL_WRITE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.REGISTER_CTRL.Reg, volatile.LoadUint32(&o.REGISTER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetREGISTER_CTRL_WRITE_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.REGISTER_CTRL.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetREGISTER_CTRL_TIMER_MASK(value uint32) {
	volatile.StoreUint32(&o.REGISTER_CTRL.Reg, volatile.LoadUint32(&o.REGISTER_CTRL.Reg)&^(0x1fe000)|value<<13)
}
func (o *RTC_Type) GetREGISTER_CTRL_TIMER_MASK() uint32 {
	return (volatile.LoadUint32(&o.REGISTER_CTRL.Reg) & 0x1fe000) >> 13
}
func (o *RTC_Type) SetREGISTER_CTRL_ALARM_MASK(value uint32) {
	volatile.StoreUint32(&o.REGISTER_CTRL.Reg, volatile.LoadUint32(&o.REGISTER_CTRL.Reg)&^(0x1fe00000)|value<<21)
}
func (o *RTC_Type) GetREGISTER_CTRL_ALARM_MASK() uint32 {
	return (volatile.LoadUint32(&o.REGISTER_CTRL.Reg) & 0x1fe00000) >> 21
}
func (o *RTC_Type) SetREGISTER_CTRL_INITIAL_COUNT_MASK(value uint32) {
	volatile.StoreUint32(&o.REGISTER_CTRL.Reg, volatile.LoadUint32(&o.REGISTER_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_Type) GetREGISTER_CTRL_INITIAL_COUNT_MASK() uint32 {
	return (volatile.LoadUint32(&o.REGISTER_CTRL.Reg) & 0x20000000) >> 29
}
func (o *RTC_Type) SetREGISTER_CTRL_INTERRUPT_REGISTER_MASK(value uint32) {
	volatile.StoreUint32(&o.REGISTER_CTRL.Reg, volatile.LoadUint32(&o.REGISTER_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetREGISTER_CTRL_INTERRUPT_REGISTER_MASK() uint32 {
	return (volatile.LoadUint32(&o.REGISTER_CTRL.Reg) & 0x40000000) >> 30
}

// RTC.EXTENDED: Timer extended information
func (o *RTC_Type) SetEXTENDED_CENTURY(value uint32) {
	volatile.StoreUint32(&o.EXTENDED.Reg, volatile.LoadUint32(&o.EXTENDED.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetEXTENDED_CENTURY() uint32 {
	return volatile.LoadUint32(&o.EXTENDED.Reg) & 0x1f
}
func (o *RTC_Type) SetEXTENDED_LEAP_YEAR(value uint32) {
	volatile.StoreUint32(&o.EXTENDED.Reg, volatile.LoadUint32(&o.EXTENDED.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetEXTENDED_LEAP_YEAR() uint32 {
	return (volatile.LoadUint32(&o.EXTENDED.Reg) & 0x20) >> 5
}

// Constants for CLINT: Core Local Interruptor
const ()

// Constants for PLIC: Platform-Level Interrupt Controller
const (
	// TARGET_ENABLES.ENABLE: Interrupt Enable Register

	// TARGETS.THRESHOLD: Priority Threshold Register
	// Position of PRIORITY field.
	PLIC_targets_THRESHOLD_PRIORITY_Pos = 0x0
	// Bit mask of PRIORITY field.
	PLIC_targets_THRESHOLD_PRIORITY_Msk = 0x7
	// Never interrupt
	PLIC_targets_THRESHOLD_PRIORITY_Never = 0x0
	// Priority 1
	PLIC_targets_THRESHOLD_PRIORITY_P1 = 0x1
	// Priority 2
	PLIC_targets_THRESHOLD_PRIORITY_P2 = 0x2
	// Priority 3
	PLIC_targets_THRESHOLD_PRIORITY_P3 = 0x3
	// Priority 4
	PLIC_targets_THRESHOLD_PRIORITY_P4 = 0x4
	// Priority 5
	PLIC_targets_THRESHOLD_PRIORITY_P5 = 0x5
	// Priority 6
	PLIC_targets_THRESHOLD_PRIORITY_P6 = 0x6
	// Priority 7
	PLIC_targets_THRESHOLD_PRIORITY_P7 = 0x7

	// TARGETS.CLAIM: Claim/Complete Register

	// TARGETS._RESERVED: Padding to make sure targets is an array
)

// Constants for UARTHS: High-speed UART
const (
	// TXDATA: Transmit Data Register
	// Position of DATA field.
	UARTHS_TXDATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	UARTHS_TXDATA_DATA_Msk = 0xff
	// Position of FULL field.
	UARTHS_TXDATA_FULL_Pos = 0x1f
	// Bit mask of FULL field.
	UARTHS_TXDATA_FULL_Msk = 0x80000000
	// Bit FULL.
	UARTHS_TXDATA_FULL = 0x80000000

	// RXDATA: Receive Data Register
	// Position of DATA field.
	UARTHS_RXDATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	UARTHS_RXDATA_DATA_Msk = 0xff
	// Position of EMPTY field.
	UARTHS_RXDATA_EMPTY_Pos = 0x1f
	// Bit mask of EMPTY field.
	UARTHS_RXDATA_EMPTY_Msk = 0x80000000
	// Bit EMPTY.
	UARTHS_RXDATA_EMPTY = 0x80000000

	// TXCTRL: Transmit Control Register
	// Position of TXEN field.
	UARTHS_TXCTRL_TXEN_Pos = 0x0
	// Bit mask of TXEN field.
	UARTHS_TXCTRL_TXEN_Msk = 0x1
	// Bit TXEN.
	UARTHS_TXCTRL_TXEN = 0x1
	// Position of NSTOP field.
	UARTHS_TXCTRL_NSTOP_Pos = 0x1
	// Bit mask of NSTOP field.
	UARTHS_TXCTRL_NSTOP_Msk = 0x2
	// Bit NSTOP.
	UARTHS_TXCTRL_NSTOP = 0x2
	// Position of TXCNT field.
	UARTHS_TXCTRL_TXCNT_Pos = 0x10
	// Bit mask of TXCNT field.
	UARTHS_TXCTRL_TXCNT_Msk = 0x70000

	// RXCTRL: Receive Control Register
	// Position of RXEN field.
	UARTHS_RXCTRL_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	UARTHS_RXCTRL_RXEN_Msk = 0x1
	// Bit RXEN.
	UARTHS_RXCTRL_RXEN = 0x1
	// Position of RXCNT field.
	UARTHS_RXCTRL_RXCNT_Pos = 0x10
	// Bit mask of RXCNT field.
	UARTHS_RXCTRL_RXCNT_Msk = 0x70000

	// IE: Interrupt Enable Register
	// Position of TXWM field.
	UARTHS_IE_TXWM_Pos = 0x0
	// Bit mask of TXWM field.
	UARTHS_IE_TXWM_Msk = 0x1
	// Bit TXWM.
	UARTHS_IE_TXWM = 0x1
	// Position of RXWM field.
	UARTHS_IE_RXWM_Pos = 0x1
	// Bit mask of RXWM field.
	UARTHS_IE_RXWM_Msk = 0x2
	// Bit RXWM.
	UARTHS_IE_RXWM = 0x2

	// IP: Interrupt Pending Register
	// Position of TXWM field.
	UARTHS_IP_TXWM_Pos = 0x0
	// Bit mask of TXWM field.
	UARTHS_IP_TXWM_Msk = 0x1
	// Bit TXWM.
	UARTHS_IP_TXWM = 0x1
	// Position of RXWM field.
	UARTHS_IP_RXWM_Pos = 0x1
	// Bit mask of RXWM field.
	UARTHS_IP_RXWM_Msk = 0x2
	// Bit RXWM.
	UARTHS_IP_RXWM = 0x2

	// DIV: Baud Rate Divisor Register
	// Position of DIV field.
	UARTHS_DIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	UARTHS_DIV_DIV_Msk = 0xffff
)

// Constants for GPIOHS: High-speed GPIO
const (
	// INPUT_VAL: Input Value Register
	// Position of PIN_S field.
	GPIOHS_INPUT_VAL_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_INPUT_VAL_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_INPUT_VAL_PIN_S = 0x1

	// INPUT_EN: Pin Input Enable Register
	// Position of PIN_S field.
	GPIOHS_INPUT_EN_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_INPUT_EN_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_INPUT_EN_PIN_S = 0x1

	// OUTPUT_EN: Pin Output Enable Register
	// Position of PIN_S field.
	GPIOHS_OUTPUT_EN_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_OUTPUT_EN_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_OUTPUT_EN_PIN_S = 0x1

	// OUTPUT_VAL: Output Value Register
	// Position of PIN_S field.
	GPIOHS_OUTPUT_VAL_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_OUTPUT_VAL_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_OUTPUT_VAL_PIN_S = 0x1

	// PULLUP_EN: Internal Pull-Up Enable Register
	// Position of PIN_S field.
	GPIOHS_PULLUP_EN_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_PULLUP_EN_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_PULLUP_EN_PIN_S = 0x1

	// DRIVE: Drive Strength Register
	// Position of PIN_S field.
	GPIOHS_DRIVE_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_DRIVE_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_DRIVE_PIN_S = 0x1

	// RISE_IE: Rise Interrupt Enable Register
	// Position of PIN_S field.
	GPIOHS_RISE_IE_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_RISE_IE_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_RISE_IE_PIN_S = 0x1

	// RISE_IP: Rise Interrupt Pending Register
	// Position of PIN_S field.
	GPIOHS_RISE_IP_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_RISE_IP_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_RISE_IP_PIN_S = 0x1

	// FALL_IE: Fall Interrupt Enable Register
	// Position of PIN_S field.
	GPIOHS_FALL_IE_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_FALL_IE_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_FALL_IE_PIN_S = 0x1

	// FALL_IP: Fall Interrupt Pending Register
	// Position of PIN_S field.
	GPIOHS_FALL_IP_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_FALL_IP_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_FALL_IP_PIN_S = 0x1

	// HIGH_IE: High Interrupt Enable Register
	// Position of PIN_S field.
	GPIOHS_HIGH_IE_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_HIGH_IE_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_HIGH_IE_PIN_S = 0x1

	// HIGH_IP: High Interrupt Pending Register
	// Position of PIN_S field.
	GPIOHS_HIGH_IP_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_HIGH_IP_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_HIGH_IP_PIN_S = 0x1

	// LOW_IE: Low Interrupt Enable Register
	// Position of PIN_S field.
	GPIOHS_LOW_IE_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_LOW_IE_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_LOW_IE_PIN_S = 0x1

	// LOW_IP: Low Interrupt Pending Register
	// Position of PIN_S field.
	GPIOHS_LOW_IP_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_LOW_IP_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_LOW_IP_PIN_S = 0x1

	// IOF_EN: HW I/O Function Enable Register
	// Position of PIN_S field.
	GPIOHS_IOF_EN_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_IOF_EN_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_IOF_EN_PIN_S = 0x1

	// IOF_SEL: HW I/O Function Select Register
	// Position of PIN_S field.
	GPIOHS_IOF_SEL_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_IOF_SEL_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_IOF_SEL_PIN_S = 0x1

	// OUTPUT_XOR: Output XOR (invert) Register
	// Position of PIN_S field.
	GPIOHS_OUTPUT_XOR_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIOHS_OUTPUT_XOR_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIOHS_OUTPUT_XOR_PIN_S = 0x1
)

// Constants for KPU: Neural Network Accelerator
const (
	// INTERRUPT_STATUS: Interrupt status
	// Position of CALC_DONE field.
	KPU_INTERRUPT_STATUS_CALC_DONE_Pos = 0x0
	// Bit mask of CALC_DONE field.
	KPU_INTERRUPT_STATUS_CALC_DONE_Msk = 0x1
	// Bit CALC_DONE.
	KPU_INTERRUPT_STATUS_CALC_DONE = 0x1
	// Position of LAYER_CFG_ALMOST_EMPTY field.
	KPU_INTERRUPT_STATUS_LAYER_CFG_ALMOST_EMPTY_Pos = 0x1
	// Bit mask of LAYER_CFG_ALMOST_EMPTY field.
	KPU_INTERRUPT_STATUS_LAYER_CFG_ALMOST_EMPTY_Msk = 0x2
	// Bit LAYER_CFG_ALMOST_EMPTY.
	KPU_INTERRUPT_STATUS_LAYER_CFG_ALMOST_EMPTY = 0x2
	// Position of LAYER_CFG_ALMOST_FULL field.
	KPU_INTERRUPT_STATUS_LAYER_CFG_ALMOST_FULL_Pos = 0x2
	// Bit mask of LAYER_CFG_ALMOST_FULL field.
	KPU_INTERRUPT_STATUS_LAYER_CFG_ALMOST_FULL_Msk = 0x4
	// Bit LAYER_CFG_ALMOST_FULL.
	KPU_INTERRUPT_STATUS_LAYER_CFG_ALMOST_FULL = 0x4

	// FIFO_THRESHOLD: FIFO threshold
	// Position of FULL_THRESHOLD field.
	KPU_FIFO_THRESHOLD_FULL_THRESHOLD_Pos = 0x0
	// Bit mask of FULL_THRESHOLD field.
	KPU_FIFO_THRESHOLD_FULL_THRESHOLD_Msk = 0xf
	// Position of EMPTY_THRESHOLD field.
	KPU_FIFO_THRESHOLD_EMPTY_THRESHOLD_Pos = 0x4
	// Bit mask of EMPTY_THRESHOLD field.
	KPU_FIFO_THRESHOLD_EMPTY_THRESHOLD_Msk = 0xf0

	// FIFO_CTRL: FIFO control
	// Position of DMA_FIFO_FLUSH_N field.
	KPU_FIFO_CTRL_DMA_FIFO_FLUSH_N_Pos = 0x0
	// Bit mask of DMA_FIFO_FLUSH_N field.
	KPU_FIFO_CTRL_DMA_FIFO_FLUSH_N_Msk = 0x1
	// Bit DMA_FIFO_FLUSH_N.
	KPU_FIFO_CTRL_DMA_FIFO_FLUSH_N = 0x1
	// Position of GS_FIFO_FLUSH_N field.
	KPU_FIFO_CTRL_GS_FIFO_FLUSH_N_Pos = 0x1
	// Bit mask of GS_FIFO_FLUSH_N field.
	KPU_FIFO_CTRL_GS_FIFO_FLUSH_N_Msk = 0x2
	// Bit GS_FIFO_FLUSH_N.
	KPU_FIFO_CTRL_GS_FIFO_FLUSH_N = 0x2
	// Position of CFG_FIFO_FLUSH_N field.
	KPU_FIFO_CTRL_CFG_FIFO_FLUSH_N_Pos = 0x2
	// Bit mask of CFG_FIFO_FLUSH_N field.
	KPU_FIFO_CTRL_CFG_FIFO_FLUSH_N_Msk = 0x4
	// Bit CFG_FIFO_FLUSH_N.
	KPU_FIFO_CTRL_CFG_FIFO_FLUSH_N = 0x4
	// Position of CMD_FIFO_FLUSH_N field.
	KPU_FIFO_CTRL_CMD_FIFO_FLUSH_N_Pos = 0x3
	// Bit mask of CMD_FIFO_FLUSH_N field.
	KPU_FIFO_CTRL_CMD_FIFO_FLUSH_N_Msk = 0x8
	// Bit CMD_FIFO_FLUSH_N.
	KPU_FIFO_CTRL_CMD_FIFO_FLUSH_N = 0x8
	// Position of RESP_FIFO_FLUSH_N field.
	KPU_FIFO_CTRL_RESP_FIFO_FLUSH_N_Pos = 0x4
	// Bit mask of RESP_FIFO_FLUSH_N field.
	KPU_FIFO_CTRL_RESP_FIFO_FLUSH_N_Msk = 0x10
	// Bit RESP_FIFO_FLUSH_N.
	KPU_FIFO_CTRL_RESP_FIFO_FLUSH_N = 0x10

	// EIGHT_BIT_MODE: Eight bit mode
	// Position of EIGHT_BIT_MODE field.
	KPU_EIGHT_BIT_MODE_EIGHT_BIT_MODE_Pos = 0x0
	// Bit mask of EIGHT_BIT_MODE field.
	KPU_EIGHT_BIT_MODE_EIGHT_BIT_MODE_Msk = 0x1
	// Bit EIGHT_BIT_MODE.
	KPU_EIGHT_BIT_MODE_EIGHT_BIT_MODE = 0x1
)

// Constants for FFT: Fast Fourier Transform Accelerator
const (
	// CTRL: FFT control register
	// Position of POINT field.
	FFT_CTRL_POINT_Pos = 0x0
	// Bit mask of POINT field.
	FFT_CTRL_POINT_Msk = 0x7
	// 512 point
	FFT_CTRL_POINT_P512 = 0x0
	// 256 point
	FFT_CTRL_POINT_P256 = 0x1
	// 128 point
	FFT_CTRL_POINT_P128 = 0x2
	// 64 point
	FFT_CTRL_POINT_P64 = 0x3
	// Position of MODE field.
	FFT_CTRL_MODE_Pos = 0x3
	// Bit mask of MODE field.
	FFT_CTRL_MODE_Msk = 0x8
	// Bit MODE.
	FFT_CTRL_MODE = 0x8
	// FFT mode
	FFT_CTRL_MODE_FFT = 0x0
	// Inverse FFT mode
	FFT_CTRL_MODE_IFFT = 0x1
	// Position of SHIFT field.
	FFT_CTRL_SHIFT_Pos = 0x4
	// Bit mask of SHIFT field.
	FFT_CTRL_SHIFT_Msk = 0x1ff0
	// Position of ENABLE field.
	FFT_CTRL_ENABLE_Pos = 0xd
	// Bit mask of ENABLE field.
	FFT_CTRL_ENABLE_Msk = 0x2000
	// Bit ENABLE.
	FFT_CTRL_ENABLE = 0x2000
	// Position of DMA_SEND field.
	FFT_CTRL_DMA_SEND_Pos = 0xe
	// Bit mask of DMA_SEND field.
	FFT_CTRL_DMA_SEND_Msk = 0x4000
	// Bit DMA_SEND.
	FFT_CTRL_DMA_SEND = 0x4000
	// Position of INPUT_MODE field.
	FFT_CTRL_INPUT_MODE_Pos = 0xf
	// Bit mask of INPUT_MODE field.
	FFT_CTRL_INPUT_MODE_Msk = 0x18000
	// RIRI (real imaginary interleaved)
	FFT_CTRL_INPUT_MODE_RIRI = 0x0
	// RRRR (only real part)
	FFT_CTRL_INPUT_MODE_RRRR = 0x1
	// First input the real part and then input the imaginary part
	FFT_CTRL_INPUT_MODE_RRII = 0x2
	// Position of DATA_MODE field.
	FFT_CTRL_DATA_MODE_Pos = 0x11
	// Bit mask of DATA_MODE field.
	FFT_CTRL_DATA_MODE_Msk = 0x20000
	// Bit DATA_MODE.
	FFT_CTRL_DATA_MODE = 0x20000
	// 64 bit effective
	FFT_CTRL_DATA_MODE_WIDTH_64 = 0x0
	// 128 bit effective
	FFT_CTRL_DATA_MODE_WIDTH_128 = 0x1

	// FIFO_CTRL: FIFO control
	// Position of RESP_FIFO_FLUSH field.
	FFT_FIFO_CTRL_RESP_FIFO_FLUSH_Pos = 0x0
	// Bit mask of RESP_FIFO_FLUSH field.
	FFT_FIFO_CTRL_RESP_FIFO_FLUSH_Msk = 0x1
	// Bit RESP_FIFO_FLUSH.
	FFT_FIFO_CTRL_RESP_FIFO_FLUSH = 0x1
	// Position of CMD_FIFO_FLUSH field.
	FFT_FIFO_CTRL_CMD_FIFO_FLUSH_Pos = 0x1
	// Bit mask of CMD_FIFO_FLUSH field.
	FFT_FIFO_CTRL_CMD_FIFO_FLUSH_Msk = 0x2
	// Bit CMD_FIFO_FLUSH.
	FFT_FIFO_CTRL_CMD_FIFO_FLUSH = 0x2
	// Position of GS_FIFO_FLUSH field.
	FFT_FIFO_CTRL_GS_FIFO_FLUSH_Pos = 0x2
	// Bit mask of GS_FIFO_FLUSH field.
	FFT_FIFO_CTRL_GS_FIFO_FLUSH_Msk = 0x4
	// Bit GS_FIFO_FLUSH.
	FFT_FIFO_CTRL_GS_FIFO_FLUSH = 0x4

	// INTR_MASK: interrupt mask
	// Position of FFT_DONE field.
	FFT_INTR_MASK_FFT_DONE_Pos = 0x0
	// Bit mask of FFT_DONE field.
	FFT_INTR_MASK_FFT_DONE_Msk = 0x1
	// Bit FFT_DONE.
	FFT_INTR_MASK_FFT_DONE = 0x1

	// INTR_CLEAR: Interrupt clear
	// Position of FFT_DONE field.
	FFT_INTR_CLEAR_FFT_DONE_Pos = 0x0
	// Bit mask of FFT_DONE field.
	FFT_INTR_CLEAR_FFT_DONE_Msk = 0x1
	// Bit FFT_DONE.
	FFT_INTR_CLEAR_FFT_DONE = 0x1

	// STATUS: FFT status register
	// Position of FFT_DONE field.
	FFT_STATUS_FFT_DONE_Pos = 0x0
	// Bit mask of FFT_DONE field.
	FFT_STATUS_FFT_DONE_Msk = 0x1
	// Bit FFT_DONE.
	FFT_STATUS_FFT_DONE = 0x1

	// STATUS_RAW: FFT status raw
	// Position of FFT_DONE field.
	FFT_STATUS_RAW_FFT_DONE_Pos = 0x0
	// Bit mask of FFT_DONE field.
	FFT_STATUS_RAW_FFT_DONE_Msk = 0x1
	// Bit FFT_DONE.
	FFT_STATUS_RAW_FFT_DONE = 0x1
	// Position of FFT_WORK field.
	FFT_STATUS_RAW_FFT_WORK_Pos = 0x1
	// Bit mask of FFT_WORK field.
	FFT_STATUS_RAW_FFT_WORK_Msk = 0x2
	// Bit FFT_WORK.
	FFT_STATUS_RAW_FFT_WORK = 0x2
)

// Constants for DMAC: Direct Memory Access Controller
const (
	// CFG: Configure Register
	// Position of DMAC_EN field.
	DMAC_CFG_DMAC_EN_Pos = 0x0
	// Bit mask of DMAC_EN field.
	DMAC_CFG_DMAC_EN_Msk = 0x1
	// Bit DMAC_EN.
	DMAC_CFG_DMAC_EN = 0x1
	// Position of INT_EN field.
	DMAC_CFG_INT_EN_Pos = 0x1
	// Bit mask of INT_EN field.
	DMAC_CFG_INT_EN_Msk = 0x2
	// Bit INT_EN.
	DMAC_CFG_INT_EN = 0x2

	// CHEN: Channel Enable Register
	// Position of CH_S_EN field.
	DMAC_CHEN_CH_S_EN_Pos = 0x0
	// Bit mask of CH_S_EN field.
	DMAC_CHEN_CH_S_EN_Msk = 0x1
	// Bit CH_S_EN.
	DMAC_CHEN_CH_S_EN = 0x1
	// Position of CH_S_EN_WE field.
	DMAC_CHEN_CH_S_EN_WE_Pos = 0x8
	// Bit mask of CH_S_EN_WE field.
	DMAC_CHEN_CH_S_EN_WE_Msk = 0x100
	// Bit CH_S_EN_WE.
	DMAC_CHEN_CH_S_EN_WE = 0x100
	// Position of CH_S_SUSP field.
	DMAC_CHEN_CH_S_SUSP_Pos = 0x10
	// Bit mask of CH_S_SUSP field.
	DMAC_CHEN_CH_S_SUSP_Msk = 0x10000
	// Bit CH_S_SUSP.
	DMAC_CHEN_CH_S_SUSP = 0x10000
	// Position of CH_S_SUSP_WE field.
	DMAC_CHEN_CH_S_SUSP_WE_Pos = 0x18
	// Bit mask of CH_S_SUSP_WE field.
	DMAC_CHEN_CH_S_SUSP_WE_Msk = 0x1000000
	// Bit CH_S_SUSP_WE.
	DMAC_CHEN_CH_S_SUSP_WE = 0x1000000
	// Position of CH_S_ABORT field.
	DMAC_CHEN_CH_S_ABORT_Pos = 0x20
	// Bit mask of CH_S_ABORT field.
	DMAC_CHEN_CH_S_ABORT_Msk = 0x100000000
	// Bit CH_S_ABORT.
	DMAC_CHEN_CH_S_ABORT = 0x100000000
	// Position of CH_S_ABORT_WE field.
	DMAC_CHEN_CH_S_ABORT_WE_Pos = 0x28
	// Bit mask of CH_S_ABORT_WE field.
	DMAC_CHEN_CH_S_ABORT_WE_Msk = 0x10000000000
	// Bit CH_S_ABORT_WE.
	DMAC_CHEN_CH_S_ABORT_WE = 0x10000000000

	// INTSTATUS: Interrupt Status Register
	// Position of CH_S_INTSTAT field.
	DMAC_INTSTATUS_CH_S_INTSTAT_Pos = 0x0
	// Bit mask of CH_S_INTSTAT field.
	DMAC_INTSTATUS_CH_S_INTSTAT_Msk = 0x1
	// Bit CH_S_INTSTAT.
	DMAC_INTSTATUS_CH_S_INTSTAT = 0x1
	// Position of COMMONREG_INTSTAT field.
	DMAC_INTSTATUS_COMMONREG_INTSTAT_Pos = 0x10
	// Bit mask of COMMONREG_INTSTAT field.
	DMAC_INTSTATUS_COMMONREG_INTSTAT_Msk = 0x10000
	// Bit COMMONREG_INTSTAT.
	DMAC_INTSTATUS_COMMONREG_INTSTAT = 0x10000

	// COM_INTCLEAR: Common Interrupt Clear Register
	// Position of SLVIF_DEC_ERR field.
	DMAC_COM_INTCLEAR_SLVIF_DEC_ERR_Pos = 0x0
	// Bit mask of SLVIF_DEC_ERR field.
	DMAC_COM_INTCLEAR_SLVIF_DEC_ERR_Msk = 0x1
	// Bit SLVIF_DEC_ERR.
	DMAC_COM_INTCLEAR_SLVIF_DEC_ERR = 0x1
	// Position of SLVIF_WR2RO_ERR field.
	DMAC_COM_INTCLEAR_SLVIF_WR2RO_ERR_Pos = 0x1
	// Bit mask of SLVIF_WR2RO_ERR field.
	DMAC_COM_INTCLEAR_SLVIF_WR2RO_ERR_Msk = 0x2
	// Bit SLVIF_WR2RO_ERR.
	DMAC_COM_INTCLEAR_SLVIF_WR2RO_ERR = 0x2
	// Position of SLVIF_RD2WO_ERR field.
	DMAC_COM_INTCLEAR_SLVIF_RD2WO_ERR_Pos = 0x2
	// Bit mask of SLVIF_RD2WO_ERR field.
	DMAC_COM_INTCLEAR_SLVIF_RD2WO_ERR_Msk = 0x4
	// Bit SLVIF_RD2WO_ERR.
	DMAC_COM_INTCLEAR_SLVIF_RD2WO_ERR = 0x4
	// Position of SLVIF_WRONHOLD_ERR field.
	DMAC_COM_INTCLEAR_SLVIF_WRONHOLD_ERR_Pos = 0x3
	// Bit mask of SLVIF_WRONHOLD_ERR field.
	DMAC_COM_INTCLEAR_SLVIF_WRONHOLD_ERR_Msk = 0x8
	// Bit SLVIF_WRONHOLD_ERR.
	DMAC_COM_INTCLEAR_SLVIF_WRONHOLD_ERR = 0x8
	// Position of SLVIF_UNDEFINEDREG_DEC_ERR field.
	DMAC_COM_INTCLEAR_SLVIF_UNDEFINEDREG_DEC_ERR_Pos = 0x8
	// Bit mask of SLVIF_UNDEFINEDREG_DEC_ERR field.
	DMAC_COM_INTCLEAR_SLVIF_UNDEFINEDREG_DEC_ERR_Msk = 0x100
	// Bit SLVIF_UNDEFINEDREG_DEC_ERR.
	DMAC_COM_INTCLEAR_SLVIF_UNDEFINEDREG_DEC_ERR = 0x100

	// COM_INTSTATUS_EN: Common Interrupt Status Enable Register
	// Position of SLVIF_DEC_ERR field.
	DMAC_COM_INTSTATUS_EN_SLVIF_DEC_ERR_Pos = 0x0
	// Bit mask of SLVIF_DEC_ERR field.
	DMAC_COM_INTSTATUS_EN_SLVIF_DEC_ERR_Msk = 0x1
	// Bit SLVIF_DEC_ERR.
	DMAC_COM_INTSTATUS_EN_SLVIF_DEC_ERR = 0x1
	// Position of SLVIF_WR2RO_ERR field.
	DMAC_COM_INTSTATUS_EN_SLVIF_WR2RO_ERR_Pos = 0x1
	// Bit mask of SLVIF_WR2RO_ERR field.
	DMAC_COM_INTSTATUS_EN_SLVIF_WR2RO_ERR_Msk = 0x2
	// Bit SLVIF_WR2RO_ERR.
	DMAC_COM_INTSTATUS_EN_SLVIF_WR2RO_ERR = 0x2
	// Position of SLVIF_RD2WO_ERR field.
	DMAC_COM_INTSTATUS_EN_SLVIF_RD2WO_ERR_Pos = 0x2
	// Bit mask of SLVIF_RD2WO_ERR field.
	DMAC_COM_INTSTATUS_EN_SLVIF_RD2WO_ERR_Msk = 0x4
	// Bit SLVIF_RD2WO_ERR.
	DMAC_COM_INTSTATUS_EN_SLVIF_RD2WO_ERR = 0x4
	// Position of SLVIF_WRONHOLD_ERR field.
	DMAC_COM_INTSTATUS_EN_SLVIF_WRONHOLD_ERR_Pos = 0x3
	// Bit mask of SLVIF_WRONHOLD_ERR field.
	DMAC_COM_INTSTATUS_EN_SLVIF_WRONHOLD_ERR_Msk = 0x8
	// Bit SLVIF_WRONHOLD_ERR.
	DMAC_COM_INTSTATUS_EN_SLVIF_WRONHOLD_ERR = 0x8
	// Position of SLVIF_UNDEFINEDREG_DEC_ERR field.
	DMAC_COM_INTSTATUS_EN_SLVIF_UNDEFINEDREG_DEC_ERR_Pos = 0x8
	// Bit mask of SLVIF_UNDEFINEDREG_DEC_ERR field.
	DMAC_COM_INTSTATUS_EN_SLVIF_UNDEFINEDREG_DEC_ERR_Msk = 0x100
	// Bit SLVIF_UNDEFINEDREG_DEC_ERR.
	DMAC_COM_INTSTATUS_EN_SLVIF_UNDEFINEDREG_DEC_ERR = 0x100

	// COM_INTSIGNAL_EN: Common Interrupt Signal Enable Register
	// Position of SLVIF_DEC_ERR field.
	DMAC_COM_INTSIGNAL_EN_SLVIF_DEC_ERR_Pos = 0x0
	// Bit mask of SLVIF_DEC_ERR field.
	DMAC_COM_INTSIGNAL_EN_SLVIF_DEC_ERR_Msk = 0x1
	// Bit SLVIF_DEC_ERR.
	DMAC_COM_INTSIGNAL_EN_SLVIF_DEC_ERR = 0x1
	// Position of SLVIF_WR2RO_ERR field.
	DMAC_COM_INTSIGNAL_EN_SLVIF_WR2RO_ERR_Pos = 0x1
	// Bit mask of SLVIF_WR2RO_ERR field.
	DMAC_COM_INTSIGNAL_EN_SLVIF_WR2RO_ERR_Msk = 0x2
	// Bit SLVIF_WR2RO_ERR.
	DMAC_COM_INTSIGNAL_EN_SLVIF_WR2RO_ERR = 0x2
	// Position of SLVIF_RD2WO_ERR field.
	DMAC_COM_INTSIGNAL_EN_SLVIF_RD2WO_ERR_Pos = 0x2
	// Bit mask of SLVIF_RD2WO_ERR field.
	DMAC_COM_INTSIGNAL_EN_SLVIF_RD2WO_ERR_Msk = 0x4
	// Bit SLVIF_RD2WO_ERR.
	DMAC_COM_INTSIGNAL_EN_SLVIF_RD2WO_ERR = 0x4
	// Position of SLVIF_WRONHOLD_ERR field.
	DMAC_COM_INTSIGNAL_EN_SLVIF_WRONHOLD_ERR_Pos = 0x3
	// Bit mask of SLVIF_WRONHOLD_ERR field.
	DMAC_COM_INTSIGNAL_EN_SLVIF_WRONHOLD_ERR_Msk = 0x8
	// Bit SLVIF_WRONHOLD_ERR.
	DMAC_COM_INTSIGNAL_EN_SLVIF_WRONHOLD_ERR = 0x8
	// Position of SLVIF_UNDEFINEDREG_DEC_ERR field.
	DMAC_COM_INTSIGNAL_EN_SLVIF_UNDEFINEDREG_DEC_ERR_Pos = 0x8
	// Bit mask of SLVIF_UNDEFINEDREG_DEC_ERR field.
	DMAC_COM_INTSIGNAL_EN_SLVIF_UNDEFINEDREG_DEC_ERR_Msk = 0x100
	// Bit SLVIF_UNDEFINEDREG_DEC_ERR.
	DMAC_COM_INTSIGNAL_EN_SLVIF_UNDEFINEDREG_DEC_ERR = 0x100

	// COM_INTSTATUS: Common Interrupt Status
	// Position of SLVIF_DEC_ERR field.
	DMAC_COM_INTSTATUS_SLVIF_DEC_ERR_Pos = 0x0
	// Bit mask of SLVIF_DEC_ERR field.
	DMAC_COM_INTSTATUS_SLVIF_DEC_ERR_Msk = 0x1
	// Bit SLVIF_DEC_ERR.
	DMAC_COM_INTSTATUS_SLVIF_DEC_ERR = 0x1
	// Position of SLVIF_WR2RO_ERR field.
	DMAC_COM_INTSTATUS_SLVIF_WR2RO_ERR_Pos = 0x1
	// Bit mask of SLVIF_WR2RO_ERR field.
	DMAC_COM_INTSTATUS_SLVIF_WR2RO_ERR_Msk = 0x2
	// Bit SLVIF_WR2RO_ERR.
	DMAC_COM_INTSTATUS_SLVIF_WR2RO_ERR = 0x2
	// Position of SLVIF_RD2WO_ERR field.
	DMAC_COM_INTSTATUS_SLVIF_RD2WO_ERR_Pos = 0x2
	// Bit mask of SLVIF_RD2WO_ERR field.
	DMAC_COM_INTSTATUS_SLVIF_RD2WO_ERR_Msk = 0x4
	// Bit SLVIF_RD2WO_ERR.
	DMAC_COM_INTSTATUS_SLVIF_RD2WO_ERR = 0x4
	// Position of SLVIF_WRONHOLD_ERR field.
	DMAC_COM_INTSTATUS_SLVIF_WRONHOLD_ERR_Pos = 0x3
	// Bit mask of SLVIF_WRONHOLD_ERR field.
	DMAC_COM_INTSTATUS_SLVIF_WRONHOLD_ERR_Msk = 0x8
	// Bit SLVIF_WRONHOLD_ERR.
	DMAC_COM_INTSTATUS_SLVIF_WRONHOLD_ERR = 0x8
	// Position of SLVIF_UNDEFINEDREG_DEC_ERR field.
	DMAC_COM_INTSTATUS_SLVIF_UNDEFINEDREG_DEC_ERR_Pos = 0x8
	// Bit mask of SLVIF_UNDEFINEDREG_DEC_ERR field.
	DMAC_COM_INTSTATUS_SLVIF_UNDEFINEDREG_DEC_ERR_Msk = 0x100
	// Bit SLVIF_UNDEFINEDREG_DEC_ERR.
	DMAC_COM_INTSTATUS_SLVIF_UNDEFINEDREG_DEC_ERR = 0x100

	// RESET: Reset register
	// Position of RST field.
	DMAC_RESET_RST_Pos = 0x0
	// Bit mask of RST field.
	DMAC_RESET_RST_Msk = 0x1
	// Bit RST.
	DMAC_RESET_RST = 0x1

	// CHANNEL.SAR: SAR Address Register

	// CHANNEL.DAR: DAR Address Register

	// CHANNEL.BLOCK_TS: Block Transfer Size Register
	// Position of BLOCK_TS field.
	DMAC_channel_BLOCK_TS_BLOCK_TS_Pos = 0x0
	// Bit mask of BLOCK_TS field.
	DMAC_channel_BLOCK_TS_BLOCK_TS_Msk = 0x3fffff

	// CHANNEL.CTL: Control Register
	// Position of SMS field.
	DMAC_channel_CTL_SMS_Pos = 0x0
	// Bit mask of SMS field.
	DMAC_channel_CTL_SMS_Msk = 0x1
	// Bit SMS.
	DMAC_channel_CTL_SMS = 0x1
	// AXI master 1
	DMAC_channel_CTL_SMS_AXI_MASTER_1 = 0x0
	// AXI master 2
	DMAC_channel_CTL_SMS_AXI_MASTER_2 = 0x1
	// Position of DMS field.
	DMAC_channel_CTL_DMS_Pos = 0x2
	// Bit mask of DMS field.
	DMAC_channel_CTL_DMS_Msk = 0x4
	// Bit DMS.
	DMAC_channel_CTL_DMS = 0x4
	// AXI master 1
	DMAC_channel_CTL_DMS_AXI_MASTER_1 = 0x0
	// AXI master 2
	DMAC_channel_CTL_DMS_AXI_MASTER_2 = 0x1
	// Position of SINC field.
	DMAC_channel_CTL_SINC_Pos = 0x4
	// Bit mask of SINC field.
	DMAC_channel_CTL_SINC_Msk = 0x10
	// Bit SINC.
	DMAC_channel_CTL_SINC = 0x10
	// Increment address
	DMAC_channel_CTL_SINC_INCREMENT = 0x0
	// Don't increment address
	DMAC_channel_CTL_SINC_NOCHANGE = 0x1
	// Position of DINC field.
	DMAC_channel_CTL_DINC_Pos = 0x6
	// Bit mask of DINC field.
	DMAC_channel_CTL_DINC_Msk = 0x40
	// Bit DINC.
	DMAC_channel_CTL_DINC = 0x40
	// Increment address
	DMAC_channel_CTL_DINC_INCREMENT = 0x0
	// Don't increment address
	DMAC_channel_CTL_DINC_NOCHANGE = 0x1
	// Position of SRC_TR_WIDTH field.
	DMAC_channel_CTL_SRC_TR_WIDTH_Pos = 0x8
	// Bit mask of SRC_TR_WIDTH field.
	DMAC_channel_CTL_SRC_TR_WIDTH_Msk = 0x700
	// 8 bits
	DMAC_channel_CTL_SRC_TR_WIDTH_WIDTH_8 = 0x0
	// 16 bits
	DMAC_channel_CTL_SRC_TR_WIDTH_WIDTH_16 = 0x1
	// 32 bits
	DMAC_channel_CTL_SRC_TR_WIDTH_WIDTH_32 = 0x2
	// 64 bits
	DMAC_channel_CTL_SRC_TR_WIDTH_WIDTH_64 = 0x3
	// 128 bits
	DMAC_channel_CTL_SRC_TR_WIDTH_WIDTH_128 = 0x4
	// 256 bits
	DMAC_channel_CTL_SRC_TR_WIDTH_WIDTH_256 = 0x5
	// 512 bits
	DMAC_channel_CTL_SRC_TR_WIDTH_WIDTH_512 = 0x6
	// Position of DST_TR_WIDTH field.
	DMAC_channel_CTL_DST_TR_WIDTH_Pos = 0xb
	// Bit mask of DST_TR_WIDTH field.
	DMAC_channel_CTL_DST_TR_WIDTH_Msk = 0x3800
	// 8 bits
	DMAC_channel_CTL_DST_TR_WIDTH_WIDTH_8 = 0x0
	// 16 bits
	DMAC_channel_CTL_DST_TR_WIDTH_WIDTH_16 = 0x1
	// 32 bits
	DMAC_channel_CTL_DST_TR_WIDTH_WIDTH_32 = 0x2
	// 64 bits
	DMAC_channel_CTL_DST_TR_WIDTH_WIDTH_64 = 0x3
	// 128 bits
	DMAC_channel_CTL_DST_TR_WIDTH_WIDTH_128 = 0x4
	// 256 bits
	DMAC_channel_CTL_DST_TR_WIDTH_WIDTH_256 = 0x5
	// 512 bits
	DMAC_channel_CTL_DST_TR_WIDTH_WIDTH_512 = 0x6
	// Position of SRC_MSIZE field.
	DMAC_channel_CTL_SRC_MSIZE_Pos = 0xe
	// Bit mask of SRC_MSIZE field.
	DMAC_channel_CTL_SRC_MSIZE_Msk = 0x3c000
	// 1 data item
	DMAC_channel_CTL_SRC_MSIZE_LENGTH_1 = 0x0
	// 4 data items
	DMAC_channel_CTL_SRC_MSIZE_LENGTH_4 = 0x1
	// 8 data items
	DMAC_channel_CTL_SRC_MSIZE_LENGTH_8 = 0x2
	// 16 data items
	DMAC_channel_CTL_SRC_MSIZE_LENGTH_16 = 0x3
	// 32 data items
	DMAC_channel_CTL_SRC_MSIZE_LENGTH_32 = 0x4
	// 64 data items
	DMAC_channel_CTL_SRC_MSIZE_LENGTH_64 = 0x5
	// 128 data items
	DMAC_channel_CTL_SRC_MSIZE_LENGTH_128 = 0x6
	// 256 data items
	DMAC_channel_CTL_SRC_MSIZE_LENGTH_256 = 0x7
	// 512 data items
	DMAC_channel_CTL_SRC_MSIZE_LENGTH_512 = 0x8
	// 1024 data items
	DMAC_channel_CTL_SRC_MSIZE_LENGTH_1024 = 0x9
	// Position of DST_MSIZE field.
	DMAC_channel_CTL_DST_MSIZE_Pos = 0x12
	// Bit mask of DST_MSIZE field.
	DMAC_channel_CTL_DST_MSIZE_Msk = 0x3c0000
	// 1 data item
	DMAC_channel_CTL_DST_MSIZE_LENGTH_1 = 0x0
	// 4 data items
	DMAC_channel_CTL_DST_MSIZE_LENGTH_4 = 0x1
	// 8 data items
	DMAC_channel_CTL_DST_MSIZE_LENGTH_8 = 0x2
	// 16 data items
	DMAC_channel_CTL_DST_MSIZE_LENGTH_16 = 0x3
	// 32 data items
	DMAC_channel_CTL_DST_MSIZE_LENGTH_32 = 0x4
	// 64 data items
	DMAC_channel_CTL_DST_MSIZE_LENGTH_64 = 0x5
	// 128 data items
	DMAC_channel_CTL_DST_MSIZE_LENGTH_128 = 0x6
	// 256 data items
	DMAC_channel_CTL_DST_MSIZE_LENGTH_256 = 0x7
	// 512 data items
	DMAC_channel_CTL_DST_MSIZE_LENGTH_512 = 0x8
	// 1024 data items
	DMAC_channel_CTL_DST_MSIZE_LENGTH_1024 = 0x9
	// Position of NONPOSTED_LASTWRITE_EN field.
	DMAC_channel_CTL_NONPOSTED_LASTWRITE_EN_Pos = 0x1e
	// Bit mask of NONPOSTED_LASTWRITE_EN field.
	DMAC_channel_CTL_NONPOSTED_LASTWRITE_EN_Msk = 0x40000000
	// Bit NONPOSTED_LASTWRITE_EN.
	DMAC_channel_CTL_NONPOSTED_LASTWRITE_EN = 0x40000000
	// Position of ARLEN_EN field.
	DMAC_channel_CTL_ARLEN_EN_Pos = 0x26
	// Bit mask of ARLEN_EN field.
	DMAC_channel_CTL_ARLEN_EN_Msk = 0x4000000000
	// Bit ARLEN_EN.
	DMAC_channel_CTL_ARLEN_EN = 0x4000000000
	// Position of ARLEN field.
	DMAC_channel_CTL_ARLEN_Pos = 0x27
	// Bit mask of ARLEN field.
	DMAC_channel_CTL_ARLEN_Msk = 0x7f8000000000
	// Position of AWLEN_EN field.
	DMAC_channel_CTL_AWLEN_EN_Pos = 0x2f
	// Bit mask of AWLEN_EN field.
	DMAC_channel_CTL_AWLEN_EN_Msk = 0x800000000000
	// Bit AWLEN_EN.
	DMAC_channel_CTL_AWLEN_EN = 0x800000000000
	// Position of AWLEN field.
	DMAC_channel_CTL_AWLEN_Pos = 0x30
	// Bit mask of AWLEN field.
	DMAC_channel_CTL_AWLEN_Msk = 0xff000000000000
	// Position of SRC_STAT_EN field.
	DMAC_channel_CTL_SRC_STAT_EN_Pos = 0x38
	// Bit mask of SRC_STAT_EN field.
	DMAC_channel_CTL_SRC_STAT_EN_Msk = 0x100000000000000
	// Bit SRC_STAT_EN.
	DMAC_channel_CTL_SRC_STAT_EN = 0x100000000000000
	// Position of DST_STAT_EN field.
	DMAC_channel_CTL_DST_STAT_EN_Pos = 0x39
	// Bit mask of DST_STAT_EN field.
	DMAC_channel_CTL_DST_STAT_EN_Msk = 0x200000000000000
	// Bit DST_STAT_EN.
	DMAC_channel_CTL_DST_STAT_EN = 0x200000000000000
	// Position of IOC_BLKTFR field.
	DMAC_channel_CTL_IOC_BLKTFR_Pos = 0x3a
	// Bit mask of IOC_BLKTFR field.
	DMAC_channel_CTL_IOC_BLKTFR_Msk = 0x400000000000000
	// Bit IOC_BLKTFR.
	DMAC_channel_CTL_IOC_BLKTFR = 0x400000000000000
	// Position of SHADOWREG_OR_LLI_LAST field.
	DMAC_channel_CTL_SHADOWREG_OR_LLI_LAST_Pos = 0x3e
	// Bit mask of SHADOWREG_OR_LLI_LAST field.
	DMAC_channel_CTL_SHADOWREG_OR_LLI_LAST_Msk = 0x4000000000000000
	// Bit SHADOWREG_OR_LLI_LAST.
	DMAC_channel_CTL_SHADOWREG_OR_LLI_LAST = 0x4000000000000000
	// Position of SHADOWREG_OR_LLI_VALID field.
	DMAC_channel_CTL_SHADOWREG_OR_LLI_VALID_Pos = 0x3f
	// Bit mask of SHADOWREG_OR_LLI_VALID field.
	DMAC_channel_CTL_SHADOWREG_OR_LLI_VALID_Msk = 0x8000000000000000
	// Bit SHADOWREG_OR_LLI_VALID.
	DMAC_channel_CTL_SHADOWREG_OR_LLI_VALID = 0x8000000000000000

	// CHANNEL.CFG: Configure Register
	// Position of SRC_MULTBLK_TYPE field.
	DMAC_channel_CFG_SRC_MULTBLK_TYPE_Pos = 0x0
	// Bit mask of SRC_MULTBLK_TYPE field.
	DMAC_channel_CFG_SRC_MULTBLK_TYPE_Msk = 0x3
	// Continuous multi-block type
	DMAC_channel_CFG_SRC_MULTBLK_TYPE_CONTIGUOUS = 0x0
	// Reload multi-block type
	DMAC_channel_CFG_SRC_MULTBLK_TYPE_RELOAD = 0x1
	// Shadow register based multi-block type
	DMAC_channel_CFG_SRC_MULTBLK_TYPE_SHADOW_REGISTER = 0x2
	// Linked list based multi-block type
	DMAC_channel_CFG_SRC_MULTBLK_TYPE_LINKED_LIST = 0x3
	// Position of DST_MULTBLK_TYPE field.
	DMAC_channel_CFG_DST_MULTBLK_TYPE_Pos = 0x2
	// Bit mask of DST_MULTBLK_TYPE field.
	DMAC_channel_CFG_DST_MULTBLK_TYPE_Msk = 0xc
	// Continuous multi-block type
	DMAC_channel_CFG_DST_MULTBLK_TYPE_CONTIGUOUS = 0x0
	// Reload multi-block type
	DMAC_channel_CFG_DST_MULTBLK_TYPE_RELOAD = 0x1
	// Shadow register based multi-block type
	DMAC_channel_CFG_DST_MULTBLK_TYPE_SHADOW_REGISTER = 0x2
	// Linked list based multi-block type
	DMAC_channel_CFG_DST_MULTBLK_TYPE_LINKED_LIST = 0x3
	// Position of TT_FC field.
	DMAC_channel_CFG_TT_FC_Pos = 0x20
	// Bit mask of TT_FC field.
	DMAC_channel_CFG_TT_FC_Msk = 0x700000000
	// Transfer memory to memory and flow controller is DMAC
	DMAC_channel_CFG_TT_FC_MEM2MEM_DMA = 0x0
	// Transfer memory to peripheral and flow controller is DMAC
	DMAC_channel_CFG_TT_FC_MEM2PRF_DMA = 0x1
	// Transfer peripheral to memory and flow controller is DMAC
	DMAC_channel_CFG_TT_FC_PRF2MEM_DMA = 0x2
	// Transfer peripheral to peripheral and flow controller is DMAC
	DMAC_channel_CFG_TT_FC_PRF2PRF_DMA = 0x3
	// Transfer peripheral to memory and flow controller is source peripheral
	DMAC_channel_CFG_TT_FC_PRF2MEM_PRF = 0x4
	// Transfer peripheral to peripheral and flow controller is source peripheral
	DMAC_channel_CFG_TT_FC_PRF2PRF_SRCPRF = 0x5
	// Transfer memory to peripheral and flow controller is destination peripheral
	DMAC_channel_CFG_TT_FC_MEM2PRF_PRF = 0x6
	// Transfer peripheral to peripheral and flow controller is destination peripheral
	DMAC_channel_CFG_TT_FC_PRF2PRF_DSTPRF = 0x7
	// Position of HS_SEL_SRC field.
	DMAC_channel_CFG_HS_SEL_SRC_Pos = 0x23
	// Bit mask of HS_SEL_SRC field.
	DMAC_channel_CFG_HS_SEL_SRC_Msk = 0x800000000
	// Bit HS_SEL_SRC.
	DMAC_channel_CFG_HS_SEL_SRC = 0x800000000
	// Hardware handshaking is used
	DMAC_channel_CFG_HS_SEL_SRC_HARDWARE = 0x0
	// Software handshaking is used
	DMAC_channel_CFG_HS_SEL_SRC_SOFTWARE = 0x1
	// Position of HS_SEL_DST field.
	DMAC_channel_CFG_HS_SEL_DST_Pos = 0x24
	// Bit mask of HS_SEL_DST field.
	DMAC_channel_CFG_HS_SEL_DST_Msk = 0x1000000000
	// Bit HS_SEL_DST.
	DMAC_channel_CFG_HS_SEL_DST = 0x1000000000
	// Hardware handshaking is used
	DMAC_channel_CFG_HS_SEL_DST_HARDWARE = 0x0
	// Software handshaking is used
	DMAC_channel_CFG_HS_SEL_DST_SOFTWARE = 0x1
	// Position of SRC_HWHS_POL field.
	DMAC_channel_CFG_SRC_HWHS_POL_Pos = 0x25
	// Bit mask of SRC_HWHS_POL field.
	DMAC_channel_CFG_SRC_HWHS_POL_Msk = 0x2000000000
	// Bit SRC_HWHS_POL.
	DMAC_channel_CFG_SRC_HWHS_POL = 0x2000000000
	// Active high
	DMAC_channel_CFG_SRC_HWHS_POL_ACTIVE_HIGH = 0x0
	// Active low
	DMAC_channel_CFG_SRC_HWHS_POL_ACTIVE_LOW = 0x1
	// Position of DST_HWHS_POL field.
	DMAC_channel_CFG_DST_HWHS_POL_Pos = 0x26
	// Bit mask of DST_HWHS_POL field.
	DMAC_channel_CFG_DST_HWHS_POL_Msk = 0x4000000000
	// Bit DST_HWHS_POL.
	DMAC_channel_CFG_DST_HWHS_POL = 0x4000000000
	// Active high
	DMAC_channel_CFG_DST_HWHS_POL_ACTIVE_HIGH = 0x0
	// Active low
	DMAC_channel_CFG_DST_HWHS_POL_ACTIVE_LOW = 0x1
	// Position of SRC_PER field.
	DMAC_channel_CFG_SRC_PER_Pos = 0x27
	// Bit mask of SRC_PER field.
	DMAC_channel_CFG_SRC_PER_Msk = 0x78000000000
	// Position of DST_PER field.
	DMAC_channel_CFG_DST_PER_Pos = 0x2c
	// Bit mask of DST_PER field.
	DMAC_channel_CFG_DST_PER_Msk = 0xf00000000000
	// Position of CH_PRIOR field.
	DMAC_channel_CFG_CH_PRIOR_Pos = 0x31
	// Bit mask of CH_PRIOR field.
	DMAC_channel_CFG_CH_PRIOR_Msk = 0xe000000000000
	// Position of LOCK_CH field.
	DMAC_channel_CFG_LOCK_CH_Pos = 0x34
	// Bit mask of LOCK_CH field.
	DMAC_channel_CFG_LOCK_CH_Msk = 0x10000000000000
	// Bit LOCK_CH.
	DMAC_channel_CFG_LOCK_CH = 0x10000000000000
	// Position of LOCK_CH_L field.
	DMAC_channel_CFG_LOCK_CH_L_Pos = 0x35
	// Bit mask of LOCK_CH_L field.
	DMAC_channel_CFG_LOCK_CH_L_Msk = 0x60000000000000
	// Duration of channel is locked for entire DMA transfer
	DMAC_channel_CFG_LOCK_CH_L_DMA_TRANSFER = 0x0
	// Duration of channel is locked for current block transfer
	DMAC_channel_CFG_LOCK_CH_L_BLOCK_TRANSFER = 0x1
	// Duration of channel is locked for current transaction
	DMAC_channel_CFG_LOCK_CH_L_TRANSACTION = 0x2
	// Position of SRC_OSR_LMT field.
	DMAC_channel_CFG_SRC_OSR_LMT_Pos = 0x37
	// Bit mask of SRC_OSR_LMT field.
	DMAC_channel_CFG_SRC_OSR_LMT_Msk = 0x780000000000000
	// Position of DST_OSR_LMT field.
	DMAC_channel_CFG_DST_OSR_LMT_Pos = 0x3b
	// Bit mask of DST_OSR_LMT field.
	DMAC_channel_CFG_DST_OSR_LMT_Msk = 0x7800000000000000

	// CHANNEL.LLP: Linked List Pointer register
	// Position of LMS field.
	DMAC_channel_LLP_LMS_Pos = 0x0
	// Bit mask of LMS field.
	DMAC_channel_LLP_LMS_Msk = 0x1
	// Bit LMS.
	DMAC_channel_LLP_LMS = 0x1
	// Position of LOC field.
	DMAC_channel_LLP_LOC_Pos = 0x6
	// Bit mask of LOC field.
	DMAC_channel_LLP_LOC_Msk = 0xffffffffffffffc0

	// CHANNEL.STATUS: Channel Status Register
	// Position of CMPLTD_BLK_SIZE field.
	DMAC_channel_STATUS_CMPLTD_BLK_SIZE_Pos = 0x0
	// Bit mask of CMPLTD_BLK_SIZE field.
	DMAC_channel_STATUS_CMPLTD_BLK_SIZE_Msk = 0x3fffff

	// CHANNEL.SWHSSRC: Channel Software handshake Source Register
	// Position of REQ field.
	DMAC_channel_SWHSSRC_REQ_Pos = 0x0
	// Bit mask of REQ field.
	DMAC_channel_SWHSSRC_REQ_Msk = 0x1
	// Bit REQ.
	DMAC_channel_SWHSSRC_REQ = 0x1
	// Position of REQ_WE field.
	DMAC_channel_SWHSSRC_REQ_WE_Pos = 0x1
	// Bit mask of REQ_WE field.
	DMAC_channel_SWHSSRC_REQ_WE_Msk = 0x2
	// Bit REQ_WE.
	DMAC_channel_SWHSSRC_REQ_WE = 0x2
	// Position of SGLREQ field.
	DMAC_channel_SWHSSRC_SGLREQ_Pos = 0x2
	// Bit mask of SGLREQ field.
	DMAC_channel_SWHSSRC_SGLREQ_Msk = 0x4
	// Bit SGLREQ.
	DMAC_channel_SWHSSRC_SGLREQ = 0x4
	// Position of SGLREQ_WE field.
	DMAC_channel_SWHSSRC_SGLREQ_WE_Pos = 0x3
	// Bit mask of SGLREQ_WE field.
	DMAC_channel_SWHSSRC_SGLREQ_WE_Msk = 0x8
	// Bit SGLREQ_WE.
	DMAC_channel_SWHSSRC_SGLREQ_WE = 0x8
	// Position of LST field.
	DMAC_channel_SWHSSRC_LST_Pos = 0x4
	// Bit mask of LST field.
	DMAC_channel_SWHSSRC_LST_Msk = 0x10
	// Bit LST.
	DMAC_channel_SWHSSRC_LST = 0x10
	// Position of LST_WE field.
	DMAC_channel_SWHSSRC_LST_WE_Pos = 0x5
	// Bit mask of LST_WE field.
	DMAC_channel_SWHSSRC_LST_WE_Msk = 0x20
	// Bit LST_WE.
	DMAC_channel_SWHSSRC_LST_WE = 0x20

	// CHANNEL.SWHSDST: Channel Software handshake Destination Register
	// Position of REQ field.
	DMAC_channel_SWHSDST_REQ_Pos = 0x0
	// Bit mask of REQ field.
	DMAC_channel_SWHSDST_REQ_Msk = 0x1
	// Bit REQ.
	DMAC_channel_SWHSDST_REQ = 0x1
	// Position of REQ_WE field.
	DMAC_channel_SWHSDST_REQ_WE_Pos = 0x1
	// Bit mask of REQ_WE field.
	DMAC_channel_SWHSDST_REQ_WE_Msk = 0x2
	// Bit REQ_WE.
	DMAC_channel_SWHSDST_REQ_WE = 0x2
	// Position of SGLREQ field.
	DMAC_channel_SWHSDST_SGLREQ_Pos = 0x2
	// Bit mask of SGLREQ field.
	DMAC_channel_SWHSDST_SGLREQ_Msk = 0x4
	// Bit SGLREQ.
	DMAC_channel_SWHSDST_SGLREQ = 0x4
	// Position of SGLREQ_WE field.
	DMAC_channel_SWHSDST_SGLREQ_WE_Pos = 0x3
	// Bit mask of SGLREQ_WE field.
	DMAC_channel_SWHSDST_SGLREQ_WE_Msk = 0x8
	// Bit SGLREQ_WE.
	DMAC_channel_SWHSDST_SGLREQ_WE = 0x8
	// Position of LST field.
	DMAC_channel_SWHSDST_LST_Pos = 0x4
	// Bit mask of LST field.
	DMAC_channel_SWHSDST_LST_Msk = 0x10
	// Bit LST.
	DMAC_channel_SWHSDST_LST = 0x10
	// Position of LST_WE field.
	DMAC_channel_SWHSDST_LST_WE_Pos = 0x5
	// Bit mask of LST_WE field.
	DMAC_channel_SWHSDST_LST_WE_Msk = 0x20
	// Bit LST_WE.
	DMAC_channel_SWHSDST_LST_WE = 0x20

	// CHANNEL.BLK_TFR: Channel Block Transfer Resume Request Register
	// Position of RESUMEREQ field.
	DMAC_channel_BLK_TFR_RESUMEREQ_Pos = 0x0
	// Bit mask of RESUMEREQ field.
	DMAC_channel_BLK_TFR_RESUMEREQ_Msk = 0x1
	// Bit RESUMEREQ.
	DMAC_channel_BLK_TFR_RESUMEREQ = 0x1

	// CHANNEL.AXI_ID: Channel AXI ID Register

	// CHANNEL.AXI_QOS: AXI QOS Register

	// CHANNEL.INTSTATUS_EN: Interrupt Status Enable Register
	// Position of BLOCK_TFR_DONE field.
	DMAC_channel_INTSTATUS_EN_BLOCK_TFR_DONE_Pos = 0x0
	// Bit mask of BLOCK_TFR_DONE field.
	DMAC_channel_INTSTATUS_EN_BLOCK_TFR_DONE_Msk = 0x1
	// Bit BLOCK_TFR_DONE.
	DMAC_channel_INTSTATUS_EN_BLOCK_TFR_DONE = 0x1
	// Position of TFR_DONE field.
	DMAC_channel_INTSTATUS_EN_TFR_DONE_Pos = 0x1
	// Bit mask of TFR_DONE field.
	DMAC_channel_INTSTATUS_EN_TFR_DONE_Msk = 0x2
	// Bit TFR_DONE.
	DMAC_channel_INTSTATUS_EN_TFR_DONE = 0x2
	// Position of SRC_TRANSCOMP field.
	DMAC_channel_INTSTATUS_EN_SRC_TRANSCOMP_Pos = 0x3
	// Bit mask of SRC_TRANSCOMP field.
	DMAC_channel_INTSTATUS_EN_SRC_TRANSCOMP_Msk = 0x8
	// Bit SRC_TRANSCOMP.
	DMAC_channel_INTSTATUS_EN_SRC_TRANSCOMP = 0x8
	// Position of DST_TRANSCOMP field.
	DMAC_channel_INTSTATUS_EN_DST_TRANSCOMP_Pos = 0x4
	// Bit mask of DST_TRANSCOMP field.
	DMAC_channel_INTSTATUS_EN_DST_TRANSCOMP_Msk = 0x10
	// Bit DST_TRANSCOMP.
	DMAC_channel_INTSTATUS_EN_DST_TRANSCOMP = 0x10
	// Position of SRC_DEC_ERR field.
	DMAC_channel_INTSTATUS_EN_SRC_DEC_ERR_Pos = 0x5
	// Bit mask of SRC_DEC_ERR field.
	DMAC_channel_INTSTATUS_EN_SRC_DEC_ERR_Msk = 0x20
	// Bit SRC_DEC_ERR.
	DMAC_channel_INTSTATUS_EN_SRC_DEC_ERR = 0x20
	// Position of DST_DEC_ERR field.
	DMAC_channel_INTSTATUS_EN_DST_DEC_ERR_Pos = 0x6
	// Bit mask of DST_DEC_ERR field.
	DMAC_channel_INTSTATUS_EN_DST_DEC_ERR_Msk = 0x40
	// Bit DST_DEC_ERR.
	DMAC_channel_INTSTATUS_EN_DST_DEC_ERR = 0x40
	// Position of SRC_SLV_ERR field.
	DMAC_channel_INTSTATUS_EN_SRC_SLV_ERR_Pos = 0x7
	// Bit mask of SRC_SLV_ERR field.
	DMAC_channel_INTSTATUS_EN_SRC_SLV_ERR_Msk = 0x80
	// Bit SRC_SLV_ERR.
	DMAC_channel_INTSTATUS_EN_SRC_SLV_ERR = 0x80
	// Position of DST_SLV_ERR field.
	DMAC_channel_INTSTATUS_EN_DST_SLV_ERR_Pos = 0x8
	// Bit mask of DST_SLV_ERR field.
	DMAC_channel_INTSTATUS_EN_DST_SLV_ERR_Msk = 0x100
	// Bit DST_SLV_ERR.
	DMAC_channel_INTSTATUS_EN_DST_SLV_ERR = 0x100
	// Position of LLI_RD_DEC_ERR field.
	DMAC_channel_INTSTATUS_EN_LLI_RD_DEC_ERR_Pos = 0x9
	// Bit mask of LLI_RD_DEC_ERR field.
	DMAC_channel_INTSTATUS_EN_LLI_RD_DEC_ERR_Msk = 0x200
	// Bit LLI_RD_DEC_ERR.
	DMAC_channel_INTSTATUS_EN_LLI_RD_DEC_ERR = 0x200
	// Position of LLI_WR_DEC_ERR field.
	DMAC_channel_INTSTATUS_EN_LLI_WR_DEC_ERR_Pos = 0xa
	// Bit mask of LLI_WR_DEC_ERR field.
	DMAC_channel_INTSTATUS_EN_LLI_WR_DEC_ERR_Msk = 0x400
	// Bit LLI_WR_DEC_ERR.
	DMAC_channel_INTSTATUS_EN_LLI_WR_DEC_ERR = 0x400
	// Position of LLI_RD_SLV_ERR field.
	DMAC_channel_INTSTATUS_EN_LLI_RD_SLV_ERR_Pos = 0xb
	// Bit mask of LLI_RD_SLV_ERR field.
	DMAC_channel_INTSTATUS_EN_LLI_RD_SLV_ERR_Msk = 0x800
	// Bit LLI_RD_SLV_ERR.
	DMAC_channel_INTSTATUS_EN_LLI_RD_SLV_ERR = 0x800
	// Position of LLI_WR_SLV_ERR field.
	DMAC_channel_INTSTATUS_EN_LLI_WR_SLV_ERR_Pos = 0xc
	// Bit mask of LLI_WR_SLV_ERR field.
	DMAC_channel_INTSTATUS_EN_LLI_WR_SLV_ERR_Msk = 0x1000
	// Bit LLI_WR_SLV_ERR.
	DMAC_channel_INTSTATUS_EN_LLI_WR_SLV_ERR = 0x1000

	// CHANNEL.INTSTATUS: Channel Interrupt Status Register
	// Position of BLOCK_TFR_DONE field.
	DMAC_channel_INTSTATUS_BLOCK_TFR_DONE_Pos = 0x0
	// Bit mask of BLOCK_TFR_DONE field.
	DMAC_channel_INTSTATUS_BLOCK_TFR_DONE_Msk = 0x1
	// Bit BLOCK_TFR_DONE.
	DMAC_channel_INTSTATUS_BLOCK_TFR_DONE = 0x1
	// Position of TFR_DONE field.
	DMAC_channel_INTSTATUS_TFR_DONE_Pos = 0x1
	// Bit mask of TFR_DONE field.
	DMAC_channel_INTSTATUS_TFR_DONE_Msk = 0x2
	// Bit TFR_DONE.
	DMAC_channel_INTSTATUS_TFR_DONE = 0x2
	// Position of SRC_TRANSCOMP field.
	DMAC_channel_INTSTATUS_SRC_TRANSCOMP_Pos = 0x3
	// Bit mask of SRC_TRANSCOMP field.
	DMAC_channel_INTSTATUS_SRC_TRANSCOMP_Msk = 0x8
	// Bit SRC_TRANSCOMP.
	DMAC_channel_INTSTATUS_SRC_TRANSCOMP = 0x8
	// Position of DST_TRANSCOMP field.
	DMAC_channel_INTSTATUS_DST_TRANSCOMP_Pos = 0x4
	// Bit mask of DST_TRANSCOMP field.
	DMAC_channel_INTSTATUS_DST_TRANSCOMP_Msk = 0x10
	// Bit DST_TRANSCOMP.
	DMAC_channel_INTSTATUS_DST_TRANSCOMP = 0x10
	// Position of SRC_DEC_ERR field.
	DMAC_channel_INTSTATUS_SRC_DEC_ERR_Pos = 0x5
	// Bit mask of SRC_DEC_ERR field.
	DMAC_channel_INTSTATUS_SRC_DEC_ERR_Msk = 0x20
	// Bit SRC_DEC_ERR.
	DMAC_channel_INTSTATUS_SRC_DEC_ERR = 0x20
	// Position of DST_DEC_ERR field.
	DMAC_channel_INTSTATUS_DST_DEC_ERR_Pos = 0x6
	// Bit mask of DST_DEC_ERR field.
	DMAC_channel_INTSTATUS_DST_DEC_ERR_Msk = 0x40
	// Bit DST_DEC_ERR.
	DMAC_channel_INTSTATUS_DST_DEC_ERR = 0x40
	// Position of SRC_SLV_ERR field.
	DMAC_channel_INTSTATUS_SRC_SLV_ERR_Pos = 0x7
	// Bit mask of SRC_SLV_ERR field.
	DMAC_channel_INTSTATUS_SRC_SLV_ERR_Msk = 0x80
	// Bit SRC_SLV_ERR.
	DMAC_channel_INTSTATUS_SRC_SLV_ERR = 0x80
	// Position of DST_SLV_ERR field.
	DMAC_channel_INTSTATUS_DST_SLV_ERR_Pos = 0x8
	// Bit mask of DST_SLV_ERR field.
	DMAC_channel_INTSTATUS_DST_SLV_ERR_Msk = 0x100
	// Bit DST_SLV_ERR.
	DMAC_channel_INTSTATUS_DST_SLV_ERR = 0x100
	// Position of LLI_RD_DEC_ERR field.
	DMAC_channel_INTSTATUS_LLI_RD_DEC_ERR_Pos = 0x9
	// Bit mask of LLI_RD_DEC_ERR field.
	DMAC_channel_INTSTATUS_LLI_RD_DEC_ERR_Msk = 0x200
	// Bit LLI_RD_DEC_ERR.
	DMAC_channel_INTSTATUS_LLI_RD_DEC_ERR = 0x200
	// Position of LLI_WR_DEC_ERR field.
	DMAC_channel_INTSTATUS_LLI_WR_DEC_ERR_Pos = 0xa
	// Bit mask of LLI_WR_DEC_ERR field.
	DMAC_channel_INTSTATUS_LLI_WR_DEC_ERR_Msk = 0x400
	// Bit LLI_WR_DEC_ERR.
	DMAC_channel_INTSTATUS_LLI_WR_DEC_ERR = 0x400
	// Position of LLI_RD_SLV_ERR field.
	DMAC_channel_INTSTATUS_LLI_RD_SLV_ERR_Pos = 0xb
	// Bit mask of LLI_RD_SLV_ERR field.
	DMAC_channel_INTSTATUS_LLI_RD_SLV_ERR_Msk = 0x800
	// Bit LLI_RD_SLV_ERR.
	DMAC_channel_INTSTATUS_LLI_RD_SLV_ERR = 0x800
	// Position of LLI_WR_SLV_ERR field.
	DMAC_channel_INTSTATUS_LLI_WR_SLV_ERR_Pos = 0xc
	// Bit mask of LLI_WR_SLV_ERR field.
	DMAC_channel_INTSTATUS_LLI_WR_SLV_ERR_Msk = 0x1000
	// Bit LLI_WR_SLV_ERR.
	DMAC_channel_INTSTATUS_LLI_WR_SLV_ERR = 0x1000

	// CHANNEL.INTSIGNAL_EN: Interrupt Signal Enable Register
	// Position of BLOCK_TFR_DONE field.
	DMAC_channel_INTSIGNAL_EN_BLOCK_TFR_DONE_Pos = 0x0
	// Bit mask of BLOCK_TFR_DONE field.
	DMAC_channel_INTSIGNAL_EN_BLOCK_TFR_DONE_Msk = 0x1
	// Bit BLOCK_TFR_DONE.
	DMAC_channel_INTSIGNAL_EN_BLOCK_TFR_DONE = 0x1
	// Position of TFR_DONE field.
	DMAC_channel_INTSIGNAL_EN_TFR_DONE_Pos = 0x1
	// Bit mask of TFR_DONE field.
	DMAC_channel_INTSIGNAL_EN_TFR_DONE_Msk = 0x2
	// Bit TFR_DONE.
	DMAC_channel_INTSIGNAL_EN_TFR_DONE = 0x2
	// Position of SRC_TRANSCOMP field.
	DMAC_channel_INTSIGNAL_EN_SRC_TRANSCOMP_Pos = 0x3
	// Bit mask of SRC_TRANSCOMP field.
	DMAC_channel_INTSIGNAL_EN_SRC_TRANSCOMP_Msk = 0x8
	// Bit SRC_TRANSCOMP.
	DMAC_channel_INTSIGNAL_EN_SRC_TRANSCOMP = 0x8
	// Position of DST_TRANSCOMP field.
	DMAC_channel_INTSIGNAL_EN_DST_TRANSCOMP_Pos = 0x4
	// Bit mask of DST_TRANSCOMP field.
	DMAC_channel_INTSIGNAL_EN_DST_TRANSCOMP_Msk = 0x10
	// Bit DST_TRANSCOMP.
	DMAC_channel_INTSIGNAL_EN_DST_TRANSCOMP = 0x10
	// Position of SRC_DEC_ERR field.
	DMAC_channel_INTSIGNAL_EN_SRC_DEC_ERR_Pos = 0x5
	// Bit mask of SRC_DEC_ERR field.
	DMAC_channel_INTSIGNAL_EN_SRC_DEC_ERR_Msk = 0x20
	// Bit SRC_DEC_ERR.
	DMAC_channel_INTSIGNAL_EN_SRC_DEC_ERR = 0x20
	// Position of DST_DEC_ERR field.
	DMAC_channel_INTSIGNAL_EN_DST_DEC_ERR_Pos = 0x6
	// Bit mask of DST_DEC_ERR field.
	DMAC_channel_INTSIGNAL_EN_DST_DEC_ERR_Msk = 0x40
	// Bit DST_DEC_ERR.
	DMAC_channel_INTSIGNAL_EN_DST_DEC_ERR = 0x40
	// Position of SRC_SLV_ERR field.
	DMAC_channel_INTSIGNAL_EN_SRC_SLV_ERR_Pos = 0x7
	// Bit mask of SRC_SLV_ERR field.
	DMAC_channel_INTSIGNAL_EN_SRC_SLV_ERR_Msk = 0x80
	// Bit SRC_SLV_ERR.
	DMAC_channel_INTSIGNAL_EN_SRC_SLV_ERR = 0x80
	// Position of DST_SLV_ERR field.
	DMAC_channel_INTSIGNAL_EN_DST_SLV_ERR_Pos = 0x8
	// Bit mask of DST_SLV_ERR field.
	DMAC_channel_INTSIGNAL_EN_DST_SLV_ERR_Msk = 0x100
	// Bit DST_SLV_ERR.
	DMAC_channel_INTSIGNAL_EN_DST_SLV_ERR = 0x100
	// Position of LLI_RD_DEC_ERR field.
	DMAC_channel_INTSIGNAL_EN_LLI_RD_DEC_ERR_Pos = 0x9
	// Bit mask of LLI_RD_DEC_ERR field.
	DMAC_channel_INTSIGNAL_EN_LLI_RD_DEC_ERR_Msk = 0x200
	// Bit LLI_RD_DEC_ERR.
	DMAC_channel_INTSIGNAL_EN_LLI_RD_DEC_ERR = 0x200
	// Position of LLI_WR_DEC_ERR field.
	DMAC_channel_INTSIGNAL_EN_LLI_WR_DEC_ERR_Pos = 0xa
	// Bit mask of LLI_WR_DEC_ERR field.
	DMAC_channel_INTSIGNAL_EN_LLI_WR_DEC_ERR_Msk = 0x400
	// Bit LLI_WR_DEC_ERR.
	DMAC_channel_INTSIGNAL_EN_LLI_WR_DEC_ERR = 0x400
	// Position of LLI_RD_SLV_ERR field.
	DMAC_channel_INTSIGNAL_EN_LLI_RD_SLV_ERR_Pos = 0xb
	// Bit mask of LLI_RD_SLV_ERR field.
	DMAC_channel_INTSIGNAL_EN_LLI_RD_SLV_ERR_Msk = 0x800
	// Bit LLI_RD_SLV_ERR.
	DMAC_channel_INTSIGNAL_EN_LLI_RD_SLV_ERR = 0x800
	// Position of LLI_WR_SLV_ERR field.
	DMAC_channel_INTSIGNAL_EN_LLI_WR_SLV_ERR_Pos = 0xc
	// Bit mask of LLI_WR_SLV_ERR field.
	DMAC_channel_INTSIGNAL_EN_LLI_WR_SLV_ERR_Msk = 0x1000
	// Bit LLI_WR_SLV_ERR.
	DMAC_channel_INTSIGNAL_EN_LLI_WR_SLV_ERR = 0x1000

	// CHANNEL.INTCLEAR: Interrupt Clear Register
	// Position of BLOCK_TFR_DONE field.
	DMAC_channel_INTCLEAR_BLOCK_TFR_DONE_Pos = 0x0
	// Bit mask of BLOCK_TFR_DONE field.
	DMAC_channel_INTCLEAR_BLOCK_TFR_DONE_Msk = 0x1
	// Bit BLOCK_TFR_DONE.
	DMAC_channel_INTCLEAR_BLOCK_TFR_DONE = 0x1
	// Position of TFR_DONE field.
	DMAC_channel_INTCLEAR_TFR_DONE_Pos = 0x1
	// Bit mask of TFR_DONE field.
	DMAC_channel_INTCLEAR_TFR_DONE_Msk = 0x2
	// Bit TFR_DONE.
	DMAC_channel_INTCLEAR_TFR_DONE = 0x2
	// Position of SRC_TRANSCOMP field.
	DMAC_channel_INTCLEAR_SRC_TRANSCOMP_Pos = 0x3
	// Bit mask of SRC_TRANSCOMP field.
	DMAC_channel_INTCLEAR_SRC_TRANSCOMP_Msk = 0x8
	// Bit SRC_TRANSCOMP.
	DMAC_channel_INTCLEAR_SRC_TRANSCOMP = 0x8
	// Position of DST_TRANSCOMP field.
	DMAC_channel_INTCLEAR_DST_TRANSCOMP_Pos = 0x4
	// Bit mask of DST_TRANSCOMP field.
	DMAC_channel_INTCLEAR_DST_TRANSCOMP_Msk = 0x10
	// Bit DST_TRANSCOMP.
	DMAC_channel_INTCLEAR_DST_TRANSCOMP = 0x10
	// Position of SRC_DEC_ERR field.
	DMAC_channel_INTCLEAR_SRC_DEC_ERR_Pos = 0x5
	// Bit mask of SRC_DEC_ERR field.
	DMAC_channel_INTCLEAR_SRC_DEC_ERR_Msk = 0x20
	// Bit SRC_DEC_ERR.
	DMAC_channel_INTCLEAR_SRC_DEC_ERR = 0x20
	// Position of DST_DEC_ERR field.
	DMAC_channel_INTCLEAR_DST_DEC_ERR_Pos = 0x6
	// Bit mask of DST_DEC_ERR field.
	DMAC_channel_INTCLEAR_DST_DEC_ERR_Msk = 0x40
	// Bit DST_DEC_ERR.
	DMAC_channel_INTCLEAR_DST_DEC_ERR = 0x40
	// Position of SRC_SLV_ERR field.
	DMAC_channel_INTCLEAR_SRC_SLV_ERR_Pos = 0x7
	// Bit mask of SRC_SLV_ERR field.
	DMAC_channel_INTCLEAR_SRC_SLV_ERR_Msk = 0x80
	// Bit SRC_SLV_ERR.
	DMAC_channel_INTCLEAR_SRC_SLV_ERR = 0x80
	// Position of DST_SLV_ERR field.
	DMAC_channel_INTCLEAR_DST_SLV_ERR_Pos = 0x8
	// Bit mask of DST_SLV_ERR field.
	DMAC_channel_INTCLEAR_DST_SLV_ERR_Msk = 0x100
	// Bit DST_SLV_ERR.
	DMAC_channel_INTCLEAR_DST_SLV_ERR = 0x100
	// Position of LLI_RD_DEC_ERR field.
	DMAC_channel_INTCLEAR_LLI_RD_DEC_ERR_Pos = 0x9
	// Bit mask of LLI_RD_DEC_ERR field.
	DMAC_channel_INTCLEAR_LLI_RD_DEC_ERR_Msk = 0x200
	// Bit LLI_RD_DEC_ERR.
	DMAC_channel_INTCLEAR_LLI_RD_DEC_ERR = 0x200
	// Position of LLI_WR_DEC_ERR field.
	DMAC_channel_INTCLEAR_LLI_WR_DEC_ERR_Pos = 0xa
	// Bit mask of LLI_WR_DEC_ERR field.
	DMAC_channel_INTCLEAR_LLI_WR_DEC_ERR_Msk = 0x400
	// Bit LLI_WR_DEC_ERR.
	DMAC_channel_INTCLEAR_LLI_WR_DEC_ERR = 0x400
	// Position of LLI_RD_SLV_ERR field.
	DMAC_channel_INTCLEAR_LLI_RD_SLV_ERR_Pos = 0xb
	// Bit mask of LLI_RD_SLV_ERR field.
	DMAC_channel_INTCLEAR_LLI_RD_SLV_ERR_Msk = 0x800
	// Bit LLI_RD_SLV_ERR.
	DMAC_channel_INTCLEAR_LLI_RD_SLV_ERR = 0x800
	// Position of LLI_WR_SLV_ERR field.
	DMAC_channel_INTCLEAR_LLI_WR_SLV_ERR_Pos = 0xc
	// Bit mask of LLI_WR_SLV_ERR field.
	DMAC_channel_INTCLEAR_LLI_WR_SLV_ERR_Msk = 0x1000
	// Bit LLI_WR_SLV_ERR.
	DMAC_channel_INTCLEAR_LLI_WR_SLV_ERR = 0x1000

	// CHANNEL._RESERVED: Padding to make structure size 256 bytes so that channels[] is an array
)

// Constants for GPIO: General Purpose Input/Output Interface
const (
	// DATA_OUTPUT: Data (output) registers
	// Position of PIN_S field.
	GPIO_DATA_OUTPUT_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIO_DATA_OUTPUT_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIO_DATA_OUTPUT_PIN_S = 0x1

	// DIRECTION: Data direction registers
	// Position of PIN_S field.
	GPIO_DIRECTION_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIO_DIRECTION_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIO_DIRECTION_PIN_S = 0x1
	// Pin is input
	GPIO_DIRECTION_PIN_S_INPUT = 0x0
	// Pin is output
	GPIO_DIRECTION_PIN_S_OUTPUT = 0x1

	// DATA_INPUT: External port (data input) registers
	// Position of PIN_S field.
	GPIO_DATA_INPUT_PIN_S_Pos = 0x0
	// Bit mask of PIN_S field.
	GPIO_DATA_INPUT_PIN_S_Msk = 0x1
	// Bit PIN_S.
	GPIO_DATA_INPUT_PIN_S = 0x1
)

// Constants for UART1: Universal Asynchronous Receiver-Transmitter 1
const ()

// Constants for SPI0: Serial Peripheral Interface 0 (master)
const (
	// CTRLR0: Control Register 0
	// Position of WORK_MODE field.
	SPI_CTRLR0_WORK_MODE_Pos = 0x6
	// Bit mask of WORK_MODE field.
	SPI_CTRLR0_WORK_MODE_Msk = 0xc0
	// MODE_0
	SPI_CTRLR0_WORK_MODE_MODE0 = 0x0
	// MODE_1
	SPI_CTRLR0_WORK_MODE_MODE1 = 0x1
	// MODE_2
	SPI_CTRLR0_WORK_MODE_MODE2 = 0x2
	// MODE_3
	SPI_CTRLR0_WORK_MODE_MODE3 = 0x3
	// Position of TMOD field.
	SPI_CTRLR0_TMOD_Pos = 0x8
	// Bit mask of TMOD field.
	SPI_CTRLR0_TMOD_Msk = 0x300
	// TRANS_RECV
	SPI_CTRLR0_TMOD_TRANS_RECV = 0x0
	// TRANS
	SPI_CTRLR0_TMOD_TRANS = 0x1
	// RECV
	SPI_CTRLR0_TMOD_RECV = 0x2
	// EEROM
	SPI_CTRLR0_TMOD_EEROM = 0x3
	// Position of FRAME_FORMAT field.
	SPI_CTRLR0_FRAME_FORMAT_Pos = 0x15
	// Bit mask of FRAME_FORMAT field.
	SPI_CTRLR0_FRAME_FORMAT_Msk = 0x600000
	// STANDARD
	SPI_CTRLR0_FRAME_FORMAT_STANDARD = 0x0
	// DUAL
	SPI_CTRLR0_FRAME_FORMAT_DUAL = 0x1
	// QUAD
	SPI_CTRLR0_FRAME_FORMAT_QUAD = 0x2
	// OCTAL
	SPI_CTRLR0_FRAME_FORMAT_OCTAL = 0x3
	// Position of DATA_LENGTH field.
	SPI_CTRLR0_DATA_LENGTH_Pos = 0x10
	// Bit mask of DATA_LENGTH field.
	SPI_CTRLR0_DATA_LENGTH_Msk = 0x1f0000

	// SPI_CTRLR0: SPI Control Register
	// Position of AITM field.
	SPI_SPI_CTRLR0_AITM_Pos = 0x0
	// Bit mask of AITM field.
	SPI_SPI_CTRLR0_AITM_Msk = 0x3
	// STANDARD
	SPI_SPI_CTRLR0_AITM_STANDARD = 0x0
	// ADDR_STANDARD
	SPI_SPI_CTRLR0_AITM_ADDR_STANDARD = 0x1
	// AS_FRAME_FORMAT
	SPI_SPI_CTRLR0_AITM_AS_FRAME_FORMAT = 0x2
	// Position of ADDR_LENGTH field.
	SPI_SPI_CTRLR0_ADDR_LENGTH_Pos = 0x2
	// Bit mask of ADDR_LENGTH field.
	SPI_SPI_CTRLR0_ADDR_LENGTH_Msk = 0x3c
	// Position of INST_LENGTH field.
	SPI_SPI_CTRLR0_INST_LENGTH_Pos = 0x8
	// Bit mask of INST_LENGTH field.
	SPI_SPI_CTRLR0_INST_LENGTH_Msk = 0x300
	// Position of WAIT_CYCLES field.
	SPI_SPI_CTRLR0_WAIT_CYCLES_Pos = 0xb
	// Bit mask of WAIT_CYCLES field.
	SPI_SPI_CTRLR0_WAIT_CYCLES_Msk = 0xf800
)

// Constants for SPI2: Serial Peripheral Interface 2 (slave)
const ()

// Constants for SPI3: Serial Peripheral Interface 3 (master)
const (
	// CTRLR0: Control Register 0
	// Position of DATA_LENGTH field.
	SPI3_CTRLR0_DATA_LENGTH_Pos = 0x0
	// Bit mask of DATA_LENGTH field.
	SPI3_CTRLR0_DATA_LENGTH_Msk = 0x1f
	// Position of WORK_MODE field.
	SPI3_CTRLR0_WORK_MODE_Pos = 0x8
	// Bit mask of WORK_MODE field.
	SPI3_CTRLR0_WORK_MODE_Msk = 0x300
	// MODE_0
	SPI3_CTRLR0_WORK_MODE_MODE0 = 0x0
	// MODE_1
	SPI3_CTRLR0_WORK_MODE_MODE1 = 0x1
	// MODE_2
	SPI3_CTRLR0_WORK_MODE_MODE2 = 0x2
	// MODE_3
	SPI3_CTRLR0_WORK_MODE_MODE3 = 0x3
	// Position of TMOD field.
	SPI3_CTRLR0_TMOD_Pos = 0xa
	// Bit mask of TMOD field.
	SPI3_CTRLR0_TMOD_Msk = 0xc00
	// TRANS_RECV
	SPI3_CTRLR0_TMOD_TRANS_RECV = 0x0
	// TRANS
	SPI3_CTRLR0_TMOD_TRANS = 0x1
	// RECV
	SPI3_CTRLR0_TMOD_RECV = 0x2
	// EEROM
	SPI3_CTRLR0_TMOD_EEROM = 0x3
	// Position of FRAME_FORMAT field.
	SPI3_CTRLR0_FRAME_FORMAT_Pos = 0x16
	// Bit mask of FRAME_FORMAT field.
	SPI3_CTRLR0_FRAME_FORMAT_Msk = 0xc00000
	// STANDARD
	SPI3_CTRLR0_FRAME_FORMAT_STANDARD = 0x0
	// DUAL
	SPI3_CTRLR0_FRAME_FORMAT_DUAL = 0x1
	// QUAD
	SPI3_CTRLR0_FRAME_FORMAT_QUAD = 0x2
	// OCTAL
	SPI3_CTRLR0_FRAME_FORMAT_OCTAL = 0x3

	// SPI_CTRLR0: SPI Control Register
	// Position of AITM field.
	SPI3_SPI_CTRLR0_AITM_Pos = 0x0
	// Bit mask of AITM field.
	SPI3_SPI_CTRLR0_AITM_Msk = 0x3
	// STANDARD
	SPI3_SPI_CTRLR0_AITM_STANDARD = 0x0
	// ADDR_STANDARD
	SPI3_SPI_CTRLR0_AITM_ADDR_STANDARD = 0x1
	// AS_FRAME_FORMAT
	SPI3_SPI_CTRLR0_AITM_AS_FRAME_FORMAT = 0x2
	// Position of ADDR_LENGTH field.
	SPI3_SPI_CTRLR0_ADDR_LENGTH_Pos = 0x2
	// Bit mask of ADDR_LENGTH field.
	SPI3_SPI_CTRLR0_ADDR_LENGTH_Msk = 0x3c
	// Position of INST_LENGTH field.
	SPI3_SPI_CTRLR0_INST_LENGTH_Pos = 0x8
	// Bit mask of INST_LENGTH field.
	SPI3_SPI_CTRLR0_INST_LENGTH_Msk = 0x300
	// Position of WAIT_CYCLES field.
	SPI3_SPI_CTRLR0_WAIT_CYCLES_Pos = 0xb
	// Bit mask of WAIT_CYCLES field.
	SPI3_SPI_CTRLR0_WAIT_CYCLES_Msk = 0xf800
)

// Constants for I2S0: Inter-Integrated Sound Interface 0
const (
	// IER: Enable Register
	// Position of IEN field.
	I2S_IER_IEN_Pos = 0x0
	// Bit mask of IEN field.
	I2S_IER_IEN_Msk = 0x1
	// Bit IEN.
	I2S_IER_IEN = 0x1

	// IRER: Receiver Block Enable Register
	// Position of RXEN field.
	I2S_IRER_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	I2S_IRER_RXEN_Msk = 0x1
	// Bit RXEN.
	I2S_IRER_RXEN = 0x1

	// ITER: Transmitter Block Enable Register
	// Position of TXEN field.
	I2S_ITER_TXEN_Pos = 0x0
	// Bit mask of TXEN field.
	I2S_ITER_TXEN_Msk = 0x1
	// Bit TXEN.
	I2S_ITER_TXEN = 0x1

	// CER: Clock Generation enable
	// Position of CLKEN field.
	I2S_CER_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	I2S_CER_CLKEN_Msk = 0x1
	// Bit CLKEN.
	I2S_CER_CLKEN = 0x1

	// CCR: Clock Configuration Register
	// Position of CLK_GATE field.
	I2S_CCR_CLK_GATE_Pos = 0x0
	// Bit mask of CLK_GATE field.
	I2S_CCR_CLK_GATE_Msk = 0x7
	// Clock gating is disabled
	I2S_CCR_CLK_GATE_NO = 0x0
	// Gating after 12 sclk cycles
	I2S_CCR_CLK_GATE_CYCLES12 = 0x1
	// Gating after 16 sclk cycles
	I2S_CCR_CLK_GATE_CYCLES16 = 0x2
	// Gating after 20 sclk cycles
	I2S_CCR_CLK_GATE_CYCLES20 = 0x3
	// Gating after 24 sclk cycles
	I2S_CCR_CLK_GATE_CYCLES24 = 0x4
	// Position of CLK_WORD_SIZE field.
	I2S_CCR_CLK_WORD_SIZE_Pos = 0x3
	// Bit mask of CLK_WORD_SIZE field.
	I2S_CCR_CLK_WORD_SIZE_Msk = 0x18
	// 16 sclk cycles
	I2S_CCR_CLK_WORD_SIZE_CYCLES16 = 0x0
	// 24 sclk cycles
	I2S_CCR_CLK_WORD_SIZE_CYCLES24 = 0x1
	// 32 sclk cycles
	I2S_CCR_CLK_WORD_SIZE_CYCLES32 = 0x2
	// Position of ALIGN_MODE field.
	I2S_CCR_ALIGN_MODE_Pos = 0x5
	// Bit mask of ALIGN_MODE field.
	I2S_CCR_ALIGN_MODE_Msk = 0xe0
	// Standard I2S format
	I2S_CCR_ALIGN_MODE_STANDARD = 0x1
	// Right aligned format
	I2S_CCR_ALIGN_MODE_RIGHT = 0x2
	// Left aligned format
	I2S_CCR_ALIGN_MODE_LEFT = 0x4
	// Position of DMA_TX_EN field.
	I2S_CCR_DMA_TX_EN_Pos = 0x8
	// Bit mask of DMA_TX_EN field.
	I2S_CCR_DMA_TX_EN_Msk = 0x100
	// Bit DMA_TX_EN.
	I2S_CCR_DMA_TX_EN = 0x100
	// Position of DMA_RX_EN field.
	I2S_CCR_DMA_RX_EN_Pos = 0x9
	// Bit mask of DMA_RX_EN field.
	I2S_CCR_DMA_RX_EN_Msk = 0x200
	// Bit DMA_RX_EN.
	I2S_CCR_DMA_RX_EN = 0x200
	// Position of DMA_DIVIDE_16 field.
	I2S_CCR_DMA_DIVIDE_16_Pos = 0xa
	// Bit mask of DMA_DIVIDE_16 field.
	I2S_CCR_DMA_DIVIDE_16_Msk = 0x400
	// Bit DMA_DIVIDE_16.
	I2S_CCR_DMA_DIVIDE_16 = 0x400
	// Position of SIGN_EXPAND_EN field.
	I2S_CCR_SIGN_EXPAND_EN_Pos = 0xb
	// Bit mask of SIGN_EXPAND_EN field.
	I2S_CCR_SIGN_EXPAND_EN_Msk = 0x800
	// Bit SIGN_EXPAND_EN.
	I2S_CCR_SIGN_EXPAND_EN = 0x800

	// RXFFR: Receiver Block FIFO Reset Register
	// Position of RXFFR field.
	I2S_RXFFR_RXFFR_Pos = 0x0
	// Bit mask of RXFFR field.
	I2S_RXFFR_RXFFR_Msk = 0x1
	// Bit RXFFR.
	I2S_RXFFR_RXFFR = 0x1
	// Not flush FIFO
	I2S_RXFFR_RXFFR_NOT_FLUSH = 0x0
	// Flush FIFO
	I2S_RXFFR_RXFFR_FLUSH = 0x1

	// TXFFR: Transmitter Block FIFO Reset Register
	// Position of RXFFR field.
	I2S_TXFFR_RXFFR_Pos = 0x0
	// Bit mask of RXFFR field.
	I2S_TXFFR_RXFFR_Msk = 0x1
	// Bit RXFFR.
	I2S_TXFFR_RXFFR = 0x1

	// CHANNEL.LEFT_RXTX: Left Receive or Left Transmit Register

	// CHANNEL.RIGHT_RXTX: Right Receive or Right Transmit Register

	// CHANNEL.RER: Receive Enable Register
	// Position of RXCHENX field.
	I2S_channel_RER_RXCHENX_Pos = 0x0
	// Bit mask of RXCHENX field.
	I2S_channel_RER_RXCHENX_Msk = 0x1
	// Bit RXCHENX.
	I2S_channel_RER_RXCHENX = 0x1

	// CHANNEL.TER: Transmit Enable Register
	// Position of TXCHENX field.
	I2S_channel_TER_TXCHENX_Pos = 0x0
	// Bit mask of TXCHENX field.
	I2S_channel_TER_TXCHENX_Msk = 0x1
	// Bit TXCHENX.
	I2S_channel_TER_TXCHENX = 0x1

	// CHANNEL.RCR: Receive Configuration Register
	// Position of WLEN field.
	I2S_channel_RCR_WLEN_Pos = 0x0
	// Bit mask of WLEN field.
	I2S_channel_RCR_WLEN_Msk = 0x7
	// Ignore the word length
	I2S_channel_RCR_WLEN_IGNORE = 0x0
	// 12-bit data resolution of the receiver
	I2S_channel_RCR_WLEN_RESOLUTION12 = 0x1
	// 16-bit data resolution of the receiver
	I2S_channel_RCR_WLEN_RESOLUTION16 = 0x2
	// 20-bit data resolution of the receiver
	I2S_channel_RCR_WLEN_RESOLUTION20 = 0x3
	// 24-bit data resolution of the receiver
	I2S_channel_RCR_WLEN_RESOLUTION24 = 0x4
	// 32-bit data resolution of the receiver
	I2S_channel_RCR_WLEN_RESOLUTION32 = 0x5

	// CHANNEL.TCR: Transmit Configuration Register
	// Position of WLEN field.
	I2S_channel_TCR_WLEN_Pos = 0x0
	// Bit mask of WLEN field.
	I2S_channel_TCR_WLEN_Msk = 0x7

	// CHANNEL.ISR: Interrupt Status Register
	// Position of RXDA field.
	I2S_channel_ISR_RXDA_Pos = 0x0
	// Bit mask of RXDA field.
	I2S_channel_ISR_RXDA_Msk = 0x1
	// Bit RXDA.
	I2S_channel_ISR_RXDA = 0x1
	// Position of RXFO field.
	I2S_channel_ISR_RXFO_Pos = 0x1
	// Bit mask of RXFO field.
	I2S_channel_ISR_RXFO_Msk = 0x2
	// Bit RXFO.
	I2S_channel_ISR_RXFO = 0x2
	// Position of TXFE field.
	I2S_channel_ISR_TXFE_Pos = 0x4
	// Bit mask of TXFE field.
	I2S_channel_ISR_TXFE_Msk = 0x10
	// Bit TXFE.
	I2S_channel_ISR_TXFE = 0x10
	// Position of TXFO field.
	I2S_channel_ISR_TXFO_Pos = 0x5
	// Bit mask of TXFO field.
	I2S_channel_ISR_TXFO_Msk = 0x20
	// Bit TXFO.
	I2S_channel_ISR_TXFO = 0x20

	// CHANNEL.IMR: Interrupt Mask Register
	// Position of RXDAM field.
	I2S_channel_IMR_RXDAM_Pos = 0x0
	// Bit mask of RXDAM field.
	I2S_channel_IMR_RXDAM_Msk = 0x1
	// Bit RXDAM.
	I2S_channel_IMR_RXDAM = 0x1
	// Position of RXFOM field.
	I2S_channel_IMR_RXFOM_Pos = 0x1
	// Bit mask of RXFOM field.
	I2S_channel_IMR_RXFOM_Msk = 0x2
	// Bit RXFOM.
	I2S_channel_IMR_RXFOM = 0x2
	// Position of TXFEM field.
	I2S_channel_IMR_TXFEM_Pos = 0x4
	// Bit mask of TXFEM field.
	I2S_channel_IMR_TXFEM_Msk = 0x10
	// Bit TXFEM.
	I2S_channel_IMR_TXFEM = 0x10
	// Position of TXFOM field.
	I2S_channel_IMR_TXFOM_Pos = 0x5
	// Bit mask of TXFOM field.
	I2S_channel_IMR_TXFOM_Msk = 0x20
	// Bit TXFOM.
	I2S_channel_IMR_TXFOM = 0x20

	// CHANNEL.ROR: Receive Overrun Register
	// Position of RXCHO field.
	I2S_channel_ROR_RXCHO_Pos = 0x0
	// Bit mask of RXCHO field.
	I2S_channel_ROR_RXCHO_Msk = 0x1
	// Bit RXCHO.
	I2S_channel_ROR_RXCHO = 0x1

	// CHANNEL.TOR: Transmit Overrun Register
	// Position of TXCHO field.
	I2S_channel_TOR_TXCHO_Pos = 0x0
	// Bit mask of TXCHO field.
	I2S_channel_TOR_TXCHO_Msk = 0x1
	// Bit TXCHO.
	I2S_channel_TOR_TXCHO = 0x1

	// CHANNEL.RFCR: Receive FIFO Configuration Register
	// Position of RXCHDT field.
	I2S_channel_RFCR_RXCHDT_Pos = 0x0
	// Bit mask of RXCHDT field.
	I2S_channel_RFCR_RXCHDT_Msk = 0xf
	// Interrupt trigger when FIFO level is 1
	I2S_channel_RFCR_RXCHDT_LEVEL1 = 0x0
	// Interrupt trigger when FIFO level is 2
	I2S_channel_RFCR_RXCHDT_LEVEL2 = 0x1
	// Interrupt trigger when FIFO level is 3
	I2S_channel_RFCR_RXCHDT_LEVEL3 = 0x2
	// Interrupt trigger when FIFO level is 4
	I2S_channel_RFCR_RXCHDT_LEVEL4 = 0x3
	// Interrupt trigger when FIFO level is 5
	I2S_channel_RFCR_RXCHDT_LEVEL5 = 0x4
	// Interrupt trigger when FIFO level is 6
	I2S_channel_RFCR_RXCHDT_LEVEL6 = 0x5
	// Interrupt trigger when FIFO level is 7
	I2S_channel_RFCR_RXCHDT_LEVEL7 = 0x6
	// Interrupt trigger when FIFO level is 8
	I2S_channel_RFCR_RXCHDT_LEVEL8 = 0x7
	// Interrupt trigger when FIFO level is 9
	I2S_channel_RFCR_RXCHDT_LEVEL9 = 0x8
	// Interrupt trigger when FIFO level is 10
	I2S_channel_RFCR_RXCHDT_LEVEL10 = 0x9
	// Interrupt trigger when FIFO level is 11
	I2S_channel_RFCR_RXCHDT_LEVEL11 = 0xa
	// Interrupt trigger when FIFO level is 12
	I2S_channel_RFCR_RXCHDT_LEVEL12 = 0xb
	// Interrupt trigger when FIFO level is 13
	I2S_channel_RFCR_RXCHDT_LEVEL13 = 0xc
	// Interrupt trigger when FIFO level is 14
	I2S_channel_RFCR_RXCHDT_LEVEL14 = 0xd
	// Interrupt trigger when FIFO level is 15
	I2S_channel_RFCR_RXCHDT_LEVEL15 = 0xe
	// Interrupt trigger when FIFO level is 16
	I2S_channel_RFCR_RXCHDT_LEVEL16 = 0xf

	// CHANNEL.TFCR: Transmit FIFO Configuration Register
	// Position of TXCHET field.
	I2S_channel_TFCR_TXCHET_Pos = 0x0
	// Bit mask of TXCHET field.
	I2S_channel_TFCR_TXCHET_Msk = 0xf

	// CHANNEL.RFF: Receive FIFO Flush Register
	// Position of RXCHFR field.
	I2S_channel_RFF_RXCHFR_Pos = 0x0
	// Bit mask of RXCHFR field.
	I2S_channel_RFF_RXCHFR_Msk = 0x1
	// Bit RXCHFR.
	I2S_channel_RFF_RXCHFR = 0x1
	// Not flush an individual FIFO
	I2S_channel_RFF_RXCHFR_NOT_FLUSH = 0x0
	// Flush an indiviadual FIFO
	I2S_channel_RFF_RXCHFR_FLUSH = 0x1

	// CHANNEL.TFF: Transmit FIFO Flush Register
	// Position of RTXCHFR field.
	I2S_channel_TFF_RTXCHFR_Pos = 0x0
	// Bit mask of RTXCHFR field.
	I2S_channel_TFF_RTXCHFR_Msk = 0x1
	// Bit RTXCHFR.
	I2S_channel_TFF_RTXCHFR = 0x1

	// CHANNEL._RESERVED0: _RESERVED0

	// CHANNEL._RESERVED1: _RESERVED0
)

// Constants for APU: Audio Processor
const (
	// CH_CFG: Channel Config Register
	// Position of SOUND_CH_EN field.
	APU_CH_CFG_SOUND_CH_EN_Pos = 0x0
	// Bit mask of SOUND_CH_EN field.
	APU_CH_CFG_SOUND_CH_EN_Msk = 0xff
	// Position of TARGET_DIR field.
	APU_CH_CFG_TARGET_DIR_Pos = 0x8
	// Bit mask of TARGET_DIR field.
	APU_CH_CFG_TARGET_DIR_Msk = 0xf00
	// Position of AUDIO_GAIN field.
	APU_CH_CFG_AUDIO_GAIN_Pos = 0xc
	// Bit mask of AUDIO_GAIN field.
	APU_CH_CFG_AUDIO_GAIN_Msk = 0x7ff000
	// Position of DATA_SRC_MODE field.
	APU_CH_CFG_DATA_SRC_MODE_Pos = 0x18
	// Bit mask of DATA_SRC_MODE field.
	APU_CH_CFG_DATA_SRC_MODE_Msk = 0x1000000
	// Bit DATA_SRC_MODE.
	APU_CH_CFG_DATA_SRC_MODE = 0x1000000
	// Position of WE_SOUND_CH_EN field.
	APU_CH_CFG_WE_SOUND_CH_EN_Pos = 0x1c
	// Bit mask of WE_SOUND_CH_EN field.
	APU_CH_CFG_WE_SOUND_CH_EN_Msk = 0x10000000
	// Bit WE_SOUND_CH_EN.
	APU_CH_CFG_WE_SOUND_CH_EN = 0x10000000
	// Position of WE_TARGET_DIR field.
	APU_CH_CFG_WE_TARGET_DIR_Pos = 0x1d
	// Bit mask of WE_TARGET_DIR field.
	APU_CH_CFG_WE_TARGET_DIR_Msk = 0x20000000
	// Bit WE_TARGET_DIR.
	APU_CH_CFG_WE_TARGET_DIR = 0x20000000
	// Position of WE_AUDIO_GAIN field.
	APU_CH_CFG_WE_AUDIO_GAIN_Pos = 0x1e
	// Bit mask of WE_AUDIO_GAIN field.
	APU_CH_CFG_WE_AUDIO_GAIN_Msk = 0x40000000
	// Bit WE_AUDIO_GAIN.
	APU_CH_CFG_WE_AUDIO_GAIN = 0x40000000
	// Position of WE_DATA_SRC_MODE field.
	APU_CH_CFG_WE_DATA_SRC_MODE_Pos = 0x1f
	// Bit mask of WE_DATA_SRC_MODE field.
	APU_CH_CFG_WE_DATA_SRC_MODE_Msk = 0x80000000
	// Bit WE_DATA_SRC_MODE.
	APU_CH_CFG_WE_DATA_SRC_MODE = 0x80000000

	// CTL: Control Register
	// Position of DIR_SEARCH_EN field.
	APU_CTL_DIR_SEARCH_EN_Pos = 0x0
	// Bit mask of DIR_SEARCH_EN field.
	APU_CTL_DIR_SEARCH_EN_Msk = 0x1
	// Bit DIR_SEARCH_EN.
	APU_CTL_DIR_SEARCH_EN = 0x1
	// Position of SEARCH_PATH_RESET field.
	APU_CTL_SEARCH_PATH_RESET_Pos = 0x1
	// Bit mask of SEARCH_PATH_RESET field.
	APU_CTL_SEARCH_PATH_RESET_Msk = 0x2
	// Bit SEARCH_PATH_RESET.
	APU_CTL_SEARCH_PATH_RESET = 0x2
	// Position of STREAM_GEN_EN field.
	APU_CTL_STREAM_GEN_EN_Pos = 0x4
	// Bit mask of STREAM_GEN_EN field.
	APU_CTL_STREAM_GEN_EN_Msk = 0x10
	// Bit STREAM_GEN_EN.
	APU_CTL_STREAM_GEN_EN = 0x10
	// Position of VOICE_GEN_PATH_RESET field.
	APU_CTL_VOICE_GEN_PATH_RESET_Pos = 0x5
	// Bit mask of VOICE_GEN_PATH_RESET field.
	APU_CTL_VOICE_GEN_PATH_RESET_Msk = 0x20
	// Bit VOICE_GEN_PATH_RESET.
	APU_CTL_VOICE_GEN_PATH_RESET = 0x20
	// Position of UPDATE_VOICE_DIR field.
	APU_CTL_UPDATE_VOICE_DIR_Pos = 0x6
	// Bit mask of UPDATE_VOICE_DIR field.
	APU_CTL_UPDATE_VOICE_DIR_Msk = 0x40
	// Bit UPDATE_VOICE_DIR.
	APU_CTL_UPDATE_VOICE_DIR = 0x40
	// Position of WE_DIR_SEARCH_EN field.
	APU_CTL_WE_DIR_SEARCH_EN_Pos = 0x8
	// Bit mask of WE_DIR_SEARCH_EN field.
	APU_CTL_WE_DIR_SEARCH_EN_Msk = 0x100
	// Bit WE_DIR_SEARCH_EN.
	APU_CTL_WE_DIR_SEARCH_EN = 0x100
	// Position of WE_SEARCH_PATH_RST field.
	APU_CTL_WE_SEARCH_PATH_RST_Pos = 0x9
	// Bit mask of WE_SEARCH_PATH_RST field.
	APU_CTL_WE_SEARCH_PATH_RST_Msk = 0x200
	// Bit WE_SEARCH_PATH_RST.
	APU_CTL_WE_SEARCH_PATH_RST = 0x200
	// Position of WE_STREAM_GEN field.
	APU_CTL_WE_STREAM_GEN_Pos = 0xa
	// Bit mask of WE_STREAM_GEN field.
	APU_CTL_WE_STREAM_GEN_Msk = 0x400
	// Bit WE_STREAM_GEN.
	APU_CTL_WE_STREAM_GEN = 0x400
	// Position of WE_VOICE_GEN_PATH_RST field.
	APU_CTL_WE_VOICE_GEN_PATH_RST_Pos = 0xb
	// Bit mask of WE_VOICE_GEN_PATH_RST field.
	APU_CTL_WE_VOICE_GEN_PATH_RST_Msk = 0x800
	// Bit WE_VOICE_GEN_PATH_RST.
	APU_CTL_WE_VOICE_GEN_PATH_RST = 0x800
	// Position of WE_UPDATE_VOICE_DIR field.
	APU_CTL_WE_UPDATE_VOICE_DIR_Pos = 0xc
	// Bit mask of WE_UPDATE_VOICE_DIR field.
	APU_CTL_WE_UPDATE_VOICE_DIR_Msk = 0x1000
	// Bit WE_UPDATE_VOICE_DIR.
	APU_CTL_WE_UPDATE_VOICE_DIR = 0x1000

	// DIR_BIDX: Direction Sample Buffer Read Index Configure Register (16 directions * 2 values * 4 indices)
	// Position of RD_IDX_S field.
	APU_DIR_BIDX_RD_IDX_S_Pos = 0x0
	// Bit mask of RD_IDX_S field.
	APU_DIR_BIDX_RD_IDX_S_Msk = 0x3f

	// PRE_FIR0_COEF: FIR0 pre-filter coefficients
	// Position of TAP0 field.
	APU_PRE_FIR0_COEF_TAP0_Pos = 0x0
	// Bit mask of TAP0 field.
	APU_PRE_FIR0_COEF_TAP0_Msk = 0xffff
	// Position of TAP1 field.
	APU_PRE_FIR0_COEF_TAP1_Pos = 0x10
	// Bit mask of TAP1 field.
	APU_PRE_FIR0_COEF_TAP1_Msk = 0xffff0000

	// POST_FIR0_COEF: FIR0 post-filter coefficients
	// Position of TAP0 field.
	APU_POST_FIR0_COEF_TAP0_Pos = 0x0
	// Bit mask of TAP0 field.
	APU_POST_FIR0_COEF_TAP0_Msk = 0xffff
	// Position of TAP1 field.
	APU_POST_FIR0_COEF_TAP1_Pos = 0x10
	// Bit mask of TAP1 field.
	APU_POST_FIR0_COEF_TAP1_Msk = 0xffff0000

	// PRE_FIR1_COEF: FIR1 pre-filter coeffecients
	// Position of TAP0 field.
	APU_PRE_FIR1_COEF_TAP0_Pos = 0x0
	// Bit mask of TAP0 field.
	APU_PRE_FIR1_COEF_TAP0_Msk = 0xffff
	// Position of TAP1 field.
	APU_PRE_FIR1_COEF_TAP1_Pos = 0x10
	// Bit mask of TAP1 field.
	APU_PRE_FIR1_COEF_TAP1_Msk = 0xffff0000

	// POST_FIR1_COEF: FIR1 post-filter coefficients
	// Position of TAP0 field.
	APU_POST_FIR1_COEF_TAP0_Pos = 0x0
	// Bit mask of TAP0 field.
	APU_POST_FIR1_COEF_TAP0_Msk = 0xffff
	// Position of TAP1 field.
	APU_POST_FIR1_COEF_TAP1_Pos = 0x10
	// Bit mask of TAP1 field.
	APU_POST_FIR1_COEF_TAP1_Msk = 0xffff0000

	// DWSZ_CFG: Downsize Config Register
	// Position of DIR_DWN_SIZ_RATE field.
	APU_DWSZ_CFG_DIR_DWN_SIZ_RATE_Pos = 0x0
	// Bit mask of DIR_DWN_SIZ_RATE field.
	APU_DWSZ_CFG_DIR_DWN_SIZ_RATE_Msk = 0xf
	// Position of VOC_DWN_SIZ_RATE field.
	APU_DWSZ_CFG_VOC_DWN_SIZ_RATE_Pos = 0x4
	// Bit mask of VOC_DWN_SIZ_RATE field.
	APU_DWSZ_CFG_VOC_DWN_SIZ_RATE_Msk = 0xf0
	// Position of SMPL_SHIFT_BITS field.
	APU_DWSZ_CFG_SMPL_SHIFT_BITS_Pos = 0x8
	// Bit mask of SMPL_SHIFT_BITS field.
	APU_DWSZ_CFG_SMPL_SHIFT_BITS_Msk = 0x1f00

	// INT_STAT: Interrupt Status Register
	// Position of DIR_SEARCH_DATA_RDY field.
	APU_INT_STAT_DIR_SEARCH_DATA_RDY_Pos = 0x0
	// Bit mask of DIR_SEARCH_DATA_RDY field.
	APU_INT_STAT_DIR_SEARCH_DATA_RDY_Msk = 0x1
	// Bit DIR_SEARCH_DATA_RDY.
	APU_INT_STAT_DIR_SEARCH_DATA_RDY = 0x1
	// Position of VOC_BUF_DATA_RDY field.
	APU_INT_STAT_VOC_BUF_DATA_RDY_Pos = 0x1
	// Bit mask of VOC_BUF_DATA_RDY field.
	APU_INT_STAT_VOC_BUF_DATA_RDY_Msk = 0x2
	// Bit VOC_BUF_DATA_RDY.
	APU_INT_STAT_VOC_BUF_DATA_RDY = 0x2

	// INT_MASK: Interrupt Mask Register
	// Position of DIR_SEARCH_DATA_RDY field.
	APU_INT_MASK_DIR_SEARCH_DATA_RDY_Pos = 0x0
	// Bit mask of DIR_SEARCH_DATA_RDY field.
	APU_INT_MASK_DIR_SEARCH_DATA_RDY_Msk = 0x1
	// Bit DIR_SEARCH_DATA_RDY.
	APU_INT_MASK_DIR_SEARCH_DATA_RDY = 0x1
	// Position of VOC_BUF_DATA_RDY field.
	APU_INT_MASK_VOC_BUF_DATA_RDY_Pos = 0x1
	// Bit mask of VOC_BUF_DATA_RDY field.
	APU_INT_MASK_VOC_BUF_DATA_RDY_Msk = 0x2
	// Bit VOC_BUF_DATA_RDY.
	APU_INT_MASK_VOC_BUF_DATA_RDY = 0x2

	// SAT_COUNTER: Saturation Counter
	// Position of COUNTER field.
	APU_SAT_COUNTER_COUNTER_Pos = 0x0
	// Bit mask of COUNTER field.
	APU_SAT_COUNTER_COUNTER_Msk = 0xffff
	// Position of TOTAL field.
	APU_SAT_COUNTER_TOTAL_Pos = 0x10
	// Bit mask of TOTAL field.
	APU_SAT_COUNTER_TOTAL_Msk = 0xffff0000

	// SAT_LIMITS: Saturation Limits
	// Position of UPPER field.
	APU_SAT_LIMITS_UPPER_Pos = 0x0
	// Bit mask of UPPER field.
	APU_SAT_LIMITS_UPPER_Msk = 0xffff
	// Position of BOTTOM field.
	APU_SAT_LIMITS_BOTTOM_Pos = 0x10
	// Bit mask of BOTTOM field.
	APU_SAT_LIMITS_BOTTOM_Msk = 0xffff0000
)

// Constants for I2C0: Inter-Integrated Circuit Bus 0
const (
	// CON: Control Register
	// Position of MASTER_MODE field.
	I2C_CON_MASTER_MODE_Pos = 0x0
	// Bit mask of MASTER_MODE field.
	I2C_CON_MASTER_MODE_Msk = 0x1
	// Bit MASTER_MODE.
	I2C_CON_MASTER_MODE = 0x1
	// Position of SPEED field.
	I2C_CON_SPEED_Pos = 0x1
	// Bit mask of SPEED field.
	I2C_CON_SPEED_Msk = 0x6
	// STANDARD
	I2C_CON_SPEED_STANDARD = 0x0
	// FAST
	I2C_CON_SPEED_FAST = 0x1
	// HIGHSPEED
	I2C_CON_SPEED_HIGHSPEED = 0x2
	// Position of ADDR_SLAVE_WIDTH field.
	I2C_CON_ADDR_SLAVE_WIDTH_Pos = 0x3
	// Bit mask of ADDR_SLAVE_WIDTH field.
	I2C_CON_ADDR_SLAVE_WIDTH_Msk = 0x8
	// Bit ADDR_SLAVE_WIDTH.
	I2C_CON_ADDR_SLAVE_WIDTH = 0x8
	// 7-bit address
	I2C_CON_ADDR_SLAVE_WIDTH_B7 = 0x0
	// 10-bit address
	I2C_CON_ADDR_SLAVE_WIDTH_B10 = 0x1
	// Position of RESTART_EN field.
	I2C_CON_RESTART_EN_Pos = 0x5
	// Bit mask of RESTART_EN field.
	I2C_CON_RESTART_EN_Msk = 0x20
	// Bit RESTART_EN.
	I2C_CON_RESTART_EN = 0x20
	// Position of SLAVE_DISABLE field.
	I2C_CON_SLAVE_DISABLE_Pos = 0x6
	// Bit mask of SLAVE_DISABLE field.
	I2C_CON_SLAVE_DISABLE_Msk = 0x40
	// Bit SLAVE_DISABLE.
	I2C_CON_SLAVE_DISABLE = 0x40
	// Position of STOP_DET field.
	I2C_CON_STOP_DET_Pos = 0x7
	// Bit mask of STOP_DET field.
	I2C_CON_STOP_DET_Msk = 0x80
	// Bit STOP_DET.
	I2C_CON_STOP_DET = 0x80
	// Position of TX_EMPTY field.
	I2C_CON_TX_EMPTY_Pos = 0x8
	// Bit mask of TX_EMPTY field.
	I2C_CON_TX_EMPTY_Msk = 0x100
	// Bit TX_EMPTY.
	I2C_CON_TX_EMPTY = 0x100

	// TAR: Target Address Register
	// Position of ADDRESS field.
	I2C_TAR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	I2C_TAR_ADDRESS_Msk = 0x3ff
	// Position of GC field.
	I2C_TAR_GC_Pos = 0xa
	// Bit mask of GC field.
	I2C_TAR_GC_Msk = 0x400
	// Bit GC.
	I2C_TAR_GC = 0x400
	// Position of SPECIAL field.
	I2C_TAR_SPECIAL_Pos = 0xb
	// Bit mask of SPECIAL field.
	I2C_TAR_SPECIAL_Msk = 0x800
	// Bit SPECIAL.
	I2C_TAR_SPECIAL = 0x800
	// Position of ADDR_MASTER_WIDTH field.
	I2C_TAR_ADDR_MASTER_WIDTH_Pos = 0xc
	// Bit mask of ADDR_MASTER_WIDTH field.
	I2C_TAR_ADDR_MASTER_WIDTH_Msk = 0x1000
	// Bit ADDR_MASTER_WIDTH.
	I2C_TAR_ADDR_MASTER_WIDTH = 0x1000
	// 7-bit address
	I2C_TAR_ADDR_MASTER_WIDTH_B7 = 0x0
	// 10-bit address
	I2C_TAR_ADDR_MASTER_WIDTH_B10 = 0x1

	// SAR: Slave Address Register
	// Position of ADDRESS field.
	I2C_SAR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	I2C_SAR_ADDRESS_Msk = 0x3ff

	// DATA_CMD: Data Buffer and Command Register
	// Position of CMD field.
	I2C_DATA_CMD_CMD_Pos = 0x8
	// Bit mask of CMD field.
	I2C_DATA_CMD_CMD_Msk = 0x100
	// Bit CMD.
	I2C_DATA_CMD_CMD = 0x100
	// Position of DATA field.
	I2C_DATA_CMD_DATA_Pos = 0x0
	// Bit mask of DATA field.
	I2C_DATA_CMD_DATA_Msk = 0xff

	// SS_SCL_HCNT: Standard Speed Clock SCL High Count Register
	// Position of COUNT field.
	I2C_SS_SCL_HCNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	I2C_SS_SCL_HCNT_COUNT_Msk = 0xffff

	// SS_SCL_LCNT: Standard Speed Clock SCL Low Count Register
	// Position of COUNT field.
	I2C_SS_SCL_LCNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	I2C_SS_SCL_LCNT_COUNT_Msk = 0xffff

	// INTR_STAT: Interrupt Status Register
	// Position of RX_UNDER field.
	I2C_INTR_STAT_RX_UNDER_Pos = 0x0
	// Bit mask of RX_UNDER field.
	I2C_INTR_STAT_RX_UNDER_Msk = 0x1
	// Bit RX_UNDER.
	I2C_INTR_STAT_RX_UNDER = 0x1
	// Position of RX_OVER field.
	I2C_INTR_STAT_RX_OVER_Pos = 0x1
	// Bit mask of RX_OVER field.
	I2C_INTR_STAT_RX_OVER_Msk = 0x2
	// Bit RX_OVER.
	I2C_INTR_STAT_RX_OVER = 0x2
	// Position of RX_FULL field.
	I2C_INTR_STAT_RX_FULL_Pos = 0x2
	// Bit mask of RX_FULL field.
	I2C_INTR_STAT_RX_FULL_Msk = 0x4
	// Bit RX_FULL.
	I2C_INTR_STAT_RX_FULL = 0x4
	// Position of TX_OVER field.
	I2C_INTR_STAT_TX_OVER_Pos = 0x3
	// Bit mask of TX_OVER field.
	I2C_INTR_STAT_TX_OVER_Msk = 0x8
	// Bit TX_OVER.
	I2C_INTR_STAT_TX_OVER = 0x8
	// Position of TX_EMPTY field.
	I2C_INTR_STAT_TX_EMPTY_Pos = 0x4
	// Bit mask of TX_EMPTY field.
	I2C_INTR_STAT_TX_EMPTY_Msk = 0x10
	// Bit TX_EMPTY.
	I2C_INTR_STAT_TX_EMPTY = 0x10
	// Position of RD_REQ field.
	I2C_INTR_STAT_RD_REQ_Pos = 0x5
	// Bit mask of RD_REQ field.
	I2C_INTR_STAT_RD_REQ_Msk = 0x20
	// Bit RD_REQ.
	I2C_INTR_STAT_RD_REQ = 0x20
	// Position of TX_ABRT field.
	I2C_INTR_STAT_TX_ABRT_Pos = 0x6
	// Bit mask of TX_ABRT field.
	I2C_INTR_STAT_TX_ABRT_Msk = 0x40
	// Bit TX_ABRT.
	I2C_INTR_STAT_TX_ABRT = 0x40
	// Position of RX_DONE field.
	I2C_INTR_STAT_RX_DONE_Pos = 0x7
	// Bit mask of RX_DONE field.
	I2C_INTR_STAT_RX_DONE_Msk = 0x80
	// Bit RX_DONE.
	I2C_INTR_STAT_RX_DONE = 0x80
	// Position of ACTIVITY field.
	I2C_INTR_STAT_ACTIVITY_Pos = 0x8
	// Bit mask of ACTIVITY field.
	I2C_INTR_STAT_ACTIVITY_Msk = 0x100
	// Bit ACTIVITY.
	I2C_INTR_STAT_ACTIVITY = 0x100
	// Position of STOP_DET field.
	I2C_INTR_STAT_STOP_DET_Pos = 0x9
	// Bit mask of STOP_DET field.
	I2C_INTR_STAT_STOP_DET_Msk = 0x200
	// Bit STOP_DET.
	I2C_INTR_STAT_STOP_DET = 0x200
	// Position of START_DET field.
	I2C_INTR_STAT_START_DET_Pos = 0xa
	// Bit mask of START_DET field.
	I2C_INTR_STAT_START_DET_Msk = 0x400
	// Bit START_DET.
	I2C_INTR_STAT_START_DET = 0x400
	// Position of GEN_CALL field.
	I2C_INTR_STAT_GEN_CALL_Pos = 0xb
	// Bit mask of GEN_CALL field.
	I2C_INTR_STAT_GEN_CALL_Msk = 0x800
	// Bit GEN_CALL.
	I2C_INTR_STAT_GEN_CALL = 0x800

	// INTR_MASK: Interrupt Mask Register
	// Position of RX_UNDER field.
	I2C_INTR_MASK_RX_UNDER_Pos = 0x0
	// Bit mask of RX_UNDER field.
	I2C_INTR_MASK_RX_UNDER_Msk = 0x1
	// Bit RX_UNDER.
	I2C_INTR_MASK_RX_UNDER = 0x1
	// Position of RX_OVER field.
	I2C_INTR_MASK_RX_OVER_Pos = 0x1
	// Bit mask of RX_OVER field.
	I2C_INTR_MASK_RX_OVER_Msk = 0x2
	// Bit RX_OVER.
	I2C_INTR_MASK_RX_OVER = 0x2
	// Position of RX_FULL field.
	I2C_INTR_MASK_RX_FULL_Pos = 0x2
	// Bit mask of RX_FULL field.
	I2C_INTR_MASK_RX_FULL_Msk = 0x4
	// Bit RX_FULL.
	I2C_INTR_MASK_RX_FULL = 0x4
	// Position of TX_OVER field.
	I2C_INTR_MASK_TX_OVER_Pos = 0x3
	// Bit mask of TX_OVER field.
	I2C_INTR_MASK_TX_OVER_Msk = 0x8
	// Bit TX_OVER.
	I2C_INTR_MASK_TX_OVER = 0x8
	// Position of TX_EMPTY field.
	I2C_INTR_MASK_TX_EMPTY_Pos = 0x4
	// Bit mask of TX_EMPTY field.
	I2C_INTR_MASK_TX_EMPTY_Msk = 0x10
	// Bit TX_EMPTY.
	I2C_INTR_MASK_TX_EMPTY = 0x10
	// Position of RD_REQ field.
	I2C_INTR_MASK_RD_REQ_Pos = 0x5
	// Bit mask of RD_REQ field.
	I2C_INTR_MASK_RD_REQ_Msk = 0x20
	// Bit RD_REQ.
	I2C_INTR_MASK_RD_REQ = 0x20
	// Position of TX_ABRT field.
	I2C_INTR_MASK_TX_ABRT_Pos = 0x6
	// Bit mask of TX_ABRT field.
	I2C_INTR_MASK_TX_ABRT_Msk = 0x40
	// Bit TX_ABRT.
	I2C_INTR_MASK_TX_ABRT = 0x40
	// Position of RX_DONE field.
	I2C_INTR_MASK_RX_DONE_Pos = 0x7
	// Bit mask of RX_DONE field.
	I2C_INTR_MASK_RX_DONE_Msk = 0x80
	// Bit RX_DONE.
	I2C_INTR_MASK_RX_DONE = 0x80
	// Position of ACTIVITY field.
	I2C_INTR_MASK_ACTIVITY_Pos = 0x8
	// Bit mask of ACTIVITY field.
	I2C_INTR_MASK_ACTIVITY_Msk = 0x100
	// Bit ACTIVITY.
	I2C_INTR_MASK_ACTIVITY = 0x100
	// Position of STOP_DET field.
	I2C_INTR_MASK_STOP_DET_Pos = 0x9
	// Bit mask of STOP_DET field.
	I2C_INTR_MASK_STOP_DET_Msk = 0x200
	// Bit STOP_DET.
	I2C_INTR_MASK_STOP_DET = 0x200
	// Position of START_DET field.
	I2C_INTR_MASK_START_DET_Pos = 0xa
	// Bit mask of START_DET field.
	I2C_INTR_MASK_START_DET_Msk = 0x400
	// Bit START_DET.
	I2C_INTR_MASK_START_DET = 0x400
	// Position of GEN_CALL field.
	I2C_INTR_MASK_GEN_CALL_Pos = 0xb
	// Bit mask of GEN_CALL field.
	I2C_INTR_MASK_GEN_CALL_Msk = 0x800
	// Bit GEN_CALL.
	I2C_INTR_MASK_GEN_CALL = 0x800

	// RAW_INTR_STAT: Raw Interrupt Status Register
	// Position of RX_UNDER field.
	I2C_RAW_INTR_STAT_RX_UNDER_Pos = 0x0
	// Bit mask of RX_UNDER field.
	I2C_RAW_INTR_STAT_RX_UNDER_Msk = 0x1
	// Bit RX_UNDER.
	I2C_RAW_INTR_STAT_RX_UNDER = 0x1
	// Position of RX_OVER field.
	I2C_RAW_INTR_STAT_RX_OVER_Pos = 0x1
	// Bit mask of RX_OVER field.
	I2C_RAW_INTR_STAT_RX_OVER_Msk = 0x2
	// Bit RX_OVER.
	I2C_RAW_INTR_STAT_RX_OVER = 0x2
	// Position of RX_FULL field.
	I2C_RAW_INTR_STAT_RX_FULL_Pos = 0x2
	// Bit mask of RX_FULL field.
	I2C_RAW_INTR_STAT_RX_FULL_Msk = 0x4
	// Bit RX_FULL.
	I2C_RAW_INTR_STAT_RX_FULL = 0x4
	// Position of TX_OVER field.
	I2C_RAW_INTR_STAT_TX_OVER_Pos = 0x3
	// Bit mask of TX_OVER field.
	I2C_RAW_INTR_STAT_TX_OVER_Msk = 0x8
	// Bit TX_OVER.
	I2C_RAW_INTR_STAT_TX_OVER = 0x8
	// Position of TX_EMPTY field.
	I2C_RAW_INTR_STAT_TX_EMPTY_Pos = 0x4
	// Bit mask of TX_EMPTY field.
	I2C_RAW_INTR_STAT_TX_EMPTY_Msk = 0x10
	// Bit TX_EMPTY.
	I2C_RAW_INTR_STAT_TX_EMPTY = 0x10
	// Position of RD_REQ field.
	I2C_RAW_INTR_STAT_RD_REQ_Pos = 0x5
	// Bit mask of RD_REQ field.
	I2C_RAW_INTR_STAT_RD_REQ_Msk = 0x20
	// Bit RD_REQ.
	I2C_RAW_INTR_STAT_RD_REQ = 0x20
	// Position of TX_ABRT field.
	I2C_RAW_INTR_STAT_TX_ABRT_Pos = 0x6
	// Bit mask of TX_ABRT field.
	I2C_RAW_INTR_STAT_TX_ABRT_Msk = 0x40
	// Bit TX_ABRT.
	I2C_RAW_INTR_STAT_TX_ABRT = 0x40
	// Position of RX_DONE field.
	I2C_RAW_INTR_STAT_RX_DONE_Pos = 0x7
	// Bit mask of RX_DONE field.
	I2C_RAW_INTR_STAT_RX_DONE_Msk = 0x80
	// Bit RX_DONE.
	I2C_RAW_INTR_STAT_RX_DONE = 0x80
	// Position of ACTIVITY field.
	I2C_RAW_INTR_STAT_ACTIVITY_Pos = 0x8
	// Bit mask of ACTIVITY field.
	I2C_RAW_INTR_STAT_ACTIVITY_Msk = 0x100
	// Bit ACTIVITY.
	I2C_RAW_INTR_STAT_ACTIVITY = 0x100
	// Position of STOP_DET field.
	I2C_RAW_INTR_STAT_STOP_DET_Pos = 0x9
	// Bit mask of STOP_DET field.
	I2C_RAW_INTR_STAT_STOP_DET_Msk = 0x200
	// Bit STOP_DET.
	I2C_RAW_INTR_STAT_STOP_DET = 0x200
	// Position of START_DET field.
	I2C_RAW_INTR_STAT_START_DET_Pos = 0xa
	// Bit mask of START_DET field.
	I2C_RAW_INTR_STAT_START_DET_Msk = 0x400
	// Bit START_DET.
	I2C_RAW_INTR_STAT_START_DET = 0x400
	// Position of GEN_CALL field.
	I2C_RAW_INTR_STAT_GEN_CALL_Pos = 0xb
	// Bit mask of GEN_CALL field.
	I2C_RAW_INTR_STAT_GEN_CALL_Msk = 0x800
	// Bit GEN_CALL.
	I2C_RAW_INTR_STAT_GEN_CALL = 0x800

	// RX_TL: Receive FIFO Threshold Register
	// Position of VALUE field.
	I2C_RX_TL_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_RX_TL_VALUE_Msk = 0x7

	// TX_TL: Transmit FIFO Threshold Register
	// Position of VALUE field.
	I2C_TX_TL_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_TX_TL_VALUE_Msk = 0x7

	// CLR_INTR: Clear Combined and Individual Interrupt Register
	// Position of CLR field.
	I2C_CLR_INTR_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_INTR_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_INTR_CLR = 0x1

	// CLR_RX_UNDER: Clear RX_UNDER Interrupt Register
	// Position of CLR field.
	I2C_CLR_RX_UNDER_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_RX_UNDER_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_RX_UNDER_CLR = 0x1

	// CLR_RX_OVER: Clear RX_OVER Interrupt Register
	// Position of CLR field.
	I2C_CLR_RX_OVER_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_RX_OVER_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_RX_OVER_CLR = 0x1

	// CLR_TX_OVER: Clear TX_OVER Interrupt Register
	// Position of CLR field.
	I2C_CLR_TX_OVER_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_TX_OVER_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_TX_OVER_CLR = 0x1

	// CLR_RD_REQ: Clear RD_REQ Interrupt Register
	// Position of CLR field.
	I2C_CLR_RD_REQ_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_RD_REQ_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_RD_REQ_CLR = 0x1

	// CLR_TX_ABRT: Clear TX_ABRT Interrupt Register
	// Position of CLR field.
	I2C_CLR_TX_ABRT_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_TX_ABRT_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_TX_ABRT_CLR = 0x1

	// CLR_RX_DONE: Clear RX_DONE Interrupt Register
	// Position of CLR field.
	I2C_CLR_RX_DONE_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_RX_DONE_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_RX_DONE_CLR = 0x1

	// CLR_ACTIVITY: Clear ACTIVITY Interrupt Register
	// Position of CLR field.
	I2C_CLR_ACTIVITY_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_ACTIVITY_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_ACTIVITY_CLR = 0x1

	// CLR_STOP_DET: Clear STOP_DET Interrupt Register
	// Position of CLR field.
	I2C_CLR_STOP_DET_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_STOP_DET_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_STOP_DET_CLR = 0x1

	// CLR_START_DET: Clear START_DET Interrupt Register
	// Position of CLR field.
	I2C_CLR_START_DET_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_START_DET_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_START_DET_CLR = 0x1

	// CLR_GEN_CALL: I2C Clear GEN_CALL Interrupt Register
	// Position of CLR field.
	I2C_CLR_GEN_CALL_CLR_Pos = 0x0
	// Bit mask of CLR field.
	I2C_CLR_GEN_CALL_CLR_Msk = 0x1
	// Bit CLR.
	I2C_CLR_GEN_CALL_CLR = 0x1

	// ENABLE: Enable Register
	// Position of ENABLE field.
	I2C_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	I2C_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	I2C_ENABLE_ENABLE = 0x1
	// Position of ABORT field.
	I2C_ENABLE_ABORT_Pos = 0x1
	// Bit mask of ABORT field.
	I2C_ENABLE_ABORT_Msk = 0x2
	// Bit ABORT.
	I2C_ENABLE_ABORT = 0x2
	// Position of TX_CMD_BLOCK field.
	I2C_ENABLE_TX_CMD_BLOCK_Pos = 0x2
	// Bit mask of TX_CMD_BLOCK field.
	I2C_ENABLE_TX_CMD_BLOCK_Msk = 0x4
	// Bit TX_CMD_BLOCK.
	I2C_ENABLE_TX_CMD_BLOCK = 0x4

	// STATUS: Status Register
	// Position of ACTIVITY field.
	I2C_STATUS_ACTIVITY_Pos = 0x0
	// Bit mask of ACTIVITY field.
	I2C_STATUS_ACTIVITY_Msk = 0x1
	// Bit ACTIVITY.
	I2C_STATUS_ACTIVITY = 0x1
	// Position of TFNF field.
	I2C_STATUS_TFNF_Pos = 0x1
	// Bit mask of TFNF field.
	I2C_STATUS_TFNF_Msk = 0x2
	// Bit TFNF.
	I2C_STATUS_TFNF = 0x2
	// Position of TFE field.
	I2C_STATUS_TFE_Pos = 0x2
	// Bit mask of TFE field.
	I2C_STATUS_TFE_Msk = 0x4
	// Bit TFE.
	I2C_STATUS_TFE = 0x4
	// Position of RFNE field.
	I2C_STATUS_RFNE_Pos = 0x3
	// Bit mask of RFNE field.
	I2C_STATUS_RFNE_Msk = 0x8
	// Bit RFNE.
	I2C_STATUS_RFNE = 0x8
	// Position of RFF field.
	I2C_STATUS_RFF_Pos = 0x4
	// Bit mask of RFF field.
	I2C_STATUS_RFF_Msk = 0x10
	// Bit RFF.
	I2C_STATUS_RFF = 0x10
	// Position of MST_ACTIVITY field.
	I2C_STATUS_MST_ACTIVITY_Pos = 0x5
	// Bit mask of MST_ACTIVITY field.
	I2C_STATUS_MST_ACTIVITY_Msk = 0x20
	// Bit MST_ACTIVITY.
	I2C_STATUS_MST_ACTIVITY = 0x20
	// Position of SLV_ACTIVITY field.
	I2C_STATUS_SLV_ACTIVITY_Pos = 0x6
	// Bit mask of SLV_ACTIVITY field.
	I2C_STATUS_SLV_ACTIVITY_Msk = 0x40
	// Bit SLV_ACTIVITY.
	I2C_STATUS_SLV_ACTIVITY = 0x40

	// TXFLR: Transmit FIFO Level Register
	// Position of VALUE field.
	I2C_TXFLR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_TXFLR_VALUE_Msk = 0x7

	// RXFLR: Receive FIFO Level Register
	// Position of VALUE field.
	I2C_RXFLR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_RXFLR_VALUE_Msk = 0x7

	// SDA_HOLD: SDA Hold Time Length Register
	// Position of TX field.
	I2C_SDA_HOLD_TX_Pos = 0x0
	// Bit mask of TX field.
	I2C_SDA_HOLD_TX_Msk = 0xffff
	// Position of RX field.
	I2C_SDA_HOLD_RX_Pos = 0x10
	// Bit mask of RX field.
	I2C_SDA_HOLD_RX_Msk = 0xff0000

	// TX_ABRT_SOURCE: Transmit Abort Source Register
	// Position of ADDR7_NOACK field.
	I2C_TX_ABRT_SOURCE_ADDR7_NOACK_Pos = 0x0
	// Bit mask of ADDR7_NOACK field.
	I2C_TX_ABRT_SOURCE_ADDR7_NOACK_Msk = 0x1
	// Bit ADDR7_NOACK.
	I2C_TX_ABRT_SOURCE_ADDR7_NOACK = 0x1
	// Position of ADDR1_10_NOACK field.
	I2C_TX_ABRT_SOURCE_ADDR1_10_NOACK_Pos = 0x1
	// Bit mask of ADDR1_10_NOACK field.
	I2C_TX_ABRT_SOURCE_ADDR1_10_NOACK_Msk = 0x2
	// Bit ADDR1_10_NOACK.
	I2C_TX_ABRT_SOURCE_ADDR1_10_NOACK = 0x2
	// Position of ADDR2_10_NOACK field.
	I2C_TX_ABRT_SOURCE_ADDR2_10_NOACK_Pos = 0x2
	// Bit mask of ADDR2_10_NOACK field.
	I2C_TX_ABRT_SOURCE_ADDR2_10_NOACK_Msk = 0x4
	// Bit ADDR2_10_NOACK.
	I2C_TX_ABRT_SOURCE_ADDR2_10_NOACK = 0x4
	// Position of TXDATA_NOACK field.
	I2C_TX_ABRT_SOURCE_TXDATA_NOACK_Pos = 0x3
	// Bit mask of TXDATA_NOACK field.
	I2C_TX_ABRT_SOURCE_TXDATA_NOACK_Msk = 0x8
	// Bit TXDATA_NOACK.
	I2C_TX_ABRT_SOURCE_TXDATA_NOACK = 0x8
	// Position of GCALL_NOACK field.
	I2C_TX_ABRT_SOURCE_GCALL_NOACK_Pos = 0x4
	// Bit mask of GCALL_NOACK field.
	I2C_TX_ABRT_SOURCE_GCALL_NOACK_Msk = 0x10
	// Bit GCALL_NOACK.
	I2C_TX_ABRT_SOURCE_GCALL_NOACK = 0x10
	// Position of GCALL_READ field.
	I2C_TX_ABRT_SOURCE_GCALL_READ_Pos = 0x5
	// Bit mask of GCALL_READ field.
	I2C_TX_ABRT_SOURCE_GCALL_READ_Msk = 0x20
	// Bit GCALL_READ.
	I2C_TX_ABRT_SOURCE_GCALL_READ = 0x20
	// Position of HS_ACKDET field.
	I2C_TX_ABRT_SOURCE_HS_ACKDET_Pos = 0x6
	// Bit mask of HS_ACKDET field.
	I2C_TX_ABRT_SOURCE_HS_ACKDET_Msk = 0x40
	// Bit HS_ACKDET.
	I2C_TX_ABRT_SOURCE_HS_ACKDET = 0x40
	// Position of SBYTE_ACKDET field.
	I2C_TX_ABRT_SOURCE_SBYTE_ACKDET_Pos = 0x7
	// Bit mask of SBYTE_ACKDET field.
	I2C_TX_ABRT_SOURCE_SBYTE_ACKDET_Msk = 0x80
	// Bit SBYTE_ACKDET.
	I2C_TX_ABRT_SOURCE_SBYTE_ACKDET = 0x80
	// Position of HS_NORSTRT field.
	I2C_TX_ABRT_SOURCE_HS_NORSTRT_Pos = 0x8
	// Bit mask of HS_NORSTRT field.
	I2C_TX_ABRT_SOURCE_HS_NORSTRT_Msk = 0x100
	// Bit HS_NORSTRT.
	I2C_TX_ABRT_SOURCE_HS_NORSTRT = 0x100
	// Position of SBYTE_NORSTRT field.
	I2C_TX_ABRT_SOURCE_SBYTE_NORSTRT_Pos = 0x9
	// Bit mask of SBYTE_NORSTRT field.
	I2C_TX_ABRT_SOURCE_SBYTE_NORSTRT_Msk = 0x200
	// Bit SBYTE_NORSTRT.
	I2C_TX_ABRT_SOURCE_SBYTE_NORSTRT = 0x200
	// Position of RD_10_NORSTRT field.
	I2C_TX_ABRT_SOURCE_RD_10_NORSTRT_Pos = 0xa
	// Bit mask of RD_10_NORSTRT field.
	I2C_TX_ABRT_SOURCE_RD_10_NORSTRT_Msk = 0x400
	// Bit RD_10_NORSTRT.
	I2C_TX_ABRT_SOURCE_RD_10_NORSTRT = 0x400
	// Position of MASTER_DIS field.
	I2C_TX_ABRT_SOURCE_MASTER_DIS_Pos = 0xb
	// Bit mask of MASTER_DIS field.
	I2C_TX_ABRT_SOURCE_MASTER_DIS_Msk = 0x800
	// Bit MASTER_DIS.
	I2C_TX_ABRT_SOURCE_MASTER_DIS = 0x800
	// Position of MST_ARBLOST field.
	I2C_TX_ABRT_SOURCE_MST_ARBLOST_Pos = 0xc
	// Bit mask of MST_ARBLOST field.
	I2C_TX_ABRT_SOURCE_MST_ARBLOST_Msk = 0x1000
	// Bit MST_ARBLOST.
	I2C_TX_ABRT_SOURCE_MST_ARBLOST = 0x1000
	// Position of SLVFLUSH_TXFIFO field.
	I2C_TX_ABRT_SOURCE_SLVFLUSH_TXFIFO_Pos = 0xd
	// Bit mask of SLVFLUSH_TXFIFO field.
	I2C_TX_ABRT_SOURCE_SLVFLUSH_TXFIFO_Msk = 0x2000
	// Bit SLVFLUSH_TXFIFO.
	I2C_TX_ABRT_SOURCE_SLVFLUSH_TXFIFO = 0x2000
	// Position of SLV_ARBLOST field.
	I2C_TX_ABRT_SOURCE_SLV_ARBLOST_Pos = 0xe
	// Bit mask of SLV_ARBLOST field.
	I2C_TX_ABRT_SOURCE_SLV_ARBLOST_Msk = 0x4000
	// Bit SLV_ARBLOST.
	I2C_TX_ABRT_SOURCE_SLV_ARBLOST = 0x4000
	// Position of SLVRD_INTX field.
	I2C_TX_ABRT_SOURCE_SLVRD_INTX_Pos = 0xf
	// Bit mask of SLVRD_INTX field.
	I2C_TX_ABRT_SOURCE_SLVRD_INTX_Msk = 0x8000
	// Bit SLVRD_INTX.
	I2C_TX_ABRT_SOURCE_SLVRD_INTX = 0x8000
	// Position of USER_ABRT field.
	I2C_TX_ABRT_SOURCE_USER_ABRT_Pos = 0x10
	// Bit mask of USER_ABRT field.
	I2C_TX_ABRT_SOURCE_USER_ABRT_Msk = 0x10000
	// Bit USER_ABRT.
	I2C_TX_ABRT_SOURCE_USER_ABRT = 0x10000

	// DMA_CR: I2C DMA Control Register
	// Position of RDMAE field.
	I2C_DMA_CR_RDMAE_Pos = 0x0
	// Bit mask of RDMAE field.
	I2C_DMA_CR_RDMAE_Msk = 0x1
	// Bit RDMAE.
	I2C_DMA_CR_RDMAE = 0x1
	// Position of TDMAE field.
	I2C_DMA_CR_TDMAE_Pos = 0x1
	// Bit mask of TDMAE field.
	I2C_DMA_CR_TDMAE_Msk = 0x2
	// Bit TDMAE.
	I2C_DMA_CR_TDMAE = 0x2

	// DMA_TDLR: DMA Transmit Data Level Register
	// Position of VALUE field.
	I2C_DMA_TDLR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_DMA_TDLR_VALUE_Msk = 0x7

	// DMA_RDLR: DMA Receive Data Level Register
	// Position of VALUE field.
	I2C_DMA_RDLR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_DMA_RDLR_VALUE_Msk = 0x7

	// SDA_SETUP: SDA Setup Register
	// Position of VALUE field.
	I2C_SDA_SETUP_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_SDA_SETUP_VALUE_Msk = 0xff

	// GENERAL_CALL: ACK General Call Register
	// Position of CALL_ENABLE field.
	I2C_GENERAL_CALL_CALL_ENABLE_Pos = 0x0
	// Bit mask of CALL_ENABLE field.
	I2C_GENERAL_CALL_CALL_ENABLE_Msk = 0x1
	// Bit CALL_ENABLE.
	I2C_GENERAL_CALL_CALL_ENABLE = 0x1

	// ENABLE_STATUS: Enable Status Register
	// Position of IC_ENABLE field.
	I2C_ENABLE_STATUS_IC_ENABLE_Pos = 0x0
	// Bit mask of IC_ENABLE field.
	I2C_ENABLE_STATUS_IC_ENABLE_Msk = 0x1
	// Bit IC_ENABLE.
	I2C_ENABLE_STATUS_IC_ENABLE = 0x1
	// Position of SLV_DIS_BUSY field.
	I2C_ENABLE_STATUS_SLV_DIS_BUSY_Pos = 0x1
	// Bit mask of SLV_DIS_BUSY field.
	I2C_ENABLE_STATUS_SLV_DIS_BUSY_Msk = 0x2
	// Bit SLV_DIS_BUSY.
	I2C_ENABLE_STATUS_SLV_DIS_BUSY = 0x2
	// Position of SLV_RX_DATA_LOST field.
	I2C_ENABLE_STATUS_SLV_RX_DATA_LOST_Pos = 0x2
	// Bit mask of SLV_RX_DATA_LOST field.
	I2C_ENABLE_STATUS_SLV_RX_DATA_LOST_Msk = 0x4
	// Bit SLV_RX_DATA_LOST.
	I2C_ENABLE_STATUS_SLV_RX_DATA_LOST = 0x4

	// FS_SPKLEN: SS, FS or FM+ spike suppression limit
	// Position of VALUE field.
	I2C_FS_SPKLEN_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_FS_SPKLEN_VALUE_Msk = 0xff

	// COMP_PARAM_1: Component Parameter Register 1
	// Position of APB_DATA_WIDTH field.
	I2C_COMP_PARAM_1_APB_DATA_WIDTH_Pos = 0x0
	// Bit mask of APB_DATA_WIDTH field.
	I2C_COMP_PARAM_1_APB_DATA_WIDTH_Msk = 0x3
	// Position of MAX_SPEED_MODE field.
	I2C_COMP_PARAM_1_MAX_SPEED_MODE_Pos = 0x2
	// Bit mask of MAX_SPEED_MODE field.
	I2C_COMP_PARAM_1_MAX_SPEED_MODE_Msk = 0xc
	// Position of HC_COUNT_VALUES field.
	I2C_COMP_PARAM_1_HC_COUNT_VALUES_Pos = 0x4
	// Bit mask of HC_COUNT_VALUES field.
	I2C_COMP_PARAM_1_HC_COUNT_VALUES_Msk = 0x10
	// Bit HC_COUNT_VALUES.
	I2C_COMP_PARAM_1_HC_COUNT_VALUES = 0x10
	// Position of INTR_IO field.
	I2C_COMP_PARAM_1_INTR_IO_Pos = 0x5
	// Bit mask of INTR_IO field.
	I2C_COMP_PARAM_1_INTR_IO_Msk = 0x20
	// Bit INTR_IO.
	I2C_COMP_PARAM_1_INTR_IO = 0x20
	// Position of HAS_DMA field.
	I2C_COMP_PARAM_1_HAS_DMA_Pos = 0x6
	// Bit mask of HAS_DMA field.
	I2C_COMP_PARAM_1_HAS_DMA_Msk = 0x40
	// Bit HAS_DMA.
	I2C_COMP_PARAM_1_HAS_DMA = 0x40
	// Position of ENCODED_PARAMS field.
	I2C_COMP_PARAM_1_ENCODED_PARAMS_Pos = 0x7
	// Bit mask of ENCODED_PARAMS field.
	I2C_COMP_PARAM_1_ENCODED_PARAMS_Msk = 0x80
	// Bit ENCODED_PARAMS.
	I2C_COMP_PARAM_1_ENCODED_PARAMS = 0x80
	// Position of RX_BUFFER_DEPTH field.
	I2C_COMP_PARAM_1_RX_BUFFER_DEPTH_Pos = 0x8
	// Bit mask of RX_BUFFER_DEPTH field.
	I2C_COMP_PARAM_1_RX_BUFFER_DEPTH_Msk = 0xff00
	// Position of TX_BUFFER_DEPTH field.
	I2C_COMP_PARAM_1_TX_BUFFER_DEPTH_Pos = 0x10
	// Bit mask of TX_BUFFER_DEPTH field.
	I2C_COMP_PARAM_1_TX_BUFFER_DEPTH_Msk = 0xff0000

	// COMP_VERSION: Component Version Register
	// Position of VALUE field.
	I2C_COMP_VERSION_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_COMP_VERSION_VALUE_Msk = 0xffffffff

	// COMP_TYPE: Component Type Register
	// Position of VALUE field.
	I2C_COMP_TYPE_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_COMP_TYPE_VALUE_Msk = 0xffffffff
)

// Constants for FPIOA: Field Programmable IO Array
const (
	// IO: FPIOA GPIO multiplexer io array
	// Position of CH_SEL field.
	FPIOA_IO_CH_SEL_Pos = 0x0
	// Bit mask of CH_SEL field.
	FPIOA_IO_CH_SEL_Msk = 0xff
	// Position of DS field.
	FPIOA_IO_DS_Pos = 0x8
	// Bit mask of DS field.
	FPIOA_IO_DS_Msk = 0xf00
	// Position of OE_EN field.
	FPIOA_IO_OE_EN_Pos = 0xc
	// Bit mask of OE_EN field.
	FPIOA_IO_OE_EN_Msk = 0x1000
	// Bit OE_EN.
	FPIOA_IO_OE_EN = 0x1000
	// Position of OE_INV field.
	FPIOA_IO_OE_INV_Pos = 0xd
	// Bit mask of OE_INV field.
	FPIOA_IO_OE_INV_Msk = 0x2000
	// Bit OE_INV.
	FPIOA_IO_OE_INV = 0x2000
	// Position of DO_SEL field.
	FPIOA_IO_DO_SEL_Pos = 0xe
	// Bit mask of DO_SEL field.
	FPIOA_IO_DO_SEL_Msk = 0x4000
	// Bit DO_SEL.
	FPIOA_IO_DO_SEL = 0x4000
	// Position of DO_INV field.
	FPIOA_IO_DO_INV_Pos = 0xf
	// Bit mask of DO_INV field.
	FPIOA_IO_DO_INV_Msk = 0x8000
	// Bit DO_INV.
	FPIOA_IO_DO_INV = 0x8000
	// Position of PU field.
	FPIOA_IO_PU_Pos = 0x10
	// Bit mask of PU field.
	FPIOA_IO_PU_Msk = 0x10000
	// Bit PU.
	FPIOA_IO_PU = 0x10000
	// Position of PD field.
	FPIOA_IO_PD_Pos = 0x11
	// Bit mask of PD field.
	FPIOA_IO_PD_Msk = 0x20000
	// Bit PD.
	FPIOA_IO_PD = 0x20000
	// Position of SL field.
	FPIOA_IO_SL_Pos = 0x13
	// Bit mask of SL field.
	FPIOA_IO_SL_Msk = 0x80000
	// Bit SL.
	FPIOA_IO_SL = 0x80000
	// Position of IE_EN field.
	FPIOA_IO_IE_EN_Pos = 0x14
	// Bit mask of IE_EN field.
	FPIOA_IO_IE_EN_Msk = 0x100000
	// Bit IE_EN.
	FPIOA_IO_IE_EN = 0x100000
	// Position of IE_INV field.
	FPIOA_IO_IE_INV_Pos = 0x15
	// Bit mask of IE_INV field.
	FPIOA_IO_IE_INV_Msk = 0x200000
	// Bit IE_INV.
	FPIOA_IO_IE_INV = 0x200000
	// Position of DI_INV field.
	FPIOA_IO_DI_INV_Pos = 0x16
	// Bit mask of DI_INV field.
	FPIOA_IO_DI_INV_Msk = 0x400000
	// Bit DI_INV.
	FPIOA_IO_DI_INV = 0x400000
	// Position of ST field.
	FPIOA_IO_ST_Pos = 0x17
	// Bit mask of ST field.
	FPIOA_IO_ST_Msk = 0x800000
	// Bit ST.
	FPIOA_IO_ST = 0x800000
	// Position of PAD_DI field.
	FPIOA_IO_PAD_DI_Pos = 0x1f
	// Bit mask of PAD_DI field.
	FPIOA_IO_PAD_DI_Msk = 0x80000000
	// Bit PAD_DI.
	FPIOA_IO_PAD_DI = 0x80000000
)

// Constants for SHA256: SHA256 Accelerator
const (
	// NUM_REG: Counters register
	// Position of DATA_CNT field.
	SHA256_NUM_REG_DATA_CNT_Pos = 0x0
	// Bit mask of DATA_CNT field.
	SHA256_NUM_REG_DATA_CNT_Msk = 0xffff
	// Position of DATA_NUM field.
	SHA256_NUM_REG_DATA_NUM_Pos = 0x10
	// Bit mask of DATA_NUM field.
	SHA256_NUM_REG_DATA_NUM_Msk = 0xffff0000

	// FUNCTION_REG_0: Function configuration register 0
	// Position of EN field.
	SHA256_FUNCTION_REG_0_EN_Pos = 0x0
	// Bit mask of EN field.
	SHA256_FUNCTION_REG_0_EN_Msk = 0x1
	// Bit EN.
	SHA256_FUNCTION_REG_0_EN = 0x1
	// Position of OVERFLOW field.
	SHA256_FUNCTION_REG_0_OVERFLOW_Pos = 0x8
	// Bit mask of OVERFLOW field.
	SHA256_FUNCTION_REG_0_OVERFLOW_Msk = 0x100
	// Bit OVERFLOW.
	SHA256_FUNCTION_REG_0_OVERFLOW = 0x100
	// Position of ENDIAN field.
	SHA256_FUNCTION_REG_0_ENDIAN_Pos = 0x10
	// Bit mask of ENDIAN field.
	SHA256_FUNCTION_REG_0_ENDIAN_Msk = 0x10000
	// Bit ENDIAN.
	SHA256_FUNCTION_REG_0_ENDIAN = 0x10000
	// Little endian
	SHA256_FUNCTION_REG_0_ENDIAN_LE = 0x0
	// Big endian
	SHA256_FUNCTION_REG_0_ENDIAN_BE = 0x1

	// FUNCTION_REG_1: Function configuration register 1
	// Position of DMA_EN field.
	SHA256_FUNCTION_REG_1_DMA_EN_Pos = 0x0
	// Bit mask of DMA_EN field.
	SHA256_FUNCTION_REG_1_DMA_EN_Msk = 0x1
	// Bit DMA_EN.
	SHA256_FUNCTION_REG_1_DMA_EN = 0x1
	// Position of FIFO_IN_FULL field.
	SHA256_FUNCTION_REG_1_FIFO_IN_FULL_Pos = 0x8
	// Bit mask of FIFO_IN_FULL field.
	SHA256_FUNCTION_REG_1_FIFO_IN_FULL_Msk = 0x100
	// Bit FIFO_IN_FULL.
	SHA256_FUNCTION_REG_1_FIFO_IN_FULL = 0x100
)

// Constants for TIMER0: Timer 0
const (
	// CHANNEL.LOAD_COUNT: Load Count Register

	// CHANNEL.CURRENT_VALUE: Current Value Register

	// CHANNEL.CONTROL: Control Register
	// Position of ENABLE field.
	TIMER_channel_CONTROL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TIMER_channel_CONTROL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	TIMER_channel_CONTROL_ENABLE = 0x1
	// Position of MODE field.
	TIMER_channel_CONTROL_MODE_Pos = 0x1
	// Bit mask of MODE field.
	TIMER_channel_CONTROL_MODE_Msk = 0x2
	// Bit MODE.
	TIMER_channel_CONTROL_MODE = 0x2
	// FREE_MODE
	TIMER_channel_CONTROL_MODE_FREE = 0x0
	// USER_MODE
	TIMER_channel_CONTROL_MODE_USER = 0x1
	// Position of INTERRUPT field.
	TIMER_channel_CONTROL_INTERRUPT_Pos = 0x2
	// Bit mask of INTERRUPT field.
	TIMER_channel_CONTROL_INTERRUPT_Msk = 0x4
	// Bit INTERRUPT.
	TIMER_channel_CONTROL_INTERRUPT = 0x4
	// Position of PWM_ENABLE field.
	TIMER_channel_CONTROL_PWM_ENABLE_Pos = 0x3
	// Bit mask of PWM_ENABLE field.
	TIMER_channel_CONTROL_PWM_ENABLE_Msk = 0x8
	// Bit PWM_ENABLE.
	TIMER_channel_CONTROL_PWM_ENABLE = 0x8

	// CHANNEL.EOI: Interrupt Clear Register

	// CHANNEL.INTR_STAT: Interrupt Status Register
)

// Constants for WDT0: Watchdog Timer 0
const (
	// CR: Control Register
	// Position of ENABLE field.
	WDT_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	WDT_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	WDT_CR_ENABLE = 0x1
	// Position of RMOD field.
	WDT_CR_RMOD_Pos = 0x1
	// Bit mask of RMOD field.
	WDT_CR_RMOD_Msk = 0x2
	// Bit RMOD.
	WDT_CR_RMOD = 0x2
	// RESET
	WDT_CR_RMOD_RESET = 0x0
	// INTERRUPT
	WDT_CR_RMOD_INTERRUPT = 0x1
	// Position of RPL field.
	WDT_CR_RPL_Pos = 0x2
	// Bit mask of RPL field.
	WDT_CR_RPL_Msk = 0x1c

	// TORR: Timeout Range Register
	// Position of TOP0 field.
	WDT_TORR_TOP0_Pos = 0x0
	// Bit mask of TOP0 field.
	WDT_TORR_TOP0_Msk = 0xf
	// Position of TOP1 field.
	WDT_TORR_TOP1_Pos = 0x4
	// Bit mask of TOP1 field.
	WDT_TORR_TOP1_Msk = 0xf0

	// STAT: Interrupt Status Register
	// Position of STAT field.
	WDT_STAT_STAT_Pos = 0x0
	// Bit mask of STAT field.
	WDT_STAT_STAT_Msk = 0x1
	// Bit STAT.
	WDT_STAT_STAT = 0x1

	// EOI: Interrupt Clear Register
	// Position of EOI field.
	WDT_EOI_EOI_Pos = 0x0
	// Bit mask of EOI field.
	WDT_EOI_EOI_Msk = 0x1
	// Bit EOI.
	WDT_EOI_EOI = 0x1

	// PROT_LEVEL: Protection level Register
	// Position of PROT_LEVEL field.
	WDT_PROT_LEVEL_PROT_LEVEL_Pos = 0x0
	// Bit mask of PROT_LEVEL field.
	WDT_PROT_LEVEL_PROT_LEVEL_Msk = 0x7

	// COMP_PARAM_5: Component Parameters Register 5
	// Position of USER_TOP_MAX field.
	WDT_COMP_PARAM_5_USER_TOP_MAX_Pos = 0x0
	// Bit mask of USER_TOP_MAX field.
	WDT_COMP_PARAM_5_USER_TOP_MAX_Msk = 0xffffffff

	// COMP_PARAM_4: Component Parameters Register 4
	// Position of USER_TOP_INIT_MAX field.
	WDT_COMP_PARAM_4_USER_TOP_INIT_MAX_Pos = 0x0
	// Bit mask of USER_TOP_INIT_MAX field.
	WDT_COMP_PARAM_4_USER_TOP_INIT_MAX_Msk = 0xffffffff

	// COMP_PARAM_3: Component Parameters Register 3
	// Position of TOP_RST field.
	WDT_COMP_PARAM_3_TOP_RST_Pos = 0x0
	// Bit mask of TOP_RST field.
	WDT_COMP_PARAM_3_TOP_RST_Msk = 0xffffffff

	// COMP_PARAM_2: Component Parameters Register 2
	// Position of CNT_RST field.
	WDT_COMP_PARAM_2_CNT_RST_Pos = 0x0
	// Bit mask of CNT_RST field.
	WDT_COMP_PARAM_2_CNT_RST_Msk = 0xffffffff

	// COMP_PARAM_1: Component Parameters Register 1
	// Position of ALWAYS_EN field.
	WDT_COMP_PARAM_1_ALWAYS_EN_Pos = 0x0
	// Bit mask of ALWAYS_EN field.
	WDT_COMP_PARAM_1_ALWAYS_EN_Msk = 0x1
	// Bit ALWAYS_EN.
	WDT_COMP_PARAM_1_ALWAYS_EN = 0x1
	// Position of DFLT_RMOD field.
	WDT_COMP_PARAM_1_DFLT_RMOD_Pos = 0x1
	// Bit mask of DFLT_RMOD field.
	WDT_COMP_PARAM_1_DFLT_RMOD_Msk = 0x2
	// Bit DFLT_RMOD.
	WDT_COMP_PARAM_1_DFLT_RMOD = 0x2
	// Position of DUAL_TOP field.
	WDT_COMP_PARAM_1_DUAL_TOP_Pos = 0x2
	// Bit mask of DUAL_TOP field.
	WDT_COMP_PARAM_1_DUAL_TOP_Msk = 0x4
	// Bit DUAL_TOP.
	WDT_COMP_PARAM_1_DUAL_TOP = 0x4
	// Position of HC_RMOD field.
	WDT_COMP_PARAM_1_HC_RMOD_Pos = 0x3
	// Bit mask of HC_RMOD field.
	WDT_COMP_PARAM_1_HC_RMOD_Msk = 0x8
	// Bit HC_RMOD.
	WDT_COMP_PARAM_1_HC_RMOD = 0x8
	// Position of HC_RPL field.
	WDT_COMP_PARAM_1_HC_RPL_Pos = 0x4
	// Bit mask of HC_RPL field.
	WDT_COMP_PARAM_1_HC_RPL_Msk = 0x10
	// Bit HC_RPL.
	WDT_COMP_PARAM_1_HC_RPL = 0x10
	// Position of HC_TOP field.
	WDT_COMP_PARAM_1_HC_TOP_Pos = 0x5
	// Bit mask of HC_TOP field.
	WDT_COMP_PARAM_1_HC_TOP_Msk = 0x20
	// Bit HC_TOP.
	WDT_COMP_PARAM_1_HC_TOP = 0x20
	// Position of USE_FIX_TOP field.
	WDT_COMP_PARAM_1_USE_FIX_TOP_Pos = 0x6
	// Bit mask of USE_FIX_TOP field.
	WDT_COMP_PARAM_1_USE_FIX_TOP_Msk = 0x40
	// Bit USE_FIX_TOP.
	WDT_COMP_PARAM_1_USE_FIX_TOP = 0x40
	// Position of PAUSE field.
	WDT_COMP_PARAM_1_PAUSE_Pos = 0x7
	// Bit mask of PAUSE field.
	WDT_COMP_PARAM_1_PAUSE_Msk = 0x80
	// Bit PAUSE.
	WDT_COMP_PARAM_1_PAUSE = 0x80
	// Position of APB_DATA_WIDTH field.
	WDT_COMP_PARAM_1_APB_DATA_WIDTH_Pos = 0x8
	// Bit mask of APB_DATA_WIDTH field.
	WDT_COMP_PARAM_1_APB_DATA_WIDTH_Msk = 0x300
	// Position of DFLT_RPL field.
	WDT_COMP_PARAM_1_DFLT_RPL_Pos = 0xa
	// Bit mask of DFLT_RPL field.
	WDT_COMP_PARAM_1_DFLT_RPL_Msk = 0x1c00
	// Position of DFLT_TOP field.
	WDT_COMP_PARAM_1_DFLT_TOP_Pos = 0x10
	// Bit mask of DFLT_TOP field.
	WDT_COMP_PARAM_1_DFLT_TOP_Msk = 0xf0000
	// Position of DFLT_TOP_INIT field.
	WDT_COMP_PARAM_1_DFLT_TOP_INIT_Pos = 0x14
	// Bit mask of DFLT_TOP_INIT field.
	WDT_COMP_PARAM_1_DFLT_TOP_INIT_Msk = 0xf00000
	// Position of CNT_WIDTH field.
	WDT_COMP_PARAM_1_CNT_WIDTH_Pos = 0x18
	// Bit mask of CNT_WIDTH field.
	WDT_COMP_PARAM_1_CNT_WIDTH_Msk = 0x1f000000
)

// Constants for OTP: One-Time Programmable Memory Controller
const ()

// Constants for DVP: Digital Video Port
const (
	// DVP_CFG: Config Register
	// Position of START_INT_ENABLE field.
	DVP_DVP_CFG_START_INT_ENABLE_Pos = 0x0
	// Bit mask of START_INT_ENABLE field.
	DVP_DVP_CFG_START_INT_ENABLE_Msk = 0x1
	// Bit START_INT_ENABLE.
	DVP_DVP_CFG_START_INT_ENABLE = 0x1
	// Position of FINISH_INT_ENABLE field.
	DVP_DVP_CFG_FINISH_INT_ENABLE_Pos = 0x1
	// Bit mask of FINISH_INT_ENABLE field.
	DVP_DVP_CFG_FINISH_INT_ENABLE_Msk = 0x2
	// Bit FINISH_INT_ENABLE.
	DVP_DVP_CFG_FINISH_INT_ENABLE = 0x2
	// Position of AI_OUTPUT_ENABLE field.
	DVP_DVP_CFG_AI_OUTPUT_ENABLE_Pos = 0x2
	// Bit mask of AI_OUTPUT_ENABLE field.
	DVP_DVP_CFG_AI_OUTPUT_ENABLE_Msk = 0x4
	// Bit AI_OUTPUT_ENABLE.
	DVP_DVP_CFG_AI_OUTPUT_ENABLE = 0x4
	// Position of DISPLAY_OUTPUT_ENABLE field.
	DVP_DVP_CFG_DISPLAY_OUTPUT_ENABLE_Pos = 0x3
	// Bit mask of DISPLAY_OUTPUT_ENABLE field.
	DVP_DVP_CFG_DISPLAY_OUTPUT_ENABLE_Msk = 0x8
	// Bit DISPLAY_OUTPUT_ENABLE.
	DVP_DVP_CFG_DISPLAY_OUTPUT_ENABLE = 0x8
	// Position of AUTO_ENABLE field.
	DVP_DVP_CFG_AUTO_ENABLE_Pos = 0x4
	// Bit mask of AUTO_ENABLE field.
	DVP_DVP_CFG_AUTO_ENABLE_Msk = 0x10
	// Bit AUTO_ENABLE.
	DVP_DVP_CFG_AUTO_ENABLE = 0x10
	// Position of BURST_SIZE_4BEATS field.
	DVP_DVP_CFG_BURST_SIZE_4BEATS_Pos = 0x8
	// Bit mask of BURST_SIZE_4BEATS field.
	DVP_DVP_CFG_BURST_SIZE_4BEATS_Msk = 0x100
	// Bit BURST_SIZE_4BEATS.
	DVP_DVP_CFG_BURST_SIZE_4BEATS = 0x100
	// Position of FORMAT field.
	DVP_DVP_CFG_FORMAT_Pos = 0x9
	// Bit mask of FORMAT field.
	DVP_DVP_CFG_FORMAT_Msk = 0x600
	// RGB_FORMAT
	DVP_DVP_CFG_FORMAT_RGB = 0x0
	// YUV_FORMAT
	DVP_DVP_CFG_FORMAT_YUV = 0x1
	// Y_FORMAT
	DVP_DVP_CFG_FORMAT_Y = 0x3
	// Position of HREF_BURST_NUM field.
	DVP_DVP_CFG_HREF_BURST_NUM_Pos = 0xc
	// Bit mask of HREF_BURST_NUM field.
	DVP_DVP_CFG_HREF_BURST_NUM_Msk = 0xff000
	// Position of LINE_NUM field.
	DVP_DVP_CFG_LINE_NUM_Pos = 0x14
	// Bit mask of LINE_NUM field.
	DVP_DVP_CFG_LINE_NUM_Msk = 0x3ff00000

	// CMOS_CFG: CMOS Config Register
	// Position of CLK_DIV field.
	DVP_CMOS_CFG_CLK_DIV_Pos = 0x0
	// Bit mask of CLK_DIV field.
	DVP_CMOS_CFG_CLK_DIV_Msk = 0xff
	// Position of CLK_ENABLE field.
	DVP_CMOS_CFG_CLK_ENABLE_Pos = 0x8
	// Bit mask of CLK_ENABLE field.
	DVP_CMOS_CFG_CLK_ENABLE_Msk = 0x100
	// Bit CLK_ENABLE.
	DVP_CMOS_CFG_CLK_ENABLE = 0x100
	// Position of RESET field.
	DVP_CMOS_CFG_RESET_Pos = 0x10
	// Bit mask of RESET field.
	DVP_CMOS_CFG_RESET_Msk = 0x10000
	// Bit RESET.
	DVP_CMOS_CFG_RESET = 0x10000
	// Position of POWER_DOWN field.
	DVP_CMOS_CFG_POWER_DOWN_Pos = 0x18
	// Bit mask of POWER_DOWN field.
	DVP_CMOS_CFG_POWER_DOWN_Msk = 0x1000000
	// Bit POWER_DOWN.
	DVP_CMOS_CFG_POWER_DOWN = 0x1000000

	// SCCB_CFG: SCCB Config Register
	// Position of BYTE_NUM field.
	DVP_SCCB_CFG_BYTE_NUM_Pos = 0x0
	// Bit mask of BYTE_NUM field.
	DVP_SCCB_CFG_BYTE_NUM_Msk = 0x3
	// BYTE_NUM_2
	DVP_SCCB_CFG_BYTE_NUM_NUM2 = 0x1
	// BYTE_NUM_3
	DVP_SCCB_CFG_BYTE_NUM_NUM3 = 0x2
	// BYTE_NUM_4
	DVP_SCCB_CFG_BYTE_NUM_NUM4 = 0x3
	// Position of SCL_LCNT field.
	DVP_SCCB_CFG_SCL_LCNT_Pos = 0x8
	// Bit mask of SCL_LCNT field.
	DVP_SCCB_CFG_SCL_LCNT_Msk = 0xff00
	// Position of SCL_HCNT field.
	DVP_SCCB_CFG_SCL_HCNT_Pos = 0x10
	// Bit mask of SCL_HCNT field.
	DVP_SCCB_CFG_SCL_HCNT_Msk = 0xff0000
	// Position of RDATA field.
	DVP_SCCB_CFG_RDATA_Pos = 0x18
	// Bit mask of RDATA field.
	DVP_SCCB_CFG_RDATA_Msk = 0xff000000

	// SCCB_CTL: SCCB Control Register
	// Position of DEVICE_ADDRESS field.
	DVP_SCCB_CTL_DEVICE_ADDRESS_Pos = 0x0
	// Bit mask of DEVICE_ADDRESS field.
	DVP_SCCB_CTL_DEVICE_ADDRESS_Msk = 0xff
	// Position of REG_ADDRESS field.
	DVP_SCCB_CTL_REG_ADDRESS_Pos = 0x8
	// Bit mask of REG_ADDRESS field.
	DVP_SCCB_CTL_REG_ADDRESS_Msk = 0xff00
	// Position of WDATA_BYTE0 field.
	DVP_SCCB_CTL_WDATA_BYTE0_Pos = 0x10
	// Bit mask of WDATA_BYTE0 field.
	DVP_SCCB_CTL_WDATA_BYTE0_Msk = 0xff0000
	// Position of WDATA_BYTE1 field.
	DVP_SCCB_CTL_WDATA_BYTE1_Pos = 0x18
	// Bit mask of WDATA_BYTE1 field.
	DVP_SCCB_CTL_WDATA_BYTE1_Msk = 0xff000000

	// AXI: AXI Register
	// Position of GM_MLEN field.
	DVP_AXI_GM_MLEN_Pos = 0x0
	// Bit mask of GM_MLEN field.
	DVP_AXI_GM_MLEN_Msk = 0xff
	// GM_MLEN_1BYTE
	DVP_AXI_GM_MLEN_BYTE1 = 0x0
	// GM_MLEN_4BYTE
	DVP_AXI_GM_MLEN_BYTE4 = 0x3

	// STS: STS Register
	// Position of FRAME_START field.
	DVP_STS_FRAME_START_Pos = 0x0
	// Bit mask of FRAME_START field.
	DVP_STS_FRAME_START_Msk = 0x1
	// Bit FRAME_START.
	DVP_STS_FRAME_START = 0x1
	// Position of FRAME_START_WE field.
	DVP_STS_FRAME_START_WE_Pos = 0x1
	// Bit mask of FRAME_START_WE field.
	DVP_STS_FRAME_START_WE_Msk = 0x2
	// Bit FRAME_START_WE.
	DVP_STS_FRAME_START_WE = 0x2
	// Position of FRAME_FINISH field.
	DVP_STS_FRAME_FINISH_Pos = 0x8
	// Bit mask of FRAME_FINISH field.
	DVP_STS_FRAME_FINISH_Msk = 0x100
	// Bit FRAME_FINISH.
	DVP_STS_FRAME_FINISH = 0x100
	// Position of FRAME_FINISH_WE field.
	DVP_STS_FRAME_FINISH_WE_Pos = 0x9
	// Bit mask of FRAME_FINISH_WE field.
	DVP_STS_FRAME_FINISH_WE_Msk = 0x200
	// Bit FRAME_FINISH_WE.
	DVP_STS_FRAME_FINISH_WE = 0x200
	// Position of DVP_EN field.
	DVP_STS_DVP_EN_Pos = 0x10
	// Bit mask of DVP_EN field.
	DVP_STS_DVP_EN_Msk = 0x10000
	// Bit DVP_EN.
	DVP_STS_DVP_EN = 0x10000
	// Position of DVP_EN_WE field.
	DVP_STS_DVP_EN_WE_Pos = 0x11
	// Bit mask of DVP_EN_WE field.
	DVP_STS_DVP_EN_WE_Msk = 0x20000
	// Bit DVP_EN_WE.
	DVP_STS_DVP_EN_WE = 0x20000
	// Position of SCCB_EN field.
	DVP_STS_SCCB_EN_Pos = 0x18
	// Bit mask of SCCB_EN field.
	DVP_STS_SCCB_EN_Msk = 0x1000000
	// Bit SCCB_EN.
	DVP_STS_SCCB_EN = 0x1000000
	// Position of SCCB_EN_WE field.
	DVP_STS_SCCB_EN_WE_Pos = 0x19
	// Bit mask of SCCB_EN_WE field.
	DVP_STS_SCCB_EN_WE_Msk = 0x2000000
	// Bit SCCB_EN_WE.
	DVP_STS_SCCB_EN_WE = 0x2000000
)

// Constants for SYSCTL: System Controller
const (
	// PLL0: PLL0 controller
	// Position of CLKR field.
	SYSCTL_PLL0_CLKR_Pos = 0x0
	// Bit mask of CLKR field.
	SYSCTL_PLL0_CLKR_Msk = 0xf
	// Position of CLKF field.
	SYSCTL_PLL0_CLKF_Pos = 0x4
	// Bit mask of CLKF field.
	SYSCTL_PLL0_CLKF_Msk = 0x3f0
	// Position of CLKOD field.
	SYSCTL_PLL0_CLKOD_Pos = 0xa
	// Bit mask of CLKOD field.
	SYSCTL_PLL0_CLKOD_Msk = 0x3c00
	// Position of BWADJ field.
	SYSCTL_PLL0_BWADJ_Pos = 0xe
	// Bit mask of BWADJ field.
	SYSCTL_PLL0_BWADJ_Msk = 0xfc000
	// Position of RESET field.
	SYSCTL_PLL0_RESET_Pos = 0x14
	// Bit mask of RESET field.
	SYSCTL_PLL0_RESET_Msk = 0x100000
	// Bit RESET.
	SYSCTL_PLL0_RESET = 0x100000
	// Position of PWRD field.
	SYSCTL_PLL0_PWRD_Pos = 0x15
	// Bit mask of PWRD field.
	SYSCTL_PLL0_PWRD_Msk = 0x200000
	// Bit PWRD.
	SYSCTL_PLL0_PWRD = 0x200000
	// Position of INTFB field.
	SYSCTL_PLL0_INTFB_Pos = 0x16
	// Bit mask of INTFB field.
	SYSCTL_PLL0_INTFB_Msk = 0x400000
	// Bit INTFB.
	SYSCTL_PLL0_INTFB = 0x400000
	// Position of BYPASS field.
	SYSCTL_PLL0_BYPASS_Pos = 0x17
	// Bit mask of BYPASS field.
	SYSCTL_PLL0_BYPASS_Msk = 0x800000
	// Bit BYPASS.
	SYSCTL_PLL0_BYPASS = 0x800000
	// Position of TEST field.
	SYSCTL_PLL0_TEST_Pos = 0x18
	// Bit mask of TEST field.
	SYSCTL_PLL0_TEST_Msk = 0x1000000
	// Bit TEST.
	SYSCTL_PLL0_TEST = 0x1000000
	// Position of OUT_EN field.
	SYSCTL_PLL0_OUT_EN_Pos = 0x19
	// Bit mask of OUT_EN field.
	SYSCTL_PLL0_OUT_EN_Msk = 0x2000000
	// Bit OUT_EN.
	SYSCTL_PLL0_OUT_EN = 0x2000000
	// Position of TEST_EN field.
	SYSCTL_PLL0_TEST_EN_Pos = 0x1a
	// Bit mask of TEST_EN field.
	SYSCTL_PLL0_TEST_EN_Msk = 0x4000000
	// Bit TEST_EN.
	SYSCTL_PLL0_TEST_EN = 0x4000000

	// PLL1: PLL1 controller
	// Position of CLKR field.
	SYSCTL_PLL1_CLKR_Pos = 0x0
	// Bit mask of CLKR field.
	SYSCTL_PLL1_CLKR_Msk = 0xf
	// Position of CLKF field.
	SYSCTL_PLL1_CLKF_Pos = 0x4
	// Bit mask of CLKF field.
	SYSCTL_PLL1_CLKF_Msk = 0x3f0
	// Position of CLKOD field.
	SYSCTL_PLL1_CLKOD_Pos = 0xa
	// Bit mask of CLKOD field.
	SYSCTL_PLL1_CLKOD_Msk = 0x3c00
	// Position of BWADJ field.
	SYSCTL_PLL1_BWADJ_Pos = 0xe
	// Bit mask of BWADJ field.
	SYSCTL_PLL1_BWADJ_Msk = 0xfc000
	// Position of RESET field.
	SYSCTL_PLL1_RESET_Pos = 0x14
	// Bit mask of RESET field.
	SYSCTL_PLL1_RESET_Msk = 0x100000
	// Bit RESET.
	SYSCTL_PLL1_RESET = 0x100000
	// Position of PWRD field.
	SYSCTL_PLL1_PWRD_Pos = 0x15
	// Bit mask of PWRD field.
	SYSCTL_PLL1_PWRD_Msk = 0x200000
	// Bit PWRD.
	SYSCTL_PLL1_PWRD = 0x200000
	// Position of INTFB field.
	SYSCTL_PLL1_INTFB_Pos = 0x16
	// Bit mask of INTFB field.
	SYSCTL_PLL1_INTFB_Msk = 0x400000
	// Bit INTFB.
	SYSCTL_PLL1_INTFB = 0x400000
	// Position of BYPASS field.
	SYSCTL_PLL1_BYPASS_Pos = 0x17
	// Bit mask of BYPASS field.
	SYSCTL_PLL1_BYPASS_Msk = 0x800000
	// Bit BYPASS.
	SYSCTL_PLL1_BYPASS = 0x800000
	// Position of TEST field.
	SYSCTL_PLL1_TEST_Pos = 0x18
	// Bit mask of TEST field.
	SYSCTL_PLL1_TEST_Msk = 0x1000000
	// Bit TEST.
	SYSCTL_PLL1_TEST = 0x1000000
	// Position of OUT_EN field.
	SYSCTL_PLL1_OUT_EN_Pos = 0x19
	// Bit mask of OUT_EN field.
	SYSCTL_PLL1_OUT_EN_Msk = 0x2000000
	// Bit OUT_EN.
	SYSCTL_PLL1_OUT_EN = 0x2000000

	// PLL2: PLL2 controller
	// Position of CLKR field.
	SYSCTL_PLL2_CLKR_Pos = 0x0
	// Bit mask of CLKR field.
	SYSCTL_PLL2_CLKR_Msk = 0xf
	// Position of CLKF field.
	SYSCTL_PLL2_CLKF_Pos = 0x4
	// Bit mask of CLKF field.
	SYSCTL_PLL2_CLKF_Msk = 0x3f0
	// Position of CLKOD field.
	SYSCTL_PLL2_CLKOD_Pos = 0xa
	// Bit mask of CLKOD field.
	SYSCTL_PLL2_CLKOD_Msk = 0x3c00
	// Position of BWADJ field.
	SYSCTL_PLL2_BWADJ_Pos = 0xe
	// Bit mask of BWADJ field.
	SYSCTL_PLL2_BWADJ_Msk = 0xfc000
	// Position of RESET field.
	SYSCTL_PLL2_RESET_Pos = 0x14
	// Bit mask of RESET field.
	SYSCTL_PLL2_RESET_Msk = 0x100000
	// Bit RESET.
	SYSCTL_PLL2_RESET = 0x100000
	// Position of PWRD field.
	SYSCTL_PLL2_PWRD_Pos = 0x15
	// Bit mask of PWRD field.
	SYSCTL_PLL2_PWRD_Msk = 0x200000
	// Bit PWRD.
	SYSCTL_PLL2_PWRD = 0x200000
	// Position of INTFB field.
	SYSCTL_PLL2_INTFB_Pos = 0x16
	// Bit mask of INTFB field.
	SYSCTL_PLL2_INTFB_Msk = 0x400000
	// Bit INTFB.
	SYSCTL_PLL2_INTFB = 0x400000
	// Position of BYPASS field.
	SYSCTL_PLL2_BYPASS_Pos = 0x17
	// Bit mask of BYPASS field.
	SYSCTL_PLL2_BYPASS_Msk = 0x800000
	// Bit BYPASS.
	SYSCTL_PLL2_BYPASS = 0x800000
	// Position of TEST field.
	SYSCTL_PLL2_TEST_Pos = 0x18
	// Bit mask of TEST field.
	SYSCTL_PLL2_TEST_Msk = 0x1000000
	// Bit TEST.
	SYSCTL_PLL2_TEST = 0x1000000
	// Position of OUT_EN field.
	SYSCTL_PLL2_OUT_EN_Pos = 0x19
	// Bit mask of OUT_EN field.
	SYSCTL_PLL2_OUT_EN_Msk = 0x2000000
	// Bit OUT_EN.
	SYSCTL_PLL2_OUT_EN = 0x2000000
	// Position of CKIN_SEL field.
	SYSCTL_PLL2_CKIN_SEL_Pos = 0x1a
	// Bit mask of CKIN_SEL field.
	SYSCTL_PLL2_CKIN_SEL_Msk = 0xc000000

	// PLL_LOCK: PLL lock tester
	// Position of PLL_LOCK0 field.
	SYSCTL_PLL_LOCK_PLL_LOCK0_Pos = 0x0
	// Bit mask of PLL_LOCK0 field.
	SYSCTL_PLL_LOCK_PLL_LOCK0_Msk = 0x3
	// Position of PLL_SLIP_CLEAR0 field.
	SYSCTL_PLL_LOCK_PLL_SLIP_CLEAR0_Pos = 0x2
	// Bit mask of PLL_SLIP_CLEAR0 field.
	SYSCTL_PLL_LOCK_PLL_SLIP_CLEAR0_Msk = 0x4
	// Bit PLL_SLIP_CLEAR0.
	SYSCTL_PLL_LOCK_PLL_SLIP_CLEAR0 = 0x4
	// Position of TEST_CLK_OUT0 field.
	SYSCTL_PLL_LOCK_TEST_CLK_OUT0_Pos = 0x3
	// Bit mask of TEST_CLK_OUT0 field.
	SYSCTL_PLL_LOCK_TEST_CLK_OUT0_Msk = 0x8
	// Bit TEST_CLK_OUT0.
	SYSCTL_PLL_LOCK_TEST_CLK_OUT0 = 0x8
	// Position of PLL_LOCK1 field.
	SYSCTL_PLL_LOCK_PLL_LOCK1_Pos = 0x8
	// Bit mask of PLL_LOCK1 field.
	SYSCTL_PLL_LOCK_PLL_LOCK1_Msk = 0x300
	// Position of PLL_SLIP_CLEAR1 field.
	SYSCTL_PLL_LOCK_PLL_SLIP_CLEAR1_Pos = 0xa
	// Bit mask of PLL_SLIP_CLEAR1 field.
	SYSCTL_PLL_LOCK_PLL_SLIP_CLEAR1_Msk = 0x400
	// Bit PLL_SLIP_CLEAR1.
	SYSCTL_PLL_LOCK_PLL_SLIP_CLEAR1 = 0x400
	// Position of TEST_CLK_OUT1 field.
	SYSCTL_PLL_LOCK_TEST_CLK_OUT1_Pos = 0xb
	// Bit mask of TEST_CLK_OUT1 field.
	SYSCTL_PLL_LOCK_TEST_CLK_OUT1_Msk = 0x800
	// Bit TEST_CLK_OUT1.
	SYSCTL_PLL_LOCK_TEST_CLK_OUT1 = 0x800
	// Position of PLL_LOCK2 field.
	SYSCTL_PLL_LOCK_PLL_LOCK2_Pos = 0x10
	// Bit mask of PLL_LOCK2 field.
	SYSCTL_PLL_LOCK_PLL_LOCK2_Msk = 0x30000
	// Position of PLL_SLIP_CLEAR2 field.
	SYSCTL_PLL_LOCK_PLL_SLIP_CLEAR2_Pos = 0x12
	// Bit mask of PLL_SLIP_CLEAR2 field.
	SYSCTL_PLL_LOCK_PLL_SLIP_CLEAR2_Msk = 0x40000
	// Bit PLL_SLIP_CLEAR2.
	SYSCTL_PLL_LOCK_PLL_SLIP_CLEAR2 = 0x40000
	// Position of TEST_CLK_OUT2 field.
	SYSCTL_PLL_LOCK_TEST_CLK_OUT2_Pos = 0x13
	// Bit mask of TEST_CLK_OUT2 field.
	SYSCTL_PLL_LOCK_TEST_CLK_OUT2_Msk = 0x80000
	// Bit TEST_CLK_OUT2.
	SYSCTL_PLL_LOCK_TEST_CLK_OUT2 = 0x80000

	// ROM_ERROR: AXI ROM detector
	// Position of ROM_MUL_ERROR field.
	SYSCTL_ROM_ERROR_ROM_MUL_ERROR_Pos = 0x0
	// Bit mask of ROM_MUL_ERROR field.
	SYSCTL_ROM_ERROR_ROM_MUL_ERROR_Msk = 0x1
	// Bit ROM_MUL_ERROR.
	SYSCTL_ROM_ERROR_ROM_MUL_ERROR = 0x1
	// Position of ROM_ONE_ERROR field.
	SYSCTL_ROM_ERROR_ROM_ONE_ERROR_Pos = 0x1
	// Bit mask of ROM_ONE_ERROR field.
	SYSCTL_ROM_ERROR_ROM_ONE_ERROR_Msk = 0x2
	// Bit ROM_ONE_ERROR.
	SYSCTL_ROM_ERROR_ROM_ONE_ERROR = 0x2

	// CLK_SEL0: Clock select controller 0
	// Position of ACLK_SEL field.
	SYSCTL_CLK_SEL0_ACLK_SEL_Pos = 0x0
	// Bit mask of ACLK_SEL field.
	SYSCTL_CLK_SEL0_ACLK_SEL_Msk = 0x1
	// Bit ACLK_SEL.
	SYSCTL_CLK_SEL0_ACLK_SEL = 0x1
	// Position of ACLK_DIVIDER_SEL field.
	SYSCTL_CLK_SEL0_ACLK_DIVIDER_SEL_Pos = 0x1
	// Bit mask of ACLK_DIVIDER_SEL field.
	SYSCTL_CLK_SEL0_ACLK_DIVIDER_SEL_Msk = 0x6
	// Position of APB0_CLK_SEL field.
	SYSCTL_CLK_SEL0_APB0_CLK_SEL_Pos = 0x3
	// Bit mask of APB0_CLK_SEL field.
	SYSCTL_CLK_SEL0_APB0_CLK_SEL_Msk = 0x38
	// Position of APB1_CLK_SEL field.
	SYSCTL_CLK_SEL0_APB1_CLK_SEL_Pos = 0x6
	// Bit mask of APB1_CLK_SEL field.
	SYSCTL_CLK_SEL0_APB1_CLK_SEL_Msk = 0x1c0
	// Position of APB2_CLK_SEL field.
	SYSCTL_CLK_SEL0_APB2_CLK_SEL_Pos = 0x9
	// Bit mask of APB2_CLK_SEL field.
	SYSCTL_CLK_SEL0_APB2_CLK_SEL_Msk = 0xe00
	// Position of SPI3_CLK_SEL field.
	SYSCTL_CLK_SEL0_SPI3_CLK_SEL_Pos = 0xc
	// Bit mask of SPI3_CLK_SEL field.
	SYSCTL_CLK_SEL0_SPI3_CLK_SEL_Msk = 0x1000
	// Bit SPI3_CLK_SEL.
	SYSCTL_CLK_SEL0_SPI3_CLK_SEL = 0x1000
	// Position of TIMER0_CLK_SEL field.
	SYSCTL_CLK_SEL0_TIMER0_CLK_SEL_Pos = 0xd
	// Bit mask of TIMER0_CLK_SEL field.
	SYSCTL_CLK_SEL0_TIMER0_CLK_SEL_Msk = 0x2000
	// Bit TIMER0_CLK_SEL.
	SYSCTL_CLK_SEL0_TIMER0_CLK_SEL = 0x2000
	// Position of TIMER1_CLK_SEL field.
	SYSCTL_CLK_SEL0_TIMER1_CLK_SEL_Pos = 0xe
	// Bit mask of TIMER1_CLK_SEL field.
	SYSCTL_CLK_SEL0_TIMER1_CLK_SEL_Msk = 0x4000
	// Bit TIMER1_CLK_SEL.
	SYSCTL_CLK_SEL0_TIMER1_CLK_SEL = 0x4000
	// Position of TIMER2_CLK_SEL field.
	SYSCTL_CLK_SEL0_TIMER2_CLK_SEL_Pos = 0xf
	// Bit mask of TIMER2_CLK_SEL field.
	SYSCTL_CLK_SEL0_TIMER2_CLK_SEL_Msk = 0x8000
	// Bit TIMER2_CLK_SEL.
	SYSCTL_CLK_SEL0_TIMER2_CLK_SEL = 0x8000

	// CLK_SEL1: Clock select controller 1
	// Position of SPI3_SAMPLE_CLK_SEL field.
	SYSCTL_CLK_SEL1_SPI3_SAMPLE_CLK_SEL_Pos = 0x0
	// Bit mask of SPI3_SAMPLE_CLK_SEL field.
	SYSCTL_CLK_SEL1_SPI3_SAMPLE_CLK_SEL_Msk = 0x1
	// Bit SPI3_SAMPLE_CLK_SEL.
	SYSCTL_CLK_SEL1_SPI3_SAMPLE_CLK_SEL = 0x1

	// CLK_EN_CENT: Central clock enable
	// Position of CPU_CLK_EN field.
	SYSCTL_CLK_EN_CENT_CPU_CLK_EN_Pos = 0x0
	// Bit mask of CPU_CLK_EN field.
	SYSCTL_CLK_EN_CENT_CPU_CLK_EN_Msk = 0x1
	// Bit CPU_CLK_EN.
	SYSCTL_CLK_EN_CENT_CPU_CLK_EN = 0x1
	// Position of SRAM0_CLK_EN field.
	SYSCTL_CLK_EN_CENT_SRAM0_CLK_EN_Pos = 0x1
	// Bit mask of SRAM0_CLK_EN field.
	SYSCTL_CLK_EN_CENT_SRAM0_CLK_EN_Msk = 0x2
	// Bit SRAM0_CLK_EN.
	SYSCTL_CLK_EN_CENT_SRAM0_CLK_EN = 0x2
	// Position of SRAM1_CLK_EN field.
	SYSCTL_CLK_EN_CENT_SRAM1_CLK_EN_Pos = 0x2
	// Bit mask of SRAM1_CLK_EN field.
	SYSCTL_CLK_EN_CENT_SRAM1_CLK_EN_Msk = 0x4
	// Bit SRAM1_CLK_EN.
	SYSCTL_CLK_EN_CENT_SRAM1_CLK_EN = 0x4
	// Position of APB0_CLK_EN field.
	SYSCTL_CLK_EN_CENT_APB0_CLK_EN_Pos = 0x3
	// Bit mask of APB0_CLK_EN field.
	SYSCTL_CLK_EN_CENT_APB0_CLK_EN_Msk = 0x8
	// Bit APB0_CLK_EN.
	SYSCTL_CLK_EN_CENT_APB0_CLK_EN = 0x8
	// Position of APB1_CLK_EN field.
	SYSCTL_CLK_EN_CENT_APB1_CLK_EN_Pos = 0x4
	// Bit mask of APB1_CLK_EN field.
	SYSCTL_CLK_EN_CENT_APB1_CLK_EN_Msk = 0x10
	// Bit APB1_CLK_EN.
	SYSCTL_CLK_EN_CENT_APB1_CLK_EN = 0x10
	// Position of APB2_CLK_EN field.
	SYSCTL_CLK_EN_CENT_APB2_CLK_EN_Pos = 0x5
	// Bit mask of APB2_CLK_EN field.
	SYSCTL_CLK_EN_CENT_APB2_CLK_EN_Msk = 0x20
	// Bit APB2_CLK_EN.
	SYSCTL_CLK_EN_CENT_APB2_CLK_EN = 0x20

	// CLK_EN_PERI: Peripheral clock enable
	// Position of ROM_CLK_EN field.
	SYSCTL_CLK_EN_PERI_ROM_CLK_EN_Pos = 0x0
	// Bit mask of ROM_CLK_EN field.
	SYSCTL_CLK_EN_PERI_ROM_CLK_EN_Msk = 0x1
	// Bit ROM_CLK_EN.
	SYSCTL_CLK_EN_PERI_ROM_CLK_EN = 0x1
	// Position of DMA_CLK_EN field.
	SYSCTL_CLK_EN_PERI_DMA_CLK_EN_Pos = 0x1
	// Bit mask of DMA_CLK_EN field.
	SYSCTL_CLK_EN_PERI_DMA_CLK_EN_Msk = 0x2
	// Bit DMA_CLK_EN.
	SYSCTL_CLK_EN_PERI_DMA_CLK_EN = 0x2
	// Position of AI_CLK_EN field.
	SYSCTL_CLK_EN_PERI_AI_CLK_EN_Pos = 0x2
	// Bit mask of AI_CLK_EN field.
	SYSCTL_CLK_EN_PERI_AI_CLK_EN_Msk = 0x4
	// Bit AI_CLK_EN.
	SYSCTL_CLK_EN_PERI_AI_CLK_EN = 0x4
	// Position of DVP_CLK_EN field.
	SYSCTL_CLK_EN_PERI_DVP_CLK_EN_Pos = 0x3
	// Bit mask of DVP_CLK_EN field.
	SYSCTL_CLK_EN_PERI_DVP_CLK_EN_Msk = 0x8
	// Bit DVP_CLK_EN.
	SYSCTL_CLK_EN_PERI_DVP_CLK_EN = 0x8
	// Position of FFT_CLK_EN field.
	SYSCTL_CLK_EN_PERI_FFT_CLK_EN_Pos = 0x4
	// Bit mask of FFT_CLK_EN field.
	SYSCTL_CLK_EN_PERI_FFT_CLK_EN_Msk = 0x10
	// Bit FFT_CLK_EN.
	SYSCTL_CLK_EN_PERI_FFT_CLK_EN = 0x10
	// Position of GPIO_CLK_EN field.
	SYSCTL_CLK_EN_PERI_GPIO_CLK_EN_Pos = 0x5
	// Bit mask of GPIO_CLK_EN field.
	SYSCTL_CLK_EN_PERI_GPIO_CLK_EN_Msk = 0x20
	// Bit GPIO_CLK_EN.
	SYSCTL_CLK_EN_PERI_GPIO_CLK_EN = 0x20
	// Position of SPI0_CLK_EN field.
	SYSCTL_CLK_EN_PERI_SPI0_CLK_EN_Pos = 0x6
	// Bit mask of SPI0_CLK_EN field.
	SYSCTL_CLK_EN_PERI_SPI0_CLK_EN_Msk = 0x40
	// Bit SPI0_CLK_EN.
	SYSCTL_CLK_EN_PERI_SPI0_CLK_EN = 0x40
	// Position of SPI1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_SPI1_CLK_EN_Pos = 0x7
	// Bit mask of SPI1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_SPI1_CLK_EN_Msk = 0x80
	// Bit SPI1_CLK_EN.
	SYSCTL_CLK_EN_PERI_SPI1_CLK_EN = 0x80
	// Position of SPI2_CLK_EN field.
	SYSCTL_CLK_EN_PERI_SPI2_CLK_EN_Pos = 0x8
	// Bit mask of SPI2_CLK_EN field.
	SYSCTL_CLK_EN_PERI_SPI2_CLK_EN_Msk = 0x100
	// Bit SPI2_CLK_EN.
	SYSCTL_CLK_EN_PERI_SPI2_CLK_EN = 0x100
	// Position of SPI3_CLK_EN field.
	SYSCTL_CLK_EN_PERI_SPI3_CLK_EN_Pos = 0x9
	// Bit mask of SPI3_CLK_EN field.
	SYSCTL_CLK_EN_PERI_SPI3_CLK_EN_Msk = 0x200
	// Bit SPI3_CLK_EN.
	SYSCTL_CLK_EN_PERI_SPI3_CLK_EN = 0x200
	// Position of I2S0_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2S0_CLK_EN_Pos = 0xa
	// Bit mask of I2S0_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2S0_CLK_EN_Msk = 0x400
	// Bit I2S0_CLK_EN.
	SYSCTL_CLK_EN_PERI_I2S0_CLK_EN = 0x400
	// Position of I2S1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2S1_CLK_EN_Pos = 0xb
	// Bit mask of I2S1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2S1_CLK_EN_Msk = 0x800
	// Bit I2S1_CLK_EN.
	SYSCTL_CLK_EN_PERI_I2S1_CLK_EN = 0x800
	// Position of I2S2_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2S2_CLK_EN_Pos = 0xc
	// Bit mask of I2S2_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2S2_CLK_EN_Msk = 0x1000
	// Bit I2S2_CLK_EN.
	SYSCTL_CLK_EN_PERI_I2S2_CLK_EN = 0x1000
	// Position of I2C0_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2C0_CLK_EN_Pos = 0xd
	// Bit mask of I2C0_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2C0_CLK_EN_Msk = 0x2000
	// Bit I2C0_CLK_EN.
	SYSCTL_CLK_EN_PERI_I2C0_CLK_EN = 0x2000
	// Position of I2C1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2C1_CLK_EN_Pos = 0xe
	// Bit mask of I2C1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2C1_CLK_EN_Msk = 0x4000
	// Bit I2C1_CLK_EN.
	SYSCTL_CLK_EN_PERI_I2C1_CLK_EN = 0x4000
	// Position of I2C2_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2C2_CLK_EN_Pos = 0xf
	// Bit mask of I2C2_CLK_EN field.
	SYSCTL_CLK_EN_PERI_I2C2_CLK_EN_Msk = 0x8000
	// Bit I2C2_CLK_EN.
	SYSCTL_CLK_EN_PERI_I2C2_CLK_EN = 0x8000
	// Position of UART1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_UART1_CLK_EN_Pos = 0x10
	// Bit mask of UART1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_UART1_CLK_EN_Msk = 0x10000
	// Bit UART1_CLK_EN.
	SYSCTL_CLK_EN_PERI_UART1_CLK_EN = 0x10000
	// Position of UART2_CLK_EN field.
	SYSCTL_CLK_EN_PERI_UART2_CLK_EN_Pos = 0x11
	// Bit mask of UART2_CLK_EN field.
	SYSCTL_CLK_EN_PERI_UART2_CLK_EN_Msk = 0x20000
	// Bit UART2_CLK_EN.
	SYSCTL_CLK_EN_PERI_UART2_CLK_EN = 0x20000
	// Position of UART3_CLK_EN field.
	SYSCTL_CLK_EN_PERI_UART3_CLK_EN_Pos = 0x12
	// Bit mask of UART3_CLK_EN field.
	SYSCTL_CLK_EN_PERI_UART3_CLK_EN_Msk = 0x40000
	// Bit UART3_CLK_EN.
	SYSCTL_CLK_EN_PERI_UART3_CLK_EN = 0x40000
	// Position of AES_CLK_EN field.
	SYSCTL_CLK_EN_PERI_AES_CLK_EN_Pos = 0x13
	// Bit mask of AES_CLK_EN field.
	SYSCTL_CLK_EN_PERI_AES_CLK_EN_Msk = 0x80000
	// Bit AES_CLK_EN.
	SYSCTL_CLK_EN_PERI_AES_CLK_EN = 0x80000
	// Position of FPIOA_CLK_EN field.
	SYSCTL_CLK_EN_PERI_FPIOA_CLK_EN_Pos = 0x14
	// Bit mask of FPIOA_CLK_EN field.
	SYSCTL_CLK_EN_PERI_FPIOA_CLK_EN_Msk = 0x100000
	// Bit FPIOA_CLK_EN.
	SYSCTL_CLK_EN_PERI_FPIOA_CLK_EN = 0x100000
	// Position of TIMER0_CLK_EN field.
	SYSCTL_CLK_EN_PERI_TIMER0_CLK_EN_Pos = 0x15
	// Bit mask of TIMER0_CLK_EN field.
	SYSCTL_CLK_EN_PERI_TIMER0_CLK_EN_Msk = 0x200000
	// Bit TIMER0_CLK_EN.
	SYSCTL_CLK_EN_PERI_TIMER0_CLK_EN = 0x200000
	// Position of TIMER1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_TIMER1_CLK_EN_Pos = 0x16
	// Bit mask of TIMER1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_TIMER1_CLK_EN_Msk = 0x400000
	// Bit TIMER1_CLK_EN.
	SYSCTL_CLK_EN_PERI_TIMER1_CLK_EN = 0x400000
	// Position of TIMER2_CLK_EN field.
	SYSCTL_CLK_EN_PERI_TIMER2_CLK_EN_Pos = 0x17
	// Bit mask of TIMER2_CLK_EN field.
	SYSCTL_CLK_EN_PERI_TIMER2_CLK_EN_Msk = 0x800000
	// Bit TIMER2_CLK_EN.
	SYSCTL_CLK_EN_PERI_TIMER2_CLK_EN = 0x800000
	// Position of WDT0_CLK_EN field.
	SYSCTL_CLK_EN_PERI_WDT0_CLK_EN_Pos = 0x18
	// Bit mask of WDT0_CLK_EN field.
	SYSCTL_CLK_EN_PERI_WDT0_CLK_EN_Msk = 0x1000000
	// Bit WDT0_CLK_EN.
	SYSCTL_CLK_EN_PERI_WDT0_CLK_EN = 0x1000000
	// Position of WDT1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_WDT1_CLK_EN_Pos = 0x19
	// Bit mask of WDT1_CLK_EN field.
	SYSCTL_CLK_EN_PERI_WDT1_CLK_EN_Msk = 0x2000000
	// Bit WDT1_CLK_EN.
	SYSCTL_CLK_EN_PERI_WDT1_CLK_EN = 0x2000000
	// Position of SHA_CLK_EN field.
	SYSCTL_CLK_EN_PERI_SHA_CLK_EN_Pos = 0x1a
	// Bit mask of SHA_CLK_EN field.
	SYSCTL_CLK_EN_PERI_SHA_CLK_EN_Msk = 0x4000000
	// Bit SHA_CLK_EN.
	SYSCTL_CLK_EN_PERI_SHA_CLK_EN = 0x4000000
	// Position of OTP_CLK_EN field.
	SYSCTL_CLK_EN_PERI_OTP_CLK_EN_Pos = 0x1b
	// Bit mask of OTP_CLK_EN field.
	SYSCTL_CLK_EN_PERI_OTP_CLK_EN_Msk = 0x8000000
	// Bit OTP_CLK_EN.
	SYSCTL_CLK_EN_PERI_OTP_CLK_EN = 0x8000000
	// Position of RTC_CLK_EN field.
	SYSCTL_CLK_EN_PERI_RTC_CLK_EN_Pos = 0x1d
	// Bit mask of RTC_CLK_EN field.
	SYSCTL_CLK_EN_PERI_RTC_CLK_EN_Msk = 0x20000000
	// Bit RTC_CLK_EN.
	SYSCTL_CLK_EN_PERI_RTC_CLK_EN = 0x20000000

	// SOFT_RESET: Soft reset ctrl
	// Position of SOFT_RESET field.
	SYSCTL_SOFT_RESET_SOFT_RESET_Pos = 0x0
	// Bit mask of SOFT_RESET field.
	SYSCTL_SOFT_RESET_SOFT_RESET_Msk = 0x1
	// Bit SOFT_RESET.
	SYSCTL_SOFT_RESET_SOFT_RESET = 0x1

	// PERI_RESET: Peripheral reset controller
	// Position of ROM_RESET field.
	SYSCTL_PERI_RESET_ROM_RESET_Pos = 0x0
	// Bit mask of ROM_RESET field.
	SYSCTL_PERI_RESET_ROM_RESET_Msk = 0x1
	// Bit ROM_RESET.
	SYSCTL_PERI_RESET_ROM_RESET = 0x1
	// Position of DMA_RESET field.
	SYSCTL_PERI_RESET_DMA_RESET_Pos = 0x1
	// Bit mask of DMA_RESET field.
	SYSCTL_PERI_RESET_DMA_RESET_Msk = 0x2
	// Bit DMA_RESET.
	SYSCTL_PERI_RESET_DMA_RESET = 0x2
	// Position of AI_RESET field.
	SYSCTL_PERI_RESET_AI_RESET_Pos = 0x2
	// Bit mask of AI_RESET field.
	SYSCTL_PERI_RESET_AI_RESET_Msk = 0x4
	// Bit AI_RESET.
	SYSCTL_PERI_RESET_AI_RESET = 0x4
	// Position of DVP_RESET field.
	SYSCTL_PERI_RESET_DVP_RESET_Pos = 0x3
	// Bit mask of DVP_RESET field.
	SYSCTL_PERI_RESET_DVP_RESET_Msk = 0x8
	// Bit DVP_RESET.
	SYSCTL_PERI_RESET_DVP_RESET = 0x8
	// Position of FFT_RESET field.
	SYSCTL_PERI_RESET_FFT_RESET_Pos = 0x4
	// Bit mask of FFT_RESET field.
	SYSCTL_PERI_RESET_FFT_RESET_Msk = 0x10
	// Bit FFT_RESET.
	SYSCTL_PERI_RESET_FFT_RESET = 0x10
	// Position of GPIO_RESET field.
	SYSCTL_PERI_RESET_GPIO_RESET_Pos = 0x5
	// Bit mask of GPIO_RESET field.
	SYSCTL_PERI_RESET_GPIO_RESET_Msk = 0x20
	// Bit GPIO_RESET.
	SYSCTL_PERI_RESET_GPIO_RESET = 0x20
	// Position of SPI0_RESET field.
	SYSCTL_PERI_RESET_SPI0_RESET_Pos = 0x6
	// Bit mask of SPI0_RESET field.
	SYSCTL_PERI_RESET_SPI0_RESET_Msk = 0x40
	// Bit SPI0_RESET.
	SYSCTL_PERI_RESET_SPI0_RESET = 0x40
	// Position of SPI1_RESET field.
	SYSCTL_PERI_RESET_SPI1_RESET_Pos = 0x7
	// Bit mask of SPI1_RESET field.
	SYSCTL_PERI_RESET_SPI1_RESET_Msk = 0x80
	// Bit SPI1_RESET.
	SYSCTL_PERI_RESET_SPI1_RESET = 0x80
	// Position of SPI2_RESET field.
	SYSCTL_PERI_RESET_SPI2_RESET_Pos = 0x8
	// Bit mask of SPI2_RESET field.
	SYSCTL_PERI_RESET_SPI2_RESET_Msk = 0x100
	// Bit SPI2_RESET.
	SYSCTL_PERI_RESET_SPI2_RESET = 0x100
	// Position of SPI3_RESET field.
	SYSCTL_PERI_RESET_SPI3_RESET_Pos = 0x9
	// Bit mask of SPI3_RESET field.
	SYSCTL_PERI_RESET_SPI3_RESET_Msk = 0x200
	// Bit SPI3_RESET.
	SYSCTL_PERI_RESET_SPI3_RESET = 0x200
	// Position of I2S0_RESET field.
	SYSCTL_PERI_RESET_I2S0_RESET_Pos = 0xa
	// Bit mask of I2S0_RESET field.
	SYSCTL_PERI_RESET_I2S0_RESET_Msk = 0x400
	// Bit I2S0_RESET.
	SYSCTL_PERI_RESET_I2S0_RESET = 0x400
	// Position of I2S1_RESET field.
	SYSCTL_PERI_RESET_I2S1_RESET_Pos = 0xb
	// Bit mask of I2S1_RESET field.
	SYSCTL_PERI_RESET_I2S1_RESET_Msk = 0x800
	// Bit I2S1_RESET.
	SYSCTL_PERI_RESET_I2S1_RESET = 0x800
	// Position of I2S2_RESET field.
	SYSCTL_PERI_RESET_I2S2_RESET_Pos = 0xc
	// Bit mask of I2S2_RESET field.
	SYSCTL_PERI_RESET_I2S2_RESET_Msk = 0x1000
	// Bit I2S2_RESET.
	SYSCTL_PERI_RESET_I2S2_RESET = 0x1000
	// Position of I2C0_RESET field.
	SYSCTL_PERI_RESET_I2C0_RESET_Pos = 0xd
	// Bit mask of I2C0_RESET field.
	SYSCTL_PERI_RESET_I2C0_RESET_Msk = 0x2000
	// Bit I2C0_RESET.
	SYSCTL_PERI_RESET_I2C0_RESET = 0x2000
	// Position of I2C1_RESET field.
	SYSCTL_PERI_RESET_I2C1_RESET_Pos = 0xe
	// Bit mask of I2C1_RESET field.
	SYSCTL_PERI_RESET_I2C1_RESET_Msk = 0x4000
	// Bit I2C1_RESET.
	SYSCTL_PERI_RESET_I2C1_RESET = 0x4000
	// Position of I2C2_RESET field.
	SYSCTL_PERI_RESET_I2C2_RESET_Pos = 0xf
	// Bit mask of I2C2_RESET field.
	SYSCTL_PERI_RESET_I2C2_RESET_Msk = 0x8000
	// Bit I2C2_RESET.
	SYSCTL_PERI_RESET_I2C2_RESET = 0x8000
	// Position of UART1_RESET field.
	SYSCTL_PERI_RESET_UART1_RESET_Pos = 0x10
	// Bit mask of UART1_RESET field.
	SYSCTL_PERI_RESET_UART1_RESET_Msk = 0x10000
	// Bit UART1_RESET.
	SYSCTL_PERI_RESET_UART1_RESET = 0x10000
	// Position of UART2_RESET field.
	SYSCTL_PERI_RESET_UART2_RESET_Pos = 0x11
	// Bit mask of UART2_RESET field.
	SYSCTL_PERI_RESET_UART2_RESET_Msk = 0x20000
	// Bit UART2_RESET.
	SYSCTL_PERI_RESET_UART2_RESET = 0x20000
	// Position of UART3_RESET field.
	SYSCTL_PERI_RESET_UART3_RESET_Pos = 0x12
	// Bit mask of UART3_RESET field.
	SYSCTL_PERI_RESET_UART3_RESET_Msk = 0x40000
	// Bit UART3_RESET.
	SYSCTL_PERI_RESET_UART3_RESET = 0x40000
	// Position of AES_RESET field.
	SYSCTL_PERI_RESET_AES_RESET_Pos = 0x13
	// Bit mask of AES_RESET field.
	SYSCTL_PERI_RESET_AES_RESET_Msk = 0x80000
	// Bit AES_RESET.
	SYSCTL_PERI_RESET_AES_RESET = 0x80000
	// Position of FPIOA_RESET field.
	SYSCTL_PERI_RESET_FPIOA_RESET_Pos = 0x14
	// Bit mask of FPIOA_RESET field.
	SYSCTL_PERI_RESET_FPIOA_RESET_Msk = 0x100000
	// Bit FPIOA_RESET.
	SYSCTL_PERI_RESET_FPIOA_RESET = 0x100000
	// Position of TIMER0_RESET field.
	SYSCTL_PERI_RESET_TIMER0_RESET_Pos = 0x15
	// Bit mask of TIMER0_RESET field.
	SYSCTL_PERI_RESET_TIMER0_RESET_Msk = 0x200000
	// Bit TIMER0_RESET.
	SYSCTL_PERI_RESET_TIMER0_RESET = 0x200000
	// Position of TIMER1_RESET field.
	SYSCTL_PERI_RESET_TIMER1_RESET_Pos = 0x16
	// Bit mask of TIMER1_RESET field.
	SYSCTL_PERI_RESET_TIMER1_RESET_Msk = 0x400000
	// Bit TIMER1_RESET.
	SYSCTL_PERI_RESET_TIMER1_RESET = 0x400000
	// Position of TIMER2_RESET field.
	SYSCTL_PERI_RESET_TIMER2_RESET_Pos = 0x17
	// Bit mask of TIMER2_RESET field.
	SYSCTL_PERI_RESET_TIMER2_RESET_Msk = 0x800000
	// Bit TIMER2_RESET.
	SYSCTL_PERI_RESET_TIMER2_RESET = 0x800000
	// Position of WDT0_RESET field.
	SYSCTL_PERI_RESET_WDT0_RESET_Pos = 0x18
	// Bit mask of WDT0_RESET field.
	SYSCTL_PERI_RESET_WDT0_RESET_Msk = 0x1000000
	// Bit WDT0_RESET.
	SYSCTL_PERI_RESET_WDT0_RESET = 0x1000000
	// Position of WDT1_RESET field.
	SYSCTL_PERI_RESET_WDT1_RESET_Pos = 0x19
	// Bit mask of WDT1_RESET field.
	SYSCTL_PERI_RESET_WDT1_RESET_Msk = 0x2000000
	// Bit WDT1_RESET.
	SYSCTL_PERI_RESET_WDT1_RESET = 0x2000000
	// Position of SHA_RESET field.
	SYSCTL_PERI_RESET_SHA_RESET_Pos = 0x1a
	// Bit mask of SHA_RESET field.
	SYSCTL_PERI_RESET_SHA_RESET_Msk = 0x4000000
	// Bit SHA_RESET.
	SYSCTL_PERI_RESET_SHA_RESET = 0x4000000
	// Position of RTC_RESET field.
	SYSCTL_PERI_RESET_RTC_RESET_Pos = 0x1d
	// Bit mask of RTC_RESET field.
	SYSCTL_PERI_RESET_RTC_RESET_Msk = 0x20000000
	// Bit RTC_RESET.
	SYSCTL_PERI_RESET_RTC_RESET = 0x20000000

	// CLK_TH0: Clock threshold controller 0
	// Position of SRAM0_GCLK field.
	SYSCTL_CLK_TH0_SRAM0_GCLK_Pos = 0x0
	// Bit mask of SRAM0_GCLK field.
	SYSCTL_CLK_TH0_SRAM0_GCLK_Msk = 0xf
	// Position of SRAM1_GCLK field.
	SYSCTL_CLK_TH0_SRAM1_GCLK_Pos = 0x4
	// Bit mask of SRAM1_GCLK field.
	SYSCTL_CLK_TH0_SRAM1_GCLK_Msk = 0xf0
	// Position of AI_GCLK field.
	SYSCTL_CLK_TH0_AI_GCLK_Pos = 0x8
	// Bit mask of AI_GCLK field.
	SYSCTL_CLK_TH0_AI_GCLK_Msk = 0xf00
	// Position of DVP_GCLK field.
	SYSCTL_CLK_TH0_DVP_GCLK_Pos = 0xc
	// Bit mask of DVP_GCLK field.
	SYSCTL_CLK_TH0_DVP_GCLK_Msk = 0xf000
	// Position of ROM_GCLK field.
	SYSCTL_CLK_TH0_ROM_GCLK_Pos = 0x10
	// Bit mask of ROM_GCLK field.
	SYSCTL_CLK_TH0_ROM_GCLK_Msk = 0xf0000

	// CLK_TH1: Clock threshold controller 1
	// Position of SPI0_CLK field.
	SYSCTL_CLK_TH1_SPI0_CLK_Pos = 0x0
	// Bit mask of SPI0_CLK field.
	SYSCTL_CLK_TH1_SPI0_CLK_Msk = 0xff
	// Position of SPI1_CLK field.
	SYSCTL_CLK_TH1_SPI1_CLK_Pos = 0x8
	// Bit mask of SPI1_CLK field.
	SYSCTL_CLK_TH1_SPI1_CLK_Msk = 0xff00
	// Position of SPI2_CLK field.
	SYSCTL_CLK_TH1_SPI2_CLK_Pos = 0x10
	// Bit mask of SPI2_CLK field.
	SYSCTL_CLK_TH1_SPI2_CLK_Msk = 0xff0000
	// Position of SPI3_CLK field.
	SYSCTL_CLK_TH1_SPI3_CLK_Pos = 0x18
	// Bit mask of SPI3_CLK field.
	SYSCTL_CLK_TH1_SPI3_CLK_Msk = 0xff000000

	// CLK_TH2: Clock threshold controller 2
	// Position of TIMER0_CLK field.
	SYSCTL_CLK_TH2_TIMER0_CLK_Pos = 0x0
	// Bit mask of TIMER0_CLK field.
	SYSCTL_CLK_TH2_TIMER0_CLK_Msk = 0xff
	// Position of TIMER1_CLK field.
	SYSCTL_CLK_TH2_TIMER1_CLK_Pos = 0x8
	// Bit mask of TIMER1_CLK field.
	SYSCTL_CLK_TH2_TIMER1_CLK_Msk = 0xff00
	// Position of TIMER2_CLK field.
	SYSCTL_CLK_TH2_TIMER2_CLK_Pos = 0x10
	// Bit mask of TIMER2_CLK field.
	SYSCTL_CLK_TH2_TIMER2_CLK_Msk = 0xff0000

	// CLK_TH3: Clock threshold controller 3
	// Position of I2S0_CLK field.
	SYSCTL_CLK_TH3_I2S0_CLK_Pos = 0x0
	// Bit mask of I2S0_CLK field.
	SYSCTL_CLK_TH3_I2S0_CLK_Msk = 0xffff
	// Position of I2S1_CLK field.
	SYSCTL_CLK_TH3_I2S1_CLK_Pos = 0x10
	// Bit mask of I2S1_CLK field.
	SYSCTL_CLK_TH3_I2S1_CLK_Msk = 0xffff0000

	// CLK_TH4: Clock threshold controller 4
	// Position of I2S2_CLK field.
	SYSCTL_CLK_TH4_I2S2_CLK_Pos = 0x0
	// Bit mask of I2S2_CLK field.
	SYSCTL_CLK_TH4_I2S2_CLK_Msk = 0xffff
	// Position of I2S0_MCLK field.
	SYSCTL_CLK_TH4_I2S0_MCLK_Pos = 0x10
	// Bit mask of I2S0_MCLK field.
	SYSCTL_CLK_TH4_I2S0_MCLK_Msk = 0xff0000
	// Position of I2S1_MCLK field.
	SYSCTL_CLK_TH4_I2S1_MCLK_Pos = 0x18
	// Bit mask of I2S1_MCLK field.
	SYSCTL_CLK_TH4_I2S1_MCLK_Msk = 0xff000000

	// CLK_TH5: Clock threshold controller 5
	// Position of I2S2_MCLK field.
	SYSCTL_CLK_TH5_I2S2_MCLK_Pos = 0x0
	// Bit mask of I2S2_MCLK field.
	SYSCTL_CLK_TH5_I2S2_MCLK_Msk = 0xff
	// Position of I2C0_CLK field.
	SYSCTL_CLK_TH5_I2C0_CLK_Pos = 0x8
	// Bit mask of I2C0_CLK field.
	SYSCTL_CLK_TH5_I2C0_CLK_Msk = 0xff00
	// Position of I2C1_CLK field.
	SYSCTL_CLK_TH5_I2C1_CLK_Pos = 0x10
	// Bit mask of I2C1_CLK field.
	SYSCTL_CLK_TH5_I2C1_CLK_Msk = 0xff0000
	// Position of I2C2_CLK field.
	SYSCTL_CLK_TH5_I2C2_CLK_Pos = 0x18
	// Bit mask of I2C2_CLK field.
	SYSCTL_CLK_TH5_I2C2_CLK_Msk = 0xff000000

	// CLK_TH6: Clock threshold controller 6
	// Position of WDT0_CLK field.
	SYSCTL_CLK_TH6_WDT0_CLK_Pos = 0x0
	// Bit mask of WDT0_CLK field.
	SYSCTL_CLK_TH6_WDT0_CLK_Msk = 0xff
	// Position of WDT1_CLK field.
	SYSCTL_CLK_TH6_WDT1_CLK_Pos = 0x8
	// Bit mask of WDT1_CLK field.
	SYSCTL_CLK_TH6_WDT1_CLK_Msk = 0xff00

	// MISC: Miscellaneous controller
	// Position of DEBUG_SEL field.
	SYSCTL_MISC_DEBUG_SEL_Pos = 0x0
	// Bit mask of DEBUG_SEL field.
	SYSCTL_MISC_DEBUG_SEL_Msk = 0x3f
	// Position of SPI_DVP_DATA_ENABLE field.
	SYSCTL_MISC_SPI_DVP_DATA_ENABLE_Pos = 0xa
	// Bit mask of SPI_DVP_DATA_ENABLE field.
	SYSCTL_MISC_SPI_DVP_DATA_ENABLE_Msk = 0x400
	// Bit SPI_DVP_DATA_ENABLE.
	SYSCTL_MISC_SPI_DVP_DATA_ENABLE = 0x400

	// PERI: Peripheral controller
	// Position of TIMER0_PAUSE field.
	SYSCTL_PERI_TIMER0_PAUSE_Pos = 0x0
	// Bit mask of TIMER0_PAUSE field.
	SYSCTL_PERI_TIMER0_PAUSE_Msk = 0x1
	// Bit TIMER0_PAUSE.
	SYSCTL_PERI_TIMER0_PAUSE = 0x1
	// Position of TIMER1_PAUSE field.
	SYSCTL_PERI_TIMER1_PAUSE_Pos = 0x1
	// Bit mask of TIMER1_PAUSE field.
	SYSCTL_PERI_TIMER1_PAUSE_Msk = 0x2
	// Bit TIMER1_PAUSE.
	SYSCTL_PERI_TIMER1_PAUSE = 0x2
	// Position of TIMER2_PAUSE field.
	SYSCTL_PERI_TIMER2_PAUSE_Pos = 0x2
	// Bit mask of TIMER2_PAUSE field.
	SYSCTL_PERI_TIMER2_PAUSE_Msk = 0x4
	// Bit TIMER2_PAUSE.
	SYSCTL_PERI_TIMER2_PAUSE = 0x4
	// Position of TIMER3_PAUSE field.
	SYSCTL_PERI_TIMER3_PAUSE_Pos = 0x3
	// Bit mask of TIMER3_PAUSE field.
	SYSCTL_PERI_TIMER3_PAUSE_Msk = 0x8
	// Bit TIMER3_PAUSE.
	SYSCTL_PERI_TIMER3_PAUSE = 0x8
	// Position of TIMER4_PAUSE field.
	SYSCTL_PERI_TIMER4_PAUSE_Pos = 0x4
	// Bit mask of TIMER4_PAUSE field.
	SYSCTL_PERI_TIMER4_PAUSE_Msk = 0x10
	// Bit TIMER4_PAUSE.
	SYSCTL_PERI_TIMER4_PAUSE = 0x10
	// Position of TIMER5_PAUSE field.
	SYSCTL_PERI_TIMER5_PAUSE_Pos = 0x5
	// Bit mask of TIMER5_PAUSE field.
	SYSCTL_PERI_TIMER5_PAUSE_Msk = 0x20
	// Bit TIMER5_PAUSE.
	SYSCTL_PERI_TIMER5_PAUSE = 0x20
	// Position of TIMER6_PAUSE field.
	SYSCTL_PERI_TIMER6_PAUSE_Pos = 0x6
	// Bit mask of TIMER6_PAUSE field.
	SYSCTL_PERI_TIMER6_PAUSE_Msk = 0x40
	// Bit TIMER6_PAUSE.
	SYSCTL_PERI_TIMER6_PAUSE = 0x40
	// Position of TIMER7_PAUSE field.
	SYSCTL_PERI_TIMER7_PAUSE_Pos = 0x7
	// Bit mask of TIMER7_PAUSE field.
	SYSCTL_PERI_TIMER7_PAUSE_Msk = 0x80
	// Bit TIMER7_PAUSE.
	SYSCTL_PERI_TIMER7_PAUSE = 0x80
	// Position of TIMER8_PAUSE field.
	SYSCTL_PERI_TIMER8_PAUSE_Pos = 0x8
	// Bit mask of TIMER8_PAUSE field.
	SYSCTL_PERI_TIMER8_PAUSE_Msk = 0x100
	// Bit TIMER8_PAUSE.
	SYSCTL_PERI_TIMER8_PAUSE = 0x100
	// Position of TIMER9_PAUSE field.
	SYSCTL_PERI_TIMER9_PAUSE_Pos = 0x9
	// Bit mask of TIMER9_PAUSE field.
	SYSCTL_PERI_TIMER9_PAUSE_Msk = 0x200
	// Bit TIMER9_PAUSE.
	SYSCTL_PERI_TIMER9_PAUSE = 0x200
	// Position of TIMER10_PAUSE field.
	SYSCTL_PERI_TIMER10_PAUSE_Pos = 0xa
	// Bit mask of TIMER10_PAUSE field.
	SYSCTL_PERI_TIMER10_PAUSE_Msk = 0x400
	// Bit TIMER10_PAUSE.
	SYSCTL_PERI_TIMER10_PAUSE = 0x400
	// Position of TIMER11_PAUSE field.
	SYSCTL_PERI_TIMER11_PAUSE_Pos = 0xb
	// Bit mask of TIMER11_PAUSE field.
	SYSCTL_PERI_TIMER11_PAUSE_Msk = 0x800
	// Bit TIMER11_PAUSE.
	SYSCTL_PERI_TIMER11_PAUSE = 0x800
	// Position of SPI0_XIP_EN field.
	SYSCTL_PERI_SPI0_XIP_EN_Pos = 0xc
	// Bit mask of SPI0_XIP_EN field.
	SYSCTL_PERI_SPI0_XIP_EN_Msk = 0x1000
	// Bit SPI0_XIP_EN.
	SYSCTL_PERI_SPI0_XIP_EN = 0x1000
	// Position of SPI1_XIP_EN field.
	SYSCTL_PERI_SPI1_XIP_EN_Pos = 0xd
	// Bit mask of SPI1_XIP_EN field.
	SYSCTL_PERI_SPI1_XIP_EN_Msk = 0x2000
	// Bit SPI1_XIP_EN.
	SYSCTL_PERI_SPI1_XIP_EN = 0x2000
	// Position of SPI2_XIP_EN field.
	SYSCTL_PERI_SPI2_XIP_EN_Pos = 0xe
	// Bit mask of SPI2_XIP_EN field.
	SYSCTL_PERI_SPI2_XIP_EN_Msk = 0x4000
	// Bit SPI2_XIP_EN.
	SYSCTL_PERI_SPI2_XIP_EN = 0x4000
	// Position of SPI3_XIP_EN field.
	SYSCTL_PERI_SPI3_XIP_EN_Pos = 0xf
	// Bit mask of SPI3_XIP_EN field.
	SYSCTL_PERI_SPI3_XIP_EN_Msk = 0x8000
	// Bit SPI3_XIP_EN.
	SYSCTL_PERI_SPI3_XIP_EN = 0x8000
	// Position of SPI0_CLK_BYPASS field.
	SYSCTL_PERI_SPI0_CLK_BYPASS_Pos = 0x10
	// Bit mask of SPI0_CLK_BYPASS field.
	SYSCTL_PERI_SPI0_CLK_BYPASS_Msk = 0x10000
	// Bit SPI0_CLK_BYPASS.
	SYSCTL_PERI_SPI0_CLK_BYPASS = 0x10000
	// Position of SPI1_CLK_BYPASS field.
	SYSCTL_PERI_SPI1_CLK_BYPASS_Pos = 0x11
	// Bit mask of SPI1_CLK_BYPASS field.
	SYSCTL_PERI_SPI1_CLK_BYPASS_Msk = 0x20000
	// Bit SPI1_CLK_BYPASS.
	SYSCTL_PERI_SPI1_CLK_BYPASS = 0x20000
	// Position of SPI2_CLK_BYPASS field.
	SYSCTL_PERI_SPI2_CLK_BYPASS_Pos = 0x12
	// Bit mask of SPI2_CLK_BYPASS field.
	SYSCTL_PERI_SPI2_CLK_BYPASS_Msk = 0x40000
	// Bit SPI2_CLK_BYPASS.
	SYSCTL_PERI_SPI2_CLK_BYPASS = 0x40000
	// Position of I2S0_CLK_BYPASS field.
	SYSCTL_PERI_I2S0_CLK_BYPASS_Pos = 0x13
	// Bit mask of I2S0_CLK_BYPASS field.
	SYSCTL_PERI_I2S0_CLK_BYPASS_Msk = 0x80000
	// Bit I2S0_CLK_BYPASS.
	SYSCTL_PERI_I2S0_CLK_BYPASS = 0x80000
	// Position of I2S1_CLK_BYPASS field.
	SYSCTL_PERI_I2S1_CLK_BYPASS_Pos = 0x14
	// Bit mask of I2S1_CLK_BYPASS field.
	SYSCTL_PERI_I2S1_CLK_BYPASS_Msk = 0x100000
	// Bit I2S1_CLK_BYPASS.
	SYSCTL_PERI_I2S1_CLK_BYPASS = 0x100000
	// Position of I2S2_CLK_BYPASS field.
	SYSCTL_PERI_I2S2_CLK_BYPASS_Pos = 0x15
	// Bit mask of I2S2_CLK_BYPASS field.
	SYSCTL_PERI_I2S2_CLK_BYPASS_Msk = 0x200000
	// Bit I2S2_CLK_BYPASS.
	SYSCTL_PERI_I2S2_CLK_BYPASS = 0x200000
	// Position of JTAG_CLK_BYPASS field.
	SYSCTL_PERI_JTAG_CLK_BYPASS_Pos = 0x16
	// Bit mask of JTAG_CLK_BYPASS field.
	SYSCTL_PERI_JTAG_CLK_BYPASS_Msk = 0x400000
	// Bit JTAG_CLK_BYPASS.
	SYSCTL_PERI_JTAG_CLK_BYPASS = 0x400000
	// Position of DVP_CLK_BYPASS field.
	SYSCTL_PERI_DVP_CLK_BYPASS_Pos = 0x17
	// Bit mask of DVP_CLK_BYPASS field.
	SYSCTL_PERI_DVP_CLK_BYPASS_Msk = 0x800000
	// Bit DVP_CLK_BYPASS.
	SYSCTL_PERI_DVP_CLK_BYPASS = 0x800000
	// Position of DEBUG_CLK_BYPASS field.
	SYSCTL_PERI_DEBUG_CLK_BYPASS_Pos = 0x18
	// Bit mask of DEBUG_CLK_BYPASS field.
	SYSCTL_PERI_DEBUG_CLK_BYPASS_Msk = 0x1000000
	// Bit DEBUG_CLK_BYPASS.
	SYSCTL_PERI_DEBUG_CLK_BYPASS = 0x1000000

	// SPI_SLEEP: SPI sleep controller
	// Position of SSI0_SLEEP field.
	SYSCTL_SPI_SLEEP_SSI0_SLEEP_Pos = 0x0
	// Bit mask of SSI0_SLEEP field.
	SYSCTL_SPI_SLEEP_SSI0_SLEEP_Msk = 0x1
	// Bit SSI0_SLEEP.
	SYSCTL_SPI_SLEEP_SSI0_SLEEP = 0x1
	// Position of SSI1_SLEEP field.
	SYSCTL_SPI_SLEEP_SSI1_SLEEP_Pos = 0x1
	// Bit mask of SSI1_SLEEP field.
	SYSCTL_SPI_SLEEP_SSI1_SLEEP_Msk = 0x2
	// Bit SSI1_SLEEP.
	SYSCTL_SPI_SLEEP_SSI1_SLEEP = 0x2
	// Position of SSI2_SLEEP field.
	SYSCTL_SPI_SLEEP_SSI2_SLEEP_Pos = 0x2
	// Bit mask of SSI2_SLEEP field.
	SYSCTL_SPI_SLEEP_SSI2_SLEEP_Msk = 0x4
	// Bit SSI2_SLEEP.
	SYSCTL_SPI_SLEEP_SSI2_SLEEP = 0x4
	// Position of SSI3_SLEEP field.
	SYSCTL_SPI_SLEEP_SSI3_SLEEP_Pos = 0x3
	// Bit mask of SSI3_SLEEP field.
	SYSCTL_SPI_SLEEP_SSI3_SLEEP_Msk = 0x8
	// Bit SSI3_SLEEP.
	SYSCTL_SPI_SLEEP_SSI3_SLEEP = 0x8

	// RESET_STATUS: Reset source status
	// Position of RESET_STS_CLR field.
	SYSCTL_RESET_STATUS_RESET_STS_CLR_Pos = 0x0
	// Bit mask of RESET_STS_CLR field.
	SYSCTL_RESET_STATUS_RESET_STS_CLR_Msk = 0x1
	// Bit RESET_STS_CLR.
	SYSCTL_RESET_STATUS_RESET_STS_CLR = 0x1
	// Position of PIN_RESET_STS field.
	SYSCTL_RESET_STATUS_PIN_RESET_STS_Pos = 0x1
	// Bit mask of PIN_RESET_STS field.
	SYSCTL_RESET_STATUS_PIN_RESET_STS_Msk = 0x2
	// Bit PIN_RESET_STS.
	SYSCTL_RESET_STATUS_PIN_RESET_STS = 0x2
	// Position of WDT0_RESET_STS field.
	SYSCTL_RESET_STATUS_WDT0_RESET_STS_Pos = 0x2
	// Bit mask of WDT0_RESET_STS field.
	SYSCTL_RESET_STATUS_WDT0_RESET_STS_Msk = 0x4
	// Bit WDT0_RESET_STS.
	SYSCTL_RESET_STATUS_WDT0_RESET_STS = 0x4
	// Position of WDT1_RESET_STS field.
	SYSCTL_RESET_STATUS_WDT1_RESET_STS_Pos = 0x3
	// Bit mask of WDT1_RESET_STS field.
	SYSCTL_RESET_STATUS_WDT1_RESET_STS_Msk = 0x8
	// Bit WDT1_RESET_STS.
	SYSCTL_RESET_STATUS_WDT1_RESET_STS = 0x8
	// Position of SOFT_RESET_STS field.
	SYSCTL_RESET_STATUS_SOFT_RESET_STS_Pos = 0x4
	// Bit mask of SOFT_RESET_STS field.
	SYSCTL_RESET_STATUS_SOFT_RESET_STS_Msk = 0x10
	// Bit SOFT_RESET_STS.
	SYSCTL_RESET_STATUS_SOFT_RESET_STS = 0x10

	// DMA_SEL0: DMA handshake selector
	// Position of DMA_SEL0 field.
	SYSCTL_DMA_SEL0_DMA_SEL0_Pos = 0x0
	// Bit mask of DMA_SEL0 field.
	SYSCTL_DMA_SEL0_DMA_SEL0_Msk               = 0x3f
	SYSCTL_DMA_SEL0_DMA_SEL0_SSI0_RX_REQ       = 0x0
	SYSCTL_DMA_SEL0_DMA_SEL0_SSI0_TX_REQ       = 0x1
	SYSCTL_DMA_SEL0_DMA_SEL0_SSI1_RX_REQ       = 0x2
	SYSCTL_DMA_SEL0_DMA_SEL0_SSI1_TX_REQ       = 0x3
	SYSCTL_DMA_SEL0_DMA_SEL0_SSI2_RX_REQ       = 0x4
	SYSCTL_DMA_SEL0_DMA_SEL0_SSI2_TX_REQ       = 0x5
	SYSCTL_DMA_SEL0_DMA_SEL0_SSI3_RX_REQ       = 0x6
	SYSCTL_DMA_SEL0_DMA_SEL0_SSI3_TX_REQ       = 0x7
	SYSCTL_DMA_SEL0_DMA_SEL0_I2C0_RX_REQ       = 0x8
	SYSCTL_DMA_SEL0_DMA_SEL0_I2C0_TX_REQ       = 0x9
	SYSCTL_DMA_SEL0_DMA_SEL0_I2C1_RX_REQ       = 0xa
	SYSCTL_DMA_SEL0_DMA_SEL0_I2C1_TX_REQ       = 0xb
	SYSCTL_DMA_SEL0_DMA_SEL0_I2C2_RX_REQ       = 0xc
	SYSCTL_DMA_SEL0_DMA_SEL0_I2C2_TX_REQ       = 0xd
	SYSCTL_DMA_SEL0_DMA_SEL0_UART1_RX_REQ      = 0xe
	SYSCTL_DMA_SEL0_DMA_SEL0_UART1_TX_REQ      = 0xf
	SYSCTL_DMA_SEL0_DMA_SEL0_UART2_RX_REQ      = 0x10
	SYSCTL_DMA_SEL0_DMA_SEL0_UART2_TX_REQ      = 0x11
	SYSCTL_DMA_SEL0_DMA_SEL0_UART3_RX_REQ      = 0x12
	SYSCTL_DMA_SEL0_DMA_SEL0_UART3_TX_REQ      = 0x13
	SYSCTL_DMA_SEL0_DMA_SEL0_AES_REQ           = 0x14
	SYSCTL_DMA_SEL0_DMA_SEL0_SHA_RX_REQ        = 0x15
	SYSCTL_DMA_SEL0_DMA_SEL0_AI_RX_REQ         = 0x16
	SYSCTL_DMA_SEL0_DMA_SEL0_FFT_RX_REQ        = 0x17
	SYSCTL_DMA_SEL0_DMA_SEL0_FFT_TX_REQ        = 0x18
	SYSCTL_DMA_SEL0_DMA_SEL0_I2S0_TX_REQ       = 0x19
	SYSCTL_DMA_SEL0_DMA_SEL0_I2S0_RX_REQ       = 0x1a
	SYSCTL_DMA_SEL0_DMA_SEL0_I2S1_TX_REQ       = 0x1b
	SYSCTL_DMA_SEL0_DMA_SEL0_I2S1_RX_REQ       = 0x1c
	SYSCTL_DMA_SEL0_DMA_SEL0_I2S2_TX_REQ       = 0x1d
	SYSCTL_DMA_SEL0_DMA_SEL0_I2S2_RX_REQ       = 0x1e
	SYSCTL_DMA_SEL0_DMA_SEL0_I2S0_BF_DIR_REQ   = 0x1f
	SYSCTL_DMA_SEL0_DMA_SEL0_I2S0_BF_VOICE_REQ = 0x20
	// Position of DMA_SEL1 field.
	SYSCTL_DMA_SEL0_DMA_SEL1_Pos = 0x6
	// Bit mask of DMA_SEL1 field.
	SYSCTL_DMA_SEL0_DMA_SEL1_Msk               = 0xfc0
	SYSCTL_DMA_SEL0_DMA_SEL1_SSI0_RX_REQ       = 0x0
	SYSCTL_DMA_SEL0_DMA_SEL1_SSI0_TX_REQ       = 0x1
	SYSCTL_DMA_SEL0_DMA_SEL1_SSI1_RX_REQ       = 0x2
	SYSCTL_DMA_SEL0_DMA_SEL1_SSI1_TX_REQ       = 0x3
	SYSCTL_DMA_SEL0_DMA_SEL1_SSI2_RX_REQ       = 0x4
	SYSCTL_DMA_SEL0_DMA_SEL1_SSI2_TX_REQ       = 0x5
	SYSCTL_DMA_SEL0_DMA_SEL1_SSI3_RX_REQ       = 0x6
	SYSCTL_DMA_SEL0_DMA_SEL1_SSI3_TX_REQ       = 0x7
	SYSCTL_DMA_SEL0_DMA_SEL1_I2C0_RX_REQ       = 0x8
	SYSCTL_DMA_SEL0_DMA_SEL1_I2C0_TX_REQ       = 0x9
	SYSCTL_DMA_SEL0_DMA_SEL1_I2C1_RX_REQ       = 0xa
	SYSCTL_DMA_SEL0_DMA_SEL1_I2C1_TX_REQ       = 0xb
	SYSCTL_DMA_SEL0_DMA_SEL1_I2C2_RX_REQ       = 0xc
	SYSCTL_DMA_SEL0_DMA_SEL1_I2C2_TX_REQ       = 0xd
	SYSCTL_DMA_SEL0_DMA_SEL1_UART1_RX_REQ      = 0xe
	SYSCTL_DMA_SEL0_DMA_SEL1_UART1_TX_REQ      = 0xf
	SYSCTL_DMA_SEL0_DMA_SEL1_UART2_RX_REQ      = 0x10
	SYSCTL_DMA_SEL0_DMA_SEL1_UART2_TX_REQ      = 0x11
	SYSCTL_DMA_SEL0_DMA_SEL1_UART3_RX_REQ      = 0x12
	SYSCTL_DMA_SEL0_DMA_SEL1_UART3_TX_REQ      = 0x13
	SYSCTL_DMA_SEL0_DMA_SEL1_AES_REQ           = 0x14
	SYSCTL_DMA_SEL0_DMA_SEL1_SHA_RX_REQ        = 0x15
	SYSCTL_DMA_SEL0_DMA_SEL1_AI_RX_REQ         = 0x16
	SYSCTL_DMA_SEL0_DMA_SEL1_FFT_RX_REQ        = 0x17
	SYSCTL_DMA_SEL0_DMA_SEL1_FFT_TX_REQ        = 0x18
	SYSCTL_DMA_SEL0_DMA_SEL1_I2S0_TX_REQ       = 0x19
	SYSCTL_DMA_SEL0_DMA_SEL1_I2S0_RX_REQ       = 0x1a
	SYSCTL_DMA_SEL0_DMA_SEL1_I2S1_TX_REQ       = 0x1b
	SYSCTL_DMA_SEL0_DMA_SEL1_I2S1_RX_REQ       = 0x1c
	SYSCTL_DMA_SEL0_DMA_SEL1_I2S2_TX_REQ       = 0x1d
	SYSCTL_DMA_SEL0_DMA_SEL1_I2S2_RX_REQ       = 0x1e
	SYSCTL_DMA_SEL0_DMA_SEL1_I2S0_BF_DIR_REQ   = 0x1f
	SYSCTL_DMA_SEL0_DMA_SEL1_I2S0_BF_VOICE_REQ = 0x20
	// Position of DMA_SEL2 field.
	SYSCTL_DMA_SEL0_DMA_SEL2_Pos = 0xc
	// Bit mask of DMA_SEL2 field.
	SYSCTL_DMA_SEL0_DMA_SEL2_Msk               = 0x3f000
	SYSCTL_DMA_SEL0_DMA_SEL2_SSI0_RX_REQ       = 0x0
	SYSCTL_DMA_SEL0_DMA_SEL2_SSI0_TX_REQ       = 0x1
	SYSCTL_DMA_SEL0_DMA_SEL2_SSI1_RX_REQ       = 0x2
	SYSCTL_DMA_SEL0_DMA_SEL2_SSI1_TX_REQ       = 0x3
	SYSCTL_DMA_SEL0_DMA_SEL2_SSI2_RX_REQ       = 0x4
	SYSCTL_DMA_SEL0_DMA_SEL2_SSI2_TX_REQ       = 0x5
	SYSCTL_DMA_SEL0_DMA_SEL2_SSI3_RX_REQ       = 0x6
	SYSCTL_DMA_SEL0_DMA_SEL2_SSI3_TX_REQ       = 0x7
	SYSCTL_DMA_SEL0_DMA_SEL2_I2C0_RX_REQ       = 0x8
	SYSCTL_DMA_SEL0_DMA_SEL2_I2C0_TX_REQ       = 0x9
	SYSCTL_DMA_SEL0_DMA_SEL2_I2C1_RX_REQ       = 0xa
	SYSCTL_DMA_SEL0_DMA_SEL2_I2C1_TX_REQ       = 0xb
	SYSCTL_DMA_SEL0_DMA_SEL2_I2C2_RX_REQ       = 0xc
	SYSCTL_DMA_SEL0_DMA_SEL2_I2C2_TX_REQ       = 0xd
	SYSCTL_DMA_SEL0_DMA_SEL2_UART1_RX_REQ      = 0xe
	SYSCTL_DMA_SEL0_DMA_SEL2_UART1_TX_REQ      = 0xf
	SYSCTL_DMA_SEL0_DMA_SEL2_UART2_RX_REQ      = 0x10
	SYSCTL_DMA_SEL0_DMA_SEL2_UART2_TX_REQ      = 0x11
	SYSCTL_DMA_SEL0_DMA_SEL2_UART3_RX_REQ      = 0x12
	SYSCTL_DMA_SEL0_DMA_SEL2_UART3_TX_REQ      = 0x13
	SYSCTL_DMA_SEL0_DMA_SEL2_AES_REQ           = 0x14
	SYSCTL_DMA_SEL0_DMA_SEL2_SHA_RX_REQ        = 0x15
	SYSCTL_DMA_SEL0_DMA_SEL2_AI_RX_REQ         = 0x16
	SYSCTL_DMA_SEL0_DMA_SEL2_FFT_RX_REQ        = 0x17
	SYSCTL_DMA_SEL0_DMA_SEL2_FFT_TX_REQ        = 0x18
	SYSCTL_DMA_SEL0_DMA_SEL2_I2S0_TX_REQ       = 0x19
	SYSCTL_DMA_SEL0_DMA_SEL2_I2S0_RX_REQ       = 0x1a
	SYSCTL_DMA_SEL0_DMA_SEL2_I2S1_TX_REQ       = 0x1b
	SYSCTL_DMA_SEL0_DMA_SEL2_I2S1_RX_REQ       = 0x1c
	SYSCTL_DMA_SEL0_DMA_SEL2_I2S2_TX_REQ       = 0x1d
	SYSCTL_DMA_SEL0_DMA_SEL2_I2S2_RX_REQ       = 0x1e
	SYSCTL_DMA_SEL0_DMA_SEL2_I2S0_BF_DIR_REQ   = 0x1f
	SYSCTL_DMA_SEL0_DMA_SEL2_I2S0_BF_VOICE_REQ = 0x20
	// Position of DMA_SEL3 field.
	SYSCTL_DMA_SEL0_DMA_SEL3_Pos = 0x12
	// Bit mask of DMA_SEL3 field.
	SYSCTL_DMA_SEL0_DMA_SEL3_Msk               = 0xfc0000
	SYSCTL_DMA_SEL0_DMA_SEL3_SSI0_RX_REQ       = 0x0
	SYSCTL_DMA_SEL0_DMA_SEL3_SSI0_TX_REQ       = 0x1
	SYSCTL_DMA_SEL0_DMA_SEL3_SSI1_RX_REQ       = 0x2
	SYSCTL_DMA_SEL0_DMA_SEL3_SSI1_TX_REQ       = 0x3
	SYSCTL_DMA_SEL0_DMA_SEL3_SSI2_RX_REQ       = 0x4
	SYSCTL_DMA_SEL0_DMA_SEL3_SSI2_TX_REQ       = 0x5
	SYSCTL_DMA_SEL0_DMA_SEL3_SSI3_RX_REQ       = 0x6
	SYSCTL_DMA_SEL0_DMA_SEL3_SSI3_TX_REQ       = 0x7
	SYSCTL_DMA_SEL0_DMA_SEL3_I2C0_RX_REQ       = 0x8
	SYSCTL_DMA_SEL0_DMA_SEL3_I2C0_TX_REQ       = 0x9
	SYSCTL_DMA_SEL0_DMA_SEL3_I2C1_RX_REQ       = 0xa
	SYSCTL_DMA_SEL0_DMA_SEL3_I2C1_TX_REQ       = 0xb
	SYSCTL_DMA_SEL0_DMA_SEL3_I2C2_RX_REQ       = 0xc
	SYSCTL_DMA_SEL0_DMA_SEL3_I2C2_TX_REQ       = 0xd
	SYSCTL_DMA_SEL0_DMA_SEL3_UART1_RX_REQ      = 0xe
	SYSCTL_DMA_SEL0_DMA_SEL3_UART1_TX_REQ      = 0xf
	SYSCTL_DMA_SEL0_DMA_SEL3_UART2_RX_REQ      = 0x10
	SYSCTL_DMA_SEL0_DMA_SEL3_UART2_TX_REQ      = 0x11
	SYSCTL_DMA_SEL0_DMA_SEL3_UART3_RX_REQ      = 0x12
	SYSCTL_DMA_SEL0_DMA_SEL3_UART3_TX_REQ      = 0x13
	SYSCTL_DMA_SEL0_DMA_SEL3_AES_REQ           = 0x14
	SYSCTL_DMA_SEL0_DMA_SEL3_SHA_RX_REQ        = 0x15
	SYSCTL_DMA_SEL0_DMA_SEL3_AI_RX_REQ         = 0x16
	SYSCTL_DMA_SEL0_DMA_SEL3_FFT_RX_REQ        = 0x17
	SYSCTL_DMA_SEL0_DMA_SEL3_FFT_TX_REQ        = 0x18
	SYSCTL_DMA_SEL0_DMA_SEL3_I2S0_TX_REQ       = 0x19
	SYSCTL_DMA_SEL0_DMA_SEL3_I2S0_RX_REQ       = 0x1a
	SYSCTL_DMA_SEL0_DMA_SEL3_I2S1_TX_REQ       = 0x1b
	SYSCTL_DMA_SEL0_DMA_SEL3_I2S1_RX_REQ       = 0x1c
	SYSCTL_DMA_SEL0_DMA_SEL3_I2S2_TX_REQ       = 0x1d
	SYSCTL_DMA_SEL0_DMA_SEL3_I2S2_RX_REQ       = 0x1e
	SYSCTL_DMA_SEL0_DMA_SEL3_I2S0_BF_DIR_REQ   = 0x1f
	SYSCTL_DMA_SEL0_DMA_SEL3_I2S0_BF_VOICE_REQ = 0x20
	// Position of DMA_SEL4 field.
	SYSCTL_DMA_SEL0_DMA_SEL4_Pos = 0x18
	// Bit mask of DMA_SEL4 field.
	SYSCTL_DMA_SEL0_DMA_SEL4_Msk               = 0x3f000000
	SYSCTL_DMA_SEL0_DMA_SEL4_SSI0_RX_REQ       = 0x0
	SYSCTL_DMA_SEL0_DMA_SEL4_SSI0_TX_REQ       = 0x1
	SYSCTL_DMA_SEL0_DMA_SEL4_SSI1_RX_REQ       = 0x2
	SYSCTL_DMA_SEL0_DMA_SEL4_SSI1_TX_REQ       = 0x3
	SYSCTL_DMA_SEL0_DMA_SEL4_SSI2_RX_REQ       = 0x4
	SYSCTL_DMA_SEL0_DMA_SEL4_SSI2_TX_REQ       = 0x5
	SYSCTL_DMA_SEL0_DMA_SEL4_SSI3_RX_REQ       = 0x6
	SYSCTL_DMA_SEL0_DMA_SEL4_SSI3_TX_REQ       = 0x7
	SYSCTL_DMA_SEL0_DMA_SEL4_I2C0_RX_REQ       = 0x8
	SYSCTL_DMA_SEL0_DMA_SEL4_I2C0_TX_REQ       = 0x9
	SYSCTL_DMA_SEL0_DMA_SEL4_I2C1_RX_REQ       = 0xa
	SYSCTL_DMA_SEL0_DMA_SEL4_I2C1_TX_REQ       = 0xb
	SYSCTL_DMA_SEL0_DMA_SEL4_I2C2_RX_REQ       = 0xc
	SYSCTL_DMA_SEL0_DMA_SEL4_I2C2_TX_REQ       = 0xd
	SYSCTL_DMA_SEL0_DMA_SEL4_UART1_RX_REQ      = 0xe
	SYSCTL_DMA_SEL0_DMA_SEL4_UART1_TX_REQ      = 0xf
	SYSCTL_DMA_SEL0_DMA_SEL4_UART2_RX_REQ      = 0x10
	SYSCTL_DMA_SEL0_DMA_SEL4_UART2_TX_REQ      = 0x11
	SYSCTL_DMA_SEL0_DMA_SEL4_UART3_RX_REQ      = 0x12
	SYSCTL_DMA_SEL0_DMA_SEL4_UART3_TX_REQ      = 0x13
	SYSCTL_DMA_SEL0_DMA_SEL4_AES_REQ           = 0x14
	SYSCTL_DMA_SEL0_DMA_SEL4_SHA_RX_REQ        = 0x15
	SYSCTL_DMA_SEL0_DMA_SEL4_AI_RX_REQ         = 0x16
	SYSCTL_DMA_SEL0_DMA_SEL4_FFT_RX_REQ        = 0x17
	SYSCTL_DMA_SEL0_DMA_SEL4_FFT_TX_REQ        = 0x18
	SYSCTL_DMA_SEL0_DMA_SEL4_I2S0_TX_REQ       = 0x19
	SYSCTL_DMA_SEL0_DMA_SEL4_I2S0_RX_REQ       = 0x1a
	SYSCTL_DMA_SEL0_DMA_SEL4_I2S1_TX_REQ       = 0x1b
	SYSCTL_DMA_SEL0_DMA_SEL4_I2S1_RX_REQ       = 0x1c
	SYSCTL_DMA_SEL0_DMA_SEL4_I2S2_TX_REQ       = 0x1d
	SYSCTL_DMA_SEL0_DMA_SEL4_I2S2_RX_REQ       = 0x1e
	SYSCTL_DMA_SEL0_DMA_SEL4_I2S0_BF_DIR_REQ   = 0x1f
	SYSCTL_DMA_SEL0_DMA_SEL4_I2S0_BF_VOICE_REQ = 0x20

	// DMA_SEL1: DMA handshake selector
	// Position of DMA_SEL5 field.
	SYSCTL_DMA_SEL1_DMA_SEL5_Pos = 0x0
	// Bit mask of DMA_SEL5 field.
	SYSCTL_DMA_SEL1_DMA_SEL5_Msk = 0x3f

	// POWER_SEL: IO Power Mode Select controller
	// Position of POWER_MODE_SEL0 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL0_Pos = 0x0
	// Bit mask of POWER_MODE_SEL0 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL0_Msk = 0x1
	// Bit POWER_MODE_SEL0.
	SYSCTL_POWER_SEL_POWER_MODE_SEL0 = 0x1
	// Position of POWER_MODE_SEL1 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL1_Pos = 0x1
	// Bit mask of POWER_MODE_SEL1 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL1_Msk = 0x2
	// Bit POWER_MODE_SEL1.
	SYSCTL_POWER_SEL_POWER_MODE_SEL1 = 0x2
	// Position of POWER_MODE_SEL2 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL2_Pos = 0x2
	// Bit mask of POWER_MODE_SEL2 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL2_Msk = 0x4
	// Bit POWER_MODE_SEL2.
	SYSCTL_POWER_SEL_POWER_MODE_SEL2 = 0x4
	// Position of POWER_MODE_SEL3 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL3_Pos = 0x3
	// Bit mask of POWER_MODE_SEL3 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL3_Msk = 0x8
	// Bit POWER_MODE_SEL3.
	SYSCTL_POWER_SEL_POWER_MODE_SEL3 = 0x8
	// Position of POWER_MODE_SEL4 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL4_Pos = 0x4
	// Bit mask of POWER_MODE_SEL4 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL4_Msk = 0x10
	// Bit POWER_MODE_SEL4.
	SYSCTL_POWER_SEL_POWER_MODE_SEL4 = 0x10
	// Position of POWER_MODE_SEL5 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL5_Pos = 0x5
	// Bit mask of POWER_MODE_SEL5 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL5_Msk = 0x20
	// Bit POWER_MODE_SEL5.
	SYSCTL_POWER_SEL_POWER_MODE_SEL5 = 0x20
	// Position of POWER_MODE_SEL6 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL6_Pos = 0x6
	// Bit mask of POWER_MODE_SEL6 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL6_Msk = 0x40
	// Bit POWER_MODE_SEL6.
	SYSCTL_POWER_SEL_POWER_MODE_SEL6 = 0x40
	// Position of POWER_MODE_SEL7 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL7_Pos = 0x7
	// Bit mask of POWER_MODE_SEL7 field.
	SYSCTL_POWER_SEL_POWER_MODE_SEL7_Msk = 0x80
	// Bit POWER_MODE_SEL7.
	SYSCTL_POWER_SEL_POWER_MODE_SEL7 = 0x80
)

// Constants for AES: AES Accelerator
const (
	// ENCRYPT_SEL: Encryption or decryption select
	// Position of ENCRYPT_SEL field.
	AES_ENCRYPT_SEL_ENCRYPT_SEL_Pos = 0x0
	// Bit mask of ENCRYPT_SEL field.
	AES_ENCRYPT_SEL_ENCRYPT_SEL_Msk = 0x1
	// Bit ENCRYPT_SEL.
	AES_ENCRYPT_SEL_ENCRYPT_SEL = 0x1
	// Sets encryption mode
	AES_ENCRYPT_SEL_ENCRYPT_SEL_ENCRYPTION = 0x0
	// Sets decryption mode
	AES_ENCRYPT_SEL_ENCRYPT_SEL_DECRYPTION = 0x1

	// MODE_CTL: AES mode register
	// Position of CIPHER_MODE field.
	AES_MODE_CTL_CIPHER_MODE_Pos = 0x0
	// Bit mask of CIPHER_MODE field.
	AES_MODE_CTL_CIPHER_MODE_Msk = 0x7
	// Electronic Codebook
	AES_MODE_CTL_CIPHER_MODE_ECB = 0x0
	// Cipher Block Chaining
	AES_MODE_CTL_CIPHER_MODE_CBC = 0x1
	// Galois/Counter Mode
	AES_MODE_CTL_CIPHER_MODE_GCM = 0x2
	// Position of KEY_MODE field.
	AES_MODE_CTL_KEY_MODE_Pos = 0x3
	// Bit mask of KEY_MODE field.
	AES_MODE_CTL_KEY_MODE_Msk = 0x18
	// AES-128
	AES_MODE_CTL_KEY_MODE_AES128 = 0x0
	// AES-192
	AES_MODE_CTL_KEY_MODE_AES192 = 0x1
	// AES-256
	AES_MODE_CTL_KEY_MODE_AES256 = 0x2
	// Position of KEY_ORDER field.
	AES_MODE_CTL_KEY_ORDER_Pos = 0x5
	// Bit mask of KEY_ORDER field.
	AES_MODE_CTL_KEY_ORDER_Msk = 0x20
	// Bit KEY_ORDER.
	AES_MODE_CTL_KEY_ORDER = 0x20
	// Big Endian
	AES_MODE_CTL_KEY_ORDER_BE = 0x0
	// Little Endian
	AES_MODE_CTL_KEY_ORDER_LE = 0x1
	// Position of INPUT_ORDER field.
	AES_MODE_CTL_INPUT_ORDER_Pos = 0x7
	// Bit mask of INPUT_ORDER field.
	AES_MODE_CTL_INPUT_ORDER_Msk = 0x80
	// Bit INPUT_ORDER.
	AES_MODE_CTL_INPUT_ORDER = 0x80
	// Big Endian
	AES_MODE_CTL_INPUT_ORDER_BE = 0x0
	// Little Endian
	AES_MODE_CTL_INPUT_ORDER_LE = 0x1
	// Position of OUTPUT_ORDER field.
	AES_MODE_CTL_OUTPUT_ORDER_Pos = 0x9
	// Bit mask of OUTPUT_ORDER field.
	AES_MODE_CTL_OUTPUT_ORDER_Msk = 0x200
	// Bit OUTPUT_ORDER.
	AES_MODE_CTL_OUTPUT_ORDER = 0x200
	// Big Endian
	AES_MODE_CTL_OUTPUT_ORDER_BE = 0x0
	// Little Endian
	AES_MODE_CTL_OUTPUT_ORDER_LE = 0x1

	// ENDIAN: Endian control
	// Position of ENDIAN field.
	AES_ENDIAN_ENDIAN_Pos = 0x0
	// Bit mask of ENDIAN field.
	AES_ENDIAN_ENDIAN_Msk = 0x1
	// Bit ENDIAN.
	AES_ENDIAN_ENDIAN = 0x1

	// FINISH: Finished status
	// Position of FINISH field.
	AES_FINISH_FINISH_Pos = 0x0
	// Bit mask of FINISH field.
	AES_FINISH_FINISH_Msk = 0x1
	// Bit FINISH.
	AES_FINISH_FINISH = 0x1
	// Operation not finished
	AES_FINISH_FINISH_NOT_FINISHED = 0x0
	// Operation finished
	AES_FINISH_FINISH_FINISHED = 0x1

	// DMA_SEL: DMA select
	// Position of DMA_SEL field.
	AES_DMA_SEL_DMA_SEL_Pos = 0x0
	// Bit mask of DMA_SEL field.
	AES_DMA_SEL_DMA_SEL_Msk = 0x1
	// Bit DMA_SEL.
	AES_DMA_SEL_DMA_SEL = 0x1

	// TAG_CHK: Tag check status
	// Position of TAG_CHK field.
	AES_TAG_CHK_TAG_CHK_Pos = 0x0
	// Bit mask of TAG_CHK field.
	AES_TAG_CHK_TAG_CHK_Msk = 0x3
	// Check not finished
	AES_TAG_CHK_TAG_CHK_BUSY = 0x0
	// Check failed
	AES_TAG_CHK_TAG_CHK_FAIL = 0x1
	// Check success
	AES_TAG_CHK_TAG_CHK_SUCCESS = 0x2

	// DATA_IN_FLAG: Data can input flag
	// Position of DATA_IN_FLAG field.
	AES_DATA_IN_FLAG_DATA_IN_FLAG_Pos = 0x0
	// Bit mask of DATA_IN_FLAG field.
	AES_DATA_IN_FLAG_DATA_IN_FLAG_Msk = 0x1
	// Bit DATA_IN_FLAG.
	AES_DATA_IN_FLAG_DATA_IN_FLAG = 0x1
	// Cannot input
	AES_DATA_IN_FLAG_DATA_IN_FLAG_CANNOT_INPUT = 0x0
	// Can input
	AES_DATA_IN_FLAG_DATA_IN_FLAG_CAN_INPUT = 0x1

	// EN: AES module enable
	// Position of EN field.
	AES_EN_EN_Pos = 0x0
	// Bit mask of EN field.
	AES_EN_EN_Msk = 0x1
	// Bit EN.
	AES_EN_EN = 0x1
	// Disable module
	AES_EN_EN_DISABLE = 0x0
	// Enable module
	AES_EN_EN_ENABLE = 0x1

	// DATA_OUT_FLAG: Data can output flag
	// Position of DATA_OUT_FLAG field.
	AES_DATA_OUT_FLAG_DATA_OUT_FLAG_Pos = 0x0
	// Bit mask of DATA_OUT_FLAG field.
	AES_DATA_OUT_FLAG_DATA_OUT_FLAG_Msk = 0x1
	// Bit DATA_OUT_FLAG.
	AES_DATA_OUT_FLAG_DATA_OUT_FLAG = 0x1
	// Data cannot output
	AES_DATA_OUT_FLAG_DATA_OUT_FLAG_CANNOT_OUTPUT = 0x0
	// Data can output
	AES_DATA_OUT_FLAG_DATA_OUT_FLAG_CAN_OUTPUT = 0x1

	// TAG_IN_FLAG: Can input tag (when using GCM)
	// Position of TAG_IN_FLAG field.
	AES_TAG_IN_FLAG_TAG_IN_FLAG_Pos = 0x0
	// Bit mask of TAG_IN_FLAG field.
	AES_TAG_IN_FLAG_TAG_IN_FLAG_Msk = 0x1
	// Bit TAG_IN_FLAG.
	AES_TAG_IN_FLAG_TAG_IN_FLAG = 0x1
)

// Constants for RTC: Real Time Clock
const (
	// DATE: Timer date information
	// Position of WEEK field.
	RTC_DATE_WEEK_Pos = 0x0
	// Bit mask of WEEK field.
	RTC_DATE_WEEK_Msk = 0x7
	// Position of DAY field.
	RTC_DATE_DAY_Pos = 0x8
	// Bit mask of DAY field.
	RTC_DATE_DAY_Msk = 0x1f00
	// Position of MONTH field.
	RTC_DATE_MONTH_Pos = 0x10
	// Bit mask of MONTH field.
	RTC_DATE_MONTH_Msk = 0xf0000
	// Position of YEAR field.
	RTC_DATE_YEAR_Pos = 0x14
	// Bit mask of YEAR field.
	RTC_DATE_YEAR_Msk = 0xfff00000

	// TIME: Timer time information
	// Position of SECOND field.
	RTC_TIME_SECOND_Pos = 0xa
	// Bit mask of SECOND field.
	RTC_TIME_SECOND_Msk = 0xfc00
	// Position of MINUTE field.
	RTC_TIME_MINUTE_Pos = 0x10
	// Bit mask of MINUTE field.
	RTC_TIME_MINUTE_Msk = 0x3f0000
	// Position of HOUR field.
	RTC_TIME_HOUR_Pos = 0x18
	// Bit mask of HOUR field.
	RTC_TIME_HOUR_Msk = 0x1f000000

	// ALARM_DATE: Alarm date information
	// Position of WEEK field.
	RTC_ALARM_DATE_WEEK_Pos = 0x0
	// Bit mask of WEEK field.
	RTC_ALARM_DATE_WEEK_Msk = 0x7
	// Position of DAY field.
	RTC_ALARM_DATE_DAY_Pos = 0x8
	// Bit mask of DAY field.
	RTC_ALARM_DATE_DAY_Msk = 0x1f00
	// Position of MONTH field.
	RTC_ALARM_DATE_MONTH_Pos = 0x10
	// Bit mask of MONTH field.
	RTC_ALARM_DATE_MONTH_Msk = 0xf0000
	// Position of YEAR field.
	RTC_ALARM_DATE_YEAR_Pos = 0x14
	// Bit mask of YEAR field.
	RTC_ALARM_DATE_YEAR_Msk = 0xfff00000

	// ALARM_TIME: Alarm time information
	// Position of SECOND field.
	RTC_ALARM_TIME_SECOND_Pos = 0xa
	// Bit mask of SECOND field.
	RTC_ALARM_TIME_SECOND_Msk = 0xfc00
	// Position of MINUTE field.
	RTC_ALARM_TIME_MINUTE_Pos = 0x10
	// Bit mask of MINUTE field.
	RTC_ALARM_TIME_MINUTE_Msk = 0x3f0000
	// Position of HOUR field.
	RTC_ALARM_TIME_HOUR_Pos = 0x18
	// Bit mask of HOUR field.
	RTC_ALARM_TIME_HOUR_Msk = 0x1f000000

	// INITIAL_COUNT: Timer counter initial value
	// Position of COUNT field.
	RTC_INITIAL_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_INITIAL_COUNT_COUNT_Msk = 0xffffffff

	// CURRENT_COUNT: Timer counter current value
	// Position of COUNT field.
	RTC_CURRENT_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_CURRENT_COUNT_COUNT_Msk = 0xffffffff

	// INTERRUPT_CTRL: RTC interrupt settings
	// Position of TICK_ENABLE field.
	RTC_INTERRUPT_CTRL_TICK_ENABLE_Pos = 0x0
	// Bit mask of TICK_ENABLE field.
	RTC_INTERRUPT_CTRL_TICK_ENABLE_Msk = 0x1
	// Bit TICK_ENABLE.
	RTC_INTERRUPT_CTRL_TICK_ENABLE = 0x1
	// Position of ALARM_ENABLE field.
	RTC_INTERRUPT_CTRL_ALARM_ENABLE_Pos = 0x1
	// Bit mask of ALARM_ENABLE field.
	RTC_INTERRUPT_CTRL_ALARM_ENABLE_Msk = 0x2
	// Bit ALARM_ENABLE.
	RTC_INTERRUPT_CTRL_ALARM_ENABLE = 0x2
	// Position of TICK_INT_MODE field.
	RTC_INTERRUPT_CTRL_TICK_INT_MODE_Pos = 0x2
	// Bit mask of TICK_INT_MODE field.
	RTC_INTERRUPT_CTRL_TICK_INT_MODE_Msk = 0xc
	// Position of ALARM_COMPARE_MASK field.
	RTC_INTERRUPT_CTRL_ALARM_COMPARE_MASK_Pos = 0x18
	// Bit mask of ALARM_COMPARE_MASK field.
	RTC_INTERRUPT_CTRL_ALARM_COMPARE_MASK_Msk = 0xff000000

	// REGISTER_CTRL: RTC register settings
	// Position of READ_ENABLE field.
	RTC_REGISTER_CTRL_READ_ENABLE_Pos = 0x0
	// Bit mask of READ_ENABLE field.
	RTC_REGISTER_CTRL_READ_ENABLE_Msk = 0x1
	// Bit READ_ENABLE.
	RTC_REGISTER_CTRL_READ_ENABLE = 0x1
	// Position of WRITE_ENABLE field.
	RTC_REGISTER_CTRL_WRITE_ENABLE_Pos = 0x1
	// Bit mask of WRITE_ENABLE field.
	RTC_REGISTER_CTRL_WRITE_ENABLE_Msk = 0x2
	// Bit WRITE_ENABLE.
	RTC_REGISTER_CTRL_WRITE_ENABLE = 0x2
	// Position of TIMER_MASK field.
	RTC_REGISTER_CTRL_TIMER_MASK_Pos = 0xd
	// Bit mask of TIMER_MASK field.
	RTC_REGISTER_CTRL_TIMER_MASK_Msk = 0x1fe000
	// Position of ALARM_MASK field.
	RTC_REGISTER_CTRL_ALARM_MASK_Pos = 0x15
	// Bit mask of ALARM_MASK field.
	RTC_REGISTER_CTRL_ALARM_MASK_Msk = 0x1fe00000
	// Position of INITIAL_COUNT_MASK field.
	RTC_REGISTER_CTRL_INITIAL_COUNT_MASK_Pos = 0x1d
	// Bit mask of INITIAL_COUNT_MASK field.
	RTC_REGISTER_CTRL_INITIAL_COUNT_MASK_Msk = 0x20000000
	// Bit INITIAL_COUNT_MASK.
	RTC_REGISTER_CTRL_INITIAL_COUNT_MASK = 0x20000000
	// Position of INTERRUPT_REGISTER_MASK field.
	RTC_REGISTER_CTRL_INTERRUPT_REGISTER_MASK_Pos = 0x1e
	// Bit mask of INTERRUPT_REGISTER_MASK field.
	RTC_REGISTER_CTRL_INTERRUPT_REGISTER_MASK_Msk = 0x40000000
	// Bit INTERRUPT_REGISTER_MASK.
	RTC_REGISTER_CTRL_INTERRUPT_REGISTER_MASK = 0x40000000

	// EXTENDED: Timer extended information
	// Position of CENTURY field.
	RTC_EXTENDED_CENTURY_Pos = 0x0
	// Bit mask of CENTURY field.
	RTC_EXTENDED_CENTURY_Msk = 0x1f
	// Position of LEAP_YEAR field.
	RTC_EXTENDED_LEAP_YEAR_Pos = 0x5
	// Bit mask of LEAP_YEAR field.
	RTC_EXTENDED_LEAP_YEAR_Msk = 0x20
	// Bit LEAP_YEAR.
	RTC_EXTENDED_LEAP_YEAR = 0x20
	// 0 is not leap year
	RTC_EXTENDED_LEAP_YEAR_NOT_LEAP = 0x0
	// 1 is leap year
	RTC_EXTENDED_LEAP_YEAR_LEAP = 0x1
)
