/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.internal;

import java.io.InputStream;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.io.IoExtKt;
import org.luaj.vm2.io.LuaBinInput;
import org.luaj.vm2.io.LuaWriter;
import org.luaj.vm2.io.LuaWriterKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\b2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\u000e2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u0001J\u0012\u0010\u0018\u001a\u00020\u00152\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0001J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0001J\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 J\u001c\u0010!\u001a\u00020\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020 J\u0006\u0010(\u001a\u00020\u001cJ\u001c\u0010)\u001a\u0004\u0018\u00010\u00152\u0006\u0010*\u001a\u00020\u00152\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0015J\u0006\u0010,\u001a\u00020 R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lorg/luaj/vm2/internal/JSystem;", "", "()V", "err", "Lorg/luaj/vm2/io/LuaWriter;", "getErr", "()Lorg/luaj/vm2/io/LuaWriter;", "in", "Lorg/luaj/vm2/io/LuaBinInput;", "getIn", "()Lorg/luaj/vm2/io/LuaBinInput;", "out", "getOut", "supportStatic", "", "getSupportStatic", "()Z", "Class_getResourceAsStreamPortable", "clazz", "Lkotlin/reflect/KClass;", "res", "", "Class_isInstancePortable", "ins", "Class_portableName", "InstantiateClassByName", "name", "Object_notify", "", "obj", "Object_wait", "time", "", "StartNativeThread", "runnable", "Lkotlin/Function0;", "exit", "code", "", "freeMemory", "gc", "getProperty", "key", "def", "totalMemory", "luak"})
public final class JSystem {
    @NotNull
    public static final JSystem INSTANCE = new JSystem();
    private static final boolean supportStatic = true;

    private JSystem() {
    }

    @NotNull
    public final LuaWriter getOut() {
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue(printStream, "out");
        return LuaWriterKt.toWriter$default(IoExtKt.toLua(printStream), null, 1, null);
    }

    @NotNull
    public final LuaWriter getErr() {
        PrintStream printStream = System.err;
        Intrinsics.checkNotNullExpressionValue(printStream, "err");
        return LuaWriterKt.toWriter$default(IoExtKt.toLua(printStream), null, 1, null);
    }

    @NotNull
    public final LuaBinInput getIn() {
        InputStream inputStream = System.in;
        Intrinsics.checkNotNullExpressionValue(inputStream, "`in`");
        return IoExtKt.toLua(inputStream);
    }

    public final void exit(int code) {
        System.exit(code);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    @Nullable
    public final String getProperty(@NotNull String key, @Nullable String def) {
        Intrinsics.checkNotNullParameter(key, "key");
        return System.getProperty(key, def);
    }

    public static /* synthetic */ String getProperty$default(JSystem jSystem, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return jSystem.getProperty(string, string2);
    }

    public final void gc() {
        System.gc();
    }

    public final long totalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public final long freeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    @Nullable
    public final Object InstantiateClassByName(@NotNull String name) {
        Object var2_2;
        Intrinsics.checkNotNullParameter(name, "name");
        try {
            var2_2 = Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException e) {
            var2_2 = null;
        }
        return var2_2;
    }

    public final void StartNativeThread(@NotNull Function0<Unit> runnable, @NotNull String name) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        Intrinsics.checkNotNullParameter(name, "name");
        new Thread(() -> JSystem.StartNativeThread$lambda-0(runnable), name).start();
    }

    public final void Object_notify(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        obj.notify();
    }

    public final void Object_wait(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        obj.wait();
    }

    public final void Object_wait(@NotNull Object obj, long time) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        obj.wait(time);
    }

    @NotNull
    public final String Class_portableName(@NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        String string = JvmClassMappingKt.getJavaClass(clazz).getName();
        Intrinsics.checkNotNullExpressionValue(string, "clazz.java.name");
        return string;
    }

    public final boolean Class_isInstancePortable(@NotNull KClass<?> clazz, @NotNull Object ins) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(ins, "ins");
        return JvmClassMappingKt.getJavaClass(clazz).isAssignableFrom(ins.getClass());
    }

    @Nullable
    public final LuaBinInput Class_getResourceAsStreamPortable(@NotNull KClass<?> clazz, @NotNull String res) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(res, "res");
        InputStream inputStream = JvmClassMappingKt.getJavaClass(clazz).getResourceAsStream(res);
        return inputStream == null ? null : IoExtKt.toLua(inputStream);
    }

    public final boolean getSupportStatic() {
        return supportStatic;
    }

    private static final void StartNativeThread$lambda-0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke();
    }
}

