/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UserNumber;

public class IntegerContentCommand
extends TextualContentCommand
implements TeXNumber {
    public IntegerContentCommand(String string, int n) {
        this(string, "" + n, new UserNumber(n));
    }

    protected IntegerContentCommand(String string, String string2, UserNumber userNumber) {
        super(string, string2, userNumber);
    }

    @Override
    public Object clone() {
        return new IntegerContentCommand(this.getName(), this.getText(), this.getNumber());
    }

    @Override
    public TextualContentCommand duplicate(String string) {
        TextualContentCommand textualContentCommand = (TextualContentCommand)this.clone();
        textualContentCommand.name = string;
        textualContentCommand.data = new UserNumber(this.getValue());
        return textualContentCommand;
    }

    @Override
    public int getValue() {
        return this.getNumber().getValue();
    }

    public void setValue(int n) {
        this.text = "" + n;
        this.getNumber().setValue(n);
    }

    public UserNumber getNumber() {
        return (UserNumber)this.data;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.getNumber().number(teXParser);
    }

    @Override
    public void multiply(int n) {
        this.getNumber().multiply(n);
        this.text = "" + this.getValue();
    }

    @Override
    public void divide(int n) {
        this.getNumber().divide(n);
        this.text = "" + this.getValue();
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.getNumber().advance(teXParser, numerical);
        this.text = "" + this.getValue();
    }
}

