'''OpenGL extension EXT.draw_buffers

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.draw_buffers to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension increases the number of available framebuffer object
	color attachment points, extends OpenGL ES 2.0 to allow multiple output
	colors, and provides a mechanism for directing those outputs to
	multiple color buffers.
	
	This extension is similar to the combination of the GL_NV_draw_buffers
	and GL_NV_fbo_color_attachments extensions, but imposes certain
	restrictions informed by the OpenGL ES 3.0 API.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/draw_buffers.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.draw_buffers import *
from OpenGL.raw.GLES2.EXT.draw_buffers import _EXTENSION_NAME

def glInitDrawBuffersEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glDrawBuffersEXT.bufs size not checked against n
glDrawBuffersEXT=wrapper.wrapper(glDrawBuffersEXT).setInputArraySize(
    'bufs', None
)
### END AUTOGENERATED SECTION
from OpenGL.lazywrapper import lazy as _lazy

@_lazy( glDrawBuffers )
def glDrawBuffers( baseOperation, n=None, bufs=None ):
    """glDrawBuffers( bufs ) -> bufs

    Wrapper will calculate n from dims of bufs if only
    one argument is provided...
    """
    if bufs is None:
        bufs = n
        n = None
    bufs = arrays.GLenumArray.asArray( bufs )
    if n is None:
        n = arrays.GLenumArray.arraySize( bufs )
    return baseOperation( n,bufs )
