/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.metrics.OWLMetric;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class AbstractOWLMetric<M extends Serializable>
implements OWLMetric<M>,
OWLOntologyChangeListener {
    @Nonnull
    private OWLOntology ontology;
    private boolean dirty;
    private boolean importsClosureUsed;
    private M value;

    public AbstractOWLMetric(@Nonnull OWLOntology o) {
        this.ontology = OWLAPIPreconditions.checkNotNull(o, "o cannot be null");
        this.ontology.getOWLOntologyManager().addOntologyChangeListener(this);
        this.dirty = true;
    }

    @Override
    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Override
    public void setOntology(OWLOntology ontology) {
        this.ontology.getOWLOntologyManager().removeOntologyChangeListener(this);
        this.ontology = ontology;
        this.ontology.getOWLOntologyManager().addOntologyChangeListener(this);
        this.setDirty(true);
    }

    @Nonnull
    protected abstract M recomputeMetric();

    @Override
    public M getValue() {
        if (this.dirty) {
            this.value = this.recomputeMetric();
        }
        return (M)((Serializable)OWLAPIPreconditions.verifyNotNull(this.value));
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Nonnull
    public Set<OWLOntology> getOntologies() {
        if (this.importsClosureUsed) {
            return this.ontology.getImportsClosure();
        }
        return CollectionFactory.createSet(this.ontology);
    }

    @Override
    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        if (this.isMetricInvalidated(changes)) {
            this.setDirty(true);
        }
    }

    @Override
    public OWLOntologyManager getManager() {
        return this.ontology.getOWLOntologyManager();
    }

    @Override
    public void dispose() {
        this.ontology.getOWLOntologyManager().removeOntologyChangeListener(this);
        this.disposeMetric();
    }

    @Override
    public boolean isImportsClosureUsed() {
        return this.importsClosureUsed;
    }

    @Override
    public void setImportsClosureUsed(boolean b) {
        this.importsClosureUsed = b;
        this.recomputeMetric();
    }

    protected abstract boolean isMetricInvalidated(@Nonnull List<? extends OWLOntologyChange> var1);

    protected abstract void disposeMetric();

    @Nonnull
    public String toString() {
        return this.getName() + ": " + this.getValue();
    }
}

