/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.LineLocationImpl;
import net.sourceforge.plantuml.utils.Log;

public class ReadLineReader
implements ReadLine {
    private final BufferedReader br;
    private LineLocationImpl location;
    private final String description;

    private ReadLineReader(Reader reader, String description, LineLocation parent) {
        if (description == null) {
            description = "?";
        }
        this.br = new BufferedReader(reader);
        this.location = new LineLocationImpl(description, parent);
        this.description = description;
        Log.info("Reading from " + description);
    }

    public String toString() {
        return super.toString() + " " + this.description;
    }

    private ReadLineReader(Reader reader, String desc) {
        this(reader, desc, null);
    }

    public static ReadLine create(Reader reader, String description) {
        return new ReadLineReader(reader, description, null);
    }

    public static ReadLine create(Reader reader, String description, LineLocation parent) {
        return new ReadLineReader(reader, description, parent);
    }

    @Override
    public StringLocated readLine() throws IOException {
        String s2 = this.br.readLine();
        this.location = this.location.oneLineRead();
        if (s2 == null) {
            return null;
        }
        if (s2.startsWith("\ufeff")) {
            s2 = s2.substring(1);
        }
        s2 = s2.replace('\u2013', '-');
        return new StringLocated(s2, this.location);
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }
}

