/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.functions.implementation;

import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.TableFunctionImplementation;
import org.opensearch.sql.spark.client.SparkClient;
import org.opensearch.sql.spark.request.SparkQueryRequest;
import org.opensearch.sql.spark.storage.SparkTable;
import org.opensearch.sql.storage.Table;

public class SparkSqlFunctionImplementation
extends FunctionExpression
implements TableFunctionImplementation {
    private final FunctionName functionName;
    private final List<Expression> arguments;
    private final SparkClient sparkClient;

    public SparkSqlFunctionImplementation(FunctionName functionName, List<Expression> arguments, SparkClient sparkClient) {
        super(functionName, arguments);
        this.functionName = functionName;
        this.arguments = arguments;
        this.sparkClient = sparkClient;
    }

    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        throw new UnsupportedOperationException(String.format("Spark defined function [%s] is only supported in SOURCE clause with spark connector catalog", this.functionName));
    }

    public ExprType type() {
        return ExprCoreType.STRUCT;
    }

    public String toString() {
        List args = this.arguments.stream().map(arg -> String.format("%s=%s", ((NamedArgumentExpression)arg).getArgName(), ((NamedArgumentExpression)arg).getValue().toString())).collect(Collectors.toList());
        return String.format("%s(%s)", this.functionName, String.join((CharSequence)", ", args));
    }

    public Table applyArguments() {
        return new SparkTable(this.sparkClient, this.buildQueryFromSqlFunction(this.arguments));
    }

    private SparkQueryRequest buildQueryFromSqlFunction(List<Expression> arguments) {
        SparkQueryRequest sparkQueryRequest = new SparkQueryRequest();
        arguments.forEach(arg -> {
            String argName = ((NamedArgumentExpression)arg).getArgName();
            Expression argValue = ((NamedArgumentExpression)arg).getValue();
            ExprValue literalValue = argValue.valueOf();
            if (!argName.equals("query")) {
                throw new ExpressionEvaluationException(String.format("Invalid Function Argument:%s", argName));
            }
            sparkQueryRequest.setSql((String)literalValue.value());
        });
        return sparkQueryRequest;
    }
}

