/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.securityconf.ConfigModel;
import org.opensearch.security.securityconf.SecurityRoles;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class RestLayerPrivilegesEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final ClusterService clusterService;
    private ThreadContext threadContext;
    private ConfigModel configModel;

    public RestLayerPrivilegesEvaluator(ClusterService clusterService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.threadContext = threadPool.getThreadContext();
    }

    @Subscribe
    public void onConfigModelChanged(ConfigModel configModel) {
        this.configModel = configModel;
    }

    SecurityRoles getSecurityRoles(Set<String> roles) {
        return this.configModel.getSecurityRoles().filter(roles);
    }

    boolean isInitialized() {
        return this.configModel != null && this.configModel.getSecurityRoles() != null;
    }

    public PrivilegesEvaluatorResponse evaluate(User user, Set<String> actions) {
        if (!this.isInitialized()) {
            throw new OpenSearchSecurityException("OpenSearch Security is not initialized.", new Object[0]);
        }
        PrivilegesEvaluatorResponse presponse = new PrivilegesEvaluatorResponse();
        TransportAddress caller = (TransportAddress)this.threadContext.getTransient("_opendistro_security_remote_address");
        Set<String> mappedRoles = this.mapRoles(user, caller);
        presponse.resolvedSecurityRoles.addAll(mappedRoles);
        SecurityRoles securityRoles = this.getSecurityRoles(mappedRoles);
        boolean isDebugEnabled = this.log.isDebugEnabled();
        if (isDebugEnabled) {
            this.log.debug("Evaluate permissions for {} on {}", (Object)user, (Object)this.clusterService.localNode().getName());
            this.log.debug("Action: {}", actions);
            this.log.debug("Mapped roles: {}", (Object)mappedRoles.toString());
        }
        for (String action : actions) {
            if (!securityRoles.impliesClusterPermissionPermission(action)) {
                presponse.missingPrivileges.add(action);
                presponse.allowed = false;
                this.log.info("No permission match for {} [Action [{}]] [RolesChecked {}]. No permissions for {}", (Object)user, (Object)action, securityRoles.getRoleNames(), presponse.missingPrivileges);
                continue;
            }
            if (isDebugEnabled) {
                this.log.debug("Allowed because we have permissions for {}", actions);
            }
            presponse.allowed = true;
            break;
        }
        return presponse;
    }

    Set<String> mapRoles(User user, TransportAddress caller) {
        return this.configModel.mapSecurityRoles(user, caller);
    }
}

