/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.send;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.commons.notifications.model.ChannelMessage;
import org.opensearch.commons.notifications.model.EventSource;
import org.opensearch.commons.notifications.model.SeverityType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/opensearch/notifications/send/SendTestNotificationActionHelper;", "", "()V", "generateEventSource", "Lorg/opensearch/commons/notifications/model/EventSource;", "configId", "", "generateMessage", "Lorg/opensearch/commons/notifications/model/ChannelMessage;", "getMessageHtmlDescription", "getMessageTextDescription", "getMessageTitle", "opensearch-notifications"})
public final class SendTestNotificationActionHelper {
    @NotNull
    public static final SendTestNotificationActionHelper INSTANCE = new SendTestNotificationActionHelper();

    private SendTestNotificationActionHelper() {
    }

    @NotNull
    public final ChannelMessage generateMessage(@NotNull String configId) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        return new ChannelMessage(this.getMessageTextDescription(configId), this.getMessageHtmlDescription(configId), null);
    }

    @NotNull
    public final EventSource generateEventSource(@NotNull String configId) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        return new EventSource(this.getMessageTitle(configId), configId, SeverityType.INFO, null, 8, null);
    }

    private final String getMessageTitle(String configId) {
        return "Test Message Title-" + configId;
    }

    private final String getMessageTextDescription(String configId) {
        return "Test message content body for config id " + configId;
    }

    private final String getMessageHtmlDescription(String configId) {
        return StringsKt.trimIndent((String)("\n            <html>\n            <header><title>Test Message</title></header>\n            <body>\n            <p>Test Message for config id " + configId + "</p>\n            </body>\n            </html>\n        "));
    }
}

