/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.combination;

import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationTechnique;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationUtil;

public class GeometricMeanScoreCombinationTechnique
implements ScoreCombinationTechnique {
    public static final String TECHNIQUE_NAME = "geometric_mean";
    public static final String PARAM_NAME_WEIGHTS = "weights";
    private static final Set<String> SUPPORTED_PARAMS = Set.of("weights");
    private static final Float ZERO_SCORE = Float.valueOf(0.0f);
    private final List<Float> weights;
    private final ScoreCombinationUtil scoreCombinationUtil;

    public GeometricMeanScoreCombinationTechnique(Map<String, Object> params, ScoreCombinationUtil combinationUtil) {
        this.scoreCombinationUtil = combinationUtil;
        this.scoreCombinationUtil.validateParams(params, SUPPORTED_PARAMS);
        this.weights = this.scoreCombinationUtil.getWeights(params);
    }

    @Override
    public float combine(float[] scores) {
        this.scoreCombinationUtil.validateIfWeightsMatchScores(scores, this.weights);
        float weightedLnSum = 0.0f;
        float sumOfWeights = 0.0f;
        for (int indexOfSubQuery = 0; indexOfSubQuery < scores.length; ++indexOfSubQuery) {
            float score = scores[indexOfSubQuery];
            if (score <= 0.0f) continue;
            float weight = this.scoreCombinationUtil.getWeightForSubQuery(this.weights, indexOfSubQuery);
            sumOfWeights += weight;
            weightedLnSum = (float)((double)weightedLnSum + (double)weight * Math.log(score));
        }
        return sumOfWeights == 0.0f ? ZERO_SCORE.floatValue() : (float)Math.exp(weightedLnSum / sumOfWeights);
    }

    @Generated
    public String toString() {
        return "GeometricMeanScoreCombinationTechnique(TECHNIQUE_NAME=geometric_mean)";
    }
}

