/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.jobs;

import com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.jobs.MLJobParameter;
import org.opensearch.ml.jobs.processors.MLBatchTaskUpdateProcessor;
import org.opensearch.ml.jobs.processors.MLStatsJobProcessor;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class MLJobRunner
implements ScheduledJobRunner {
    @Generated
    private static final Logger log = LogManager.getLogger(MLJobRunner.class);
    private static MLJobRunner instance;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Client client;
    private SdkClient sdkClient;
    private ConnectorAccessControlHelper connectorAccessControlHelper;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLJobRunner getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<MLJobRunner> clazz = MLJobRunner.class;
        synchronized (MLJobRunner.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            instance = new MLJobRunner();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    MLJobRunner() {
    }

    public void initialize(ClusterService clusterService, ThreadPool threadPool, Client client, SdkClient sdkClient, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.sdkClient = sdkClient;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.initialized = true;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public void runJob(ScheduledJobParameter scheduledJobParameter, JobExecutionContext jobExecutionContext) {
        if (!this.initialized) {
            throw new IllegalStateException("MLJobRunner Instance not initialized");
        }
        MLJobParameter jobParameter = (MLJobParameter)scheduledJobParameter;
        if (jobParameter == null || jobParameter.getJobType() == null) {
            throw new IllegalArgumentException("Job parameters is invalid.");
        }
        switch (jobParameter.getJobType()) {
            case STATS_COLLECTOR: {
                MLStatsJobProcessor.getInstance(this.clusterService, this.client, this.threadPool, this.connectorAccessControlHelper, this.sdkClient).process(jobParameter, jobExecutionContext, this.mlFeatureEnabledSetting.isStaticMetricCollectionEnabled());
                break;
            }
            case BATCH_TASK_UPDATE: {
                MLBatchTaskUpdateProcessor.getInstance(this.clusterService, this.client, this.threadPool).process(jobParameter, jobExecutionContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported job type " + String.valueOf((Object)jobParameter.getJobType()));
            }
        }
    }

    @Generated
    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Generated
    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setSdkClient(SdkClient sdkClient) {
        this.sdkClient = sdkClient;
    }

    @Generated
    public void setConnectorAccessControlHelper(ConnectorAccessControlHelper connectorAccessControlHelper) {
        this.connectorAccessControlHelper = connectorAccessControlHelper;
    }

    @Generated
    public void setMlFeatureEnabledSetting(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }
}

