/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.agent;

import com.google.common.annotations.VisibleForTesting;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import joptsimple.internal.Strings;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.StepListener;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.agent.LLMSpec;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.agent.MLToolSpec;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.execute.agent.AgentMLInput;
import org.opensearch.ml.common.input.remote.RemoteInferenceMLInput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.memory.Memory;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskAction;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskRequest;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.common.utils.MLTaskUtils;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.algorithms.agent.AgentUtils;
import org.opensearch.ml.engine.algorithms.agent.MLAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLChatAgentRunner;
import org.opensearch.ml.engine.encryptor.Encryptor;
import org.opensearch.ml.engine.memory.ConversationIndexMemory;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.transport.client.Client;

public class MLPlanExecuteAndReflectAgentRunner
implements MLAgentRunner {
    @Generated
    private static final Logger log = LogManager.getLogger(MLPlanExecuteAndReflectAgentRunner.class);
    private final Client client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final Map<String, Tool.Factory> toolFactories;
    private final Map<String, Memory.Factory> memoryFactoryMap;
    private SdkClient sdkClient;
    private Encryptor encryptor;
    private boolean taskUpdated = false;
    private final Map<String, Object> taskUpdates = new HashMap<String, Object>();
    private String plannerPrompt;
    private String plannerPromptTemplate;
    private String reflectPrompt;
    private String reflectPromptTemplate;
    private String plannerWithHistoryPromptTemplate;
    private static final String DEFAULT_PLANNER_SYSTEM_PROMPT = "You are part of an OpenSearch cluster. When you deliver your final result, include a comprehensive report. This report MUST:\\n1. List every analysis or step you performed.\\n2. Summarize the inputs, methods, tools, and data used at each step.\\n3. Include key findings from all intermediate steps \u2014 do NOT omit them.\\n4. Clearly explain how the steps led to your final conclusion.\\n5. Return the full analysis and conclusion in the 'result' field, even if some of this was mentioned earlier.\\n\\nThe final response should be fully self-contained and detailed, allowing a user to understand the full investigation without needing to reference prior messages. Always respond in JSON format.";
    private static final String DEFAULT_EXECUTOR_SYSTEM_PROMPT = "You are a dedicated helper agent working as part of a plan\u2011execute\u2011reflect framework. Your role is to receive a discrete task, execute all necessary internal reasoning or tool calls, and return a single, final response that fully addresses the task. You must never return an empty response. If you are unable to complete the task or retrieve meaningful information, you must respond with a clear explanation of the issue or what was missing. Under no circumstances should you end your reply with a question or ask for more information. If you search any index, always include the raw documents in the final result instead of summarizing the content. This is critical to give visibility into what the query retrieved.";
    private static final String DEFAULT_NO_ESCAPE_PARAMS = "tool_configs,_tools";
    private static final String DEFAULT_MAX_STEPS_EXECUTED = "20";
    private static final int DEFAULT_MESSAGE_HISTORY_LIMIT = 10;
    private static final String DEFAULT_REACT_MAX_ITERATIONS = "20";
    public static final String PROMPT_FIELD = "prompt";
    public static final String USER_PROMPT_FIELD = "user_prompt";
    public static final String EXECUTOR_SYSTEM_PROMPT_FIELD = "executor_system_prompt";
    public static final String STEPS_FIELD = "steps";
    public static final String COMPLETED_STEPS_FIELD = "completed_steps";
    public static final String PLANNER_PROMPT_FIELD = "planner_prompt";
    public static final String REFLECT_PROMPT_FIELD = "reflect_prompt";
    public static final String PLAN_EXECUTE_REFLECT_RESPONSE_FORMAT_FIELD = "plan_execute_reflect_response_format";
    public static final String PROMPT_TEMPLATE_FIELD = "prompt_template";
    public static final String SYSTEM_PROMPT_FIELD = "system_prompt";
    public static final String QUESTION_FIELD = "question";
    public static final String MEMORY_ID_FIELD = "memory_id";
    public static final String PARENT_INTERACTION_ID_FIELD = "parent_interaction_id";
    public static final String TENANT_ID_FIELD = "tenant_id";
    public static final String RESULT_FIELD = "result";
    public static final String RESPONSE_FIELD = "response";
    public static final String STEP_RESULT_FIELD = "step_result";
    public static final String EXECUTOR_AGENT_ID_FIELD = "executor_agent_id";
    public static final String EXECUTOR_AGENT_MEMORY_ID_FIELD = "executor_agent_memory_id";
    public static final String EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD = "executor_agent_parent_interaction_id";
    public static final String NO_ESCAPE_PARAMS_FIELD = "no_escape_params";
    public static final String DEFAULT_PROMPT_TOOLS_FIELD = "tools_prompt";
    public static final String MAX_STEPS_EXECUTED_FIELD = "max_steps";
    public static final String PLANNER_PROMPT_TEMPLATE_FIELD = "planner_prompt_template";
    public static final String REFLECT_PROMPT_TEMPLATE_FIELD = "reflect_prompt_template";
    public static final String PLANNER_WITH_HISTORY_TEMPLATE_FIELD = "planner_with_history_template";
    public static final String EXECUTOR_MAX_ITERATIONS_FIELD = "executor_max_iterations";

    public MLPlanExecuteAndReflectAgentRunner(Client client, Settings settings, ClusterService clusterService, NamedXContentRegistry registry, Map<String, Tool.Factory> toolFactories, Map<String, Memory.Factory> memoryFactoryMap, SdkClient sdkClient, Encryptor encryptor) {
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = registry;
        this.toolFactories = toolFactories;
        this.memoryFactoryMap = memoryFactoryMap;
        this.sdkClient = sdkClient;
        this.encryptor = encryptor;
        this.plannerPrompt = "For the given objective, come up with a simple step by step plan. This plan should involve individual tasks, that if executed correctly will yield the correct answer. Do not add any superfluous steps. The result of the final step should be the final answer. Make sure that each step has all the information needed - do not skip steps. At all costs, do not execute the steps. You will be told when to execute the steps.";
        this.plannerPromptTemplate = "${parameters.planner_prompt} \nObjective: ${parameters.user_prompt} \n\n${parameters.plan_execute_reflect_response_format}";
        this.reflectPrompt = "Update your plan accordingly. If no more steps are needed and you can return to the user, then respond with that. Otherwise, fill out the plan. Only add steps to the plan that still NEED to be done. Do not return previously done steps as part of the plan. Please follow the below response format.";
        this.reflectPromptTemplate = "${parameters.planner_prompt} \n\nObjective: ${parameters.user_prompt} \n\nOriginal plan:\n[${parameters.steps}] \n\nYou have currently executed the following steps: \n[${parameters.completed_steps}] \n\n${parameters.reflect_prompt} \n\n${parameters.plan_execute_reflect_response_format}";
        this.plannerWithHistoryPromptTemplate = "${parameters.planner_prompt} \nObjective: ${parameters.user_prompt} \n\nYou have currently executed the following steps: \n[${parameters.completed_steps}] \n\n${parameters.plan_execute_reflect_response_format}";
    }

    @VisibleForTesting
    void setupPromptParameters(Map<String, String> params) {
        params.remove(PROMPT_FIELD);
        String userPrompt = params.get(QUESTION_FIELD);
        params.put(USER_PROMPT_FIELD, userPrompt);
        params.put(SYSTEM_PROMPT_FIELD, params.getOrDefault(SYSTEM_PROMPT_FIELD, DEFAULT_PLANNER_SYSTEM_PROMPT));
        if (params.get(PLANNER_PROMPT_FIELD) != null) {
            this.plannerPrompt = params.get(PLANNER_PROMPT_FIELD);
        }
        params.put(PLANNER_PROMPT_FIELD, this.plannerPrompt);
        if (params.get(PLANNER_PROMPT_TEMPLATE_FIELD) != null) {
            this.plannerPromptTemplate = params.get(PLANNER_PROMPT_TEMPLATE_FIELD);
        }
        if (params.get(REFLECT_PROMPT_FIELD) != null) {
            this.reflectPrompt = params.get(REFLECT_PROMPT_FIELD);
        }
        params.put(REFLECT_PROMPT_FIELD, this.reflectPrompt);
        if (params.get(REFLECT_PROMPT_TEMPLATE_FIELD) != null) {
            this.reflectPromptTemplate = params.get(REFLECT_PROMPT_TEMPLATE_FIELD);
        }
        if (params.get(PLANNER_WITH_HISTORY_TEMPLATE_FIELD) != null) {
            this.plannerWithHistoryPromptTemplate = params.get(PLANNER_WITH_HISTORY_TEMPLATE_FIELD);
        }
        params.put(PLAN_EXECUTE_REFLECT_RESPONSE_FORMAT_FIELD, "${parameters.tools_prompt:-} \nResponse Instructions: \nALWAYS follow the given response instructions. Do not return any content that does not follow the response instructions. Do not add anything before or after the expected JSON \nAlways respond with a valid JSON object that strictly follows the below schema:\n{\n\t\"steps\": array[string], \n\t\"result\": string \n}\nUse \"steps\" to return an array of strings where each string is a step to complete the objective, leave it empty if you know the final result. Please wrap each step in quotes and escape any special characters within the string. \nUse \"result\" return the final response when you have enough information, leave it empty if you want to execute more steps \nHere are examples of valid responses:\n\nExample 1 - When you need to execute steps:\n{\n\t\"steps\": [\"Search for logs containing error messages in the last hour\", \"Analyze the frequency of each error type\", \"Check system metrics during error spikes\"],\n\t\"result\": \"\"\n}\n\nExample 2 - When you have the final result:\n{\n\t\"steps\": [],\n\t\"result\": \"Based on the analysis, the root cause of the system slowdown was a memory leak in the authentication service, which started at 14:30 UTC.\"\n}\nIMPORTANT RULES:\n1. DO NOT use commas within individual steps \n2. DO NOT add any content before or after the JSON \n3. ONLY respond with a pure JSON object \n4. DO NOT USE ANY TOOLS. TOOLS ARE PROVIDED ONLY FOR YOU TO MAKE A PLAN.");
        params.put(NO_ESCAPE_PARAMS_FIELD, DEFAULT_NO_ESCAPE_PARAMS);
        if (params.containsKey("_llm_interface") && (!params.containsKey("llm_response_filter") || params.get("llm_response_filter").isEmpty())) {
            String llmInterface = params.get("_llm_interface");
            String llmResponseFilter = switch (llmInterface.trim().toLowerCase(Locale.ROOT)) {
                case "bedrock/converse/claude", "bedrock/converse/deepseek_r1" -> "$.output.message.content[0].text";
                case "openai/v1/chat/completions" -> "$.choices[0].message.content";
                default -> throw new MLException(String.format("Unsupported llm interface: %s", llmInterface));
            };
            params.put("llm_response_filter", llmResponseFilter);
        }
    }

    @VisibleForTesting
    void usePlannerPromptTemplate(Map<String, String> params) {
        params.put(PROMPT_TEMPLATE_FIELD, this.plannerPromptTemplate);
        this.populatePrompt(params);
    }

    @VisibleForTesting
    void useReflectPromptTemplate(Map<String, String> params) {
        params.put(PROMPT_TEMPLATE_FIELD, this.reflectPromptTemplate);
        this.populatePrompt(params);
    }

    @VisibleForTesting
    void usePlannerWithHistoryPromptTemplate(Map<String, String> params) {
        params.put(PROMPT_TEMPLATE_FIELD, this.plannerWithHistoryPromptTemplate);
        this.populatePrompt(params);
    }

    @VisibleForTesting
    void populatePrompt(Map<String, String> allParams) {
        String promptTemplate = allParams.get(PROMPT_TEMPLATE_FIELD);
        StringSubstitutor promptSubstitutor = new StringSubstitutor(allParams, "${parameters.", "}");
        String prompt = promptSubstitutor.replace(promptTemplate);
        allParams.put(PROMPT_FIELD, prompt);
    }

    @Override
    public void run(MLAgent mlAgent, Map<String, String> apiParams, ActionListener<Object> listener) {
        HashMap<String, String> allParams = new HashMap<String, String>();
        allParams.putAll(apiParams);
        allParams.putAll(mlAgent.getParameters());
        this.setupPromptParameters(allParams);
        this.usePlannerPromptTemplate(allParams);
        String memoryId = (String)allParams.get(MEMORY_ID_FIELD);
        String memoryType = mlAgent.getMemory().getType();
        String appType = mlAgent.getAppType();
        int messageHistoryLimit = 10;
        ConversationIndexMemory.Factory conversationIndexMemoryFactory = (ConversationIndexMemory.Factory)this.memoryFactoryMap.get(memoryType);
        conversationIndexMemoryFactory.create(apiParams.get(USER_PROMPT_FIELD), memoryId, appType, (ActionListener<ConversationIndexMemory>)ActionListener.wrap(memory -> memory.getMessages(ActionListener.wrap(interactions -> {
            ArrayList<String> completedSteps = new ArrayList<String>();
            for (Interaction interaction : interactions) {
                String question = interaction.getInput();
                String response = interaction.getResponse();
                if (Strings.isNullOrEmpty((String)response)) continue;
                completedSteps.add(question);
                completedSteps.add(response);
            }
            if (!completedSteps.isEmpty()) {
                this.addSteps(completedSteps, allParams, COMPLETED_STEPS_FIELD);
                this.usePlannerWithHistoryPromptTemplate(allParams);
            }
            this.setToolsAndRunAgent(mlAgent, (Map<String, String>)allParams, (List<String>)completedSteps, (Memory)memory, memory.getConversationId(), listener);
        }, e -> {
            log.error("Failed to get chat history", (Throwable)e);
            listener.onFailure(e);
        }), messageHistoryLimit), arg_0 -> listener.onFailure(arg_0)));
    }

    private void setToolsAndRunAgent(MLAgent mlAgent, Map<String, String> allParams, List<String> completedSteps, Memory memory, String conversationId, ActionListener<Object> finalListener) {
        List<MLToolSpec> toolSpecs = AgentUtils.getMlToolSpecs(mlAgent, allParams);
        Consumer<List> processTools = allToolSpecs -> {
            HashMap<String, Tool> tools = new HashMap<String, Tool>();
            HashMap<String, MLToolSpec> toolSpecMap = new HashMap<String, MLToolSpec>();
            AgentUtils.createTools(this.toolFactories, allParams, allToolSpecs, tools, toolSpecMap, mlAgent);
            this.addToolsToPrompt(tools, allParams);
            AtomicInteger traceNumber = new AtomicInteger(0);
            this.executePlanningLoop(mlAgent.getLlm(), allParams, completedSteps, memory, conversationId, 0, traceNumber, finalListener);
        };
        AgentUtils.getMcpToolSpecs(mlAgent, this.client, this.sdkClient, this.encryptor, (ActionListener<List<MLToolSpec>>)ActionListener.wrap(mcpTools -> {
            toolSpecs.addAll((Collection<MLToolSpec>)mcpTools);
            processTools.accept(toolSpecs);
        }, e -> {
            log.warn("Failed to get MCP tools, continuing with base tools only", (Throwable)e);
            processTools.accept(toolSpecs);
        }));
    }

    private void executePlanningLoop(LLMSpec llm, Map<String, String> allParams, List<String> completedSteps, Memory memory, String conversationId, int stepsExecuted, AtomicInteger traceNumber, ActionListener<Object> finalListener) {
        int maxSteps = Integer.parseInt(allParams.getOrDefault(MAX_STEPS_EXECUTED_FIELD, "20"));
        String parentInteractionId = allParams.get(PARENT_INTERACTION_ID_FIELD);
        if (stepsExecuted >= maxSteps) {
            String finalResult = String.format("Max Steps Limit Reached. Use memory_id with same task to restart. \n Last executed step: %s, \n Last executed step result: %s", completedSteps.get(completedSteps.size() - 2), completedSteps.getLast());
            this.saveAndReturnFinalResult((ConversationIndexMemory)memory, parentInteractionId, finalResult, completedSteps.get(completedSteps.size() - 2), allParams.get(EXECUTOR_AGENT_MEMORY_ID_FIELD), allParams.get(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD), finalListener);
            return;
        }
        MLPredictionTaskRequest request = new MLPredictionTaskRequest(llm.getModelId(), RemoteInferenceMLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)RemoteInferenceInputDataSet.builder().parameters(allParams).build()).build(), null, allParams.get(TENANT_ID_FIELD));
        StepListener planListener = new StepListener();
        planListener.whenComplete(llmOutput -> {
            ModelTensorOutput modelTensorOutput = (ModelTensorOutput)llmOutput.getOutput();
            Map<String, String> parseLLMOutput = this.parseLLMOutput(allParams, modelTensorOutput);
            if (parseLLMOutput.get(RESULT_FIELD) != null) {
                String finalResult = parseLLMOutput.get(RESULT_FIELD);
                this.saveAndReturnFinalResult((ConversationIndexMemory)memory, parentInteractionId, (String)allParams.get(EXECUTOR_AGENT_MEMORY_ID_FIELD), (String)allParams.get(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD), finalResult, null, finalListener);
            } else {
                List<String> steps = Arrays.stream(parseLLMOutput.get(STEPS_FIELD).split(", ")).toList();
                this.addSteps(steps, allParams, STEPS_FIELD);
                String stepToExecute = steps.getFirst();
                String reActAgentId = (String)allParams.get(EXECUTOR_AGENT_ID_FIELD);
                HashMap<String, String> reactParams = new HashMap<String, String>();
                reactParams.put(QUESTION_FIELD, stepToExecute);
                if (allParams.containsKey(EXECUTOR_AGENT_MEMORY_ID_FIELD)) {
                    reactParams.put(MEMORY_ID_FIELD, (String)allParams.get(EXECUTOR_AGENT_MEMORY_ID_FIELD));
                }
                reactParams.put(SYSTEM_PROMPT_FIELD, allParams.getOrDefault(EXECUTOR_SYSTEM_PROMPT_FIELD, DEFAULT_EXECUTOR_SYSTEM_PROMPT));
                reactParams.put("llm_response_filter", (String)allParams.get("llm_response_filter"));
                reactParams.put("max_iteration", allParams.getOrDefault(EXECUTOR_MAX_ITERATIONS_FIELD, "20"));
                AgentMLInput agentInput = AgentMLInput.AgentMLInputBuilder().agentId(reActAgentId).functionName(FunctionName.AGENT).inputDataset((MLInputDataset)RemoteInferenceInputDataSet.builder().parameters(reactParams).build()).build();
                MLExecuteTaskRequest executeRequest = new MLExecuteTaskRequest(FunctionName.AGENT, (Input)agentInput);
                this.client.execute((ActionType)MLExecuteTaskAction.INSTANCE, (ActionRequest)executeRequest, ActionListener.wrap(executeResponse -> {
                    String taskId;
                    String reActParentInteractionId;
                    ModelTensorOutput reactResult = (ModelTensorOutput)executeResponse.getOutput();
                    HashMap results = new HashMap();
                    reactResult.getMlModelOutputs().stream().flatMap(output -> output.getMlModelTensors().stream()).forEach(tensor -> {
                        switch (tensor.getName()) {
                            case "memory_id": {
                                results.put(MEMORY_ID_FIELD, tensor.getResult());
                                break;
                            }
                            case "parent_interaction_id": {
                                results.put(PARENT_INTERACTION_ID_FIELD, tensor.getResult());
                                break;
                            }
                            default: {
                                Map dataMap = tensor.getDataAsMap();
                                if (dataMap == null || !dataMap.containsKey(RESPONSE_FIELD)) break;
                                results.put(STEP_RESULT_FIELD, (String)dataMap.get(RESPONSE_FIELD));
                            }
                        }
                    });
                    if (!results.containsKey(STEP_RESULT_FIELD)) {
                        throw new IllegalStateException("No valid response found in ReAct agent output");
                    }
                    String reActMemoryId = (String)results.get(MEMORY_ID_FIELD);
                    if (reActMemoryId != null && !reActMemoryId.isEmpty()) {
                        allParams.put(EXECUTOR_AGENT_MEMORY_ID_FIELD, reActMemoryId);
                    }
                    if ((reActParentInteractionId = (String)results.get(PARENT_INTERACTION_ID_FIELD)) != null && !reActParentInteractionId.isEmpty()) {
                        allParams.put(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD, reActParentInteractionId);
                    }
                    HashMap memoryUpdates = new HashMap();
                    if (allParams.containsKey(EXECUTOR_AGENT_MEMORY_ID_FIELD)) {
                        memoryUpdates.put(EXECUTOR_AGENT_MEMORY_ID_FIELD, allParams.get(EXECUTOR_AGENT_MEMORY_ID_FIELD));
                    }
                    if (allParams.containsKey(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD)) {
                        memoryUpdates.put(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD, allParams.get(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD));
                    }
                    if ((taskId = (String)allParams.get("task_id")) != null && !this.taskUpdated) {
                        this.taskUpdates.put("state", MLTaskState.RUNNING);
                        this.taskUpdates.put(RESPONSE_FIELD, memoryUpdates);
                        MLTaskUtils.updateMLTaskDirectly((String)taskId, this.taskUpdates, (Client)this.client, (ActionListener)ActionListener.wrap(updateResponse -> {
                            log.info("Updated task {} with executor memory ID", (Object)taskId);
                            this.taskUpdated = true;
                        }, e -> log.error("Failed to update task {} with executor memory ID", (Object)taskId, e)));
                    }
                    completedSteps.add(String.format("\nStep: %s\n", stepToExecute));
                    completedSteps.add(String.format("\nStep Result: %s\n", results.get(STEP_RESULT_FIELD)));
                    MLChatAgentRunner.saveTraceData((ConversationIndexMemory)memory, memory.getType(), stepToExecute, (String)results.get(STEP_RESULT_FIELD), conversationId, false, parentInteractionId, traceNumber, "PlanExecuteReflect Agent");
                    this.addSteps(completedSteps, allParams, COMPLETED_STEPS_FIELD);
                    this.useReflectPromptTemplate(allParams);
                    this.executePlanningLoop(llm, allParams, completedSteps, memory, conversationId, stepsExecuted + 1, traceNumber, finalListener);
                }, e -> {
                    log.error("Failed to execute ReAct agent", (Throwable)e);
                    finalListener.onFailure(e);
                }));
            }
        }, e -> {
            log.error("Failed to run deep research agent", (Throwable)e);
            finalListener.onFailure(e);
        });
        this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)request, (ActionListener)planListener);
    }

    @VisibleForTesting
    Map<String, String> parseLLMOutput(Map<String, String> allParams, ModelTensorOutput modelTensorOutput) {
        String result;
        String llmResponse;
        HashMap<String, String> modelOutput = new HashMap<String, String>();
        Map dataAsMap = ((ModelTensor)((ModelTensors)modelTensorOutput.getMlModelOutputs().getFirst()).getMlModelTensors().getFirst()).getDataAsMap();
        if (dataAsMap.size() == 1 && dataAsMap.containsKey(RESPONSE_FIELD)) {
            llmResponse = ((String)dataAsMap.get(RESPONSE_FIELD)).trim();
        } else {
            if (!allParams.containsKey("llm_response_filter") || allParams.get("llm_response_filter").isEmpty()) {
                throw new IllegalArgumentException("llm_response_filter not found. Please provide the path to the model output.");
            }
            llmResponse = ((String)JsonPath.read((Object)dataAsMap, (String)allParams.get("llm_response_filter"), (Predicate[])new Predicate[0])).trim();
        }
        String json = StringUtils.isJson((String)llmResponse) ? llmResponse : this.extractJsonFromMarkdown(llmResponse);
        Map parsedJson = StringUtils.fromJson((String)json, (String)RESPONSE_FIELD);
        if (!parsedJson.containsKey(STEPS_FIELD) && !parsedJson.containsKey(RESULT_FIELD)) {
            throw new IllegalArgumentException("Missing required fields 'steps' and 'result' in JSON response");
        }
        if (parsedJson.containsKey(STEPS_FIELD)) {
            List steps = (List)parsedJson.get(STEPS_FIELD);
            modelOutput.put(STEPS_FIELD, String.join((CharSequence)", ", steps));
        }
        if (parsedJson.containsKey(RESULT_FIELD) && !(result = (String)parsedJson.get(RESULT_FIELD)).isEmpty()) {
            modelOutput.put(RESULT_FIELD, result);
        }
        return modelOutput;
    }

    @VisibleForTesting
    String extractJsonFromMarkdown(String response) {
        if ((response = response.trim()).contains("```json")) {
            if ((response = response.substring(response.indexOf("```json") + "```json".length())).contains("```")) {
                response = response.substring(0, response.lastIndexOf("```"));
            }
        } else if (response.contains("{") && response.contains("}")) {
            response = response.substring(response.indexOf("{"), response.lastIndexOf("}") + 1);
        }
        if (!StringUtils.isJson((String)(response = response.trim()))) {
            throw new IllegalStateException("Failed to parse LLM output due to invalid JSON");
        }
        return response;
    }

    @VisibleForTesting
    void addToolsToPrompt(Map<String, Tool> tools, Map<String, String> allParams) {
        StringBuilder toolsPrompt = new StringBuilder("In this environment, you have access to the below tools: \n");
        for (Map.Entry<String, Tool> entry : tools.entrySet()) {
            String toolName = entry.getKey();
            String toolDescription = entry.getValue().getDescription();
            toolsPrompt.append("- ").append(toolName).append(": ").append(toolDescription).append("\n").append("\n");
        }
        allParams.put(DEFAULT_PROMPT_TOOLS_FIELD, toolsPrompt.toString());
        this.populatePrompt(allParams);
        AgentUtils.cleanUpResource(tools);
    }

    @VisibleForTesting
    void addSteps(List<String> steps, Map<String, String> allParams, String field) {
        allParams.put(field, String.join((CharSequence)", ", steps));
    }

    @VisibleForTesting
    void saveAndReturnFinalResult(ConversationIndexMemory memory, String parentInteractionId, String reactAgentMemoryId, String reactParentInteractionId, String finalResult, String input, ActionListener<Object> finalListener) {
        HashMap<String, Object> updateContent = new HashMap<String, Object>();
        updateContent.put(RESPONSE_FIELD, finalResult);
        if (input != null) {
            updateContent.put("input", input);
        }
        memory.getMemoryManager().updateInteraction(parentInteractionId, updateContent, (ActionListener<UpdateResponse>)ActionListener.wrap(res -> {
            List<ModelTensors> finalModelTensors = MLPlanExecuteAndReflectAgentRunner.createModelTensors(memory.getConversationId(), parentInteractionId, reactAgentMemoryId, reactParentInteractionId);
            finalModelTensors.add(ModelTensors.builder().mlModelTensors(List.of(ModelTensor.builder().name(RESPONSE_FIELD).dataAsMap(Map.of(RESPONSE_FIELD, finalResult)).build())).build());
            finalListener.onResponse((Object)ModelTensorOutput.builder().mlModelOutputs(finalModelTensors).build());
        }, e -> {
            log.error("Failed to update interaction with final result", (Throwable)e);
            finalListener.onFailure(e);
        }));
    }

    @VisibleForTesting
    static List<ModelTensors> createModelTensors(String sessionId, String parentInteractionId, String reactAgentMemoryId, String reactParentInteractionId) {
        ArrayList<ModelTensors> modelTensors = new ArrayList<ModelTensors>();
        modelTensors.add(ModelTensors.builder().mlModelTensors(List.of(ModelTensor.builder().name(MEMORY_ID_FIELD).result(sessionId).build(), ModelTensor.builder().name(PARENT_INTERACTION_ID_FIELD).result(parentInteractionId).build(), ModelTensor.builder().name(EXECUTOR_AGENT_MEMORY_ID_FIELD).result(reactAgentMemoryId).build(), ModelTensor.builder().name(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD).result(reactParentInteractionId).build())).build());
        return modelTensors;
    }

    @VisibleForTesting
    Map<String, Object> getTaskUpdates() {
        return this.taskUpdates;
    }
}

