/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.input.remote.RemoteInferenceMLInput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.transport.connector.MLExecuteConnectorAction;
import org.opensearch.ml.common.transport.connector.MLExecuteConnectorRequest;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="ConnectorTool")
public class ConnectorTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(ConnectorTool.class);
    public static final String TYPE = "ConnectorTool";
    public static final String CONNECTOR_ID = "connector_id";
    public static final String CONNECTOR_ACTION = "connector_action";
    private String name = "ConnectorTool";
    private Map<String, Object> attributes;
    private String description = "This tool will invoke external service.";
    private String version;
    private Parser inputParser;
    private Parser outputParser;
    private Client client;
    private String connectorId;

    public ConnectorTool(Client client, String connectorId) {
        this.client = client;
        if (connectorId == null) {
            throw new IllegalArgumentException("connector_id can't be null");
        }
        this.connectorId = connectorId;
        this.outputParser = new Parser(this){

            public Object parse(Object o) {
                List mlModelOutputs = (List)o;
                return ((ModelTensor)((ModelTensors)mlModelOutputs.get(0)).getMlModelTensors().get(0)).getDataAsMap().get("response");
            }
        };
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        RemoteInferenceInputDataSet inputDataSet = RemoteInferenceInputDataSet.builder().parameters(parameters).build();
        MLInput mlInput = RemoteInferenceMLInput.builder().algorithm(FunctionName.CONNECTOR).inputDataset((MLInputDataset)inputDataSet).build();
        MLExecuteConnectorRequest request = new MLExecuteConnectorRequest(this.connectorId, mlInput);
        this.client.execute((ActionType)MLExecuteConnectorAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> {
            ModelTensorOutput modelTensorOutput = (ModelTensorOutput)r.getOutput();
            modelTensorOutput.getMlModelOutputs();
            if (this.outputParser == null) {
                listener.onResponse((Object)modelTensorOutput.getMlModelOutputs());
            } else {
                listener.onResponse(this.outputParser.parse((Object)modelTensorOutput.getMlModelOutputs()));
            }
        }, e -> {
            log.error("Failed to run model " + this.connectorId, (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public String getType() {
        return TYPE;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.size() != 0;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setInputParser(Parser inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser outputParser) {
        this.outputParser = outputParser;
    }

    public static class Factory
    implements Tool.Factory<ConnectorTool> {
        public static final String TYPE = "ConnectorTool";
        public static final String DEFAULT_DESCRIPTION = "This tool will invoke external service.";
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<ConnectorTool> clazz = ConnectorTool.class;
            synchronized (ConnectorTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public ConnectorTool create(Map<String, Object> map) {
            return new ConnectorTool(this.client, (String)map.get(ConnectorTool.CONNECTOR_ID));
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return "ConnectorTool";
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

