/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.health.ClusterStateHealth;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.snapshotmanagement.SMRunner;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.SMState;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.SMStateKt;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMMetadata;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.indexmanagement.util.JobSchedulerUtilsKt;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.threadpool.ThreadPool;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J.\u0010\u001f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rJ\u001b\u0010 \u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/SMRunner;", "Lorg/opensearch/jobscheduler/spi/ScheduledJobRunner;", "Lkotlinx/coroutines/CoroutineScope;", "()V", "EXPONENTIAL_BACKOFF_MILLIS", "", "MAX_NUMBER_OF_RETRIES", "", "backoffPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "indicesManager", "Lorg/opensearch/indexmanagement/IndexManagementIndices;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "settings", "Lorg/opensearch/common/settings/Settings;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "getInitialMetadata", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata;", "job", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;", "init", "initMetadata", "(Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runJob", "", "Lorg/opensearch/jobscheduler/spi/ScheduledJobParameter;", "context", "Lorg/opensearch/jobscheduler/spi/JobExecutionContext;", "opensearch-index-management"})
public final class SMRunner
implements ScheduledJobRunner,
CoroutineScope {
    @NotNull
    public static final SMRunner INSTANCE = new SMRunner();
    private final /* synthetic */ CoroutineScope $$delegate_0;
    private static final Logger log = LogManager.getLogger(INSTANCE.getClass());
    private static Client client;
    private static IndexManagementIndices indicesManager;
    private static ClusterService clusterService;
    private static ThreadPool threadPool;
    private static Settings settings;
    private static final int MAX_NUMBER_OF_RETRIES = 3;
    private static final long EXPONENTIAL_BACKOFF_MILLIS = 1000L;
    @NotNull
    private static final BackoffPolicy backoffPolicy;

    private SMRunner() {
        this.$$delegate_0 = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault()).plus((CoroutineContext)new CoroutineName("snapshot_management_runner")));
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    @NotNull
    public final SMRunner init(@NotNull Client client, @NotNull ThreadPool threadPool, @NotNull Settings settings, @NotNull IndexManagementIndices indicesManager, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)indicesManager, (String)"indicesManager");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        SMRunner.client = client;
        SMRunner.threadPool = threadPool;
        SMRunner.settings = settings;
        SMRunner.indicesManager = indicesManager;
        SMRunner.clusterService = clusterService;
        return this;
    }

    public void runJob(@NotNull ScheduledJobParameter job, @NotNull JobExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        log.debug("Snapshot management running job: {}", (Object)job);
        if (!(job instanceof SMPolicy)) {
            throw new IllegalArgumentException("Received invalid job type [" + job.getClass().getSimpleName() + "] with id [" + context.getJobId() + "].");
        }
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(job, context, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            final /* synthetic */ ScheduledJobParameter $job;
            final /* synthetic */ JobExecutionContext $context;
            {
                this.$job = $job;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = JobSchedulerUtilsKt.acquireLockForScheduledJob(this.$job, this.$context, SMRunner.access$getBackoffPolicy$p(), (Continuation<? super LockModel>)((Continuation)this));
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((lock = (LockModel)v0) == null) {
                            SMRunner.access$getLog$p().warn("Cannot acquire lock for snapshot management job " + ((SMPolicy)this.$job).getPolicyName());
                            return Unit.INSTANCE;
                        }
                        v1 = SMRunner.access$getClusterService$p();
                        if (v1 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
                            v1 = null;
                        }
                        if (new ClusterStateHealth(v1.state()).getStatus() == ClusterHealthStatus.RED) {
                            SMRunner.access$getLog$p().warn("Skipping current execution of " + ((SMPolicy)this.$job).getPolicyName() + " because of red cluster health");
                            return Unit.INSTANCE;
                        }
                        var8_7 = metadata = new Ref.ObjectRef();
                        var9_8 = var8_7;
                        v2 = SMRunner.access$getClient$p();
                        if (v2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            v2 = null;
                        }
                        this.L$0 = lock;
                        this.L$1 = metadata;
                        this.L$2 = var8_7;
                        this.L$3 = var9_8;
                        this.label = 2;
                        v3 = SMUtilsKt.getSMMetadata(v2, ((SMPolicy)this.$job).getId(), (Continuation<? super SMMetadata>)((Continuation)this));
                        ** if (v3 != var10_2) goto lbl41
lbl40:
                        // 1 sources

                        return var10_2;
lbl41:
                        // 1 sources

                        ** GOTO lbl52
                    }
                    case 2: {
                        var9_8 = (Ref.ObjectRef)this.L$3;
                        var8_7 = (Ref.ObjectRef)this.L$2;
                        metadata = (Ref.ObjectRef)this.L$1;
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl52:
                        // 2 sources

                        v4 = var9_8;
                        var4_9 = (SMMetadata)v3;
                        break;
                        {
                            catch (Exception var5_11) {
                                SMRunner.access$getLog$p().error("Failed to retrieve metadata before running " + ((SMPolicy)this.$job).getPolicyName(), (Throwable)e);
                                var6_14 = Unit.INSTANCE;
                                this.L$0 = lock;
                                this.L$1 = var6_14;
                                this.L$2 = var8_7;
                                this.L$3 = null;
                                this.label = 3;
                                v5 = JobSchedulerUtilsKt.releaseLockForScheduledJob(this.$context, lock, (Continuation<? super Boolean>)((Continuation)this));
                                if (v5 == var10_2) {
                                    return var10_2;
                                }
                                ** GOTO lbl73
                            }
                        }
                    }
                    case 3: {
                        var8_7 = (Ref.ObjectRef)this.L$2;
                        var6_14 = (Unit)this.L$1;
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl73:
                        // 2 sources

                        v6 = var8_7;
                        if (!((Boolean)v5).booleanValue()) {
                            SMRunner.access$getLog$p().error("Could not release lock [" + lock.getLockId() + "] for " + ((SMPolicy)this.$job).getId() + ".");
                        }
                        return var6_14;
                    }
                }
                try {
                    v4.element = var4_9;
                    if (metadata.element != null) ** GOTO lbl-1000
                    var8_7 = metadata;
                    this.L$0 = lock;
                    this.L$1 = metadata;
                    this.L$2 = var8_7;
                    this.L$3 = null;
                    this.label = 4;
                    v7 = SMRunner.access$initMetadata(SMRunner.INSTANCE, (SMPolicy)this.$job, (Continuation)this);
                    ** if (v7 != var10_2) goto lbl99
                }
                catch (Throwable var3_5) {
                    this.L$0 = lock;
                    this.L$1 = var3_5;
                    this.L$2 = null;
                    this.L$3 = null;
                    this.label = 10;
                    v8 = JobSchedulerUtilsKt.releaseLockForScheduledJob(this.$context, lock, (Continuation<? super Boolean>)((Continuation)this));
                    if (v8 == var10_2) {
                        return var10_2;
                    }
                    ** GOTO lbl212
                }
lbl98:
                // 1 sources

                return var10_2;
lbl99:
                // 1 sources

                ** GOTO lbl108
                {
                    case 4: {
                        var8_7 = (Ref.ObjectRef)this.L$2;
                        metadata = (Ref.ObjectRef)this.L$1;
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = var8_7.element = $result;
lbl108:
                        // 2 sources

                        if ((SMMetadata)metadata.element != null) break;
                        e = Unit.INSTANCE;
                        this.L$0 = lock;
                        this.L$1 = e;
                        this.L$2 = null;
                        this.label = 5;
                        v9 = JobSchedulerUtilsKt.releaseLockForScheduledJob(this.$context, lock, (Continuation<? super Boolean>)((Continuation)this));
                        if (v9 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl123
                    }
                    case 5: {
                        e = (Unit)this.L$1;
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v9 = $result;
lbl123:
                        // 2 sources

                        if (!((Boolean)v9).booleanValue()) {
                            SMRunner.access$getLog$p().error("Could not release lock [" + lock.getLockId() + "] for " + ((SMPolicy)this.$job).getId() + ".");
                        }
                        return e;
                    }
                }
                if ((v10 = SMRunner.access$getClient$p()) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v10 = null;
                }
                v11 = (SMPolicy)this.$job;
                v12 = (SMMetadata)metadata.element;
                v13 = SMRunner.access$getSettings$p();
                if (v13 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    v13 = null;
                }
                if ((v14 = SMRunner.access$getThreadPool$p()) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"threadPool");
                    v14 = null;
                }
                if ((v15 = SMRunner.access$getIndicesManager$p()) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indicesManager");
                    v15 = null;
                }
                this.L$0 = lock;
                this.L$1 = metadata;
                this.L$2 = null;
                this.L$3 = null;
                this.label = 6;
                v16 = new SMStateMachine(v10, v11, v12, v13, v14, v15).handlePolicyChange((Continuation<? super SMStateMachine>)((Continuation)this));
                ** if (v16 != var10_2) goto lbl150
lbl149:
                // 1 sources

                return var10_2;
lbl150:
                // 1 sources

                ** GOTO lbl158
                {
                    case 6: {
                        metadata = (Ref.ObjectRef)this.L$1;
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v16 = $result;
lbl158:
                        // 2 sources

                        this.L$0 = lock;
                        this.L$1 = metadata;
                        this.label = 7;
                        v17 = ((SMStateMachine)v16).currentState(((SMMetadata)metadata.element).getCreation().getCurrentState()).next(SMStateKt.getCreationTransitions(), (Continuation<? super SMStateMachine>)((Continuation)this));
                        ** if (v17 != var10_2) goto lbl164
lbl163:
                        // 1 sources

                        return var10_2;
lbl164:
                        // 1 sources

                        ** GOTO lbl172
                    }
                    case 7: {
                        metadata = (Ref.ObjectRef)this.L$1;
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v17 = $result;
lbl172:
                        // 2 sources

                        var4_9 = v17;
                        $this$invokeSuspend_u24lambda_u240 = (SMStateMachine)var4_9;
                        $i$a$-apply-SMRunner$runJob$1$1 = false;
                        deleteMetadata = ((SMMetadata)metadata.element).getDeletion();
                        if (deleteMetadata == null) ** GOTO lbl193
                        this.L$0 = lock;
                        this.L$1 = var4_9;
                        this.label = 8;
                        v18 = $this$invokeSuspend_u24lambda_u240.currentState(deleteMetadata.getCurrentState()).next(SMStateKt.getDeletionTransitions(), (Continuation<? super SMStateMachine>)this);
                        ** if (v18 != var10_2) goto lbl183
lbl182:
                        // 1 sources

                        return var10_2;
lbl183:
                        // 1 sources

                        ** GOTO lbl193
                    }
                    case 8: {
                        $i$a$-apply-SMRunner$runJob$1$1 = false;
                        var4_10 = this.L$1;
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v18 = $result;
lbl193:
                        // 3 sources

                        this.L$0 = lock;
                        this.L$1 = null;
                        this.label = 9;
                        v19 = JobSchedulerUtilsKt.releaseLockForScheduledJob(this.$context, lock, (Continuation<? super Boolean>)((Continuation)this));
                        if (v19 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl204
                    }
                    case 9: {
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v19 = $result;
lbl204:
                        // 2 sources

                        if (((Boolean)v19).booleanValue()) break;
                        SMRunner.access$getLog$p().error("Could not release lock [" + lock.getLockId() + "] for " + ((SMPolicy)this.$job).getId() + ".");
                        break;
                    }
                    case 10: {
                        var3_6 = (Throwable)this.L$1;
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v8 = $result;
lbl212:
                        // 2 sources

                        if (!((Boolean)v8).booleanValue()) {
                            SMRunner.access$getLog$p().error("Could not release lock [" + lock.getLockId() + "] for " + ((SMPolicy)this.$job).getId() + ".");
                        }
                        throw var3_6;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object initMetadata(SMPolicy var1_1, Continuation<? super SMMetadata> var2_2) {
        if (!(var2_2 instanceof initMetadata.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SMRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SMRunner.access$initMetadata(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                initMetadata = this.getInitialMetadata((SMPolicy)job);
                SMRunner.log.info("Initializing metadata [" + initMetadata + "] for [" + job.getPolicyName() + "].");
                v0 = SMRunner.client;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    v0 = null;
                }
                var5_7 = v0;
                var6_8 = job.getId();
                $continuation.L$0 = initMetadata;
                $continuation.label = 1;
                v1 = SMUtilsKt.indexMetadata(var5_7, initMetadata, var6_8, -2L, 0L, true, (Continuation<? super IndexResponse>)$continuation);
                ** if (v1 != var9_5) goto lbl27
lbl26:
                // 1 sources

                return var9_5;
lbl27:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                initMetadata = (SMMetadata)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl34:
                    // 2 sources

                    if ((res = (IndexResponse)v1).status() != RestStatus.CREATED) {
                        SMRunner.log.error("Metadata initialization response status is " + res.status() + ", expecting CREATED 201.");
                        return null;
                    }
                }
                catch (Exception e) {
                    SMRunner.log.error("Caught exception while initializing SM metadata.", (Throwable)e);
                    return null;
                }
                return initMetadata;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final SMMetadata getInitialMetadata(SMPolicy job) {
        SMMetadata.WorkflowMetadata workflowMetadata;
        Instant now = Instant.now();
        String string = SMUtilsKt.smPolicyNameToMetadataDocId(SMUtilsKt.smDocIdToPolicyName(job.getId()));
        long l = job.getSeqNo();
        long l2 = job.getPrimaryTerm();
        Instant instant = job.getCreation().getSchedule().getNextExecutionTime(now);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"job.creation.schedule.getNextExecutionTime(now)");
        SMMetadata.WorkflowMetadata workflowMetadata2 = new SMMetadata.WorkflowMetadata(SMState.CREATION_START, new SMMetadata.Trigger(instant), null, null, null, 28, null);
        SMPolicy.Deletion deletion = job.getDeletion();
        if (deletion != null) {
            SMPolicy.Deletion it = deletion;
            boolean bl = false;
            Instant instant2 = job.getDeletion().getSchedule().getNextExecutionTime(now);
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"job.deletion.schedule.getNextExecutionTime(now)");
            workflowMetadata = new SMMetadata.WorkflowMetadata(SMState.DELETION_START, new SMMetadata.Trigger(instant2), null, null, null, 28, null);
        } else {
            workflowMetadata = null;
        }
        SMMetadata.WorkflowMetadata workflowMetadata3 = workflowMetadata;
        return new SMMetadata(l, l2, workflowMetadata2, workflowMetadata3, string, 0L, 0L, 96, null);
    }

    public static final /* synthetic */ BackoffPolicy access$getBackoffPolicy$p() {
        return backoffPolicy;
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ ClusterService access$getClusterService$p() {
        return clusterService;
    }

    public static final /* synthetic */ Client access$getClient$p() {
        return client;
    }

    public static final /* synthetic */ Object access$initMetadata(SMRunner $this, SMPolicy job, Continuation $completion) {
        return $this.initMetadata(job, (Continuation<? super SMMetadata>)$completion);
    }

    public static final /* synthetic */ Settings access$getSettings$p() {
        return settings;
    }

    public static final /* synthetic */ ThreadPool access$getThreadPool$p() {
        return threadPool;
    }

    public static final /* synthetic */ IndexManagementIndices access$getIndicesManager$p() {
        return indicesManager;
    }

    static {
        BackoffPolicy backoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3);
        Intrinsics.checkNotNullExpressionValue((Object)backoffPolicy, (String)"exponentialBackoff(\n    \u2026X_NUMBER_OF_RETRIES\n    )");
        SMRunner.backoffPolicy = backoffPolicy;
    }
}

