"use strict";

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts'
  },
  testEnvironment: 'jest-environment-jsdom',
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['**/*.ts', '**/*.tsx', '**/*.js', '**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.js', '!<rootDir>/public/app.js', '!<rootDir>/index.js', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!**/vendor/**'],
  clearMocks: true,
  modulePathIgnorePatterns: ['<rootDir>/offline-module-cache/'],
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  transformIgnorePatterns: ['<rootDir>/node_modules'],
  globalSetup: '<rootDir>/global-setup.js',

  /**
   * This configuration specifies different file extensions 
   * and the corresponding transformers to be used
   */
  transform: {
    '\\.[jt]sx?$': 'babel-jest',
    '^.+\\.svg$': '<rootDir>/test/mocks/transformMock.ts',
    '^.+\\.html$': '<rootDir>/test/mocks/transformMock.ts'
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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