/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.AliasesRequest;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.close.CloseIndexClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.close.CloseIndexRequest;
import org.opensearch.action.admin.indices.close.CloseIndexResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.open.OpenIndexClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.open.OpenIndexRequest;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.ack.OpenIndexClusterStateUpdateResponse;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.AliasAction;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataIndexAliasesService;
import org.opensearch.cluster.metadata.MetadataIndexStateService;
import org.opensearch.cluster.metadata.MetadataMappingService;
import org.opensearch.cluster.metadata.MetadataUpdateSettingsService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.Index;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.replication.metadata.TransportUpdateMetadataAction;
import org.opensearch.replication.metadata.UpdateMetadataRequest;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.rest.action.admin.indices.AliasesNotFoundException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 G2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001GBO\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0014J,\u0010$\u001a\u00020%2\b\u0010!\u001a\u0004\u0018\u00010\u00022\b\u0010\"\u001a\u0004\u0018\u00010#2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010'H\u0014J.\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0014J+\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020,H\u0002\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020,H\u0014JA\u00104\u001a\u00020%2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060+2\u0006\u0010!\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00107\u001a\u00020#H\u0002\u00a2\u0006\u0002\u00108J9\u00109\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060+2\u0006\u0010!\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0002\u00a2\u0006\u0002\u0010:J9\u0010;\u001a\u00020%2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060+2\u0006\u0010!\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010<J1\u0010=\u001a\u00020%2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060+2\u0006\u0010!\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0002\u00a2\u0006\u0002\u0010>J9\u0010?\u001a\u00020%2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060+2\u0006\u0010!\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010@J\u0012\u0010A\u001a\u00020\u00032\b\u0010B\u001a\u0004\u0018\u00010CH\u0014J-\u0010D\u001a\b\u0012\u0004\u0012\u0002060+2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010E\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010FR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006H"}, d2={"Lorg/opensearch/replication/metadata/TransportUpdateMetadataAction;", "Lorg/opensearch/action/support/clustermanager/TransportClusterManagerNodeAction;", "Lorg/opensearch/replication/metadata/UpdateMetadataRequest;", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "metadataMappingService", "Lorg/opensearch/cluster/metadata/MetadataMappingService;", "updateSettingsService", "Lorg/opensearch/cluster/metadata/MetadataUpdateSettingsService;", "indexAliasService", "Lorg/opensearch/cluster/metadata/MetadataIndexAliasesService;", "indexStateService", "Lorg/opensearch/cluster/metadata/MetadataIndexStateService;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;Lorg/opensearch/cluster/metadata/MetadataMappingService;Lorg/opensearch/cluster/metadata/MetadataUpdateSettingsService;Lorg/opensearch/cluster/metadata/MetadataIndexAliasesService;Lorg/opensearch/cluster/metadata/MetadataIndexStateService;)V", "getIndexAliasService", "()Lorg/opensearch/cluster/metadata/MetadataIndexAliasesService;", "getIndexStateService", "()Lorg/opensearch/cluster/metadata/MetadataIndexStateService;", "getMetadataMappingService", "()Lorg/opensearch/cluster/metadata/MetadataMappingService;", "getUpdateSettingsService", "()Lorg/opensearch/cluster/metadata/MetadataUpdateSettingsService;", "checkBlock", "Lorg/opensearch/cluster/block/ClusterBlockException;", "request", "state", "Lorg/opensearch/cluster/ClusterState;", "clusterManagerOperation", "", "listener", "Lorg/opensearch/core/action/ActionListener;", "task", "Lorg/opensearch/tasks/Task;", "concreteAliases", "", "", "action", "Lorg/opensearch/action/admin/indices/alias/IndicesAliasesRequest$AliasActions;", "metadata", "Lorg/opensearch/cluster/metadata/Metadata;", "concreteIndex", "(Lorg/opensearch/action/admin/indices/alias/IndicesAliasesRequest$AliasActions;Lorg/opensearch/cluster/metadata/Metadata;Ljava/lang/String;)[Ljava/lang/String;", "executor", "performAliasUpdate", "concreteIndices", "Lorg/opensearch/core/index/Index;", "clusterState", "([Lorg/opensearch/core/index/Index;Lorg/opensearch/replication/metadata/UpdateMetadataRequest;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/cluster/metadata/MetadataIndexAliasesService;Lorg/opensearch/cluster/ClusterState;)V", "performCloseIndex", "(Lorg/opensearch/tasks/Task;[Lorg/opensearch/core/index/Index;Lorg/opensearch/replication/metadata/UpdateMetadataRequest;Lorg/opensearch/core/action/ActionListener;)V", "performMappingUpdate", "([Lorg/opensearch/core/index/Index;Lorg/opensearch/replication/metadata/UpdateMetadataRequest;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/cluster/metadata/MetadataMappingService;)V", "performOpenIndex", "([Lorg/opensearch/core/index/Index;Lorg/opensearch/replication/metadata/UpdateMetadataRequest;Lorg/opensearch/core/action/ActionListener;)V", "performSettingUpdate", "([Lorg/opensearch/core/index/Index;Lorg/opensearch/replication/metadata/UpdateMetadataRequest;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/cluster/metadata/MetadataUpdateSettingsService;)V", "read", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "resolveIndices", "iner", "(Lorg/opensearch/cluster/ClusterState;Lorg/opensearch/replication/metadata/UpdateMetadataRequest;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;)[Lorg/opensearch/core/index/Index;", "Companion", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nTransportUpdateMetadataAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportUpdateMetadataAction.kt\norg/opensearch/replication/metadata/TransportUpdateMetadataAction\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,294:1\n37#2,2:295\n37#2,2:297\n*S KotlinDebug\n*F\n+ 1 TransportUpdateMetadataAction.kt\norg/opensearch/replication/metadata/TransportUpdateMetadataAction\n*L\n184#1:295,2\n282#1:297,2\n*E\n"})
public final class TransportUpdateMetadataAction
extends TransportClusterManagerNodeAction<UpdateMetadataRequest, AcknowledgedResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetadataMappingService metadataMappingService;
    @NotNull
    private final MetadataUpdateSettingsService updateSettingsService;
    @NotNull
    private final MetadataIndexAliasesService indexAliasService;
    @NotNull
    private final MetadataIndexStateService indexStateService;
    private static final Logger log = LogManager.getLogger(TransportUpdateMetadataAction.class);
    private static final IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)false, (boolean)true, (boolean)true);

    @Inject
    public TransportUpdateMetadataAction(@NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull ThreadPool threadPool, @NotNull ClusterService clusterService, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull MetadataMappingService metadataMappingService, @NotNull MetadataUpdateSettingsService updateSettingsService, @NotNull MetadataIndexAliasesService indexAliasService, @NotNull MetadataIndexStateService indexStateService) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)metadataMappingService, (String)"metadataMappingService");
        Intrinsics.checkNotNullParameter((Object)updateSettingsService, (String)"updateSettingsService");
        Intrinsics.checkNotNullParameter((Object)indexAliasService, (String)"indexAliasService");
        Intrinsics.checkNotNullParameter((Object)indexStateService, (String)"indexStateService");
        super("indices:admin/plugins/replication/index/update_metadata", transportService, clusterService, threadPool, actionFilters, UpdateMetadataRequest::new, indexNameExpressionResolver);
        this.metadataMappingService = metadataMappingService;
        this.updateSettingsService = updateSettingsService;
        this.indexAliasService = indexAliasService;
        this.indexStateService = indexStateService;
    }

    @NotNull
    public final MetadataMappingService getMetadataMappingService() {
        return this.metadataMappingService;
    }

    @NotNull
    public final MetadataUpdateSettingsService getUpdateSettingsService() {
        return this.updateSettingsService;
    }

    @NotNull
    public final MetadataIndexAliasesService getIndexAliasService() {
        return this.indexAliasService;
    }

    @NotNull
    public final MetadataIndexStateService getIndexStateService() {
        return this.indexStateService;
    }

    @NotNull
    protected String executor() {
        return "same";
    }

    @NotNull
    protected AcknowledgedResponse read(@Nullable StreamInput inp) {
        return new AcknowledgedResponse(inp);
    }

    @Nullable
    protected ClusterBlockException checkBlock(@NotNull UpdateMetadataRequest request, @NotNull ClusterState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void clusterManagerOperation(@NotNull Task task, @NotNull UpdateMetadataRequest request, @NotNull ClusterState state, @NotNull ActionListener<AcknowledgedResponse> listener2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        IndexNameExpressionResolver indexNameExpressionResolver = this.indexNameExpressionResolver;
        Intrinsics.checkNotNullExpressionValue((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Index[] concreteIndices = this.resolveIndices(state, request, indexNameExpressionResolver);
        switch (WhenMappings.$EnumSwitchMapping$0[request.getType().ordinal()]) {
            case 1: {
                this.performSettingUpdate(concreteIndices, request, listener2, this.updateSettingsService);
                break;
            }
            case 2: {
                this.performMappingUpdate(concreteIndices, request, listener2, this.metadataMappingService);
                break;
            }
            case 3: {
                this.performAliasUpdate(concreteIndices, request, listener2, this.indexAliasService, state);
                break;
            }
            case 4: {
                this.performOpenIndex(concreteIndices, request, listener2);
                break;
            }
            case 5: {
                this.performCloseIndex(task, concreteIndices, request, listener2);
            }
        }
    }

    private final void performOpenIndex(Index[] concreteIndices, UpdateMetadataRequest request, ActionListener<AcknowledgedResponse> listener2) {
        AcknowledgedRequest<?> acknowledgedRequest = request.getRequest();
        Intrinsics.checkNotNull(acknowledgedRequest, (String)"null cannot be cast to non-null type org.opensearch.action.admin.indices.open.OpenIndexRequest");
        OpenIndexRequest openIndexRequest = (OpenIndexRequest)acknowledgedRequest;
        OpenIndexClusterStateUpdateRequest updateRequest = ((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)new OpenIndexClusterStateUpdateRequest().ackTimeout(openIndexRequest.timeout())).masterNodeTimeout(openIndexRequest.masterNodeTimeout())).indices(concreteIndices)).waitForActiveShards(openIndexRequest.waitForActiveShards());
        this.indexStateService.openIndex(updateRequest, (ActionListener)new ActionListener<OpenIndexClusterStateUpdateResponse>(listener2, concreteIndices){
            final /* synthetic */ ActionListener<AcknowledgedResponse> $listener;
            final /* synthetic */ Index[] $concreteIndices;
            {
                this.$listener = $listener;
                this.$concreteIndices = $concreteIndices;
            }

            public void onResponse(@NotNull OpenIndexClusterStateUpdateResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$listener.onResponse((Object)new AcknowledgedResponse(response2.isAcknowledged()));
            }

            public void onFailure(@NotNull Exception t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                TransportUpdateMetadataAction.access$getLog$cp().error(() -> performOpenIndex.1.onFailure$lambda$0(this.$concreteIndices), (Throwable)t);
                this.$listener.onFailure(t);
            }

            private static final Message onFailure$lambda$0(Index[] $concreteIndices) {
                Intrinsics.checkNotNullParameter((Object)$concreteIndices, (String)"$concreteIndices");
                return (Message)new ParameterizedMessage("failed to open indices [{}]", (Object)$concreteIndices);
            }
        });
    }

    private final void performCloseIndex(Task task, Index[] concreteIndices, UpdateMetadataRequest request, ActionListener<AcknowledgedResponse> listener2) {
        AcknowledgedRequest<?> acknowledgedRequest = request.getRequest();
        Intrinsics.checkNotNull(acknowledgedRequest, (String)"null cannot be cast to non-null type org.opensearch.action.admin.indices.close.CloseIndexRequest");
        CloseIndexRequest openIndexRequest = (CloseIndexRequest)acknowledgedRequest;
        CloseIndexClusterStateUpdateRequest closeRequest = (CloseIndexClusterStateUpdateRequest)((CloseIndexClusterStateUpdateRequest)((CloseIndexClusterStateUpdateRequest)new CloseIndexClusterStateUpdateRequest(task.getId()).ackTimeout(openIndexRequest.timeout())).masterNodeTimeout(openIndexRequest.masterNodeTimeout())).waitForActiveShards(openIndexRequest.waitForActiveShards()).indices(concreteIndices);
        this.indexStateService.closeIndices(closeRequest, (ActionListener)new ActionListener<CloseIndexResponse>(listener2, concreteIndices){
            final /* synthetic */ ActionListener<AcknowledgedResponse> $listener;
            final /* synthetic */ Index[] $concreteIndices;
            {
                this.$listener = $listener;
                this.$concreteIndices = $concreteIndices;
            }

            public void onResponse(@NotNull CloseIndexResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$listener.onResponse((Object)new AcknowledgedResponse(response2.isAcknowledged()));
            }

            public void onFailure(@NotNull Exception t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                TransportUpdateMetadataAction.access$getLog$cp().error(() -> performCloseIndex.1.onFailure$lambda$0(this.$concreteIndices), (Throwable)t);
                this.$listener.onFailure(t);
            }

            private static final Message onFailure$lambda$0(Index[] $concreteIndices) {
                Intrinsics.checkNotNullParameter((Object)$concreteIndices, (String)"$concreteIndices");
                return (Message)new ParameterizedMessage("failed to close indices [{}]", (Object)$concreteIndices);
            }
        });
    }

    private final void performAliasUpdate(Index[] concreteIndices, UpdateMetadataRequest request, ActionListener<AcknowledgedResponse> listener2, MetadataIndexAliasesService indexAliasService, ClusterState clusterState) {
        AcknowledgedRequest<?> acknowledgedRequest = request.getRequest();
        Intrinsics.checkNotNull(acknowledgedRequest, (String)"null cannot be cast to non-null type org.opensearch.action.admin.indices.alias.IndicesAliasesRequest");
        IndicesAliasesRequest indicesAliasesRequest = (IndicesAliasesRequest)acknowledgedRequest;
        List list = indicesAliasesRequest.getAliasActions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"indicesAliasesRequest.aliasActions");
        List actions = list;
        ArrayList<Object> finalActions = new ArrayList<Object>();
        HashSet aliases = new HashSet();
        for (IndicesAliasesRequest.AliasActions action : actions) {
            for (Index concreteIndex : concreteIndices) {
                IndexAbstraction indexAbstraction;
                if ((IndexAbstraction)clusterState.metadata().getIndicesLookup().get(concreteIndex.getName()) == null) {
                    throw new IllegalStateException(("invalid cluster metadata. index [" + concreteIndex.getName() + "] was not found").toString());
                }
                if (indexAbstraction.getParentDataStream() == null) continue;
                boolean bl = false;
                String[] stringArray = action.indices();
                IndexAbstraction.DataStream dataStream = indexAbstraction.getParentDataStream();
                String string = "The provided expressions [" + String.join((CharSequence)",", Arrays.copyOf(stringArray, stringArray.length)) + "] match a backing index belonging to data stream [" + (dataStream != null ? dataStream.getName() : null) + "]. Data streams and their backing indices don't support aliases.";
                throw new IllegalArgumentException(string.toString());
            }
            String[] stringArray = action.getOriginalAliases();
            Collections.addAll(aliases, Arrays.copyOf(stringArray, stringArray.length));
            int n = concreteIndices.length;
            block7: for (int i = 0; i < n; ++i) {
                Index index = concreteIndices[i];
                IndicesAliasesRequest.AliasActions.Type type = action.actionType();
                switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                    case 1: {
                        Metadata metadata = clusterState.metadata();
                        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"clusterState.metadata()");
                        String string = index.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"index.name");
                        for (String alias : this.concreteAliases(action, metadata, string)) {
                            finalActions.add(new AliasAction.Add(index.getName(), alias, action.filter(), action.indexRouting(), action.searchRouting(), action.writeIndex(), action.isHidden()));
                        }
                        continue block7;
                    }
                    case 2: {
                        Metadata metadata = clusterState.metadata();
                        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"clusterState.metadata()");
                        String string = index.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"index.name");
                        for (String alias : this.concreteAliases(action, metadata, string)) {
                            finalActions.add(new AliasAction.Remove(index.getName(), alias, action.mustExist()));
                        }
                        continue block7;
                    }
                    case 3: {
                        finalActions.add(new AliasAction.RemoveIndex(index.getName()));
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported action [" + action.actionType() + ']');
                    }
                }
            }
        }
        if (finalActions.isEmpty() && !actions.isEmpty()) {
            Collection $this$toTypedArray$iv = aliases;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            throw new AliasesNotFoundException(Arrays.copyOf(stringArray, stringArray.length));
        }
        IndicesAliasesClusterStateUpdateRequest updateRequest = (IndicesAliasesClusterStateUpdateRequest)((IndicesAliasesClusterStateUpdateRequest)new IndicesAliasesClusterStateUpdateRequest(Collections.unmodifiableList((List)finalActions)).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
        indexAliasService.indicesAliases(updateRequest, (ActionListener)new ActionListener<ClusterStateUpdateResponse>(listener2, request){
            final /* synthetic */ ActionListener<AcknowledgedResponse> $listener;
            final /* synthetic */ UpdateMetadataRequest $request;
            {
                this.$listener = $listener;
                this.$request = $request;
            }

            public void onResponse(@NotNull ClusterStateUpdateResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$listener.onResponse((Object)new AcknowledgedResponse(response2.isAcknowledged()));
            }

            public void onFailure(@NotNull Exception t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                TransportUpdateMetadataAction.access$getLog$cp().error("failed to perform aliases on index " + this.$request.getIndexName(), (Throwable)t);
                this.$listener.onFailure(t);
            }
        });
    }

    private final void performSettingUpdate(Index[] concreteIndices, UpdateMetadataRequest request, ActionListener<AcknowledgedResponse> listener2, MetadataUpdateSettingsService updateSettingsService) {
        AcknowledgedRequest<?> acknowledgedRequest = request.getRequest();
        Intrinsics.checkNotNull(acknowledgedRequest, (String)"null cannot be cast to non-null type org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest");
        UpdateSettingsRequest updateSettingsRequest = (UpdateSettingsRequest)acknowledgedRequest;
        UpdateSettingsClusterStateUpdateRequest clusterStateUpdateRequest = (UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)new UpdateSettingsClusterStateUpdateRequest().indices(concreteIndices)).settings(updateSettingsRequest.settings()).setPreserveExisting(updateSettingsRequest.isPreserveExisting()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
        updateSettingsService.updateSettings(clusterStateUpdateRequest, (ActionListener)new ActionListener<ClusterStateUpdateResponse>(listener2, request){
            final /* synthetic */ ActionListener<AcknowledgedResponse> $listener;
            final /* synthetic */ UpdateMetadataRequest $request;
            {
                this.$listener = $listener;
                this.$request = $request;
            }

            public void onResponse(@NotNull ClusterStateUpdateResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$listener.onResponse((Object)new AcknowledgedResponse(response2.isAcknowledged()));
            }

            public void onFailure(@NotNull Exception t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                TransportUpdateMetadataAction.access$getLog$cp().error("failed to update settings on index " + this.$request.getIndexName(), (Throwable)t);
                this.$listener.onFailure(t);
            }
        });
    }

    private final Index[] resolveIndices(ClusterState state, UpdateMetadataRequest request, IndexNameExpressionResolver iner) {
        try {
            Index[] indexArray = iner.concreteIndices(state, new IndicesRequest(request){
                final /* synthetic */ UpdateMetadataRequest $request;
                {
                    this.$request = $request;
                }

                @NotNull
                public String[] indices() {
                    String[] stringArray = new String[]{this.$request.getIndexName()};
                    return stringArray;
                }

                @NotNull
                public IndicesOptions indicesOptions() {
                    IndicesOptions indicesOptions = TransportUpdateMetadataAction.access$getIndicesOptions$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)indicesOptions, (String)"indicesOptions");
                    return indicesOptions;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)indexArray, (String)"request: UpdateMetadataR\u2026         }\n            })");
            return indexArray;
        }
        catch (IndexNotFoundException ex) {
            log.error("Failed to execute UpdateMetadataRequest. Index " + request.getIndexName() + " not found. type: " + (Object)((Object)request.getType()) + ": " + ExtensionsKt.stackTraceToString(ex));
            throw ex;
        }
    }

    private final void performMappingUpdate(Index[] concreteIndices, UpdateMetadataRequest request, ActionListener<AcknowledgedResponse> listener2, MetadataMappingService metadataMappingService) {
        AcknowledgedRequest<?> acknowledgedRequest = request.getRequest();
        Intrinsics.checkNotNull(acknowledgedRequest, (String)"null cannot be cast to non-null type org.opensearch.action.admin.indices.mapping.put.PutMappingRequest");
        PutMappingRequest mappingRequest = (PutMappingRequest)acknowledgedRequest;
        PutMappingClusterStateUpdateRequest updateRequest = (PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)new PutMappingClusterStateUpdateRequest(mappingRequest.source()).ackTimeout(mappingRequest.timeout())).masterNodeTimeout(mappingRequest.masterNodeTimeout())).indices(concreteIndices);
        metadataMappingService.putMapping(updateRequest, (ActionListener)new ActionListener<ClusterStateUpdateResponse>(listener2, request){
            final /* synthetic */ ActionListener<AcknowledgedResponse> $listener;
            final /* synthetic */ UpdateMetadataRequest $request;
            {
                this.$listener = $listener;
                this.$request = $request;
            }

            public void onResponse(@NotNull ClusterStateUpdateResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$listener.onResponse((Object)new AcknowledgedResponse(response2.isAcknowledged()));
            }

            public void onFailure(@NotNull Exception ex) {
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                TransportUpdateMetadataAction.access$getLog$cp().error("failed to put mappings on indices " + this.$request.getIndexName() + " : " + ExtensionsKt.stackTraceToString(ex));
                this.$listener.onFailure(ex);
            }
        });
    }

    private final String[] concreteAliases(IndicesAliasesRequest.AliasActions action, Metadata metadata, String concreteIndex) {
        String[] stringArray;
        if (action.expandAliasesWildcards()) {
            String[] stringArray2 = new String[]{concreteIndex};
            String[] indexAsArray = stringArray2;
            Map aliasMetadata = metadata.findAliases((AliasesRequest)action, indexAsArray);
            List finalAliases = new ArrayList();
            for (List curAliases : aliasMetadata.values()) {
                for (AliasMetadata aliasMeta : curAliases) {
                    String string = aliasMeta.alias();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aliasMeta.alias()");
                    finalAliases.add(string);
                }
            }
            Collection $this$toTypedArray$iv = finalAliases;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            String[] stringArray3 = action.aliases();
            stringArray = stringArray3;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"{\n            //for ADD \u2026ction.aliases()\n        }");
        }
        return stringArray;
    }

    protected void clusterManagerOperation(@Nullable UpdateMetadataRequest request, @Nullable ClusterState state, @Nullable ActionListener<AcknowledgedResponse> listener2) {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ IndicesOptions access$getIndicesOptions$cp() {
        return indicesOptions;
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/opensearch/replication/metadata/TransportUpdateMetadataAction$Companion;", "", "()V", "indicesOptions", "Lorg/opensearch/action/support/IndicesOptions;", "kotlin.jvm.PlatformType", "log", "Lorg/apache/logging/log4j/Logger;", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UpdateMetadataRequest.Type.values().length];
            try {
                nArray[UpdateMetadataRequest.Type.SETTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateMetadataRequest.Type.MAPPING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateMetadataRequest.Type.ALIAS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateMetadataRequest.Type.OPEN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateMetadataRequest.Type.CLOSE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IndicesAliasesRequest.AliasActions.Type.values().length];
            try {
                nArray[IndicesAliasesRequest.AliasActions.Type.ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndicesAliasesRequest.AliasActions.Type.REMOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndicesAliasesRequest.AliasActions.Type.REMOVE_INDEX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

