/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.rest.BaseRestHandler;

public abstract class AbstractAnomalyDetectorAction
extends BaseRestHandler {
    protected volatile TimeValue requestTimeout;
    protected volatile TimeValue detectionInterval;
    protected volatile TimeValue detectionWindowDelay;
    protected volatile Integer maxSingleEntityDetectors;
    protected volatile Integer maxMultiEntityDetectors;
    protected volatile Integer maxAnomalyFeatures;

    public AbstractAnomalyDetectorAction(Settings settings, ClusterService clusterService) {
        this.requestTimeout = (TimeValue)AnomalyDetectorSettings.REQUEST_TIMEOUT.get(settings);
        this.detectionInterval = (TimeValue)AnomalyDetectorSettings.DETECTION_INTERVAL.get(settings);
        this.detectionWindowDelay = (TimeValue)AnomalyDetectorSettings.DETECTION_WINDOW_DELAY.get(settings);
        this.maxSingleEntityDetectors = (Integer)AnomalyDetectorSettings.MAX_SINGLE_ENTITY_ANOMALY_DETECTORS.get(settings);
        this.maxMultiEntityDetectors = (Integer)AnomalyDetectorSettings.MAX_MULTI_ENTITY_ANOMALY_DETECTORS.get(settings);
        this.maxAnomalyFeatures = (Integer)AnomalyDetectorSettings.MAX_ANOMALY_FEATURES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.REQUEST_TIMEOUT, it -> {
            this.requestTimeout = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.DETECTION_INTERVAL, it -> {
            this.detectionInterval = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.DETECTION_WINDOW_DELAY, it -> {
            this.detectionWindowDelay = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_SINGLE_ENTITY_ANOMALY_DETECTORS, it -> {
            this.maxSingleEntityDetectors = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_MULTI_ENTITY_ANOMALY_DETECTORS, it -> {
            this.maxMultiEntityDetectors = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_ANOMALY_FEATURES, it -> {
            this.maxAnomalyFeatures = it;
        });
    }
}

