/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.slice;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.opensearch.common.util.BitMixer;
import org.opensearch.search.slice.SliceQuery;

public final class DocValuesSliceQuery
extends SliceQuery {
    public DocValuesSliceQuery(String field, int id, int max) {
        super(field, id, max);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)DocValuesSliceQuery.this.getField());
                DocIdSetIterator approximation = DocIdSetIterator.all((int)context.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    public boolean matches() throws IOException {
                        if (values.advanceExact(this.approximation.docID())) {
                            for (int i = 0; i < values.docValueCount(); ++i) {
                                if (!DocValuesSliceQuery.this.contains(BitMixer.mix((long)values.nextValue()))) continue;
                                return true;
                            }
                            return false;
                        }
                        return DocValuesSliceQuery.this.contains(0L);
                    }

                    public float matchCost() {
                        return 10.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{DocValuesSliceQuery.this.getField()});
            }
        };
    }
}

