/*
 * Decompiled with CFR 0.152.
 */
package j2html.rendering;

import j2html.Config;
import j2html.rendering.HtmlBuilder;
import j2html.rendering.TagBuilder;
import j2html.utils.Indenter;
import j2html.utils.TextEscaper;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;

public class IndentedHtml<T extends Appendable>
implements HtmlBuilder<T> {
    private final T out;
    private final Indenter indenter;
    private final TextEscaper textEscaper;
    private final TagBuilder enclosingElementAttributes;
    private final TagBuilder emptyElementAttributes;
    private final Deque<String> trace = new ArrayDeque<String>();

    public static final <T extends Appendable> IndentedHtml<T> into(T out) {
        return new IndentedHtml<T>(out, Config.defaults());
    }

    public static final <T extends Appendable> IndentedHtml<T> into(T out, Config config) {
        return new IndentedHtml<T>(out, config);
    }

    public static final IndentedHtml<StringBuilder> inMemory() {
        return IndentedHtml.into(new StringBuilder());
    }

    public static final IndentedHtml<StringBuilder> inMemory(Config config) {
        return IndentedHtml.into(new StringBuilder(), config);
    }

    private IndentedHtml(T out, Config config) {
        this.out = out;
        this.indenter = config.indenter();
        this.textEscaper = config.textEscaper();
        this.enclosingElementAttributes = new IndentedTagBuilder(false);
        this.emptyElementAttributes = new IndentedTagBuilder(config.closeEmptyTags());
    }

    private boolean isContentSelfFormatting() {
        return this.trace.contains("pre") || this.trace.contains("textarea");
    }

    private int lvl() {
        return this.trace.size();
    }

    @Override
    public TagBuilder appendStartTag(String name) throws IOException {
        if (!this.isContentSelfFormatting()) {
            this.out.append(this.indenter.indent(this.lvl(), ""));
        }
        this.trace.push(name);
        this.out.append("<").append(name);
        return this.enclosingElementAttributes;
    }

    @Override
    public HtmlBuilder<T> appendEndTag(String name) throws IOException {
        if (!name.equals(this.trace.peek())) {
            throw new RuntimeException("Incorrect element closed: " + name + ".  Expected: " + this.trace.peek());
        }
        if (!this.isContentSelfFormatting()) {
            this.trace.pop();
            this.out.append(this.indenter.indent(this.lvl(), ""));
        } else {
            this.trace.pop();
        }
        this.out.append("</").append(name).append(">");
        if (!this.isContentSelfFormatting()) {
            this.out.append("\n");
        }
        return this;
    }

    @Override
    public TagBuilder appendEmptyTag(String name) throws IOException {
        if (!this.isContentSelfFormatting()) {
            this.out.append(this.indenter.indent(this.lvl(), ""));
        }
        this.out.append("<").append(name);
        return this.emptyElementAttributes;
    }

    private void appendLines(String txt) throws IOException {
        if (!this.isContentSelfFormatting()) {
            String[] lines;
            for (String line : lines = txt.split("\n")) {
                this.out.append(this.indenter.indent(this.lvl(), line)).append("\n");
            }
        } else {
            this.out.append(txt);
        }
    }

    @Override
    public HtmlBuilder<T> appendEscapedText(String txt) throws IOException {
        this.appendLines(this.textEscaper.escape(txt));
        return this;
    }

    @Override
    public HtmlBuilder<T> appendUnescapedText(String txt) throws IOException {
        this.appendLines(txt);
        return this;
    }

    @Override
    public T output() {
        return this.out;
    }

    @Override
    @Deprecated
    public HtmlBuilder<T> append(CharSequence csq) throws IOException {
        this.out.append(csq);
        return this;
    }

    @Override
    @Deprecated
    public HtmlBuilder<T> append(CharSequence csq, int start, int end) throws IOException {
        this.out.append(csq, start, end);
        return this;
    }

    @Override
    @Deprecated
    public HtmlBuilder<T> append(char c) throws IOException {
        this.out.append(c);
        return this;
    }

    private class IndentedTagBuilder
    implements TagBuilder {
        private final boolean closeTag;

        private IndentedTagBuilder(boolean closeTag) {
            this.closeTag = closeTag;
        }

        @Override
        public TagBuilder appendAttribute(String name, String value) throws IOException {
            IndentedHtml.this.out.append(" ").append(name).append("=\"").append(IndentedHtml.this.textEscaper.escape(value)).append("\"");
            return this;
        }

        @Override
        public TagBuilder appendBooleanAttribute(String name) throws IOException {
            IndentedHtml.this.out.append(" ").append(name);
            return this;
        }

        public HtmlBuilder<T> completeTag() throws IOException {
            if (this.closeTag) {
                IndentedHtml.this.out.append("/");
            }
            IndentedHtml.this.out.append(">");
            if (!IndentedHtml.this.isContentSelfFormatting()) {
                IndentedHtml.this.out.append("\n");
            }
            return IndentedHtml.this;
        }

        @Override
        @Deprecated
        public TagBuilder append(CharSequence csq) throws IOException {
            IndentedHtml.this.out.append(csq);
            return this;
        }

        @Override
        @Deprecated
        public TagBuilder append(CharSequence csq, int start, int end) throws IOException {
            IndentedHtml.this.out.append(csq, start, end);
            return this;
        }

        @Override
        @Deprecated
        public TagBuilder append(char c) throws IOException {
            IndentedHtml.this.out.append(c);
            return this;
        }
    }
}

