/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import com.formdev.flatlaf.util.ScaledImageIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import mediathek.config.Daten;
import mediathek.daten.Country;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.gui.messages.GeoStateChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MessageBus;
import mediathek.tool.SVGIconUtilities;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;

public class PanelEinstellungenGeo
extends JPanel {
    private final JFrame parentComponent;
    private static final Dimension FLAG_DIMENSIONS = new Dimension(32, 24);
    private JRadioButton jRadioButtonDe;
    private JLabel lblIcon_DE;
    private JRadioButton jRadioButtonAt;
    private JLabel lblIcon_AT;
    private JRadioButton jRadioButtonCH;
    private JLabel lblIcon_CH;
    private JRadioButton radioButtonFR;
    private JLabel lblIcon_FR;
    private JRadioButton jRadioButtonEu;
    private JLabel lblIcon_EU;
    private JRadioButton jRadioButtonSonst;
    private JButton jButtonHilfe;

    public PanelEinstellungenGeo(JFrame pparentComponent) {
        this.parentComponent = pparentComponent;
        this.initComponents();
        this.setCountryFlags();
        this.init();
    }

    private void setCountryFlags() {
        this.lblIcon_DE.setIcon(this.getScaledIconResource("/icons/countries/162-germany.png"));
        this.lblIcon_AT.setIcon(this.getScaledIconResource("/icons/countries/003-austria.png"));
        this.lblIcon_CH.setIcon(this.getScaledIconResource("/icons/countries/205-switzerland.png"));
        this.lblIcon_FR.setIcon(this.getScaledIconResource("/icons/countries/195-france.png"));
        this.lblIcon_EU.setIcon(this.getScaledIconResource("/icons/countries/259-european-union.png"));
    }

    private ScaledImageIcon getScaledIconResource(@NotNull String url) {
        ImageIcon icon = new ImageIcon(Objects.requireNonNull(this.getClass().getResource(url)));
        Dimension imageDim = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        Dimension destDim = GuiFunktionen.calculateFittedDimension(imageDim, FLAG_DIMENSIONS);
        return new ScaledImageIcon(icon, destDim.width, destDim.height);
    }

    private void init() {
        switch (ApplicationConfiguration.getInstance().getGeographicLocation()) {
            case CH: {
                this.jRadioButtonCH.setSelected(true);
                break;
            }
            case AT: {
                this.jRadioButtonAt.setSelected(true);
                break;
            }
            case EU: {
                this.jRadioButtonEu.setSelected(true);
                break;
            }
            case FR: {
                this.radioButtonFR.setSelected(true);
                break;
            }
            case OTHER: {
                this.jRadioButtonSonst.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonDe.setSelected(true);
            }
        }
        this.jRadioButtonDe.addActionListener(e -> {
            ApplicationConfiguration.getInstance().setGeographicLocation(Country.DE);
            this.filterBlacklistAndNotifyChanges();
        });
        this.radioButtonFR.addActionListener(e -> {
            ApplicationConfiguration.getInstance().setGeographicLocation(Country.FR);
            this.filterBlacklistAndNotifyChanges();
        });
        this.jRadioButtonCH.addActionListener(e -> {
            ApplicationConfiguration.getInstance().setGeographicLocation(Country.CH);
            this.filterBlacklistAndNotifyChanges();
        });
        this.jRadioButtonAt.addActionListener(e -> {
            ApplicationConfiguration.getInstance().setGeographicLocation(Country.AT);
            this.filterBlacklistAndNotifyChanges();
        });
        this.jRadioButtonEu.addActionListener(e -> {
            ApplicationConfiguration.getInstance().setGeographicLocation(Country.EU);
            this.filterBlacklistAndNotifyChanges();
        });
        this.jRadioButtonSonst.addActionListener(e -> {
            ApplicationConfiguration.getInstance().setGeographicLocation(Country.OTHER);
            this.filterBlacklistAndNotifyChanges();
        });
        this.jButtonHilfe.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
        this.jButtonHilfe.addActionListener(e -> new DialogHilfe(this.parentComponent, true, new GetFile().getHilfeSuchen("/mediathek/file/hilfetext_geo.txt")).setVisible(true));
    }

    private void filterBlacklistAndNotifyChanges() {
        Daten daten = Daten.getInstance();
        daten.getListeBlacklist().filterListe();
        MessageBus.getMessageBus().publishAsync(new GeoStateChangedEvent());
        MessageBus.getMessageBus().publishAsync(new BlacklistChangedEvent());
    }

    private void initComponents() {
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        this.jRadioButtonDe = new JRadioButton();
        this.lblIcon_DE = new JLabel();
        JLabel label2 = new JLabel();
        JPanel panel3 = new JPanel();
        this.jRadioButtonAt = new JRadioButton();
        this.lblIcon_AT = new JLabel();
        JLabel label4 = new JLabel();
        JPanel panel4 = new JPanel();
        this.jRadioButtonCH = new JRadioButton();
        this.lblIcon_CH = new JLabel();
        JLabel label6 = new JLabel();
        JPanel panel5 = new JPanel();
        this.radioButtonFR = new JRadioButton();
        this.lblIcon_FR = new JLabel();
        JLabel label8 = new JLabel();
        JPanel panel6 = new JPanel();
        this.jRadioButtonEu = new JRadioButton();
        this.lblIcon_EU = new JLabel();
        JLabel label10 = new JLabel();
        this.jRadioButtonSonst = new JRadioButton();
        this.jButtonHilfe = new JButton();
        this.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().grow().fill(), new AC().gap().fill()));
        panel1.setBorder(new TitledBorder("Mein Standort"));
        panel1.setLayout(new VerticalLayout());
        panel2.setLayout(new MigLayout(new LC().insets("0").hideMode(3), new AC().grow().align("left"), new AC().fill()));
        this.jRadioButtonDe.setSelected(true);
        panel2.add((Component)this.jRadioButtonDe, new CC().cell(0, 0));
        panel2.add((Component)this.lblIcon_DE, new CC().cell(0, 0));
        label2.setText("Deutschland (DE)");
        panel2.add((Component)label2, new CC().cell(0, 0));
        panel1.add(panel2);
        panel3.setLayout(new MigLayout(new LC().insets("0").hideMode(3), new AC().grow().align("left"), new AC().fill()));
        panel3.add((Component)this.jRadioButtonAt, new CC().cell(0, 0));
        panel3.add((Component)this.lblIcon_AT, new CC().cell(0, 0));
        label4.setText("\u00d6sterreich (AT)");
        panel3.add((Component)label4, new CC().cell(0, 0));
        panel1.add(panel3);
        panel4.setLayout(new MigLayout(new LC().insets("0").hideMode(3), new AC().grow().align("left"), new AC().fill()));
        panel4.add((Component)this.jRadioButtonCH, new CC().cell(0, 0));
        panel4.add((Component)this.lblIcon_CH, new CC().cell(0, 0));
        label6.setText("Schweiz (CH)");
        panel4.add((Component)label6, new CC().cell(0, 0));
        panel1.add(panel4);
        panel5.setLayout(new MigLayout(new LC().insets("0").hideMode(3), new AC().grow().align("left"), new AC().fill()));
        panel5.add((Component)this.radioButtonFR, new CC().cell(0, 0));
        panel5.add((Component)this.lblIcon_FR, new CC().cell(0, 0));
        label8.setText("Frankreich (FR)");
        panel5.add((Component)label8, new CC().cell(0, 0));
        panel1.add(panel5);
        panel6.setLayout(new MigLayout(new LC().insets("0").hideMode(3), new AC().grow().align("left"), new AC().fill()));
        panel6.add((Component)this.jRadioButtonEu, new CC().cell(0, 0));
        panel6.add((Component)this.lblIcon_EU, new CC().cell(0, 0));
        label10.setText("EU (EBU - European Broadcasting Union)");
        panel6.add((Component)label10, new CC().cell(0, 0));
        panel1.add(panel6);
        this.jRadioButtonSonst.setText("Sonstiger");
        panel1.add(this.jRadioButtonSonst);
        this.add((Component)panel1, new CC().cell(0, 0));
        this.jButtonHilfe.setIcon(null);
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        this.add((Component)this.jButtonHilfe, new CC().cell(0, 1).alignX("right").growX(0.0f));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonDe);
        buttonGroup1.add(this.jRadioButtonAt);
        buttonGroup1.add(this.jRadioButtonCH);
        buttonGroup1.add(this.radioButtonFR);
        buttonGroup1.add(this.jRadioButtonEu);
        buttonGroup1.add(this.jRadioButtonSonst);
    }
}

