/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Insets;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.gui.PanelVorlage;
import mediathek.gui.messages.ReplaceListChangedEvent;
import mediathek.tool.MessageBus;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.ReplaceList;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.TextCopyPasteHandler;
import mediathek.tool.models.NonEditableTableModel;
import net.engio.mbassy.listener.Handler;

public class PanelDateinamen
extends PanelVorlage {
    public boolean ok;
    private JCheckBox jCheckBoxTable;
    private JButton jButtonReset;
    private JTable tabelle;
    private JLabel jLabelAlert;
    private JLabel jLabelVon;
    private JTextField jTextFieldVon;
    private JLabel jLabelNach;
    private JTextField jTextFieldNach;
    private JButton jButtonMinus;
    private JButton jButtonPlus;
    private JButton jButtonDown;
    private JButton jButtonUp;
    private JCheckBox jCheckBoxAscii;

    @Handler
    private void handleReplaceListChange(ReplaceListChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.tabelleLaden();
            this.setTextfelder();
        });
    }

    public PanelDateinamen(Daten d, JFrame pparentComponent) {
        super(d, pparentComponent);
        this.initComponents();
        MessageBus.getMessageBus().subscribe(this);
        this.jLabelAlert.setVisible(false);
        this.jLabelAlert.setText("");
        this.jLabelAlert.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/triangle-exclamation.svg", 32.0f));
        this.jButtonPlus.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/plus.svg"));
        this.jButtonMinus.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/minus.svg"));
        this.jButtonUp.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/arrow-up.svg"));
        this.jButtonDown.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/arrow-down.svg"));
        this.jButtonReset.addActionListener(e -> {
            ReplaceList.init();
            this.tabelleLaden();
            this.setTextfelder();
        });
        this.jButtonPlus.addActionListener(e -> {
            ReplaceList.list.add(new String[]{"von", "nach"});
            this.tabelleLaden();
            this.tabelle.setRowSelectionInterval(this.tabelle.getRowCount() - 1, this.tabelle.getRowCount() - 1);
            this.setTextfelder();
        });
        this.jButtonMinus.addActionListener(e -> {
            int selectedTableRow = this.tabelle.getSelectedRow();
            if (selectedTableRow != -1) {
                ReplaceList.list.remove(selectedTableRow);
                this.tabelleLaden();
                this.setTextfelder();
            }
        });
        this.jButtonUp.addActionListener(e -> this.upDown(true));
        this.jButtonDown.addActionListener(e -> this.upDown(false));
        this.tabelleLaden();
        this.setTextfelder();
        this.tabelle.getSelectionModel().addListSelectionListener(new BeobachterTableSelect());
        this.jTextFieldVon.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelDateinamen.this.setVon();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelDateinamen.this.setVon();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelDateinamen.this.setVon();
            }
        });
        this.jTextFieldNach.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelDateinamen.this.setNach();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelDateinamen.this.setNach();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelDateinamen.this.setNach();
            }
        });
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldNach);
        this.jTextFieldNach.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldVon);
        this.jTextFieldVon.setComponentPopupMenu(handler.getPopupMenu());
        this.jCheckBoxTable.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_USE_REPLACETABLE, Boolean.toString(this.jCheckBoxTable.isSelected())));
        this.jCheckBoxTable.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_REPLACETABLE)));
        this.jCheckBoxAscii.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_ONLY_ASCII, Boolean.toString(this.jCheckBoxAscii.isSelected())));
        this.jCheckBoxAscii.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ONLY_ASCII)));
    }

    private void setVon() {
        int selectedTableRow;
        if (!this.stopBeob && (selectedTableRow = this.tabelle.getSelectedRow()) != -1) {
            ReplaceList.list.get((int)this.tabelle.convertRowIndexToModel((int)selectedTableRow))[0] = this.jTextFieldVon.getText();
            this.tabelleLaden();
        }
    }

    private void setNach() {
        int selectedTableRow;
        if (!this.stopBeob && (selectedTableRow = this.tabelle.getSelectedRow()) != -1) {
            ReplaceList.list.get((int)this.tabelle.convertRowIndexToModel((int)selectedTableRow))[1] = this.jTextFieldNach.getText();
            this.tabelleLaden();
        }
    }

    private void upDown(boolean auf) {
        int rows = this.tabelle.getSelectedRow();
        if (rows != -1) {
            int row = this.tabelle.convertRowIndexToModel(rows);
            int neu = ReplaceList.up(row, auf);
            this.tabelleLaden();
            this.tabelle.setRowSelectionInterval(neu, neu);
            this.tabelle.scrollRectToVisible(this.tabelle.getCellRect(neu, 0, true));
        } else {
            NoSelectionErrorDialog.show(this);
        }
    }

    private void tabelleLaden() {
        this.stopBeob = true;
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow != -1) {
            selectedTableRow = this.tabelle.convertRowIndexToModel(selectedTableRow);
        }
        NonEditableTableModel model = new NonEditableTableModel(new Object[0][], ReplaceList.COLUMN_NAMES);
        model.setRowCount(0);
        Object[] object = new Object[2];
        for (String[] s2 : ReplaceList.list) {
            object[0] = s2[0];
            object[1] = s2[1];
            model.addRow(object);
        }
        this.tabelle.setModel(model);
        if (selectedTableRow != -1) {
            if (this.tabelle.getRowCount() > 0 && selectedTableRow < this.tabelle.getRowCount()) {
                this.tabelle.setRowSelectionInterval(selectedTableRow, selectedTableRow);
            } else if (this.tabelle.getRowCount() > 0 && selectedTableRow > 0) {
                this.tabelle.setRowSelectionInterval(this.tabelle.getRowCount() - 1, this.tabelle.getRowCount() - 1);
            } else if (this.tabelle.getRowCount() > 0) {
                this.tabelle.setRowSelectionInterval(0, 0);
            }
        } else if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
        this.jLabelAlert.setVisible(ReplaceList.check());
        this.stopBeob = false;
    }

    private void setTextfelder() {
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow != -1) {
            this.jTextFieldVon.setText(this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(selectedTableRow), 0).toString());
            this.jTextFieldNach.setText(this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(selectedTableRow), 1).toString());
        } else {
            this.jTextFieldVon.setText("");
            this.jTextFieldNach.setText("");
        }
        this.jTextFieldNach.setEnabled(selectedTableRow >= 0);
        this.jTextFieldVon.setEnabled(selectedTableRow >= 0);
        this.jButtonUp.setEnabled(selectedTableRow >= 0);
        this.jButtonDown.setEnabled(selectedTableRow >= 0);
        this.jLabelNach.setEnabled(selectedTableRow >= 0);
        this.jLabelVon.setEnabled(selectedTableRow >= 0);
    }

    private void initComponents() {
        JTabbedPane jTabbedPane1 = new JTabbedPane();
        JPanel jPanel1 = new JPanel();
        JScrollPane jScrollPane5 = new JScrollPane();
        JTextArea jTextArea3 = new JTextArea();
        JPanel jPanel2 = new JPanel();
        this.jCheckBoxTable = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        this.jButtonReset = new JButton();
        JScrollPane jScrollPane3 = new JScrollPane();
        JTextArea jTextArea2 = new JTextArea();
        JScrollPane jScrollPane4 = new JScrollPane();
        this.tabelle = new JTable();
        this.jLabelAlert = new JLabel();
        this.jLabelVon = new JLabel();
        this.jTextFieldVon = new JTextField();
        this.jLabelNach = new JLabel();
        this.jTextFieldNach = new JTextField();
        this.jButtonMinus = new JButton();
        this.jButtonPlus = new JButton();
        this.jButtonDown = new JButton();
        this.jButtonUp = new JButton();
        this.jCheckBoxAscii = new JCheckBox();
        jTextArea3.setEditable(false);
        jTextArea3.setColumns(20);
        jTextArea3.setRows(5);
        jTextArea3.setText("\nDie Dateinamen werden f\u00fcr jedes Betriebssystem passend aufbereitet.\n\nWer will, kann dar\u00fcber hinaus weitere Einstellungen mit einer Ersetzungstabelle\nvornehmen: z.B. \"\u00df\" durch \"ss\" ersetzen.\n");
        jTextArea3.setMargin(new Insets(3, 3, 3, 3));
        jScrollPane5.setViewportView(jTextArea3);
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane5, -1, 773, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane5, -2, 119, -2).addContainerGap(459, Short.MAX_VALUE)));
        jTabbedPane1.addTab("Dateinamen", jPanel1);
        this.jCheckBoxTable.setText("Ersetzungstabelle anwenden");
        jPanel3.setBorder(new EtchedBorder());
        this.jButtonReset.setText("Tabelle zur\u00fccksetzen");
        jScrollPane3.setBorder(new EmptyBorder(1, 1, 1, 1));
        jTextArea2.setEditable(false);
        jTextArea2.setBackground(UIManager.getColor("Label.background"));
        jTextArea2.setColumns(20);
        jTextArea2.setRows(4);
        jTextArea2.setText("Die Tabelle wird von oben nach unten abgearbeitet.\nEs ist also m\u00f6glich, dass eine Ersetzung durch eine weitere\nwieder ersetzt wird!");
        jTextArea2.setBorder(new EmptyBorder(1, 1, 1, 1));
        jScrollPane3.setViewportView(jTextArea2);
        this.tabelle.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        jScrollPane4.setViewportView(this.tabelle);
        this.jLabelAlert.setText("Achtung");
        this.jLabelVon.setText("von:");
        this.jLabelNach.setText("nach:");
        this.jButtonMinus.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-remove.png")));
        this.jButtonPlus.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-add.png")));
        this.jButtonDown.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-move-down.png")));
        this.jButtonUp.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-move-up.png")));
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup().addComponent(jScrollPane4).addGroup(jPanel3Layout.createSequentialGroup().addComponent(jScrollPane3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelAlert)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jButtonReset).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabelVon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldVon, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelNach).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNach, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 111, Short.MAX_VALUE).addComponent(this.jButtonUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPlus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMinus))).addGap(15, 15, 15)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane4, -1, 328, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelVon).addComponent(this.jTextFieldVon, -2, -1, -2).addComponent(this.jLabelNach).addComponent(this.jTextFieldNach, -2, -1, -2).addComponent(this.jButtonUp).addComponent(this.jButtonDown).addComponent(this.jButtonPlus).addComponent(this.jButtonMinus)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jScrollPane3, -2, -1, -2).addComponent(this.jLabelAlert)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReset).addContainerGap()));
        jPanel3Layout.linkSize(1, this.jButtonDown, this.jButtonMinus, this.jButtonPlus, this.jButtonUp, this.jLabelNach, this.jLabelVon, this.jTextFieldNach, this.jTextFieldVon);
        this.jCheckBoxAscii.setText("Nur ASCII-Zeichen erlauben");
        this.jCheckBoxAscii.setToolTipText("<html>Es werden alle Zeichen \"\u00fcber 127\" ersetzt.  Auch Umlaute wie \"\u00f6 -> oe\" werden ersetzt.<br>Wenn die Ersetzungstabelle aktiv ist, wird sie vorher abgearbeitet.</html>");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup().addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup().addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(jPanel3, -1, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup().addComponent(this.jCheckBoxAscii).addComponent(this.jCheckBoxTable)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup().addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxTable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel3, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jCheckBoxAscii).addContainerGap()));
        jTabbedPane1.addTab("Eigene Einstellungen", jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(jTabbedPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jTabbedPane1).addContainerGap()));
    }

    private class BeobachterTableSelect
    implements ListSelectionListener {
        private BeobachterTableSelect() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!PanelDateinamen.this.stopBeob && !event.getValueIsAdjusting()) {
                PanelDateinamen.this.stopBeob = true;
                PanelDateinamen.this.setTextfelder();
                PanelDateinamen.this.stopBeob = false;
            }
        }
    }
}

