/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.runtime.util.IconHelper;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.jetbrains.annotations.Nullable;

public class ButtonWrapper {
    private JButton button;
    private AbstractFormComponent formComponent;
    private ActionListener actionListener;

    public ButtonWrapper(AbstractFormComponent formComponent) {
        this.formComponent = formComponent;
    }

    public JButton getButton() {
        return this.button;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void initialize(String buttonText) {
        this.initialize(buttonText, null);
    }

    public void initialize(String buttonText, @Nullable String buttonName) {
        this.button.setText(this.formComponent.replaceFormVariables(buttonText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
        if (buttonText != null && buttonName != null) {
            this.button.setName(buttonName);
        }
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        if (this.button != null && formEnvironment != null) {
            this.button.setName(formEnvironment.getId(this.formComponent));
        }
    }

    public JButton createCenterComponent(Context context, ExternalFile buttonIconFile, ActionListener actionListener) {
        this.actionListener = actionListener;
        this.button = new JButton();
        if (buttonIconFile != null) {
            IconHelper.withIcon(buttonIconFile, context, icon -> {
                this.button.setIcon(icon);
                return null;
            });
        }
        this.button.addActionListener(actionListener);
        return this.button;
    }
}

